<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:xmi="http://www.omg.org/spec/XMI/20131001"
                xmlns:xgen="http://www.xoev.de/de/xgenerator/framework/1/library"
                xmlns:uml="http://www.eclipse.org/uml2/5.0.0/UML"
                xmlns:xd="http://www.oxygenxml.com/ns/doc/xsl"
                version="2.0">
   <xd:doc>
      <xd:desc>Type check function for UML metaclass ActivityContent.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is ActivityContent.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-ActivityContent" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:ActivityContent'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass ActivityContent.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is ActivityContent or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-ActivityContent" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:ActivityContent' or $element/@xmi:type = 'uml:ActivityGroup' or $element/@xmi:type = 'uml:StructuredActivityNode' or $element/@xmi:type = 'uml:ConditionalNode' or $element/@xmi:type = 'uml:ExpansionRegion' or $element/@xmi:type = 'uml:LoopNode' or $element/@xmi:type = 'uml:SequenceNode' or $element/@xmi:type = 'uml:ActivityPartition' or $element/@xmi:type = 'uml:InterruptibleActivityRegion' or $element/@xmi:type = 'uml:ActivityNode' or $element/@xmi:type = 'uml:ControlNode' or $element/@xmi:type = 'uml:DecisionNode' or $element/@xmi:type = 'uml:FinalNode' or $element/@xmi:type = 'uml:ActivityFinalNode' or $element/@xmi:type = 'uml:FlowFinalNode' or $element/@xmi:type = 'uml:ForkNode' or $element/@xmi:type = 'uml:InitialNode' or $element/@xmi:type = 'uml:JoinNode' or $element/@xmi:type = 'uml:MergeNode' or $element/@xmi:type = 'uml:ExecutableNode' or $element/@xmi:type = 'uml:Action' or $element/@xmi:type = 'uml:ValueSpecificationAction' or $element/@xmi:type = 'uml:VariableAction' or $element/@xmi:type = 'uml:WriteVariableAction' or $element/@xmi:type = 'uml:AddVariableValueAction' or $element/@xmi:type = 'uml:RemoveVariableValueAction' or $element/@xmi:type = 'uml:ClearVariableAction' or $element/@xmi:type = 'uml:ReadVariableAction' or $element/@xmi:type = 'uml:AcceptEventAction' or $element/@xmi:type = 'uml:AcceptCallAction' or $element/@xmi:type = 'uml:ClearAssociationAction' or $element/@xmi:type = 'uml:CreateObjectAction' or $element/@xmi:type = 'uml:DestroyObjectAction' or $element/@xmi:type = 'uml:InvocationAction' or $element/@xmi:type = 'uml:BroadcastSignalAction' or $element/@xmi:type = 'uml:CallAction' or $element/@xmi:type = 'uml:CallBehaviorAction' or $element/@xmi:type = 'uml:CallOperationAction' or $element/@xmi:type = 'uml:StartObjectBehaviorAction' or $element/@xmi:type = 'uml:SendObjectAction' or $element/@xmi:type = 'uml:SendSignalAction' or $element/@xmi:type = 'uml:LinkAction' or $element/@xmi:type = 'uml:WriteLinkAction' or $element/@xmi:type = 'uml:CreateLinkAction' or $element/@xmi:type = 'uml:CreateLinkObjectAction' or $element/@xmi:type = 'uml:DestroyLinkAction' or $element/@xmi:type = 'uml:ReadLinkAction' or $element/@xmi:type = 'uml:OpaqueAction' or $element/@xmi:type = 'uml:RaiseExceptionAction' or $element/@xmi:type = 'uml:ReadExtentAction' or $element/@xmi:type = 'uml:ReadIsClassifiedObjectAction' or $element/@xmi:type = 'uml:ReadLinkObjectEndAction' or $element/@xmi:type = 'uml:ReadLinkObjectEndQualifierAction' or $element/@xmi:type = 'uml:ReadSelfAction' or $element/@xmi:type = 'uml:ReclassifyObjectAction' or $element/@xmi:type = 'uml:ReduceAction' or $element/@xmi:type = 'uml:ReplyAction' or $element/@xmi:type = 'uml:StartClassifierBehaviorAction' or $element/@xmi:type = 'uml:StructuralFeatureAction' or $element/@xmi:type = 'uml:WriteStructuralFeatureAction' or $element/@xmi:type = 'uml:AddStructuralFeatureValueAction' or $element/@xmi:type = 'uml:RemoveStructuralFeatureValueAction' or $element/@xmi:type = 'uml:ClearStructuralFeatureAction' or $element/@xmi:type = 'uml:ReadStructuralFeatureAction' or $element/@xmi:type = 'uml:StructuredActivityNode' or $element/@xmi:type = 'uml:ConditionalNode' or $element/@xmi:type = 'uml:ExpansionRegion' or $element/@xmi:type = 'uml:LoopNode' or $element/@xmi:type = 'uml:SequenceNode' or $element/@xmi:type = 'uml:TestIdentityAction' or $element/@xmi:type = 'uml:UnmarshallAction' or $element/@xmi:type = 'uml:ObjectNode' or $element/@xmi:type = 'uml:ExpansionNode' or $element/@xmi:type = 'uml:Pin' or $element/@xmi:type = 'uml:InputPin' or $element/@xmi:type = 'uml:ActionInputPin' or $element/@xmi:type = 'uml:ValuePin' or $element/@xmi:type = 'uml:OutputPin' or $element/@xmi:type = 'uml:ActivityParameterNode' or $element/@xmi:type = 'uml:CentralBufferNode' or $element/@xmi:type = 'uml:DataStoreNode'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass ValueSpecificationAction.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is ValueSpecificationAction.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-ValueSpecificationAction" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:ValueSpecificationAction'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass ValueSpecificationAction.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is ValueSpecificationAction or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-ValueSpecificationAction" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:ValueSpecificationAction'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass VariableAction.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is VariableAction.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-VariableAction" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:VariableAction'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass VariableAction.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is VariableAction or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-VariableAction" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:VariableAction' or $element/@xmi:type = 'uml:WriteVariableAction' or $element/@xmi:type = 'uml:AddVariableValueAction' or $element/@xmi:type = 'uml:RemoveVariableValueAction' or $element/@xmi:type = 'uml:ClearVariableAction' or $element/@xmi:type = 'uml:ReadVariableAction'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass WriteLinkAction.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is WriteLinkAction.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-WriteLinkAction" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:WriteLinkAction'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass WriteLinkAction.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is WriteLinkAction or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-WriteLinkAction" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:WriteLinkAction' or $element/@xmi:type = 'uml:CreateLinkAction' or $element/@xmi:type = 'uml:CreateLinkObjectAction' or $element/@xmi:type = 'uml:DestroyLinkAction'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass WriteStructuralFeatureAction.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is WriteStructuralFeatureAction.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-WriteStructuralFeatureAction" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:WriteStructuralFeatureAction'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass WriteStructuralFeatureAction.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is WriteStructuralFeatureAction or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-WriteStructuralFeatureAction" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:WriteStructuralFeatureAction' or $element/@xmi:type = 'uml:AddStructuralFeatureValueAction' or $element/@xmi:type = 'uml:RemoveStructuralFeatureValueAction'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass WriteVariableAction.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is WriteVariableAction.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-WriteVariableAction" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:WriteVariableAction'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass WriteVariableAction.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is WriteVariableAction or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-WriteVariableAction" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:WriteVariableAction' or $element/@xmi:type = 'uml:AddVariableValueAction' or $element/@xmi:type = 'uml:RemoveVariableValueAction'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass AcceptCallAction.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is AcceptCallAction.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-AcceptCallAction" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:AcceptCallAction'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass AcceptCallAction.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is AcceptCallAction or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-AcceptCallAction" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:AcceptCallAction'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass AcceptEventAction.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is AcceptEventAction.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-AcceptEventAction" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:AcceptEventAction'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass AcceptEventAction.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is AcceptEventAction or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-AcceptEventAction" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:AcceptEventAction' or $element/@xmi:type = 'uml:AcceptCallAction'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass Action.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is Action.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-Action" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:Action'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass Action.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is Action or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-Action" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:Action' or $element/@xmi:type = 'uml:ValueSpecificationAction' or $element/@xmi:type = 'uml:VariableAction' or $element/@xmi:type = 'uml:WriteVariableAction' or $element/@xmi:type = 'uml:AddVariableValueAction' or $element/@xmi:type = 'uml:RemoveVariableValueAction' or $element/@xmi:type = 'uml:ClearVariableAction' or $element/@xmi:type = 'uml:ReadVariableAction' or $element/@xmi:type = 'uml:AcceptEventAction' or $element/@xmi:type = 'uml:AcceptCallAction' or $element/@xmi:type = 'uml:ClearAssociationAction' or $element/@xmi:type = 'uml:CreateObjectAction' or $element/@xmi:type = 'uml:DestroyObjectAction' or $element/@xmi:type = 'uml:InvocationAction' or $element/@xmi:type = 'uml:BroadcastSignalAction' or $element/@xmi:type = 'uml:CallAction' or $element/@xmi:type = 'uml:CallBehaviorAction' or $element/@xmi:type = 'uml:CallOperationAction' or $element/@xmi:type = 'uml:StartObjectBehaviorAction' or $element/@xmi:type = 'uml:SendObjectAction' or $element/@xmi:type = 'uml:SendSignalAction' or $element/@xmi:type = 'uml:LinkAction' or $element/@xmi:type = 'uml:WriteLinkAction' or $element/@xmi:type = 'uml:CreateLinkAction' or $element/@xmi:type = 'uml:CreateLinkObjectAction' or $element/@xmi:type = 'uml:DestroyLinkAction' or $element/@xmi:type = 'uml:ReadLinkAction' or $element/@xmi:type = 'uml:OpaqueAction' or $element/@xmi:type = 'uml:RaiseExceptionAction' or $element/@xmi:type = 'uml:ReadExtentAction' or $element/@xmi:type = 'uml:ReadIsClassifiedObjectAction' or $element/@xmi:type = 'uml:ReadLinkObjectEndAction' or $element/@xmi:type = 'uml:ReadLinkObjectEndQualifierAction' or $element/@xmi:type = 'uml:ReadSelfAction' or $element/@xmi:type = 'uml:ReclassifyObjectAction' or $element/@xmi:type = 'uml:ReduceAction' or $element/@xmi:type = 'uml:ReplyAction' or $element/@xmi:type = 'uml:StartClassifierBehaviorAction' or $element/@xmi:type = 'uml:StructuralFeatureAction' or $element/@xmi:type = 'uml:WriteStructuralFeatureAction' or $element/@xmi:type = 'uml:AddStructuralFeatureValueAction' or $element/@xmi:type = 'uml:RemoveStructuralFeatureValueAction' or $element/@xmi:type = 'uml:ClearStructuralFeatureAction' or $element/@xmi:type = 'uml:ReadStructuralFeatureAction' or $element/@xmi:type = 'uml:StructuredActivityNode' or $element/@xmi:type = 'uml:ConditionalNode' or $element/@xmi:type = 'uml:ExpansionRegion' or $element/@xmi:type = 'uml:LoopNode' or $element/@xmi:type = 'uml:SequenceNode' or $element/@xmi:type = 'uml:TestIdentityAction' or $element/@xmi:type = 'uml:UnmarshallAction'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass ActionInputPin.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is ActionInputPin.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-ActionInputPin" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:ActionInputPin'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass ActionInputPin.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is ActionInputPin or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-ActionInputPin" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:ActionInputPin'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass AddStructuralFeatureValueAction.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is AddStructuralFeatureValueAction.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-AddStructuralFeatureValueAction" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:AddStructuralFeatureValueAction'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass AddStructuralFeatureValueAction.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is AddStructuralFeatureValueAction or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-AddStructuralFeatureValueAction" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:AddStructuralFeatureValueAction'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass AddVariableValueAction.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is AddVariableValueAction.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-AddVariableValueAction" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:AddVariableValueAction'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass AddVariableValueAction.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is AddVariableValueAction or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-AddVariableValueAction" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:AddVariableValueAction'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass BroadcastSignalAction.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is BroadcastSignalAction.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-BroadcastSignalAction" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:BroadcastSignalAction'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass BroadcastSignalAction.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is BroadcastSignalAction or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-BroadcastSignalAction" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:BroadcastSignalAction'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass CallAction.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is CallAction.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-CallAction" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:CallAction'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass CallAction.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is CallAction or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-CallAction" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:CallAction' or $element/@xmi:type = 'uml:CallBehaviorAction' or $element/@xmi:type = 'uml:CallOperationAction' or $element/@xmi:type = 'uml:StartObjectBehaviorAction'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass CallBehaviorAction.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is CallBehaviorAction.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-CallBehaviorAction" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:CallBehaviorAction'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass CallBehaviorAction.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is CallBehaviorAction or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-CallBehaviorAction" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:CallBehaviorAction'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass CallOperationAction.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is CallOperationAction.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-CallOperationAction" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:CallOperationAction'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass CallOperationAction.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is CallOperationAction or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-CallOperationAction" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:CallOperationAction'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass Clause.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is Clause.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-Clause" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:Clause'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass Clause.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is Clause or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-Clause" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:Clause'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass ClearAssociationAction.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is ClearAssociationAction.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-ClearAssociationAction" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:ClearAssociationAction'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass ClearAssociationAction.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is ClearAssociationAction or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-ClearAssociationAction" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:ClearAssociationAction'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass ClearStructuralFeatureAction.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is ClearStructuralFeatureAction.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-ClearStructuralFeatureAction" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:ClearStructuralFeatureAction'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass ClearStructuralFeatureAction.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is ClearStructuralFeatureAction or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-ClearStructuralFeatureAction" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:ClearStructuralFeatureAction'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass ClearVariableAction.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is ClearVariableAction.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-ClearVariableAction" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:ClearVariableAction'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass ClearVariableAction.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is ClearVariableAction or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-ClearVariableAction" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:ClearVariableAction'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass ConditionalNode.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is ConditionalNode.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-ConditionalNode" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:ConditionalNode'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass ConditionalNode.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is ConditionalNode or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-ConditionalNode" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:ConditionalNode'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass CreateLinkAction.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is CreateLinkAction.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-CreateLinkAction" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:CreateLinkAction'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass CreateLinkAction.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is CreateLinkAction or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-CreateLinkAction" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:CreateLinkAction' or $element/@xmi:type = 'uml:CreateLinkObjectAction'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass CreateLinkObjectAction.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is CreateLinkObjectAction.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-CreateLinkObjectAction" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:CreateLinkObjectAction'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass CreateLinkObjectAction.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is CreateLinkObjectAction or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-CreateLinkObjectAction" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:CreateLinkObjectAction'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass CreateObjectAction.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is CreateObjectAction.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-CreateObjectAction" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:CreateObjectAction'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass CreateObjectAction.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is CreateObjectAction or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-CreateObjectAction" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:CreateObjectAction'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass DestroyLinkAction.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is DestroyLinkAction.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-DestroyLinkAction" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:DestroyLinkAction'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass DestroyLinkAction.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is DestroyLinkAction or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-DestroyLinkAction" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:DestroyLinkAction'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass DestroyObjectAction.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is DestroyObjectAction.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-DestroyObjectAction" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:DestroyObjectAction'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass DestroyObjectAction.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is DestroyObjectAction or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-DestroyObjectAction" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:DestroyObjectAction'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass ExpansionNode.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is ExpansionNode.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-ExpansionNode" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:ExpansionNode'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass ExpansionNode.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is ExpansionNode or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-ExpansionNode" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:ExpansionNode'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass ExpansionRegion.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is ExpansionRegion.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-ExpansionRegion" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:ExpansionRegion'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass ExpansionRegion.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is ExpansionRegion or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-ExpansionRegion" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:ExpansionRegion'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass InputPin.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is InputPin.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-InputPin" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:InputPin'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass InputPin.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is InputPin or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-InputPin" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:InputPin' or $element/@xmi:type = 'uml:ActionInputPin' or $element/@xmi:type = 'uml:ValuePin'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass InvocationAction.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is InvocationAction.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-InvocationAction" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:InvocationAction'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass InvocationAction.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is InvocationAction or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-InvocationAction" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:InvocationAction' or $element/@xmi:type = 'uml:BroadcastSignalAction' or $element/@xmi:type = 'uml:CallAction' or $element/@xmi:type = 'uml:CallBehaviorAction' or $element/@xmi:type = 'uml:CallOperationAction' or $element/@xmi:type = 'uml:StartObjectBehaviorAction' or $element/@xmi:type = 'uml:SendObjectAction' or $element/@xmi:type = 'uml:SendSignalAction'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass LinkAction.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is LinkAction.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-LinkAction" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:LinkAction'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass LinkAction.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is LinkAction or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-LinkAction" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:LinkAction' or $element/@xmi:type = 'uml:WriteLinkAction' or $element/@xmi:type = 'uml:CreateLinkAction' or $element/@xmi:type = 'uml:CreateLinkObjectAction' or $element/@xmi:type = 'uml:DestroyLinkAction' or $element/@xmi:type = 'uml:ReadLinkAction'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass LinkEndCreationData.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is LinkEndCreationData.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-LinkEndCreationData" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:LinkEndCreationData'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass LinkEndCreationData.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is LinkEndCreationData or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-LinkEndCreationData" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:LinkEndCreationData'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass LinkEndData.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is LinkEndData.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-LinkEndData" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:LinkEndData'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass LinkEndData.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is LinkEndData or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-LinkEndData" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:LinkEndData' or $element/@xmi:type = 'uml:LinkEndCreationData' or $element/@xmi:type = 'uml:LinkEndDestructionData'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass LinkEndDestructionData.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is LinkEndDestructionData.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-LinkEndDestructionData" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:LinkEndDestructionData'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass LinkEndDestructionData.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is LinkEndDestructionData or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-LinkEndDestructionData" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:LinkEndDestructionData'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass LoopNode.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is LoopNode.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-LoopNode" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:LoopNode'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass LoopNode.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is LoopNode or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-LoopNode" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:LoopNode'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass OpaqueAction.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is OpaqueAction.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-OpaqueAction" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:OpaqueAction'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass OpaqueAction.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is OpaqueAction or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-OpaqueAction" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:OpaqueAction'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass OutputPin.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is OutputPin.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-OutputPin" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:OutputPin'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass OutputPin.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is OutputPin or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-OutputPin" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:OutputPin'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass Pin.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is Pin.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-Pin" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:Pin'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass Pin.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is Pin or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-Pin" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:Pin' or $element/@xmi:type = 'uml:InputPin' or $element/@xmi:type = 'uml:ActionInputPin' or $element/@xmi:type = 'uml:ValuePin' or $element/@xmi:type = 'uml:OutputPin'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass QualifierValue.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is QualifierValue.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-QualifierValue" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:QualifierValue'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass QualifierValue.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is QualifierValue or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-QualifierValue" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:QualifierValue'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass RaiseExceptionAction.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is RaiseExceptionAction.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-RaiseExceptionAction" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:RaiseExceptionAction'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass RaiseExceptionAction.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is RaiseExceptionAction or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-RaiseExceptionAction" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:RaiseExceptionAction'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass ReadExtentAction.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is ReadExtentAction.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-ReadExtentAction" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:ReadExtentAction'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass ReadExtentAction.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is ReadExtentAction or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-ReadExtentAction" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:ReadExtentAction'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass ReadIsClassifiedObjectAction.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is ReadIsClassifiedObjectAction.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-ReadIsClassifiedObjectAction" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:ReadIsClassifiedObjectAction'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass ReadIsClassifiedObjectAction.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is ReadIsClassifiedObjectAction or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-ReadIsClassifiedObjectAction" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:ReadIsClassifiedObjectAction'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass ReadLinkAction.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is ReadLinkAction.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-ReadLinkAction" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:ReadLinkAction'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass ReadLinkAction.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is ReadLinkAction or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-ReadLinkAction" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:ReadLinkAction'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass ReadLinkObjectEndAction.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is ReadLinkObjectEndAction.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-ReadLinkObjectEndAction" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:ReadLinkObjectEndAction'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass ReadLinkObjectEndAction.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is ReadLinkObjectEndAction or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-ReadLinkObjectEndAction" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:ReadLinkObjectEndAction'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass ReadLinkObjectEndQualifierAction.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is ReadLinkObjectEndQualifierAction.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-ReadLinkObjectEndQualifierAction" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:ReadLinkObjectEndQualifierAction'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass ReadLinkObjectEndQualifierAction.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is ReadLinkObjectEndQualifierAction or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-ReadLinkObjectEndQualifierAction" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:ReadLinkObjectEndQualifierAction'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass ReadSelfAction.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is ReadSelfAction.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-ReadSelfAction" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:ReadSelfAction'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass ReadSelfAction.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is ReadSelfAction or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-ReadSelfAction" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:ReadSelfAction'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass ReadStructuralFeatureAction.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is ReadStructuralFeatureAction.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-ReadStructuralFeatureAction" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:ReadStructuralFeatureAction'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass ReadStructuralFeatureAction.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is ReadStructuralFeatureAction or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-ReadStructuralFeatureAction" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:ReadStructuralFeatureAction'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass ReadVariableAction.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is ReadVariableAction.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-ReadVariableAction" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:ReadVariableAction'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass ReadVariableAction.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is ReadVariableAction or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-ReadVariableAction" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:ReadVariableAction'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass ReclassifyObjectAction.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is ReclassifyObjectAction.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-ReclassifyObjectAction" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:ReclassifyObjectAction'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass ReclassifyObjectAction.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is ReclassifyObjectAction or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-ReclassifyObjectAction" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:ReclassifyObjectAction'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass ReduceAction.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is ReduceAction.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-ReduceAction" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:ReduceAction'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass ReduceAction.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is ReduceAction or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-ReduceAction" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:ReduceAction'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass RemoveStructuralFeatureValueAction.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is RemoveStructuralFeatureValueAction.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-RemoveStructuralFeatureValueAction" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:RemoveStructuralFeatureValueAction'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass RemoveStructuralFeatureValueAction.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is RemoveStructuralFeatureValueAction or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-RemoveStructuralFeatureValueAction"
                 as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:RemoveStructuralFeatureValueAction'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass RemoveVariableValueAction.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is RemoveVariableValueAction.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-RemoveVariableValueAction" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:RemoveVariableValueAction'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass RemoveVariableValueAction.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is RemoveVariableValueAction or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-RemoveVariableValueAction" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:RemoveVariableValueAction'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass ReplyAction.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is ReplyAction.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-ReplyAction" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:ReplyAction'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass ReplyAction.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is ReplyAction or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-ReplyAction" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:ReplyAction'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass SendObjectAction.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is SendObjectAction.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-SendObjectAction" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:SendObjectAction'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass SendObjectAction.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is SendObjectAction or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-SendObjectAction" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:SendObjectAction'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass SendSignalAction.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is SendSignalAction.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-SendSignalAction" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:SendSignalAction'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass SendSignalAction.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is SendSignalAction or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-SendSignalAction" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:SendSignalAction'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass SequenceNode.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is SequenceNode.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-SequenceNode" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:SequenceNode'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass SequenceNode.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is SequenceNode or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-SequenceNode" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:SequenceNode'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass StartClassifierBehaviorAction.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is StartClassifierBehaviorAction.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-StartClassifierBehaviorAction" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:StartClassifierBehaviorAction'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass StartClassifierBehaviorAction.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is StartClassifierBehaviorAction or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-StartClassifierBehaviorAction" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:StartClassifierBehaviorAction'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass StartObjectBehaviorAction.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is StartObjectBehaviorAction.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-StartObjectBehaviorAction" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:StartObjectBehaviorAction'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass StartObjectBehaviorAction.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is StartObjectBehaviorAction or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-StartObjectBehaviorAction" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:StartObjectBehaviorAction'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass StructuralFeatureAction.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is StructuralFeatureAction.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-StructuralFeatureAction" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:StructuralFeatureAction'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass StructuralFeatureAction.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is StructuralFeatureAction or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-StructuralFeatureAction" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:StructuralFeatureAction' or $element/@xmi:type = 'uml:WriteStructuralFeatureAction' or $element/@xmi:type = 'uml:AddStructuralFeatureValueAction' or $element/@xmi:type = 'uml:RemoveStructuralFeatureValueAction' or $element/@xmi:type = 'uml:ClearStructuralFeatureAction' or $element/@xmi:type = 'uml:ReadStructuralFeatureAction'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass StructuredActivityNode.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is StructuredActivityNode.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-StructuredActivityNode" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:StructuredActivityNode'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass StructuredActivityNode.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is StructuredActivityNode or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-StructuredActivityNode" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:StructuredActivityNode' or $element/@xmi:type = 'uml:ConditionalNode' or $element/@xmi:type = 'uml:ExpansionRegion' or $element/@xmi:type = 'uml:LoopNode' or $element/@xmi:type = 'uml:SequenceNode'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass TestIdentityAction.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is TestIdentityAction.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-TestIdentityAction" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:TestIdentityAction'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass TestIdentityAction.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is TestIdentityAction or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-TestIdentityAction" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:TestIdentityAction'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass UnmarshallAction.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is UnmarshallAction.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-UnmarshallAction" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:UnmarshallAction'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass UnmarshallAction.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is UnmarshallAction or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-UnmarshallAction" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:UnmarshallAction'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass ValuePin.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is ValuePin.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-ValuePin" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:ValuePin'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass ValuePin.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is ValuePin or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-ValuePin" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:ValuePin'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass Activity.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is Activity.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-Activity" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:Activity'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass Activity.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is Activity or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-Activity" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:Activity'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass ActivityEdge.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is ActivityEdge.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-ActivityEdge" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:ActivityEdge'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass ActivityEdge.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is ActivityEdge or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-ActivityEdge" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:ActivityEdge' or $element/@xmi:type = 'uml:ControlFlow' or $element/@xmi:type = 'uml:ObjectFlow'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass ActivityFinalNode.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is ActivityFinalNode.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-ActivityFinalNode" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:ActivityFinalNode'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass ActivityFinalNode.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is ActivityFinalNode or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-ActivityFinalNode" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:ActivityFinalNode'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass ActivityGroup.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is ActivityGroup.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-ActivityGroup" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:ActivityGroup'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass ActivityGroup.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is ActivityGroup or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-ActivityGroup" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:ActivityGroup' or $element/@xmi:type = 'uml:StructuredActivityNode' or $element/@xmi:type = 'uml:ConditionalNode' or $element/@xmi:type = 'uml:ExpansionRegion' or $element/@xmi:type = 'uml:LoopNode' or $element/@xmi:type = 'uml:SequenceNode' or $element/@xmi:type = 'uml:ActivityPartition' or $element/@xmi:type = 'uml:InterruptibleActivityRegion'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass ActivityNode.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is ActivityNode.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-ActivityNode" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:ActivityNode'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass ActivityNode.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is ActivityNode or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-ActivityNode" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:ActivityNode' or $element/@xmi:type = 'uml:ControlNode' or $element/@xmi:type = 'uml:DecisionNode' or $element/@xmi:type = 'uml:FinalNode' or $element/@xmi:type = 'uml:ActivityFinalNode' or $element/@xmi:type = 'uml:FlowFinalNode' or $element/@xmi:type = 'uml:ForkNode' or $element/@xmi:type = 'uml:InitialNode' or $element/@xmi:type = 'uml:JoinNode' or $element/@xmi:type = 'uml:MergeNode' or $element/@xmi:type = 'uml:ExecutableNode' or $element/@xmi:type = 'uml:Action' or $element/@xmi:type = 'uml:ValueSpecificationAction' or $element/@xmi:type = 'uml:VariableAction' or $element/@xmi:type = 'uml:WriteVariableAction' or $element/@xmi:type = 'uml:AddVariableValueAction' or $element/@xmi:type = 'uml:RemoveVariableValueAction' or $element/@xmi:type = 'uml:ClearVariableAction' or $element/@xmi:type = 'uml:ReadVariableAction' or $element/@xmi:type = 'uml:AcceptEventAction' or $element/@xmi:type = 'uml:AcceptCallAction' or $element/@xmi:type = 'uml:ClearAssociationAction' or $element/@xmi:type = 'uml:CreateObjectAction' or $element/@xmi:type = 'uml:DestroyObjectAction' or $element/@xmi:type = 'uml:InvocationAction' or $element/@xmi:type = 'uml:BroadcastSignalAction' or $element/@xmi:type = 'uml:CallAction' or $element/@xmi:type = 'uml:CallBehaviorAction' or $element/@xmi:type = 'uml:CallOperationAction' or $element/@xmi:type = 'uml:StartObjectBehaviorAction' or $element/@xmi:type = 'uml:SendObjectAction' or $element/@xmi:type = 'uml:SendSignalAction' or $element/@xmi:type = 'uml:LinkAction' or $element/@xmi:type = 'uml:WriteLinkAction' or $element/@xmi:type = 'uml:CreateLinkAction' or $element/@xmi:type = 'uml:CreateLinkObjectAction' or $element/@xmi:type = 'uml:DestroyLinkAction' or $element/@xmi:type = 'uml:ReadLinkAction' or $element/@xmi:type = 'uml:OpaqueAction' or $element/@xmi:type = 'uml:RaiseExceptionAction' or $element/@xmi:type = 'uml:ReadExtentAction' or $element/@xmi:type = 'uml:ReadIsClassifiedObjectAction' or $element/@xmi:type = 'uml:ReadLinkObjectEndAction' or $element/@xmi:type = 'uml:ReadLinkObjectEndQualifierAction' or $element/@xmi:type = 'uml:ReadSelfAction' or $element/@xmi:type = 'uml:ReclassifyObjectAction' or $element/@xmi:type = 'uml:ReduceAction' or $element/@xmi:type = 'uml:ReplyAction' or $element/@xmi:type = 'uml:StartClassifierBehaviorAction' or $element/@xmi:type = 'uml:StructuralFeatureAction' or $element/@xmi:type = 'uml:WriteStructuralFeatureAction' or $element/@xmi:type = 'uml:AddStructuralFeatureValueAction' or $element/@xmi:type = 'uml:RemoveStructuralFeatureValueAction' or $element/@xmi:type = 'uml:ClearStructuralFeatureAction' or $element/@xmi:type = 'uml:ReadStructuralFeatureAction' or $element/@xmi:type = 'uml:StructuredActivityNode' or $element/@xmi:type = 'uml:ConditionalNode' or $element/@xmi:type = 'uml:ExpansionRegion' or $element/@xmi:type = 'uml:LoopNode' or $element/@xmi:type = 'uml:SequenceNode' or $element/@xmi:type = 'uml:TestIdentityAction' or $element/@xmi:type = 'uml:UnmarshallAction' or $element/@xmi:type = 'uml:ObjectNode' or $element/@xmi:type = 'uml:ExpansionNode' or $element/@xmi:type = 'uml:Pin' or $element/@xmi:type = 'uml:InputPin' or $element/@xmi:type = 'uml:ActionInputPin' or $element/@xmi:type = 'uml:ValuePin' or $element/@xmi:type = 'uml:OutputPin' or $element/@xmi:type = 'uml:ActivityParameterNode' or $element/@xmi:type = 'uml:CentralBufferNode' or $element/@xmi:type = 'uml:DataStoreNode'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass ActivityParameterNode.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is ActivityParameterNode.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-ActivityParameterNode" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:ActivityParameterNode'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass ActivityParameterNode.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is ActivityParameterNode or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-ActivityParameterNode" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:ActivityParameterNode'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass ActivityPartition.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is ActivityPartition.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-ActivityPartition" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:ActivityPartition'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass ActivityPartition.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is ActivityPartition or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-ActivityPartition" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:ActivityPartition'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass CentralBufferNode.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is CentralBufferNode.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-CentralBufferNode" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:CentralBufferNode'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass CentralBufferNode.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is CentralBufferNode or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-CentralBufferNode" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:CentralBufferNode' or $element/@xmi:type = 'uml:DataStoreNode'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass ControlFlow.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is ControlFlow.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-ControlFlow" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:ControlFlow'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass ControlFlow.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is ControlFlow or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-ControlFlow" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:ControlFlow'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass ControlNode.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is ControlNode.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-ControlNode" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:ControlNode'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass ControlNode.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is ControlNode or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-ControlNode" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:ControlNode' or $element/@xmi:type = 'uml:DecisionNode' or $element/@xmi:type = 'uml:FinalNode' or $element/@xmi:type = 'uml:ActivityFinalNode' or $element/@xmi:type = 'uml:FlowFinalNode' or $element/@xmi:type = 'uml:ForkNode' or $element/@xmi:type = 'uml:InitialNode' or $element/@xmi:type = 'uml:JoinNode' or $element/@xmi:type = 'uml:MergeNode'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass DataStoreNode.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is DataStoreNode.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-DataStoreNode" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:DataStoreNode'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass DataStoreNode.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is DataStoreNode or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-DataStoreNode" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:DataStoreNode'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass DecisionNode.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is DecisionNode.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-DecisionNode" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:DecisionNode'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass DecisionNode.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is DecisionNode or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-DecisionNode" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:DecisionNode'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass ExceptionHandler.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is ExceptionHandler.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-ExceptionHandler" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:ExceptionHandler'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass ExceptionHandler.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is ExceptionHandler or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-ExceptionHandler" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:ExceptionHandler'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass ExecutableNode.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is ExecutableNode.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-ExecutableNode" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:ExecutableNode'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass ExecutableNode.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is ExecutableNode or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-ExecutableNode" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:ExecutableNode' or $element/@xmi:type = 'uml:Action' or $element/@xmi:type = 'uml:ValueSpecificationAction' or $element/@xmi:type = 'uml:VariableAction' or $element/@xmi:type = 'uml:WriteVariableAction' or $element/@xmi:type = 'uml:AddVariableValueAction' or $element/@xmi:type = 'uml:RemoveVariableValueAction' or $element/@xmi:type = 'uml:ClearVariableAction' or $element/@xmi:type = 'uml:ReadVariableAction' or $element/@xmi:type = 'uml:AcceptEventAction' or $element/@xmi:type = 'uml:AcceptCallAction' or $element/@xmi:type = 'uml:ClearAssociationAction' or $element/@xmi:type = 'uml:CreateObjectAction' or $element/@xmi:type = 'uml:DestroyObjectAction' or $element/@xmi:type = 'uml:InvocationAction' or $element/@xmi:type = 'uml:BroadcastSignalAction' or $element/@xmi:type = 'uml:CallAction' or $element/@xmi:type = 'uml:CallBehaviorAction' or $element/@xmi:type = 'uml:CallOperationAction' or $element/@xmi:type = 'uml:StartObjectBehaviorAction' or $element/@xmi:type = 'uml:SendObjectAction' or $element/@xmi:type = 'uml:SendSignalAction' or $element/@xmi:type = 'uml:LinkAction' or $element/@xmi:type = 'uml:WriteLinkAction' or $element/@xmi:type = 'uml:CreateLinkAction' or $element/@xmi:type = 'uml:CreateLinkObjectAction' or $element/@xmi:type = 'uml:DestroyLinkAction' or $element/@xmi:type = 'uml:ReadLinkAction' or $element/@xmi:type = 'uml:OpaqueAction' or $element/@xmi:type = 'uml:RaiseExceptionAction' or $element/@xmi:type = 'uml:ReadExtentAction' or $element/@xmi:type = 'uml:ReadIsClassifiedObjectAction' or $element/@xmi:type = 'uml:ReadLinkObjectEndAction' or $element/@xmi:type = 'uml:ReadLinkObjectEndQualifierAction' or $element/@xmi:type = 'uml:ReadSelfAction' or $element/@xmi:type = 'uml:ReclassifyObjectAction' or $element/@xmi:type = 'uml:ReduceAction' or $element/@xmi:type = 'uml:ReplyAction' or $element/@xmi:type = 'uml:StartClassifierBehaviorAction' or $element/@xmi:type = 'uml:StructuralFeatureAction' or $element/@xmi:type = 'uml:WriteStructuralFeatureAction' or $element/@xmi:type = 'uml:AddStructuralFeatureValueAction' or $element/@xmi:type = 'uml:RemoveStructuralFeatureValueAction' or $element/@xmi:type = 'uml:ClearStructuralFeatureAction' or $element/@xmi:type = 'uml:ReadStructuralFeatureAction' or $element/@xmi:type = 'uml:StructuredActivityNode' or $element/@xmi:type = 'uml:ConditionalNode' or $element/@xmi:type = 'uml:ExpansionRegion' or $element/@xmi:type = 'uml:LoopNode' or $element/@xmi:type = 'uml:SequenceNode' or $element/@xmi:type = 'uml:TestIdentityAction' or $element/@xmi:type = 'uml:UnmarshallAction'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass FinalNode.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is FinalNode.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-FinalNode" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:FinalNode'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass FinalNode.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is FinalNode or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-FinalNode" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:FinalNode' or $element/@xmi:type = 'uml:ActivityFinalNode' or $element/@xmi:type = 'uml:FlowFinalNode'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass FlowFinalNode.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is FlowFinalNode.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-FlowFinalNode" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:FlowFinalNode'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass FlowFinalNode.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is FlowFinalNode or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-FlowFinalNode" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:FlowFinalNode'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass ForkNode.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is ForkNode.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-ForkNode" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:ForkNode'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass ForkNode.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is ForkNode or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-ForkNode" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:ForkNode'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass InitialNode.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is InitialNode.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-InitialNode" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:InitialNode'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass InitialNode.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is InitialNode or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-InitialNode" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:InitialNode'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass InterruptibleActivityRegion.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is InterruptibleActivityRegion.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-InterruptibleActivityRegion" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:InterruptibleActivityRegion'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass InterruptibleActivityRegion.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is InterruptibleActivityRegion or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-InterruptibleActivityRegion" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:InterruptibleActivityRegion'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass JoinNode.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is JoinNode.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-JoinNode" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:JoinNode'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass JoinNode.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is JoinNode or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-JoinNode" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:JoinNode'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass MergeNode.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is MergeNode.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-MergeNode" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:MergeNode'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass MergeNode.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is MergeNode or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-MergeNode" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:MergeNode'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass ObjectFlow.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is ObjectFlow.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-ObjectFlow" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:ObjectFlow'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass ObjectFlow.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is ObjectFlow or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-ObjectFlow" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:ObjectFlow'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass ObjectNode.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is ObjectNode.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-ObjectNode" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:ObjectNode'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass ObjectNode.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is ObjectNode or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-ObjectNode" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:ObjectNode' or $element/@xmi:type = 'uml:ExpansionNode' or $element/@xmi:type = 'uml:Pin' or $element/@xmi:type = 'uml:InputPin' or $element/@xmi:type = 'uml:ActionInputPin' or $element/@xmi:type = 'uml:ValuePin' or $element/@xmi:type = 'uml:OutputPin' or $element/@xmi:type = 'uml:ActivityParameterNode' or $element/@xmi:type = 'uml:CentralBufferNode' or $element/@xmi:type = 'uml:DataStoreNode'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass Variable.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is Variable.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-Variable" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:Variable'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass Variable.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is Variable or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-Variable" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:Variable'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass Substitution.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is Substitution.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-Substitution" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:Substitution'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass Substitution.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is Substitution or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-Substitution" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:Substitution'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass BehavioralFeature.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is BehavioralFeature.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-BehavioralFeature" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:BehavioralFeature'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass BehavioralFeature.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is BehavioralFeature or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-BehavioralFeature" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:BehavioralFeature' or $element/@xmi:type = 'uml:Operation' or $element/@xmi:type = 'uml:Reception'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass Classifier.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is Classifier.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-Classifier" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:Classifier'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass Classifier.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is Classifier or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-Classifier" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:Classifier' or $element/@xmi:type = 'uml:Artifact' or $element/@xmi:type = 'uml:DeploymentSpecification' or $element/@xmi:type = 'uml:InformationItem' or $element/@xmi:type = 'uml:BehavioredClassifier' or $element/@xmi:type = 'uml:Class' or $element/@xmi:type = 'uml:Behavior' or $element/@xmi:type = 'uml:Activity' or $element/@xmi:type = 'uml:OpaqueBehavior' or $element/@xmi:type = 'uml:FunctionBehavior' or $element/@xmi:type = 'uml:Interaction' or $element/@xmi:type = 'uml:StateMachine' or $element/@xmi:type = 'uml:ProtocolStateMachine' or $element/@xmi:type = 'uml:Node' or $element/@xmi:type = 'uml:Device' or $element/@xmi:type = 'uml:ExecutionEnvironment' or $element/@xmi:type = 'uml:Stereotype' or $element/@xmi:type = 'uml:AssociationClass' or $element/@xmi:type = 'uml:Component' or $element/@xmi:type = 'uml:Collaboration' or $element/@xmi:type = 'uml:Actor' or $element/@xmi:type = 'uml:UseCase' or $element/@xmi:type = 'uml:DataType' or $element/@xmi:type = 'uml:Enumeration' or $element/@xmi:type = 'uml:PrimitiveType' or $element/@xmi:type = 'uml:Interface' or $element/@xmi:type = 'uml:Signal' or $element/@xmi:type = 'uml:Association' or $element/@xmi:type = 'uml:CommunicationPath' or $element/@xmi:type = 'uml:Extension' or $element/@xmi:type = 'uml:AssociationClass' or $element/@xmi:type = 'uml:StructuredClassifier' or $element/@xmi:type = 'uml:Collaboration' or $element/@xmi:type = 'uml:EncapsulatedClassifier' or $element/@xmi:type = 'uml:Class' or $element/@xmi:type = 'uml:Behavior' or $element/@xmi:type = 'uml:Activity' or $element/@xmi:type = 'uml:OpaqueBehavior' or $element/@xmi:type = 'uml:FunctionBehavior' or $element/@xmi:type = 'uml:Interaction' or $element/@xmi:type = 'uml:StateMachine' or $element/@xmi:type = 'uml:ProtocolStateMachine' or $element/@xmi:type = 'uml:Node' or $element/@xmi:type = 'uml:Device' or $element/@xmi:type = 'uml:ExecutionEnvironment' or $element/@xmi:type = 'uml:Stereotype' or $element/@xmi:type = 'uml:AssociationClass' or $element/@xmi:type = 'uml:Component'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass ClassifierTemplateParameter.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is ClassifierTemplateParameter.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-ClassifierTemplateParameter" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:ClassifierTemplateParameter'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass ClassifierTemplateParameter.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is ClassifierTemplateParameter or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-ClassifierTemplateParameter" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:ClassifierTemplateParameter'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass Feature.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is Feature.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-Feature" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:Feature'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass Feature.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is Feature or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-Feature" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:Feature' or $element/@xmi:type = 'uml:BehavioralFeature' or $element/@xmi:type = 'uml:Operation' or $element/@xmi:type = 'uml:Reception' or $element/@xmi:type = 'uml:StructuralFeature' or $element/@xmi:type = 'uml:Property' or $element/@xmi:type = 'uml:ExtensionEnd' or $element/@xmi:type = 'uml:Port' or $element/@xmi:type = 'uml:Connector'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass Generalization.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is Generalization.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-Generalization" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:Generalization'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass Generalization.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is Generalization or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-Generalization" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:Generalization'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass GeneralizationSet.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is GeneralizationSet.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-GeneralizationSet" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:GeneralizationSet'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass GeneralizationSet.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is GeneralizationSet or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-GeneralizationSet" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:GeneralizationSet'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass InstanceSpecification.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is InstanceSpecification.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-InstanceSpecification" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:InstanceSpecification'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass InstanceSpecification.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is InstanceSpecification or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-InstanceSpecification" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:InstanceSpecification' or $element/@xmi:type = 'uml:EnumerationLiteral'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass InstanceValue.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is InstanceValue.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-InstanceValue" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:InstanceValue'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass InstanceValue.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is InstanceValue or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-InstanceValue" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:InstanceValue'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass Operation.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is Operation.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-Operation" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:Operation'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass Operation.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is Operation or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-Operation" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:Operation'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass OperationTemplateParameter.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is OperationTemplateParameter.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-OperationTemplateParameter" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:OperationTemplateParameter'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass OperationTemplateParameter.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is OperationTemplateParameter or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-OperationTemplateParameter" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:OperationTemplateParameter'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass Parameter.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is Parameter.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-Parameter" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:Parameter'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass Parameter.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is Parameter or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-Parameter" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:Parameter'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass ParameterSet.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is ParameterSet.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-ParameterSet" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:ParameterSet'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass ParameterSet.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is ParameterSet or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-ParameterSet" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:ParameterSet'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass Property.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is Property.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-Property" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:Property'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass Property.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is Property or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-Property" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:Property' or $element/@xmi:type = 'uml:ExtensionEnd' or $element/@xmi:type = 'uml:Port'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass RedefinableTemplateSignature.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is RedefinableTemplateSignature.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-RedefinableTemplateSignature" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:RedefinableTemplateSignature'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass RedefinableTemplateSignature.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is RedefinableTemplateSignature or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-RedefinableTemplateSignature" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:RedefinableTemplateSignature'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass Slot.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is Slot.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-Slot" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:Slot'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass Slot.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is Slot or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-Slot" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:Slot'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass StructuralFeature.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is StructuralFeature.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-StructuralFeature" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:StructuralFeature'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass StructuralFeature.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is StructuralFeature or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-StructuralFeature" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:StructuralFeature' or $element/@xmi:type = 'uml:Property' or $element/@xmi:type = 'uml:ExtensionEnd' or $element/@xmi:type = 'uml:Port'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass AnyReceiveEvent.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is AnyReceiveEvent.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-AnyReceiveEvent" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:AnyReceiveEvent'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass AnyReceiveEvent.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is AnyReceiveEvent or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-AnyReceiveEvent" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:AnyReceiveEvent'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass Behavior.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is Behavior.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-Behavior" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:Behavior'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass Behavior.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is Behavior or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-Behavior" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:Behavior' or $element/@xmi:type = 'uml:Activity' or $element/@xmi:type = 'uml:OpaqueBehavior' or $element/@xmi:type = 'uml:FunctionBehavior' or $element/@xmi:type = 'uml:Interaction' or $element/@xmi:type = 'uml:StateMachine' or $element/@xmi:type = 'uml:ProtocolStateMachine'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass CallEvent.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is CallEvent.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-CallEvent" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:CallEvent'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass CallEvent.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is CallEvent or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-CallEvent" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:CallEvent'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass ChangeEvent.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is ChangeEvent.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-ChangeEvent" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:ChangeEvent'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass ChangeEvent.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is ChangeEvent or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-ChangeEvent" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:ChangeEvent'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass Event.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is Event.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-Event" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:Event'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass Event.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is Event or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-Event" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:Event' or $element/@xmi:type = 'uml:ChangeEvent' or $element/@xmi:type = 'uml:MessageEvent' or $element/@xmi:type = 'uml:AnyReceiveEvent' or $element/@xmi:type = 'uml:CallEvent' or $element/@xmi:type = 'uml:SignalEvent' or $element/@xmi:type = 'uml:TimeEvent'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass FunctionBehavior.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is FunctionBehavior.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-FunctionBehavior" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:FunctionBehavior'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass FunctionBehavior.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is FunctionBehavior or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-FunctionBehavior" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:FunctionBehavior'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass MessageEvent.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is MessageEvent.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-MessageEvent" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:MessageEvent'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass MessageEvent.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is MessageEvent or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-MessageEvent" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:MessageEvent' or $element/@xmi:type = 'uml:AnyReceiveEvent' or $element/@xmi:type = 'uml:CallEvent' or $element/@xmi:type = 'uml:SignalEvent'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass OpaqueBehavior.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is OpaqueBehavior.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-OpaqueBehavior" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:OpaqueBehavior'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass OpaqueBehavior.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is OpaqueBehavior or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-OpaqueBehavior" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:OpaqueBehavior' or $element/@xmi:type = 'uml:FunctionBehavior'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass SignalEvent.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is SignalEvent.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-SignalEvent" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:SignalEvent'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass SignalEvent.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is SignalEvent or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-SignalEvent" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:SignalEvent'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass TimeEvent.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is TimeEvent.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-TimeEvent" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:TimeEvent'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass TimeEvent.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is TimeEvent or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-TimeEvent" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:TimeEvent'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass Trigger.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is Trigger.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-Trigger" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:Trigger'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass Trigger.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is Trigger or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-Trigger" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:Trigger'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass Abstraction.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is Abstraction.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-Abstraction" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:Abstraction'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass Abstraction.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is Abstraction or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-Abstraction" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:Abstraction' or $element/@xmi:type = 'uml:Realization' or $element/@xmi:type = 'uml:Substitution' or $element/@xmi:type = 'uml:InterfaceRealization' or $element/@xmi:type = 'uml:ComponentRealization' or $element/@xmi:type = 'uml:Manifestation'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass Comment.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is Comment.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-Comment" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:Comment'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass Comment.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is Comment or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-Comment" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:Comment'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass Constraint.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is Constraint.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-Constraint" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:Constraint'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass Constraint.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is Constraint or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-Constraint" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:Constraint' or $element/@xmi:type = 'uml:InteractionConstraint' or $element/@xmi:type = 'uml:IntervalConstraint' or $element/@xmi:type = 'uml:DurationConstraint' or $element/@xmi:type = 'uml:TimeConstraint'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass Dependency.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is Dependency.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-Dependency" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:Dependency'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass Dependency.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is Dependency or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-Dependency" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:Dependency' or $element/@xmi:type = 'uml:Abstraction' or $element/@xmi:type = 'uml:Realization' or $element/@xmi:type = 'uml:Substitution' or $element/@xmi:type = 'uml:InterfaceRealization' or $element/@xmi:type = 'uml:ComponentRealization' or $element/@xmi:type = 'uml:Manifestation' or $element/@xmi:type = 'uml:Usage' or $element/@xmi:type = 'uml:Deployment'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass DirectedRelationship.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is DirectedRelationship.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-DirectedRelationship" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:DirectedRelationship'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass DirectedRelationship.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is DirectedRelationship or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-DirectedRelationship" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:DirectedRelationship' or $element/@xmi:type = 'uml:Generalization' or $element/@xmi:type = 'uml:Dependency' or $element/@xmi:type = 'uml:Abstraction' or $element/@xmi:type = 'uml:Realization' or $element/@xmi:type = 'uml:Substitution' or $element/@xmi:type = 'uml:InterfaceRealization' or $element/@xmi:type = 'uml:ComponentRealization' or $element/@xmi:type = 'uml:Manifestation' or $element/@xmi:type = 'uml:Usage' or $element/@xmi:type = 'uml:Deployment' or $element/@xmi:type = 'uml:ElementImport' or $element/@xmi:type = 'uml:PackageImport' or $element/@xmi:type = 'uml:TemplateBinding' or $element/@xmi:type = 'uml:InformationFlow' or $element/@xmi:type = 'uml:PackageMerge' or $element/@xmi:type = 'uml:ProfileApplication' or $element/@xmi:type = 'uml:ProtocolConformance' or $element/@xmi:type = 'uml:Extend' or $element/@xmi:type = 'uml:Include'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass ElementImport.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is ElementImport.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-ElementImport" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:ElementImport'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass ElementImport.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is ElementImport or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-ElementImport" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:ElementImport'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass MultiplicityElement.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is MultiplicityElement.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-MultiplicityElement" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:MultiplicityElement'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass MultiplicityElement.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is MultiplicityElement or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-MultiplicityElement" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:MultiplicityElement' or $element/@xmi:type = 'uml:Pin' or $element/@xmi:type = 'uml:InputPin' or $element/@xmi:type = 'uml:ActionInputPin' or $element/@xmi:type = 'uml:ValuePin' or $element/@xmi:type = 'uml:OutputPin' or $element/@xmi:type = 'uml:Variable' or $element/@xmi:type = 'uml:Parameter' or $element/@xmi:type = 'uml:StructuralFeature' or $element/@xmi:type = 'uml:Property' or $element/@xmi:type = 'uml:ExtensionEnd' or $element/@xmi:type = 'uml:Port' or $element/@xmi:type = 'uml:ConnectorEnd'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass PackageImport.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is PackageImport.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-PackageImport" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:PackageImport'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass PackageImport.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is PackageImport or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-PackageImport" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:PackageImport'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass Realization.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is Realization.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-Realization" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:Realization'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass Realization.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is Realization or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-Realization" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:Realization' or $element/@xmi:type = 'uml:Substitution' or $element/@xmi:type = 'uml:InterfaceRealization' or $element/@xmi:type = 'uml:ComponentRealization'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass Relationship.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is Relationship.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-Relationship" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:Relationship'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass Relationship.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is Relationship or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-Relationship" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:Relationship' or $element/@xmi:type = 'uml:DirectedRelationship' or $element/@xmi:type = 'uml:Generalization' or $element/@xmi:type = 'uml:Dependency' or $element/@xmi:type = 'uml:Abstraction' or $element/@xmi:type = 'uml:Realization' or $element/@xmi:type = 'uml:Substitution' or $element/@xmi:type = 'uml:InterfaceRealization' or $element/@xmi:type = 'uml:ComponentRealization' or $element/@xmi:type = 'uml:Manifestation' or $element/@xmi:type = 'uml:Usage' or $element/@xmi:type = 'uml:Deployment' or $element/@xmi:type = 'uml:ElementImport' or $element/@xmi:type = 'uml:PackageImport' or $element/@xmi:type = 'uml:TemplateBinding' or $element/@xmi:type = 'uml:InformationFlow' or $element/@xmi:type = 'uml:PackageMerge' or $element/@xmi:type = 'uml:ProfileApplication' or $element/@xmi:type = 'uml:ProtocolConformance' or $element/@xmi:type = 'uml:Extend' or $element/@xmi:type = 'uml:Include' or $element/@xmi:type = 'uml:Association' or $element/@xmi:type = 'uml:CommunicationPath' or $element/@xmi:type = 'uml:Extension' or $element/@xmi:type = 'uml:AssociationClass'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass TemplateBinding.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is TemplateBinding.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-TemplateBinding" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:TemplateBinding'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass TemplateBinding.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is TemplateBinding or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-TemplateBinding" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:TemplateBinding'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass TemplateParameter.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is TemplateParameter.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-TemplateParameter" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:TemplateParameter'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass TemplateParameter.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is TemplateParameter or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-TemplateParameter" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:TemplateParameter' or $element/@xmi:type = 'uml:ClassifierTemplateParameter' or $element/@xmi:type = 'uml:OperationTemplateParameter' or $element/@xmi:type = 'uml:ConnectableElementTemplateParameter'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass TemplateParameterSubstitution.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is TemplateParameterSubstitution.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-TemplateParameterSubstitution" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:TemplateParameterSubstitution'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass TemplateParameterSubstitution.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is TemplateParameterSubstitution or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-TemplateParameterSubstitution" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:TemplateParameterSubstitution'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass TemplateSignature.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is TemplateSignature.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-TemplateSignature" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:TemplateSignature'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass TemplateSignature.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is TemplateSignature or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-TemplateSignature" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:TemplateSignature' or $element/@xmi:type = 'uml:RedefinableTemplateSignature'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass Type.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is Type.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-Type" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:Type'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass Type.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is Type or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-Type" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:Type' or $element/@xmi:type = 'uml:Classifier' or $element/@xmi:type = 'uml:Artifact' or $element/@xmi:type = 'uml:DeploymentSpecification' or $element/@xmi:type = 'uml:InformationItem' or $element/@xmi:type = 'uml:BehavioredClassifier' or $element/@xmi:type = 'uml:Class' or $element/@xmi:type = 'uml:Behavior' or $element/@xmi:type = 'uml:Activity' or $element/@xmi:type = 'uml:OpaqueBehavior' or $element/@xmi:type = 'uml:FunctionBehavior' or $element/@xmi:type = 'uml:Interaction' or $element/@xmi:type = 'uml:StateMachine' or $element/@xmi:type = 'uml:ProtocolStateMachine' or $element/@xmi:type = 'uml:Node' or $element/@xmi:type = 'uml:Device' or $element/@xmi:type = 'uml:ExecutionEnvironment' or $element/@xmi:type = 'uml:Stereotype' or $element/@xmi:type = 'uml:AssociationClass' or $element/@xmi:type = 'uml:Component' or $element/@xmi:type = 'uml:Collaboration' or $element/@xmi:type = 'uml:Actor' or $element/@xmi:type = 'uml:UseCase' or $element/@xmi:type = 'uml:DataType' or $element/@xmi:type = 'uml:Enumeration' or $element/@xmi:type = 'uml:PrimitiveType' or $element/@xmi:type = 'uml:Interface' or $element/@xmi:type = 'uml:Signal' or $element/@xmi:type = 'uml:Association' or $element/@xmi:type = 'uml:CommunicationPath' or $element/@xmi:type = 'uml:Extension' or $element/@xmi:type = 'uml:AssociationClass' or $element/@xmi:type = 'uml:StructuredClassifier' or $element/@xmi:type = 'uml:Collaboration' or $element/@xmi:type = 'uml:EncapsulatedClassifier' or $element/@xmi:type = 'uml:Class' or $element/@xmi:type = 'uml:Behavior' or $element/@xmi:type = 'uml:Activity' or $element/@xmi:type = 'uml:OpaqueBehavior' or $element/@xmi:type = 'uml:FunctionBehavior' or $element/@xmi:type = 'uml:Interaction' or $element/@xmi:type = 'uml:StateMachine' or $element/@xmi:type = 'uml:ProtocolStateMachine' or $element/@xmi:type = 'uml:Node' or $element/@xmi:type = 'uml:Device' or $element/@xmi:type = 'uml:ExecutionEnvironment' or $element/@xmi:type = 'uml:Stereotype' or $element/@xmi:type = 'uml:AssociationClass' or $element/@xmi:type = 'uml:Component'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass TypedElement.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is TypedElement.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-TypedElement" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:TypedElement'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass TypedElement.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is TypedElement or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-TypedElement" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:TypedElement' or $element/@xmi:type = 'uml:ObjectNode' or $element/@xmi:type = 'uml:ExpansionNode' or $element/@xmi:type = 'uml:Pin' or $element/@xmi:type = 'uml:InputPin' or $element/@xmi:type = 'uml:ActionInputPin' or $element/@xmi:type = 'uml:ValuePin' or $element/@xmi:type = 'uml:OutputPin' or $element/@xmi:type = 'uml:ActivityParameterNode' or $element/@xmi:type = 'uml:CentralBufferNode' or $element/@xmi:type = 'uml:DataStoreNode' or $element/@xmi:type = 'uml:StructuralFeature' or $element/@xmi:type = 'uml:Property' or $element/@xmi:type = 'uml:ExtensionEnd' or $element/@xmi:type = 'uml:Port' or $element/@xmi:type = 'uml:ConnectableElement' or $element/@xmi:type = 'uml:Variable' or $element/@xmi:type = 'uml:Parameter' or $element/@xmi:type = 'uml:Property' or $element/@xmi:type = 'uml:ExtensionEnd' or $element/@xmi:type = 'uml:Port' or $element/@xmi:type = 'uml:ValueSpecification' or $element/@xmi:type = 'uml:InstanceValue' or $element/@xmi:type = 'uml:Duration' or $element/@xmi:type = 'uml:Expression' or $element/@xmi:type = 'uml:StringExpression' or $element/@xmi:type = 'uml:Interval' or $element/@xmi:type = 'uml:DurationInterval' or $element/@xmi:type = 'uml:TimeInterval' or $element/@xmi:type = 'uml:LiteralSpecification' or $element/@xmi:type = 'uml:LiteralBoolean' or $element/@xmi:type = 'uml:LiteralInteger' or $element/@xmi:type = 'uml:LiteralNull' or $element/@xmi:type = 'uml:LiteralReal' or $element/@xmi:type = 'uml:LiteralString' or $element/@xmi:type = 'uml:LiteralUnlimitedNatural' or $element/@xmi:type = 'uml:OpaqueExpression' or $element/@xmi:type = 'uml:TimeExpression'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass Usage.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is Usage.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-Usage" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:Usage'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass Usage.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is Usage or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-Usage" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:Usage'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass Artifact.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is Artifact.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-Artifact" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:Artifact'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass Artifact.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is Artifact or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-Artifact" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:Artifact' or $element/@xmi:type = 'uml:DeploymentSpecification'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass CommunicationPath.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is CommunicationPath.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-CommunicationPath" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:CommunicationPath'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass CommunicationPath.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is CommunicationPath or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-CommunicationPath" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:CommunicationPath'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass DeployedArtifact.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is DeployedArtifact.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-DeployedArtifact" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:DeployedArtifact'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass DeployedArtifact.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is DeployedArtifact or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-DeployedArtifact" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:DeployedArtifact' or $element/@xmi:type = 'uml:InstanceSpecification' or $element/@xmi:type = 'uml:EnumerationLiteral' or $element/@xmi:type = 'uml:Artifact' or $element/@xmi:type = 'uml:DeploymentSpecification'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass Deployment.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is Deployment.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-Deployment" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:Deployment'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass Deployment.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is Deployment or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-Deployment" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:Deployment'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass DeploymentSpecification.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is DeploymentSpecification.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-DeploymentSpecification" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:DeploymentSpecification'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass DeploymentSpecification.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is DeploymentSpecification or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-DeploymentSpecification" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:DeploymentSpecification'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass DeploymentTarget.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is DeploymentTarget.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-DeploymentTarget" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:DeploymentTarget'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass DeploymentTarget.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is DeploymentTarget or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-DeploymentTarget" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:DeploymentTarget' or $element/@xmi:type = 'uml:InstanceSpecification' or $element/@xmi:type = 'uml:EnumerationLiteral' or $element/@xmi:type = 'uml:Property' or $element/@xmi:type = 'uml:ExtensionEnd' or $element/@xmi:type = 'uml:Port' or $element/@xmi:type = 'uml:Node' or $element/@xmi:type = 'uml:Device' or $element/@xmi:type = 'uml:ExecutionEnvironment'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass Device.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is Device.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-Device" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:Device'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass Device.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is Device or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-Device" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:Device'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass ExecutionEnvironment.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is ExecutionEnvironment.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-ExecutionEnvironment" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:ExecutionEnvironment'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass ExecutionEnvironment.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is ExecutionEnvironment or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-ExecutionEnvironment" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:ExecutionEnvironment'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass Manifestation.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is Manifestation.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-Manifestation" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:Manifestation'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass Manifestation.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is Manifestation or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-Manifestation" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:Manifestation'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass Node.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is Node.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-Node" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:Node'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass Node.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is Node or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-Node" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:Node' or $element/@xmi:type = 'uml:Device' or $element/@xmi:type = 'uml:ExecutionEnvironment'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass InformationFlow.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is InformationFlow.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-InformationFlow" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:InformationFlow'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass InformationFlow.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is InformationFlow or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-InformationFlow" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:InformationFlow'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass InformationItem.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is InformationItem.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-InformationItem" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:InformationItem'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass InformationItem.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is InformationItem or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-InformationItem" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:InformationItem'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass ActionExecutionSpecification.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is ActionExecutionSpecification.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-ActionExecutionSpecification" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:ActionExecutionSpecification'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass ActionExecutionSpecification.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is ActionExecutionSpecification or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-ActionExecutionSpecification" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:ActionExecutionSpecification'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass BehaviorExecutionSpecification.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is BehaviorExecutionSpecification.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-BehaviorExecutionSpecification" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:BehaviorExecutionSpecification'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass BehaviorExecutionSpecification.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is BehaviorExecutionSpecification or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-BehaviorExecutionSpecification" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:BehaviorExecutionSpecification'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass CombinedFragment.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is CombinedFragment.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-CombinedFragment" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:CombinedFragment'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass CombinedFragment.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is CombinedFragment or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-CombinedFragment" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:CombinedFragment' or $element/@xmi:type = 'uml:ConsiderIgnoreFragment'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass ConsiderIgnoreFragment.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is ConsiderIgnoreFragment.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-ConsiderIgnoreFragment" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:ConsiderIgnoreFragment'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass ConsiderIgnoreFragment.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is ConsiderIgnoreFragment or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-ConsiderIgnoreFragment" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:ConsiderIgnoreFragment'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass Continuation.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is Continuation.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-Continuation" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:Continuation'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass Continuation.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is Continuation or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-Continuation" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:Continuation'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass DestructionOccurrenceSpecification.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is DestructionOccurrenceSpecification.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-DestructionOccurrenceSpecification" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:DestructionOccurrenceSpecification'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass DestructionOccurrenceSpecification.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is DestructionOccurrenceSpecification or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-DestructionOccurrenceSpecification"
                 as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:DestructionOccurrenceSpecification'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass ExecutionOccurrenceSpecification.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is ExecutionOccurrenceSpecification.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-ExecutionOccurrenceSpecification" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:ExecutionOccurrenceSpecification'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass ExecutionOccurrenceSpecification.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is ExecutionOccurrenceSpecification or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-ExecutionOccurrenceSpecification" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:ExecutionOccurrenceSpecification'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass ExecutionSpecification.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is ExecutionSpecification.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-ExecutionSpecification" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:ExecutionSpecification'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass ExecutionSpecification.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is ExecutionSpecification or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-ExecutionSpecification" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:ExecutionSpecification' or $element/@xmi:type = 'uml:ActionExecutionSpecification' or $element/@xmi:type = 'uml:BehaviorExecutionSpecification'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass Gate.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is Gate.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-Gate" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:Gate'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass Gate.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is Gate or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-Gate" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:Gate'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass GeneralOrdering.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is GeneralOrdering.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-GeneralOrdering" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:GeneralOrdering'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass GeneralOrdering.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is GeneralOrdering or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-GeneralOrdering" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:GeneralOrdering'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass Interaction.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is Interaction.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-Interaction" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:Interaction'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass Interaction.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is Interaction or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-Interaction" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:Interaction'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass InteractionConstraint.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is InteractionConstraint.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-InteractionConstraint" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:InteractionConstraint'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass InteractionConstraint.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is InteractionConstraint or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-InteractionConstraint" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:InteractionConstraint'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass InteractionFragment.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is InteractionFragment.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-InteractionFragment" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:InteractionFragment'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass InteractionFragment.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is InteractionFragment or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-InteractionFragment" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:InteractionFragment' or $element/@xmi:type = 'uml:CombinedFragment' or $element/@xmi:type = 'uml:ConsiderIgnoreFragment' or $element/@xmi:type = 'uml:Continuation' or $element/@xmi:type = 'uml:ExecutionSpecification' or $element/@xmi:type = 'uml:ActionExecutionSpecification' or $element/@xmi:type = 'uml:BehaviorExecutionSpecification' or $element/@xmi:type = 'uml:Interaction' or $element/@xmi:type = 'uml:InteractionOperand' or $element/@xmi:type = 'uml:InteractionUse' or $element/@xmi:type = 'uml:PartDecomposition' or $element/@xmi:type = 'uml:OccurrenceSpecification' or $element/@xmi:type = 'uml:ExecutionOccurrenceSpecification' or $element/@xmi:type = 'uml:MessageOccurrenceSpecification' or $element/@xmi:type = 'uml:DestructionOccurrenceSpecification' or $element/@xmi:type = 'uml:StateInvariant'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass InteractionOperand.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is InteractionOperand.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-InteractionOperand" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:InteractionOperand'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass InteractionOperand.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is InteractionOperand or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-InteractionOperand" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:InteractionOperand'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass InteractionUse.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is InteractionUse.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-InteractionUse" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:InteractionUse'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass InteractionUse.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is InteractionUse or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-InteractionUse" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:InteractionUse' or $element/@xmi:type = 'uml:PartDecomposition'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass Lifeline.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is Lifeline.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-Lifeline" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:Lifeline'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass Lifeline.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is Lifeline or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-Lifeline" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:Lifeline'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass Message.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is Message.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-Message" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:Message'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass Message.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is Message or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-Message" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:Message'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass MessageEnd.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is MessageEnd.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-MessageEnd" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:MessageEnd'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass MessageEnd.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is MessageEnd or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-MessageEnd" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:MessageEnd' or $element/@xmi:type = 'uml:Gate' or $element/@xmi:type = 'uml:MessageOccurrenceSpecification' or $element/@xmi:type = 'uml:DestructionOccurrenceSpecification'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass MessageOccurrenceSpecification.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is MessageOccurrenceSpecification.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-MessageOccurrenceSpecification" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:MessageOccurrenceSpecification'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass MessageOccurrenceSpecification.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is MessageOccurrenceSpecification or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-MessageOccurrenceSpecification" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:MessageOccurrenceSpecification' or $element/@xmi:type = 'uml:DestructionOccurrenceSpecification'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass OccurrenceSpecification.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is OccurrenceSpecification.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-OccurrenceSpecification" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:OccurrenceSpecification'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass OccurrenceSpecification.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is OccurrenceSpecification or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-OccurrenceSpecification" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:OccurrenceSpecification' or $element/@xmi:type = 'uml:ExecutionOccurrenceSpecification' or $element/@xmi:type = 'uml:MessageOccurrenceSpecification' or $element/@xmi:type = 'uml:DestructionOccurrenceSpecification'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass PartDecomposition.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is PartDecomposition.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-PartDecomposition" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:PartDecomposition'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass PartDecomposition.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is PartDecomposition or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-PartDecomposition" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:PartDecomposition'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass StateInvariant.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is StateInvariant.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-StateInvariant" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:StateInvariant'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass StateInvariant.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is StateInvariant or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-StateInvariant" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:StateInvariant'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass Extension.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is Extension.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-Extension" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:Extension'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass Extension.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is Extension or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-Extension" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:Extension'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass ExtensionEnd.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is ExtensionEnd.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-ExtensionEnd" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:ExtensionEnd'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass ExtensionEnd.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is ExtensionEnd or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-ExtensionEnd" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:ExtensionEnd'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass Image.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is Image.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-Image" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:Image'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass Image.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is Image or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-Image" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:Image'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass Model.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is Model.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-Model" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:Model'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass Model.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is Model or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-Model" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:Model'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass Package.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is Package.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-Package" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:Package'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass Package.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is Package or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-Package" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:Package' or $element/@xmi:type = 'uml:Model' or $element/@xmi:type = 'uml:Profile'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass PackageMerge.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is PackageMerge.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-PackageMerge" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:PackageMerge'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass PackageMerge.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is PackageMerge or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-PackageMerge" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:PackageMerge'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass Profile.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is Profile.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-Profile" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:Profile'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass Profile.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is Profile or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-Profile" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:Profile'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass ProfileApplication.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is ProfileApplication.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-ProfileApplication" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:ProfileApplication'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass ProfileApplication.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is ProfileApplication or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-ProfileApplication" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:ProfileApplication'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass Stereotype.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is Stereotype.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-Stereotype" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:Stereotype'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass Stereotype.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is Stereotype or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-Stereotype" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:Stereotype'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass BehavioredClassifier.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is BehavioredClassifier.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-BehavioredClassifier" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:BehavioredClassifier'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass BehavioredClassifier.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is BehavioredClassifier or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-BehavioredClassifier" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:BehavioredClassifier' or $element/@xmi:type = 'uml:Class' or $element/@xmi:type = 'uml:Behavior' or $element/@xmi:type = 'uml:Activity' or $element/@xmi:type = 'uml:OpaqueBehavior' or $element/@xmi:type = 'uml:FunctionBehavior' or $element/@xmi:type = 'uml:Interaction' or $element/@xmi:type = 'uml:StateMachine' or $element/@xmi:type = 'uml:ProtocolStateMachine' or $element/@xmi:type = 'uml:Node' or $element/@xmi:type = 'uml:Device' or $element/@xmi:type = 'uml:ExecutionEnvironment' or $element/@xmi:type = 'uml:Stereotype' or $element/@xmi:type = 'uml:AssociationClass' or $element/@xmi:type = 'uml:Component' or $element/@xmi:type = 'uml:Collaboration' or $element/@xmi:type = 'uml:Actor' or $element/@xmi:type = 'uml:UseCase'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass DataType.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is DataType.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-DataType" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:DataType'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass DataType.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is DataType or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-DataType" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:DataType' or $element/@xmi:type = 'uml:Enumeration' or $element/@xmi:type = 'uml:PrimitiveType'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass Enumeration.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is Enumeration.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-Enumeration" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:Enumeration'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass Enumeration.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is Enumeration or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-Enumeration" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:Enumeration'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass EnumerationLiteral.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is EnumerationLiteral.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-EnumerationLiteral" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:EnumerationLiteral'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass EnumerationLiteral.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is EnumerationLiteral or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-EnumerationLiteral" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:EnumerationLiteral'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass Interface.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is Interface.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-Interface" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:Interface'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass Interface.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is Interface or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-Interface" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:Interface'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass InterfaceRealization.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is InterfaceRealization.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-InterfaceRealization" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:InterfaceRealization'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass InterfaceRealization.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is InterfaceRealization or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-InterfaceRealization" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:InterfaceRealization'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass PrimitiveType.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is PrimitiveType.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-PrimitiveType" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:PrimitiveType'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass PrimitiveType.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is PrimitiveType or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-PrimitiveType" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:PrimitiveType'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass Reception.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is Reception.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-Reception" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:Reception'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass Reception.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is Reception or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-Reception" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:Reception'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass Signal.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is Signal.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-Signal" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:Signal'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass Signal.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is Signal or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-Signal" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:Signal'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass ConnectionPointReference.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is ConnectionPointReference.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-ConnectionPointReference" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:ConnectionPointReference'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass ConnectionPointReference.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is ConnectionPointReference or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-ConnectionPointReference" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:ConnectionPointReference'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass FinalState.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is FinalState.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-FinalState" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:FinalState'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass FinalState.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is FinalState or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-FinalState" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:FinalState'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass ProtocolConformance.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is ProtocolConformance.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-ProtocolConformance" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:ProtocolConformance'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass ProtocolConformance.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is ProtocolConformance or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-ProtocolConformance" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:ProtocolConformance'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass ProtocolStateMachine.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is ProtocolStateMachine.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-ProtocolStateMachine" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:ProtocolStateMachine'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass ProtocolStateMachine.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is ProtocolStateMachine or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-ProtocolStateMachine" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:ProtocolStateMachine'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass ProtocolTransition.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is ProtocolTransition.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-ProtocolTransition" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:ProtocolTransition'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass ProtocolTransition.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is ProtocolTransition or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-ProtocolTransition" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:ProtocolTransition'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass Pseudostate.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is Pseudostate.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-Pseudostate" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:Pseudostate'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass Pseudostate.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is Pseudostate or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-Pseudostate" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:Pseudostate'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass Region.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is Region.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-Region" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:Region'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass Region.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is Region or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-Region" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:Region'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass State.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is State.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-State" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:State'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass State.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is State or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-State" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:State' or $element/@xmi:type = 'uml:FinalState'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass StateMachine.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is StateMachine.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-StateMachine" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:StateMachine'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass StateMachine.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is StateMachine or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-StateMachine" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:StateMachine' or $element/@xmi:type = 'uml:ProtocolStateMachine'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass Transition.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is Transition.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-Transition" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:Transition'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass Transition.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is Transition or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-Transition" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:Transition' or $element/@xmi:type = 'uml:ProtocolTransition'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass Vertex.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is Vertex.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-Vertex" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:Vertex'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass Vertex.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is Vertex or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-Vertex" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:Vertex' or $element/@xmi:type = 'uml:ConnectionPointReference' or $element/@xmi:type = 'uml:Pseudostate' or $element/@xmi:type = 'uml:State' or $element/@xmi:type = 'uml:FinalState'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass Association.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is Association.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-Association" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:Association'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass Association.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is Association or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-Association" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:Association' or $element/@xmi:type = 'uml:CommunicationPath' or $element/@xmi:type = 'uml:Extension' or $element/@xmi:type = 'uml:AssociationClass'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass AssociationClass.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is AssociationClass.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-AssociationClass" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:AssociationClass'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass AssociationClass.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is AssociationClass or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-AssociationClass" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:AssociationClass'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass Class.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is Class.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-Class" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:Class'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass Class.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is Class or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-Class" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:Class' or $element/@xmi:type = 'uml:Behavior' or $element/@xmi:type = 'uml:Activity' or $element/@xmi:type = 'uml:OpaqueBehavior' or $element/@xmi:type = 'uml:FunctionBehavior' or $element/@xmi:type = 'uml:Interaction' or $element/@xmi:type = 'uml:StateMachine' or $element/@xmi:type = 'uml:ProtocolStateMachine' or $element/@xmi:type = 'uml:Node' or $element/@xmi:type = 'uml:Device' or $element/@xmi:type = 'uml:ExecutionEnvironment' or $element/@xmi:type = 'uml:Stereotype' or $element/@xmi:type = 'uml:AssociationClass' or $element/@xmi:type = 'uml:Component'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass Collaboration.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is Collaboration.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-Collaboration" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:Collaboration'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass Collaboration.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is Collaboration or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-Collaboration" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:Collaboration'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass CollaborationUse.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is CollaborationUse.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-CollaborationUse" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:CollaborationUse'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass CollaborationUse.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is CollaborationUse or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-CollaborationUse" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:CollaborationUse'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass Component.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is Component.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-Component" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:Component'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass Component.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is Component or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-Component" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:Component'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass ComponentRealization.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is ComponentRealization.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-ComponentRealization" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:ComponentRealization'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass ComponentRealization.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is ComponentRealization or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-ComponentRealization" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:ComponentRealization'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass ConnectableElement.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is ConnectableElement.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-ConnectableElement" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:ConnectableElement'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass ConnectableElement.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is ConnectableElement or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-ConnectableElement" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:ConnectableElement' or $element/@xmi:type = 'uml:Variable' or $element/@xmi:type = 'uml:Parameter' or $element/@xmi:type = 'uml:Property' or $element/@xmi:type = 'uml:ExtensionEnd' or $element/@xmi:type = 'uml:Port'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass ConnectableElementTemplateParameter.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is ConnectableElementTemplateParameter.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-ConnectableElementTemplateParameter" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:ConnectableElementTemplateParameter'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass ConnectableElementTemplateParameter.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is ConnectableElementTemplateParameter or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-ConnectableElementTemplateParameter"
                 as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:ConnectableElementTemplateParameter'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass Connector.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is Connector.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-Connector" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:Connector'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass Connector.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is Connector or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-Connector" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:Connector'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass ConnectorEnd.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is ConnectorEnd.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-ConnectorEnd" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:ConnectorEnd'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass ConnectorEnd.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is ConnectorEnd or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-ConnectorEnd" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:ConnectorEnd'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass EncapsulatedClassifier.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is EncapsulatedClassifier.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-EncapsulatedClassifier" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:EncapsulatedClassifier'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass EncapsulatedClassifier.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is EncapsulatedClassifier or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-EncapsulatedClassifier" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:EncapsulatedClassifier' or $element/@xmi:type = 'uml:Class' or $element/@xmi:type = 'uml:Behavior' or $element/@xmi:type = 'uml:Activity' or $element/@xmi:type = 'uml:OpaqueBehavior' or $element/@xmi:type = 'uml:FunctionBehavior' or $element/@xmi:type = 'uml:Interaction' or $element/@xmi:type = 'uml:StateMachine' or $element/@xmi:type = 'uml:ProtocolStateMachine' or $element/@xmi:type = 'uml:Node' or $element/@xmi:type = 'uml:Device' or $element/@xmi:type = 'uml:ExecutionEnvironment' or $element/@xmi:type = 'uml:Stereotype' or $element/@xmi:type = 'uml:AssociationClass' or $element/@xmi:type = 'uml:Component'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass Port.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is Port.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-Port" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:Port'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass Port.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is Port or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-Port" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:Port'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass StructuredClassifier.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is StructuredClassifier.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-StructuredClassifier" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:StructuredClassifier'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass StructuredClassifier.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is StructuredClassifier or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-StructuredClassifier" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:StructuredClassifier' or $element/@xmi:type = 'uml:Collaboration' or $element/@xmi:type = 'uml:EncapsulatedClassifier' or $element/@xmi:type = 'uml:Class' or $element/@xmi:type = 'uml:Behavior' or $element/@xmi:type = 'uml:Activity' or $element/@xmi:type = 'uml:OpaqueBehavior' or $element/@xmi:type = 'uml:FunctionBehavior' or $element/@xmi:type = 'uml:Interaction' or $element/@xmi:type = 'uml:StateMachine' or $element/@xmi:type = 'uml:ProtocolStateMachine' or $element/@xmi:type = 'uml:Node' or $element/@xmi:type = 'uml:Device' or $element/@xmi:type = 'uml:ExecutionEnvironment' or $element/@xmi:type = 'uml:Stereotype' or $element/@xmi:type = 'uml:AssociationClass' or $element/@xmi:type = 'uml:Component'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass Actor.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is Actor.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-Actor" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:Actor'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass Actor.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is Actor or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-Actor" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:Actor'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass Extend.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is Extend.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-Extend" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:Extend'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass Extend.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is Extend or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-Extend" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:Extend'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass ExtensionPoint.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is ExtensionPoint.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-ExtensionPoint" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:ExtensionPoint'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass ExtensionPoint.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is ExtensionPoint or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-ExtensionPoint" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:ExtensionPoint'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass Include.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is Include.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-Include" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:Include'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass Include.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is Include or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-Include" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:Include'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass UseCase.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is UseCase.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-UseCase" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:UseCase'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass UseCase.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is UseCase or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-UseCase" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:UseCase'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass Duration.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is Duration.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-Duration" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:Duration'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass Duration.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is Duration or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-Duration" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:Duration'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass DurationConstraint.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is DurationConstraint.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-DurationConstraint" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:DurationConstraint'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass DurationConstraint.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is DurationConstraint or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-DurationConstraint" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:DurationConstraint'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass DurationInterval.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is DurationInterval.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-DurationInterval" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:DurationInterval'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass DurationInterval.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is DurationInterval or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-DurationInterval" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:DurationInterval'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass DurationObservation.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is DurationObservation.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-DurationObservation" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:DurationObservation'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass DurationObservation.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is DurationObservation or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-DurationObservation" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:DurationObservation'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass Expression.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is Expression.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-Expression" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:Expression'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass Expression.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is Expression or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-Expression" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:Expression' or $element/@xmi:type = 'uml:StringExpression'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass Interval.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is Interval.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-Interval" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:Interval'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass Interval.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is Interval or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-Interval" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:Interval' or $element/@xmi:type = 'uml:DurationInterval' or $element/@xmi:type = 'uml:TimeInterval'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass IntervalConstraint.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is IntervalConstraint.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-IntervalConstraint" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:IntervalConstraint'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass IntervalConstraint.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is IntervalConstraint or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-IntervalConstraint" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:IntervalConstraint' or $element/@xmi:type = 'uml:DurationConstraint' or $element/@xmi:type = 'uml:TimeConstraint'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass LiteralBoolean.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is LiteralBoolean.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-LiteralBoolean" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:LiteralBoolean'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass LiteralBoolean.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is LiteralBoolean or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-LiteralBoolean" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:LiteralBoolean'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass LiteralInteger.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is LiteralInteger.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-LiteralInteger" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:LiteralInteger'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass LiteralInteger.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is LiteralInteger or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-LiteralInteger" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:LiteralInteger'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass LiteralNull.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is LiteralNull.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-LiteralNull" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:LiteralNull'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass LiteralNull.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is LiteralNull or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-LiteralNull" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:LiteralNull'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass LiteralReal.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is LiteralReal.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-LiteralReal" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:LiteralReal'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass LiteralReal.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is LiteralReal or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-LiteralReal" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:LiteralReal'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass LiteralSpecification.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is LiteralSpecification.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-LiteralSpecification" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:LiteralSpecification'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass LiteralSpecification.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is LiteralSpecification or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-LiteralSpecification" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:LiteralSpecification' or $element/@xmi:type = 'uml:LiteralBoolean' or $element/@xmi:type = 'uml:LiteralInteger' or $element/@xmi:type = 'uml:LiteralNull' or $element/@xmi:type = 'uml:LiteralReal' or $element/@xmi:type = 'uml:LiteralString' or $element/@xmi:type = 'uml:LiteralUnlimitedNatural'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass LiteralString.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is LiteralString.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-LiteralString" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:LiteralString'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass LiteralString.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is LiteralString or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-LiteralString" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:LiteralString'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass LiteralUnlimitedNatural.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is LiteralUnlimitedNatural.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-LiteralUnlimitedNatural" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:LiteralUnlimitedNatural'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass LiteralUnlimitedNatural.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is LiteralUnlimitedNatural or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-LiteralUnlimitedNatural" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:LiteralUnlimitedNatural'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass Observation.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is Observation.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-Observation" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:Observation'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass Observation.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is Observation or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-Observation" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:Observation' or $element/@xmi:type = 'uml:DurationObservation' or $element/@xmi:type = 'uml:TimeObservation'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass OpaqueExpression.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is OpaqueExpression.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-OpaqueExpression" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:OpaqueExpression'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass OpaqueExpression.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is OpaqueExpression or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-OpaqueExpression" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:OpaqueExpression'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass StringExpression.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is StringExpression.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-StringExpression" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:StringExpression'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass StringExpression.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is StringExpression or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-StringExpression" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:StringExpression'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass TimeConstraint.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is TimeConstraint.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-TimeConstraint" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:TimeConstraint'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass TimeConstraint.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is TimeConstraint or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-TimeConstraint" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:TimeConstraint'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass TimeExpression.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is TimeExpression.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-TimeExpression" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:TimeExpression'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass TimeExpression.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is TimeExpression or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-TimeExpression" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:TimeExpression'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass TimeInterval.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is TimeInterval.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-TimeInterval" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:TimeInterval'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass TimeInterval.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is TimeInterval or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-TimeInterval" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:TimeInterval'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass TimeObservation.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is TimeObservation.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-TimeObservation" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:TimeObservation'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass TimeObservation.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is TimeObservation or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-TimeObservation" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:TimeObservation'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass ValueSpecification.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is ValueSpecification.</xd:return>
   </xd:doc>
   <xsl:function name="uml:is-ValueSpecification" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:ValueSpecification'"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Type check function for UML metaclass ValueSpecification.</xd:desc>
      <xd:param name="element">Element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>True if the actual type of <xd:ref type="param" name="element"/> is ValueSpecification or one of its subtypes.</xd:return>
   </xd:doc>
   <xsl:function name="uml:conforms-to-ValueSpecification" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="$element/@xmi:type = 'uml:ValueSpecification' or $element/@xmi:type = 'uml:InstanceValue' or $element/@xmi:type = 'uml:Duration' or $element/@xmi:type = 'uml:Expression' or $element/@xmi:type = 'uml:StringExpression' or $element/@xmi:type = 'uml:Interval' or $element/@xmi:type = 'uml:DurationInterval' or $element/@xmi:type = 'uml:TimeInterval' or $element/@xmi:type = 'uml:LiteralSpecification' or $element/@xmi:type = 'uml:LiteralBoolean' or $element/@xmi:type = 'uml:LiteralInteger' or $element/@xmi:type = 'uml:LiteralNull' or $element/@xmi:type = 'uml:LiteralReal' or $element/@xmi:type = 'uml:LiteralString' or $element/@xmi:type = 'uml:LiteralUnlimitedNatural' or $element/@xmi:type = 'uml:OpaqueExpression' or $element/@xmi:type = 'uml:TimeExpression'"/>
   </xsl:function>
   <xsl:function name="uml:resolve-variable" as="element()*">
      <xsl:param name="element-with-variable" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-variable/@variable,$element-with-variable/variable)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-isUnmarshall" as="element()*">
      <xsl:param name="element-with-isUnmarshall" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-isUnmarshall/@isUnmarshall,$element-with-isUnmarshall/isUnmarshall)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-isLocallyReentrant" as="element()*">
      <xsl:param name="element-with-isLocallyReentrant" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-isLocallyReentrant/@isLocallyReentrant,$element-with-isLocallyReentrant/isLocallyReentrant)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-isReplaceAll" as="element()*">
      <xsl:param name="element-with-isReplaceAll" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-isReplaceAll/@isReplaceAll,$element-with-isReplaceAll/isReplaceAll)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-signal" as="element()*">
      <xsl:param name="element-with-signal" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-signal/@signal,$element-with-signal/signal)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-isSynchronous" as="element()*">
      <xsl:param name="element-with-isSynchronous" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-isSynchronous/@isSynchronous,$element-with-isSynchronous/isSynchronous)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-behavior" as="element()*">
      <xsl:param name="element-with-behavior" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-behavior/@behavior,$element-with-behavior/behavior)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-operation" as="element()*">
      <xsl:param name="element-with-operation" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-operation/@operation,$element-with-operation/operation)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-body" as="element()*">
      <xsl:param name="element-with-body" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-body/@body,$element-with-body/body)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-bodyOutput" as="element()*">
      <xsl:param name="element-with-bodyOutput" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-bodyOutput/@bodyOutput,$element-with-bodyOutput/bodyOutput)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-decider" as="element()*">
      <xsl:param name="element-with-decider" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-decider/@decider,$element-with-decider/decider)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-predecessorClause" as="element()*">
      <xsl:param name="element-with-predecessorClause" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-predecessorClause/@predecessorClause,$element-with-predecessorClause/predecessorClause)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-successorClause" as="element()*">
      <xsl:param name="element-with-successorClause" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-successorClause/@successorClause,$element-with-successorClause/successorClause)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-test" as="element()*">
      <xsl:param name="element-with-test" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-test/@test,$element-with-test/test)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-association" as="element()*">
      <xsl:param name="element-with-association" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-association/@association,$element-with-association/association)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-isAssured" as="element()*">
      <xsl:param name="element-with-isAssured" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-isAssured/@isAssured,$element-with-isAssured/isAssured)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-isDeterminate" as="element()*">
      <xsl:param name="element-with-isDeterminate" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-isDeterminate/@isDeterminate,$element-with-isDeterminate/isDeterminate)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-classifier" as="element()*">
      <xsl:param name="element-with-classifier" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-classifier/@classifier,$element-with-classifier/classifier)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-isDestroyLinks" as="element()*">
      <xsl:param name="element-with-isDestroyLinks" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-isDestroyLinks/@isDestroyLinks,$element-with-isDestroyLinks/isDestroyLinks)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-isDestroyOwnedObjects" as="element()*">
      <xsl:param name="element-with-isDestroyOwnedObjects" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-isDestroyOwnedObjects/@isDestroyOwnedObjects,$element-with-isDestroyOwnedObjects/isDestroyOwnedObjects)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-regionAsInput" as="element()*">
      <xsl:param name="element-with-regionAsInput" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-regionAsInput/@regionAsInput,$element-with-regionAsInput/regionAsInput)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-regionAsOutput" as="element()*">
      <xsl:param name="element-with-regionAsOutput" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-regionAsOutput/@regionAsOutput,$element-with-regionAsOutput/regionAsOutput)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-inputElement" as="element()*">
      <xsl:param name="element-with-inputElement" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-inputElement/@inputElement,$element-with-inputElement/inputElement)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-mode" as="element()*">
      <xsl:param name="element-with-mode" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-mode/@mode,$element-with-mode/mode)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-outputElement" as="element()*">
      <xsl:param name="element-with-outputElement" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-outputElement/@outputElement,$element-with-outputElement/outputElement)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-onPort" as="element()*">
      <xsl:param name="element-with-onPort" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-onPort/@onPort,$element-with-onPort/onPort)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-insertAt" as="element()*">
      <xsl:param name="element-with-insertAt" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-insertAt/@insertAt,$element-with-insertAt/insertAt)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-end" as="element()*">
      <xsl:param name="element-with-end" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-end/@end,$element-with-end/end)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-value" as="element()*">
      <xsl:param name="element-with-value" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-value/@value,$element-with-value/value)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-destroyAt" as="element()*">
      <xsl:param name="element-with-destroyAt" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-destroyAt/@destroyAt,$element-with-destroyAt/destroyAt)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-isDestroyDuplicates" as="element()*">
      <xsl:param name="element-with-isDestroyDuplicates" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-isDestroyDuplicates/@isDestroyDuplicates,$element-with-isDestroyDuplicates/isDestroyDuplicates)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-bodyPart" as="element()*">
      <xsl:param name="element-with-bodyPart" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-bodyPart/@bodyPart,$element-with-bodyPart/bodyPart)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-isTestedFirst" as="element()*">
      <xsl:param name="element-with-isTestedFirst" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-isTestedFirst/@isTestedFirst,$element-with-isTestedFirst/isTestedFirst)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-setupPart" as="element()*">
      <xsl:param name="element-with-setupPart" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-setupPart/@setupPart,$element-with-setupPart/setupPart)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-language" as="element()*">
      <xsl:param name="element-with-language" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-language/@language,$element-with-language/language)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-isControl" as="element()*">
      <xsl:param name="element-with-isControl" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-isControl/@isControl,$element-with-isControl/isControl)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-qualifier" as="element()*">
      <xsl:param name="element-with-qualifier" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-qualifier/@qualifier,$element-with-qualifier/qualifier)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-isDirect" as="element()*">
      <xsl:param name="element-with-isDirect" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-isDirect/@isDirect,$element-with-isDirect/isDirect)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-newClassifier" as="element()*">
      <xsl:param name="element-with-newClassifier" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-newClassifier/@newClassifier,$element-with-newClassifier/newClassifier)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-oldClassifier" as="element()*">
      <xsl:param name="element-with-oldClassifier" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-oldClassifier/@oldClassifier,$element-with-oldClassifier/oldClassifier)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-isOrdered" as="element()*">
      <xsl:param name="element-with-isOrdered" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-isOrdered/@isOrdered,$element-with-isOrdered/isOrdered)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-reducer" as="element()*">
      <xsl:param name="element-with-reducer" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-reducer/@reducer,$element-with-reducer/reducer)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-isRemoveDuplicates" as="element()*">
      <xsl:param name="element-with-isRemoveDuplicates" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-isRemoveDuplicates/@isRemoveDuplicates,$element-with-isRemoveDuplicates/isRemoveDuplicates)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-replyToCall" as="element()*">
      <xsl:param name="element-with-replyToCall" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-replyToCall/@replyToCall,$element-with-replyToCall/replyToCall)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-structuralFeature" as="element()*">
      <xsl:param name="element-with-structuralFeature" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-structuralFeature/@structuralFeature,$element-with-structuralFeature/structuralFeature)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-mustIsolate" as="element()*">
      <xsl:param name="element-with-mustIsolate" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-mustIsolate/@mustIsolate,$element-with-mustIsolate/mustIsolate)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-unmarshallType" as="element()*">
      <xsl:param name="element-with-unmarshallType" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-unmarshallType/@unmarshallType,$element-with-unmarshallType/unmarshallType)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-isReadOnly" as="element()*">
      <xsl:param name="element-with-isReadOnly" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-isReadOnly/@isReadOnly,$element-with-isReadOnly/isReadOnly)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-isSingleExecution" as="element()*">
      <xsl:param name="element-with-isSingleExecution" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-isSingleExecution/@isSingleExecution,$element-with-isSingleExecution/isSingleExecution)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-partition" as="element()*">
      <xsl:param name="element-with-partition" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-partition/@partition,$element-with-partition/partition)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-activity" as="element()*">
      <xsl:param name="element-with-activity" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-activity/@activity,$element-with-activity/activity)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-inPartition" as="element()*">
      <xsl:param name="element-with-inPartition" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-inPartition/@inPartition,$element-with-inPartition/inPartition)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-inStructuredNode" as="element()*">
      <xsl:param name="element-with-inStructuredNode" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-inStructuredNode/@inStructuredNode,$element-with-inStructuredNode/inStructuredNode)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-interrupts" as="element()*">
      <xsl:param name="element-with-interrupts" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-interrupts/@interrupts,$element-with-interrupts/interrupts)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-redefinedEdge" as="element()*">
      <xsl:param name="element-with-redefinedEdge" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-redefinedEdge/@redefinedEdge,$element-with-redefinedEdge/redefinedEdge)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-source" as="element()*">
      <xsl:param name="element-with-source" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-source/@source,$element-with-source/source)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-target" as="element()*">
      <xsl:param name="element-with-target" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-target/@target,$element-with-target/target)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-inActivity" as="element()*">
      <xsl:param name="element-with-inActivity" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-inActivity/@inActivity,$element-with-inActivity/inActivity)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-inInterruptibleRegion" as="element()*">
      <xsl:param name="element-with-inInterruptibleRegion" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-inInterruptibleRegion/@inInterruptibleRegion,$element-with-inInterruptibleRegion/inInterruptibleRegion)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-incoming" as="element()*">
      <xsl:param name="element-with-incoming" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-incoming/@incoming,$element-with-incoming/incoming)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-outgoing" as="element()*">
      <xsl:param name="element-with-outgoing" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-outgoing/@outgoing,$element-with-outgoing/outgoing)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-redefinedNode" as="element()*">
      <xsl:param name="element-with-redefinedNode" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-redefinedNode/@redefinedNode,$element-with-redefinedNode/redefinedNode)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-parameter" as="element()*">
      <xsl:param name="element-with-parameter" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-parameter/@parameter,$element-with-parameter/parameter)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-edge" as="element()*">
      <xsl:param name="element-with-edge" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-edge/@edge,$element-with-edge/edge)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-isDimension" as="element()*">
      <xsl:param name="element-with-isDimension" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-isDimension/@isDimension,$element-with-isDimension/isDimension)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-isExternal" as="element()*">
      <xsl:param name="element-with-isExternal" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-isExternal/@isExternal,$element-with-isExternal/isExternal)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-node" as="element()*">
      <xsl:param name="element-with-node" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-node/@node,$element-with-node/node)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-represents" as="element()*">
      <xsl:param name="element-with-represents" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-represents/@represents,$element-with-represents/represents)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-superPartition" as="element()*">
      <xsl:param name="element-with-superPartition" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-superPartition/@superPartition,$element-with-superPartition/superPartition)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-decisionInput" as="element()*">
      <xsl:param name="element-with-decisionInput" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-decisionInput/@decisionInput,$element-with-decisionInput/decisionInput)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-decisionInputFlow" as="element()*">
      <xsl:param name="element-with-decisionInputFlow" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-decisionInputFlow/@decisionInputFlow,$element-with-decisionInputFlow/decisionInputFlow)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-exceptionInput" as="element()*">
      <xsl:param name="element-with-exceptionInput" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-exceptionInput/@exceptionInput,$element-with-exceptionInput/exceptionInput)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-exceptionType" as="element()*">
      <xsl:param name="element-with-exceptionType" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-exceptionType/@exceptionType,$element-with-exceptionType/exceptionType)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-handlerBody" as="element()*">
      <xsl:param name="element-with-handlerBody" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-handlerBody/@handlerBody,$element-with-handlerBody/handlerBody)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-protectedNode" as="element()*">
      <xsl:param name="element-with-protectedNode" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-protectedNode/@protectedNode,$element-with-protectedNode/protectedNode)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-interruptingEdge" as="element()*">
      <xsl:param name="element-with-interruptingEdge" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-interruptingEdge/@interruptingEdge,$element-with-interruptingEdge/interruptingEdge)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-isCombineDuplicate" as="element()*">
      <xsl:param name="element-with-isCombineDuplicate" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-isCombineDuplicate/@isCombineDuplicate,$element-with-isCombineDuplicate/isCombineDuplicate)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-isMulticast" as="element()*">
      <xsl:param name="element-with-isMulticast" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-isMulticast/@isMulticast,$element-with-isMulticast/isMulticast)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-isMultireceive" as="element()*">
      <xsl:param name="element-with-isMultireceive" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-isMultireceive/@isMultireceive,$element-with-isMultireceive/isMultireceive)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-selection" as="element()*">
      <xsl:param name="element-with-selection" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-selection/@selection,$element-with-selection/selection)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-transformation" as="element()*">
      <xsl:param name="element-with-transformation" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-transformation/@transformation,$element-with-transformation/transformation)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-inState" as="element()*">
      <xsl:param name="element-with-inState" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-inState/@inState,$element-with-inState/inState)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-isControlType" as="element()*">
      <xsl:param name="element-with-isControlType" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-isControlType/@isControlType,$element-with-isControlType/isControlType)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-ordering" as="element()*">
      <xsl:param name="element-with-ordering" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-ordering/@ordering,$element-with-ordering/ordering)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-activityScope" as="element()*">
      <xsl:param name="element-with-activityScope" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-activityScope/@activityScope,$element-with-activityScope/activityScope)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-scope" as="element()*">
      <xsl:param name="element-with-scope" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-scope/@scope,$element-with-scope/scope)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-contract" as="element()*">
      <xsl:param name="element-with-contract" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-contract/@contract,$element-with-contract/contract)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-substitutingClassifier" as="element()*">
      <xsl:param name="element-with-substitutingClassifier" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-substitutingClassifier/@substitutingClassifier,$element-with-substitutingClassifier/substitutingClassifier)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-concurrency" as="element()*">
      <xsl:param name="element-with-concurrency" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-concurrency/@concurrency,$element-with-concurrency/concurrency)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-isAbstract" as="element()*">
      <xsl:param name="element-with-isAbstract" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-isAbstract/@isAbstract,$element-with-isAbstract/isAbstract)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-method" as="element()*">
      <xsl:param name="element-with-method" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-method/@method,$element-with-method/method)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-raisedException" as="element()*">
      <xsl:param name="element-with-raisedException" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-raisedException/@raisedException,$element-with-raisedException/raisedException)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-isFinalSpecialization" as="element()*">
      <xsl:param name="element-with-isFinalSpecialization" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-isFinalSpecialization/@isFinalSpecialization,$element-with-isFinalSpecialization/isFinalSpecialization)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-powertypeExtent" as="element()*">
      <xsl:param name="element-with-powertypeExtent" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-powertypeExtent/@powertypeExtent,$element-with-powertypeExtent/powertypeExtent)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-redefinedClassifier" as="element()*">
      <xsl:param name="element-with-redefinedClassifier" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-redefinedClassifier/@redefinedClassifier,$element-with-redefinedClassifier/redefinedClassifier)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-representation" as="element()*">
      <xsl:param name="element-with-representation" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-representation/@representation,$element-with-representation/representation)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-templateParameter" as="element()*">
      <xsl:param name="element-with-templateParameter" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-templateParameter/@templateParameter,$element-with-templateParameter/templateParameter)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-useCase" as="element()*">
      <xsl:param name="element-with-useCase" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-useCase/@useCase,$element-with-useCase/useCase)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-allowSubstitutable" as="element()*">
      <xsl:param name="element-with-allowSubstitutable" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-allowSubstitutable/@allowSubstitutable,$element-with-allowSubstitutable/allowSubstitutable)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-constrainingClassifier" as="element()*">
      <xsl:param name="element-with-constrainingClassifier" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-constrainingClassifier/@constrainingClassifier,$element-with-constrainingClassifier/constrainingClassifier)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-parameteredElement" as="element()*">
      <xsl:param name="element-with-parameteredElement" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-parameteredElement/@parameteredElement,$element-with-parameteredElement/parameteredElement)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-isStatic" as="element()*">
      <xsl:param name="element-with-isStatic" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-isStatic/@isStatic,$element-with-isStatic/isStatic)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-general" as="element()*">
      <xsl:param name="element-with-general" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-general/@general,$element-with-general/general)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-generalizationSet" as="element()*">
      <xsl:param name="element-with-generalizationSet" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-generalizationSet/@generalizationSet,$element-with-generalizationSet/generalizationSet)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-isSubstitutable" as="element()*">
      <xsl:param name="element-with-isSubstitutable" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-isSubstitutable/@isSubstitutable,$element-with-isSubstitutable/isSubstitutable)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-specific" as="element()*">
      <xsl:param name="element-with-specific" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-specific/@specific,$element-with-specific/specific)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-generalization" as="element()*">
      <xsl:param name="element-with-generalization" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-generalization/@generalization,$element-with-generalization/generalization)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-isCovering" as="element()*">
      <xsl:param name="element-with-isCovering" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-isCovering/@isCovering,$element-with-isCovering/isCovering)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-isDisjoint" as="element()*">
      <xsl:param name="element-with-isDisjoint" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-isDisjoint/@isDisjoint,$element-with-isDisjoint/isDisjoint)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-powertype" as="element()*">
      <xsl:param name="element-with-powertype" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-powertype/@powertype,$element-with-powertype/powertype)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-instance" as="element()*">
      <xsl:param name="element-with-instance" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-instance/@instance,$element-with-instance/instance)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-class" as="element()*">
      <xsl:param name="element-with-class" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-class/@class,$element-with-class/class)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-datatype" as="element()*">
      <xsl:param name="element-with-datatype" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-datatype/@datatype,$element-with-datatype/datatype)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-interface" as="element()*">
      <xsl:param name="element-with-interface" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-interface/@interface,$element-with-interface/interface)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-isQuery" as="element()*">
      <xsl:param name="element-with-isQuery" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-isQuery/@isQuery,$element-with-isQuery/isQuery)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-redefinedOperation" as="element()*">
      <xsl:param name="element-with-redefinedOperation" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-redefinedOperation/@redefinedOperation,$element-with-redefinedOperation/redefinedOperation)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-direction" as="element()*">
      <xsl:param name="element-with-direction" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-direction/@direction,$element-with-direction/direction)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-effect" as="element()*">
      <xsl:param name="element-with-effect" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-effect/@effect,$element-with-effect/effect)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-isException" as="element()*">
      <xsl:param name="element-with-isException" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-isException/@isException,$element-with-isException/isException)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-isStream" as="element()*">
      <xsl:param name="element-with-isStream" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-isStream/@isStream,$element-with-isStream/isStream)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-parameterSet" as="element()*">
      <xsl:param name="element-with-parameterSet" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-parameterSet/@parameterSet,$element-with-parameterSet/parameterSet)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-aggregation" as="element()*">
      <xsl:param name="element-with-aggregation" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-aggregation/@aggregation,$element-with-aggregation/aggregation)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-associationEnd" as="element()*">
      <xsl:param name="element-with-associationEnd" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-associationEnd/@associationEnd,$element-with-associationEnd/associationEnd)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-isDerived" as="element()*">
      <xsl:param name="element-with-isDerived" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-isDerived/@isDerived,$element-with-isDerived/isDerived)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-isDerivedUnion" as="element()*">
      <xsl:param name="element-with-isDerivedUnion" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-isDerivedUnion/@isDerivedUnion,$element-with-isDerivedUnion/isDerivedUnion)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-isID" as="element()*">
      <xsl:param name="element-with-isID" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-isID/@isID,$element-with-isID/isID)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-owningAssociation" as="element()*">
      <xsl:param name="element-with-owningAssociation" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-owningAssociation/@owningAssociation,$element-with-owningAssociation/owningAssociation)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-redefinedProperty" as="element()*">
      <xsl:param name="element-with-redefinedProperty" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-redefinedProperty/@redefinedProperty,$element-with-redefinedProperty/redefinedProperty)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-subsettedProperty" as="element()*">
      <xsl:param name="element-with-subsettedProperty" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-subsettedProperty/@subsettedProperty,$element-with-subsettedProperty/subsettedProperty)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-isLeaf" as="element()*">
      <xsl:param name="element-with-isLeaf" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-isLeaf/@isLeaf,$element-with-isLeaf/isLeaf)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-extendedSignature" as="element()*">
      <xsl:param name="element-with-extendedSignature" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-extendedSignature/@extendedSignature,$element-with-extendedSignature/extendedSignature)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-definingFeature" as="element()*">
      <xsl:param name="element-with-definingFeature" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-definingFeature/@definingFeature,$element-with-definingFeature/definingFeature)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-owningInstance" as="element()*">
      <xsl:param name="element-with-owningInstance" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-owningInstance/@owningInstance,$element-with-owningInstance/owningInstance)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-isReentrant" as="element()*">
      <xsl:param name="element-with-isReentrant" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-isReentrant/@isReentrant,$element-with-isReentrant/isReentrant)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-specification" as="element()*">
      <xsl:param name="element-with-specification" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-specification/@specification,$element-with-specification/specification)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-redefinedBehavior" as="element()*">
      <xsl:param name="element-with-redefinedBehavior" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-redefinedBehavior/@redefinedBehavior,$element-with-redefinedBehavior/redefinedBehavior)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-isRelative" as="element()*">
      <xsl:param name="element-with-isRelative" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-isRelative/@isRelative,$element-with-isRelative/isRelative)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-event" as="element()*">
      <xsl:param name="element-with-event" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-event/@event,$element-with-event/event)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-port" as="element()*">
      <xsl:param name="element-with-port" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-port/@port,$element-with-port/port)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-annotatedElement" as="element()*">
      <xsl:param name="element-with-annotatedElement" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-annotatedElement/@annotatedElement,$element-with-annotatedElement/annotatedElement)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-constrainedElement" as="element()*">
      <xsl:param name="element-with-constrainedElement" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-constrainedElement/@constrainedElement,$element-with-constrainedElement/constrainedElement)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-context" as="element()*">
      <xsl:param name="element-with-context" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-context/@context,$element-with-context/context)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-client" as="element()*">
      <xsl:param name="element-with-client" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-client/@client,$element-with-client/client)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-supplier" as="element()*">
      <xsl:param name="element-with-supplier" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-supplier/@supplier,$element-with-supplier/supplier)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-alias" as="element()*">
      <xsl:param name="element-with-alias" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-alias/@alias,$element-with-alias/alias)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-importedElement" as="element()*">
      <xsl:param name="element-with-importedElement" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-importedElement/@importedElement,$element-with-importedElement/importedElement)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-importingNamespace" as="element()*">
      <xsl:param name="element-with-importingNamespace" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-importingNamespace/@importingNamespace,$element-with-importingNamespace/importingNamespace)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-visibility" as="element()*">
      <xsl:param name="element-with-visibility" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-visibility/@visibility,$element-with-visibility/visibility)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-isUnique" as="element()*">
      <xsl:param name="element-with-isUnique" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-isUnique/@isUnique,$element-with-isUnique/isUnique)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-name" as="element()*">
      <xsl:param name="element-with-name" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-name/@name,$element-with-name/name)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-importedPackage" as="element()*">
      <xsl:param name="element-with-importedPackage" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-importedPackage/@importedPackage,$element-with-importedPackage/importedPackage)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-owningTemplateParameter" as="element()*">
      <xsl:param name="element-with-owningTemplateParameter" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-owningTemplateParameter/@owningTemplateParameter,$element-with-owningTemplateParameter/owningTemplateParameter)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-boundElement" as="element()*">
      <xsl:param name="element-with-boundElement" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-boundElement/@boundElement,$element-with-boundElement/boundElement)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-signature" as="element()*">
      <xsl:param name="element-with-signature" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-signature/@signature,$element-with-signature/signature)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-default" as="element()*">
      <xsl:param name="element-with-default" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-default/@default,$element-with-default/default)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-actual" as="element()*">
      <xsl:param name="element-with-actual" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-actual/@actual,$element-with-actual/actual)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-formal" as="element()*">
      <xsl:param name="element-with-formal" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-formal/@formal,$element-with-formal/formal)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-templateBinding" as="element()*">
      <xsl:param name="element-with-templateBinding" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-templateBinding/@templateBinding,$element-with-templateBinding/templateBinding)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-template" as="element()*">
      <xsl:param name="element-with-template" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-template/@template,$element-with-template/template)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-package" as="element()*">
      <xsl:param name="element-with-package" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-package/@package,$element-with-package/package)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-type" as="element()*">
      <xsl:param name="element-with-type" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-type/@type,$element-with-type/type)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-fileName" as="element()*">
      <xsl:param name="element-with-fileName" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-fileName/@fileName,$element-with-fileName/fileName)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-deployedArtifact" as="element()*">
      <xsl:param name="element-with-deployedArtifact" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-deployedArtifact/@deployedArtifact,$element-with-deployedArtifact/deployedArtifact)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-location" as="element()*">
      <xsl:param name="element-with-location" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-location/@location,$element-with-location/location)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-deployment" as="element()*">
      <xsl:param name="element-with-deployment" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-deployment/@deployment,$element-with-deployment/deployment)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-deploymentLocation" as="element()*">
      <xsl:param name="element-with-deploymentLocation" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-deploymentLocation/@deploymentLocation,$element-with-deploymentLocation/deploymentLocation)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-executionLocation" as="element()*">
      <xsl:param name="element-with-executionLocation" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-executionLocation/@executionLocation,$element-with-executionLocation/executionLocation)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-utilizedElement" as="element()*">
      <xsl:param name="element-with-utilizedElement" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-utilizedElement/@utilizedElement,$element-with-utilizedElement/utilizedElement)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-conveyed" as="element()*">
      <xsl:param name="element-with-conveyed" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-conveyed/@conveyed,$element-with-conveyed/conveyed)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-informationSource" as="element()*">
      <xsl:param name="element-with-informationSource" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-informationSource/@informationSource,$element-with-informationSource/informationSource)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-informationTarget" as="element()*">
      <xsl:param name="element-with-informationTarget" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-informationTarget/@informationTarget,$element-with-informationTarget/informationTarget)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-realization" as="element()*">
      <xsl:param name="element-with-realization" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-realization/@realization,$element-with-realization/realization)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-realizingActivityEdge" as="element()*">
      <xsl:param name="element-with-realizingActivityEdge" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-realizingActivityEdge/@realizingActivityEdge,$element-with-realizingActivityEdge/realizingActivityEdge)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-realizingConnector" as="element()*">
      <xsl:param name="element-with-realizingConnector" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-realizingConnector/@realizingConnector,$element-with-realizingConnector/realizingConnector)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-realizingMessage" as="element()*">
      <xsl:param name="element-with-realizingMessage" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-realizingMessage/@realizingMessage,$element-with-realizingMessage/realizingMessage)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-represented" as="element()*">
      <xsl:param name="element-with-represented" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-represented/@represented,$element-with-represented/represented)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-action" as="element()*">
      <xsl:param name="element-with-action" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-action/@action,$element-with-action/action)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-interactionOperator" as="element()*">
      <xsl:param name="element-with-interactionOperator" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-interactionOperator/@interactionOperator,$element-with-interactionOperator/interactionOperator)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-message" as="element()*">
      <xsl:param name="element-with-message" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-message/@message,$element-with-message/message)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-setting" as="element()*">
      <xsl:param name="element-with-setting" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-setting/@setting,$element-with-setting/setting)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-execution" as="element()*">
      <xsl:param name="element-with-execution" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-execution/@execution,$element-with-execution/execution)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-finish" as="element()*">
      <xsl:param name="element-with-finish" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-finish/@finish,$element-with-finish/finish)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-start" as="element()*">
      <xsl:param name="element-with-start" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-start/@start,$element-with-start/start)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-after" as="element()*">
      <xsl:param name="element-with-after" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-after/@after,$element-with-after/after)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-before" as="element()*">
      <xsl:param name="element-with-before" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-before/@before,$element-with-before/before)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-covered" as="element()*">
      <xsl:param name="element-with-covered" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-covered/@covered,$element-with-covered/covered)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-enclosingInteraction" as="element()*">
      <xsl:param name="element-with-enclosingInteraction" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-enclosingInteraction/@enclosingInteraction,$element-with-enclosingInteraction/enclosingInteraction)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-enclosingOperand" as="element()*">
      <xsl:param name="element-with-enclosingOperand" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-enclosingOperand/@enclosingOperand,$element-with-enclosingOperand/enclosingOperand)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-refersTo" as="element()*">
      <xsl:param name="element-with-refersTo" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-refersTo/@refersTo,$element-with-refersTo/refersTo)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-returnValueRecipient" as="element()*">
      <xsl:param name="element-with-returnValueRecipient" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-returnValueRecipient/@returnValueRecipient,$element-with-returnValueRecipient/returnValueRecipient)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-coveredBy" as="element()*">
      <xsl:param name="element-with-coveredBy" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-coveredBy/@coveredBy,$element-with-coveredBy/coveredBy)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-decomposedAs" as="element()*">
      <xsl:param name="element-with-decomposedAs" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-decomposedAs/@decomposedAs,$element-with-decomposedAs/decomposedAs)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-interaction" as="element()*">
      <xsl:param name="element-with-interaction" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-interaction/@interaction,$element-with-interaction/interaction)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-connector" as="element()*">
      <xsl:param name="element-with-connector" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-connector/@connector,$element-with-connector/connector)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-messageSort" as="element()*">
      <xsl:param name="element-with-messageSort" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-messageSort/@messageSort,$element-with-messageSort/messageSort)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-receiveEvent" as="element()*">
      <xsl:param name="element-with-receiveEvent" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-receiveEvent/@receiveEvent,$element-with-receiveEvent/receiveEvent)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-sendEvent" as="element()*">
      <xsl:param name="element-with-sendEvent" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-sendEvent/@sendEvent,$element-with-sendEvent/sendEvent)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-toAfter" as="element()*">
      <xsl:param name="element-with-toAfter" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-toAfter/@toAfter,$element-with-toAfter/toAfter)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-toBefore" as="element()*">
      <xsl:param name="element-with-toBefore" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-toBefore/@toBefore,$element-with-toBefore/toBefore)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-content" as="element()*">
      <xsl:param name="element-with-content" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-content/@content,$element-with-content/content)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-format" as="element()*">
      <xsl:param name="element-with-format" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-format/@format,$element-with-format/format)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-viewpoint" as="element()*">
      <xsl:param name="element-with-viewpoint" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-viewpoint/@viewpoint,$element-with-viewpoint/viewpoint)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-URI" as="element()*">
      <xsl:param name="element-with-URI" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-URI/@URI,$element-with-URI/URI)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-nestingPackage" as="element()*">
      <xsl:param name="element-with-nestingPackage" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-nestingPackage/@nestingPackage,$element-with-nestingPackage/nestingPackage)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-mergedPackage" as="element()*">
      <xsl:param name="element-with-mergedPackage" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-mergedPackage/@mergedPackage,$element-with-mergedPackage/mergedPackage)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-receivingPackage" as="element()*">
      <xsl:param name="element-with-receivingPackage" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-receivingPackage/@receivingPackage,$element-with-receivingPackage/receivingPackage)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-appliedProfile" as="element()*">
      <xsl:param name="element-with-appliedProfile" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-appliedProfile/@appliedProfile,$element-with-appliedProfile/appliedProfile)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-applyingPackage" as="element()*">
      <xsl:param name="element-with-applyingPackage" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-applyingPackage/@applyingPackage,$element-with-applyingPackage/applyingPackage)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-isStrict" as="element()*">
      <xsl:param name="element-with-isStrict" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-isStrict/@isStrict,$element-with-isStrict/isStrict)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-classifierBehavior" as="element()*">
      <xsl:param name="element-with-classifierBehavior" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-classifierBehavior/@classifierBehavior,$element-with-classifierBehavior/classifierBehavior)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-enumeration" as="element()*">
      <xsl:param name="element-with-enumeration" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-enumeration/@enumeration,$element-with-enumeration/enumeration)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-redefinedInterface" as="element()*">
      <xsl:param name="element-with-redefinedInterface" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-redefinedInterface/@redefinedInterface,$element-with-redefinedInterface/redefinedInterface)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-implementingClassifier" as="element()*">
      <xsl:param name="element-with-implementingClassifier" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-implementingClassifier/@implementingClassifier,$element-with-implementingClassifier/implementingClassifier)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-entry" as="element()*">
      <xsl:param name="element-with-entry" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-entry/@entry,$element-with-entry/entry)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-exit" as="element()*">
      <xsl:param name="element-with-exit" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-exit/@exit,$element-with-exit/exit)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-state" as="element()*">
      <xsl:param name="element-with-state" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-state/@state,$element-with-state/state)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-generalMachine" as="element()*">
      <xsl:param name="element-with-generalMachine" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-generalMachine/@generalMachine,$element-with-generalMachine/generalMachine)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-specificMachine" as="element()*">
      <xsl:param name="element-with-specificMachine" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-specificMachine/@specificMachine,$element-with-specificMachine/specificMachine)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-kind" as="element()*">
      <xsl:param name="element-with-kind" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-kind/@kind,$element-with-kind/kind)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-stateMachine" as="element()*">
      <xsl:param name="element-with-stateMachine" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-stateMachine/@stateMachine,$element-with-stateMachine/stateMachine)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-extendedRegion" as="element()*">
      <xsl:param name="element-with-extendedRegion" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-extendedRegion/@extendedRegion,$element-with-extendedRegion/extendedRegion)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-redefinedState" as="element()*">
      <xsl:param name="element-with-redefinedState" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-redefinedState/@redefinedState,$element-with-redefinedState/redefinedState)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-submachine" as="element()*">
      <xsl:param name="element-with-submachine" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-submachine/@submachine,$element-with-submachine/submachine)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-extendedStateMachine" as="element()*">
      <xsl:param name="element-with-extendedStateMachine" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-extendedStateMachine/@extendedStateMachine,$element-with-extendedStateMachine/extendedStateMachine)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-submachineState" as="element()*">
      <xsl:param name="element-with-submachineState" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-submachineState/@submachineState,$element-with-submachineState/submachineState)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-container" as="element()*">
      <xsl:param name="element-with-container" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-container/@container,$element-with-container/container)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-redefinedTransition" as="element()*">
      <xsl:param name="element-with-redefinedTransition" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-redefinedTransition/@redefinedTransition,$element-with-redefinedTransition/redefinedTransition)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-memberEnd" as="element()*">
      <xsl:param name="element-with-memberEnd" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-memberEnd/@memberEnd,$element-with-memberEnd/memberEnd)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-navigableOwnedEnd" as="element()*">
      <xsl:param name="element-with-navigableOwnedEnd" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-navigableOwnedEnd/@navigableOwnedEnd,$element-with-navigableOwnedEnd/navigableOwnedEnd)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-isActive" as="element()*">
      <xsl:param name="element-with-isActive" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-isActive/@isActive,$element-with-isActive/isActive)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-collaborationRole" as="element()*">
      <xsl:param name="element-with-collaborationRole" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-collaborationRole/@collaborationRole,$element-with-collaborationRole/collaborationRole)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-isIndirectlyInstantiated" as="element()*">
      <xsl:param name="element-with-isIndirectlyInstantiated" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-isIndirectlyInstantiated/@isIndirectlyInstantiated,$element-with-isIndirectlyInstantiated/isIndirectlyInstantiated)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-abstraction" as="element()*">
      <xsl:param name="element-with-abstraction" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-abstraction/@abstraction,$element-with-abstraction/abstraction)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-realizingClassifier" as="element()*">
      <xsl:param name="element-with-realizingClassifier" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-realizingClassifier/@realizingClassifier,$element-with-realizingClassifier/realizingClassifier)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-redefinedConnector" as="element()*">
      <xsl:param name="element-with-redefinedConnector" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-redefinedConnector/@redefinedConnector,$element-with-redefinedConnector/redefinedConnector)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-partWithPort" as="element()*">
      <xsl:param name="element-with-partWithPort" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-partWithPort/@partWithPort,$element-with-partWithPort/partWithPort)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-role" as="element()*">
      <xsl:param name="element-with-role" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-role/@role,$element-with-role/role)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-isBehavior" as="element()*">
      <xsl:param name="element-with-isBehavior" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-isBehavior/@isBehavior,$element-with-isBehavior/isBehavior)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-isConjugated" as="element()*">
      <xsl:param name="element-with-isConjugated" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-isConjugated/@isConjugated,$element-with-isConjugated/isConjugated)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-isService" as="element()*">
      <xsl:param name="element-with-isService" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-isService/@isService,$element-with-isService/isService)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-protocol" as="element()*">
      <xsl:param name="element-with-protocol" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-protocol/@protocol,$element-with-protocol/protocol)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-redefinedPort" as="element()*">
      <xsl:param name="element-with-redefinedPort" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-redefinedPort/@redefinedPort,$element-with-redefinedPort/redefinedPort)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-extendedCase" as="element()*">
      <xsl:param name="element-with-extendedCase" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-extendedCase/@extendedCase,$element-with-extendedCase/extendedCase)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-extension" as="element()*">
      <xsl:param name="element-with-extension" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-extension/@extension,$element-with-extension/extension)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-extensionLocation" as="element()*">
      <xsl:param name="element-with-extensionLocation" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-extensionLocation/@extensionLocation,$element-with-extensionLocation/extensionLocation)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-addition" as="element()*">
      <xsl:param name="element-with-addition" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-addition/@addition,$element-with-addition/addition)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-includingCase" as="element()*">
      <xsl:param name="element-with-includingCase" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-includingCase/@includingCase,$element-with-includingCase/includingCase)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-subject" as="element()*">
      <xsl:param name="element-with-subject" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-subject/@subject,$element-with-subject/subject)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-observation" as="element()*">
      <xsl:param name="element-with-observation" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-observation/@observation,$element-with-observation/observation)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-firstEvent" as="element()*">
      <xsl:param name="element-with-firstEvent" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-firstEvent/@firstEvent,$element-with-firstEvent/firstEvent)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-max" as="element()*">
      <xsl:param name="element-with-max" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-max/@max,$element-with-max/max)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-min" as="element()*">
      <xsl:param name="element-with-min" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-min/@min,$element-with-min/min)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-symbol" as="element()*">
      <xsl:param name="element-with-symbol" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-symbol/@symbol,$element-with-symbol/symbol)"/>
   </xsl:function>
   <xsl:function name="uml:resolve-owningExpression" as="element()*">
      <xsl:param name="element-with-owningExpression" as="element()?"/>
      <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-owningExpression/@owningExpression,$element-with-owningExpression/owningExpression)"/>
   </xsl:function>
</xsl:stylesheet>
