<?xml version="1.0" encoding="UTF-8" standalone="yes"?>
<xsl:stylesheet xmlns:bib="urn:xoev-de:kosit:xoev:lite:schema:bibliothek_1.2.0"
                xmlns:fm="urn:xoev-de:kosit:xoev:lite:schema:fachmodell_1.2.0"
                xmlns:iso="http://purl.oclc.org/dsdl/schematron"
                xmlns:lite="urn:xoev-de:kosit:xoev:lite:transformation_1.2.0"
                xmlns:saxon="http://saxon.sf.net/"
                xmlns:schold="http://www.ascc.net/xml/schematron"
                xmlns:xhtml="http://www.w3.org/1999/xhtml"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:xsd="http://www.w3.org/2001/XMLSchema"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                version="2.0"><!--Implementers: please note that overriding process-prolog or process-root is 
    the preferred method for meta-stylesheets to use where possible. -->
   <xsl:param name="archiveDirParameter"/>
   <xsl:param name="archiveNameParameter"/>
   <xsl:param name="fileNameParameter"/>
   <xsl:param name="fileDirParameter"/>
   <xsl:variable name="document-uri">
      <xsl:value-of select="document-uri(/)"/>
   </xsl:variable>
   <!--PHASES-->
   <!--PROLOG-->
   <xsl:output xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
               method="xml"
               omit-xml-declaration="no"
               standalone="yes"
               indent="yes"/>
   <!--XSD TYPES FOR XSLT2-->
   <!--KEYS AND FUNCTIONS-->
   <!--DEFAULT RULES-->
   <!--MODE: SCHEMATRON-SELECT-FULL-PATH-->
   <!--This mode can be used to generate an ugly though full XPath for locators-->
   <xsl:template match="*" mode="schematron-select-full-path">
      <xsl:apply-templates select="." mode="schematron-get-full-path-3"/>
   </xsl:template>
   <!--MODE: SCHEMATRON-FULL-PATH-->
   <!--This mode can be used to generate an ugly though full XPath for locators-->
   <xsl:template match="*" mode="schematron-get-full-path">
      <xsl:apply-templates select="parent::*" mode="schematron-get-full-path"/>
      <xsl:text>/</xsl:text>
      <xsl:choose>
         <xsl:when test="namespace-uri()=''">
            <xsl:value-of select="name()"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:text>*:</xsl:text>
            <xsl:value-of select="local-name()"/>
            <xsl:text>[namespace-uri()='</xsl:text>
            <xsl:value-of select="namespace-uri()"/>
            <xsl:text>']</xsl:text>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="preceding"
                    select="count(preceding-sibling::*[local-name()=local-name(current())                                   and namespace-uri() = namespace-uri(current())])"/>
      <xsl:text>[</xsl:text>
      <xsl:value-of select="1+ $preceding"/>
      <xsl:text>]</xsl:text>
   </xsl:template>
   <xsl:template match="@*" mode="schematron-get-full-path">
      <xsl:apply-templates select="parent::*" mode="schematron-get-full-path"/>
      <xsl:text>/</xsl:text>
      <xsl:choose>
         <xsl:when test="namespace-uri()=''">@<xsl:value-of select="name()"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:text>@*[local-name()='</xsl:text>
            <xsl:value-of select="local-name()"/>
            <xsl:text>' and namespace-uri()='</xsl:text>
            <xsl:value-of select="namespace-uri()"/>
            <xsl:text>']</xsl:text>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <!--MODE: SCHEMATRON-FULL-PATH-2-->
   <!--This mode can be used to generate prefixed XPath for humans-->
   <xsl:template match="node() | @*" mode="schematron-get-full-path-2">
      <xsl:for-each select="ancestor-or-self::*">
         <xsl:text>/</xsl:text>
         <xsl:value-of select="name(.)"/>
         <xsl:if test="preceding-sibling::*[name(.)=name(current())]">
            <xsl:text>[</xsl:text>
            <xsl:value-of select="count(preceding-sibling::*[name(.)=name(current())])+1"/>
            <xsl:text>]</xsl:text>
         </xsl:if>
      </xsl:for-each>
      <xsl:if test="not(self::*)">
         <xsl:text/>/@<xsl:value-of select="name(.)"/>
      </xsl:if>
   </xsl:template>
   <!--MODE: SCHEMATRON-FULL-PATH-3-->
   <!--This mode can be used to generate prefixed XPath for humans 
	(Top-level element has index)-->
   <xsl:template match="node() | @*" mode="schematron-get-full-path-3">
      <xsl:for-each select="ancestor-or-self::*">
         <xsl:text>/</xsl:text>
         <xsl:value-of select="name(.)"/>
         <xsl:if test="parent::*">
            <xsl:text>[</xsl:text>
            <xsl:value-of select="count(preceding-sibling::*[name(.)=name(current())])+1"/>
            <xsl:text>]</xsl:text>
         </xsl:if>
      </xsl:for-each>
      <xsl:if test="not(self::*)">
         <xsl:text/>/@<xsl:value-of select="name(.)"/>
      </xsl:if>
   </xsl:template>
   <!--MODE: GENERATE-ID-FROM-PATH -->
   <xsl:template match="/" mode="generate-id-from-path"/>
   <xsl:template match="text()" mode="generate-id-from-path">
      <xsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <xsl:value-of select="concat('.text-', 1+count(preceding-sibling::text()), '-')"/>
   </xsl:template>
   <xsl:template match="comment()" mode="generate-id-from-path">
      <xsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <xsl:value-of select="concat('.comment-', 1+count(preceding-sibling::comment()), '-')"/>
   </xsl:template>
   <xsl:template match="processing-instruction()" mode="generate-id-from-path">
      <xsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <xsl:value-of select="concat('.processing-instruction-', 1+count(preceding-sibling::processing-instruction()), '-')"/>
   </xsl:template>
   <xsl:template match="@*" mode="generate-id-from-path">
      <xsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <xsl:value-of select="concat('.@', name())"/>
   </xsl:template>
   <xsl:template match="*" mode="generate-id-from-path" priority="-0.5">
      <xsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <xsl:text>.</xsl:text>
      <xsl:value-of select="concat('.',name(),'-',1+count(preceding-sibling::*[name()=name(current())]),'-')"/>
   </xsl:template>
   <!--MODE: GENERATE-ID-2 -->
   <xsl:template match="/" mode="generate-id-2">U</xsl:template>
   <xsl:template match="*" mode="generate-id-2" priority="2">
      <xsl:text>U</xsl:text>
      <xsl:number level="multiple" count="*"/>
   </xsl:template>
   <xsl:template match="node()" mode="generate-id-2">
      <xsl:text>U.</xsl:text>
      <xsl:number level="multiple" count="*"/>
      <xsl:text>n</xsl:text>
      <xsl:number count="node()"/>
   </xsl:template>
   <xsl:template match="@*" mode="generate-id-2">
      <xsl:text>U.</xsl:text>
      <xsl:number level="multiple" count="*"/>
      <xsl:text>_</xsl:text>
      <xsl:value-of select="string-length(local-name(.))"/>
      <xsl:text>_</xsl:text>
      <xsl:value-of select="translate(name(),':','.')"/>
   </xsl:template>
   <!--Strip characters-->
   <xsl:template match="text()" priority="-1"/>
   <!--SCHEMA SETUP-->
   <xsl:template match="/">
      <svrl:schematron-output xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                              title="Prüfanweisungen: XÖV lite"
                              schemaVersion="">
         <svrl:ns-prefix-in-attribute-values uri="urn:xoev-de:kosit:xoev:lite:schema:fachmodell_1.2.0" prefix="fm"/>
         <svrl:ns-prefix-in-attribute-values uri="urn:xoev-de:kosit:xoev:lite:schema:bibliothek_1.2.0" prefix="bib"/>
         <svrl:ns-prefix-in-attribute-values uri="urn:xoev-de:kosit:xoev:lite:transformation_1.2.0" prefix="lite"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.NDR-11.001</xsl:attribute>
            <xsl:attribute name="name">Namen von benannten Typen und globalen Elementen ohne Whitespaces</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M6"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.NDR-11.002</xsl:attribute>
            <xsl:attribute name="name">Nur erlaubte Zeichen in Namen von Präfixen und Suffixen</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M7"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.NDR-11.003</xsl:attribute>
            <xsl:attribute name="name">Keine Whitespaces in Namen von Präfixen und Suffixen</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M8"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.NDR-11.004</xsl:attribute>
            <xsl:attribute name="name">Nur erlaubte Zeichen in Namen von Elementen, Attributen, Gruppen, Datentypen und Nachrichten</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M9"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.NDR-11.005</xsl:attribute>
            <xsl:attribute name="name">Keine Whitespaces in Namen von Elementen und Attributen</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M10"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.NDR-11.006</xsl:attribute>
            <xsl:attribute name="name">Erlaubte Zeichen in Namen benannter Datentypen zur Nutzung von Schema-validierenden Codelisten-Versionen</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M11"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.NDR-11.007</xsl:attribute>
            <xsl:attribute name="name">Keine Whitespaces in Namen benannter Datentypen zur Nutzung von Schema-validierenden Codelisten-Versionen</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M12"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.NDR-28.001</xsl:attribute>
            <xsl:attribute name="name">Sich ausschließende Default- und Fixed-Werte</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M13"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.NDR-28.002</xsl:attribute>
            <xsl:attribute name="name">Eindeutige Namen von Datentypen in einem Namensraum</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M14"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.NDR-28.003</xsl:attribute>
            <xsl:attribute name="name">Eindeutige Namen von Nachrichten, globalen Elemente, globalen Elementgruppen, globalen Attribute und globalen Attributgruppen in einem Namensraum</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M15"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.NDR-28.004</xsl:attribute>
            <xsl:attribute name="name">Benannte oder referenzierende Elemente, Elementgruppen, Attribute und Attributgruppen</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M16"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.NDR-28.005</xsl:attribute>
            <xsl:attribute name="name">Eindeutig benannte und referenzierte Elemente in Nachrichten, Datentypen und globalen Elementgruppen</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M17"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.NDR-28.006</xsl:attribute>
            <xsl:attribute name="name">Typisierte globale Elemente und Nachrichten ohne eigene weitere Elemente und Attribute</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M18"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.NDR-28.007</xsl:attribute>
            <xsl:attribute name="name">Verwendung existierender globaler Typen, Elemente, Elementgruppen, Attribute und Attributgruppen</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M19"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.NDR-28.008</xsl:attribute>
            <xsl:attribute name="name">Referenzierung von Elementreferenzen auf globale Elemente und Elementgruppen</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M20"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.NDR-28.009</xsl:attribute>
            <xsl:attribute name="name">Schema Location für Schema</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M21"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.NDR-28.010</xsl:attribute>
            <xsl:attribute name="name">Eindeutiger Dateinamen für Schema</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M22"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.NDR-28.011</xsl:attribute>
            <xsl:attribute name="name">Eindeutige Schema Location für Schema</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M23"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.NDR-28.012</xsl:attribute>
            <xsl:attribute name="name">Ausschließlich Elemente in Elementgruppen und Attribute in Attributgruppen</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M24"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.NDR-28.013</xsl:attribute>
            <xsl:attribute name="name">Keine erweiternden Elemente oder Attribute für per Restriktion definierte Typen, Nachrichten und globale Elemente</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M25"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.NDR-28.014</xsl:attribute>
            <xsl:attribute name="name">Keine Verwendung von im Entwurf befindlichen Typen</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M26"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.NDR-28.015</xsl:attribute>
            <xsl:attribute name="name">Keine Verwendung von im Entwurf befindlichen globalen Elementen, Elementgruppen, Attributen und Attributgruppen</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M27"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.NDR-28.016</xsl:attribute>
            <xsl:attribute name="name">Korrekte Elementreihenfolge bei einschränkenden Datentypen, Nachrichten und globalen Elementen</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M28"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.NDR-28.017</xsl:attribute>
            <xsl:attribute name="name">Facetten zur Restriktion nur bei einfachen Datentypen</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M29"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.NDR-28.018</xsl:attribute>
            <xsl:attribute name="name">Facette fractionsDigits nur zur Einschränkung von bestimmten einfachen Datentypen</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M30"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.NDR-28.019</xsl:attribute>
            <xsl:attribute name="name">Facette length nur zur Einschränkung von bestimmten einfachen Datentypen</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M31"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.NDR-28.020</xsl:attribute>
            <xsl:attribute name="name">Ausschluss der Facette length bei Nutzung der Facetten maxLength oder minLength</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M32"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.NDR-28.021</xsl:attribute>
            <xsl:attribute name="name">Gegenseitiger Ausschluss der Facetten maxExclusive und maxInclusive</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M33"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.NDR-28.022</xsl:attribute>
            <xsl:attribute name="name">Gegenseitiger Ausschluss der Facetten minExlusive und minInclusive</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M34"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.NDR-28.023</xsl:attribute>
            <xsl:attribute name="name">Facette maxExclusive nur zur Einschränkung von bestimmten einfachen Datentypen</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M35"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.NDR-28.024</xsl:attribute>
            <xsl:attribute name="name">Facette maxInclusive nur zur Einschränkung von bestimmten einfachen Datentypen</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M36"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.NDR-28.025</xsl:attribute>
            <xsl:attribute name="name">Facette maxLength nur zur Einschränkung von bestimmten einfachen Datentypen</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M37"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.NDR-28.026</xsl:attribute>
            <xsl:attribute name="name">Facette minExclusive nur zur Einschränkung von bestimmten einfachen Datentypen</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M38"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.NDR-28.027</xsl:attribute>
            <xsl:attribute name="name">Facette minInclusive nur zur Einschränkung von bestimmten einfachen Datentypen</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M39"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.NDR-28.028</xsl:attribute>
            <xsl:attribute name="name">Facette minLength nur zur Einschränkung von bestimmten einfachen Datentypen</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M40"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.NDR-28.029</xsl:attribute>
            <xsl:attribute name="name">Facette pattern nur zur Einschränkung von bestimmten einfachen Datentypen</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M41"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.NDR-28.030</xsl:attribute>
            <xsl:attribute name="name">Facette totalDigits nur zur Einschränkung von bestimmten einfachen Datentypen</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M42"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.NDR-28.031</xsl:attribute>
            <xsl:attribute name="name">Facette whitespace nur zur Einschränkung von bestimmten einfachen Datentypen</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M43"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.NDR-28.032</xsl:attribute>
            <xsl:attribute name="name">Eingeschränkte Multiplizität bei Attributen</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M44"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.NDR-28.033</xsl:attribute>
            <xsl:attribute name="name">xsd als Dateiendung von Schema</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M45"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.NDR-28.034</xsl:attribute>
            <xsl:attribute name="name">xsd als Dateiendung von Schema Location</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M46"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.NDR-28.035</xsl:attribute>
            <xsl:attribute name="name">Elemente, Elementgruppen, Attribute und Attributgruppen mit Typ, Referenz oder lokaler Struktur</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M47"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.NDR-28.036</xsl:attribute>
            <xsl:attribute name="name">Zyklenfreie Importe und Inkludierungen von Schema</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M48"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.NDR-28.037</xsl:attribute>
            <xsl:attribute name="name">Unqualifizierte Elemente bei namensraumübergreifenden Restriktionen</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M49"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.NDR-28.038</xsl:attribute>
            <xsl:attribute name="name">Ausschließlich einfache Datentypen als Member eines Unions</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M50"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.NDR-28.039</xsl:attribute>
            <xsl:attribute name="name">Nur benannte Datentypen als Member eines Unions</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M51"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.NDR-28.040</xsl:attribute>
            <xsl:attribute name="name">Verweise auf globale Datentypen, globale Attribute, globale Elemente oder globale Gruppen mit Präfix</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M52"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.NDR-28.041</xsl:attribute>
            <xsl:attribute name="name">Attribute mit einfachem Typ</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M53"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.NDR-28.042</xsl:attribute>
            <xsl:attribute name="name">Nur Attribute zur Erweiterung einfacher Datentypen</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M54"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.NDR-29.001</xsl:attribute>
            <xsl:attribute name="name">Namensraum für Schema</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M55"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.NDR-29.002</xsl:attribute>
            <xsl:attribute name="name">Namensraumpräfix für Schema</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M56"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.NDR-30.001</xsl:attribute>
            <xsl:attribute name="name">Version für Schema</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M57"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.NDR-32.001</xsl:attribute>
            <xsl:attribute name="name">Kennung des Standards beginnt mit urn:xoev-de:</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M58"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.NDR-32.002</xsl:attribute>
            <xsl:attribute name="name">Kennung des Standards mit :standard:</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M59"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.NDR-32.003</xsl:attribute>
            <xsl:attribute name="name">Kennung des Standards mit kleingeschriebenem technischen Namen des Standards</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M60"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.NDR-32.004</xsl:attribute>
            <xsl:attribute name="name">Kennung des Standards mit xoev nur zu Beginn in urn:xoev-de</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M61"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.NDR-32.005</xsl:attribute>
            <xsl:attribute name="name">Nur erlaubte Zeichen in der Kennung eines Standards</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M62"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.NDR-32.006</xsl:attribute>
            <xsl:attribute name="name">Nur erlaubte Zeichen im technischen Namen eines Standards</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M63"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.NDR-32.007</xsl:attribute>
            <xsl:attribute name="name">Nur erlaubte Zeichen in der Version eines Standards</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M64"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.NDR-33.001</xsl:attribute>
            <xsl:attribute name="name">token als Basis des Elements code in Code-Datentypen</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M65"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.NDR-33.002</xsl:attribute>
            <xsl:attribute name="name">Angabe von Kennung und Version für Schema-validierende Codes in Code-Datentypen</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M66"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.NDR-33.003</xsl:attribute>
            <xsl:attribute name="name">Definition genutzter Code-Spalte als Code-Spalte der Codelisten-Version</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M67"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.NDR-33.004</xsl:attribute>
            <xsl:attribute name="name">Korrekte Codelistenmodellierung</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M68"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.lite.001</xsl:attribute>
            <xsl:attribute name="name">Beispielwerte nur im erlaubten Kontext</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M69"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.lite.002</xsl:attribute>
            <xsl:attribute name="name">Beispielewerte nur für lokale Elemente und Attribute mit einfachem Typ</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M70"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.lite.003</xsl:attribute>
            <xsl:attribute name="name">Beispielewerte nur für globale Elemente und Attribute mit einfachem Typ</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M71"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.lite.004</xsl:attribute>
            <xsl:attribute name="name">Beispielwerte nur für Elemente und Attribute mit Referenz auf Element oder Attribut mit einfachem Typ</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M72"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.lite.005</xsl:attribute>
            <xsl:attribute name="name">Beispielwerte nur für Elemente und Attribute mit Einschränkung auf einfachen Typ</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M73"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.lite.006</xsl:attribute>
            <xsl:attribute name="name">Verarbeitbares XÖV-Fachmodell</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M74"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.lite.007</xsl:attribute>
            <xsl:attribute name="name">Keine leeren Deklarationen</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M75"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.lite.008</xsl:attribute>
            <xsl:attribute name="name">Codelisten mit Kennung liegen im codelists-Verzeichnis vollständig vor</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M76"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.lite.009</xsl:attribute>
            <xsl:attribute name="name">Codelisten mit Kennung und Version liegen im codelists-Verzeichnis vollständig vor</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M77"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.lite.010</xsl:attribute>
            <xsl:attribute name="name">Externe Modelle liegen im Modell-Verzeichnis vollständig vor</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M78"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.lite.011</xsl:attribute>
            <xsl:attribute name="name">Externe Modelle im XÖV-Fachmodell bestimmt</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M79"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.GP-1.001</xsl:attribute>
            <xsl:attribute name="name">Paket für Basisdatentypen</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M80"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.GP-1.002</xsl:attribute>
            <xsl:attribute name="name">Paket für Baukasten</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M81"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.GP-1.003</xsl:attribute>
            <xsl:attribute name="name">Paket für Nachrichten oder Fachmodule</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M82"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.GP-1.004</xsl:attribute>
            <xsl:attribute name="name">Mindestens ein Schema für Nachrichten oder Fachmodule</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M83"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.GP-1.005</xsl:attribute>
            <xsl:attribute name="name">Nachrichten nur in einem Schema für Nachrichten oder Fachmodule</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M84"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.GP-1.006</xsl:attribute>
            <xsl:attribute name="name">Schema im Paket Nachrichten oder Fachmodule mit mindestens einer Nachricht</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M85"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.GP-5.001</xsl:attribute>
            <xsl:attribute name="name">Nutzung von Schema-validierenden Codelistenversionen über benannte Datentypen</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M86"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.GP-5.002</xsl:attribute>
            <xsl:attribute name="name">Namen benannter Datentypen zur Nutzung von Schema-validierenden Codelisten-Versionen eindeutig</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M87"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.GP-5.003</xsl:attribute>
            <xsl:attribute name="name">Benannte Datentypen zur Nutzung von Schema-validierenden Codelisten-Versionen in einem Schema des XÖV-Standards</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M88"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.GP-6.001</xsl:attribute>
            <xsl:attribute name="name">Keine aufeinanderfolgenden Punkte in Namen von Typen, globalen Elementen, Nachrichten und Datentypen</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M89"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.GP-6.002</xsl:attribute>
            <xsl:attribute name="name">Keine aufeinanderfolgenden Punkte in Namen von Elementen und Attributen</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M90"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.GP-8.001</xsl:attribute>
            <xsl:attribute name="name">Großer Buchstabe am Beginn des Namens von Datentypen</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M91"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.GP-8.002</xsl:attribute>
            <xsl:attribute name="name">Kleiner Buchstabe am Beginn des Namens von Elementen und Attributen</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M92"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.GP-8.003</xsl:attribute>
            <xsl:attribute name="name">Kleiner Buchstabe am Beginn des Namens von globalen Elementen und Nachrichten</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M93"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.GP-9.001</xsl:attribute>
            <xsl:attribute name="name">Vorangestellter Präfix in Namen von Nachrichten</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M94"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.GP-9.002</xsl:attribute>
            <xsl:attribute name="name">Vorangestellter Präfix in Namen von Nachrichten entspricht Name des Schema-Pakets</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M95"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.GP-10.001</xsl:attribute>
            <xsl:attribute name="name">Nachgestellter numerischer Suffix in Namen von Nachrichten</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M96"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.GP-10.002</xsl:attribute>
            <xsl:attribute name="name">Eindeutiger nachgestellter numerischer Suffix in Namen von Nachrichten</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M97"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.GP-11.001</xsl:attribute>
            <xsl:attribute name="name">Technischer Name des Standards am Beginn des Dateinamens einer Schema-Datei</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M98"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.GP-11.002</xsl:attribute>
            <xsl:attribute name="name">Technischer Name des Standards am Beginn der Schema-Location einer Schema-Datei</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M99"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.GP-12.001</xsl:attribute>
            <xsl:attribute name="name">Rechtsgrundlage für Nachrichten</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M100"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.WSDL-2.001</xsl:attribute>
            <xsl:attribute name="name">Dienst mit gültigem Kommunikationsszenario</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M101"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.WSDL-3.001</xsl:attribute>
            <xsl:attribute name="name">Transportszenario mit gültigem Kommunikationsszenario</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M102"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.WSDL-4.001</xsl:attribute>
            <xsl:attribute name="name">Dienst mit gültigem Signaturlevel für Inhaltsdaten</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M103"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.WSDL-5.001</xsl:attribute>
            <xsl:attribute name="name">Transportszenario mit gültigem Signaturlevel für Inhaltsdaten</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M104"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.WSDL-6.001</xsl:attribute>
            <xsl:attribute name="name">Dienst mit gültigem Signaturlevel für Nutzdaten</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M105"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.WSDL-7.001</xsl:attribute>
            <xsl:attribute name="name">Transportszenario mit gültigem Signaturlevel für Nutzdaten</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M106"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.WSDL-8.001</xsl:attribute>
            <xsl:attribute name="name">Nutzung optionaler Container korrekt geregelt in Dienst</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M107"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.WSDL-9.001</xsl:attribute>
            <xsl:attribute name="name">Nutzung optionaler Container korrekt geregelt in Transportszenario</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M108"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.WSDL-10.001</xsl:attribute>
            <xsl:attribute name="name">Korrekte Service Messages in one-way-active</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M109"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.WSDL-11.001</xsl:attribute>
            <xsl:attribute name="name">Korrekte Service Messages in request-response</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M110"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.WSDL-12.001</xsl:attribute>
            <xsl:attribute name="name">Nicht unterstützte Kommumikationszenarien in Diensten</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M111"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.WSDL-12.002</xsl:attribute>
            <xsl:attribute name="name">Nicht unterstützte Kommunikationsszenarien in Transportszenarien</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M112"/>
      </svrl:schematron-output>
   </xsl:template>
   <!--SCHEMATRON PATTERNS-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Prüfanweisungen: XÖV lite</svrl:text>
   <xsl:include xmlns:bp="urn:xoev-de:kosit:xoev:lite:schema:betrieb.pruefanweisungen"
                xmlns:sch="http://purl.oclc.org/dsdl/schematron"
                href="helpers.lite.xsl"/>
   <xsl:include xmlns:bp="urn:xoev-de:kosit:xoev:lite:schema:betrieb.pruefanweisungen"
                xmlns:sch="http://purl.oclc.org/dsdl/schematron"
                href="../xsl/helpers.lite.schematron.xsl"/>
   <!--PATTERN pattern.NDR-11.001Namen von benannten Typen und globalen Elementen ohne Whitespaces-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Namen von benannten Typen und globalen Elementen ohne Whitespaces</svrl:text>
   <!--RULE -->
   <xsl:template match="fm:globaleEigenschaft[@xsdAttribute = false() and @name] | fm:nachricht[@name] | fm:datentyp[@name] | fm:codeDatentyp[@name]"
                 priority="1000"
                 mode="M6">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(matches(@name, '\s'))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(matches(@name, '\s'))">
               <xsl:attribute name="id">NDR-11.001</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>NDR-11.001: Benannte Typen und globale Elemente dürfen keine Whitespaces enthalten. <xsl:text/>
                  <xsl:value-of select="@name"/>
                  <xsl:text/> verletzt diese Regel.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M6"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M6"/>
   <xsl:template match="@*|node()" priority="-2" mode="M6">
      <xsl:apply-templates select="*" mode="M6"/>
   </xsl:template>
   <!--PATTERN pattern.NDR-11.002Nur erlaubte Zeichen in Namen von Präfixen und Suffixen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Nur erlaubte Zeichen in Namen von Präfixen und Suffixen</svrl:text>
   <!--RULE -->
   <xsl:template match="fm:xsdGlobalElementNamePrefix | fm:xsdGlobalElementNameSuffix | fm:xsdNamedTypeNamePrefix | fm:xsdNamedTypeNameSuffix"
                 priority="1000"
                 mode="M7">

		<!--ASSERT warning-->
      <xsl:choose>
         <xsl:when test="           replace(., '[a-zA-Z0-9\.\-_]', '') = ''"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="replace(., '[a-zA-Z0-9\.\-_]', '') = ''">
               <xsl:attribute name="id">NDR-11.002</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>NDR-11.002: Namenspräfixe und -suffixe von benannten Typen und globalen Elementen (xsdGlobalElementNamePrefix, xsdGlobalElementNameSuffix, xsdNamedTypeNamePrefix, xsdNamedTypeNameSuffix) sollen nur die Zeichen "a-z", "A-Z", "0-9", ".", "_" und "-" enthalten. Folgende Eigenschaft verletzt diese Regel: <xsl:text/>
                  <xsl:value-of select="name()"/>
                  <xsl:text/>
               </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M7"/>
   <xsl:template match="@*|node()" priority="-2" mode="M7">
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>
   <!--PATTERN pattern.NDR-11.003Keine Whitespaces in Namen von Präfixen und Suffixen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Keine Whitespaces in Namen von Präfixen und Suffixen</svrl:text>
   <!--RULE -->
   <xsl:template match="fm:xsdGlobalElementNamePrefix | fm:xsdGlobalElementNameSuffix | fm:xsdNamedTypeNamePrefix | fm:xsdNamedTypeNameSuffix"
                 priority="1000"
                 mode="M8">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="           not(matches(., '\s'))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(matches(., '\s'))">
               <xsl:attribute name="id">NDR-11.003</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>NDR-11.003: Namenspräfixe und -suffixe von benannten Typen und globalen Elementen (xsdGlobalElementNamePrefix, xsdGlobalElementNameSuffix, xsdNamedTypeNamePrefix, xsdNamedTypeNameSuffix) dürfen keine Whitespaces enthalten. Folgende Eigenschaft verletzt diese Regel: <xsl:text/>
                  <xsl:value-of select="name()"/>
                  <xsl:text/>
               </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M8"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M8"/>
   <xsl:template match="@*|node()" priority="-2" mode="M8">
      <xsl:apply-templates select="*" mode="M8"/>
   </xsl:template>
   <!--PATTERN pattern.NDR-11.004Nur erlaubte Zeichen in Namen von Elementen, Attributen, Gruppen, Datentypen und Nachrichten-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Nur erlaubte Zeichen in Namen von Elementen, Attributen, Gruppen, Datentypen und Nachrichten</svrl:text>
   <!--RULE -->
   <xsl:template match="fm:eigenschaft[@name]|fm:globaleEigenschaft[@name]|fm:eigenschaftenGruppe[@name]|fm:globaleEigenschaftenGruppe[@name]|fm:nachricht[@name]|fm:datentyp[@name]|fm:codeDatentyp[@name]"
                 priority="1000"
                 mode="M9">

		<!--ASSERT warning-->
      <xsl:choose>
         <xsl:when test="not(replace(@name, '[a-zA-Z0-9\.\-_]', '') != '')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(replace(@name, '[a-zA-Z0-9\.\-_]', '') != '')">
               <xsl:attribute name="id">NDR-11.004</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>NDR-11.004: Namen von Elementen, Elementgruppen, Attributen, Attributgruppen, Datentypen und Nachrichten sollen nur die Zeichen "a-z", "A-Z", "0-9", ".", "_" und "-" enthalten. <xsl:text/>
                  <xsl:value-of select="@name"/>
                  <xsl:text/> verletzt diese Regel.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M9"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M9"/>
   <xsl:template match="@*|node()" priority="-2" mode="M9">
      <xsl:apply-templates select="*" mode="M9"/>
   </xsl:template>
   <!--PATTERN pattern.NDR-11.005Keine Whitespaces in Namen von Elementen und Attributen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Keine Whitespaces in Namen von Elementen und Attributen</svrl:text>
   <!--RULE -->
   <xsl:template match="fm:eigenschaft[@name] | fm:globaleEigenschaft[@name]"
                 priority="1000"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(matches(@name, '\s'))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(matches(@name, '\s'))">
               <xsl:attribute name="id">NDR-11.005</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>NDR-11.005:  Namen von Elementen und Attributen dürfen keine Whitespaces enthalten. <xsl:text/>
                  <xsl:value-of select="@name"/>
                  <xsl:text/> verletzt diese Regel.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M10"/>
   <xsl:template match="@*|node()" priority="-2" mode="M10">
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>
   <!--PATTERN pattern.NDR-11.006Erlaubte Zeichen in Namen benannter Datentypen zur Nutzung von Schema-validierenden Codelisten-Versionen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Erlaubte Zeichen in Namen benannter Datentypen zur Nutzung von Schema-validierenden Codelisten-Versionen</svrl:text>
   <!--RULE -->
   <xsl:template match="fm:codeDatentyp[fm:benannterCodelistenDatentypName][not(matches(fm:benannterCodelistenDatentypName, '^[a-zA-Z0-9\.\-_]*$'))]"
                 priority="1000"
                 mode="M11">

		<!--ASSERT warning-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">NDR-11.006</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>NDR-11.006: Datentypen, die Schema-validierende Codelisten einbinden und über einen Code-Datentyp referenziert werden, sollen nur die Zeichen "a-z", "A-Z", "0-9", ".", "_" und "-" enthalten. Im Kontext der Verwendungsbeziehung in dem Code-Datentyp <xsl:text/>
                  <xsl:value-of select="@name"/>
                  <xsl:text/> wird der Datentypname "<xsl:text/>
                  <xsl:value-of select="fm:benannterCodelistenDatentypName"/>
                  <xsl:text/>" mit ungültigen Zeichen spezifiziert.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M11"/>
   <xsl:template match="@*|node()" priority="-2" mode="M11">
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>
   <!--PATTERN pattern.NDR-11.007Keine Whitespaces in Namen benannter Datentypen zur Nutzung von Schema-validierenden Codelisten-Versionen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Keine Whitespaces in Namen benannter Datentypen zur Nutzung von Schema-validierenden Codelisten-Versionen</svrl:text>
   <!--RULE -->
   <xsl:template match="fm:codeDatentyp[fm:benannterCodelistenDatentypName][matches(fm:benannterCodelistenDatentypName, '\s')]"
                 priority="1000"
                 mode="M12">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">NDR-11.007</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>NDR-11.007: Datentypen, die Schema-validierende Codelisten einbinden und über einen Code-Datentyp referenziert werden, dürfen keine Whitespaces enthalten. Im Kontext der Verwendungsbeziehung in dem Code-Datentyp <xsl:text/>
                  <xsl:value-of select="@name"/>
                  <xsl:text/> wird der Datentypname "<xsl:text/>
                  <xsl:value-of select="fm:benannterCodelistenDatentypName"/>
                  <xsl:text/>" mit Whitespaces spezifiziert.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M12"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M12"/>
   <xsl:template match="@*|node()" priority="-2" mode="M12">
      <xsl:apply-templates select="*" mode="M12"/>
   </xsl:template>
   <!--PATTERN pattern.NDR-28.001Sich ausschließende Default- und Fixed-Werte-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Sich ausschließende Default- und Fixed-Werte</svrl:text>
   <!--RULE -->
   <xsl:template match="fm:globaleEigenschaft[@defaultWert and @fixedWert] | fm:eigenschaft[@defaultWert and @fixedWert]"
                 priority="1000"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">NDR-28.001</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>NDR-28.001: Ein Attribut oder Element darf nicht gleichzeitig einen Default-Wert und einen Fixed-Wert haben. <xsl:text/>
                  <xsl:value-of select="@name"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M13"/>
   <xsl:template match="@*|node()" priority="-2" mode="M13">
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>
   <!--PATTERN pattern.NDR-28.002Eindeutige Namen von Datentypen in einem Namensraum-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Eindeutige Namen von Datentypen in einem Namensraum</svrl:text>
   <!--RULE -->
   <xsl:template match="fm:datentyp[@name] | fm:codeDatentyp[@name]"
                 priority="1000"
                 mode="M14">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="                not(count(                ancestor::fm:xoev-fachmodell//(fm:datentyp | fm:codeDatentyp)[@name and                lite:namespace(.) = lite:namespace(current()) and @name = current()/@name]) &gt; 1)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(count( ancestor::fm:xoev-fachmodell//(fm:datentyp | fm:codeDatentyp)[@name and lite:namespace(.) = lite:namespace(current()) and @name = current()/@name]) &gt; 1)">
               <xsl:attribute name="id">NDR-28.002</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>NDR-28.002: Im gleichen Namensraum dürfen keine benannten Datentypen mit dem gleichen Namen existieren. Der Name des Datentyps <xsl:text/>
                  <xsl:value-of select="@name"/>
                  <xsl:text/> ist im Namensraum "<xsl:text/>
                  <xsl:value-of select="lite:namespace(.)"/>
                  <xsl:text/>" nicht eindeutig.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M14"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M14"/>
   <xsl:template match="@*|node()" priority="-2" mode="M14">
      <xsl:apply-templates select="*" mode="M14"/>
   </xsl:template>
   <!--PATTERN pattern.NDR-28.003Eindeutige Namen von Nachrichten, globalen Elemente, globalen Elementgruppen, globalen Attribute und globalen Attributgruppen in einem Namensraum-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Eindeutige Namen von Nachrichten, globalen Elemente, globalen Elementgruppen, globalen Attribute und globalen Attributgruppen in einem Namensraum</svrl:text>
   <!--RULE -->
   <xsl:template match="fm:globaleEigenschaft[@name] | fm:nachricht[@name] | fm:globaleEigenschaftengruppe[@name]"
                 priority="1000"
                 mode="M15">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="                not(count(                ancestor::fm:xoev-fachmodell//(fm:globaleEigenschaft | fm:nachricht | fm:globaleEigenschaftengruppe)[@name and                lite:namespace(.) = lite:namespace(current()) and @name = current()/@name]) &gt; 1)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(count( ancestor::fm:xoev-fachmodell//(fm:globaleEigenschaft | fm:nachricht | fm:globaleEigenschaftengruppe)[@name and lite:namespace(.) = lite:namespace(current()) and @name = current()/@name]) &gt; 1)">
               <xsl:attribute name="id">NDR-28.003</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>NDR-28.003: Im gleichen Namensraum dürfen keine Nachrichten, globalen Elemente, globalen Elementgruppen, globalen Attribute und globalen Attributgruppen mit dem gleichen Namen existieren. Der Name <xsl:text/>
                  <xsl:value-of select="@name"/>
                  <xsl:text/> ist im Namensraum "<xsl:text/>
                  <xsl:value-of select="lite:namespace(.)"/>
                  <xsl:text/>" nicht eindeutig.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M15"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M15"/>
   <xsl:template match="@*|node()" priority="-2" mode="M15">
      <xsl:apply-templates select="*" mode="M15"/>
   </xsl:template>
   <!--PATTERN pattern.NDR-28.004Benannte oder referenzierende Elemente, Elementgruppen, Attribute und Attributgruppen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Benannte oder referenzierende Elemente, Elementgruppen, Attribute und Attributgruppen</svrl:text>
   <!--RULE -->
   <xsl:template match="         fm:eigenschaft|fm:eigenschaftengruppe"
                 priority="1000"
                 mode="M16">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="(not(@referenz) and not(@name) and not(fm:eigenschaft|fm:eigenschaftengruppe)) = false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="(not(@referenz) and not(@name) and not(fm:eigenschaft|fm:eigenschaftengruppe)) = false()">
               <xsl:attribute name="id">NDR-28.004</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>NDR-28.004: Elemente, Elementgruppen, Attribute und Attributgruppen von Elementen, Elementgruppen, Attributgruppen und Datentypen müssen benannt sein oder auf ein globales Element, ein globales Attribut, eine globale Elementgruppe bzw. eine globale Attributgruppe referenzieren. <xsl:text/>
                  <xsl:value-of select="../@name"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M16"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M16"/>
   <xsl:template match="@*|node()" priority="-2" mode="M16">
      <xsl:apply-templates select="*" mode="M16"/>
   </xsl:template>
   <!--PATTERN pattern.NDR-28.005Eindeutig benannte und referenzierte Elemente in Nachrichten, Datentypen und globalen Elementgruppen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Eindeutig benannte und referenzierte Elemente in Nachrichten, Datentypen und globalen Elementgruppen</svrl:text>
   <!--RULE -->
   <xsl:template match="fm:nachricht | fm:datentyp | fm:globaleEigenschaftengruppe"
                 priority="1000"
                 mode="M17">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(lite:all-element-names(.)) = count(distinct-values(lite:all-element-names(.)))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(lite:all-element-names(.)) = count(distinct-values(lite:all-element-names(.)))">
               <xsl:attribute name="id">NDR-28.005</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>NDR-28.005: Die Elemente einer Nachricht, eines Datentyps oder einer globalen Elementgruppe müssen eindeutig benannt sein. Hierbei sind auch die Namen referenzierter globaler Elemente und die Namen der Elemente in referenzierten Gruppen zu berücksichtigen. Im Kontext von <xsl:text/>
                  <xsl:value-of select="@name"/>
                  <xsl:text/> sind die folgenden Namen nicht eindeutig: <xsl:text/>
                  <xsl:value-of select="                   if (lite:get-duplicate-strings(lite:all-element-names(.)) = '') then                      'Elemente ohne Namen'                   else                      lite:get-duplicate-strings(lite:all-element-names(.))"/>
                  <xsl:text/>
               </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M17"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M17"/>
   <xsl:template match="@*|node()" priority="-2" mode="M17">
      <xsl:apply-templates select="*" mode="M17"/>
   </xsl:template>
   <!--PATTERN pattern.NDR-28.006Typisierte globale Elemente und Nachrichten ohne eigene weitere Elemente und Attribute-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Typisierte globale Elemente und Nachrichten ohne eigene weitere Elemente und Attribute</svrl:text>
   <!--RULE -->
   <xsl:template match="fm:globaleEigenschaft[@xsdAttribute = false() and @typ] | fm:nachricht[@typ]"
                 priority="1000"
                 mode="M18">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(fm:eigenschaft | fm:eigenschaftengruppe | fm:anyStruktur) = 0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(fm:eigenschaft | fm:eigenschaftengruppe | fm:anyStruktur) = 0">
               <xsl:attribute name="id">NDR-28.006</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>NDR-28.006: Typisierte globale Elemente und Nachrichten dürfen keine weiteren eigenen Elemente oder Attribute besitzen. <xsl:text/>
                  <xsl:value-of select="@name"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M18"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M18"/>
   <xsl:template match="@*|node()" priority="-2" mode="M18">
      <xsl:apply-templates select="*" mode="M18"/>
   </xsl:template>
   <!--PATTERN pattern.NDR-28.007Verwendung existierender globaler Typen, Elemente, Elementgruppen, Attribute und Attributgruppen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Verwendung existierender globaler Typen, Elemente, Elementgruppen, Attribute und Attributgruppen</svrl:text>
   <!--RULE -->
   <xsl:template match="fm:eigenschaft[@typ or @basistyp or @referenz]|        fm:globaleEigenschaft[@typ or @basistyp]|        fm:nachricht[@typ or @basistyp] |        fm:codeDatentyp[fm:typDesCodeElements] |        fm:datentyp[@basistyp] |        fm:eigenschaftengruppe[@referenz] |        fm:union[fm:memberType]"
                 priority="1000"
                 mode="M19">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="          if (fm:memberType) then           ((every $m in fm:memberType          satisfies          (lite:resolve($m, ., false())))) else              if(fm:typDesCodeElements) then lite:resolve(fm:typDesCodeElements, ., false()) else                  if (@typ) then lite:resolve(@typ, ., false()) else                      if (@basistyp) then lite:resolve(@basistyp, ., false()) else lite:resolve(@referenz, ., true())"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="if (fm:memberType) then ((every $m in fm:memberType satisfies (lite:resolve($m, ., false())))) else if(fm:typDesCodeElements) then lite:resolve(fm:typDesCodeElements, ., false()) else if (@typ) then lite:resolve(@typ, ., false()) else if (@basistyp) then lite:resolve(@basistyp, ., false()) else lite:resolve(@referenz, ., true())">
               <xsl:attribute name="id">NDR-28.007</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>NDR-28.007: Elemente, Elementgruppen, Attribute, Attributgruppen, Nachrichten und Datentypen verwenden bzw. referenzieren existierende globale Typen, Elemente, Elementgruppen, Attribute und Attributgruppen. <xsl:text/>
                  <xsl:value-of select="if (@name) then @name else parent::*/@name"/>
                  <xsl:text/> verletzt diese Vorgabe: <xsl:text/>
                  <xsl:value-of select="@typ|@basistyp|@referenz"/>
                  <xsl:text/> ist nicht erreichbar.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M19"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M19"/>
   <xsl:template match="@*|node()" priority="-2" mode="M19">
      <xsl:apply-templates select="*" mode="M19"/>
   </xsl:template>
   <!--PATTERN pattern.NDR-28.008Referenzierung von Elementreferenzen auf globale Elemente und Elementgruppen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Referenzierung von Elementreferenzen auf globale Elemente und Elementgruppen</svrl:text>
   <!--RULE -->
   <xsl:template match="fm:eigenschaft[(not(@xsdAttribute) or @xsdAttribute = false()) and @referenz]"
                 priority="1000"
                 mode="M20">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(empty((lite:resolve(@referenz, ., true()))))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(empty((lite:resolve(@referenz, ., true()))))">
               <xsl:attribute name="id">NDR-28.008</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>NDR-28.008: Elementreferenzen müssen auf globale Elemente oder Elementgruppen referenzieren. Das Element <xsl:text/>
                  <xsl:value-of select="@name | @referenz"/>
                  <xsl:text/> in <xsl:text/>
                  <xsl:value-of select="ancestor::fm:datentyp/@name | ancestor::fm:eigenschaft/@name | ancestor::fm:globaleEigenschaft/@name"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M20"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M20"/>
   <xsl:template match="@*|node()" priority="-2" mode="M20">
      <xsl:apply-templates select="*" mode="M20"/>
   </xsl:template>
   <!--PATTERN pattern.NDR-28.009Schema Location für Schema-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Schema Location für Schema</svrl:text>
   <!--RULE -->
   <xsl:template match="fm:xsdSchema[not(lite:schema-location(.))]"
                 priority="1000"
                 mode="M21">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">NDR-28.009</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>NDR-28.009: XML Schema-Definitionen müssen eine Schema Location besitzen, entweder über schemaLocation am Schema oder über schemaLocationBase am XÖV-Fachmodell. Das Schema <xsl:text/>
                  <xsl:value-of select="@name"/>
                  <xsl:text/> besitzt keine Schema Location. Gleichzeitig ist auch keine Schema Location Base für das XÖV-Fachmodell spezifiziert.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M21"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M21"/>
   <xsl:template match="@*|node()" priority="-2" mode="M21">
      <xsl:apply-templates select="*" mode="M21"/>
   </xsl:template>
   <!--PATTERN pattern.NDR-28.010Eindeutiger Dateinamen für Schema-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Eindeutiger Dateinamen für Schema</svrl:text>
   <!--RULE -->
   <xsl:template match="fm:xsdSchema" priority="1000" mode="M22">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="                not(count(                ancestor::fm:xoev-fachmodell//fm:xsdSchema[@schemaFile = current()/@schemaFile]) &gt; 1)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(count( ancestor::fm:xoev-fachmodell//fm:xsdSchema[@schemaFile = current()/@schemaFile]) &gt; 1)">
               <xsl:attribute name="id">NDR-28.010</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>NDR-28.010: XML Schema-Definitionen müssen im XÖV-Fachmodell eindeutige Dateinamen (schemaFile) aufweisen. Der Dateiname <xsl:text/>
                  <xsl:value-of select="@schemaFile"/>
                  <xsl:text/> im Schema <xsl:text/>
                  <xsl:value-of select="@name"/>
                  <xsl:text/> ist nicht eindeutig.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M22"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M22"/>
   <xsl:template match="@*|node()" priority="-2" mode="M22">
      <xsl:apply-templates select="*" mode="M22"/>
   </xsl:template>
   <!--PATTERN pattern.NDR-28.011Eindeutige Schema Location für Schema-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Eindeutige Schema Location für Schema</svrl:text>
   <!--RULE -->
   <xsl:template match="fm:xsdSchema" priority="1000" mode="M23">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="                not(count(                ancestor::fm:xoev-fachmodell//fm:xsdSchema[                lite:schema-location(.) = lite:schema-location(current())]) &gt; 1)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(count( ancestor::fm:xoev-fachmodell//fm:xsdSchema[ lite:schema-location(.) = lite:schema-location(current())]) &gt; 1)">
               <xsl:attribute name="id">NDR-28.011</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>NDR-28.011: XML Schema-Definitionen müssen im XÖV-Fachmodell eindeutige Schema Locations aufweisen, entweder über schemaLocation am Schema oder über eine Kombination aus schemaLocationBase am XÖV-Fachmodell und schemaFile des Schema. Die folgende Schema Location wird mehrfach verwendet: <xsl:text/>
                  <xsl:value-of select="lite:schema-location(.)"/>
                  <xsl:text/>
               </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M23"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M23"/>
   <xsl:template match="@*|node()" priority="-2" mode="M23">
      <xsl:apply-templates select="*" mode="M23"/>
   </xsl:template>
   <!--PATTERN pattern.NDR-28.012Ausschließlich Elemente in Elementgruppen und Attribute in Attributgruppen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Ausschließlich Elemente in Elementgruppen und Attribute in Attributgruppen</svrl:text>
   <!--RULE -->
   <xsl:template match="fm:globaleEigenschaftengruppe[descendant::fm:eigenschaft][not((count(descendant::fm:eigenschaft) = count(descendant::fm:eigenschaft[@xsdAttribute = 'true'])) or (count(descendant::fm:eigenschaft) = count(descendant::fm:eigenschaft[not(@xsdAttribute) or @xsdAttribute = 'false'])))]"
                 priority="1000"
                 mode="M24">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">NDR-18-012</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>NDR-28.012: Globale Elementgruppen besitzen ausschließlich nur Elemente, globale Attributgruppen besitzen ausschließlich Attribute. Die Gruppe <xsl:text/>
                  <xsl:value-of select="@name"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M24"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M24"/>
   <xsl:template match="@*|node()" priority="-2" mode="M24">
      <xsl:apply-templates select="*" mode="M24"/>
   </xsl:template>
   <!--PATTERN pattern.NDR-28.013Keine erweiternden Elemente oder Attribute für per Restriktion definierte Typen, Nachrichten und globale Elemente-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Keine erweiternden Elemente oder Attribute für per Restriktion definierte Typen, Nachrichten und globale Elemente</svrl:text>
   <!--RULE -->
   <xsl:template match="fm:datentyp[@basistyp and @restriction = 'true'] | fm:nachricht[@basistyp and @restriction = 'true'] | fm:globaleEigenschaft[@basistyp and @restriction = 'true']"
                 priority="1000"
                 mode="M25">
      <xsl:variable name="baustein" select="."/>
      <xsl:variable name="basistyp" select="lite:resolve(@basistyp, ., false())"/>
      <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="                (every $p in $baustein/(lite:attributes(.), lite:elements(.))                   satisfies                   $basistyp/(lite:all-attributes(.), lite:all-elements(.))[@name = $p/@name and @typ]/lite:resolve(@typ, $basistyp, false())[                                      (if ($p[@typ]/lite:resolve(@typ, $p, false())[name() = 'codeDatentyp']) then                      *:metadaten.xoevDatentyp/*:kennung = 'urn:xoev-de:kosit:xoev:datentyp:code' or name() = 'codeDatentyp'                   else                      lite:equal-object(., $p[@typ]/lite:resolve(@typ, $p, false())/(., lite:all-restriction-parents(.))))]                                      and                                      $basistyp/(lite:all-attributes(.), lite:all-elements(.))[@name = $p/@name and                   lite:eigenschaft-lower-bound($p) ge lite:eigenschaft-lower-bound(.) and                   (lite:eigenschaft-upper-bound(.) = '*' or                   lite:eigenschaft-upper-bound($p) != '*' and xs:integer(lite:eigenschaft-upper-bound($p)) le xs:integer(lite:eigenschaft-upper-bound(.)))]) and                ($baustein/@gruppe.art = 'choice' or (every $p in $basistyp/(lite:all-attributes(.), lite:all-elements(.))                   satisfies                   tokenize($p/@multiplizitaet, '\.\.')[1] = '0' or $baustein/(lite:attributes(.), lite:elements(.))[@name = $p/@name]))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="(every $p in $baustein/(lite:attributes(.), lite:elements(.)) satisfies $basistyp/(lite:all-attributes(.), lite:all-elements(.))[@name = $p/@name and @typ]/lite:resolve(@typ, $basistyp, false())[ (if ($p[@typ]/lite:resolve(@typ, $p, false())[name() = 'codeDatentyp']) then *:metadaten.xoevDatentyp/*:kennung = 'urn:xoev-de:kosit:xoev:datentyp:code' or name() = 'codeDatentyp' else lite:equal-object(., $p[@typ]/lite:resolve(@typ, $p, false())/(., lite:all-restriction-parents(.))))] and $basistyp/(lite:all-attributes(.), lite:all-elements(.))[@name = $p/@name and lite:eigenschaft-lower-bound($p) ge lite:eigenschaft-lower-bound(.) and (lite:eigenschaft-upper-bound(.) = '*' or lite:eigenschaft-upper-bound($p) != '*' and xs:integer(lite:eigenschaft-upper-bound($p)) le xs:integer(lite:eigenschaft-upper-bound(.)))]) and ($baustein/@gruppe.art = 'choice' or (every $p in $basistyp/(lite:all-attributes(.), lite:all-elements(.)) satisfies tokenize($p/@multiplizitaet, '\.\.')[1] = '0' or $baustein/(lite:attributes(.), lite:elements(.))[@name = $p/@name]))">
               <xsl:attribute name="id">NDR-28.013</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>NDR-28.013: Per XML-Restriktion (restriction) abgeleitete Typen, Nachricht oder globale Elemente dürfen keine zusätzlichen Elemente oder Attribute mehr hinzufügen. Die Typen der enthalten Elemente und Attribute müssen gleich den Typen der entpsrechenden Elemente und Attribute im Basistyp sein bzw. diese einschränken. Ebenso müssen die Multiplizitäten der Elementen und Attribute gleich bzw. eingeschränkt gegenüber den Multiplizitäten im Basistyp sein. <xsl:text/>
                  <xsl:value-of select="@name"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M25"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M25"/>
   <xsl:template match="@*|node()" priority="-2" mode="M25">
      <xsl:apply-templates select="*" mode="M25"/>
   </xsl:template>
   <!--PATTERN pattern.NDR-28.014Keine Verwendung von im Entwurf befindlichen Typen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Keine Verwendung von im Entwurf befindlichen Typen</svrl:text>
   <!--RULE -->
   <xsl:template match="fm:eigenschaft[@typ]|fm:globaleEigenschaft[@typ]|fm:nachricht[@typ]"
                 priority="1000"
                 mode="M26">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@draft = 'true' or ((lite:resolve(@typ, ., false())/@draft = 'true')           and parent::*/@draft = 'false'))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@draft = 'true' or ((lite:resolve(@typ, ., false())/@draft = 'true') and parent::*/@draft = 'false'))">
               <xsl:attribute name="id">NDR-28.014</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>NDR-28.014: Elemente und Attribute dürfen keine sich im Entwurf befindenden benannten Typen (draft) nutzen, sofern sie nicht selbst Teil eines Entwurfs sind. <xsl:text/>
                  <xsl:value-of select="./@name"/>
                  <xsl:text/> in <xsl:text/>
                  <xsl:value-of select="parent::*/@name"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M26"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M26"/>
   <xsl:template match="@*|node()" priority="-2" mode="M26">
      <xsl:apply-templates select="*" mode="M26"/>
   </xsl:template>
   <!--PATTERN pattern.NDR-28.015Keine Verwendung von im Entwurf befindlichen globalen Elementen, Elementgruppen, Attributen und Attributgruppen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Keine Verwendung von im Entwurf befindlichen globalen Elementen, Elementgruppen, Attributen und Attributgruppen</svrl:text>
   <!--RULE -->
   <xsl:template match="fm:eigenschaft[@referenz]|fm:globaleEigenschaft[@referenz]|fm:nachricht[@referenz]"
                 priority="1000"
                 mode="M27">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@draft = 'true' or (lite:resolve(@referenz, ., true())/@draft = 'true'))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@draft = 'true' or (lite:resolve(@referenz, ., true())/@draft = 'true'))">
               <xsl:attribute name="id">NDR-28.015</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>NDR-28.015: Elemente und Attribute dürfen keine sich im Entwurf befindenden globalen Elemente, Elementgruppen, Attribute und Attributgruppen nutzen, sofern sie nicht selbst Teil eines Entwurfs sind. <xsl:text/>
                  <xsl:value-of select="./@name"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M27"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M27"/>
   <xsl:template match="@*|node()" priority="-2" mode="M27">
      <xsl:apply-templates select="*" mode="M27"/>
   </xsl:template>
   <!--PATTERN pattern.NDR-28.016Korrekte Elementreihenfolge bei einschränkenden Datentypen, Nachrichten und globalen Elementen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Korrekte Elementreihenfolge bei einschränkenden Datentypen, Nachrichten und globalen Elementen</svrl:text>
   <!--RULE -->
   <xsl:template match="             fm:datentyp[@basistyp and @restriction = 'true' and @gruppe.art != 'all'] | fm:nachricht[@basistyp and @restriction = 'true' and @gruppe.art != 'all'] |             fm:globaleEigenschaft[@basistyp and @restriction = 'true' and @gruppe.art != 'all']"
                 priority="1000"
                 mode="M28">
      <xsl:variable name="baustein" select="."/>
      <xsl:variable name="basistyp" select="lite:resolve(@basistyp, ., false())"/>
      <xsl:variable name="elemente-basistyp"
                    select="                $basistyp/lite:all-elements(.)[(if (@referenz) then                   lite:resolve(@referenz, ., true())/@name                else                   @name) = $baustein/lite:elements(.)/(if (@referenz) then                   lite:resolve(@referenz, ., true())/@name                else                   @name)]"/>
      <xsl:variable name="elemente-baustein" select="$baustein/lite:elements(.)"/>
      <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="                every $eb in $elemente-baustein                   satisfies count($elemente-baustein[lite:position($baustein, .) le lite:position($baustein, $eb)]) =                   count($elemente-basistyp[lite:get-global-position($basistyp, .) le lite:get-global-position($basistyp, $eb)])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="every $eb in $elemente-baustein satisfies count($elemente-baustein[lite:position($baustein, .) le lite:position($baustein, $eb)]) = count($elemente-basistyp[lite:get-global-position($basistyp, .) le lite:get-global-position($basistyp, $eb)])">
               <xsl:attribute name="id">NDR-28.016</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>NDR-28.016: Elemente in einem per Restriktion eingeschränkenden Datentyp, Nachricht oder globalen Element müssen die gleiche Reihenfolge wie die Elemente des Basistyps aufweisen. <xsl:text/>
                  <xsl:value-of select="@name"/>
                  <xsl:text/> verletzt diese Vorgabe. Elementreihenfolge des Basistyps: <xsl:text/>
                  <xsl:value-of select="lite:element-sequence($basistyp)"/>
                  <xsl:text/> Elementreihenfolge des eingeschränkten Typs, Nachricht oder globalen Elements: <xsl:text/>
                  <xsl:value-of select="lite:element-sequence($baustein)"/>
                  <xsl:text/>
               </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M28"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M28"/>
   <xsl:template match="@*|node()" priority="-2" mode="M28">
      <xsl:apply-templates select="*" mode="M28"/>
   </xsl:template>
   <!--PATTERN pattern.NDR-28.017Facetten zur Restriktion nur bei einfachen Datentypen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Facetten zur Restriktion nur bei einfachen Datentypen</svrl:text>
   <!--RULE -->
   <xsl:template match="fm:datentyp[not(empty(@basistyp)) and @restriction = 'true'][@fractionDigits or @length or @totalDigits or @maxExclusive or          @maxInclusive or @maxLength or @minInclusive or @minInclusive or @minLength or @pattern or          @whitespace]"
                 priority="1000"
                 mode="M29">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="             lite:is-simple-type(.) = true()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="lite:is-simple-type(.) = true()">
               <xsl:attribute name="id">NDR-28.017</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>NDR-28.017: Restriction-Facetten dürfen ausschließich im Kontext von Datentypen mit einfachem Inhalt genutzt werden. Der Datentyp <xsl:text/>
                  <xsl:value-of select="@name"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M29"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M29"/>
   <xsl:template match="@*|node()" priority="-2" mode="M29">
      <xsl:apply-templates select="*" mode="M29"/>
   </xsl:template>
   <!--PATTERN pattern.NDR-28.018Facette fractionsDigits nur zur Einschränkung von bestimmten einfachen Datentypen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Facette fractionsDigits nur zur Einschränkung von bestimmten einfachen Datentypen</svrl:text>
   <!--RULE -->
   <xsl:template match="fm:datentyp[@restriction = 'true'][@fractionDigits]"
                 priority="1000"
                 mode="M30">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="            lite:topmost-parent(.)[empty(ancestor::xsdSchema) and @name = 'decimal']"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="lite:topmost-parent(.)[empty(ancestor::xsdSchema) and @name = 'decimal']">
               <xsl:attribute name="id">NDR-28.018</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>NDR-28.018: Datentypen, die per Restriktion mit der Facette fractionDigits ableiten, müssen den W3C-Datentyp xs:decimal als Basistyp haben. Der Datentyp <xsl:text/>
                  <xsl:value-of select="@name"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M30"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M30"/>
   <xsl:template match="@*|node()" priority="-2" mode="M30">
      <xsl:apply-templates select="*" mode="M30"/>
   </xsl:template>
   <!--PATTERN pattern.NDR-28.019Facette length nur zur Einschränkung von bestimmten einfachen Datentypen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Facette length nur zur Einschränkung von bestimmten einfachen Datentypen</svrl:text>
   <!--RULE -->
   <xsl:template match="fm:datentyp[@restriction = 'true'][@length]"
                 priority="1000"
                 mode="M31">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="            lite:topmost-parent(.)[empty(ancestor::xsdSchema) and @name = ('anyURI', 'base64Binary', 'ENTITIES', 'ENTITY', 'hexBinary', 'ID', 'IDREF', 'IDREFS', 'language', 'Name', 'NCName', 'NMTOKEN', 'NMTOKENS', 'normalizedString', 'NOTATION', 'QName', 'string', 'token')]"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="lite:topmost-parent(.)[empty(ancestor::xsdSchema) and @name = ('anyURI', 'base64Binary', 'ENTITIES', 'ENTITY', 'hexBinary', 'ID', 'IDREF', 'IDREFS', 'language', 'Name', 'NCName', 'NMTOKEN', 'NMTOKENS', 'normalizedString', 'NOTATION', 'QName', 'string', 'token')]">
               <xsl:attribute name="id">NDR-28.019</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>NDR-28.019: Datentypen, die per Restriktion mit der Facette length ableiten, müssen den W3C-Datentyp xs:anyURI, base64Binary, xs:ENTITIES, xs:ENTITY, xs:hexBinary, xs:ID, xs:IDREF, xs:IDREFS, xs:language, xs:Name, xs:NCName, xs:NMTOKEN, xs:NMTOKENS, xs:normalizedString, xs:NOTATION, xs:QName, xs:string oder xs:token als Basistyp haben. Der Datentyp <xsl:text/>
                  <xsl:value-of select="@name"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M31"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M31"/>
   <xsl:template match="@*|node()" priority="-2" mode="M31">
      <xsl:apply-templates select="*" mode="M31"/>
   </xsl:template>
   <!--PATTERN pattern.NDR-28.020Ausschluss der Facette length bei Nutzung der Facetten maxLength oder minLength-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Ausschluss der Facette length bei Nutzung der Facetten maxLength oder minLength</svrl:text>
   <!--RULE -->
   <xsl:template match="fm:datentyp[@restriction = 'true'][@length]"
                 priority="1000"
                 mode="M32">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="             empty(@maxLength) and empty(@minLength)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="empty(@maxLength) and empty(@minLength)">
               <xsl:attribute name="id">NDR-28.020</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>NDR-28.020: Die Facette length darf nicht zusammen mit den Facetten maxLength oder minLength angegeben sein. Der Datentyp <xsl:text/>
                  <xsl:value-of select="@name"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M32"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M32"/>
   <xsl:template match="@*|node()" priority="-2" mode="M32">
      <xsl:apply-templates select="*" mode="M32"/>
   </xsl:template>
   <!--PATTERN pattern.NDR-28.021Gegenseitiger Ausschluss der Facetten maxExclusive und maxInclusive-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Gegenseitiger Ausschluss der Facetten maxExclusive und maxInclusive</svrl:text>
   <!--RULE -->
   <xsl:template match="fm:datentyp[@restriction = 'true'][@maxExclusive and @maxInclusive]"
                 priority="1000"
                 mode="M33">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">NDR-28.021</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>NDR-28.021: Die Facetten maxExclusive und maxInclusive schließen sich gegenseitig aus. Der Datentyp <xsl:text/>
                  <xsl:value-of select="@name"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M33"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M33"/>
   <xsl:template match="@*|node()" priority="-2" mode="M33">
      <xsl:apply-templates select="*" mode="M33"/>
   </xsl:template>
   <!--PATTERN pattern.NDR-28.022Gegenseitiger Ausschluss der Facetten minExlusive und minInclusive-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Gegenseitiger Ausschluss der Facetten minExlusive und minInclusive</svrl:text>
   <!--RULE -->
   <xsl:template match="fm:datentyp[@restriction = 'true'][@minExclusive and @minInclusive]"
                 priority="1000"
                 mode="M34">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">NDR-28.022</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>NDR-28.022: Die Facetten minExclusive und minInclusive schließen sich gegenseitig aus. Der Datentyp <xsl:text/>
                  <xsl:value-of select="@name"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M34"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M34"/>
   <xsl:template match="@*|node()" priority="-2" mode="M34">
      <xsl:apply-templates select="*" mode="M34"/>
   </xsl:template>
   <!--PATTERN pattern.NDR-28.023Facette maxExclusive nur zur Einschränkung von bestimmten einfachen Datentypen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Facette maxExclusive nur zur Einschränkung von bestimmten einfachen Datentypen</svrl:text>
   <!--RULE -->
   <xsl:template match="fm:datentyp[@restriction = 'true'][@maxExclusive]"
                 priority="1000"
                 mode="M35">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="            lite:topmost-parent(.)[empty(ancestor::xsdSchema) and @name = ('byte', 'date', 'dateTime', 'decimal', 'double', 'duration', 'float', 'gDay', 'gMonth', 'gYear', 'gYearMonth', 'int', 'integer', 'long', 'negativeInteger', 'nonNegativeInteger', 'nonPositiveInteger', 'positiveInteger', 'short', 'time', 'unsignedByte', 'unsignedInt', 'unsignedLong', 'unsignedShort')]"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="lite:topmost-parent(.)[empty(ancestor::xsdSchema) and @name = ('byte', 'date', 'dateTime', 'decimal', 'double', 'duration', 'float', 'gDay', 'gMonth', 'gYear', 'gYearMonth', 'int', 'integer', 'long', 'negativeInteger', 'nonNegativeInteger', 'nonPositiveInteger', 'positiveInteger', 'short', 'time', 'unsignedByte', 'unsignedInt', 'unsignedLong', 'unsignedShort')]">
               <xsl:attribute name="id">NDR-28.023</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>NDR-28.023: Datentypen, die per Restriktion mit der Facette maxExclusive ableiten, müssen den W3C-Datentyp xs:byte, xs:date, xs:dateTime, xs:decimal, xs:double, xs:duration, xs:float, xs:gDay, xs:gMonth, xs:gYear, xs:gYearMonth, xs:int, xs:integer, xs:long, xs:negativeInteger, xs:nonNegativeInteger, xs:nonPositiveInteger, xs:positiveInteger, xs:short, xs:time, xs:unsignedByte, xs:unsignedInt, xs:unsignedLong oder xs:unsignedShort als Basistyp haben. Der Datentyp <xsl:text/>
                  <xsl:value-of select="@name"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M35"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M35"/>
   <xsl:template match="@*|node()" priority="-2" mode="M35">
      <xsl:apply-templates select="*" mode="M35"/>
   </xsl:template>
   <!--PATTERN pattern.NDR-28.024Facette maxInclusive nur zur Einschränkung von bestimmten einfachen Datentypen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Facette maxInclusive nur zur Einschränkung von bestimmten einfachen Datentypen</svrl:text>
   <!--RULE -->
   <xsl:template match="fm:datentyp[@restriction = 'true'][@maxInclusive]"
                 priority="1000"
                 mode="M36">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="            lite:topmost-parent(.)[empty(ancestor::xsdSchema) and @name = ('byte', 'date', 'dateTime', 'decimal', 'double', 'duration', 'float', 'gDay', 'gMonth', 'gYear', 'gYearMonth', 'int', 'integer', 'long', 'negativeInteger', 'nonNegativeInteger', 'nonPositiveInteger', 'positiveInteger', 'short', 'time', 'unsignedByte', 'unsignedInt', 'unsignedLong', 'unsignedShort')]"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="lite:topmost-parent(.)[empty(ancestor::xsdSchema) and @name = ('byte', 'date', 'dateTime', 'decimal', 'double', 'duration', 'float', 'gDay', 'gMonth', 'gYear', 'gYearMonth', 'int', 'integer', 'long', 'negativeInteger', 'nonNegativeInteger', 'nonPositiveInteger', 'positiveInteger', 'short', 'time', 'unsignedByte', 'unsignedInt', 'unsignedLong', 'unsignedShort')]">
               <xsl:attribute name="id">NDR-28.024</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>NDR-28.024: Datentypen, die per Restriktion mit der Facette maxInclusive ableiten, müssen den W3C-Datentyp xs:byte, xs:date, xs:dateTime, xs:decimal, xs:double, xs:duration, xs:float, xs:gDay, xs:gMonth, xs:gYear, xs:gYearMonth, xs:int, xs:integer, xs:long, xs:negativeInteger, xs:nonNegativeInteger, xs:nonPositiveInteger, xs:positiveInteger, xs:short, xs:time, xs:unsignedByte, xs:unsignedInt, xs:unsignedLong oder xs:unsignedShort als Basistyp haben. Der Datentyp <xsl:text/>
                  <xsl:value-of select="@name"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M36"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M36"/>
   <xsl:template match="@*|node()" priority="-2" mode="M36">
      <xsl:apply-templates select="*" mode="M36"/>
   </xsl:template>
   <!--PATTERN pattern.NDR-28.025Facette maxLength nur zur Einschränkung von bestimmten einfachen Datentypen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Facette maxLength nur zur Einschränkung von bestimmten einfachen Datentypen</svrl:text>
   <!--RULE -->
   <xsl:template match="fm:datentyp[@restriction = 'true'][@maxLength]"
                 priority="1000"
                 mode="M37">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="            lite:topmost-parent(.)[empty(ancestor::xsdSchema) and @name = ('anyURI', 'base64Binary', 'ENTITIES', 'ENTITY', 'hexBinary', 'ID', 'IDREF', 'IDREFS', 'language', 'Name', 'NCName', 'NMTOKEN', 'NMTOKENS', 'normalizedString', 'NOTATION', 'QName', 'string', 'token')]"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="lite:topmost-parent(.)[empty(ancestor::xsdSchema) and @name = ('anyURI', 'base64Binary', 'ENTITIES', 'ENTITY', 'hexBinary', 'ID', 'IDREF', 'IDREFS', 'language', 'Name', 'NCName', 'NMTOKEN', 'NMTOKENS', 'normalizedString', 'NOTATION', 'QName', 'string', 'token')]">
               <xsl:attribute name="id">NDR-28.025</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>NDR-28.025: Datentypen, die per Restriktion mit der Facette maxLength ableiten, müssen den W3C-Datentyp xs:anyURI, base64Binary, xs:ENTITIES, xs:ENTITY, xs:hexBinary, xs:ID, xs:IDREF, xs:IDREFS, xs:language, xs:Name, xs:NCName, xs:NMTOKEN, xs:NMTOKENS, xs:normalizedString, xs:NOTATION, xs:QName, xs:string oder xs:token als Basistyp haben. Der Datentyp <xsl:text/>
                  <xsl:value-of select="@name"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M37"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M37"/>
   <xsl:template match="@*|node()" priority="-2" mode="M37">
      <xsl:apply-templates select="*" mode="M37"/>
   </xsl:template>
   <!--PATTERN pattern.NDR-28.026Facette minExclusive nur zur Einschränkung von bestimmten einfachen Datentypen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Facette minExclusive nur zur Einschränkung von bestimmten einfachen Datentypen</svrl:text>
   <!--RULE -->
   <xsl:template match="fm:datentyp[@restriction = 'true'][@minExclusive]"
                 priority="1000"
                 mode="M38">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="            lite:topmost-parent(.)[empty(ancestor::xsdSchema) and @name = ('byte', 'date', 'dateTime', 'decimal', 'double', 'duration', 'float', 'gDay', 'gMonth', 'gYear', 'gYearMonth', 'int', 'integer', 'long', 'negativeInteger', 'nonNegativeInteger', 'nonPositiveInteger', 'positiveInteger', 'short', 'time', 'unsignedByte', 'unsignedInt', 'unsignedLong', 'unsignedShort')]"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="lite:topmost-parent(.)[empty(ancestor::xsdSchema) and @name = ('byte', 'date', 'dateTime', 'decimal', 'double', 'duration', 'float', 'gDay', 'gMonth', 'gYear', 'gYearMonth', 'int', 'integer', 'long', 'negativeInteger', 'nonNegativeInteger', 'nonPositiveInteger', 'positiveInteger', 'short', 'time', 'unsignedByte', 'unsignedInt', 'unsignedLong', 'unsignedShort')]">
               <xsl:attribute name="id">NDR-28.026</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>NDR-28.026: Datentypen, die per Restriktion mit der Facette minExclusive ableiten, müssen den W3C-Datentyp xs:byte, xs:date, xs:dateTime, xs:decimal, xs:double, xs:duration, xs:float, xs:gDay, xs:gMonth, xs:gYear, xs:gYearMonth, xs:int, xs:integer, xs:long, xs:negativeInteger, xs:nonNegativeInteger, xs:nonPositiveInteger, xs:positiveInteger, xs:short, xs:time, xs:unsignedByte, xs:unsignedInt, xs:unsignedLong oder xs:unsignedShort als Basistyp haben. Der Datentyp <xsl:text/>
                  <xsl:value-of select="@name"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M38"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M38"/>
   <xsl:template match="@*|node()" priority="-2" mode="M38">
      <xsl:apply-templates select="*" mode="M38"/>
   </xsl:template>
   <!--PATTERN pattern.NDR-28.027Facette minInclusive nur zur Einschränkung von bestimmten einfachen Datentypen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Facette minInclusive nur zur Einschränkung von bestimmten einfachen Datentypen</svrl:text>
   <!--RULE -->
   <xsl:template match="fm:datentyp[@restriction = 'true'][@minInclusive]"
                 priority="1000"
                 mode="M39">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="            lite:topmost-parent(.)[empty(ancestor::xsdSchema) and @name = ('byte', 'date', 'dateTime', 'decimal', 'double', 'duration', 'float', 'gDay', 'gMonth', 'gYear', 'gYearMonth', 'int', 'integer', 'long', 'negativeInteger', 'nonNegativeInteger', 'nonPositiveInteger', 'positiveInteger', 'short', 'time', 'unsignedByte', 'unsignedInt', 'unsignedLong', 'unsignedShort')]"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="lite:topmost-parent(.)[empty(ancestor::xsdSchema) and @name = ('byte', 'date', 'dateTime', 'decimal', 'double', 'duration', 'float', 'gDay', 'gMonth', 'gYear', 'gYearMonth', 'int', 'integer', 'long', 'negativeInteger', 'nonNegativeInteger', 'nonPositiveInteger', 'positiveInteger', 'short', 'time', 'unsignedByte', 'unsignedInt', 'unsignedLong', 'unsignedShort')]">
               <xsl:attribute name="id">NDR-28.027</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>NDR-28.027: Datentypen, die per Restriktion mit der Facette minInclusive ableiten, müssen den W3C-Datentyp xs:byte, xs:date, xs:dateTime, xs:decimal, xs:double, xs:duration, xs:float, xs:gDay, xs:gMonth, xs:gYear, xs:gYearMonth, xs:int, xs:integer, xs:long, xs:negativeInteger, xs:nonNegativeInteger, xs:nonPositiveInteger, xs:positiveInteger, xs:short, xs:time, xs:unsignedByte, xs:unsignedInt, xs:unsignedLong oder xs:unsignedShort als Basistyp haben. Der Datentyp <xsl:text/>
                  <xsl:value-of select="@name"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M39"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M39"/>
   <xsl:template match="@*|node()" priority="-2" mode="M39">
      <xsl:apply-templates select="*" mode="M39"/>
   </xsl:template>
   <!--PATTERN pattern.NDR-28.028Facette minLength nur zur Einschränkung von bestimmten einfachen Datentypen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Facette minLength nur zur Einschränkung von bestimmten einfachen Datentypen</svrl:text>
   <!--RULE -->
   <xsl:template match="fm:datentyp[@restriction = 'true'][@minLength]"
                 priority="1000"
                 mode="M40">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="            lite:topmost-parent(.)[empty(ancestor::xsdSchema) and @name = ('anyURI', 'base64Binary', 'ENTITIES', 'ENTITY', 'hexBinary', 'ID', 'IDREF', 'IDREFS', 'language', 'Name', 'NCName', 'NMTOKEN', 'NMTOKENS', 'normalizedString', 'NOTATION', 'QName', 'string', 'token')]"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="lite:topmost-parent(.)[empty(ancestor::xsdSchema) and @name = ('anyURI', 'base64Binary', 'ENTITIES', 'ENTITY', 'hexBinary', 'ID', 'IDREF', 'IDREFS', 'language', 'Name', 'NCName', 'NMTOKEN', 'NMTOKENS', 'normalizedString', 'NOTATION', 'QName', 'string', 'token')]">
               <xsl:attribute name="id">NDR-28.028</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>NDR-28.028: Datentypen, die per Restriktion mit der Facette minLength ableiten, müssen den W3C-Datentyp xs:anyURI, base64Binary, xs:ENTITIES, xs:ENTITY, xs:hexBinary, xs:ID, xs:IDREF, xs:IDREFS, xs:language, xs:Name, xs:NCName, xs:NMTOKEN, xs:NMTOKENS, xs:normalizedString, xs:NOTATION, xs:QName, xs:string oder xs:token als Basistyp haben. Der Datentyp <xsl:text/>
                  <xsl:value-of select="@name"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M40"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M40"/>
   <xsl:template match="@*|node()" priority="-2" mode="M40">
      <xsl:apply-templates select="*" mode="M40"/>
   </xsl:template>
   <!--PATTERN pattern.NDR-28.029Facette pattern nur zur Einschränkung von bestimmten einfachen Datentypen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Facette pattern nur zur Einschränkung von bestimmten einfachen Datentypen</svrl:text>
   <!--RULE -->
   <xsl:template match="fm:datentyp[@restriction = 'true'][@pattern]"
                 priority="1000"
                 mode="M41">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="                lite:topmost-parent(.)[empty(ancestor::xsdSchema) and @name = ('anyURI', 'base64Binary', 'boolean', 'byte', 'date', 'dateTime', 'decimal', 'double', 'duration', 'ENTITY', 'float', 'gDay', 'gMonth', 'gYear', 'gYearMonth', 'hexBinary', 'ID', 'IDREF', 'int', 'integer', 'language', 'long', 'Name', 'NCName', 'negativeInteger', 'NMTOKEN', 'nonNegativeInteger', 'nonPositiveInteger', 'normalizedString', 'NOTATION', 'positiveInteger', 'QName', 'short', 'string', 'time', 'token', 'unsignedByte', 'unsignedInt', 'unsignedLong', 'unsignedShort')]"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="lite:topmost-parent(.)[empty(ancestor::xsdSchema) and @name = ('anyURI', 'base64Binary', 'boolean', 'byte', 'date', 'dateTime', 'decimal', 'double', 'duration', 'ENTITY', 'float', 'gDay', 'gMonth', 'gYear', 'gYearMonth', 'hexBinary', 'ID', 'IDREF', 'int', 'integer', 'language', 'long', 'Name', 'NCName', 'negativeInteger', 'NMTOKEN', 'nonNegativeInteger', 'nonPositiveInteger', 'normalizedString', 'NOTATION', 'positiveInteger', 'QName', 'short', 'string', 'time', 'token', 'unsignedByte', 'unsignedInt', 'unsignedLong', 'unsignedShort')]">
               <xsl:attribute name="id">NDR-28.029</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>NDR-28.029: Datentypen, die per Restriktion mit der Facette pattern ableiten, müssen den W3C-Datentyp xs:anyURI, xs:base64Binary, xs:boolean, xs:byte, xs:date, xs:dateTime, xs:decimal, xs:double, xs:duration, xs:ENTITY, xs:float, xs:gDay, xs:gMonth, xs:gYear, xs:gYearMonth, xs:hexBinary, xs:ID, xs:IDREF, xs:int, xs:integer, xs:language, xs:long, xs:Name, xs:NCName, xs:negativeInteger, xs:NMTOKEN, xs:nonNegativeInteger, xs:nonPositiveInteger, xs:normalizedString, xs:NOTATION, xs:positiveInteger, xs:QName, xs:short, xs:string, xs:time, xs:token, xs:unsignedByte, xs:unsignedInt, xs:unsignedLong oder xs:unsignedShort als Basistyp haben. Der Datentyp <xsl:text/>
                  <xsl:value-of select="@name"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M41"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M41"/>
   <xsl:template match="@*|node()" priority="-2" mode="M41">
      <xsl:apply-templates select="*" mode="M41"/>
   </xsl:template>
   <!--PATTERN pattern.NDR-28.030Facette totalDigits nur zur Einschränkung von bestimmten einfachen Datentypen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Facette totalDigits nur zur Einschränkung von bestimmten einfachen Datentypen</svrl:text>
   <!--RULE -->
   <xsl:template match="fm:datentyp[@restriction = 'true'][@totalDigits]"
                 priority="1000"
                 mode="M42">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="            lite:topmost-parent(.)[empty(ancestor::xsdSchema) and @name = ('byte', 'decimal', 'int', 'integer', 'long', 'negativeInteger', 'nonNegativeInteger', 'nonPositiveInteger', 'positiveInteger', 'short', 'unsignedByte', 'unsignedInt', 'unsignedLong', 'unsignedShort')]"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="lite:topmost-parent(.)[empty(ancestor::xsdSchema) and @name = ('byte', 'decimal', 'int', 'integer', 'long', 'negativeInteger', 'nonNegativeInteger', 'nonPositiveInteger', 'positiveInteger', 'short', 'unsignedByte', 'unsignedInt', 'unsignedLong', 'unsignedShort')]">
               <xsl:attribute name="id">NDR-28.030</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>NDR-28.030: Datentypen, die per Restriktion mit der Facette totalDigits ableiten, müssen den W3C-Datentyp xs:byte, xs:decimal, xs:int, xs:integer, xs:long, xs:negativeInteger, xs:nonNegativeInteger, xs:nonPositiveInteger, xs:positiveInteger, xs:short, xs:unsignedByte, xs:unsignedInt, xs:unsignedLong oder xs:unsignedShort als Basistyp haben. Der Datentyp <xsl:text/>
                  <xsl:value-of select="@name"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M42"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M42"/>
   <xsl:template match="@*|node()" priority="-2" mode="M42">
      <xsl:apply-templates select="*" mode="M42"/>
   </xsl:template>
   <!--PATTERN pattern.NDR-28.031Facette whitespace nur zur Einschränkung von bestimmten einfachen Datentypen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Facette whitespace nur zur Einschränkung von bestimmten einfachen Datentypen</svrl:text>
   <!--RULE -->
   <xsl:template match="fm:datentyp[@restriction = 'true'][@whitespace]"
                 priority="1000"
                 mode="M43">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="            lite:topmost-parent(.)[empty(ancestor::xsdSchema) and @name = ('ENTITIES', 'ENTITY', 'ID', 'IDREF', 'IDREFS', 'Name', 'NCName', 'NMTOKEN', 'NMTOKENS', 'normalizedString', 'string', 'token')]"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="lite:topmost-parent(.)[empty(ancestor::xsdSchema) and @name = ('ENTITIES', 'ENTITY', 'ID', 'IDREF', 'IDREFS', 'Name', 'NCName', 'NMTOKEN', 'NMTOKENS', 'normalizedString', 'string', 'token')]">
               <xsl:attribute name="id">NDR-28.031</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>NDR-28.031: Datentypen, die per Restriktion mit der Facette whitespace ableiten, müssen den W3C-Datentyp xs:ENTITIES, xs:ENTITY, xs:ID, xs:IDREF, xs:IDREFS, xs:language, xs:Name, xs:NCName, xs:NMTOKEN, xs:NMTOKENS, xs:normalizedString, xs:string oder xs:token als Basistyp haben. Der Datentyp <xsl:text/>
                  <xsl:value-of select="@name"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M43"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M43"/>
   <xsl:template match="@*|node()" priority="-2" mode="M43">
      <xsl:apply-templates select="*" mode="M43"/>
   </xsl:template>
   <!--PATTERN pattern.NDR-28.032Eingeschränkte Multiplizität bei Attributen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Eingeschränkte Multiplizität bei Attributen</svrl:text>
   <!--RULE -->
   <xsl:template match="fm:eigenschaft[@xsdAttribute = true() and not((compare(@multiplizitaet, '0..1') = 0 or compare(@multiplizitaet, '1') = 0 or compare(@multiplizitaet, '0') = 0 or not(@multiplizitaet)))]"
                 priority="1000"
                 mode="M44">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">NDR-28.032</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>NDR-28.032: Attribute müssen die Multiplizität 0..1, 1 oder 0 besitzen. Das Attribut <xsl:text/>
                  <xsl:value-of select="@name"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M44"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M44"/>
   <xsl:template match="@*|node()" priority="-2" mode="M44">
      <xsl:apply-templates select="*" mode="M44"/>
   </xsl:template>
   <!--PATTERN pattern.NDR-28.033xsd als Dateiendung von Schema-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">xsd als Dateiendung von Schema</svrl:text>
   <!--RULE -->
   <xsl:template match="             fm:xsdSchema[             not(ends-with(@schemaFile, lower-case('.xsd')))]"
                 priority="1000"
                 mode="M45">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">NDR-28.033</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>NDR-28.033: Dateinamen von XML Schema-Definitionen (schemaFile) müssen "xsd" als Dateiendung beinhalten. Das Schema <xsl:text/>
                  <xsl:value-of select="@name"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M45"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M45"/>
   <xsl:template match="@*|node()" priority="-2" mode="M45">
      <xsl:apply-templates select="*" mode="M45"/>
   </xsl:template>
   <!--PATTERN pattern.NDR-28.034xsd als Dateiendung von Schema Location-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">xsd als Dateiendung von Schema Location</svrl:text>
   <!--RULE -->
   <xsl:template match="             fm:xsdSchema[             not(ends-with(lite:schema-location(.), lower-case('.xsd')))]"
                 priority="1000"
                 mode="M46">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">NDR-28.034</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>NDR-28.034: Schema Locations von XML Schema-Definitionen (schemaLocation) müssen "xsd" als Dateiendung beinhalten. Das Schema <xsl:text/>
                  <xsl:value-of select="@name"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M46"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M46"/>
   <xsl:template match="@*|node()" priority="-2" mode="M46">
      <xsl:apply-templates select="*" mode="M46"/>
   </xsl:template>
   <!--PATTERN pattern.NDR-28.035Elemente, Elementgruppen, Attribute und Attributgruppen mit Typ, Referenz oder lokaler Struktur-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Elemente, Elementgruppen, Attribute und Attributgruppen mit Typ, Referenz oder lokaler Struktur</svrl:text>
   <!--RULE -->
   <xsl:template match="fm:eigenschaft|fm:eigenschaftengruppe"
                 priority="1000"
                 mode="M47">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="           ((@typ and @name and not(@referenz) and not(@basistyp) and not(fm:eigenschaft) and not(fm:eigenschaftengruppe)) or            (@referenz and not(@name) and not(fm:eigenschaft) and not(fm:eigenschaftengruppe)) or            (@name and not(@referenz) and not(fm:eigenschaft) and not(fm:eigenschaftengruppe) and fm:anyStruktur) or            (@name and fm:union and not(fm:eigenschaft) and not(fm:eigenschaftengruppe) and not(@referenz)) or           (@name and @basistyp and not(@typ) and not(@referenz)) or            (@name and (fm:eigenschaft or fm:eigenschaftengruppe) and not(@typ) and not(@referenz)) or           (not(@name) and (fm:eigenschaft or fm:eigenschaftengruppe) and not(@typ) and not(@referenz))) and           (not(@name and @referenz))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="((@typ and @name and not(@referenz) and not(@basistyp) and not(fm:eigenschaft) and not(fm:eigenschaftengruppe)) or (@referenz and not(@name) and not(fm:eigenschaft) and not(fm:eigenschaftengruppe)) or (@name and not(@referenz) and not(fm:eigenschaft) and not(fm:eigenschaftengruppe) and fm:anyStruktur) or (@name and fm:union and not(fm:eigenschaft) and not(fm:eigenschaftengruppe) and not(@referenz)) or (@name and @basistyp and not(@typ) and not(@referenz)) or (@name and (fm:eigenschaft or fm:eigenschaftengruppe) and not(@typ) and not(@referenz)) or (not(@name) and (fm:eigenschaft or fm:eigenschaftengruppe) and not(@typ) and not(@referenz))) and (not(@name and @referenz))">
               <xsl:attribute name="id">NDR-28.035</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>NDR-28.035: Elemente, Elementgruppen, Attribute und Attributgruppen müssen entweder einen Typ, eine Referenz oder eine lokale Struktur besitzen. Wenn eine Referenz vorhanden ist, darf kein Name vorhanden sein - in allen anderen Fällen muss ein Name vorhanden sein. Element / Elementgruppe / Attribut / Attributgruppe mit Namen (<xsl:text/>
                  <xsl:value-of select="@name"/>
                  <xsl:text/>) und/oder Referenz (<xsl:text/>
                  <xsl:value-of select="@referenz"/>
                  <xsl:text/>) in <xsl:text/>
                  <xsl:value-of select="ancestor::fm:datentyp/@name | ancestor::fm:eigenschaft/@name | ancestor::fm:globaleEigenschaft/@name"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M47"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M47"/>
   <xsl:template match="@*|node()" priority="-2" mode="M47">
      <xsl:apply-templates select="*" mode="M47"/>
   </xsl:template>
   <!--PATTERN pattern.NDR-28.036Zyklenfreie Importe und Inkludierungen von Schema-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Zyklenfreie Importe und Inkludierungen von Schema</svrl:text>
   <!--RULE -->
   <xsl:template match="fm:xsdSchema" priority="1000" mode="M48">
      <xsl:variable name="schema" select="."/>
      <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="empty($lite:implicit-and-explicit-schema-include-closure//lite:include[lite:including/@id = $schema/lite:schema-id(.) and $schema/lite:schema-id(.) = lite:included/@id])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="empty($lite:implicit-and-explicit-schema-include-closure//lite:include[lite:including/@id = $schema/lite:schema-id(.) and $schema/lite:schema-id(.) = lite:included/@id])">
               <xsl:attribute name="id">NDR-28.036</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>NDR-28.036: Eine XML Schema-Definition darf sich nicht direkt oder indirekt selbst inkludieren oder importieren. Das Schema <xsl:text/>
                  <xsl:value-of select="$schema/@name"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M48"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M48"/>
   <xsl:template match="@*|node()" priority="-2" mode="M48">
      <xsl:apply-templates select="*" mode="M48"/>
   </xsl:template>
   <!--PATTERN pattern.NDR-28.037Unqualifizierte Elemente bei namensraumübergreifenden Restriktionen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Unqualifizierte Elemente bei namensraumübergreifenden Restriktionen</svrl:text>
   <!--RULE -->
   <xsl:template match="fm:eigenschaft[parent::fm:datentyp[@basistyp and @restriction = 'true'] and @xsdAttribute = false()]         [not(lite:namespace(parent::fm:datentyp) = lite:namespace(lite:resolve(parent::fm:datentyp/@basistyp, parent::fm:datentyp, false())))]"
                 priority="1000"
                 mode="M49">
      <xsl:variable name="basistyp" select="parent::fm:datentyp/@basistyp"/>
      <xsl:variable name="parent" select="parent::fm:datentyp"/>
      <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="           (ancestor::fm:xsdSchema/@elementFormDefault = 'unqualified' or           ancestor::fm:xoev-fachmodell/@elementFormDefault = 'unqualified' or           ./@form = 'unqualified')           and           (every $e in lite:resolve(parent::fm:datentyp/@basistyp, parent::fm:datentyp, false())/lite:elements(.)           satisfies           (($e/@form = 'unqualified' or           (lite:resolve($basistyp, $parent, false())/ancestor::fm:xsdSchema/@elementFormDefault = 'unqualified' or           (lite:resolve($basistyp, $parent, false())/ancestor::fm:xsdXModel/@elementFormDefault = 'unqualified')))))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="(ancestor::fm:xsdSchema/@elementFormDefault = 'unqualified' or ancestor::fm:xoev-fachmodell/@elementFormDefault = 'unqualified' or ./@form = 'unqualified') and (every $e in lite:resolve(parent::fm:datentyp/@basistyp, parent::fm:datentyp, false())/lite:elements(.) satisfies (($e/@form = 'unqualified' or (lite:resolve($basistyp, $parent, false())/ancestor::fm:xsdSchema/@elementFormDefault = 'unqualified' or (lite:resolve($basistyp, $parent, false())/ancestor::fm:xsdXModel/@elementFormDefault = 'unqualified')))))">
               <xsl:attribute name="id">NDR-28.037</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>NDR-28.037: Eine namensraumübergreifende XML-Restriktion zweier Datentypen erfordert, dass alle Elemente der beiden Datentypen unqualifiziert sind (form = "unqualified"). Im Falle der Restriktion zwischen den beiden Datentypen <xsl:text/>
                  <xsl:value-of select="$parent/@name"/>
                  <xsl:text/> (einschränkender Datentyp) und <xsl:text/>
                  <xsl:value-of select="$parent/@basistyp"/>
                  <xsl:text/> (eingeschränkter Datentyp) wird diese Vorgabe nicht eingehalten.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M49"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M49"/>
   <xsl:template match="@*|node()" priority="-2" mode="M49">
      <xsl:apply-templates select="*" mode="M49"/>
   </xsl:template>
   <!--PATTERN pattern.NDR-28.038Ausschließlich einfache Datentypen als Member eines Unions-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Ausschließlich einfache Datentypen als Member eines Unions</svrl:text>
   <!--RULE -->
   <xsl:template match="fm:memberType" priority="1000" mode="M50">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not (. = '') and lite:resolve(., ., false()) and lite:is-simple-type(lite:resolve(., ., false())) = true()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not (. = '') and lite:resolve(., ., false()) and lite:is-simple-type(lite:resolve(., ., false())) = true()">
               <xsl:attribute name="id">NDR-28.038</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>NDR-28.038: Ein Datentyp, der als Member einer XML-Union genutzt wird, muss ein einfacher Datentyp sein. Der Typ <xsl:text/>
                  <xsl:value-of select="."/>
                  <xsl:text/> verletzt diese Vorgabe. Er wird als Member der Union <xsl:text/>
                  <xsl:value-of select="ancestor::fm:datentyp/@name | ancestor::fm:eigenschaft/@name | ancestor::fm:globaleEigenschaft/@name"/>
                  <xsl:text/> genutzt.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M50"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M50"/>
   <xsl:template match="@*|node()" priority="-2" mode="M50">
      <xsl:apply-templates select="*" mode="M50"/>
   </xsl:template>
   <!--PATTERN pattern.NDR-28.039Nur benannte Datentypen als Member eines Unions-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Nur benannte Datentypen als Member eines Unions</svrl:text>
   <!--RULE -->
   <xsl:template match="fm:memberType" priority="1000" mode="M51">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not (. = '')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not (. = '')">
               <xsl:attribute name="id">NDR-28.039</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>NDR-28.039: Ein Datentyp, der als Member einer XML-Union genutzt wird, muss ein benannter Datentyp sein. Union <xsl:text/>
                  <xsl:value-of select="ancestor::fm:datentyp/@name | ancestor::fm:eigenschaft/@name | ancestor::fm:globaleEigenschaft/@name"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M51"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M51"/>
   <xsl:template match="@*|node()" priority="-2" mode="M51">
      <xsl:apply-templates select="*" mode="M51"/>
   </xsl:template>
   <!--PATTERN pattern.NDR-28.040Verweise auf globale Datentypen, globale Attribute, globale Elemente oder globale Gruppen mit Präfix-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Verweise auf globale Datentypen, globale Attribute, globale Elemente oder globale Gruppen mit Präfix</svrl:text>
   <!--RULE -->
   <xsl:template match="fm:datentyp[@basistyp]|         fm:eigenschaft[@typ or @basistyp or @referenz]|         fm:eigenschaftengruppe[@referenz]|                 fm:codeDatentyp[fm:typDesCodeElements]|         fm:nachricht[@typ or @basistyp]|                 fm:globaleEigenschaft[@typ or @basistyp or @referenz]|         fm:union[fm:memberType]"
                 priority="1000"
                 mode="M52">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="           if (fm:memberType) then              ((every $m in fm:memberType               satisfies             (contains($m, ':')))) else if(fm:typDesCodeElements) then contains(fm:typDesCodeElements, ':') else if (@typ) then contains(@typ, ':') else if (@basistyp) then contains(@basistyp, ':') else contains(@referenz, ':')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="if (fm:memberType) then ((every $m in fm:memberType satisfies (contains($m, ':')))) else if(fm:typDesCodeElements) then contains(fm:typDesCodeElements, ':') else if (@typ) then contains(@typ, ':') else if (@basistyp) then contains(@basistyp, ':') else contains(@referenz, ':')">
               <xsl:attribute name="id">NDR-28.040</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>NDR-28.040: Alle Verweise auf globale Datentypen, globale Attribute, globale Elemente oder globale Gruppen müssen mit einem über einen Doppelpunkt abgetrennten Präfix referenziert werden. Im Kontext von <xsl:text/>
                  <xsl:value-of select="@name"/>
                  <xsl:text/> wird diese Vorgabe nicht eingehalten.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M52"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M52"/>
   <xsl:template match="@*|node()" priority="-2" mode="M52">
      <xsl:apply-templates select="*" mode="M52"/>
   </xsl:template>
   <!--PATTERN pattern.NDR-28.041Attribute mit einfachem Typ-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Attribute mit einfachem Typ</svrl:text>
   <!--RULE -->
   <xsl:template match="fm:eigenschaft[@xsdAttribute = 'true' and (@basistyp or @typ)]"
                 priority="1000"
                 mode="M53">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="((lite:resolve(@typ, ., false()) and lite:is-simple-type(lite:resolve(@typ, ., false())) = true()) and            (lite:resolve(@basistyp, ., false()) and lite:is-simple-type(lite:resolve(@basistyp, ., false())) = true()) = false())"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="((lite:resolve(@typ, ., false()) and lite:is-simple-type(lite:resolve(@typ, ., false())) = true()) and (lite:resolve(@basistyp, ., false()) and lite:is-simple-type(lite:resolve(@basistyp, ., false())) = true()) = false())">
               <xsl:attribute name="id">NDR-28.041</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>NDR-28.041: Ein Attribut darf sich nur auf einen einfachen Datentyp beziehen. Im Kontext von <xsl:text/>
                  <xsl:value-of select="@name"/>
                  <xsl:text/> wird diese Vorgabe nicht eingehalten.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M53"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M53"/>
   <xsl:template match="@*|node()" priority="-2" mode="M53">
      <xsl:apply-templates select="*" mode="M53"/>
   </xsl:template>
   <!--PATTERN pattern.NDR-28.042Nur Attribute zur Erweiterung einfacher Datentypen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Nur Attribute zur Erweiterung einfacher Datentypen</svrl:text>
   <!--RULE -->
   <xsl:template match="fm:datentyp[@basistyp and @restriction = 'false' and lite:is-simple-type(lite:resolve(@basistyp, ., false())) = true()]/fm:eigenschaft"
                 priority="1000"
                 mode="M54">
      <xsl:variable name="baustein" select="parent::fm:datentyp"/>
      <xsl:variable name="basistyp" select="lite:resolve(@basistyp, ., false())"/>
      <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@xsdAttribute = 'true'"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@xsdAttribute = 'true'">
               <xsl:attribute name="id">NDR-28.042</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>NDR-28.042: Per XML-Erweiterung (extension) abgeleitete einfache Typen dürfen keine zusätzlichen Elemente mehr hinzufügen. <xsl:text/>
                  <xsl:value-of select="@name"/>
                  <xsl:text/> im Datentyp <xsl:text/>
                  <xsl:value-of select="$baustein/@name"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M54"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M54"/>
   <xsl:template match="@*|node()" priority="-2" mode="M54">
      <xsl:apply-templates select="*" mode="M54"/>
   </xsl:template>
   <!--PATTERN pattern.NDR-29.001Namensraum für Schema-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Namensraum für Schema</svrl:text>
   <!--RULE -->
   <xsl:template match="fm:xsdSchema[empty((@namespace, ancestor::fm:xoev-fachmodell/fm:konfiguration.xoev-fachmodell/fm:namespace)[. != ''])]"
                 priority="1000"
                 mode="M55">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">NDR-29.001</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>NDR-29.001: XML Schema-Definitionen müssen einen Namensraum besitzen, entweder über namespace am XML-Schema oder über namespace am XÖV-Fachmodell. Das XML-Schema <xsl:text/>
                  <xsl:value-of select="@name"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M55"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M55"/>
   <xsl:template match="@*|node()" priority="-2" mode="M55">
      <xsl:apply-templates select="*" mode="M55"/>
   </xsl:template>
   <!--PATTERN pattern.NDR-29.002Namensraumpräfix für Schema-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Namensraumpräfix für Schema</svrl:text>
   <!--RULE -->
   <xsl:template match="fm:xsdSchema[empty((@prefix, ancestor::fm:xoev-fachmodell/fm:konfiguration.xoev-fachmodell/fm:prefix)[. != ''])]"
                 priority="1000"
                 mode="M56">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">NDR-29.002</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>NDR-29.002: XML Schema-Definitionen müssen ein Namensraumpräfix besitzen, entweder über prefix am XML-Schema oder über prefix am XÖV-Fachmodell. Das XML-Schema <xsl:text/>
                  <xsl:value-of select="@name"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M56"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M56"/>
   <xsl:template match="@*|node()" priority="-2" mode="M56">
      <xsl:apply-templates select="*" mode="M56"/>
   </xsl:template>
   <!--PATTERN pattern.NDR-30.001Version für Schema-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Version für Schema</svrl:text>
   <!--RULE -->
   <xsl:template match="fm:xsdSchema[empty((@version, ancestor::fm:xoev-fachmodell/fm:metadaten.versionStandard/fm:version)[. != ''])]"
                 priority="1000"
                 mode="M57">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">NDR-30.001</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>NDR-30.001: XML Schema-Definitionen müssen eine Version besitzen, entweder über version am XML-Schema oder über version am XÖV-Fachmodell. Das XML-Schema <xsl:text/>
                  <xsl:value-of select="@name"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M57"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M57"/>
   <xsl:template match="@*|node()" priority="-2" mode="M57">
      <xsl:apply-templates select="*" mode="M57"/>
   </xsl:template>
   <!--PATTERN pattern.NDR-32.001Kennung des Standards beginnt mit urn:xoev-de:-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Kennung des Standards beginnt mit urn:xoev-de:</svrl:text>
   <!--RULE -->
   <xsl:template match="fm:xoev-fachmodell[not(starts-with(fm:metadaten.standard/fm:kennung, 'urn:xoev-de:'))]"
                 priority="1000"
                 mode="M58">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">NDR-32.001</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>NDR-32.001: Die Kennung des Standards (kennung) muss mit der Zeichenfolge "urn:xoev-de:" beginnen. Die angegebene Kennung <xsl:text/>
                  <xsl:value-of select="fm:xoev-fachmodell/fm:metadaten.standard/fm:kennung"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M58"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M58"/>
   <xsl:template match="@*|node()" priority="-2" mode="M58">
      <xsl:apply-templates select="*" mode="M58"/>
   </xsl:template>
   <!--PATTERN pattern.NDR-32.002Kennung des Standards mit :standard:-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Kennung des Standards mit :standard:</svrl:text>
   <!--RULE -->
   <xsl:template match="fm:xoev-fachmodell[not(contains(fm:metadaten.standard/fm:kennung, ':standard:'))]"
                 priority="1000"
                 mode="M59">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">NDR-32.002</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>NDR-32.002: Die Kennung des Standards (kennung) muss die Zeichenfolge ":standard:" enthalten. Die angegebene Kennung <xsl:text/>
                  <xsl:value-of select="fm:xoev-fachmodell/fm:metadaten.standard/fm:kennung"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M59"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M59"/>
   <xsl:template match="@*|node()" priority="-2" mode="M59">
      <xsl:apply-templates select="*" mode="M59"/>
   </xsl:template>
   <!--PATTERN pattern.NDR-32.003Kennung des Standards mit kleingeschriebenem technischen Namen des Standards-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Kennung des Standards mit kleingeschriebenem technischen Namen des Standards</svrl:text>
   <!--RULE -->
   <xsl:template match="fm:xoev-fachmodell[not(contains(fm:metadaten.standard/fm:kennung, lower-case(fm:metadaten.standard/fm:nameTechnisch)))]"
                 priority="1000"
                 mode="M60">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">NDR-32.003</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>NDR-32.003: Die Kennung des Standards (kennung) muss den technischen Namen des Standards (nameTechnisch) in Kleinschreibung enthalten. Die angegebene Kennung <xsl:text/>
                  <xsl:value-of select="fm:xoev-fachmodell/fm:metadaten.standard/fm:kennung"/>
                  <xsl:text/> verletzt diese Vorgabe und enthält nicht den technischen Namen <xsl:text/>
                  <xsl:value-of select="fm:xoev-fachmodell/fm:metadaten.standard/fm:nameTechnisch"/>
                  <xsl:text/> in Kleinschreibung.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M60"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M60"/>
   <xsl:template match="@*|node()" priority="-2" mode="M60">
      <xsl:apply-templates select="*" mode="M60"/>
   </xsl:template>
   <!--PATTERN pattern.NDR-32.004Kennung des Standards mit xoev nur zu Beginn in urn:xoev-de-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Kennung des Standards mit xoev nur zu Beginn in urn:xoev-de</svrl:text>
   <!--RULE -->
   <xsl:template match="fm:xoev-fachmodell[contains(replace(fm:metadaten.standard/fm:kennung, 'urn:xoev-de', ''), 'xoev')]"
                 priority="1000"
                 mode="M61">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">NDR-32.004</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>NDR-32.004: Die Kennung des Standards (kennung) muss mit der Zeichenfolge "urn:xoev-de:" beginnen, darf die Zeichenfolge "xoev" jedoch an keiner weiteren Stelle enthalten. Die angegebene Kennung <xsl:text/>
                  <xsl:value-of select="fm:xoev-fachmodell/fm:metadaten.standard/fm:kennung"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M61"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M61"/>
   <xsl:template match="@*|node()" priority="-2" mode="M61">
      <xsl:apply-templates select="*" mode="M61"/>
   </xsl:template>
   <!--PATTERN pattern.NDR-32.005Nur erlaubte Zeichen in der Kennung eines Standards-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Nur erlaubte Zeichen in der Kennung eines Standards</svrl:text>
   <!--RULE -->
   <xsl:template match="fm:xoev-fachmodell[replace(fm:metadaten.standard/fm:kennung, '[a-z0-9\.\-,:]', '') != '']"
                 priority="1000"
                 mode="M62">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">NDR-32.005</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>NDR-32.005: Die Kennung des Standards (kennung) darf nur die Zeichen "a-z", "0-9", "-", ":" und "." enthalten. Die angegebene Kennung <xsl:text/>
                  <xsl:value-of select="fm:xoev-fachmodell/fm:metadaten.standard/fm:kennung"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M62"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M62"/>
   <xsl:template match="@*|node()" priority="-2" mode="M62">
      <xsl:apply-templates select="*" mode="M62"/>
   </xsl:template>
   <!--PATTERN pattern.NDR-32.006Nur erlaubte Zeichen im technischen Namen eines Standards-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Nur erlaubte Zeichen im technischen Namen eines Standards</svrl:text>
   <!--RULE -->
   <xsl:template match="fm:xoev-fachmodell[replace(fm:metadaten.standard/fm:nameTechnisch, '[a-zA-Z0-9\.\-,]', '') != '']"
                 priority="1000"
                 mode="M63">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">NDR-32.006</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>NDR-32.006: Der technische Name des Standards (nameTechnisch) darf nur die Zeichen "a-z", "A-Z", "0-9", "-" und "." enthalten. Der angegebene technische Name <xsl:text/>
                  <xsl:value-of select="fm:xoev-fachmodell/fm:metadaten.standard/fm:nameTechnisch"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M63"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M63"/>
   <xsl:template match="@*|node()" priority="-2" mode="M63">
      <xsl:apply-templates select="*" mode="M63"/>
   </xsl:template>
   <!--PATTERN pattern.NDR-32.007Nur erlaubte Zeichen in der Version eines Standards-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Nur erlaubte Zeichen in der Version eines Standards</svrl:text>
   <!--RULE -->
   <xsl:template match="fm:xoev-fachmodell[replace(fm:metadaten.versionStandard/fm:version, '[a-zA-Z0-9\.\-,]', '') != '']"
                 priority="1000"
                 mode="M64">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">NDR-32.007</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>NDR-32.007: Die Version des Standards (version) darf nur die Zeichen "a-z", "A-Z", "0-9", "-", ":" und "." enthalten. Die angegebene Version <xsl:text/>
                  <xsl:value-of select="fm:xoev-fachmodell/fm:metadaten.versionStandard/fm:version"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M64"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M64"/>
   <xsl:template match="@*|node()" priority="-2" mode="M64">
      <xsl:apply-templates select="*" mode="M64"/>
   </xsl:template>
   <!--PATTERN pattern.NDR-33.001token als Basis des Elements code in Code-Datentypen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">token als Basis des Elements code in Code-Datentypen</svrl:text>
   <!--RULE -->
   <xsl:template match="fm:codeDatentyp[fm:typDesCodeElements][not(lite:topmost-parent(fm:typDesCodeElements)[empty(ancestor::xsdSchema) and @name = 'token'] or fm:typDesCodeElements = 'xs:token')]"
                 priority="1000"
                 mode="M65">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">NDR-33.001</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>NDR-33.001: Der über typDesCodeElements (am XÖV-Fachmodell oder Code-Datentyp) bestimmte Datentyp muss xs:token oder ein davon abgeleiteter Datentyp sein. <xsl:text/>
                  <xsl:value-of select="@name"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M65"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M65"/>
   <xsl:template match="@*|node()" priority="-2" mode="M65">
      <xsl:apply-templates select="*" mode="M65"/>
   </xsl:template>
   <!--PATTERN pattern.NDR-33.002Angabe von Kennung und Version für Schema-validierende Codes in Code-Datentypen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Angabe von Kennung und Version für Schema-validierende Codes in Code-Datentypen</svrl:text>
   <!--RULE -->
   <xsl:template match="fm:xoev-fachmodell//fm:codeDatentyp[fm:codesSchemavalidiert = 'true']"
                 priority="1000"
                 mode="M66">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@kennung and @version"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@kennung and @version">
               <xsl:attribute name="id">NDR-33.002</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>NDR-33.002: Code-Datentypen, deren Codes schema-validierend integriert werden sollen, müssen eine Kennung und eine Version für die Codeliste besitzen. <xsl:text/>
                  <xsl:value-of select="@name"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M66"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M66"/>
   <xsl:template match="@*|node()" priority="-2" mode="M66">
      <xsl:apply-templates select="*" mode="M66"/>
   </xsl:template>
   <!--PATTERN pattern.NDR-33.003Definition genutzter Code-Spalte als Code-Spalte der Codelisten-Version-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Definition genutzter Code-Spalte als Code-Spalte der Codelisten-Version</svrl:text>
   <!--RULE -->
   <xsl:template match="fm:xoev-fachmodell//fm:codeDatentyp[fm:genutzteCodeSpalte]"
                 priority="1000"
                 mode="M67">
      <xsl:variable name="genutzteCodeSpalte" select="fm:genutzteCodeSpalte"/>
      <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="some $sp in lite:genutzte-cl-oder-vcl(.)/lite:versioncodeliste-spalten(.)           satisfies           ($sp/@Id = $genutzteCodeSpalte and lite:versioncodeliste-spalte-codeSpalte($sp))           "/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="some $sp in lite:genutzte-cl-oder-vcl(.)/lite:versioncodeliste-spalten(.) satisfies ($sp/@Id = $genutzteCodeSpalte and lite:versioncodeliste-spalte-codeSpalte($sp))">
               <xsl:attribute name="id">NDR-33.003</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>NDR-33.003: Die über genutzteCodeSpalte am Code-Datentyp bestimmte Spalte muss eine Code-Spalte der genutzten Codelisten-Version sein. GenutzteCodeSpalte <xsl:text/>
                  <xsl:value-of select="lite:genutzte-code-spalte(., lite:genutzte-cl-oder-vcl(.))"/>
                  <xsl:text/> in Code-Datentyp <xsl:text/>
                  <xsl:value-of select="@name"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M67"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M67"/>
   <xsl:template match="@*|node()" priority="-2" mode="M67">
      <xsl:apply-templates select="*" mode="M67"/>
   </xsl:template>
   <!--PATTERN pattern.NDR-33.004Korrekte Codelistenmodellierung-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Korrekte Codelistenmodellierung</svrl:text>
   <!--RULE -->
   <xsl:template match="fm:xoev-fachmodell//fm:codeDatentyp[fm:genutzteBeschreibungsspalte]"
                 priority="1000"
                 mode="M68">
      <xsl:variable name="genutzteBeschreibungsspalte"
                    select="fm:genutzteBeschreibungsspalte"/>
      <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="some $sp in lite:genutzte-cl-oder-vcl(.)/lite:versioncodeliste-spalten(.)           satisfies           ($sp/@Id = $genutzteBeschreibungsspalte)           "/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="some $sp in lite:genutzte-cl-oder-vcl(.)/lite:versioncodeliste-spalten(.) satisfies ($sp/@Id = $genutzteBeschreibungsspalte)">
               <xsl:attribute name="id">NDR-33.004</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>NDR-33.004: Die über genutzteBeschreibungsspalte am Code-Datentyp bestimmte Spalte muss eine Spalte der genutzten Codelisten-Version sein. GenutzteBeschreibungsspalte <xsl:text/>
                  <xsl:value-of select="$genutzteBeschreibungsspalte"/>
                  <xsl:text/> in Code-Datentyp <xsl:text/>
                  <xsl:value-of select="@name"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M68"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M68"/>
   <xsl:template match="@*|node()" priority="-2" mode="M68">
      <xsl:apply-templates select="*" mode="M68"/>
   </xsl:template>
   <!--PATTERN pattern.lite.001Beispielwerte nur im erlaubten Kontext-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Beispielwerte nur im erlaubten Kontext</svrl:text>
   <!--RULE -->
   <xsl:template match="fm:beispielwert[parent::fm:datentyp]"
                 priority="1000"
                 mode="M69">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="lite:is-simple-type(./parent::fm:datentyp) = true()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="lite:is-simple-type(./parent::fm:datentyp) = true()">
               <xsl:attribute name="id">lite.001</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>lite.001: Ein Beispielwert darf nur zu einem einfachen Datentyp angegeben werden. Im Kontext des Datentyps <xsl:text/>
                  <xsl:value-of select="parent::fm:datentyp/@name"/>
                  <xsl:text/> wird diese Vorgabe für Beispielwert <xsl:text/>
                  <xsl:value-of select="."/>
                  <xsl:text/> verletzt.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M69"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M69"/>
   <xsl:template match="@*|node()" priority="-2" mode="M69">
      <xsl:apply-templates select="*" mode="M69"/>
   </xsl:template>
   <!--PATTERN pattern.lite.002Beispielewerte nur für lokale Elemente und Attribute mit einfachem Typ-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Beispielewerte nur für lokale Elemente und Attribute mit einfachem Typ</svrl:text>
   <!--RULE -->
   <xsl:template match="fm:beispielwert[parent::fm:eigenschaft/@typ]"
                 priority="1000"
                 mode="M70">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="lite:is-simple-type(lite:resolve(parent::fm:eigenschaft/@typ, ., false()))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="lite:is-simple-type(lite:resolve(parent::fm:eigenschaft/@typ, ., false()))">
               <xsl:attribute name="id">lite.002</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>lite.002: Ein Beispielwert darf nur zu einem lokalen Element oder Attribut mit einfachem Datentyp angegeben werden. Im Kontext von <xsl:text/>
                  <xsl:value-of select="parent::fm:eigenschaft/@name"/>
                  <xsl:text/> in <xsl:text/>
                  <xsl:value-of select="ancestor::fm:datentyp/@name | ancestor::fm:nachricht/@name"/>
                  <xsl:text/> wird diese Vorgabe verletzt.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M70"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M70"/>
   <xsl:template match="@*|node()" priority="-2" mode="M70">
      <xsl:apply-templates select="*" mode="M70"/>
   </xsl:template>
   <!--PATTERN pattern.lite.003Beispielewerte nur für globale Elemente und Attribute mit einfachem Typ-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Beispielewerte nur für globale Elemente und Attribute mit einfachem Typ</svrl:text>
   <!--RULE -->
   <xsl:template match="fm:beispielwert[parent::fm:globaleEigenschaft/@typ]"
                 priority="1000"
                 mode="M71">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="lite:is-simple-type(lite:resolve(parent::fm:globaleEigenschaft/@typ, ., false()))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="lite:is-simple-type(lite:resolve(parent::fm:globaleEigenschaft/@typ, ., false()))">
               <xsl:attribute name="id">lite.003</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>lite.003: Ein Beispielwert darf nur zu einem globalen Element oder Attribut mit einfachen Datentyp angegeben werden. Im Kontext von <xsl:text/>
                  <xsl:value-of select="parent::fm:globaleEigenschaft/@name"/>
                  <xsl:text/> wird diese Vorgabe verletzt.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M71"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M71"/>
   <xsl:template match="@*|node()" priority="-2" mode="M71">
      <xsl:apply-templates select="*" mode="M71"/>
   </xsl:template>
   <!--PATTERN pattern.lite.004Beispielwerte nur für Elemente und Attribute mit Referenz auf Element oder Attribut mit einfachem Typ-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Beispielwerte nur für Elemente und Attribute mit Referenz auf Element oder Attribut mit einfachem Typ</svrl:text>
   <!--RULE -->
   <xsl:template match="fm:beispielwert[parent::fm:eigenschaft/@referenz]"
                 priority="1000"
                 mode="M72">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="lite:is-simple-type(lite:resolve(lite:resolve(parent::fm:eigenschaft/@referenz, ., true())/@typ, ., false()))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="lite:is-simple-type(lite:resolve(lite:resolve(parent::fm:eigenschaft/@referenz, ., true())/@typ, ., false()))">
               <xsl:attribute name="id">lite.004</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>lite.004: Ein Beispielwert darf nur zu einem Element oder Attribut angegeben werden, das auf ein globales Element oder Attribut mit einfachem Datentyp referenziert. Im Kontext von <xsl:text/>
                  <xsl:value-of select="parent::fm:eigenschaft/@referenz"/>
                  <xsl:text/> des Datentyps / der Nachricht <xsl:text/>
                  <xsl:value-of select="ancestor::fm:datentyp/@name | ancestor::fm:nachricht/@name"/>
                  <xsl:text/> wird diese Vorgabe nicht eingehalten.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M72"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M72"/>
   <xsl:template match="@*|node()" priority="-2" mode="M72">
      <xsl:apply-templates select="*" mode="M72"/>
   </xsl:template>
   <!--PATTERN pattern.lite.005Beispielwerte nur für Elemente und Attribute mit Einschränkung auf einfachen Typ-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Beispielwerte nur für Elemente und Attribute mit Einschränkung auf einfachen Typ</svrl:text>
   <!--RULE -->
   <xsl:template match="fm:beispielwert[parent::fm:eigenschaft][not(parent::fm:eigenschaft/@referenz) and not(parent::fm:eigenschaft/@typ)]"
                 priority="1000"
                 mode="M73">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="parent::fm:eigenschaft/@restriction = true() and            lite:is-simple-type(lite:resolve(parent::fm:eigenschaft/@basistyp, ., false()))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="parent::fm:eigenschaft/@restriction = true() and lite:is-simple-type(lite:resolve(parent::fm:eigenschaft/@basistyp, ., false()))">
               <xsl:attribute name="id">lite.005</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>lite.005: Ein Beispielwert darf nur zu einem Element oder Attribut angegeben werden, das einen einfachen Datentyp einschränkt. Im Kontext von <xsl:text/>
                  <xsl:value-of select="parent::fm:eigenschaft/@name"/>
                  <xsl:text/> des Datentyps / der Nachricht <xsl:text/>
                  <xsl:value-of select="ancestor::fm:datentyp/@name | ancestor::fm:nachricht/@name"/>
                  <xsl:text/> wird diese Vorgabe nicht eingehalten.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M73"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M73"/>
   <xsl:template match="@*|node()" priority="-2" mode="M73">
      <xsl:apply-templates select="*" mode="M73"/>
   </xsl:template>
   <!--PATTERN pattern.lite.006Verarbeitbares XÖV-Fachmodell-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Verarbeitbares XÖV-Fachmodell</svrl:text>
   <!--RULE -->
   <xsl:template match="/" priority="1000" mode="M74">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="/child::*[           self::*:xoev-fachmodell and            starts-with(namespace-uri(), 'urn:xoev-de:kosit:xoev:lite:schema:fachmodell_')           ]           "/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="/child::*[ self::*:xoev-fachmodell and starts-with(namespace-uri(), 'urn:xoev-de:kosit:xoev:lite:schema:fachmodell_') ]">
               <xsl:attribute name="id">lite.006</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>lite.006: Das Dokument enthält kein verarbeitbares XÖV-Fachmodell.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M74"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M74"/>
   <xsl:template match="@*|node()" priority="-2" mode="M74">
      <xsl:apply-templates select="*" mode="M74"/>
   </xsl:template>
   <!--PATTERN pattern.lite.007Keine leeren Deklarationen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Keine leeren Deklarationen</svrl:text>
   <!--RULE -->
   <xsl:template match="fm:xoev-fachmodell[attribute::*]|fm:konfiguration.xoev-fachmodell[attribute::*]|fm:metadaten.standard[attribute::*]|         fm:metadaten.versionStandard[attribute::*]|fm:externesModell[attribute::*]|         fm:nutztSchema[attribute::*]|fm:nutztCodeliste[attribute::*]|fm:xsdSchema[attribute::*]|fm:osciTransportScenario[attribute::*]|         fm:wsdlService[attribute::*]|fm:umsetzungshinweis[attribute::*]|fm:beschreibung[attribute::*]|         fm:geschaeftsregel[attribute::*]|fm:union[attribute::*]|fm:datentyp[attribute::*]|fm:eigenschaft[attribute::*]|fm:eigenschaftengruppe[attribute::*]|         fm:anyStruktur[attribute::*]|fm:codeDatentyp[attribute::*]|fm:nachricht[attribute::*]|fm:globaleEigenschaftengruppe[attribute::*]|         fm:globaleEigenschaft[attribute::*]|fm:paket[attribute::*]|fm:elementFormDefault[attribute::*]|fm:standardeinstellungEigenschaften[attribute::*]|         fm:nutzungNameElement[attribute::*]|fm:wsdlStandardaufbauNamensraum[attribute::*]|fm:wsdlStandardaufbauSubjectOperation[attribute::*]|         fm:wsdlDateipraefix[attribute::*]|fm:rechtsgrundlage[attribute::*]|fm:TestaPort[attribute::*]|fm:InternetPort[attribute::*]"
                 priority="1000"
                 mode="M75">

		<!--ASSERT warning-->
      <xsl:choose>
         <xsl:when test="not(./attribute::*[. = ''])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(./attribute::*[. = ''])">
               <xsl:attribute name="id">lite.007</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>lite.007: Alle Deklarationen im XÖV-Fachmodell müssen einen Inhalt haben. Im Kontext der Deklaration <xsl:text/>
                  <xsl:value-of select="attribute::*[. = '']/name()"/>
                  <xsl:text/> unter <xsl:text/>
                  <xsl:value-of select="string-join(concat(name(), '(', @name, ')'), '/')"/>
                  <xsl:text/> wird diese Vorgabe nicht eingehalten.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M75"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M75"/>
   <xsl:template match="@*|node()" priority="-2" mode="M75">
      <xsl:apply-templates select="*" mode="M75"/>
   </xsl:template>
   <!--PATTERN pattern.lite.008Codelisten mit Kennung liegen im codelists-Verzeichnis vollständig vor-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Codelisten mit Kennung liegen im codelists-Verzeichnis vollständig vor</svrl:text>
   <!--RULE -->
   <xsl:template match="fm:xoev-fachmodell//fm:codeDatentyp[@kennung and not(@version)]"
                 priority="1000"
                 mode="M76">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(empty(lite:genutzte-cl-oder-vcl(.)))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(empty(lite:genutzte-cl-oder-vcl(.)))">
               <xsl:attribute name="id">lite.008</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>lite.008: Alle genutzten Codelisten liegen vollständig im codelists-Verzeichnis vor. Im Kontext der genutzten Codeliste <xsl:text/>
                  <xsl:value-of select="@kennung"/>
                  <xsl:text/> unter <xsl:text/>
                  <xsl:value-of select="@name"/>
                  <xsl:text/> wird diese Vorgabe nicht eingehalten.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M76"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M76"/>
   <xsl:template match="@*|node()" priority="-2" mode="M76">
      <xsl:apply-templates select="*" mode="M76"/>
   </xsl:template>
   <!--PATTERN pattern.lite.009Codelisten mit Kennung und Version liegen im codelists-Verzeichnis vollständig vor-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Codelisten mit Kennung und Version liegen im codelists-Verzeichnis vollständig vor</svrl:text>
   <!--RULE -->
   <xsl:template match="fm:xoev-fachmodell//fm:codeDatentyp[@kennung and @version]"
                 priority="1000"
                 mode="M77">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(empty(lite:genutzte-cl-oder-vcl(.))) and @version = lite:versioncodeliste-version(lite:genutzte-cl-oder-vcl(.))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(empty(lite:genutzte-cl-oder-vcl(.))) and @version = lite:versioncodeliste-version(lite:genutzte-cl-oder-vcl(.))">
               <xsl:attribute name="id">lite.009</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>lite.009: Alle genutzten Codelisten liegen vollständig im codelists-Verzeichnis vor. Im Kontext der genutzten Codeliste <xsl:text/>
                  <xsl:value-of select="@kennung"/>
                  <xsl:text/> (Version: <xsl:text/>
                  <xsl:value-of select="@version"/>
                  <xsl:text/>) unter <xsl:text/>
                  <xsl:value-of select="@name"/>
                  <xsl:text/> wird diese Vorgabe nicht eingehalten.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M77"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M77"/>
   <xsl:template match="@*|node()" priority="-2" mode="M77">
      <xsl:apply-templates select="*" mode="M77"/>
   </xsl:template>
   <!--PATTERN pattern.lite.010Externe Modelle liegen im Modell-Verzeichnis vollständig vor-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Externe Modelle liegen im Modell-Verzeichnis vollständig vor</svrl:text>
   <!--RULE -->
   <xsl:template match="fm:xoev-fachmodell/fm:externesModell[@kennung and @version]"
                 priority="1000"
                 mode="M78">
      <xsl:variable name="externesModell" select="."/>
      <xsl:variable name="anzahlGleichesVorherigesExternesModell"
                    select="count(preceding-sibling::fm:externesModell[@kennung = $externesModell/@kennung and @version = $externesModell/@version])"/>
      <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="$anzahlGleichesVorherigesExternesModell != 0 or not(empty($modelle/*:xoev-fachmodell         [*:metadaten.standard/*:kennung = $externesModell/@kennung and *:metadaten.versionStandard/*:version = $externesModell/@version]) and          empty($modelle/*:xoev-bibliothek         [*:metadaten.bibliothek/*:kennung = $externesModell/@kennung and *:metadaten.versionBibliothek/*:version = $externesModell/@version]))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="$anzahlGleichesVorherigesExternesModell != 0 or not(empty($modelle/*:xoev-fachmodell [*:metadaten.standard/*:kennung = $externesModell/@kennung and *:metadaten.versionStandard/*:version = $externesModell/@version]) and empty($modelle/*:xoev-bibliothek [*:metadaten.bibliothek/*:kennung = $externesModell/@kennung and *:metadaten.versionBibliothek/*:version = $externesModell/@version]))">
               <xsl:attribute name="id">lite.010</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>lite.010: Alle genutzten externen Modelle liegen vollständig im Modell-Verzeichnis vor. Im Kontext des genutzten externen Modells <xsl:text/>
                  <xsl:value-of select="@kennung"/>
                  <xsl:text/> (Version: <xsl:text/>
                  <xsl:value-of select="@version"/>
                  <xsl:text/>) wird diese Vorgabe nicht eingehalten.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M78"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M78"/>
   <xsl:template match="@*|node()" priority="-2" mode="M78">
      <xsl:apply-templates select="*" mode="M78"/>
   </xsl:template>
   <!--PATTERN pattern.lite.011Externe Modelle im XÖV-Fachmodell bestimmt-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Externe Modelle im XÖV-Fachmodell bestimmt</svrl:text>
   <!--RULE -->
   <xsl:template match="fm:xoev-fachmodell" priority="1000" mode="M79">
      <xsl:variable name="fachmodell" select="."/>
      <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="every $externesModell in $modelle         satisfies         (($fachmodell/fm:externesModell[         (($externesModell/*:xoev-fachmodell/*:metadaten.standard/*:kennung = @kennung and $externesModell/*:xoev-fachmodell/*:metadaten.versionStandard/*:version = @version) or          ($externesModell/*:xoev-bibliothek/*:metadaten.bibliothek/*:kennung = @kennung and $externesModell/*:xoev-bibliothek/*:metadaten.versionBibliothek/*:version = @version))]) or          ($externesModell/*:xoev-fachmodell/*:metadaten.standard/*:kennung = $fachmodell/fm:metadaten.standard/fm:kennung and $externesModell/*:xoev-fachmodell/*:metadaten.versionStandard/*:version = $fachmodell/fm:metadaten.versionStandard/fm:version))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="every $externesModell in $modelle satisfies (($fachmodell/fm:externesModell[ (($externesModell/*:xoev-fachmodell/*:metadaten.standard/*:kennung = @kennung and $externesModell/*:xoev-fachmodell/*:metadaten.versionStandard/*:version = @version) or ($externesModell/*:xoev-bibliothek/*:metadaten.bibliothek/*:kennung = @kennung and $externesModell/*:xoev-bibliothek/*:metadaten.versionBibliothek/*:version = @version))]) or ($externesModell/*:xoev-fachmodell/*:metadaten.standard/*:kennung = $fachmodell/fm:metadaten.standard/fm:kennung and $externesModell/*:xoev-fachmodell/*:metadaten.versionStandard/*:version = $fachmodell/fm:metadaten.versionStandard/fm:version))">
               <xsl:attribute name="id">lite.011</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>lite.011: Alle genutzten externen Modelle sollen im XÖV-Fachmodell bestimmt sein. Im Kontext der genutzten externen Modelle 
        <xsl:text/>
                  <xsl:value-of select="           for $externesModell in $modelle           return if            (($fachmodell/fm:externesModell[           (($externesModell/*:xoev-fachmodell/*:metadaten.standard/*:kennung = @kennung and $externesModell/*:xoev-fachmodell/*:metadaten.versionStandard/*:version = @version) or            ($externesModell/*:xoev-bibliothek/*:metadaten.bibliothek/*:kennung = @kennung and $externesModell/*:xoev-bibliothek/*:metadaten.versionBibliothek/*:version = @version))]) or            ($externesModell/*:xoev-fachmodell/*:metadaten.standard/*:kennung = $fachmodell/fm:metadaten.standard/fm:kennung and $externesModell/*:xoev-fachmodell/*:metadaten.versionStandard/*:version = $fachmodell/fm:metadaten.versionStandard/fm:version))           then ''           else if ($externesModell/*:xoev-fachmodell)              then concat($externesModell/*:xoev-fachmodell/*:metadaten.standard/*:kennung, ' (', $externesModell/*:xoev-fachmodell/*:metadaten.versionStandard/*:version, ') - ')             else concat($externesModell/*:xoev-bibliothek/*:metadaten.bibliothek/*:kennung, ' (', $externesModell/*:xoev-bibliothek/*:metadaten.versionBibliothek/*:version, ') - ')           "/>
                  <xsl:text/> wird diese Vorgabe nicht eingehalten.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M79"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M79"/>
   <xsl:template match="@*|node()" priority="-2" mode="M79">
      <xsl:apply-templates select="*" mode="M79"/>
   </xsl:template>
   <!--PATTERN pattern.GP-1.001Paket für Basisdatentypen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Paket für Basisdatentypen</svrl:text>
   <!--RULE -->
   <xsl:template match="fm:xoev-fachmodell[count(fm:paket[@name = 'Basisdatentypen'] | fm:xsdSchema[@name = 'Basisdatentypen']) = 0]"
                 priority="1000"
                 mode="M80">

		<!--ASSERT information-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">GP-1.001</xsl:attribute>
               <xsl:attribute name="role">information</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>GP-1.001: Es wird empfohlen, im XÖV-Fachmodell ein Paket mit Namen "Basisdatentypen" vorzusehen. Das XÖV-Fachmodell enthält kein Paket mit dem Namen "Basisdatentypen".</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M80"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M80"/>
   <xsl:template match="@*|node()" priority="-2" mode="M80">
      <xsl:apply-templates select="*" mode="M80"/>
   </xsl:template>
   <!--PATTERN pattern.GP-1.002Paket für Baukasten-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Paket für Baukasten</svrl:text>
   <!--RULE -->
   <xsl:template match="fm:xoev-fachmodell[count(fm:paket[@name = 'Baukasten'] | fm:xsdSchema[@name = 'Baukasten']) = 0]"
                 priority="1000"
                 mode="M81">

		<!--ASSERT information-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">GP-1.002</xsl:attribute>
               <xsl:attribute name="role">information</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>GP-1.002: Es wird empfohlen, im XÖV-Fachmodell ein Paket mit Namen "Baukasten" vorzusehen. Das XÖV-Fachmodell enthält kein Paket mit dem Namen "Baukasten".</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M81"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M81"/>
   <xsl:template match="@*|node()" priority="-2" mode="M81">
      <xsl:apply-templates select="*" mode="M81"/>
   </xsl:template>
   <!--PATTERN pattern.GP-1.003Paket für Nachrichten oder Fachmodule-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Paket für Nachrichten oder Fachmodule</svrl:text>
   <!--RULE -->
   <xsl:template match="fm:xoev-fachmodell[count(fm:paket[@name = 'Nachrichten' or @name = 'Fachmodule'] | fm:xsdSchema[@name = 'Nachrichten' or @name = 'Fachmodule']) = 0]"
                 priority="1000"
                 mode="M82">

		<!--ASSERT information-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">GP-1.003</xsl:attribute>
               <xsl:attribute name="role">information</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>GP-1.003: Es wird empfohlen, im XÖV-Fachmodell ein Paket mit Namen "Nachrichten" bzw. "Fachmodule" vorzusehen. Das XÖV-Fachmodell enthält kein Paket mit dem Namen "Nachrichten" oder "Fachmodule".</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M82"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M82"/>
   <xsl:template match="@*|node()" priority="-2" mode="M82">
      <xsl:apply-templates select="*" mode="M82"/>
   </xsl:template>
   <!--PATTERN pattern.GP-1.004Mindestens ein Schema für Nachrichten oder Fachmodule-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Mindestens ein Schema für Nachrichten oder Fachmodule</svrl:text>
   <!--RULE -->
   <xsl:template match="         fm:xoev-fachmodell[fm:paket[@name = 'Nachrichten' or @name = 'Fachmodule']         [empty(fm:xsdSchema[not(@name = 'Nachrichtentypen')])]]"
                 priority="1000"
                 mode="M83">

		<!--ASSERT information-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">GP-1.004</xsl:attribute>
               <xsl:attribute name="role">information</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>GP-1.004: Es wird empfohlen, im Paket "Nachrichten" bzw. "Fachmodule" mindestens ein Nachrichtenhauptgruppen-Schema vorzusehen. Das XÖV-Fachmodell enthält nicht mindestens ein Schema im Paket mit dem Namen "Nachrichten" oder "Fachmodule".</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M83"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M83"/>
   <xsl:template match="@*|node()" priority="-2" mode="M83">
      <xsl:apply-templates select="*" mode="M83"/>
   </xsl:template>
   <!--PATTERN pattern.GP-1.005Nachrichten nur in einem Schema für Nachrichten oder Fachmodule-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Nachrichten nur in einem Schema für Nachrichten oder Fachmodule</svrl:text>
   <!--RULE -->
   <xsl:template match="fm:nachricht[not(ancestor-or-self::fm:paket[@name = 'Nachrichten' or @name = 'Fachmodule'] | ancestor-or-self::fm:xsdSchema[@name = 'Nachrichten' or @name = 'Fachmodule'])]"
                 priority="1000"
                 mode="M84">

		<!--ASSERT information-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">GP-1.005</xsl:attribute>
               <xsl:attribute name="role">information</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>GP-1.005: Es wird empfohlen, Nachrichten nur in einem Schema unterhalb des Pakets "Nachrichten" bzw. "Fachmodule" zu spezifizieren. Die Nachricht <xsl:text/>
                  <xsl:value-of select="@name"/>
                  <xsl:text/> entspricht der Empfehlung nicht.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M84"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M84"/>
   <xsl:template match="@*|node()" priority="-2" mode="M84">
      <xsl:apply-templates select="*" mode="M84"/>
   </xsl:template>
   <!--PATTERN pattern.GP-1.006Schema im Paket Nachrichten oder Fachmodule mit mindestens einer Nachricht-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Schema im Paket Nachrichten oder Fachmodule mit mindestens einer Nachricht</svrl:text>
   <!--RULE -->
   <xsl:template match="         fm:xsdSchema[ancestor::fm:paket[@name = 'Nachrichten' or @name = 'Fachmodule']         [not(@name = 'Nachrichtentypen')]]         [count(descendant::fm:nachricht) = 0]"
                 priority="1000"
                 mode="M85">

		<!--ASSERT information-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">GP-1.006</xsl:attribute>
               <xsl:attribute name="role">information</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>GP-1.006: Es wird empfohlen, in einem Schema unterhalb des Paketes "Nachrichten" bzw. "Fachmodule" mindestens eine Nachricht zu spezifieren. Das Schema <xsl:text/>
                  <xsl:value-of select="@name"/>
                  <xsl:text/> entspricht der Empfehlung nicht.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M85"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M85"/>
   <xsl:template match="@*|node()" priority="-2" mode="M85">
      <xsl:apply-templates select="*" mode="M85"/>
   </xsl:template>
   <!--PATTERN pattern.GP-5.001Nutzung von Schema-validierenden Codelistenversionen über benannte Datentypen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Nutzung von Schema-validierenden Codelistenversionen über benannte Datentypen</svrl:text>
   <!--RULE -->
   <xsl:template match="fm:codeDatentyp[fm:benannterCodelistenDatentyp = 'false'][fm:codesSchemavalidiert = 'true'][not(@draft = 'true')]"
                 priority="1000"
                 mode="M86">

		<!--ASSERT information-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">GP-5.001</xsl:attribute>
               <xsl:attribute name="role">information</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>GP-5.001: Es wird empfohlen, Schema-validierende Codelistenversionen über benannte Datentypen einzubinden und diese dann in dem eigentlichen Code-Datentyp zu referenzieren. Im Kontext des Code-Datentyps <xsl:text/>
                  <xsl:value-of select="@name"/>
                  <xsl:text/> wird diese Empfehlung nicht eingehalten.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M86"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M86"/>
   <xsl:template match="@*|node()" priority="-2" mode="M86">
      <xsl:apply-templates select="*" mode="M86"/>
   </xsl:template>
   <!--PATTERN pattern.GP-5.002Namen benannter Datentypen zur Nutzung von Schema-validierenden Codelisten-Versionen eindeutig-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Namen benannter Datentypen zur Nutzung von Schema-validierenden Codelisten-Versionen eindeutig</svrl:text>
   <!--RULE -->
   <xsl:template match="fm:codeDatentyp[fm:benannterCodelistenDatentyp = 'true'][fm:codesSchemavalidiert = 'true'][not(@draft = 'true')][fm:benannterCodelistenDatentypXSD]"
                 priority="1000"
                 mode="M87">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="           not(count(           ancestor::fm:xoev-fachmodell//fm:codeDatentyp[           ./fm:benannterCodelistenDatentypXSD = current()/fm:benannterCodelistenDatentypXSD and ./fm:benannterCodelistenDatentypName = current()/fm:benannterCodelistenDatentypName]) &gt; 1)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(count( ancestor::fm:xoev-fachmodell//fm:codeDatentyp[ ./fm:benannterCodelistenDatentypXSD = current()/fm:benannterCodelistenDatentypXSD and ./fm:benannterCodelistenDatentypName = current()/fm:benannterCodelistenDatentypName]) &gt; 1)">
               <xsl:attribute name="id">GP-5.002</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>GP-5.002: Datentypen, die Schema-validierende Codelisten einbinden und über einen Code-Datentyp referenziert werden, müssen bzgl. ihres Namens eindeutig sein. Der Datentyp <xsl:text/>
                  <xsl:value-of select="fm:benannterCodelistenDatentypXSD"/>
                  <xsl:text/>, der über den Code-Datentyp <xsl:text/>
                  <xsl:value-of select="@name"/>
                  <xsl:text/> benannt wird, hat denselben Namen wie ein anderer Datentyp in dem Schema <xsl:text/>
                  <xsl:value-of select="fm:benannterCodelistenDatentypXSD"/>
                  <xsl:text/>.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M87"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M87"/>
   <xsl:template match="@*|node()" priority="-2" mode="M87">
      <xsl:apply-templates select="*" mode="M87"/>
   </xsl:template>
   <!--PATTERN pattern.GP-5.003Benannte Datentypen zur Nutzung von Schema-validierenden Codelisten-Versionen in einem Schema des XÖV-Standards-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Benannte Datentypen zur Nutzung von Schema-validierenden Codelisten-Versionen in einem Schema des XÖV-Standards</svrl:text>
   <!--RULE -->
   <xsl:template match="fm:codeDatentyp[fm:benannterCodelistenDatentyp = 'true'][fm:codesSchemavalidiert = 'true'][not(@draft = 'true')][fm:benannterCodelistenDatentypXSD]"
                 priority="1000"
                 mode="M88">
      <xsl:variable name="schema" select="fm:benannterCodelistenDatentypXSD"/>
      <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(ancestor::fm:xoev-fachmodell//fm:xsdSchema[@schemaFile = $schema]) = 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(ancestor::fm:xoev-fachmodell//fm:xsdSchema[@schemaFile = $schema]) = 1">
               <xsl:attribute name="id">GP-5.003</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>GP-5.003: Datentypen, die Schema-validierende Codelisten einbinden und über einen Code-Datentyp referenziert werden, müssen zu einem Schema des XÖV-Standards gehören. Der Datentyp <xsl:text/>
                  <xsl:value-of select="fm:benannterCodelistenDatentypXSD"/>
                  <xsl:text/>, der über den Code-Datentyp <xsl:text/>
                  <xsl:value-of select="@name"/>
                  <xsl:text/> referenziert wird, gehört zum Schema <xsl:text/>
                  <xsl:value-of select="fm:benannterCodelistenDatentypXSD"/>
                  <xsl:text/>, das kein Bestandteil des XÖV-Standards ist.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M88"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M88"/>
   <xsl:template match="@*|node()" priority="-2" mode="M88">
      <xsl:apply-templates select="*" mode="M88"/>
   </xsl:template>
   <!--PATTERN pattern.GP-6.001Keine aufeinanderfolgenden Punkte in Namen von Typen, globalen Elementen, Nachrichten und Datentypen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Keine aufeinanderfolgenden Punkte in Namen von Typen, globalen Elementen, Nachrichten und Datentypen</svrl:text>
   <!--RULE -->
   <xsl:template match="fm:globaleEigenschaft[@xsdAttribute = false()] | fm:nachricht | fm:datentyp[@name] | fm:codeDatentyp[@name]"
                 priority="1000"
                 mode="M89">

		<!--ASSERT warning-->
      <xsl:choose>
         <xsl:when test="not(contains(@name, '..'))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(contains(@name, '..'))">
               <xsl:attribute name="id">GP-6.001</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>GP-6.001: Es wird empfohlen, dass die Namen von Typen, globalen Elementen, Nachrichten und Datentypen keine aufeinanderfolgenden Punkte enthalten. <xsl:text/>
                  <xsl:value-of select="@name"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M89"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M89"/>
   <xsl:template match="@*|node()" priority="-2" mode="M89">
      <xsl:apply-templates select="*" mode="M89"/>
   </xsl:template>
   <!--PATTERN pattern.GP-6.002Keine aufeinanderfolgenden Punkte in Namen von Elementen und Attributen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Keine aufeinanderfolgenden Punkte in Namen von Elementen und Attributen</svrl:text>
   <!--RULE -->
   <xsl:template match="fm:eigenschaft[@name]" priority="1000" mode="M90">

		<!--ASSERT warning-->
      <xsl:choose>
         <xsl:when test="not(contains(@name, '..'))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(contains(@name, '..'))">
               <xsl:attribute name="id">GP-6.002</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>GP-6.002: Es wird empfohlen, dass die Namen von Elementen und Attributen keine aufeinanderfolgenden Punkte enthalten. <xsl:text/>
                  <xsl:value-of select="@name"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M90"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M90"/>
   <xsl:template match="@*|node()" priority="-2" mode="M90">
      <xsl:apply-templates select="*" mode="M90"/>
   </xsl:template>
   <!--PATTERN pattern.GP-8.001Großer Buchstabe am Beginn des Namens von Datentypen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Großer Buchstabe am Beginn des Namens von Datentypen</svrl:text>
   <!--RULE -->
   <xsl:template match="fm:datentyp[@name] | fm:codeDatentyp[@name]"
                 priority="1000"
                 mode="M91">

		<!--ASSERT information-->
      <xsl:choose>
         <xsl:when test="not(substring(@name, 1, 1) != upper-case(substring(@name, 1, 1)))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(substring(@name, 1, 1) != upper-case(substring(@name, 1, 1)))">
               <xsl:attribute name="id">GP-8.001</xsl:attribute>
               <xsl:attribute name="role">information</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>GP-8.001: Es wird empfohlen, Namen benannter Typen mit einem Großbuchstaben zu beginnen. <xsl:text/>
                  <xsl:value-of select="@name"/>
                  <xsl:text/> entspricht der Empfehlung nicht.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M91"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M91"/>
   <xsl:template match="@*|node()" priority="-2" mode="M91">
      <xsl:apply-templates select="*" mode="M91"/>
   </xsl:template>
   <!--PATTERN pattern.GP-8.002Kleiner Buchstabe am Beginn des Namens von Elementen und Attributen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Kleiner Buchstabe am Beginn des Namens von Elementen und Attributen</svrl:text>
   <!--RULE -->
   <xsl:template match="fm:eigenschaft[substring(@name, 1, 1) != lower-case(substring(@name, 1, 1))]"
                 priority="1000"
                 mode="M92">

		<!--ASSERT information-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">GP-8.002</xsl:attribute>
               <xsl:attribute name="role">information</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>GP-8.002: Es wird empfohlen, Namen von Elementen und Attributen mit einem Kleinbuchstaben zu beginnen. <xsl:text/>
                  <xsl:value-of select="@name"/>
                  <xsl:text/> entspricht der Empfehlung nicht.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M92"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M92"/>
   <xsl:template match="@*|node()" priority="-2" mode="M92">
      <xsl:apply-templates select="*" mode="M92"/>
   </xsl:template>
   <!--PATTERN pattern.GP-8.003Kleiner Buchstabe am Beginn des Namens von globalen Elementen und Nachrichten-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Kleiner Buchstabe am Beginn des Namens von globalen Elementen und Nachrichten</svrl:text>
   <!--RULE -->
   <xsl:template match="             fm:globaleEigenschaft[@xsdAttribute != true()][substring(@name, 1, 1) != lower-case(substring(@name, 1, 1))] |             fm:nachricht[substring(@name, 1, 1) != lower-case(substring(@name, 1, 1))]"
                 priority="1000"
                 mode="M93">

		<!--ASSERT information-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">GP-8.003</xsl:attribute>
               <xsl:attribute name="role">information</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>GP-8.003: Es wird empfohlen, Namen globaler Elemente und Nachrichten mit einem Kleinbuchstaben zu beginnen. <xsl:text/>
                  <xsl:value-of select="@name"/>
                  <xsl:text/> entspricht der Empfehlung nicht.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M93"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M93"/>
   <xsl:template match="@*|node()" priority="-2" mode="M93">
      <xsl:apply-templates select="*" mode="M93"/>
   </xsl:template>
   <!--PATTERN pattern.GP-9.001Vorangestellter Präfix in Namen von Nachrichten-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Vorangestellter Präfix in Namen von Nachrichten</svrl:text>
   <!--RULE -->
   <xsl:template match="fm:nachricht[count(tokenize(@name, '\.')) lt 2]"
                 priority="1000"
                 mode="M94">

		<!--ASSERT information-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">GP-9.001</xsl:attribute>
               <xsl:attribute name="role">information</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>GP-9.001: Es wird empfohlen, Namen von Nachrichten ein mit einem Punkt abgetrenntes Präfix voranzustellen. <xsl:text/>
                  <xsl:value-of select="@name"/>
                  <xsl:text/> entspricht der Empfehlung nicht.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M94"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M94"/>
   <xsl:template match="@*|node()" priority="-2" mode="M94">
      <xsl:apply-templates select="*" mode="M94"/>
   </xsl:template>
   <!--PATTERN pattern.GP-9.002Vorangestellter Präfix in Namen von Nachrichten entspricht Name des Schema-Pakets-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Vorangestellter Präfix in Namen von Nachrichten entspricht Name des Schema-Pakets</svrl:text>
   <!--RULE -->
   <xsl:template match="fm:nachricht" priority="1000" mode="M95">
      <xsl:variable name="msg-prefix" select="tokenize(@name, '\.')[1]"/>
      <xsl:variable name="msg-prefix-norm"
                    select="concat(lower-case(substring($msg-prefix, 1, 1)), substring($msg-prefix, 2, string-length($msg-prefix)))"/>
      <xsl:variable name="schema-name" select="ancestor::fm:xsdSchema/@name"/>
      <xsl:variable name="schema-name-norm"
                    select="concat(lower-case(substring($schema-name, 1, 1)), substring($schema-name, 2, string-length($schema-name)))"/>
      <!--ASSERT information-->
      <xsl:choose>
         <xsl:when test="$msg-prefix-norm = $schema-name-norm"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="$msg-prefix-norm = $schema-name-norm">
               <xsl:attribute name="id">GP-9.002</xsl:attribute>
               <xsl:attribute name="role">information</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>GP-9.002: Es wird empfohlen, Namen von Nachrichten mit einem Präfix zu versehen, das dem Namen des zugehörigen xsdSchema-Hauptgruppenpakets entspricht (Hinweis: Die Anfangsbuchstaben dürfen sich in ihrer Groß- und Kleinschreibung unterscheiden). <xsl:text/>
                  <xsl:value-of select="@name"/>
                  <xsl:text/> entspricht der Empfehlung nicht.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M95"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M95"/>
   <xsl:template match="@*|node()" priority="-2" mode="M95">
      <xsl:apply-templates select="*" mode="M95"/>
   </xsl:template>
   <!--PATTERN pattern.GP-10.001Nachgestellter numerischer Suffix in Namen von Nachrichten-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Nachgestellter numerischer Suffix in Namen von Nachrichten</svrl:text>
   <!--RULE -->
   <xsl:template match="fm:nachricht[replace(tokenize(@name, '\.')[last()], '[0-9]', '') != '']"
                 priority="1000"
                 mode="M96">

		<!--ASSERT information-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">GP-10.001</xsl:attribute>
               <xsl:attribute name="role">information</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>GP-10.001: Es wird empfohlen, Namen von Nachrichten mit einem Suffix zu versehen, das die Nachrichtennummer repräsentiert, also ausschließlich aus Ziffern besteht. <xsl:text/>
                  <xsl:value-of select="@name"/>
                  <xsl:text/> entspricht der Empfehlung nicht.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M96"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M96"/>
   <xsl:template match="@*|node()" priority="-2" mode="M96">
      <xsl:apply-templates select="*" mode="M96"/>
   </xsl:template>
   <!--PATTERN pattern.GP-10.002Eindeutiger nachgestellter numerischer Suffix in Namen von Nachrichten-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Eindeutiger nachgestellter numerischer Suffix in Namen von Nachrichten</svrl:text>
   <!--RULE -->
   <xsl:template match="fm:nachricht[count(ancestor::fm:xoev-fachmodell//fm:nachricht[tokenize(current()/@name, '\.')[last()] = tokenize(@name, '\.')[last()] and lite:namespace(.) = current()/lite:namespace(.)]) &gt; 1]"
                 priority="1000"
                 mode="M97">

		<!--ASSERT information-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">GP-10.002</xsl:attribute>
               <xsl:attribute name="role">information</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>GP-10.002: Es wird empfohlen, eindeutige Nachrichtennummern zu vergeben. <xsl:text/>
                  <xsl:value-of select="@name"/>
                  <xsl:text/> entspricht der Empfehlung nicht.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M97"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M97"/>
   <xsl:template match="@*|node()" priority="-2" mode="M97">
      <xsl:apply-templates select="*" mode="M97"/>
   </xsl:template>
   <!--PATTERN pattern.GP-11.001Technischer Name des Standards am Beginn des Dateinamens einer Schema-Datei-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Technischer Name des Standards am Beginn des Dateinamens einer Schema-Datei</svrl:text>
   <!--RULE -->
   <xsl:template match="fm:xsdSchema[not(starts-with(lower-case(@schemaFile), lower-case(ancestor::fm:xoev-fachmodell/fm:metadaten.standard/fm:nameTechnisch)))]"
                 priority="1000"
                 mode="M98">

		<!--ASSERT information-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">GP-11.001</xsl:attribute>
               <xsl:attribute name="role">information</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>GP-11.001: Es wird empfohlen, den Namen der XML Schema-Dateien eines Standards (schemaFile) den technischen Namen des Standards (nameTechnisch) voranzustellen. <xsl:text/>
                  <xsl:value-of select="@name"/>
                  <xsl:text/> entspricht der Empfehlung nicht.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M98"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M98"/>
   <xsl:template match="@*|node()" priority="-2" mode="M98">
      <xsl:apply-templates select="*" mode="M98"/>
   </xsl:template>
   <!--PATTERN pattern.GP-11.002Technischer Name des Standards am Beginn der Schema-Location einer Schema-Datei-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Technischer Name des Standards am Beginn der Schema-Location einer Schema-Datei</svrl:text>
   <!--RULE -->
   <xsl:template match="             fm:xsdSchema[not(contains(lower-case(lite:schema-location(.)),             lower-case(ancestor::fm:xoev-fachmodell/fm:metadaten.standard/fm:nameTechnisch)))]"
                 priority="1000"
                 mode="M99">

		<!--ASSERT information-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">GP-11.002</xsl:attribute>
               <xsl:attribute name="role">information</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>GP-11.002: Es wird empfohlen, in der Schema Location eines XML-Schemas (schemaLocation des XML-Schemas bzw. schemaLocationBase des XÖV-Fachmodells in Verbindung mit schemaFile des XML-Schemas) den technischen Namen des Standards (nameTechnisch) aufzuführen. <xsl:text/>
                  <xsl:value-of select="@name"/>
                  <xsl:text/> entspricht der Empfehlung nicht.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M99"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M99"/>
   <xsl:template match="@*|node()" priority="-2" mode="M99">
      <xsl:apply-templates select="*" mode="M99"/>
   </xsl:template>
   <!--PATTERN pattern.GP-12.001Rechtsgrundlage für Nachrichten-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Rechtsgrundlage für Nachrichten</svrl:text>
   <!--RULE -->
   <xsl:template match="fm:nachricht[empty(fm:rechtsgrundlage)]"
                 priority="1000"
                 mode="M100">

		<!--ASSERT information-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">GP-12.001</xsl:attribute>
               <xsl:attribute name="role">information</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>GP-12.001: Es wird empfohlen, für Nachrichten die jeweiligen Rechtsgrundlagen zu dokumentieren. Die Nachricht <xsl:text/>
                  <xsl:value-of select="@name"/>
                  <xsl:text/> entspricht der Empfehlung nicht.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M100"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M100"/>
   <xsl:template match="@*|node()" priority="-2" mode="M100">
      <xsl:apply-templates select="*" mode="M100"/>
   </xsl:template>
   <!--PATTERN pattern.WSDL-2.001Dienst mit gültigem Kommunikationsszenario-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Dienst mit gültigem Kommunikationsszenario</svrl:text>
   <!--RULE -->
   <xsl:template match="fm:wsdlService[fm:Kommunikationsszenario]"
                 priority="1000"
                 mode="M101">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="fm:Kommunikationsszenario = 'one-way-active' or fm:Kommunikationsszenario = 'one-way-passive' or fm:Kommunikationsszenario = 'request-response' or fm:Kommunikationsszenario = 'request-response-noprotocol'"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="fm:Kommunikationsszenario = 'one-way-active' or fm:Kommunikationsszenario = 'one-way-passive' or fm:Kommunikationsszenario = 'request-response' or fm:Kommunikationsszenario = 'request-response-noprotocol'">
               <xsl:attribute name="id">WSDL-2.001</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>WSDL-2.001: Erlaubte Kommunikationsszenarien für Dienste sind one-way-active, one-way-passive, request-response und request-response-noprotocol. Der Dienst <xsl:text/>
                  <xsl:value-of select="@name"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M101"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M101"/>
   <xsl:template match="@*|node()" priority="-2" mode="M101">
      <xsl:apply-templates select="*" mode="M101"/>
   </xsl:template>
   <!--PATTERN pattern.WSDL-3.001Transportszenario mit gültigem Kommunikationsszenario-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Transportszenario mit gültigem Kommunikationsszenario</svrl:text>
   <!--RULE -->
   <xsl:template match="fm:osciTransportScenario[fm:Kommunikationsszenario]"
                 priority="1000"
                 mode="M102">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="fm:Kommunikationsszenario = 'one-way-active' or fm:Kommunikationsszenario = 'one-way-passive' or fm:Kommunikationsszenario = 'request-response' or fm:Kommunikationsszenario = 'request-response-noprotocol'"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="fm:Kommunikationsszenario = 'one-way-active' or fm:Kommunikationsszenario = 'one-way-passive' or fm:Kommunikationsszenario = 'request-response' or fm:Kommunikationsszenario = 'request-response-noprotocol'">
               <xsl:attribute name="id">WSDL-3.001</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>WSDL-3.001: Erlaubte Kommunikationsszenarien für Transportszenarien sind one-way-active, one-way-passive, request-response und request-response-noprotocol. Das OSCI-Transportszenario <xsl:text/>
                  <xsl:value-of select="@name"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M102"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M102"/>
   <xsl:template match="@*|node()" priority="-2" mode="M102">
      <xsl:apply-templates select="*" mode="M102"/>
   </xsl:template>
   <!--PATTERN pattern.WSDL-4.001Dienst mit gültigem Signaturlevel für Inhaltsdaten-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Dienst mit gültigem Signaturlevel für Inhaltsdaten</svrl:text>
   <!--RULE -->
   <xsl:template match="fm:wsdlService[fm:SignaturInhaltsdaten]"
                 priority="1000"
                 mode="M103">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="fm:SignaturInhaltsdaten = 'none' or fm:SignaturInhaltsdaten = 'advanced' or fm:SignaturInhaltsdaten = 'qualified'"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="fm:SignaturInhaltsdaten = 'none' or fm:SignaturInhaltsdaten = 'advanced' or fm:SignaturInhaltsdaten = 'qualified'">
               <xsl:attribute name="id">WSDL-4.001</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>WSDL-4.001: Erlaubtes Signaturlevel für Inhaltsdaten ist none, advanced oder qualified. Der Dienst <xsl:text/>
                  <xsl:value-of select="@name"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M103"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M103"/>
   <xsl:template match="@*|node()" priority="-2" mode="M103">
      <xsl:apply-templates select="*" mode="M103"/>
   </xsl:template>
   <!--PATTERN pattern.WSDL-5.001Transportszenario mit gültigem Signaturlevel für Inhaltsdaten-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Transportszenario mit gültigem Signaturlevel für Inhaltsdaten</svrl:text>
   <!--RULE -->
   <xsl:template match="fm:osciTransportScenario[fm:SignaturInhaltsdaten]"
                 priority="1000"
                 mode="M104">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="fm:SignaturInhaltsdaten = 'none' or fm:SignaturInhaltsdaten = 'advanced' or fm:SignaturInhaltsdaten = 'qualified'"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="fm:SignaturInhaltsdaten = 'none' or fm:SignaturInhaltsdaten = 'advanced' or fm:SignaturInhaltsdaten = 'qualified'">
               <xsl:attribute name="id">WSDL-5.001</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>WSDL-5.001: Erlaubtes Signaturlevel für Inhaltsdaten ist none, advanced oder qualified. Das OSCI-Transportszenario <xsl:text/>
                  <xsl:value-of select="@name"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M104"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M104"/>
   <xsl:template match="@*|node()" priority="-2" mode="M104">
      <xsl:apply-templates select="*" mode="M104"/>
   </xsl:template>
   <!--PATTERN pattern.WSDL-6.001Dienst mit gültigem Signaturlevel für Nutzdaten-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Dienst mit gültigem Signaturlevel für Nutzdaten</svrl:text>
   <!--RULE -->
   <xsl:template match="fm:wsdlService[fm:SignaturNutzdaten]"
                 priority="1000"
                 mode="M105">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="fm:SignaturNutzdaten = 'none' or fm:SignaturNutzdaten = 'advanced' or fm:SignaturNutzdaten = 'qualified'"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="fm:SignaturNutzdaten = 'none' or fm:SignaturNutzdaten = 'advanced' or fm:SignaturNutzdaten = 'qualified'">
               <xsl:attribute name="id">WSDL-6.001</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>WSDL-6.001: Erlaubtes Signaturlevel für Nutzdaten ist none, advanced oder qualified. Der Dienst <xsl:text/>
                  <xsl:value-of select="@name"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M105"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M105"/>
   <xsl:template match="@*|node()" priority="-2" mode="M105">
      <xsl:apply-templates select="*" mode="M105"/>
   </xsl:template>
   <!--PATTERN pattern.WSDL-7.001Transportszenario mit gültigem Signaturlevel für Nutzdaten-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Transportszenario mit gültigem Signaturlevel für Nutzdaten</svrl:text>
   <!--RULE -->
   <xsl:template match="fm:osciTransportScenario[fm:SignaturNutzdaten]"
                 priority="1000"
                 mode="M106">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="fm:SignaturNutzdaten = 'none' or fm:SignaturNutzdaten = 'advanced' or fm:SignaturNutzdaten = 'qualified'"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="fm:SignaturNutzdaten = 'none' or fm:SignaturNutzdaten = 'advanced' or fm:SignaturNutzdaten = 'qualified'">
               <xsl:attribute name="id">WSDL-7.001</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>WSDL-7.001: Erlaubtes Signaturlevel für Nutzdaten ist none, advanced oder qualified. Das OSCI-Transportszenario <xsl:text/>
                  <xsl:value-of select="@name"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M106"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M106"/>
   <xsl:template match="@*|node()" priority="-2" mode="M106">
      <xsl:apply-templates select="*" mode="M106"/>
   </xsl:template>
   <!--PATTERN pattern.WSDL-8.001Nutzung optionaler Container korrekt geregelt in Dienst-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Nutzung optionaler Container korrekt geregelt in Dienst</svrl:text>
   <!--RULE -->
   <xsl:template match="fm:wsdlService[fm:OptionalerContainer]"
                 priority="1000"
                 mode="M107">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="fm:OptionalerContainer = 'true' or fm:OptionalerContainer = 'false'"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="fm:OptionalerContainer = 'true' or fm:OptionalerContainer = 'false'">
               <xsl:attribute name="id">WSDL-8.001</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>WSDL-8.001: Nutzung des optionalen Containers muss geregelt sein ('true' oder 'false'). Der Dienst <xsl:text/>
                  <xsl:value-of select="@name"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M107"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M107"/>
   <xsl:template match="@*|node()" priority="-2" mode="M107">
      <xsl:apply-templates select="*" mode="M107"/>
   </xsl:template>
   <!--PATTERN pattern.WSDL-9.001Nutzung optionaler Container korrekt geregelt in Transportszenario-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Nutzung optionaler Container korrekt geregelt in Transportszenario</svrl:text>
   <!--RULE -->
   <xsl:template match="fm:osciTransportScenario[fm:OptionalerContainer]"
                 priority="1000"
                 mode="M108">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="fm:OptionalerContainer = 'true' or fm:OptionalerContainer = 'false'"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="fm:OptionalerContainer = 'true' or fm:OptionalerContainer = 'false'">
               <xsl:attribute name="id">WSDL-9.001</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>WSDL-9.001: Nutzung des optionalen Containers muss geregelt sein ('true' oder 'false'). Das OSCI-Transportszenario <xsl:text/>
                  <xsl:value-of select="@name"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M108"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M108"/>
   <xsl:template match="@*|node()" priority="-2" mode="M108">
      <xsl:apply-templates select="*" mode="M108"/>
   </xsl:template>
   <!--PATTERN pattern.WSDL-10.001Korrekte Service Messages in one-way-active-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Korrekte Service Messages in one-way-active</svrl:text>
   <!--RULE -->
   <xsl:template match="fm:wsdlService[fm:Kommunikationsszenario = 'one-way-active' or lite:all-parents(.)[fm:osciTransportScenario/fm:Kommunikationsszenario = 'one-way-active']]"
                 priority="1000"
                 mode="M109">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="        count(fm:wsdlServiceMessage) &gt; 0 and not(fm:wsdlServiceInputMessage) and not(fm:wsdlServiceOutputMessage) and not(fm:wsdlServiceFaultMessage)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(fm:wsdlServiceMessage) &gt; 0 and not(fm:wsdlServiceInputMessage) and not(fm:wsdlServiceOutputMessage) and not(fm:wsdlServiceFaultMessage)">
               <xsl:attribute name="id">WSDL-10.001</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>WSDL-10.001: One-way-active-Szenarios beziehen ausschließlich allgemeine Service-Messages ein. Der Dienst <xsl:text/>
                  <xsl:value-of select="@name"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M109"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M109"/>
   <xsl:template match="@*|node()" priority="-2" mode="M109">
      <xsl:apply-templates select="*" mode="M109"/>
   </xsl:template>
   <!--PATTERN pattern.WSDL-11.001Korrekte Service Messages in request-response-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Korrekte Service Messages in request-response</svrl:text>
   <!--RULE -->
   <xsl:template match="fm:wsdlService[fm:Kommunikationsszenario = 'request-response' or lite:all-parents(.)[fm:osciTransportScenario/fm:Kommunikationsszenario = 'request-response']]"
                 priority="1000"
                 mode="M110">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="         not(fm:wsdlServiceMessage) and         count((fm:wsdlServiceInputMessage, fm:wsdlServiceOutputMessage, fm:wsdlServiceFaultMessage)) &gt; 0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(fm:wsdlServiceMessage) and count((fm:wsdlServiceInputMessage, fm:wsdlServiceOutputMessage, fm:wsdlServiceFaultMessage)) &gt; 0">
               <xsl:attribute name="id">WSDL-11.001</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>WSDL-11.001: Request-response-Szenarios beziehen ausschließlich Input- , Output- und Fault-Messages ein. Der Dienst <xsl:text/>
                  <xsl:value-of select="@name"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M110"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M110"/>
   <xsl:template match="@*|node()" priority="-2" mode="M110">
      <xsl:apply-templates select="*" mode="M110"/>
   </xsl:template>
   <!--PATTERN pattern.WSDL-12.001Nicht unterstützte Kommumikationszenarien in Diensten-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Nicht unterstützte Kommumikationszenarien in Diensten</svrl:text>
   <!--RULE -->
   <xsl:template match="fm:wsdlService[fm:Kommunikationsszenario = 'one-way-passive' or fm:wsdlService/fm:Kommunikationsszenario = 'request-response-noprotocol']"
                 priority="1000"
                 mode="M111">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">WSDL-12.001</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>WSDL-12.001: One-way-passive und request-response-noprotocol werden noch nicht unterstützt. Der Dienst <xsl:text/>
                  <xsl:value-of select="@name"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M111"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M111"/>
   <xsl:template match="@*|node()" priority="-2" mode="M111">
      <xsl:apply-templates select="*" mode="M111"/>
   </xsl:template>
   <!--PATTERN pattern.WSDL-12.002Nicht unterstützte Kommunikationsszenarien in Transportszenarien-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Nicht unterstützte Kommunikationsszenarien in Transportszenarien</svrl:text>
   <!--RULE -->
   <xsl:template match="fm:osciTransportScenario[fm:Kommunikationsszenario = 'one-way-passive' or fm:osciTransportScenario/fm:Kommunikationsszenario = 'request-response-noprotocol']"
                 priority="1000"
                 mode="M112">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">WSDL-12.002</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>WSDL-12.002: One-way-passive und request-response-noprotocol werden noch nicht unterstützt. Der Dienst <xsl:text/>
                  <xsl:value-of select="@name"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M112"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M112"/>
   <xsl:template match="@*|node()" priority="-2" mode="M112">
      <xsl:apply-templates select="*" mode="M112"/>
   </xsl:template>
</xsl:stylesheet>
