<?xml version="1.0" encoding="UTF-8"?>

<!-- Version 1.2.0 -->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:gc="http://docs.oasis-open.org/codelist/ns/genericode/1.0/" xmlns:xoev-cl-2="http://xoev.de/schemata/genericode/2" xmlns:xoev-cl-4="http://xoev.de/schemata/genericode/4" xmlns:lite="urn:xoev-de:kosit:xoev:lite:transformation_1.2.0" xmlns:lite-bib="urn:xoev-de:kosit:xoev:lite:schema:bibliothek_1.2.0" xmlns:lite-fm="urn:xoev-de:kosit:xoev:lite:schema:fachmodell_1.2.0" xmlns:xgen="http://www.xoev.de/de/xgenerator/framework/1/library" xpath-default-namespace="urn:xoev-de:kosit:xoev:lite:schema:fachmodell_1.2.0" version="2.0" exclude-result-prefixes="xsl lite gc xoev-cl-2 xoev-cl-4 lite-bib lite-fm xgen">

  <xsl:template match="/" mode="lite:default-lite2xsd">
    <xsl:apply-templates select="xoev-fachmodell" mode="lite:schema.aggregierend"/>
    <xsl:apply-templates select="$xoev-modell/descendant::xsdSchema[not(@draft = 'true' or (ancestor::paket[@name = 'XOEV-Adapter'] and ancestor::lite-bib:xoev-bibliothek))]" mode="lite:document.schema"/>
  </xsl:template>

  <xsl:template match="xoev-fachmodell" mode="lite:schema.aggregierend">
    <xsl:if test="
        every $n in descendant::xsdSchema/@namespace
          satisfies $n = konfiguration.xoev-fachmodell/@namespace">
      <xsl:variable name="suffix" select="
          if (descendant::xsdSchema/@schemaFile = concat(metadaten.standard/nameTechnisch, '.xsd')) then
            '-aggregiert'
          else
            ''"/>
      <xsl:result-document href="{concat($result-directory, '/', metadaten.standard/nameTechnisch, $suffix, '.xsd')}" method="xml">
        <xs:schema targetNamespace="{konfiguration.xoev-fachmodell/namespace}" version="{metadaten.versionStandard/version}" elementFormDefault="{konfiguration.xoev-fachmodell/elementFormDefault}" attributeFormDefault="unqualified">
          <xsl:for-each select="descendant::xsdSchema">
            <xsl:sort select="@schemaFile"/>
            <xs:include schemaLocation="{@schemaFile}"/>
          </xsl:for-each>
        </xs:schema>
      </xsl:result-document>
    </xsl:if>
  </xsl:template>

  <xsl:template match="xsdSchema" mode="lite:document.schema">
    <xsl:call-template name="xgen:result-document">
      <xsl:with-param name="local-path" select="xs:anyURI(@schemaFile)"/>
      <xsl:with-param name="content">
        <xsl:apply-templates select="." mode="lite:schema"/>
      </xsl:with-param>
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="xsdSchema" mode="lite:schema">
    <xsl:variable name="schema" select="."/>
    <xs:schema targetNamespace="{lite:namespace(.)}" attributeFormDefault="unqualified" version="{lite:version(.)}" elementFormDefault="{lite:element-form-default(.)}">
      <xsl:namespace name="{lite:prefix(.)}" select="lite:namespace(.)"/>

      <xsl:for-each select="lite:schema-with-imports-and-includes(.)/import[@kind = 'direct']">
        <xsl:sort select="@prefix"/>
        <xsl:namespace name="{@prefix}" select="@namespace"/>
      </xsl:for-each>

      <xsl:apply-templates select="." mode="lite:annotation.schema"/>

      <xsl:for-each select="lite:schema-with-imports-and-includes(.)/include[@kind = 'direct']">
        <xsl:sort select="@schemaFile"/>
        <xs:include schemaLocation="{@schemaFile}"/>
      </xsl:for-each>
      <xsl:for-each select="lite:schema-with-imports-and-includes(.)/import[@kind = 'direct']">
        <xsl:sort select="@schemaLocation"/>
        <xs:import schemaLocation="{@schemaLocation}" namespace="{@namespace}"/>
      </xsl:for-each>

      <xsl:apply-templates select="
          nachricht[not(@draft = 'true')],
          codeDatentyp[not(@draft = 'true')],
          datentyp[not(@draft = 'true')],
          globaleEigenschaftengruppe[not(@draft = 'true')],
          globaleEigenschaft[not(@draft = 'true')]" mode="lite:baustein"/>

      <xsl:apply-templates select="paket" mode="lite:paket"/>

      <xsl:variable name="codelisten-datentypen" select="
          $xoev-modell/descendant::*:codeDatentyp[
          lite:codeliste-schemavalidiert(.) and
          lite:benannter-codelistendatentyp(.) and
          (benannterCodelistenDatentypXSD, ancestor::xsdSchema/@schemaFile)[1] = $schema/@schemaFile]"/>
      <xsl:if test="$codelisten-datentypen">
        <xsl:comment>Codelisten-Datentypen</xsl:comment>
      </xsl:if>
      <xsl:apply-templates select="$codelisten-datentypen" mode="lite:simpleType.codeliste">
        <xsl:sort select="lite:codelist-simple-type-name(.)"/>
      </xsl:apply-templates>
    </xs:schema>
  </xsl:template>

  <xsl:template match="paket" mode="lite:paket">
    <xsl:comment select="concat('Paket: ', @name)"/>
    <xsl:apply-templates select="
        nachricht[not(@draft = 'true')],
        codeDatentyp[not(@draft = 'true')],
        datentyp[not(@draft = 'true')],
        globaleEigenschaftengruppe[not(@draft = 'true')],
        globaleEigenschaft[not(@draft = 'true')]" mode="lite:baustein"/>
    <xsl:apply-templates select="paket" mode="lite:paket"/>
  </xsl:template>

  <xsl:template match="nachricht" mode="lite:baustein">
    <xsl:apply-templates select="." mode="lite:element.nachricht"/>
  </xsl:template>

  <xsl:template match="codeDatentyp" mode="lite:baustein">
    <xsl:apply-templates select="." mode="lite:complexType.codeDatentyp"/>
  </xsl:template>

  <xsl:template match="datentyp" mode="lite:baustein">
    <xsl:apply-templates select="." mode="lite:datentyp"/>
  </xsl:template>

  <xsl:template match="globaleEigenschaftengruppe" mode="lite:baustein">
    <xsl:apply-templates select=".[not(@xsdAttribute = 'true')]" mode="lite:group.globaleEigenschaftengruppe"/>
  </xsl:template>

  <xsl:template match="globaleEigenschaft" mode="lite:baustein">
    <xsl:apply-templates select="." mode="lite:element.globaleEigenschaft"/>
  </xsl:template>

  <xsl:template match="codeDatentyp" mode="lite:simpleType.codeliste">
    <xsl:variable name="codeDatentyp" select="."/>
    <xsl:variable name="gc-codeliste" select="lite:genutzte-cl-oder-vcl(.)"/>
    <xs:simpleType name="{lite:codelist-simple-type-name(.)}">
      <xsl:apply-templates select="." mode="lite:annotation.codeliste">
        <xsl:with-param name="gc-codeliste" select="$gc-codeliste"/>
      </xsl:apply-templates>
      <xsl:apply-templates select="." mode="lite:restriction.codeliste">
        <xsl:with-param name="gc-codeliste" select="$gc-codeliste"/>
      </xsl:apply-templates>
    </xs:simpleType>
  </xsl:template>

  <xsl:template match="codeDatentyp" mode="lite:restriction.codeliste">
    <xsl:param name="gc-codeliste" as="element()?" required="yes"/>
    <xsl:variable name="codeDatentyp" select="."/>
    <xsl:variable name="code-spalte" select="lite:genutzte-code-spalte($codeDatentyp, $gc-codeliste)"/>
    <xs:restriction base="{(typDesCodeElements, (ancestor::xoev-fachmodell, ancestor::lite-bib:xoev-bibliothek)/konfiguration.xoev-fachmodell/typDesCodeElements, 'xs:token')[1]}">
      <xsl:for-each select="$gc-codeliste/lite:versioncodeliste-zeilen(.)">
        <xsl:sort select="lite:versioncodeliste-zeile-spaltenwert(., $code-spalte)"/>
        <xsl:variable name="zeile" select="."/>
        <xs:enumeration value="{lite:versioncodeliste-zeile-spaltenwert(.,$code-spalte)}">
          <xs:annotation>
            <xs:appinfo>
              <xsl:for-each select="
                  lite:versioncodeliste-spalten($gc-codeliste)[
                  lite:versioncodeliste-spalte-spaltennameTechnisch(.) != $code-spalte and
                  lite:versioncodeliste-zeile-spaltenwert($zeile, lite:versioncodeliste-spalte-spaltennameTechnisch(.))]">
                <xsl:element name="{lite:versioncodeliste-spalte-spaltennameTechnisch(.)}">
                  <xsl:value-of select="
                      normalize-space(
                      lite:versioncodeliste-zeile-spaltenwert($zeile, lite:versioncodeliste-spalte-spaltennameTechnisch(.)))"/>
                </xsl:element>
              </xsl:for-each>
            </xs:appinfo>
          </xs:annotation>
        </xs:enumeration>
      </xsl:for-each>
    </xs:restriction>
  </xsl:template>

  <xsl:template match="xsdSchema" mode="lite:annotation.schema">
    <xs:annotation>
      <xs:appinfo>
        <xsl:apply-templates select="." mode="lite:title"/>
        <xsl:apply-templates select="." mode="lite:implementationHint"/>
        <xsl:apply-templates select="ancestor::xoev-fachmodell" mode="lite:metadaten.standard"/>
        <xsl:apply-templates select="ancestor::lite-bib:xoev-bibliothek" mode="lite:metadaten.bibliothek"/>
        <xsl:apply-templates select="ancestor::xoev-fachmodell" mode="lite:metadaten.versionStandard"/>
        <xsl:apply-templates select="ancestor::lite-bib:xoev-bibliothek" mode="lite:metadaten.versionBibliothek"/>
      </xs:appinfo>
      <xsl:apply-templates select="." mode="lite:documentation"/>
    </xs:annotation>
  </xsl:template>

  <xsl:template match="xoev-fachmodell" mode="lite:metadaten.standard">
    <xsl:for-each select="metadaten.standard">
      <standard>
        <xsl:for-each select="nameLang">
          <nameLang>
            <xsl:value-of select="."/>
          </nameLang>
        </xsl:for-each>
        <xsl:for-each select="nameKurz">
          <nameKurz>
            <xsl:value-of select="."/>
          </nameKurz>
        </xsl:for-each>
        <xsl:for-each select="nameTechnisch">
          <nameTechnisch>
            <xsl:value-of select="."/>
          </nameTechnisch>
        </xsl:for-each>
        <xsl:for-each select="kennung">
          <kennung>
            <xsl:value-of select="."/>
          </kennung>
        </xsl:for-each>
        <xsl:for-each select="beschreibung">
          <beschreibung>
            <xsl:value-of select="lite:clean-text(.)"/>
          </beschreibung>
        </xsl:for-each>
      </standard>
    </xsl:for-each>
  </xsl:template>

  <xsl:template match="lite-bib:xoev-bibliothek" mode="lite:metadaten.bibliothek">
    <xsl:for-each select="lite-bib:metadaten.bibliothek">
      <XOEVBibliothek>
        <xsl:for-each select="lite-bib:nameLang">
          <nameLang>
            <xsl:value-of select="."/>
          </nameLang>
        </xsl:for-each>
        <xsl:for-each select="lite-bib:nameKurz">
          <nameKurz>
            <xsl:value-of select="."/>
          </nameKurz>
        </xsl:for-each>
        <xsl:for-each select="lite-bib:nameTechnisch">
          <nameTechnisch>
            <xsl:value-of select="."/>
          </nameTechnisch>
        </xsl:for-each>
        <xsl:for-each select="lite-bib:kennung">
          <kennung>
            <xsl:value-of select="."/>
          </kennung>
        </xsl:for-each>
        <xsl:for-each select="lite-bib:beschreibung">
          <beschreibung>
            <xsl:value-of select="lite:clean-text(.)"/>
          </beschreibung>
        </xsl:for-each>
        <xsl:for-each select="lite-bib:herausgebernameLang">
          <herausgebernameLang>
            <xsl:value-of select="."/>
          </herausgebernameLang>
        </xsl:for-each>
        <xsl:for-each select="lite-bib:herausgebernameKurz">
          <herausgebernameKurz>
            <xsl:value-of select="."/>
          </herausgebernameKurz>
        </xsl:for-each>
        <xsl:for-each select="lite-bib:externeWebsite">
          <externeWebsite>
            <xsl:value-of select="."/>
          </externeWebsite>
        </xsl:for-each>
      </XOEVBibliothek>
    </xsl:for-each>
  </xsl:template>

  <xsl:template match="xoev-fachmodell" mode="lite:metadaten.versionStandard">
    <xsl:for-each select="metadaten.versionStandard">
      <versionStandard>
        <xsl:for-each select="version">
          <version>
            <xsl:value-of select="."/>
          </version>
        </xsl:for-each>
        <xsl:for-each select="beschreibung">
          <beschreibung>
            <xsl:value-of select="lite:clean-text(.)"/>
          </beschreibung>
        </xsl:for-each>
        <xsl:for-each select="versionXOEVHandbuch">
          <versionXOEVHandbuch>
            <xsl:value-of select="."/>
          </versionXOEVHandbuch>
        </xsl:for-each>
        <xsl:for-each select="versionXOEVProduktionsumgebung">
          <versionXOEVProduktionsumgebung>
            <xsl:value-of select="."/>
          </versionXOEVProduktionsumgebung>
        </xsl:for-each>
        <xsl:for-each select="nameModellierungswerkzeug">
          <nameModellierungswerkzeug>
            <xsl:value-of select="."/>
          </nameModellierungswerkzeug>
        </xsl:for-each>
        <xsl:for-each select="versionModellierungswerkzeug">
          <versionModellierungswerkzeug>
            <xsl:value-of select="."/>
          </versionModellierungswerkzeug>
        </xsl:for-each>
      </versionStandard>
    </xsl:for-each>
  </xsl:template>

  <xsl:template match="lite-bib:xoev-bibliothek" mode="lite:metadaten.versionBibliothek">
    <xsl:for-each select="lite-bib:metadaten.versionBibliothek">
      <versionXOEVBibliothek>
        <xsl:for-each select="lite-bib:version">
          <version>
            <xsl:value-of select="."/>
          </version>
        </xsl:for-each>
        <xsl:for-each select="lite-bib:beschreibung">
          <beschreibung>
            <xsl:value-of select="lite:clean-text(.)"/>
          </beschreibung>
        </xsl:for-each>
        <xsl:for-each select="lite-bib:versionXOEVLite">
          <versionXOEVLite>
            <xsl:value-of select="."/>
          </versionXOEVLite>
        </xsl:for-each>
        <xsl:for-each select="lite-bib:lizenz">
          <lizenz>
            <xsl:value-of select="."/>
          </lizenz>
        </xsl:for-each>
        <xsl:for-each select="lite-bib:bezugsort">
          <bezugsort>
            <xsl:value-of select="."/>
          </bezugsort>
        </xsl:for-each>
        <xsl:for-each select="lite-bib:aenderungZurVorversion">
          <aenderungZurVorversion>
            <xsl:value-of select="."/>
          </aenderungZurVorversion>
        </xsl:for-each>
      </versionXOEVBibliothek>
    </xsl:for-each>
  </xsl:template>

  <xsl:template match="nachricht" mode="lite:element.nachricht">
    <xs:element name="{@name}">
      <xsl:apply-templates select="." mode="lite:annotation.nachricht"/>
      <xs:complexType>
        <xsl:apply-templates select="." mode="lite:typ-inhalt.complex"/>
      </xs:complexType>
    </xs:element>
  </xsl:template>

  <xsl:template match="globaleEigenschaftengruppe" mode="lite:group.globaleEigenschaftengruppe">
    <xs:group name="{lite:name-with-name-praefix-and-suffix(.)}">
      <xsl:apply-templates select="." mode="lite:title"/>
      <xsl:element name="xs:{(@art, 'sequence')[1]}">
        <xsl:apply-templates select="." mode="lite:minMaxOccurs"/>
        <xsl:apply-templates select="lite:element-structures(.)" mode="lite:gruppen-inhalt"/>
      </xsl:element>
    </xs:group>
  </xsl:template>

  <xsl:template match="globaleEigenschaft[not(@xsdAttribute = 'true')]" mode="lite:element.globaleEigenschaft">
    <xs:element name="{lite:name-with-name-praefix-and-suffix(.)}">
      <xsl:apply-templates select="." mode="lite:element.globaleEigenschaft.content"/>
    </xs:element>
  </xsl:template>

  <xsl:template match="globaleEigenschaft[@xsdAttribute = 'true']" mode="lite:element.globaleEigenschaft">
    <xs:attribute name="{lite:name-with-name-praefix-and-suffix(.)}">
      <xsl:apply-templates select="." mode="lite:element.globaleEigenschaft.content"/>
    </xs:attribute>
  </xsl:template>

  <xsl:template match="globaleEigenschaft" mode="lite:element.globaleEigenschaft.content">
    <xsl:apply-templates select="." mode="lite:default-or-fixed"/>
    <xsl:choose>
      <xsl:when test="@typ">
        <xsl:attribute name="type" select="concat(tokenize(@typ, ':')[1], ':', lite:name-with-name-praefix-and-suffix(lite:resolve(@typ, ., false())))"/>
        <xsl:apply-templates select="." mode="lite:annotation.grunddaten"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:apply-templates select="." mode="lite:annotation.grunddaten"/>
        <xsl:choose>
          <xsl:when test="@xsdAttribute = 'true' or @basistyp and lite:resolve(@basistyp, ., false())/lite:is-simple-type(.) or ./union">
            <xs:simpleType>
              <xsl:apply-templates select="." mode="lite:typ-inhalt.simple"/>
            </xs:simpleType>
          </xsl:when>
          <xsl:otherwise>
            <xs:complexType>
              <xsl:apply-templates select="." mode="lite:typ-inhalt.complex"/>
            </xs:complexType>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template match="element()" mode="lite:annotation.nachricht">
    <xsl:variable name="appinfo" as="element()">
      <xs:appinfo>
        <xsl:apply-templates select="." mode="lite:title"/>
        <xsl:apply-templates select="." mode="lite:implementationHint"/>
        <xsl:for-each select="@autor">
          <autor>
            <xsl:value-of select="."/>
          </autor>
        </xsl:for-each>
        <xsl:for-each select="@leser">
          <leser>
            <xsl:value-of select="."/>
          </leser>
        </xsl:for-each>
        <xsl:apply-templates select="." mode="lite:rechtsgrundlage"/>
      </xs:appinfo>
    </xsl:variable>
    <xsl:variable name="documentation" as="element()?">
      <xsl:apply-templates select="." mode="lite:documentation"/>
    </xsl:variable>
    <xsl:if test="$appinfo/child::* or $documentation">
      <xs:annotation>
        <xsl:sequence select="$appinfo[child::*], $documentation"/>
      </xs:annotation>
    </xsl:if>
  </xsl:template>

  <xsl:template match="element()" mode="lite:metadaten.codeliste">
    <xsl:param name="gc-codeliste" as="element()?"/>
    <xsl:variable name="codeDatentyp" select="."/>
    <xsl:for-each select="$gc-codeliste">
      <codeliste>
        <xsl:for-each select="lite:codeliste-nameLang(.)">
          <nameLang>
            <xsl:value-of select="."/>
          </nameLang>
        </xsl:for-each>
        <xsl:for-each select="lite:codeliste-nameKurz(.)">
          <nameKurz>
            <xsl:value-of select="."/>
          </nameKurz>
        </xsl:for-each>
        <xsl:for-each select="lite:codeliste-nameTechnisch(.)">
          <nameTechnisch>
            <xsl:value-of select="."/>
          </nameTechnisch>
        </xsl:for-each>
        <xsl:for-each select="lite:codeliste-kennung(.)">
          <kennung>
            <xsl:value-of select="."/>
          </kennung>
        </xsl:for-each>
        <xsl:for-each select="lite:codeliste-beschreibung(.)">
          <beschreibung>
            <xsl:value-of select="."/>
          </beschreibung>
        </xsl:for-each>
        <xsl:for-each select="lite:codeliste-herausgebernameLang(.)">
          <herausgebernameLang>
            <xsl:value-of select="."/>
          </herausgebernameLang>
        </xsl:for-each>
        <xsl:for-each select="lite:codeliste-herausgebernameKurz(.)">
          <herausgebernameKurz>
            <xsl:value-of select="."/>
          </herausgebernameKurz>
        </xsl:for-each>
      </codeliste>
    </xsl:for-each>
    <xsl:for-each select="$gc-codeliste[$codeDatentyp/@version]">
      <versionCodeliste>
        <xsl:for-each select="lite:versioncodeliste-version(.)">
          <version>
            <xsl:value-of select="."/>
          </version>
        </xsl:for-each>
        <xsl:for-each select="lite:versioncodeliste-beschreibung(.)">
          <beschreibung>
            <xsl:value-of select="."/>
          </beschreibung>
        </xsl:for-each>
        <xsl:for-each select="lite:versioncodeliste-bezugsort(.)">
          <bezugsort>
            <xsl:value-of select="."/>
          </bezugsort>
        </xsl:for-each>
        <xsl:for-each select="lite:versioncodeliste-datumGueltigkeitAb(.)">
          <datumGueltigkeitAb>
            <xsl:value-of select="."/>
          </datumGueltigkeitAb>
        </xsl:for-each>
        <xsl:for-each select="lite:versioncodeliste-versionCodelistenHandbuch(.)">
          <versionCodelistenHandbuch>
            <xsl:value-of select="."/>
          </versionCodelistenHandbuch>
        </xsl:for-each>
        <xsl:for-each select="lite:versioncodeliste-versionXOEVHandbuch(.)">
          <versionXOEVHandbuch>
            <xsl:value-of select="."/>
          </versionXOEVHandbuch>
        </xsl:for-each>
        <xsl:for-each select="lite:versioncodeliste-aenderungZurVorversion(.)">
          <aenderungZurVorversion>
            <xsl:value-of select="."/>
          </aenderungZurVorversion>
        </xsl:for-each>
      </versionCodeliste>
      <codelistenspalten>
        <xsl:for-each select="lite:versioncodeliste-spalten(.)">
          <xsl:element name="{lite:versioncodeliste-spalte-spaltennameTechnisch(.)}">
            <xsl:for-each select="lite:versioncodeliste-spalte-spaltennameLang(.)">
              <spaltennameLang>
                <xsl:value-of select="."/>
              </spaltennameLang>
            </xsl:for-each>
            <xsl:for-each select="lite:versioncodeliste-spalte-datentyp(.)">
              <datentyp>
                <xsl:value-of select="."/>
              </datentyp>
            </xsl:for-each>
            <xsl:for-each select="lite:versioncodeliste-spalte-sprache(.)">
              <sprache>
                <xsl:value-of select="."/>
              </sprache>
            </xsl:for-each>
            <codeSpalte>
              <xsl:value-of select="lite:versioncodeliste-spalte-codeSpalte(.)"/>
            </codeSpalte>
            <verwendung>
              <xsl:value-of select="lite:versioncodeliste-spalte-verwendung(.)"/>
            </verwendung>
            <empfohleneCodeSpalte>
              <xsl:value-of select="lite:versioncodeliste-spalte-empfohleneCodeSpalte(.)"/>
            </empfohleneCodeSpalte>
          </xsl:element>
        </xsl:for-each>
      </codelistenspalten>
    </xsl:for-each>
  </xsl:template>

  <xsl:template match="element()" mode="lite:annotation.codeliste">
    <xsl:param name="gc-codeliste" as="element()?"/>
    <xsl:variable name="appinfo" as="element()">
      <xs:appinfo>
        <xsl:apply-templates select="." mode="lite:metadaten.codeliste">
          <xsl:with-param name="gc-codeliste" select="$gc-codeliste"/>
        </xsl:apply-templates>
      </xs:appinfo>
    </xsl:variable>
    <xsl:if test="$appinfo/child::*">
      <xs:annotation>
        <xsl:sequence select="$appinfo[child::*]"/>
      </xs:annotation>
    </xsl:if>
  </xsl:template>

  <xsl:template match="element()" mode="lite:annotation.codeDatentyp">
    <xsl:param name="gc-codeliste" as="element()?"/>
    <xsl:variable name="codeDatentyp" select="."/>
    <xsl:variable name="appinfo" as="element()">
      <xs:appinfo>
        <xsl:apply-templates select="." mode="lite:title"/>
        <xsl:apply-templates select="." mode="lite:implementationHint"/>
        <xsl:apply-templates select=".[@kennung]" mode="lite:metadaten.codeliste">
          <xsl:with-param name="gc-codeliste" select="$gc-codeliste"/>
        </xsl:apply-templates>
        <xsl:for-each select="
            (genutzteCodeSpalte,
            $gc-codeliste[$codeDatentyp/@version]/*:ColumnSet/*:Key[*:Annotation/*:AppInfo/(*:xoev-code, *:empfohleneCodeSpalte, xoev-cl-4:recommendedKeyColumn)]/*:ColumnRef/@Ref,
            $gc-codeliste[$codeDatentyp/@version]/*:ColumnSet/*:Key[1]/*:ColumnRef/@Ref)[1]">
          <genutzteCodeSpalte>
            <xsl:value-of select="."/>
          </genutzteCodeSpalte>
        </xsl:for-each>
        <xsl:for-each select="genutzteBeschreibungsspalte">
          <genutzteBeschreibungsspalte>
            <xsl:value-of select="."/>
          </genutzteBeschreibungsspalte>
        </xsl:for-each>
      </xs:appinfo>
    </xsl:variable>
    <xsl:variable name="documentation" as="element()?">
      <xsl:apply-templates select="." mode="lite:documentation"/>
    </xsl:variable>
    <xsl:if test="$appinfo/child::* or $documentation">
      <xs:annotation>
        <xsl:sequence select="$appinfo[child::*], $documentation"/>
      </xs:annotation>
    </xsl:if>
  </xsl:template>

  <xsl:template match="codeDatentyp" mode="lite:complexType.codeDatentyp">
    <xsl:variable name="codeDatentyp" select="."/>
    <xsl:variable name="gc-codeliste" select="lite:genutzte-cl-oder-vcl(.)"/>
    <xs:complexType name="{lite:name-with-name-praefix-and-suffix(.)}">
      <xsl:apply-templates select="." mode="lite:annotation.codeDatentyp">
        <xsl:with-param name="gc-codeliste" select="$gc-codeliste"/>
      </xsl:apply-templates>
      <xs:complexContent>
        <xs:restriction base="{(ancestor::*/nutztSchema[@namespace = 'http://xoev.de/schemata/code/1_0'][1]/@prefix, 'xoev-code')[1]}:Code">
          <xs:sequence>
            <xs:element name="code">
              <xsl:choose>
                <xsl:when test="lite:codeliste-schemavalidiert(.)">
                  <xsl:choose>
                    <xsl:when test="lite:benannter-codelistendatentyp(.)">
                      <xsl:variable name="cl-schema" select="
                          ($xoev-modell/descendant::*:xsdSchema[@schemaFile = $codeDatentyp/benannterCodelistenDatentypXSD],
                          ancestor::*:xsdSchema)[1]"/>
                      <xsl:attribute name="type" select="
                          concat(lite:prefix($cl-schema, $codeDatentyp), ':', (benannterCodelistenDatentypName, $gc-codeliste/*:Identification/*:ShortName)[1])"/>
                      <xsl:if test="lite:element-form-default(.) != 'unqualified'">
                        <xsl:attribute name="form">unqualified</xsl:attribute>
                      </xsl:if>
                    </xsl:when>
                    <xsl:otherwise>
                      <xsl:if test="lite:element-form-default(.) != 'unqualified'">
                        <xsl:attribute name="form">unqualified</xsl:attribute>
                      </xsl:if>
                      <xs:simpleType>
                        <xsl:apply-templates select="." mode="lite:restriction.codeliste">
                          <xsl:with-param name="gc-codeliste" select="$gc-codeliste"/>
                        </xsl:apply-templates>
                      </xs:simpleType>
                    </xsl:otherwise>
                  </xsl:choose>
                </xsl:when>
                <xsl:otherwise>
                  <xsl:attribute name="type" select="
                      (typDesCodeElements, (ancestor::xoev-fachmodell, ancestor::lite-bib:xoev-bibliothek)/konfiguration.xoev-fachmodell/typDesCodeElements, 'xs:token')[1]"/>
                  <xsl:if test="lite:element-form-default(.) != 'unqualified'">
                    <xsl:attribute name="form">unqualified</xsl:attribute>
                  </xsl:if>
                </xsl:otherwise>
              </xsl:choose>
            </xs:element>
            <xsl:if test="nutzungNameElement = ('mandatorisch', 'optional')">
              <xs:element name="name" type="xs:normalizedString">
                <xsl:if test="lite:element-form-default(.) != 'unqualified'">
                  <xsl:attribute name="form">unqualified</xsl:attribute>
                </xsl:if>
                <xsl:if test="nutzungNameElement = 'optional'">
                  <xsl:attribute name="minOccurs">0</xsl:attribute>
                </xsl:if>
              </xs:element>
            </xsl:if>
          </xs:sequence>
          <xs:attribute name="listURI" type="xs:anyURI">
            <xsl:attribute name="use" select="
                if (@kennung) then
                  'optional'
                else
                  'required'"/>
            <xsl:for-each select="@kennung">
              <xsl:attribute name="fixed" select="."/>
            </xsl:for-each>
          </xs:attribute>
          <xs:attribute name="listVersionID" type="xs:normalizedString">
            <xsl:attribute name="use" select="
                if (@version) then
                  'optional'
                else
                  'required'"/>
            <xsl:for-each select="@version">
              <xsl:attribute name="fixed" select="."/>
            </xsl:for-each>
          </xs:attribute>
        </xs:restriction>
      </xs:complexContent>
    </xs:complexType>
  </xsl:template>

  <xsl:template match="datentyp" mode="lite:datentyp">
    <xsl:choose>
      <xsl:when test="lite:is-simple-type(.)">
        <xsl:apply-templates select="." mode="lite:simpleType.datentyp"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:apply-templates select="." mode="lite:complexType.datentyp"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template match="datentyp" mode="lite:complexType.datentyp">
    <xs:complexType name="{lite:name-with-name-praefix-and-suffix(.)}">
      <xsl:if test="@abstrakt = 'true'">
        <xsl:attribute name="abstract">true</xsl:attribute>
      </xsl:if>
      <xsl:apply-templates select="." mode="lite:annotation.datentyp"/>
      <xsl:apply-templates select="." mode="lite:typ-inhalt.complex"/>
    </xs:complexType>
  </xsl:template>

  <xsl:template match="element()" mode="lite:annotation.datentyp">
    <xsl:variable name="appinfo" as="element()">
      <xs:appinfo>
        <xsl:apply-templates select="." mode="lite:title"/>
        <xsl:apply-templates select="." mode="lite:implementationHint"/>
        <xsl:apply-templates select="." mode="lite:beispielwert"/>
        <xsl:apply-templates select="." mode="lite:xoevDatentyp"/>
        <xsl:apply-templates select="." mode="lite:versionXOEVDatentyp"/>
      </xs:appinfo>
    </xsl:variable>
    <xsl:variable name="documentation" as="element()?">
      <xsl:apply-templates select="." mode="lite:documentation"/>
    </xsl:variable>
    <xsl:if test="$appinfo/child::* or $documentation">
      <xs:annotation>
        <xsl:sequence select="$appinfo[child::*], $documentation"/>
      </xs:annotation>
    </xsl:if>
  </xsl:template>

  <xsl:template match="datentyp" mode="lite:xoevDatentyp">
    <xsl:for-each select="lite-bib:metadaten.xoevDatentyp">
      <datentyp>
        <xsl:for-each select="lite-bib:nameLang">
          <nameLang>
            <xsl:value-of select="."/>
          </nameLang>
        </xsl:for-each>
        <xsl:for-each select="lite-bib:nameKurz">
          <nameKurz>
            <xsl:value-of select="."/>
          </nameKurz>
        </xsl:for-each>
        <xsl:for-each select="lite-bib:nameTechnisch">
          <nameTechnisch>
            <xsl:value-of select="."/>
          </nameTechnisch>
        </xsl:for-each>
        <xsl:for-each select="lite-bib:kennung">
          <kennung>
            <xsl:value-of select="."/>
          </kennung>
        </xsl:for-each>
        <xsl:for-each select="lite-bib:herausgebernameLang">
          <herausgebernameLang>
            <xsl:value-of select="."/>
          </herausgebernameLang>
        </xsl:for-each>
        <xsl:for-each select="lite-bib:herausgebernameKurz">
          <herausgebernameKurz>
            <xsl:value-of select="."/>
          </herausgebernameKurz>
        </xsl:for-each>
        <xsl:for-each select="lite-bib:externeWebsite">
          <externeWebsite>
            <xsl:value-of select="."/>
          </externeWebsite>
        </xsl:for-each>
      </datentyp>
    </xsl:for-each>
  </xsl:template>

  <xsl:template match="datentyp" mode="lite:versionXOEVDatentyp">
    <xsl:for-each select="lite-bib:metadaten.versionXOEVDatentyp">
      <versionDatentyp>
        <xsl:for-each select="lite-bib:version">
          <version>
            <xsl:value-of select="."/>
          </version>
        </xsl:for-each>
        <xsl:for-each select="beschreibung">
          <beschreibung>
            <xsl:value-of select="lite:clean-text(.)"/>
          </beschreibung>
        </xsl:for-each>
        <xsl:for-each select="lite-bib:versionXOEVLite">
          <versionXOEVLite>
            <xsl:value-of select="."/>
          </versionXOEVLite>
        </xsl:for-each>
        <xsl:for-each select="lite-bib:lizenz">
          <lizenz>
            <xsl:value-of select="."/>
          </lizenz>
        </xsl:for-each>
        <xsl:for-each select="lite-bib:bezugsort">
          <bezugsort>
            <xsl:value-of select="."/>
          </bezugsort>
        </xsl:for-each>
        <xsl:for-each select="lite-bib:aenderungZurVorversion">
          <aenderungZurVorversion>
            <xsl:value-of select="."/>
          </aenderungZurVorversion>
        </xsl:for-each>
      </versionDatentyp>
    </xsl:for-each>
  </xsl:template>

  <xsl:template match="datentyp" mode="lite:simpleType.datentyp">
    <xs:simpleType name="{lite:name-with-name-praefix-and-suffix(.)}">
      <xsl:apply-templates select="." mode="lite:annotation.datentyp"/>
      <xsl:apply-templates select="." mode="lite:typ-inhalt.simple"/>
    </xs:simpleType>
  </xsl:template>

  <xsl:template match="element()" mode="lite:typ-inhalt.simple">
    <xsl:if test="@basistyp and @restriction = 'true'">
      <xs:restriction base="{concat(tokenize(@basistyp, ':')[1], ':', lite:name-with-name-praefix-and-suffix(lite:resolve(@basistyp, ., false())))}">
        <xsl:for-each select="@fractionDigits">
          <xs:fractionDigits value="{.}"/>
        </xsl:for-each>
        <xsl:for-each select="@length">
          <xs:length value="{.}"/>
        </xsl:for-each>
        <xsl:for-each select="@maxExclusive">
          <xs:maxExclusive value="{.}"/>
        </xsl:for-each>
        <xsl:for-each select="@maxInclusive">
          <xs:maxInclusive value="{.}"/>
        </xsl:for-each>
        <xsl:for-each select="@maxLength">
          <xs:maxLength value="{.}"/>
        </xsl:for-each>
        <xsl:for-each select="@minExclusive">
          <xs:minExclusive value="{.}"/>
        </xsl:for-each>
        <xsl:for-each select="@minInclusive">
          <xs:minInclusive value="{.}"/>
        </xsl:for-each>
        <xsl:for-each select="@minLength">
          <xs:minLength value="{.}"/>
        </xsl:for-each>
        <xsl:for-each select="@pattern">
          <xs:pattern value="{lite:unescaped-xml(.)}"/>
        </xsl:for-each>
        <xsl:for-each select="@totalDigits">
          <xs:totalDigits value="{.}"/>
        </xsl:for-each>
        <xsl:for-each select="@whitespace">
          <xs:whiteSpace value="{.}"/>
        </xsl:for-each>
      </xs:restriction>
    </xsl:if>
    <xsl:if test="union">
      <xs:union memberTypes="{string-join(./union/memberType, ' ')}"/>
    </xsl:if>
  </xsl:template>

  <xsl:template match="element()" mode="lite:typ-inhalt.complex">
    <!-- empty(X/ancestor::xsdSchema) genau dann wenn es sich bei X um einen W3C-Datentyp handelt -->
    <xsl:variable name="content" select="
        if (@basistyp and empty(lite:topmost-parent(.)/ancestor::xsdSchema)) then
          'simpleContent'
        else
          'complexContent'"/>
    <xsl:choose>
      <xsl:when test="@basistyp">
        <xsl:element name="xs:{$content}">
          <xsl:choose>
            <xsl:when test="@restriction = 'true'">
              <xs:restriction base="{concat(tokenize(@basistyp, ':')[1], ':', lite:name-with-name-praefix-and-suffix(lite:resolve(@basistyp, ., false())))}">
                <xsl:apply-templates select="." mode="lite:group.implizit"/>
                <xsl:apply-templates select="lite:attribute-structures(.)" mode="lite:attribute.eigenschaft"/>
              </xs:restriction>
            </xsl:when>
            <xsl:otherwise>
              <xs:extension base="{concat(tokenize(@basistyp, ':')[1], ':', lite:name-with-name-praefix-and-suffix(lite:resolve(@basistyp, ., false())))}">
                <xsl:apply-templates select="." mode="lite:group.implizit"/>
                <xsl:apply-templates select="lite:attribute-structures(.)" mode="lite:attribute.eigenschaft"/>
              </xs:extension>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:element>
      </xsl:when>
      <xsl:otherwise>
        <xsl:apply-templates select="." mode="lite:group.implizit"/>
        <xsl:apply-templates select="lite:attribute-structures(.)" mode="lite:attribute.eigenschaft"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template match="element()" mode="lite:attribute.eigenschaft">
    <!-- ToDo: Attributgruppen -->
    <xsl:element name="xs:attribute">
      <xsl:choose>
        <xsl:when test="@referenz">
          <xsl:attribute name="ref" select="concat(tokenize(@referenz, ':')[1], ':', lite:name-with-name-praefix-and-suffix(lite:resolve(@referenz, ., true())))"/>
          <xsl:apply-templates select="." mode="lite:use"/>
          <xsl:apply-templates select="." mode="lite:default-or-fixed"/>
          <xsl:apply-templates select="." mode="lite:annotation.grunddaten"/>
        </xsl:when>
        <xsl:when test="@typ">
          <xsl:attribute name="name" select="@name"/>
          <xsl:apply-templates select="." mode="lite:use"/>
          <xsl:apply-templates select="." mode="lite:default-or-fixed"/>
          <xsl:attribute name="type" select="
              if (lite:is-simple-type(lite:resolve(@typ, ., false()))) then
                concat(tokenize(@typ, ':')[1], ':', lite:name-with-name-praefix-and-suffix(lite:resolve(@typ, ., false())))
              else
                'xs:IDREF'"/>
          <xsl:apply-templates select="." mode="lite:annotation.grunddaten"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:attribute name="name" select="@name"/>
          <xsl:apply-templates select="." mode="lite:use"/>
          <xsl:apply-templates select="." mode="lite:default-or-fixed"/>
          <xsl:apply-templates select="." mode="lite:annotation.grunddaten"/>
          <xs:simpleType>
            <xsl:apply-templates select="." mode="lite:typ-inhalt.simple"/>
          </xs:simpleType>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:element>
  </xsl:template>

  <xsl:template match="element()" mode="lite:use">
    <xsl:if test="(@multiplizitaet, '1')[1] = ('1', '1..1')">
      <xsl:attribute name="use">
        <xsl:text>required</xsl:text>
      </xsl:attribute>
    </xsl:if>
  </xsl:template>

  <xsl:template match="element()" mode="lite:minMaxOccurs">
    <xsl:param name="is-implicit-group" as="xs:boolean" required="no" select="false()"/>
    <xsl:variable name="value" select="
        if ($is-implicit-group) then
          @gruppe.multiplizitaet
        else
          @multiplizitaet"/>
    <xsl:for-each select="tokenize($value, '\.\.')[1][. != '1']">
      <xsl:attribute name="minOccurs">
        <xsl:value-of select="."/>
      </xsl:attribute>
    </xsl:for-each>
    <xsl:for-each select="(tokenize($value, '\.\.')[2], $value)[1][. != '1']">
      <xsl:attribute name="maxOccurs">
        <xsl:value-of select="
            if (. = '*') then
              'unbounded'
            else
              ."/>
      </xsl:attribute>
    </xsl:for-each>
  </xsl:template>

  <xsl:template match="element()" mode="lite:default-or-fixed">
    <xsl:for-each select="@defaultWert">
      <xsl:attribute name="default">
        <xsl:value-of select="."/>
      </xsl:attribute>
    </xsl:for-each>
    <xsl:for-each select="@fixedWert">
      <xsl:attribute name="fixed">
        <xsl:value-of select="."/>
      </xsl:attribute>
    </xsl:for-each>
  </xsl:template>

  <xsl:template match="eigenschaft" mode="lite:gruppen-inhalt">
    <xsl:element name="xs:element">
      <xsl:for-each select="@nillable[. = 'true']">
        <xsl:attribute name="nillable" select="."/>
      </xsl:for-each>
      <xsl:choose>
        <xsl:when test="@referenz">
          <xsl:attribute name="ref" select="concat(tokenize(@referenz, ':')[1], ':', lite:name-with-name-praefix-and-suffix(lite:resolve(@referenz, ., true())))"/>
          <xsl:apply-templates select="." mode="lite:minMaxOccurs"/>
          <xsl:apply-templates select="." mode="lite:default-or-fixed"/>
          <xsl:apply-templates select="." mode="lite:annotation.grunddaten"/>
        </xsl:when>
        <xsl:when test="@typ">
          <xsl:attribute name="name" select="@name"/>
          <xsl:apply-templates select="." mode="lite:minMaxOccurs"/>
          <xsl:apply-templates select="." mode="lite:default-or-fixed"/>
          <xsl:attribute name="type" select="concat(tokenize(@typ, ':')[1], ':', lite:name-with-name-praefix-and-suffix(lite:resolve(@typ, ., false())))"/>
          <xsl:for-each select="lite:element-form(.)[. != 'default']">
            <xsl:attribute name="form" select="."/>
          </xsl:for-each>
          <xsl:apply-templates select="." mode="lite:annotation.grunddaten"/>
        </xsl:when>
        <xsl:when test="@basistyp and @restriction = 'true' and lite:is-simple-type(lite:resolve(@basistyp, ., false()))">
          <xsl:attribute name="name" select="@name"/>
          <xsl:apply-templates select="." mode="lite:minMaxOccurs"/>
          <xsl:apply-templates select="." mode="lite:default-or-fixed"/>
          <xsl:for-each select="lite:element-form(.)[. != 'default']">
            <xsl:attribute name="form" select="."/>
          </xsl:for-each>
          <xsl:apply-templates select="." mode="lite:annotation.grunddaten"/>
          <xs:simpleType>
            <xsl:apply-templates select="." mode="lite:typ-inhalt.simple"/>
          </xs:simpleType>
        </xsl:when>
        <xsl:otherwise>
          <xsl:attribute name="name" select="@name"/>
          <xsl:apply-templates select="." mode="lite:minMaxOccurs"/>
          <xsl:apply-templates select="." mode="lite:default-or-fixed"/>
          <xsl:for-each select="lite:element-form(.)[. != 'default']">
            <xsl:attribute name="form" select="."/>
          </xsl:for-each>
          <xsl:apply-templates select="." mode="lite:annotation.grunddaten"/>
          <xsl:choose>
            <xsl:when test="union">
              <xs:simpleType>
                <xsl:apply-templates select="." mode="lite:typ-inhalt.simple"/>
              </xs:simpleType>
            </xsl:when>
            <xsl:otherwise>
              <xs:complexType>
                <xsl:apply-templates select="." mode="lite:typ-inhalt.complex"/>
              </xs:complexType>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:element>
  </xsl:template>

  <xsl:template match="eigenschaftengruppe" mode="lite:gruppen-inhalt">
    <xsl:choose>
      <xsl:when test="@referenz">
        <xsl:element name="xs:group">
          <xsl:attribute name="ref" select="concat(tokenize(@referenz, ':')[1], ':', lite:name-with-name-praefix-and-suffix(lite:resolve(@referenz, ., true())))"/>
          <xsl:apply-templates select="." mode="lite:minMaxOccurs"/>
          <xsl:apply-templates select="." mode="lite:annotation.grunddaten"/>
        </xsl:element>
      </xsl:when>
      <xsl:otherwise>
        <xsl:element name="xs:{(@art, 'sequence')[1]}">
          <xsl:apply-templates select="." mode="lite:minMaxOccurs"/>
          <xsl:apply-templates select="lite:element-structures(.)" mode="lite:gruppen-inhalt"/>
        </xsl:element>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template match="anyStruktur" mode="lite:gruppen-inhalt">
    <xsl:element name="xs:any">
      <xsl:apply-templates select="." mode="lite:minMaxOccurs"/>
      <xsl:attribute name="namespace" select="(@namespace, '##any')[1]"/>
      <xsl:attribute name="processContents" select="(@processContents, 'strict')[1]"/>
      <xsl:apply-templates select="." mode="lite:annotation.grunddaten"/>
    </xsl:element>
  </xsl:template>

  <xsl:template match="element()" mode="lite:group.implizit">
    <xsl:if test="lite:element-structures(.)">
      <xsl:element name="xs:{(@gruppe.art, 'sequence')[1]}">
        <xsl:apply-templates select="." mode="lite:minMaxOccurs">
          <xsl:with-param name="is-implicit-group" select="true()"/>
        </xsl:apply-templates>
        <xsl:apply-templates select="lite:element-structures(.)" mode="lite:gruppen-inhalt"/>
      </xsl:element>
    </xsl:if>
  </xsl:template>

  <xsl:template match="element()" mode="lite:annotation.grunddaten">
    <xsl:variable name="appinfo" as="element()">
      <xsl:apply-templates select="." mode="lite:appinfo.grunddaten"/>
    </xsl:variable>
    <xsl:variable name="documentation" as="element()?">
      <xsl:apply-templates select="." mode="lite:documentation"/>
    </xsl:variable>
    <xsl:if test="$appinfo/child::* or $documentation">
      <xs:annotation>
        <xsl:sequence select="$appinfo[child::*], $documentation"/>
      </xs:annotation>
    </xsl:if>
  </xsl:template>

  <xsl:template match="element()" mode="lite:appinfo.grunddaten">
    <xs:appinfo>
      <xsl:apply-templates select="." mode="lite:title"/>
      <xsl:apply-templates select="." mode="lite:implementationHint"/>
      <xsl:apply-templates select="." mode="lite:beispielwert"/>
    </xs:appinfo>
  </xsl:template>

  <xsl:template match="element()" mode="lite:documentation">
    <xsl:for-each select="beschreibung">
      <xs:documentation>
        <xsl:value-of select="lite:clean-text(.)"/>
      </xs:documentation>
    </xsl:for-each>
  </xsl:template>

  <xsl:template match="element()" mode="lite:title">
    <xsl:for-each select="@titel">
      <title>
        <xsl:value-of select="lite:clean-text(.)"/>
      </title>
    </xsl:for-each>
  </xsl:template>

  <xsl:template match="element()" mode="lite:implementationHint">
    <xsl:for-each select="umsetzungshinweis">
      <implementationHint>
        <xsl:value-of select="lite:clean-text(.)"/>
      </implementationHint>
    </xsl:for-each>
  </xsl:template>

  <xsl:template match="element()" mode="lite:beispielwert">
    <xsl:for-each select="beispielwert">
      <beispielwert>
        <xsl:value-of select="."/>
      </beispielwert>
    </xsl:for-each>
  </xsl:template>

  <xsl:template match="element()" mode="lite:rechtsgrundlage">
    <xsl:for-each select="rechtsgrundlage">
      <rechtsgrundlage>
        <xsl:value-of select="lite:clean-text(.)"/>
      </rechtsgrundlage>
    </xsl:for-each>
  </xsl:template>

</xsl:stylesheet>
