<?xml version="1.0" encoding="UTF-8"?>

<!-- Version 1.2.0 -->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:gc="http://docs.oasis-open.org/codelist/ns/genericode/1.0/" xmlns:xoev-cl-2="http://xoev.de/schemata/genericode/2" xmlns:xoev-cl-4="http://xoev.de/schemata/genericode/4" xmlns:lite="urn:xoev-de:kosit:xoev:lite:transformation_1.2.0" xmlns:lite-bib="urn:xoev-de:kosit:xoev:lite:schema:bibliothek_1.2.0" xmlns:lite-fm="urn:xoev-de:kosit:xoev:lite:schema:fachmodell_1.2.0" xmlns:xgen="http://www.xoev.de/de/xgenerator/framework/1/library" xmlns:sch="http://purl.oclc.org/dsdl/schematron" xpath-default-namespace="urn:xoev-de:kosit:xoev:lite:schema:fachmodell_1.2.0" version="2.0" exclude-result-prefixes="xgen xsl gc xoev-cl-2 xoev-cl-4 lite-bib lite-fm lite xgen">

  <xsl:template match="/" mode="lite:default-lite2sch">
    <xsl:call-template name="xgen:result-document">
      <xsl:with-param name="local-path">
        <xsl:value-of select="concat($xoev-modell/metadaten.standard/nameTechnisch, '-schematron.sch')"/>
      </xsl:with-param>
      <xsl:with-param name="content">
        <sch:schema queryBinding="xslt2">
          <xsl:call-template name="lite:xsd-namespaces"/>
          <sch:pattern>
            <xsl:value-of select="xgen:unescaped-xml('&#xa;      ')"/>

            <xsl:comment>Abstrakte Regeln</xsl:comment>
            <xsl:value-of select="xgen:unescaped-xml('&#xa;      ')"/>
            <xsl:apply-templates select="$modelle/descendant-or-self::*[geschaeftsregel]" mode="lite:abstract-rule-block">
              <xsl:sort select="@kennung"/>
            </xsl:apply-templates>

            <xsl:comment>Konkrete Regeln</xsl:comment>
            <xsl:call-template name="lite:concrete-rules"/>

          </sch:pattern>
        </sch:schema>
        <!-- Ausgaben für QS-Zwecke: -->
        <!--<xsl:sequence select="$lite:message-trees"/>-->
        <!--<xsl:sequence select="$lite:rules-and-contexts"/>-->
        <!--<xsl:sequence select="$lite:type-trees"/>-->
      </xsl:with-param>
    </xsl:call-template>
  </xsl:template>

  <xsl:template name="lite:xsd-namespaces" as="element()*">
    <xsl:variable name="namespaces">
      <lite:namespaces>
        <xsl:for-each select="$modelle//xsdSchema">
          <lite:namespace prefix="{lite:prefix(.)}" uri="{lite:namespace(.)}"/>
          <xsl:for-each select="lite:schema-with-imports-and-includes(.)/import[@kind = 'direct']">
            <lite:namespace prefix="{@prefix}" uri="{@namespace}"/>
          </xsl:for-each>
        </xsl:for-each>
      </lite:namespaces>
    </xsl:variable>
    <xsl:for-each select="$namespaces//lite:namespace[not(@prefix = preceding-sibling::lite:namespace/@prefix)]">
      <xsl:sort select="@prefix"/>
      <sch:ns prefix="{@prefix}" uri="{@uri}"/>
    </xsl:for-each>
  </xsl:template>

  <xsl:template match="element()" mode="lite:abstract-rule-block">
    <xsl:if test="geschaeftsregel[lite:rule-has-path(.)]">
      <xsl:comment select="
          concat(' ', string-join(ancestor-or-self::*/@name, '/'),
          if (geschaeftsregel/fachkontext) then
            ' (schRuleSet) '
          else
            ' ')"/>
    </xsl:if>
    <xsl:apply-templates select="geschaeftsregel[lite:rule-has-path(.)]" mode="lite:abstract-rule">
      <xsl:sort select="@name"/>
    </xsl:apply-templates>
  </xsl:template>

  <xsl:template match="geschaeftsregel" mode="lite:abstract-rule">
    <sch:rule id="{concat('rule-',@kennung)}" abstract="true">
      <sch:assert id="{@kennung}" test="{spezifikation}">
        <xsl:for-each select="beschreibung">
          <xsl:sort select="."/>
          <xsl:value-of select="."/>
        </xsl:for-each>
      </sch:assert>
    </sch:rule>
  </xsl:template>

  <xsl:template name="lite:concrete-rules" as="element()*">
    <xsl:for-each select="distinct-values($lite:rules-and-contexts//lite:full-paths/lite:path/text())">
      <xsl:variable name="path" select="."/>
      <sch:rule context="{.}">
        <xsl:for-each select="$lite:rules-and-contexts//lite:rule[lite:context/lite:full-paths/lite:path = $path]">
          <xsl:sort select="@kennung"/>
          <sch:extends rule="{concat('rule-',@kennung)}"/>
        </xsl:for-each>
      </sch:rule>
    </xsl:for-each>
  </xsl:template>

</xsl:stylesheet>
