<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:xd="http://www.oxygenxml.com/ns/doc/xsl" xmlns:xs="http://www.w3.org/2001/XMLSchema"
	xmlns:db="http://docbook.org/ns/docbook"
	xmlns:gc="http://docs.oasis-open.org/codelist/ns/genericode/1.0/"
	xmlns:xoev-cl-2="http://xoev.de/schemata/genericode/2"
	xmlns:xoev-cl-4="http://xoev.de/schemata/genericode/4"
	xmlns:lite="urn:xoev-de:kosit:xoev:lite:transformation_1.2.0"
	xmlns:lite-bib="urn:xoev-de:kosit:xoev:lite:schema:bibliothek_1.2.0"
	xmlns:lite-fm="urn:xoev-de:kosit:xoev:lite:schema:fachmodell_1.2.0"
	xmlns:xgen="http://www.xoev.de/de/xgenerator/framework/1/library"
	xmlns:util="http://lite2db4/util" xmlns="http://docbook.org/ns/docbook"
	xpath-default-namespace="urn:xoev-de:kosit:xoev:lite:schema:fachmodell_1.2.0" version="2.0"
	exclude-result-prefixes="xgen xsl xd xs db gc xoev-cl-2 xoev-cl-4 lite lite-fm lite-bib util">

	<xsl:output method="xml" indent="yes" use-character-maps="lite:_unescaped-xml-character-map"/>
	
	<xd:doc>
		<xd:desc>Generierung einer tabellarischen Übersicht über alle Nachrichten des
			Standards und Generierung einer tabellarischen Übersicht über alle Nachrichten
			eines Pakets</xd:desc>
	</xd:doc>
	<xd:doc>
		<xd:desc>
			<xd:p>Einstiegspunkt für die Generierung</xd:p>
		</xd:desc>
	</xd:doc>
	<xsl:template match="/" mode="lite:nachrichten-tabelle-entry">
		<xsl:apply-templates select="xoev-fachmodell" mode="lite:nachrichten-tabelle"/>
		<xsl:apply-templates select="//xsdSchema[.//nachricht]"
			mode="lite:nachrichten-tabelle-paket"/>
		<xsl:apply-templates select="//xsdSchema//paket[./nachricht]"
			mode="lite:nachrichten-tabelle-paket"/>
	</xsl:template>

	<xd:doc>
		<xd:desc>
			<xd:p>Erzeuge Datei: xsdSchema</xd:p>
		</xd:desc>
	</xd:doc>
	<xsl:template match="xsdSchema[.//nachricht] | xsdSchema//paket[./nachricht]"
		mode="lite:nachrichten-tabelle-paket">
		<xsl:variable name="document-directory"
			select="concat('dokumente/', lite:set-path-or-filename(ancestor::xoev-fachmodell/metadaten.standard/nameTechnisch))"
			as="xs:string"/>
		<xsl:variable name="target-document-directory"
			select="concat((string-join(($document-directory, string-join(ancestor::*/@name, '/')), '/')), '/tabelle.nachrichten.')"
			as="xs:string"/>

		<!-- Diese Variable enthält den Content einer zu erzeugenden Datei. -->
		<xsl:variable name="content">
			<xsl:apply-templates select=".[.//nachricht]"
				mode="lite:nachrichten-tabelle-paket-content"/>
		</xsl:variable>
		<xsl:variable name="contentwithoutprefix">
			<xsl:apply-templates select="$content" mode="lite:namespace-ohne-praefix"/>
		</xsl:variable>
		
		<!-- Hier wird das Template zur Dateierzeugung aufgerufen -->
		<xsl:call-template name="lite:write-file-return-log">
			<xsl:with-param name="content" select="$contentwithoutprefix"/>
			<xsl:with-param name="local-path" select="xs:anyURI(concat($target-document-directory, lite:set-path-or-filename(@name) , '.xml'))"/>
		</xsl:call-template>		
	</xsl:template>

	<xd:doc>
		<xd:desc>
			<xd:p>Erzeuge Datei: Fachmodell</xd:p>
		</xd:desc>
	</xd:doc>
	<xsl:template match="xoev-fachmodell" mode="lite:nachrichten-tabelle">
		<xsl:variable name="document-directory" select="'dokumente/anhang/nachrichten'"
			as="xs:string"/>
		<xsl:variable name="target-document-directory"
			select="concat($document-directory, '/', 'nachrichtenGesamt', '.xml')" as="xs:string"/>

		<!-- Diese Variable enthält den Content einer zu erzeugenden Datei. -->
		<xsl:variable name="content">
			<xsl:apply-templates select="." mode="lite:nachrichten-tabelle-content"/>
		</xsl:variable>
		<xsl:variable name="contentwithoutprefix">
			<xsl:apply-templates select="$content" mode="lite:namespace-ohne-praefix"/>
		</xsl:variable>
		
		<!-- Hinweis: Tabelle wird auch ohne Nachrichten erzeugt, enthält dann nur Schemata -->
		
		<!-- Hier wird das Template zur Dateierzeugung aufgerufen -->
		<xsl:call-template name="lite:write-file-return-log">
			<xsl:with-param name="content" select="$contentwithoutprefix"/>
			<xsl:with-param name="local-path" select="xs:anyURI($target-document-directory)"/>
		</xsl:call-template>
	</xsl:template>

	<xd:doc>
		<xd:desc>
			<xd:p>Erzeuge den gewünschten Content</xd:p>
		</xd:desc>
	</xd:doc>
	<xsl:template match="db:*" mode="lite:namespace-ohne-praefix">
		<xsl:element name="{local-name(.)}" namespace="{namespace-uri(.)}">
			<xsl:apply-templates select="node() | @*" mode="#current"/>
		</xsl:element>
	</xsl:template>

	<xd:doc>
		<xd:desc>
			<xd:p>Unterdrückt Namespace-Präfixe in Ausgabedatei</xd:p>
		</xd:desc>
	</xd:doc>
	<xsl:template match="node() | @*" mode="lite:namespace-ohne-praefix">
		<xsl:copy>
			<xsl:apply-templates select="node() | @*" mode="#current"/>
		</xsl:copy>
	</xsl:template>

	<xd:doc>
		<xd:desc>
			<xd:p>Tabelle aller Nachrichten im Standard</xd:p>
		</xd:desc>
	</xd:doc>

	<xsl:template match="xoev-fachmodell" mode="lite:nachrichten-tabelle-content">
		<appendix version="5" xml:lang="de">
			<title>Nachrichtengesamtübersicht</title>
			<informaltable version="5" xml:lang="de">
				<!-- Verschiedene Spaltenkombinationen, je nachdem, für welche Spalten der Standard Werte enthält: -->

				<xsl:choose>
					<xsl:when test="not(.//*:wsdlService) and .//*:nachricht[matches(tokenize(@name, '\.')[last()], '^[0-9]+$')]">
						<!-- Wenn kein Dienst vorhanden ist: -->
						<tgroup cols="4">
							<colspec colname="Bezeichnung" colnum="1" colwidth="43mm"/>
							<colspec colname="Nr" colnum="2" colwidth="13mm"/>
							<colspec colname="Beschreibung" colnum="3" colwidth="79mm"/>
							<colspec colname="Seite" colnum="4" colwidth="25mm"/>
							<thead>
								<row>
									<entry align="center">Bezeichnung</entry>
									<entry align="center">Nr.</entry>
									<entry align="center">Beschreibung</entry>
									<entry align="center">Seite</entry>
								</row>
							</thead>
							<tbody>
								<xsl:apply-templates select=".//xsdSchema"									
									mode="lite:nachrichten-tabelle">
									<xsl:with-param name="keinDienst" select="true()"/>
									<xsl:sort select="@schemaFile"/>
								</xsl:apply-templates>
							
							</tbody>
						</tgroup>					
					</xsl:when>
					<xsl:when test="not(.//*:nachricht[matches(tokenize(@name, '\.')[last()], '^[0-9]+$')]) and .//*:wsdlService">
						<!-- Wenn keine Nachrichtennummer vorhanden ist: -->
						<tgroup cols="4">
							<!-- TODO: Spaltengröße evtl. angepassen -->
							<colspec colname="Bezeichnung" colnum="1" colwidth="27mm"/>
							<colspec colname="Beschreibung" colnum="3" colwidth="63mm"/>
							<colspec colname="Dienst" colnum="4" colwidth="32mm"/>
							<colspec colname="Seite" colnum="5" colwidth="25mm"/>
							<thead>
								<row>
									<entry align="center">Bezeichnung</entry>
									<entry align="center">Beschreibung</entry>
									<entry align="center">Dienst</entry>
									<entry align="center">Seite</entry>
								</row>
							</thead>
							<tbody>
								<xsl:apply-templates select=".//*:xsdSchema"
									mode="lite:nachrichten-tabelle">
									<xsl:with-param name="keineNr" select="true()"/>
									<xsl:sort select="@schemaFile"/>
								</xsl:apply-templates>
							</tbody>
						</tgroup>
					</xsl:when>

					<xsl:when test="not(.//*:nachricht[matches(tokenize(@name, '\.')[last()], '^[0-9]+$')]) and not(.//*:wsdlService)">
						<!-- Wenn keine Nachrichtennummer UND kein Dienst vorhanden ist: -->
						<tgroup cols="3">
							<colspec colname="Bezeichnung" colnum="1" colwidth="43mm"/>
							<colspec colname="Beschreibung" colnum="2" colwidth="79mm"/>
							<colspec colname="Seite" colnum="3" colwidth="25mm"/>
							<thead>
								<row>
									<entry align="center">Bezeichnung</entry>
									<entry align="center">Beschreibung</entry>
									<entry align="center">Seite</entry>
								</row>
							</thead>
							<tbody>
								<xsl:apply-templates select=".//*:xsdSchema"
									mode="lite:nachrichten-tabelle">
									<xsl:with-param name="keineNr" select="true()"/>
									<xsl:with-param name="keinDienst" select="true()"/>
									<xsl:sort select="@schemaFile"/>
								</xsl:apply-templates>
							</tbody>
						</tgroup>
					</xsl:when>
					<xsl:otherwise>
						<!-- Alle darstellbaren Informationen vorhanden: -->
						<tgroup cols="5">
							<colspec colnum="1" colname="Bezeichnung" colwidth="27mm"/>
							<colspec colnum="2" colname="Nr." colwidth="13mm"/>
							<colspec colnum="3" colname="Beschreibung" colwidth="63mm"/>
							<colspec colnum="4" colname="Dienst" colwidth="32mm"/>
							<colspec colnum="5" colname="Seite" colwidth="25mm"/>
							<thead>
								<row>
									<entry align="center">Bezeichnung</entry>
									<entry align="center">Nr.</entry>
									<entry align="center">Beschreibung</entry>
									<entry align="center">Dienst</entry>
									<entry align="center">Seite</entry>
								</row>
							</thead>						
							<tbody>
								<xsl:apply-templates select=".//xsdSchema"
									mode="lite:nachrichten-tabelle">
									<xsl:sort select="@schemaFile"/>
								</xsl:apply-templates>
							</tbody>
						</tgroup>										
					</xsl:otherwise>
				</xsl:choose>
			</informaltable>
		</appendix>
	</xsl:template>
	
	<xd:doc>
		<xd:desc>
			<xd:p>Verarbeitung eines xsdSchema-Pakets</xd:p>
		</xd:desc>
		<xd:param name="keineNr">Nachrichtennamen enthalten keine Nachrichtennummern</xd:param>
		<xd:param name="keinDienst">Keine Dienste vorhanden</xd:param>
	</xd:doc>
	<xsl:template match="xsdSchema" mode="lite:nachrichten-tabelle">
		<xsl:param name="keineNr" required="no"/>
		<xsl:param name="keinDienst" required="no"/>
		<row role="xsdSchema">
			<entry align="center" namest="Bezeichnung" nameend="Seite">
				<emphasis role="bold">Schema-Datei: <xsl:value-of select="@schemaFile"/></emphasis>
			</entry>
		</row>
		<xsl:apply-templates select=".//nachricht" mode="lite:nachrichten-tabelle">
			<xsl:with-param name="keineNr" select="$keineNr"/>
			<xsl:with-param name="keinDienst" select="$keinDienst"/>
			<xsl:sort select="tokenize(@name, '\.')[last()]"/>
			<xsl:sort select="@name"/>
		</xsl:apply-templates>
	</xsl:template>

	<xd:doc>
		<xd:desc>
			<xd:p>Tabelle aller Nachrichten eines xsdSchema-Pakets</xd:p>
		</xd:desc>
		<xd:param name="keineNr">Nachrichtennamen enthalten keine Nachrichtennummern</xd:param>
		<xd:param name="keinDienst">Keine Dienste vorhanden</xd:param>
	</xd:doc>
	<xsl:template match="xsdSchema[.//nachricht] | xsdSchema//paket[./nachricht]"
		mode="lite:nachrichten-tabelle-paket-content">
		<xsl:param name="keineNr" required="no"/>
		<xsl:param name="keinDienst" required="no"/>
		<informaltable version="5" xml:lang="de" xml:id="{concat('tabelle.', lite:docbook-id(.))}" role="xsdSchema">
			<!-- Verschiedene Spaltenkombinationen, je nachdem, für welche Spalten der Standard Werte enthält: -->
			
			<xsl:choose>
				<xsl:when test=".//nachricht[matches(tokenize(@name, '\.')[last()], '^[0-9]+$')] and not(.[some $dienstnachricht in //wsdlService/wsdlServiceMessage|wsdlServiceOutputMessage|wsdlServiceFaultMessage|wsdlServiceInputMessage, $nachrichtenname in ./nachricht/@name satisfies substring-after($dienstnachricht,':') = $nachrichtenname])">
					<!-- Wenn kein Dienst vorhanden ist: -->
					<tgroup cols="4">
						<colspec colnum="1" colname="c1" colwidth="43mm"/>
						<colspec colnum="2" colname="c2" colwidth="13mm"/>
						<colspec colnum="3" colname="c3" colwidth="79mm"/>
						<colspec colnum="4" colname="c4" colwidth="25mm"/>
						<thead>
							<row>
								<entry namest="c1" nameend="c4" align="center">Alle Nachrichten zu <quote>
									<xsl:value-of select="(@titel, @name)[1]"/>
								</quote>
								</entry>
							</row>
							<row>
								<entry align="center">Bezeichnung</entry>
								<entry align="center">Nr.</entry>
								<entry align="center">Beschreibung</entry>
								<entry align="center">Seite</entry>
							</row>
						</thead>
						<tbody>
							<xsl:apply-templates select=".//nachricht"
								mode="lite:nachrichten-tabelle-paket">
								<xsl:with-param name="keinDienst" select="true()"/>
								<xsl:sort select="tokenize(@name, '\.')[last()]"/>
								<xsl:sort select="@name"/>
							</xsl:apply-templates>
						</tbody>
					</tgroup>
				</xsl:when>
				<xsl:when test="not(.//nachricht[matches(tokenize(@name, '\.')[last()], '^[0-9]+$')]) and .[some $dienstnachricht in //wsdlService/wsdlServiceMessage|wsdlServiceOutputMessage|wsdlServiceFaultMessage|wsdlServiceInputMessage, $nachrichtenname in ./nachricht/@name satisfies substring-after($dienstnachricht,':') = $nachrichtenname]">
					<!-- Wenn keine Nachrichtennummer vorhanden ist: -->
					<tgroup cols="4">
						<colspec colnum="1" colname="c1" colwidth="43mm"/>
						<colspec colnum="2" colname="c2" colwidth="13mm"/>
						<colspec colnum="3" colname="c3" colwidth="79mm"/>
						<colspec colnum="4" colname="c4" colwidth="25mm"/>
						<thead>
							<row>
								<entry namest="c1" nameend="c4" align="center">Alle Nachrichten zu <quote>
									<xsl:value-of select="(@titel, @name)[1]"/>
								</quote>
								</entry>
							</row>
							<row>
								<entry align="center">Bezeichnung</entry>								
								<entry align="center">Beschreibung</entry>
								<entry align="center">Dienst</entry>
								<entry align="center">Seite</entry>
							</row>
						</thead>
						<tbody>
							<xsl:apply-templates select=".//nachricht"
								mode="lite:nachrichten-tabelle-paket">
								<xsl:with-param name="keineNr" select="true()"/>
								<xsl:sort select="tokenize(@name, '\.')[last()]"/>
								<xsl:sort select="@name"/>
							</xsl:apply-templates>
						</tbody>
					</tgroup>
				</xsl:when>
				<xsl:when
					test="not(.//nachricht[matches(tokenize(@name, '\.')[last()], '^[0-9]+$')]) and not(.[some $dienstnachricht in //wsdlService/wsdlServiceMessage|wsdlServiceOutputMessage|wsdlServiceFaultMessage|wsdlServiceInputMessage, $nachrichtenname in ./nachricht/@name satisfies substring-after($dienstnachricht,':') = $nachrichtenname])">
					<!-- Wenn keine Nachrichtennummer UND kein Dienst vorhanden ist: -->
					<tgroup cols="3">
						<colspec colnum="1" colname="c1" colwidth="43mm"/>
						<colspec colnum="2" colname="c2" colwidth="79mm"/>
						<colspec colnum="3" colname="c3" colwidth="25mm"/>
						<thead>
							<row>
								<entry namest="c1" nameend="c3" align="center">Alle Nachrichten zu <quote>
									<xsl:value-of select="(@titel, @name)[1]"/>
									</quote>
								</entry>
							</row>
							<row>
								<entry align="center">Bezeichnung</entry>
								<entry align="center">Beschreibung</entry>
								<entry align="center">Seite</entry>
							</row>
						</thead>
						<tbody>
							<xsl:apply-templates select=".//nachricht"
								mode="lite:nachrichten-tabelle-paket">
								<xsl:with-param name="keineNr" select="true()"/>
								<xsl:with-param name="keinDienst" select="true()"/>
								<xsl:sort select="tokenize(@name, '\.')[last()]"/>
								<xsl:sort select="@name"/>
							</xsl:apply-templates>
						</tbody>
					</tgroup>
				</xsl:when>
				<xsl:otherwise>
					<!-- Alle darstellbaren Informationen vorhanden: -->
					<tgroup cols="5">
						<colspec colnum="1" colname="c1" colwidth="27mm"/>
						<colspec colnum="2" colname="c2" colwidth="13mm"/>
						<colspec colnum="3" colname="c3" colwidth="63mm"/>
						<colspec colnum="4" colname="c4" colwidth="32mm"/>
						<colspec colnum="5" colname="c5" colwidth="25mm"/>
						<thead>
							<row>
								<entry namest="c1" nameend="c5" align="center">Alle Nachrichten zu <quote>
									<xsl:value-of select="(@titel, @name)[1]"/>
								</quote>
								</entry>
							</row>
							<row>
								<entry align="center">Bezeichnung</entry>
								<entry align="center">Nr.</entry>
								<entry align="center">Beschreibung</entry>
								<entry align="center">Dienst</entry>
								<entry align="center">Seite</entry>
							</row>
						</thead>
						<tbody>
							<xsl:apply-templates select=".//nachricht"
								mode="lite:nachrichten-tabelle-paket">
								<xsl:sort select="tokenize(@name, '\.')[last()]"/>
								<xsl:sort select="@name"/>
							</xsl:apply-templates>
						</tbody>
					</tgroup>
				</xsl:otherwise>
			</xsl:choose>
		</informaltable>
	</xsl:template>

	<xd:doc>
		<xd:desc>
			<xd:p>Nachrichtenzeile</xd:p>
		</xd:desc>
		<xd:param name="keineNr">Nachrichtennamen enthalten keine Nachrichtennummern</xd:param>
		<xd:param name="keinDienst">Keine Dienste vorhanden</xd:param>
	</xd:doc>
	<xsl:template match="nachricht" mode="lite:nachrichten-tabelle-paket lite:nachrichten-tabelle">
		<xsl:param name="keineNr" required="no"/>
		<xsl:param name="keinDienst" required="no"/>
		<row role="nachricht">
			<entry>
				<para>
					<xsl:value-of select="(@titel, @name)[1]"/>
				</para>
			</entry>
			
			<!-- Spalte Nr. nur erzeugen, wenn @name nach dem letzten "." eine Ziffernfolge enthält 	-->
			<xsl:choose>
				<xsl:when test="matches(tokenize(@name, '\.')[last()], '^[0-9]+$')">
					<entry>
						<para>
							<xsl:value-of select="tokenize(@name, '\.')[last()]"/>
						</para>
					</entry>
				</xsl:when>
				<xsl:when test="$keineNr"/>
				<xsl:otherwise>
					<entry>
						<xsl:text/>
					</entry>
				</xsl:otherwise>
			</xsl:choose>

			<entry>
				<xsl:apply-templates select="beschreibung" mode="lite:dokumentation.beschreibung"/>
				<xsl:sequence select="lite:rechtsgrundlage-liste(rechtsgrundlage)"/>
			</entry>
			
			<!-- TODO Spalte "Dienst": die Bedingungen müssen angepasst werden, sobald der Dienst-Bezug im Lite-Modell implementiert wurde.-->
			
			<xsl:variable name="nachrichtenName" select="concat(lite:prefix(.), ':', @name)"/>
			
			<xsl:variable name="dienst" select="//wsdlService[wsdlServiceMessage|wsdlServiceOutputMessage|wsdlServiceFaultMessage|wsdlServiceInputMessage=$nachrichtenName]/@name"/>

			<xsl:choose>
				<xsl:when test="$keinDienst"/>
				<xsl:when test="$dienst">
					<entry>											
							<xsl:for-each select="$dienst">
								<para role="wsdlService">	
								<xsl:value-of select="."/>
								</para>
							</xsl:for-each>
					</entry>					
				</xsl:when>
				<xsl:otherwise>
					<entry>
						<xsl:text/>
					</entry>
				</xsl:otherwise>
			</xsl:choose>
			<entry>
				<para>
					<xref role="Seite" linkend="{lite:docbook-id(.)}"/>
				</para>
			</entry>
		</row>
	</xsl:template>

	
</xsl:stylesheet>
