<xsl:stylesheet 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:xlink="http://www.w3.org/1999/xlink"
	xmlns:xs="http://www.w3.org/2001/XMLSchema" 
	xmlns:db="http://docbook.org/ns/docbook" 
	xmlns:gc="http://docs.oasis-open.org/codelist/ns/genericode/1.0/" 
	xmlns:log="http://www.xoev.de/de/xgenerator/framework/1/log" 
	xmlns:xoev-cl-2="http://xoev.de/schemata/genericode/2" 
	xmlns:xoev-cl-4="http://xoev.de/schemata/genericode/4" 
	xmlns:lite="urn:xoev-de:kosit:xoev:lite:transformation_1.2.0" 
	xmlns:lite-bib="urn:xoev-de:kosit:xoev:lite:schema:bibliothek_1.2.0" 
	xmlns:lite-fm="urn:xoev-de:kosit:xoev:lite:schema:fachmodell_1.2.0" 
	xmlns:xgen="http://www.xoev.de/de/xgenerator/framework/1/library" 
	xmlns="http://docbook.org/ns/docbook" 
	xpath-default-namespace="urn:xoev-de:kosit:xoev:lite:schema:fachmodell_1.2.0" 
	version="2.0" 
	exclude-result-prefixes="xgen xsl xs db gc log xoev-cl-2 xoev-cl-4 lite lite-fm lite-bib">
   
	<!-- Einstiegspunkt für die Generierung -->
   <xsl:template match="/" mode="lite:externe-modelle-und-inhalte-entry">
      <xsl:apply-templates select="xoev-fachmodell" mode="lite:externe-modelle-und-inhalte"/>
	</xsl:template>
	
	
   <!-- Erzeuge Datei-->
   <xsl:template match="xoev-fachmodell" mode="lite:externe-modelle-und-inhalte">
      
      <!-- Diese Variable verweisen auf den Ordner in dem ein Datei gespeichert werden soll -->
      <xsl:variable name="document-directory" select="'dokumente/anhang/externeModelle/externeModelle.xml'" as="xs:string"/>
      
      <!-- Diese Variable enthält den Content einer zu erzeugenden Datei. -->
      <xsl:variable name="content">
         <xsl:apply-templates select="." mode="lite:externe-modelle-und-inhalte-content"/>
      </xsl:variable>
      
      <!-- Hier wird das Template zur Dateierzeugung aufgerufen -->
      <xsl:call-template name="lite:write-file-return-log">
         <xsl:with-param name="content" select="$content"/>
         <xsl:with-param name="local-path" select="xs:anyURI($document-directory)"/>
      </xsl:call-template>

   </xsl:template>


	<!-- Erzeuge den gewünschten Content -->
   <xsl:template match="xoev-fachmodell" mode="lite:externe-modelle-und-inhalte-content">
      
      <appendix version="5">
         <title>Eingebundene externe Modelle</title>

         <xsl:choose>
            <xsl:when test="not(//externesModell)">
               <para>Hinweis: In diesem Standard sind keine externen Modelle eingebunden.</para>
               <!-- Datei wird erzeugt, aber Einbindung bleibt dem Standard überlassen. -->
            </xsl:when>
            <xsl:otherwise>
         
               <para>Folgende externe Modelle werden in diesem Standard verwendet und sind auf den XÖV-Webseiten (siehe <db:link xlink:href="https://docs.xoev.de/"/>) oder im XRepository (siehe <db:link xlink:href="http://www.xrepository.de"/>) veröffentlicht:</para>
 
         <xsl:for-each select="//externesModell">
            
            <xsl:variable name="genutzte-externe-inhalte" select="lite:genutzte-externe-inhalte-metadaten(.)"/>
            <xsl:variable name="Version-or-fassung" select="if ($genutzte-externe-inhalte[1]/@modell-kennung = 'urn:xoev-de:kosit:xoev:bibliothek:xoevbibliothek')
                                                            then 'Fassung:' else 'Version:'"/>
            
            <xsl:choose>
               <xsl:when test="empty($genutzte-externe-inhalte)">
                  <!-- Das externe Modell befindet sich im Ordner "externeModelle" und ist als Element "externesModell" in 
                  das Fachmodell eingetragen. Es werden jedoch keine Inhalte daraus verwendet. -->
                  <xsl:variable name="externeKennung" select="@kennung"/>
                  <xsl:variable name="externerNameKurz" select="$modelle[./*:xoev-fachmodell/*:metadaten.standard/*:kennung=$externeKennung]/*:xoev-fachmodell/*:metadaten.standard/*:nameKurz"/>
                  <section role="externesModell">
                     <title><xsl:value-of select="$externerNameKurz"/></title>
                     <para>Hinweis: Das Modell wird eingebunden aber nicht verwendet.</para>
                  </section>
               </xsl:when>
               <xsl:otherwise>
                  <section xml:id="{replace(concat('externes.modell.', @kennung, '_', @version), '[:\-]+', '_')}" role="externesModell">
               <title><xsl:value-of select="$genutzte-externe-inhalte[1]/@nameKurz"/></title>
               <para><xsl:value-of select="concat('Kennung: ',$genutzte-externe-inhalte[1]/@modell-kennung,'; ',$Version-or-fassung,' ',$genutzte-externe-inhalte[1]/@modell-version)"/></para>
               
               <para>Folgende Inhalte aus dem externen Modell werden in diesem Standard verwendet:</para>
               <informaltable>
                  <tgroup cols="2">
                     <colspec colname="Name" colnum="1" colwidth="1*"/>
                     <colspec colname="Namensraum" colnum="2" colwidth="1*"/>
                     <thead>
                        <row>
                           <entry>Name</entry>
                           <entry>Namensraum</entry>
                        </row>
                     </thead>
                     <tbody>
                        <xsl:for-each select="$genutzte-externe-inhalte">
                           <xsl:sort select="substring-after(./@name,':')"></xsl:sort>
                           <row>
                              <entry><xsl:value-of select="@name"/></entry>
                              <entry><xsl:value-of select="@namespace"/></entry>
                           </row>
                        </xsl:for-each>
                     </tbody>
                  </tgroup>
               </informaltable>
            </section>
               </xsl:otherwise>
            </xsl:choose>
            
         </xsl:for-each>
            </xsl:otherwise>
         </xsl:choose>
      </appendix>
   </xsl:template>
   
</xsl:stylesheet>
