<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:xd="http://www.oxygenxml.com/ns/doc/xsl" xmlns:xs="http://www.w3.org/2001/XMLSchema"
	xmlns:db="http://docbook.org/ns/docbook"
	xmlns:gc="http://docs.oasis-open.org/codelist/ns/genericode/1.0/"
	xmlns:xoev-cl-2="http://xoev.de/schemata/genericode/2"
	xmlns:xoev-cl-4="http://xoev.de/schemata/genericode/4"
	xmlns:lite="urn:xoev-de:kosit:xoev:lite:transformation_1.2.0"
	xmlns:lite-bib="urn:xoev-de:kosit:xoev:lite:schema:bibliothek_1.2.0"
	xmlns:lite-fm="urn:xoev-de:kosit:xoev:lite:schema:fachmodell_1.2.0"
	xmlns:xgen="http://www.xoev.de/de/xgenerator/framework/1/library"
	xmlns:util="http://lite2db4/util" xmlns="http://docbook.org/ns/docbook"
	xpath-default-namespace="urn:xoev-de:kosit:xoev:lite:schema:fachmodell_1.2.0" version="2.0"
	exclude-result-prefixes="xgen xsl xd xs db gc xoev-cl-2 xoev-cl-4 lite lite-fm lite-bib util">

	<xsl:output method="xml" indent="yes" use-character-maps="lite:_unescaped-xml-character-map"/>
	<xd:doc>
		<xd:desc>Generierung einer tabellarischen Übersicht über alle Nachrichten des
			Standards und Generierung einer tabellarischen Übersicht über alle Nachrichten
			eines Pakets</xd:desc>
	</xd:doc>
	<xd:doc>
		<xd:desc>
			<xd:p>Einstiegspunkt für die Generierung</xd:p>
		</xd:desc>
	</xd:doc>
	<xsl:template match="/" mode="lite:nachrichten-tabelle-entry">
		<xsl:apply-templates select="xoev-fachmodell" mode="lite:nachrichten-tabelle"/>
		<xsl:apply-templates select="//xsdSchema[.//nachricht]"
			mode="lite:nachrichten-tabelle-paket"/>
		<xsl:apply-templates select="//xsdSchema//paket[./nachricht]"
			mode="lite:nachrichten-tabelle-paket"/>
	</xsl:template>

	<xd:doc>
		<xd:desc>
			<xd:p>Erzeuge Datei: xsdSchema</xd:p>
		</xd:desc>
	</xd:doc>
	<xsl:template match="xsdSchema[.//nachricht] | xsdSchema//paket[./nachricht]"
		mode="lite:nachrichten-tabelle-paket">
		<xsl:variable name="document-directory"
			select="concat('dokumente/', lite:set-path-or-filename(ancestor::xoev-fachmodell/metadaten.standard/nameTechnisch))"
			as="xs:string"/>
		<xsl:variable name="target-document-directory"
			select="concat((string-join(($document-directory, string-join(ancestor::*/@name, '/')), '/')), '/tabelle.nachrichten.')"
			as="xs:string"/>
	  
		<!-- Diese Variable enthält den Content einer zu erzeugenden Datei. -->
		<xsl:variable name="content">
			<xsl:apply-templates select=".[.//nachricht]" mode="lite:nachrichten-tabelle-paket-content"/>
		</xsl:variable>
	  
		<xsl:variable name="contentwithoutprefix">
			<xsl:apply-templates select="$content" mode="lite:namespace-ohne-praefix"/>
		</xsl:variable>

		
		<!-- Hier wird das Template zur Dateierzeugung aufgerufen -->	
	  <xsl:call-template name="xgen:result-document">
	    <xsl:with-param name="local-path" select="xs:anyURI(concat($target-document-directory, lite:set-path-or-filename(@name) , '.adoc'))"/>
	    <xsl:with-param name="method">text</xsl:with-param>
	    <xsl:with-param name="content" select="$contentwithoutprefix"/>
	  </xsl:call-template>
	</xsl:template>

	<xd:doc>
		<xd:desc>
			<xd:p>Erzeuge Datei: Fachmodell</xd:p>
		</xd:desc>
	</xd:doc>
	<xsl:template match="xoev-fachmodell" mode="lite:nachrichten-tabelle">
		<xsl:variable name="document-directory" select="'dokumente/anhang/nachrichten'"
			as="xs:string"/>
		<xsl:variable name="target-document-directory"
			select="concat($document-directory, '/', 'nachrichtenGesamt', '.adoc')" as="xs:string"/>
	  
		<!-- Diese Variable enthält den Content einer zu erzeugenden Datei. -->
		<xsl:variable name="content">
			<xsl:apply-templates select="." mode="lite:nachrichten-tabelle-content"/>
		</xsl:variable>
	  
		<xsl:variable name="contentwithoutprefix">
			<xsl:apply-templates select="$content" mode="lite:namespace-ohne-praefix"/>
		</xsl:variable>
		
		<!-- Hier wird das Template zur Dateierzeugung aufgerufen -->
	  <xsl:call-template name="xgen:result-document">
	    <xsl:with-param name="local-path" select="xs:anyURI($target-document-directory)"/>
	    <xsl:with-param name="method">text</xsl:with-param>
	    <xsl:with-param name="content" select="$contentwithoutprefix"/>
	  </xsl:call-template>
	</xsl:template>

	<xd:doc>
		<xd:desc>
			<xd:p>Erzeuge den gewünschten Content</xd:p>
		</xd:desc>
	</xd:doc>
	<xsl:template match="db:*" mode="lite:namespace-ohne-praefix">
		<xsl:element name="{local-name(.)}" namespace="{namespace-uri(.)}">
			<xsl:apply-templates select="node() | @*" mode="#current"/>
		</xsl:element>
	</xsl:template>

	<xd:doc>
		<xd:desc>
			<xd:p>Unterdrückt Namespace-Präfixe in Ausgabedatei</xd:p>
			<xd:p>TODO: Ist das für adoc noch nötig/sinnvoll?</xd:p>
		</xd:desc>
	</xd:doc>
	<xsl:template match="node() | @*" mode="lite:namespace-ohne-praefix">
		<xsl:copy>
			<xsl:apply-templates select="node() | @*" mode="#current"/>
		</xsl:copy>
	</xsl:template>

	<xd:doc>
		<xd:desc>
			<xd:p>Tabelle aller Nachrichten im Standard</xd:p>
		</xd:desc>
	</xd:doc>
	<xsl:template match="xoev-fachmodell" mode="lite:nachrichten-tabelle-content">

	  <xsl:text>= Nachrichtengesamtübersicht&#x0A;&#x0A;</xsl:text>
	  
	  <xsl:text>ifndef::relfileprefix[]&#x0A;</xsl:text>
	  <xsl:text>:relfileprefix: ../../&#x0A;</xsl:text>
	  <xsl:text>endif::[]&#x0A;&#x0A;</xsl:text>
	
	  <xsl:text>:!section-refsig:&#x0A;&#x0A;</xsl:text>

				<xsl:choose>
				  
					<xsl:when test="not(.//*:wsdlService) and .//*:nachricht[matches(tokenize(@name, '\.')[last()], '^[0-9]+$')]">
						<!-- Wenn kein Dienst vorhanden ist: -->
					  <xsl:text>[cols="27%,8%,49%,16%"]&#x0A;</xsl:text>
					  <!-- in mm (Gesamtbreite 160 mm): 43mm,13mm,79mm,25mm -->
					  <xsl:text>|===&#x0A;</xsl:text>
					  <xsl:text>|Bezeichnung|Nr.|Beschreibung|Ref.&#x0A;&#x0A;</xsl:text>
					  <xsl:apply-templates select=".//xsdSchema"									
									mode="lite:nachrichten-tabelle">
					    <xsl:with-param name="keinDienst" select="true()"/>
									<xsl:sort select="@schemaFile"/>
					  </xsl:apply-templates>	
					  <xsl:text>|===&#x0A;&#x0A;</xsl:text>	
					</xsl:when>
				  
					<xsl:when test="not(.//*:nachricht[matches(tokenize(@name, '\.')[last()], '^[0-9]+$')]) and .//*:wsdlService">
						<!-- keine Spalte Nr. vorhanden ist: -->
					  <xsl:text>[cols="18%,43%,22%,17%"]&#x0A;</xsl:text>
					  <!-- in mm (Gesamtbreite hier nur 147 mm): 27mm,63mm,32mm,25mm -->
					  <!-- tbd: Spaltengröße muss evtl. angepasst werden -->
					  <xsl:text>|===&#x0A;</xsl:text>
					  <xsl:text>|Bezeichnung|Beschreibung|Dienst|Ref.&#x0A;&#x0A;</xsl:text>
					  <xsl:apply-templates select=".//*:xsdSchema"
									mode="lite:nachrichten-tabelle">
					    <xsl:with-param name="keineNr" select="true()"/>
									<xsl:sort select="@schemaFile"/>
					  </xsl:apply-templates>
					  <xsl:text>|===&#x0A;&#x0A;</xsl:text>
					</xsl:when>

					<xsl:when test="not(.//*:nachricht[matches(tokenize(@name, '\.')[last()], '^[0-9]+$')]) and not(.//*:wsdlService)">
						<!-- keine Nr. UND kein Dienst vorhanden: -->
					  <xsl:text>[cols="29%,54%,17%"]&#x0A;</xsl:text>
					  <!-- in mm (Gesamtbreite hier nur 147 mm): 43mm,79mm,25mm -->
					  <xsl:text>|===&#x0A;</xsl:text>
					  <xsl:text>|Bezeichnung|Beschreibung|Ref.&#x0A;&#x0A;</xsl:text>
					  <xsl:apply-templates select=".//*:xsdSchema"
									mode="lite:nachrichten-tabelle">
									<xsl:with-param name="keineNr" select="true()"/>
					    <xsl:with-param name="keinDienst" select="true()"/>
									<xsl:sort select="@schemaFile"/>
					  </xsl:apply-templates>
					  <xsl:text>|===&#x0A;&#x0A;</xsl:text>
					</xsl:when>
				  
					<xsl:otherwise>
					  <xsl:text>[cols="17%,8%,39%,20%,16%"]&#x0A;</xsl:text>
					  <!-- in mm (Gesamtbreite 160 mm): 27mm,13mm,63mm,32mm,25mm -->
					  <xsl:text>|===&#x0A;</xsl:text>
					  <xsl:text>|Bezeichnung|Nr.|Beschreibung|Dienst|Ref.&#x0A;&#x0A;</xsl:text>
					  <xsl:apply-templates select=".//xsdSchema"
					    mode="lite:nachrichten-tabelle">
									<xsl:sort select="@schemaFile"/>
								</xsl:apply-templates>		
					  <xsl:text>|===&#x0A;&#x0A;</xsl:text>
					</xsl:otherwise>
				  
				</xsl:choose>
	  
	  <xsl:text>:section-refsig: Abschnitt&#x0A;&#x0A;</xsl:text>
	  
	</xsl:template>
  
	<xd:doc>
		<xd:desc>
			<xd:p>Verarbeitung eines xsdSchema-Pakets</xd:p>
		</xd:desc>
	  <xd:param name="keineNr">Keine der Nachrichten des Schemas hat ein numerisches Suffix</xd:param>
	  <xd:param name="keinDienst">Keiner Nachricht des Schemas ist ein Dienst zugeordnet</xd:param>
	</xd:doc>
	<xsl:template match="xsdSchema" mode="lite:nachrichten-tabelle">
	  <xsl:param name="keineNr" required="no"/>
	  <xsl:param name="keinDienst" required="no"/>
	  
<!--	Zeile geht über alle Spalten, Anzahl variiert je nach Fall -->
	  <xsl:variable name="numcols" select="if ($keineNr and $keinDienst) then 3 else (if (not($keineNr or $keinDienst)) then 5 else 4)"/>
	  <xsl:value-of select="concat($numcols,'+|*Schema-Datei: ',@schemaFile,'*&#x0A;')"/>
	  
		<xsl:apply-templates select=".//nachricht" mode="lite:nachrichten-tabelle">
			<xsl:with-param name="keineNr" select="$keineNr"/>
			<xsl:with-param name="keinDienst" select="$keinDienst"/>
			<xsl:sort select="tokenize(@name, '\.')[last()]"/>
			<xsl:sort select="@name"/>
		</xsl:apply-templates>
	</xsl:template>

	<xd:doc>
		<xd:desc>
			<xd:p>Tabelle aller Nachrichten eines xsdSchema-Pakets</xd:p>
		</xd:desc>
	  <xd:param name="keineNr">Keine der Nachrichten des Schemas/Pakets hat ein numerisches Suffix</xd:param>
	  <xd:param name="keinDienst">Keiner Nachricht des Schemas/Pakets ist ein Dienst zugeordnet</xd:param>
	</xd:doc>
	<xsl:template match="xsdSchema[.//nachricht] | xsdSchema//paket[./nachricht]"
		mode="lite:nachrichten-tabelle-paket-content">
		<xsl:param name="keineNr" required="no"/>
		<xsl:param name="keinDienst" required="no"/>
	  
	  <xsl:variable name="level" select="count(ancestor-or-self::*[self::paket|self::xsdSchema])"/>
	  <xsl:variable name="dokumente-navigate-up" select="string-join(for $i in 1 to $level return '../', '')"/>
	  
	  <xsl:text>ifndef::relfileprefix[]&#x0A;</xsl:text>
	  <xsl:value-of select="concat(':relfileprefix: ',$dokumente-navigate-up, '&#x0A;')"/> 
	  <xsl:text>endif::[]&#x0A;&#x0A;</xsl:text>
	  
	  <xsl:text>:!section-refsig:&#x0A;&#x0A;</xsl:text>	  
	  
	  <xsl:value-of select="concat('[id=tabelle.', lite:docbook-id(.),']&#x0A;')"/>

			<xsl:choose>
			  
				<xsl:when test=".//nachricht[matches(tokenize(@name, '\.')[last()], '^[0-9]+$')] and not(.[some $dienstnachricht in //wsdlService/wsdlServiceMessage|wsdlServiceOutputMessage|wsdlServiceFaultMessage|wsdlServiceInputMessage, $nachrichtenname in ./nachricht/@name satisfies substring-after($dienstnachricht,':') = $nachrichtenname])">
					<!-- Nr. aber kein Dienst vorhanden -->
				  <xsl:text>[cols="27%,8%,49%,16%"]&#x0A;</xsl:text>
				  <!-- in mm (Gesamtbreite 160 mm): 43mm,13mm,79mm,25mm -->
				  <xsl:text>|===&#x0A;</xsl:text>
				  <xsl:value-of select="concat('4+|Alle Nachrichten zu &quot;',(@titel, @name)[1],'&quot;&#x0A;&#x0A;')"/>
				  <xsl:text>s|Bezeichnung s|Nr. s|Beschreibung s|Ref.&#x0A;&#x0A;</xsl:text>
							<xsl:apply-templates select=".//nachricht"
								mode="lite:nachrichten-tabelle-paket">
								<xsl:with-param name="keinDienst" select="true()"/>
								<xsl:sort select="tokenize(@name, '\.')[last()]"/>
								<xsl:sort select="@name"/>
							</xsl:apply-templates>
				  <xsl:text>|===&#x0A;</xsl:text>
				</xsl:when>
			  
				<xsl:when test="not(.//nachricht[matches(tokenize(@name, '\.')[last()], '^[0-9]+$')]) and .[some $dienstnachricht in //wsdlService/wsdlServiceMessage|wsdlServiceOutputMessage|wsdlServiceFaultMessage|wsdlServiceInputMessage, $nachrichtenname in ./nachricht/@name satisfies substring-after($dienstnachricht,':') = $nachrichtenname]">
					<!-- Keine Nr. aber Dienst vorhanden -->
				  <xsl:text>[cols="18%,43%,22%,17%"]&#x0A;</xsl:text>
				  <!-- in mm (Gesamtbreite hier nur 147 mm: 43mm,13mm,79mm,25mm -->
				  <!-- TODO: Achtung: diese Spalten in mm entsprechen Fall 1, muss vermutlich in lite2db korrigiert werden -->
				  <xsl:text>|===&#x0A;</xsl:text>
				  <xsl:value-of select="concat('4+|Alle Nachrichten zu &quot;',(@titel, @name)[1],'&quot;&#x0A;&#x0A;')"/>
				  <xsl:text>s|Bezeichnung s|Beschreibung s|Dienst s|Ref.&#x0A;&#x0A;</xsl:text>
							<xsl:apply-templates select=".//nachricht"
								mode="lite:nachrichten-tabelle-paket">
							  <xsl:with-param name="keineNr" select="true()"/>
								<xsl:sort select="tokenize(@name, '\.')[last()]"/>
								<xsl:sort select="@name"/>
							</xsl:apply-templates>
				  <xsl:text>|===&#x0A;</xsl:text>
				</xsl:when>
			  
				<xsl:when
					test="not(.//nachricht[matches(tokenize(@name, '\.')[last()], '^[0-9]+$')]) and not(.[some $dienstnachricht in //wsdlService/wsdlServiceMessage|wsdlServiceOutputMessage|wsdlServiceFaultMessage|wsdlServiceInputMessage, $nachrichtenname in ./nachricht/@name satisfies substring-after($dienstnachricht,':') = $nachrichtenname])">
					<!-- Keine Nr. und  KEIN Dienstverweis in mind. einer Nachricht des Pakets vorhanden ist -->
				  <xsl:text>[cols="29%,54%,17%"]&#x0A;</xsl:text>
				  <!-- in mm (Gesamtbreite hier nur 147 mm): 43mm,79mm,25mm -->
				  <xsl:text>|===&#x0A;</xsl:text>
				  <xsl:value-of select="concat('3+|Alle Nachrichten zu &quot;',(@titel, @name)[1],'&quot;&#x0A;&#x0A;')"/>
				  <xsl:text>s|Bezeichnung s|Beschreibung s|Ref.&#x0A;&#x0A;</xsl:text>
							<xsl:apply-templates select=".//nachricht"
								mode="lite:nachrichten-tabelle-paket">
								<xsl:with-param name="keineNr" select="true()"/>
							  <xsl:with-param name="keinDienst" select="true()"/>
								<xsl:sort select="tokenize(@name, '\.')[last()]"/>
								<xsl:sort select="@name"/>
							</xsl:apply-templates>
				  <xsl:text>|===&#x0A;</xsl:text>
				</xsl:when>
			  
				<xsl:otherwise>				
				  <xsl:text>[cols="17%,8%,39%,20%,16%"]&#x0A;</xsl:text>
				  <!-- in mm (Gesamtbreite 160 mm): 27mm,13mm,63mm,32mm,25mm -->
				  <xsl:text>|===&#x0A;</xsl:text>
				  <xsl:value-of select="concat('5+|Alle Nachrichten zu &quot;',(@titel, @name)[1],'&quot;&#x0A;&#x0A;')"/>
				  <xsl:text>s|Bezeichnung s|Nr. s|Beschreibung s|Dienst s|Ref.&#x0A;&#x0A;</xsl:text>
							<xsl:apply-templates select=".//nachricht"
							  mode="lite:nachrichten-tabelle-paket">
								<xsl:sort select="tokenize(@name, '\.')[last()]"/>
								<xsl:sort select="@name"/>
							</xsl:apply-templates>
				  <xsl:text>|===&#x0A;</xsl:text>
				</xsl:otherwise>
			  
			</xsl:choose>
	  
	  <xsl:text>:section-refsig: Abschnitt&#x0A;&#x0A;</xsl:text>
	  
	</xsl:template>

	<xd:doc>
		<xd:desc>
			<xd:p>Erzeugt für eine Nachricht eine Zeile in der Übersichtstabelle</xd:p>
		</xd:desc>
	  <xd:param name="keineNr">Nachricht hat kein numerisches Suffix</xd:param>
	  <xd:param name="keinDienst">Der Nachricht ist kein Dienst zugeordnet</xd:param>
	</xd:doc>
	<xsl:template match="nachricht" mode="lite:nachrichten-tabelle-paket lite:nachrichten-tabelle">
		<xsl:param name="keineNr" required="no"/>
		<xsl:param name="keinDienst" required="no"/>
	  
	  <xsl:value-of select="concat('|', (@titel, @name)[1])"/>
	  <!-- Spalte Nr. nur erzeugen, wenn @name nach dem letzten "." eine Ziffernfolge enthält 	-->
			<xsl:choose>
				<xsl:when test="matches(tokenize(@name, '\.')[last()], '^[0-9]+$')">
				  <xsl:value-of select="concat('|', tokenize(@name, '\.')[last()])"/>
				</xsl:when>
				<xsl:when test="$keineNr"/>
				<xsl:otherwise/>
			</xsl:choose>
	  
	  <xsl:text>|</xsl:text>
	  <xsl:apply-templates select="beschreibung" mode="lite:dokumentation.FliesstextUndDocBookType">
	    <xsl:with-param name="inTabelle" select="true()" tunnel="yes"/>
	  </xsl:apply-templates>
	  <xsl:text>&#x0A;&#x0A;</xsl:text>
	  
	  <xsl:if test="rechtsgrundlage">
	      <xsl:text>*Rechtsgrundlagen:*&#x0A;&#x0A;</xsl:text>
	    <xsl:for-each select="rechtsgrundlage">
	      <!-- Aufzählungszeichen &#x2022; weggelassen, da die Darstellung sauberer wirkt. -->
	      <xsl:apply-templates select="node()"/>
	      <xsl:value-of select="' +&#x0A;'"/>
	      </xsl:for-each>
	    </xsl:if>
	  <xsl:text>&#x0A;</xsl:text>
	  
	  <!-- tbd Spalte "Dienst": die Bedingungen müssen angepasst werden, sobald der Dienst-Bezug im Lite-Modell implementiert wurde.-->
			<xsl:variable name="nachrichtenName" select="concat(lite:prefix(.), ':', @name)"/>
			<xsl:variable name="dienst" select="//wsdlService[wsdlServiceMessage|wsdlServiceOutputMessage|wsdlServiceFaultMessage|wsdlServiceInputMessage=$nachrichtenName]/@name"/>

			<xsl:choose>
				<xsl:when test="$keinDienst"/>
				<xsl:when test="$dienst">
				  <xsl:text>|</xsl:text>
				  <xsl:value-of select="string-join($dienst, '&#x0A;&#x0A;')"/>
				</xsl:when>
				<xsl:otherwise>
				  <xsl:text>|</xsl:text>
				</xsl:otherwise>
			</xsl:choose>
	  	  
	  <!-- Bei Erzeugung des gesamten Dokuments wird ein interner Link erzeugt, beim Einzeldokument ein externer Link -->
	  <xsl:text>&#x0A;ifdef::volldokument[]&#x0A;</xsl:text>
	  <xsl:value-of select="concat(' |xref:#', lite:docbook-id(.),'[]&#x0A;')"/>
	  <xsl:text>endif::[]&#x0A;</xsl:text>
	  <xsl:text>ifndef::volldokument[]&#x0A;</xsl:text>
	  <xsl:value-of select="concat(' |xref:', lite:baustein-pfad(.),'.adoc[Link]&#x0A;')"/>
	  <xsl:text>endif::[]&#x0A;</xsl:text>
	  
	</xsl:template>

</xsl:stylesheet>
