<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:db="http://docbook.org/ns/docbook" xmlns:gc="http://docs.oasis-open.org/codelist/ns/genericode/1.0/" xmlns:log="http://www.xoev.de/de/xgenerator/framework/1/log" xmlns:xoev-cl-2="http://xoev.de/schemata/genericode/2" xmlns:xoev-cl-4="http://xoev.de/schemata/genericode/4" xmlns:lite="urn:xoev-de:kosit:xoev:lite:transformation_1.2.0" xmlns:lite-bib="urn:xoev-de:kosit:xoev:lite:schema:bibliothek_1.2.0" xmlns:lite-fm="urn:xoev-de:kosit:xoev:lite:schema:fachmodell_1.2.0" xmlns:xgen="http://www.xoev.de/de/xgenerator/framework/1/library" xmlns="http://docbook.org/ns/docbook" xpath-default-namespace="urn:xoev-de:kosit:xoev:lite:schema:fachmodell_1.2.0" version="2.0" exclude-result-prefixes="xgen xsl xs db gc log xoev-cl-2 xoev-cl-4 lite lite-fm lite-bib">

  <!-- Einstiegspunkt für die Generierung -->
  <xsl:template match="/" mode="lite:externe-modelle-und-inhalte-entry">
    <xsl:apply-templates select="xoev-fachmodell" mode="lite:externe-modelle-und-inhalte"/>
  </xsl:template>


  <!-- Erzeuge Datei-->
  <xsl:template match="xoev-fachmodell" mode="lite:externe-modelle-und-inhalte">

    <!-- Diese Variable verweisen auf den Ordner in dem ein Datei gespeichert werden soll -->
    <xsl:variable name="document-directory" select="'dokumente/anhang/externeModelle/externeModelle.adoc'" as="xs:string"/>

    <!-- Diese Variable enthält den Content einer zu erzeugenden Datei. -->
    <xsl:variable name="content">
      <xsl:apply-templates select="." mode="lite:externe-modelle-und-inhalte-content"/>
    </xsl:variable>

    <!-- Hier wird das Template zur Dateierzeugung aufgerufen -->
    <xsl:call-template name="xgen:result-document">
      <xsl:with-param name="local-path" select="xs:anyURI($document-directory)"/>
      <xsl:with-param name="method">text</xsl:with-param>
      <xsl:with-param name="content" select="$content"/>
    </xsl:call-template>
  </xsl:template>


  <!-- Erzeuge den gewünschten Content -->
  <xsl:template match="xoev-fachmodell" mode="lite:externe-modelle-und-inhalte-content">
    
    <xsl:text>= Eingebundene externe Modelle&#x0A;&#x0A;</xsl:text>

    <xsl:choose>
      <xsl:when test="not(//externesModell)">
        <xsl:text>Hinweis: In diesem Standard sind keine externen Modelle eingebunden.</xsl:text>
        <!-- Datei wird erzeugt, aber Einbindung bleibt dem Standard überlassen. -->
      </xsl:when>
      <xsl:otherwise>
        <xsl:text>Folgende externe Modelle werden in diesem Standard verwendet und sind auf den XÖV-Webseiten (siehe https://docs.xoev.de) oder im XRepository (siehe http://www.xrepository.de) veröffentlicht:&#x0A;&#x0A;</xsl:text>

        <xsl:for-each select="//externesModell">

          <xsl:variable name="genutzte-externe-inhalte" select="lite:genutzte-externe-inhalte-metadaten(.)"/>
          <xsl:variable name="Version-or-fassung" select="
              if ($genutzte-externe-inhalte[1]/@modell-kennung = 'urn:xoev-de:kosit:xoev:bibliothek:xoevbibliothek')
              then
                'Fassung:'
              else
                'Version:'"/>
          
          <xsl:choose>
            <xsl:when test="empty($genutzte-externe-inhalte)">
              <!-- Das externe Modell befindet sich im Ordner "externeModelle" und ist als Element "externesModell" in 
                  das Fachmodell eingetragen. Es werden jedoch keine Inhalte daraus verwendet. -->
                <xsl:variable name="externeKennung" select="@kennung"/>
                <xsl:variable name="externerNameKurz" select="$modelle[./*:xoev-fachmodell/*:metadaten.standard/*:kennung=$externeKennung]/*:xoev-fachmodell/*:metadaten.standard/*:nameKurz"/>      
              <xsl:value-of select="concat('== ', $externerNameKurz, '&#x0A;&#x0A;')"/>
              <xsl:text>Hinweis: Das Modell wird eingebunden aber nicht verwendet.&#x0A;&#x0A;</xsl:text>
            </xsl:when>
            <xsl:otherwise>
          

          <xsl:value-of select="concat('[id=', replace(concat('externes.modell.', @kennung, '_', @version), '[:\-]+', '_'), ']&#x0A;')"/>
          <xsl:value-of select="concat('== ', $genutzte-externe-inhalte[1]/@nameKurz, '&#x0A;&#x0A;')"/>

          <xsl:value-of select="concat('Kennung: ', $genutzte-externe-inhalte[1]/@modell-kennung, '; ', $Version-or-fassung, ' ', $genutzte-externe-inhalte[1]/@modell-version, '&#x0A;&#x0A;')"/>

          <xsl:text>Folgende Inhalte aus dem externen Modell werden in diesem Standard verwendet:&#x0A;&#x0A;</xsl:text>

          <xsl:text>[cols="1,1"]&#x0A;</xsl:text>
          <xsl:text>|===&#x0A;</xsl:text>
          <xsl:text>|Name|Namensraum&#x0A;&#x0A;</xsl:text>

          <xsl:for-each select="$genutzte-externe-inhalte">
            <xsl:sort select="substring-after(./@name, ':')"/>
            <xsl:value-of select="concat('|', @name, '|', @namespace, '&#x0A;')"/>

          </xsl:for-each>
          <xsl:text>|===&#x0A;&#x0A;</xsl:text>
              
            </xsl:otherwise>
          </xsl:choose>
              
        </xsl:for-each>
      </xsl:otherwise>
    </xsl:choose>

  </xsl:template>

</xsl:stylesheet>
