<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xd="http://www.oxygenxml.com/ns/doc/xsl" xmlns:db="http://docbook.org/ns/docbook" xmlns:gc="http://docs.oasis-open.org/codelist/ns/genericode/1.0/" xmlns:log="http://www.xoev.de/de/xgenerator/framework/1/log" xmlns:xoev-cl-2="http://xoev.de/schemata/genericode/2" xmlns:xoev-cl-4="http://xoev.de/schemata/genericode/4" xmlns:lite="urn:xoev-de:kosit:xoev:lite:transformation_1.2.0" xmlns:lite-bib="urn:xoev-de:kosit:xoev:lite:schema:bibliothek_1.2.0" xmlns:lite-fm="urn:xoev-de:kosit:xoev:lite:schema:fachmodell_1.2.0" xmlns:xgen="http://www.xoev.de/de/xgenerator/framework/1/library" xmlns="http://docbook.org/ns/docbook" xpath-default-namespace="urn:xoev-de:kosit:xoev:lite:schema:fachmodell_1.2.0" version="2.0" exclude-result-prefixes="xgen xsl xs db gc log xoev-cl-2 xoev-cl-4 lite lite-fm lite-bib">

  <xd:doc scope="stylesheet">
    <xd:desc>
      <xd:p>Dieses Stylesheet generiert einen vollständigen Abschnitt zu Codelisten mit Übersichtstabellen. Es wird im Rahmen des Feature Branches codelisten_uebersichtstabellenUndAbschnitte_appendix.xsl (siehe GitLab Issue #35) entwickelt.</xd:p>
    </xd:desc>
  </xd:doc>


  <xd:doc>
    <xd:desc>
      <xd:p>Einstiegspunkt für die Generierung</xd:p>
    </xd:desc>
  </xd:doc>
  <xsl:template match="/" mode="lite:codelistenuebersicht-entry">
    <xsl:apply-templates select="/" mode="lite:codelistenuebersicht"/>
  </xsl:template>

  <xd:doc>
    <xd:desc>
      <xd:p>Erzeuge Datei codelistenuebersicht.xml in dokumente/anhang/codelistenuebersicht</xd:p>
    </xd:desc>
  </xd:doc>
  <xsl:template match="/" mode="lite:codelistenuebersicht">
    <!-- Diese Variablen verweisen auf den Ordner in dem ein Datei gespeichert werden soll -->
    <xsl:variable name="document-directory" select="'dokumente/anhang/codelisten'" as="xs:string"/>


    <!-- Diese Variable enthält den Content einer zu erzeugenden Datei. -->
    <xsl:variable name="content">
      <xsl:apply-templates select="." mode="lite:codelistenuebersicht-content"/>
    </xsl:variable>


    <!-- Hier wird das Template zur Dateierzeugung aufgerufen -->
    <xsl:call-template name="xgen:result-document">
      <xsl:with-param name="local-path" select="xs:anyURI(concat($document-directory, '/codelistenGesamt.adoc'))"/>
      <xsl:with-param name="method">text</xsl:with-param>
      <xsl:with-param name="content" select="$content"/>
    </xsl:call-template>

  </xsl:template>

  <xd:doc>
    <xd:desc>
      <xd:p>Erzeuge den Content für einen vollständigen Abschnitt zu Codelisten mit Übersichtstabellen.</xd:p>
      <xd:p> Der Abschnitt besteht aus folgenden Unterabschnitten: <xd:ul>
          <xd:li>Übersichtstabelle mit Codelisten vom Einbindungstyp 3</xd:li>
          <xd:li>Übersichtstabelle mit Codelistenversionen vom Einbindungstyp 1 und 2</xd:li>
          <xd:li>Detailabschnitte mit den Inhalten der Codelistenversionen vom Einbindungstyp 1 und 2</xd:li>
        </xd:ul>
      </xd:p>
      <xd:p>Wenn der Standard eine der Codelistenkategorien nicht enthält, wird der entsprechende Unterabschnitt nicht erzeugt.</xd:p>
    </xd:desc>
  </xd:doc>
  <xsl:template match="." mode="lite:codelistenuebersicht-content">

    <!-- TODOs / zu klären
         - Spalten in Inhaltstabelle sortieren (erst Codes, dann Beschreibungen)?
         - Spaltenbreite klären (Problem u.a. Spalte Version in XBildung)
         -->

    <xsl:variable name="nameStandard" select="$xoev-modell/metadaten.standard/nameKurz"/>

    <!-- Sammeln der Codedatentypen für die beiden Übersichtslisten -->

    <xsl:variable name="codeDatentypen_3" select="//codeDatentyp[@kennung][not(@version)][not(@draft = 'true')]"/>
    <xsl:variable name="codeDatentypen_1_2" select="//codeDatentyp[@kennung][@version][not(@draft = 'true')]"/>

    <!-- Sammeln der Codelisten, die von CodeDatentypen eines externen Modells genutzt werden -->

    <xsl:variable name="nutztCodeliste_3" select="//nutztCodeliste[@kennung][not(@version)][not(@draft = 'true')]"/>
    <xsl:variable name="nutztCodeliste_1_2" select="//nutztCodeliste[@kennung][@version][not(@draft = 'true')]"/>


    <!-- [Gesamter Abschnitt] -->

    <xsl:text>[id=schluesseltabellen]&#x0A;</xsl:text>
    <xsl:text>= Codelisten&#x0A;&#x0A;</xsl:text>
    
    <xsl:text>ifndef::relfileprefix[]&#x0A;</xsl:text>
    <xsl:text>:relfileprefix: ../../&#x0A;</xsl:text>
    <xsl:text>endif::[]&#x0A;&#x0A;</xsl:text>

    <xsl:choose>
      <xsl:when test="empty($codeDatentypen_1_2) and empty($codeDatentypen_3)">

        <xsl:text>Hinweis: In diesem Standard werden keine Codelisten verwendet.&#x0A;&#x0A;</xsl:text>
        <!-- Datei wird erzeugt, aber Einbindung bleibt dem Standard überlassen. -->
      </xsl:when>
      <xsl:otherwise>

        <xsl:text>In diesem Abschnitt sind die in </xsl:text>
        <xsl:value-of select="$nameStandard"/>
        <xsl:text> verwendeten Codelisten und ihre Inhalte aufgeführt.&#x0A;&#x0A;</xsl:text>

        <!-- [Übersicht Codelisten (Typ 3)] -->

        <xsl:if test="not(empty($codeDatentypen_3 | $nutztCodeliste_3))">

          <xsl:text>[id=schluesseltabellen.uebersicht.codelisten]&#x0A;</xsl:text>
          <xsl:text>== Übersicht Codelisten (Typ 3)&#x0A;&#x0A;</xsl:text>

          <xsl:text>In der nachstehenden Tabelle werden die folgenden Informationen dargestellt:&#x0A;&#x0A;</xsl:text>

          <xsl:text>Kennung:: Die Kennungen aller in </xsl:text>
          <xsl:value-of select="$nameStandard"/>
          <xsl:text> über einen Code-Typ 3 genutzten Codelisten in alphabetischer Reihenfolge.footnote:no-entry-3[Sofern in der Spalte „Code-Datentyp(en)“ kein Eintrag vorhanden ist, bedeutet dies, dass der Standard die jeweilige Codeliste verwendet und dokumentieren möchte. Der die Codeliste nutzende Code-Datentyp ist jedoch nicht im Standard selbst spezifiziert, sondern in einem externen Modell.]&#x0A;</xsl:text>
          <xsl:text>Code-Datentyp(en):: Die die jeweilige Codeliste nutzenden Code-Datentypen.footnote:no-entry-3[]&#x0A;&#x0A;</xsl:text>

          <xsl:text>Die Kennungen stellen Links zur jeweiligen Codeliste im XRepository dar. Die Namen der Code-Datentypen stellen Links zu den jeweiligen Detail-Abschnitten dar.&#x0A;&#x0A;</xsl:text>

          <xsl:text>[id=codelisten-typ3-uebersichtstabelle]&#x0A;</xsl:text>
          <xsl:text>[cols="56%,44%"]&#x0A;</xsl:text>
          <xsl:text>|===&#x0A;</xsl:text>
          <xsl:text>|Kennung|Code-Datentyp(en)&#x0A;&#x0A;</xsl:text>

          <xsl:for-each-group select="$codeDatentypen_3 | $nutztCodeliste_3" group-by="@kennung">
            <xsl:sort select="@kennung"/>
            <!-- Gruppierschlüssel ist die Codelistenkennung. -->
            <xsl:value-of select="concat('|https://www.xrepository.de/details/', current-grouping-key(), '[', @kennung, ']')"/>
            <xsl:text>|</xsl:text>
            <!-- Innerhalb der Tabellenzelle ein oder mehrere Codedatentypen zur Codeliste -->
            
            <xsl:text>&#x0A;ifdef::volldokument[]&#x0A;</xsl:text>
            <xsl:for-each select="current-group()[self::codeDatentyp]">
              <xsl:value-of select="concat('xref:#', lite:docbook-id(.), '[', @name, '] +&#x0A;')"/>
            </xsl:for-each>
            <xsl:text>&#x0A;endif::[]&#x0A;</xsl:text>
            <xsl:text>ifndef::volldokument[]&#x0A;</xsl:text>
            <xsl:for-each select="current-group()[self::codeDatentyp]">
              <xsl:value-of select="concat('xref:', lite:baustein-pfad(.), '.adoc[', @name, '] +&#x0A;')"/>
            </xsl:for-each>
            <xsl:text>&#x0A;endif::[]&#x0A;</xsl:text>
            
          </xsl:for-each-group>
          <xsl:text>|===&#x0A;&#x0A;</xsl:text>
        </xsl:if>


        <!-- [Übersicht Codelistenversionen (Typ 1 und 2)] -->

        <xsl:if test="not(empty($codeDatentypen_1_2 | $nutztCodeliste_1_2))">

          <xsl:text>[id=schluesseltabellen.uebersicht.codelistenversionen]&#x0A;</xsl:text>
          <xsl:text>== Übersicht Codelistenversionen (Typ 1 und 2)&#x0A;&#x0A;</xsl:text>

          <xsl:text>In der nachstehenden Tabelle werden die folgenden Informationen dargestellt:&#x0A;&#x0A;</xsl:text>

          <xsl:text>Codeliste:: Alle in </xsl:text>
          <xsl:value-of select="$nameStandard"/>
          <xsl:text> genutzten Codelistenversionen in alphabetischer Reihenfolge, die in mindestens einem Code-Datentyp genutzt werden (Typ der Codelistennutzung 1 bis 2).footnote:no-entry-12[Sofern in der Spalte „Code-Datentyp(en)“ kein Eintrag vorhanden ist, bedeutet dies, dass der Standard die jeweilige Codeliste verwendet und dokumentieren möchte. Der die Codeliste nutzende Code-Datentyp ist jedoch nicht im Standard selbst spezifiziert, sondern in einem externen Modell.]&#x0A;</xsl:text>
          <xsl:text>Version:: Die Version der Codeliste.&#x0A;</xsl:text>
          <xsl:text>Code-Datentyp(en):: Die die jeweilige Codeliste nutzenden Code-Datentypen.footnote:no-entry-12[]&#x0A;&#x0A;</xsl:text>

          <xsl:text>Die Namen der Code-Datentypen und der Codelisten stellen Links zu den jeweiligen Detail-Abschnitten dar.&#x0A;&#x0A;</xsl:text>

          <xsl:text>[id=codelisten-uebersichtstabelle]&#x0A;</xsl:text>
          <xsl:text>[cols="46%,8%,46%"]&#x0A;</xsl:text>
          <xsl:text>|===&#x0A;</xsl:text>
          <xsl:text>|Codeliste|Version|Code-Datentyp(en)&#x0A;&#x0A;</xsl:text>

          <!-- Kurzname der Codeliste mit Link; es kommt vor, dass kein Kurzname vorhanden ist, dann wird eine Warnung ausgegeben -->
          <xsl:for-each-group select="$codeDatentypen_1_2 | $nutztCodeliste_1_2" group-by="@kennung">
            <xsl:sort select="lite:codeliste-nameKurz(lite:genutzte-cl-oder-vcl(.))"/>
            <xsl:text>|xref:#</xsl:text>
            <xsl:value-of select="replace(concat('tabelle.', @kennung), ':', '.')"/>
            <xsl:value-of select="
                if (empty(lite:codeliste-nameKurz(lite:genutzte-cl-oder-vcl(.)))) then
                  '[#Codeliste besitzt keinen Namen (kurz)#]'
                else
                  concat('[', lite:codeliste-nameKurz(lite:genutzte-cl-oder-vcl(.)), ']')"/>

            <!-- Version; zwecks Trennbarkeit werden breitenlose Leerzeichen eingefügt (einige Standards benutzen längere Versionsbezeichnungen) -->
            <xsl:text>|</xsl:text>
            <xsl:value-of select="replace(@version,'(.)',concat('$1',xgen:unescaped-xml('&amp;'), '#x200B;'))"/>
            <xsl:text>|</xsl:text>
            
            <xsl:text>&#x0A;ifdef::volldokument[]&#x0A;</xsl:text>
            <xsl:for-each select="current-group()[self::codeDatentyp]">
              <xsl:value-of select="concat('xref:#', lite:docbook-id(.), '[', @name, '] +&#x0A;')"/>
            </xsl:for-each>
            <xsl:text>&#x0A;endif::[]&#x0A;</xsl:text>
            <xsl:text>ifndef::volldokument[]&#x0A;</xsl:text>
            <xsl:for-each select="current-group()[self::codeDatentyp]">
              <xsl:value-of select="concat('xref:', lite:baustein-pfad(.), '.adoc[', @name, '] +&#x0A;')"/>
            </xsl:for-each>
            <xsl:text>&#x0A;endif::[]&#x0A;</xsl:text>
            
          </xsl:for-each-group>
          <xsl:text>|===&#x0A;&#x0A;</xsl:text>

          <!-- [Details zu den Codelisten]-->

          <xsl:if test="not(empty($gc-codelisten))">
            <xsl:text>[id=schluesseltabellen.details]&#x0A;</xsl:text>
            <xsl:text>== Details&#x0A;&#x0A;</xsl:text>

            <xsl:apply-templates select="$codeDatentypen_1_2 | $nutztCodeliste_1_2" mode="lite:codelistenuebersicht-detail">
              <xsl:sort select="lite:codeliste-nameKurz(lite:genutzte-cl-oder-vcl(.))"/>
            </xsl:apply-templates>

          </xsl:if>
        </xsl:if>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>


  <xd:doc>
    <xd:desc>
      <xd:p>Prüft, ob alle übergebenen Strings Zahlen darstellen. Dient hier zur Entscheidung, ob die Code-Spalte numerisch sortiert werden kann.</xd:p>
    </xd:desc>
    <xd:param name="strings">
      <xd:p>String-Sequenz, hier Inhalte der Code-Spalte</xd:p>
    </xd:param>
  </xd:doc>
  <xsl:function name="lite:is-integer-sequence" as="xs:boolean">
    <xsl:param name="strings" as="xs:string*"/>
    <xsl:sequence select="
        every $str in $strings
          satisfies number($str) = number($str) and not(contains($str, 'NaN'))"/>
  </xsl:function>

  <xd:doc>
    <xd:desc>
      <xd:p>Dieses Template erzeugt für jede Codeliste Typ 1 oder 2 einen Detail-Abschnitt mit Metadaten und Inhalten.</xd:p>
    </xd:desc>
  </xd:doc>
  <xsl:template match="codeDatentyp | nutztCodeliste" mode="lite:codelistenuebersicht-detail">
    
    <!-- Jeder Detail-Abschnitt zu einer Codeliste soll auf einer neuen Seite beginnen. -->
    <xsl:if test="position() &gt; 1">&#x0A;&#x0A;&lt;&lt;&lt;&#x0A;&#x0A;</xsl:if>
    
    <xsl:variable name="codeliste" select="lite:genutzte-cl-oder-vcl(.)"/>
    
    <xsl:value-of select="concat('[id=', replace(concat('tabelle.', @kennung), ':', '.'), ']&#x0A;')"/>
    
    <!-- Titel = Kurzname der Codeliste mit Link; es kommt vor, dass kein Kurzname vorhanden ist, dann wird eine Warnung ausgegeben -->
    <xsl:value-of select="if (empty(lite:codeliste-nameKurz($codeliste))) then '=== #Codeliste besitzt keinen Namen (kurz)# &#x0A;&#x0A;' else concat('=== ', lite:codeliste-nameKurz($codeliste), '&#x0A;&#x0A;')"/>

    <xsl:variable name="codespalte" select="lite:genutzte-code-spalte(., $codeliste)"/>
    <xsl:variable name="codewerte" select="
        for $zeile in lite:versioncodeliste-zeilen($codeliste)
        return
          (lite:versioncodeliste-zeile-spaltenwert($zeile, $codespalte))"/>
    <xsl:variable name="ist-numerisch" select="lite:is-integer-sequence($codewerte)"/>
    <xsl:apply-templates select="$codeliste" mode="lite:codelistenuebersicht-detail-metadaten"/>
    <xsl:apply-templates select="$codeliste" mode="lite:codelistenuebersicht-detail-inhalt">
      <xsl:with-param name="codespalte" select="$codespalte"/>
      <xsl:with-param name="numerische-codes" select="$ist-numerisch"/>
    </xsl:apply-templates>
  </xsl:template>

  <xd:doc>
    <xd:desc>
      <xd:p>Dieses Template erzeugt für jede Codeliste Typ 1 oder 2 einen Abschnitt mit Metadaten.</xd:p>
    </xd:desc>
  </xd:doc>
  <xsl:template match="element()" mode="lite:codelistenuebersicht-detail-metadaten">
    
    <xsl:text>==== Metadaten&#x0A;&#x0A;</xsl:text>
    <xsl:text>[cols="19%,81%"]&#x0A;</xsl:text>
    <xsl:text>|===&#x0A;</xsl:text>
    <xsl:text>|Metadatenelement|Wert&#x0A;&#x0A;</xsl:text> 
    <xsl:value-of select="concat('|Name (lang)|', lite:codeliste-nameLang(.), '&#x0A;')"/>
    <xsl:value-of select="concat('|Name (kurz)|', lite:codeliste-nameKurz(.), '&#x0A;')"/>
    <xsl:value-of select="concat('|Kennung|', lite:codeliste-kennung(.), '&#x0A;')"/>
    <xsl:if test="not(empty(lite:codeliste-beschreibung(.)))"> 
      <xsl:value-of select="concat('|Beschreibung der Codeliste|', lite:codeliste-beschreibung(.), '&#x0A;')"/> 
    </xsl:if>
    <xsl:if test="not(empty(lite:versioncodeliste-beschreibung(.)))"> 
      <xsl:value-of select="concat('|Beschreibung der Codelistenversion|', lite:versioncodeliste-beschreibung(.), '&#x0A;')"/> </xsl:if> 
    <xsl:value-of select="concat('|Herausgeber|', lite:codeliste-herausgebernameLang(.))"/>
    <xsl:if test="not(empty(lite:codeliste-herausgebernameKurz(.)))">
      <xsl:value-of select="concat(' (', lite:codeliste-herausgebernameKurz(.), ')')"/>
    </xsl:if>
    <xsl:text>&#x0A;</xsl:text>
    <xsl:value-of select="concat('|Version|', lite:versioncodeliste-version(.), '&#x0A;')"/>
    <xsl:variable name="gueltigAb" select="lite:versioncodeliste-datumGueltigkeitAb(.)"/>
    <xsl:if test="not(empty($gueltigAb))"> 
      <xsl:value-of select="concat('|Gültigkeit ab|', $gueltigAb, '&#x0A;')"/></xsl:if>
    <xsl:text>|===&#x0A;&#x0A;</xsl:text>
  </xsl:template>

  <xd:doc>
    <xd:desc>
      <xd:p>Dieses Template erzeugt für jede Codeliste Typ 1 oder 2 eine Tabelle der Codelisteneinträge.</xd:p>
    </xd:desc>
    <xd:param name="codespalte">
      <xd:p>Verwendete Codespalte, nach dieser soll sortiert werden.</xd:p>
    </xd:param>
    <xd:param name="numerische-codes">
      <xd:p>true, wenn alle Codes Zahlen darstellen, so dass numerisch sortiert werden kann.</xd:p>
    </xd:param>
  </xd:doc>
  <xsl:template match="element()" mode="lite:codelistenuebersicht-detail-inhalt">
    <xsl:param name="codespalte"/>
    <xsl:param name="numerische-codes"/>
    <xsl:text>==== Daten&#x0A;&#x0A;</xsl:text>
    <xsl:variable name="spalten" select="lite:versioncodeliste-spalten(.)"/>
    <xsl:variable name="spaltenzahl" select="count($spalten)" as="xs:integer"/>
    <!-- Spaltenbreiten in Abhängigkeit der Spaltenzahl -->
    <!-- Für mehrspaltige Codelisten, es wird ein choice mit colspecs für 2-7 Spalten verwendet -->
    <!-- Eine Variante zur Einbindung über ein Template, eine als Funktion -->
    <xsl:apply-templates select="." mode="codelistenuebersicht-colspec"/>
    <xsl:text>|===&#x0A;</xsl:text>
    <!-- Spaltenüberschriften (technischer Name und Langname, falls vorhanden) -->
    <xsl:for-each select="$spalten">
      <xsl:value-of select="concat('|', lite:versioncodeliste-spalte-spaltennameTechnisch(.))"/>
      <xsl:variable name="nameLang" select="lite:versioncodeliste-spalte-spaltennameLang(.)"/>
      <xsl:if test="exists($nameLang) and not(normalize-space($nameLang) = '')">
        <xsl:value-of select="concat(' (', $nameLang, ')')"/>
      </xsl:if>
    </xsl:for-each>
    <xsl:text>&#x0A;&#x0A;</xsl:text>
    <!-- Codewerte -->
    <xsl:for-each select="lite:versioncodeliste-zeilen(.)">
      <xsl:sort select="lite:versioncodeliste-zeile-spaltenwert(., $codespalte)" data-type="{if ($numerische-codes) then 'number' else 'text'}"/>
      <xsl:variable name="zeile" select="."/>
      <xsl:for-each select="$spalten"><xsl:value-of select="concat('|', lite:versioncodeliste-zeile-spaltenwert($zeile, lite:versioncodeliste-spalte-spaltennameTechnisch(.)))"/>
      </xsl:for-each>
      <xsl:text>&#x0A;</xsl:text>
    </xsl:for-each> 
    <xsl:text>|===&#x0A;&#x0A;</xsl:text>
  </xsl:template>

  <xd:doc>
    <xd:desc>
      <xd:p>Gib die Spaltendefinitionen für die Tabellen der Codelisten-Inhalte zurück.</xd:p>
      <xd:p>Es werden zwei bis sieben Spalten unterstützt, mehr sind bisher nicht vorgekommen.</xd:p>
      <xd:p>Die Spaltenbreiten werden als Prozentwerte gegeben, bei 7 Spalten als gleich breite Spalten.</xd:p>
      <xd:p>Diese Funktion ist eine Alternative zum Template mit mode="codelistenuebersicht-colspec"</xd:p>
    </xd:desc>
    <xd:param name="spaltenanzahl"/>
  </xd:doc>
  <xsl:function name="lite:codelist-colspecs" as="text()*">
    <xsl:param name="spaltenanzahl" as="xs:integer*"/>
    <xsl:sequence>
      <xsl:choose>
        <xsl:when test="$spaltenanzahl = 7">
          <xsl:text>[cols="7*"]&#x0A;</xsl:text>
        </xsl:when>
        <xsl:when test="$spaltenanzahl = 6">
          <xsl:text>[cols="15%,17%,17%,17%,17%,17%"]&#x0A;</xsl:text>
        </xsl:when>
        <xsl:when test="$spaltenanzahl = 5">
          <xsl:text>[cols="16%,21%,21%,21%,21%"]&#x0A;</xsl:text>
        </xsl:when>
        <xsl:when test="$spaltenanzahl = 4">
          <xsl:text>[cols="16%,28%,28%,28%"]&#x0A;</xsl:text>
        </xsl:when>
        <xsl:when test="$spaltenanzahl = 3">
          <xsl:text>[cols="15%,41%,44%"]&#x0A;</xsl:text>
        </xsl:when>
        <xsl:otherwise>
          <xsl:text>[cols="16%,84%"]&#x0A;</xsl:text>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:sequence>
  </xsl:function>

  <xd:doc>
    <xd:desc>
      <xd:p>Gib die Spaltendefinitionen für die Tabellen der Codelisten-Inhalte zurück.</xd:p>
      <xd:p>Es werden zwei bis sieben Spalten unterstützt, mehr sind bisher nicht vorgekommen.</xd:p>
      <xd:p>Die Spaltenbreiten werden als Prozentwerte gegeben, bei 7 Spalten als gleich breite Spalten.</xd:p>
      <xd:p>Dieses Template ist eine Alternative zur Funktion lite:codelist-colspecs</xd:p>
    </xd:desc>
  </xd:doc>
  <xsl:template match="element()" mode="codelistenuebersicht-colspec">
    <xsl:variable name="spaltenanzahl" select="count(lite:versioncodeliste-spalten(.))" as="xs:integer"/>

    <xsl:choose>
      <xsl:when test="$spaltenanzahl = 7">
        <xsl:text>[cols="7*"]&#x0A;</xsl:text>
        <!-- in mm (Gesamtbreite 160 mm): 22mm,23mm,23mm,23mm,23mm,23mm,23mm -->
      </xsl:when>
      <xsl:when test="$spaltenanzahl = 6">
        <xsl:text>[cols="15%,17%,17%,17%,17%,17%"]&#x0A;</xsl:text>
        <!-- in mm (Gesamtbreite 160 mm): 25mm,27mm,27mm,27mm,27mm,27mm -->
      </xsl:when>
      <xsl:when test="$spaltenanzahl = 5">
        <xsl:text>[cols="16%,21%,21%,21%,21%"]&#x0A;</xsl:text>
        <!-- in mm (Gesamtbreite 160 mm): 24mm,34mm,34mm,34mm,34mm -->
      </xsl:when>
      <xsl:when test="$spaltenanzahl = 4">
        <xsl:text>[cols="16%,28%,28%,28%"]&#x0A;</xsl:text>
        <!-- in mm (Gesamtbreite 160 mm): 25mm,45mm,45mm,45mm -->
      </xsl:when>
      <xsl:when test="$spaltenanzahl = 3">
        <xsl:text>[cols="15%,41%,44%"]&#x0A;</xsl:text>
        <!-- in mm (Gesamtbreite 160 mm): 25mm,65mm,70mm -->
      </xsl:when>
      <xsl:otherwise>
        <xsl:text>[cols="16%,84%"]&#x0A;</xsl:text>
        <!-- in mm (Gesamtbreite 160 mm): 25mm,135mm -->
      </xsl:otherwise>
    </xsl:choose>
    
  </xsl:template>
  
</xsl:stylesheet>
