<?xml version='1.0'?>
<xsl:stylesheet  
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:d="http://docbook.org/ns/docbook"	
	xmlns:fo="http://www.w3.org/1999/XSL/Format" version="1.0"
	xmlns:axf="http://www.antennahouse.com/names/XSL/Extensions">
	<!-- Für die Verwendung mit OxyGen -->
	<!-- <xsl:import href="docbook_custom.xsl"/> -->
	<!-- Für die Verwendung mit den Standardtemplates -->
	<!-- <xsl:import href="docbook.xsl"/> -->
	<!-- <xsl:import href="kosit_docbook.changes.xsl"/> -->
	<xsl:import href="../deltaxml-fo-ns/changebars.xsl"/>

	<!-- ******************************************************************
         Annotations
         ****************************************************************** -->
	
	<!-- Turn Oxygen XML annotations into change bars.
         Requires Antenna House, Apache FOPs silently ignores them.
         Only oxy_comment_start and oxy_comment_end are supported.
         Only the annotation content is rendered. Author and change date are omitted.
    -->
	
	<xsl:template match="processing-instruction('oxy_comment_start')">
		<fo:change-bar-begin change-bar-offset="2mm" change-bar-color="red" change-bar-style="solid" change-bar-placement="right">
			<xsl:attribute name="change-bar-class">CB<xsl:number/></xsl:attribute>
			<fo:float float="start">
				<fo:block-container width="2cm" absolute-position="absolute" left="16.4cm">
					<xsl:variable name="comment" select="substring-after(.,'comment')"/>
					<xsl:variable name="contents" select="substring($comment,3,string-length($comment) - 3)"/>
					
					<fo:block start-indent="0.2cm" font-size="9pt" background-color="yellow" axf:annotation-type="Text" axf:annotation-contents="{$contents}"
						axf:annotation-position-horizontal="-17.1cm"> 
						<xsl:value-of select="$contents"/>
					</fo:block>
				</fo:block-container>
			</fo:float>
		</fo:change-bar-begin>
	</xsl:template>
	
	<xsl:template match="processing-instruction('oxy_comment_end')">
		<fo:change-bar-end>
			<xsl:attribute name="change-bar-class">
				<xsl:text>CB</xsl:text>
				<xsl:for-each select="preceding::processing-instruction('oxy_comment_start')[1]">
					<xsl:number/> 
				</xsl:for-each>
			</xsl:attribute>
		</fo:change-bar-end>
	</xsl:template>
	
	<!-- modified copy from table.xsl: do not omit PI -->
	<xsl:template match="d:tbody">
		<xsl:variable name="tgroup" select="parent::*"/>
		
		<fo:table-body start-indent="0pt" end-indent="0pt">
			<xsl:choose>
				<!-- Use recursion if @morerows is used -->
				<xsl:when test="d:row/d:entry/@morerows|d:row/d:entrytbl/@morerows">
					<xsl:apply-templates select="d:row[1]|processing-instruction()">
						<xsl:with-param name="spans">
							<xsl:call-template name="blank.spans">
								<xsl:with-param name="cols" select="../@cols"/>
							</xsl:call-template>
						</xsl:with-param>
						<xsl:with-param name="browserows" select="'recurse'"/>
					</xsl:apply-templates>
				</xsl:when>
				<xsl:otherwise>
					<xsl:apply-templates select="d:row|processing-instruction()">
						<xsl:with-param name="spans">
							<xsl:call-template name="blank.spans">
								<xsl:with-param name="cols" select="../@cols"/>
							</xsl:call-template>
						</xsl:with-param>
						<xsl:with-param name="browserows" select="'loop'" />
					</xsl:apply-templates>
				</xsl:otherwise>
			</xsl:choose>
		</fo:table-body>
	</xsl:template>
</xsl:stylesheet>
