<?xml version='1.0'?>
<xsl:stylesheet  
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:d="http://docbook.org/ns/docbook"	
	xmlns:fo="http://www.w3.org/1999/XSL/Format" version="1.0">
	
	<xsl:import href="titlepage.templates.kosit.xsl"/>
	<xsl:import href="kosit.formatting.xsl"/>
	<xsl:import href="../custom/kosit.formatting.custom.xsl"/>
	<xsl:import href="../custom/titlepage.custom.xsl"/>
	
	<xsl:key name="id" match="*" use="@id|@xml:id"/>
	
	<xsl:param name="deprecated.background-color">#EEEEEE</xsl:param>
	
	<xsl:param name="logo">logo.png</xsl:param>
	<xsl:param name="chapter.logo.width" select="4"/>
	
	<!-- Bookmarks im PDF -->
	<xsl:param name="fop1.extensions">1</xsl:param>
	
	<!-- Kein Einzug nach Überschriften -->
	<xsl:param name="body.start.indent">0</xsl:param>
		
	<!-- deprecated -->
	<xsl:attribute-set name="section.properties">
		<xsl:attribute name="background-color">
			<xsl:choose>
				<xsl:when test="ancestor-or-self::*[key('id', @annotations)[@annotations='deprecated']]"><xsl:value-of select="$deprecated.background-color"/></xsl:when>
				<xsl:otherwise>inherit</xsl:otherwise>
			</xsl:choose>
		</xsl:attribute>
	</xsl:attribute-set>
	
	<!-- Tabellen -->
	<!-- 
		Unschön ist, dass hier das gesamte Template (aus table.xsl) überschrieben wird.
		Allerdings funktioniert apply-templates nicht mit named templates.
	-->
	<!-- Expand this template to add properties to any cell's block -->
	<xsl:template name="table.row.properties">
		<xsl:choose>
			<xsl:when test="ancestor::d:thead">
				<xsl:attribute name="background-color">#F6FFA3</xsl:attribute>
			</xsl:when>
			<xsl:when test="key('id', @annotations)[@annotations='deprecated']">
				<xsl:attribute name="background-color">
					<xsl:value-of select="$deprecated.background-color"/>
				</xsl:attribute>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	
	<!-- Sections nummeriert und xref verwendet die Nummern -->
	<xsl:param name="section.autolabel">1</xsl:param>
	<!-- Section haben die Nummern der Parents als Präfix (3.1.1 statt 1) -->
	<xsl:param name="section.label.includes.component.label">1</xsl:param>
	<xsl:param name="xref.with.number.and.title">1</xsl:param>
	
	<!-- URL of each ulink will NOT appear after the text of the link -->
	<xsl:param name="ulink.show" select="0"/>
	
	<!--  Verweise standardmäßig blau anzeigen; Rollenangabe für schwarze Verweise --> 
	<xsl:attribute-set name="xref.properties">
		<xsl:attribute name="color">
			<xsl:choose>
				<xsl:when test="@role='schwarz'">black</xsl:when>
				<xsl:otherwise>blue</xsl:otherwise>
			</xsl:choose>
		</xsl:attribute>
	</xsl:attribute-set>
	
	<!-- XMeld verweist auf informaltable, obwohl dies nicht vorgesehen ist. 
	     Die hier eingefügten Verweise erlauben einen Verweis auf die Seite aber nicht
	     auf einen Titel, da informaltable keinen Titel haben. --> 
	<xsl:template match="d:informaltable" mode="xref-to">
		<xsl:param name="referrer"/>
		<xsl:param name="xrefstyle"/>
		<xsl:param name="verbose" select="1"/>

		<!-- catch-all for things with (possibly optional) titles -->
		<xsl:apply-templates select="." mode="object.xref.markup">
			<xsl:with-param name="purpose" select="'xref'"/>
			<xsl:with-param name="xrefstyle" select="$xrefstyle"/>
			<xsl:with-param name="referrer" select="$referrer"/>
			<xsl:with-param name="verbose" select="$verbose"/>
		</xsl:apply-templates>
	</xsl:template>
	
	<!-- Die eingelesene Datei passt die Verweise an die bisherigen Werte des role-Attributs an 
	     und setzt andere Einträge für generierten Text -->
	<xsl:param name="local.l10n.xml" select="document('gentext.xml')"/>
		
	<!-- Templateaufruf für die Titelseite eines Parts	-->
	<xsl:template match="d:title" mode="part.titlepage.recto.auto.mode">
	  <xsl:call-template name="kositparttitlepage">
	     <xsl:with-param name="node" select="ancestor-or-self::d:part[1]"/>
	  </xsl:call-template>
	</xsl:template>
	
	<!-- Templateaufruf für die Titelseite der Einleitung (Preface)	-->
	<xsl:template match="d:title" mode="preface.titlepage.recto.auto.mode">
		<xsl:call-template name="kosittitlepage">
			<xsl:with-param name="node" select="ancestor-or-self::d:preface[1]"/>
		</xsl:call-template>
	</xsl:template>
	
	<!-- Templateaufruf für die Titelseite eines Kapitels	-->
	<xsl:template match="d:title" mode="chapter.titlepage.recto.auto.mode">
	  <xsl:call-template name="kosittitlepage">
	     <xsl:with-param name="node" select="ancestor-or-self::d:chapter[1]"/>
	  </xsl:call-template>
	</xsl:template>

    <!-- Templateaufruf für die Titelseite eines Anhangs	-->
	<xsl:template match="d:title" mode="appendix.titlepage.recto.auto.mode">
		<xsl:call-template name="kosittitlepage">
	     <xsl:with-param name="node" select="ancestor-or-self::d:appendix[1]"/>
	  </xsl:call-template>
	</xsl:template>
	
	<!-- Template für die Titelseite eines Artikels -->
	<xsl:template name="article.titlepage.recto">
		<xsl:call-template name="kositartikeltitlepage">
	     <xsl:with-param name="node" select="ancestor-or-self::d:article"/>
		</xsl:call-template>
		<xsl:choose>
			<xsl:when test="d:articleinfo/d:title">
				<xsl:apply-templates mode="article.titlepage.recto.auto.mode" select="d:articleinfo/d:title"/>
			</xsl:when>
			<xsl:when test="d:artheader/d:title">
				<xsl:apply-templates mode="article.titlepage.recto.auto.mode" select="d:artheader/d:title"/>
			</xsl:when>
			<xsl:when test="d:info/d:title">
				<xsl:apply-templates mode="article.titlepage.recto.auto.mode" select="d:info/d:title"/>
			</xsl:when>
			<xsl:when test="d:title">
				<xsl:apply-templates mode="article.titlepage.recto.auto.mode" select="d:title"/>
			</xsl:when>
		</xsl:choose>

		<xsl:choose>
			<xsl:when test="d:articleinfo/d:subtitle">
				<xsl:apply-templates mode="article.titlepage.recto.auto.mode" select="d:articleinfo/d:subtitle"/>
			</xsl:when>
			<xsl:when test="d:artheader/d:subtitle">
				<xsl:apply-templates mode="article.titlepage.recto.auto.mode" select="d:artheader/d:subtitle"/>
			</xsl:when>
			<xsl:when test="d:info/d:subtitle">
				<xsl:apply-templates mode="article.titlepage.recto.auto.mode" select="d:info/d:subtitle"/>
			</xsl:when>
			<xsl:when test="d:subtitle">
				<xsl:apply-templates mode="article.titlepage.recto.auto.mode" select="d:subtitle"/>
			</xsl:when>
		</xsl:choose>

		<xsl:apply-templates mode="article.titlepage.recto.auto.mode" select="d:info/d:pubdate"/>
		<xsl:apply-templates mode="article.titlepage.recto.auto.mode" select="d:articleinfo/d:pubdate"/>
		<xsl:apply-templates mode="article.titlepage.recto.auto.mode" select="d:artheader/d:pubdate"/>
		<xsl:apply-templates mode="article.titlepage.recto.auto.mode" select="d:articleinfo/d:corpauthor"/>
		<xsl:apply-templates mode="article.titlepage.recto.auto.mode" select="d:artheader/d:corpauthor"/>
		<xsl:apply-templates mode="article.titlepage.recto.auto.mode" select="d:info/d:corpauthor"/>
		<xsl:apply-templates mode="article.titlepage.recto.auto.mode" select="d:articleinfo/d:authorgroup"/>
		<xsl:apply-templates mode="article.titlepage.recto.auto.mode" select="d:artheader/d:authorgroup"/>
		<xsl:apply-templates mode="article.titlepage.recto.auto.mode" select="d:info/d:authorgroup"/>
		<xsl:apply-templates mode="article.titlepage.recto.auto.mode" select="d:articleinfo/d:author"/>
		<xsl:apply-templates mode="article.titlepage.recto.auto.mode" select="d:artheader/d:author"/>
		<xsl:apply-templates mode="article.titlepage.recto.auto.mode" select="d:info/d:author"/>
		<xsl:apply-templates mode="article.titlepage.recto.auto.mode" select="d:articleinfo/d:othercredit"/>
		<xsl:apply-templates mode="article.titlepage.recto.auto.mode" select="d:artheader/d:othercredit"/>
		<xsl:apply-templates mode="article.titlepage.recto.auto.mode" select="d:info/d:othercredit"/>
		<xsl:apply-templates mode="article.titlepage.recto.auto.mode" select="d:articleinfo/d:releaseinfo"/>
		<xsl:apply-templates mode="article.titlepage.recto.auto.mode" select="d:artheader/d:releaseinfo"/>
		<xsl:apply-templates mode="article.titlepage.recto.auto.mode" select="d:info/d:releaseinfo"/>
		<xsl:apply-templates mode="article.titlepage.recto.auto.mode" select="d:articleinfo/d:copyright"/>
		<xsl:apply-templates mode="article.titlepage.recto.auto.mode" select="d:artheader/d:copyright"/>
		<xsl:apply-templates mode="article.titlepage.recto.auto.mode" select="d:info/d:copyright"/>
		<xsl:apply-templates mode="article.titlepage.recto.auto.mode" select="d:articleinfo/d:legalnotice"/>
		<xsl:apply-templates mode="article.titlepage.recto.auto.mode" select="d:artheader/d:legalnotice"/>
		<xsl:apply-templates mode="article.titlepage.recto.auto.mode" select="d:info/d:legalnotice"/>
		<xsl:apply-templates mode="article.titlepage.recto.auto.mode" select="d:articleinfo/d:revision"/>
		<xsl:apply-templates mode="article.titlepage.recto.auto.mode" select="d:artheader/d:revision"/>
		<xsl:apply-templates mode="article.titlepage.recto.auto.mode" select="d:info/d:revision"/>
		<xsl:apply-templates mode="article.titlepage.recto.auto.mode" select="d:articleinfo/d:revhistory"/>
		<xsl:apply-templates mode="article.titlepage.recto.auto.mode" select="d:artheader/d:revhistory"/>
		<xsl:apply-templates mode="article.titlepage.recto.auto.mode" select="d:info/d:revhistory"/>
		<xsl:apply-templates mode="article.titlepage.recto.auto.mode" select="d:articleinfo/d:abstract"/>
		<xsl:apply-templates mode="article.titlepage.recto.auto.mode" select="d:artheader/d:abstract"/>
		<xsl:apply-templates mode="article.titlepage.recto.auto.mode" select="d:info/d:abstract"/>
	</xsl:template>

	<!-- reduce author font size -->
	<xsl:template match="d:author" mode="article.titlepage.recto.auto.mode">
		<fo:block xmlns:fo="http://www.w3.org/1999/XSL/Format" xsl:use-attribute-sets="article.titlepage.recto.style" space-before="0.5em" font-size="10.4pt">
			<xsl:apply-templates select="." mode="article.titlepage.recto.mode"/>
		</fo:block>
	</xsl:template>
	
	<!-- remove title from article abstract -->
	<xsl:template match="d:abstract" mode="titlepage.mode">
		<fo:block xsl:use-attribute-sets="abstract.properties">
			<fo:block xsl:use-attribute-sets="abstract.title.properties">
				<xsl:choose>
					<xsl:when test="d:title|d:info/d:title">
						<xsl:apply-templates select="d:title|d:info/d:title"/>
					</xsl:when>
					<!-- <xsl:otherwise>
						<xsl:call-template name="gentext">
							<xsl:with-param name="key" select="'Abstract'"/>
						</xsl:call-template>
					</xsl:otherwise> -->
				</xsl:choose>
			</fo:block>
			<xsl:apply-templates select="*[not(self::d:title)]" mode="titlepage.mode"/>
	</fo:block>
	</xsl:template>
	
	<!-- Template für die Titelseite eines Parts	-->
	<xsl:template name="kositparttitlepage">
	    <xsl:param name="node"/>
		<fo:table>
			<fo:table-column>
				<xsl:attribute name="column-width"><xsl:value-of select="16-$chapter.logo.width"/>cm</xsl:attribute>
			</fo:table-column>
			<fo:table-column>
				<xsl:attribute name="column-width"><xsl:value-of select="$chapter.logo.width"/>cm</xsl:attribute>
			</fo:table-column>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell display-align="center">
						<fo:block></fo:block>
					</fo:table-cell>
					<fo:table-cell display-align="center" text-align="right">
						<fo:block>
							<fo:external-graphic text-align="right" src="{$logo}" content-width="scale-to-fit">
								<xsl:attribute name="width"><xsl:value-of select="$chapter.logo.width"/>cm</xsl:attribute>
							</fo:external-graphic>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
		<fo:block-container width="100%" top="37.5mm" left="0mm" position="absolute">
		<!-- top="37.5mm" ergibt sich aus 9cm top aus BeispielfuerPartSeite.pdf - page.margin.inner (25.0mm) - page.margin.top (27.5mm) -->
		<fo:table>
			<fo:table-column/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell>
						<fo:block xmlns:fo="http://www.w3.org/1999/XSL/Format" text-align="center" xsl:use-attribute-sets="part.titlepage.recto.style">
							<xsl:variable name="ergebnis">
								<xsl:call-template name="component.title">
									<xsl:with-param name="node" select="$node"/>
								</xsl:call-template>
							</xsl:variable>
							<xsl:value-of select="$ergebnis"/>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
		</fo:block-container>
	</xsl:template>
	
	<!-- Template für den oberen Teil der Titelseite eines Artikels	-->
	<xsl:template name="kositartikeltitlepage">
	    <xsl:param name="node"/>
		<fo:table>
			<fo:table-column>
				<xsl:attribute name="column-width"><xsl:value-of select="16-$chapter.logo.width"/>cm</xsl:attribute>
			</fo:table-column>
			<fo:table-column>
				<xsl:attribute name="column-width"><xsl:value-of select="$chapter.logo.width"/>cm</xsl:attribute>
			</fo:table-column>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell display-align="center">
						<fo:block/>
					</fo:table-cell>
					<fo:table-cell display-align="center" text-align="right">
						<fo:block>
							<fo:external-graphic text-align="right" src="{$logo}" content-width="scale-to-fit">
								<xsl:attribute name="width"><xsl:value-of select="$chapter.logo.width"/>cm</xsl:attribute>
							</fo:external-graphic>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
				<fo:table-row>
					<fo:table-cell display-align="center" text-align="right">
					<fo:block></fo:block>
					<fo:block space-before="46pt"></fo:block>
					</fo:table-cell>
				</fo:table-row>
				<fo:table-row border-bottom="0.5pt solid black">
					<fo:table-cell display-align="center" text-align="right">
						<fo:block></fo:block>
					</fo:table-cell>
				</fo:table-row>
				<fo:table-row>
					<fo:table-cell display-align="center" text-align="right">
					<fo:block></fo:block>
					<fo:block space-before="46pt"></fo:block>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	
	<!-- Template für die Titelseite einer Einleitung (Preface)/eines Kapitels/Anhangs	-->
	<xsl:template name="kosittitlepage">
	    <xsl:param name="node"/>
		<!-- <xsl:apply-templates mode="chapter.titlepage.recto.auto.mode"/> -->
		<fo:table>
			<fo:table-column>
				<xsl:attribute name="column-width"><xsl:value-of select="16-$chapter.logo.width"/>cm</xsl:attribute>
			</fo:table-column>
			<fo:table-column>
				<xsl:attribute name="column-width"><xsl:value-of select="$chapter.logo.width"/>cm</xsl:attribute>
			</fo:table-column>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell display-align="center">
						<fo:block xmlns:fo="http://www.w3.org/1999/XSL/Format" xsl:use-attribute-sets="chapter.titlepage.recto.style">
							<xsl:call-template name="component.title">
								<xsl:with-param name="node" select="$node"/>
							</xsl:call-template>
							<!-- <xsl:value-of select="." /> -->
						</fo:block>
					</fo:table-cell>
					<fo:table-cell display-align="center" text-align="right">
						<fo:block>
							<fo:external-graphic text-align="right" src="{$logo}" content-width="scale-to-fit">
								<xsl:attribute name="width"><xsl:value-of select="$chapter.logo.width"/>cm</xsl:attribute>
							</fo:external-graphic>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
				<fo:table-row>
					<fo:table-cell display-align="center" text-align="right">
					<fo:block></fo:block>
					<fo:block space-before="46pt"></fo:block>
					</fo:table-cell>
				</fo:table-row>
				<fo:table-row border-bottom="0.5pt solid black">
					<fo:table-cell display-align="center" text-align="right">
						<fo:block></fo:block>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	
	<!-- Initial page number -->
	<xsl:template name="initial.page.number">
		<xsl:param name="element" select="local-name(.)"/>
		<xsl:param name="master-reference" select="''"/>
		
		<!-- Select the first content that the stylesheet places
       after the TOC -->
		<xsl:variable name="first.book.content" 
			select="ancestor::d:book/*[
			not(self::d:title or
			self::d:subtitle or
			self::d:titleabbrev or
			self::d:bookinfo or
			self::d:info or
			self::d:dedication or
			self::d:acknowledgements or
			self::d:toc or
			self::d:lot)][1]"/>
		<xsl:choose>
			<!-- double-sided output -->
			<xsl:when test="$double.sided != 0">
				<xsl:choose>
					<xsl:when test="$element = 'toc'">auto-odd</xsl:when>
					<xsl:when test="$element = 'book'">auto-odd</xsl:when>
					<!-- preface typically continues TOC roman numerals -->
					<!-- Change page.number.format if not -->
					<!-- <xsl:when test="$element = 'preface'">auto-odd</xsl:when> -->
					<xsl:when test="($element = 'dedication' or $element = 'article') 
						and not(preceding::d:chapter
						or preceding::d:preface
						or preceding::d:appendix
						or preceding::d:article
						or preceding::d:dedication
						or parent::d:part
						or parent::d:reference)">auto-odd</xsl:when>
					<xsl:when test="generate-id($first.book.content) =
						generate-id(.)">1</xsl:when>
					<xsl:otherwise>auto-odd</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			
			<!-- single-sided output -->
			<xsl:otherwise>
				<xsl:choose>
					<xsl:when test="$element = 'toc'">auto</xsl:when>
					<xsl:when test="$element = 'book'">auto</xsl:when>
					<!-- <xsl:when test="$element = 'preface'">auto</xsl:when> -->
					<xsl:when test="($element = 'dedication' or $element = 'article') and
						not(preceding::d:chapter
						or preceding::d:preface
						or preceding::d:appendix
						or preceding::d:article
						or preceding::d:dedication
						or parent::d:part
						or parent::d:reference)">auto</xsl:when>
					<xsl:when test="generate-id($first.book.content) =
						generate-id(.)">1</xsl:when>
					<xsl:otherwise>auto</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<!-- Page number format -->
	<xsl:template name="page.number.format">
		<xsl:param name="element" select="local-name(.)"/>
		<xsl:param name="master-reference" select="''"/>
		
		<xsl:choose>
			<xsl:when test="$element = 'toc'">i</xsl:when>
		</xsl:choose>
	</xsl:template>
	
	<!-- Revision History, see http://www.sagehill.net/docbookxsl/FormatRevhistory.html#d0e49869 -->
	<xsl:attribute-set name="revhistory.title.properties">
		<xsl:attribute name="font-size">12pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="text-align">center</xsl:attribute>
	</xsl:attribute-set>
	
	<xsl:attribute-set name="revhistory.table.properties">
		<xsl:attribute name="border">0.5pt solid black</xsl:attribute>
		<xsl:attribute name="background-color">#EEEEEE</xsl:attribute>
		<xsl:attribute name="width">100%</xsl:attribute>
	</xsl:attribute-set>
	
	<xsl:attribute-set name="revhistory.table.cell.properties">
		<xsl:attribute name="border">0.5pt solid black</xsl:attribute>
		<xsl:attribute name="font-size">9pt</xsl:attribute>
		<xsl:attribute name="padding">4pt</xsl:attribute>
	</xsl:attribute-set>
	
	<!-- Tabellen standardmäßig linksbündig -->
	<xsl:attribute-set name="formal.object.properties">
		<xsl:attribute name="text-align">left</xsl:attribute>
	</xsl:attribute-set>
	
	<!-- Hard page break -->
	<xsl:template match="processing-instruction('KoSIT-FO')[normalize-space(.)='hard-pagebreak']">
		<fo:block break-after='page'/>
	</xsl:template>
	
	<!-- Variable list -->
	<!-- Term-Eintrag über dem entry -->
	<xsl:param name="variablelist.as.blocks">1</xsl:param>
	
	<!-- Display variable list terms as bold -->
	<xsl:attribute-set name="variablelist.term.properties">
		<xsl:attribute name="font-weight">bold</xsl:attribute>
	</xsl:attribute-set>
	
	<!-- admonitions: no graphics -->
	<xsl:param name="admon.graphics">0</xsl:param>
	
	<!-- admonitions: no text labels -->
	<xsl:param name="admon.textlabel" select="0"></xsl:param>
	
	<!-- important-Block -->
	<xsl:attribute-set name="admonition.title.properties">
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="text-align">center</xsl:attribute>
	</xsl:attribute-set>
	
	<xsl:template name="nongraphical.admonition">
		<xsl:variable name="id">
			<xsl:call-template name="object.id"/>
		</xsl:variable>
		
		<fo:block space-before.minimum="0.8em"
            space-before.optimum="1em"
            space-before.maximum="1.2em"
            start-indent="0.25in"
            end-indent="0.25in"
            border-top="0.5pt solid black"
            border-bottom="0.5pt solid black"
            padding-top="4pt"
            padding-bottom="4pt"
            id="{$id}">
			<xsl:if test="$admon.textlabel != 0 or d:title">
				<fo:block keep-with-next='always' xsl:use-attribute-sets="admonition.title.properties">
					<xsl:apply-templates select="." mode="object.title.markup"/>
				</fo:block>
			</xsl:if>
			
			<fo:block xsl:use-attribute-sets="admonition.properties">
				<xsl:apply-templates/>
			</fo:block>
		</fo:block>
	</xsl:template>
	
	<!-- Index -->
	<!-- <xsl:param name="generate.index" select="1"></xsl:param> -->
	
	<!-- Section innerhalb von Preface nicht nummerieren -->
	<xsl:template match="d:preface/d:section" mode="object.title.markup">
		<xsl:apply-templates select="." mode="title.markup"/>
	</xsl:template>
	
	<!-- TOC: Section innerhalb von Preface nicht nummerieren -->
    <xsl:template name="toc.line">
      <xsl:param name="toc-context" select="NOTANODE"/>
    
      <xsl:variable name="id">
        <xsl:call-template name="object.id"/>
      </xsl:variable>
    
      <xsl:variable name="label">
	    <xsl:choose>
          <xsl:when test="ancestor::d:preface">
          </xsl:when>
          <xsl:otherwise>
            <xsl:apply-templates select="." mode="label.markup"/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
    
      <fo:block xsl:use-attribute-sets="toc.line.properties" text-align-last="justify" text-align="justify">
        <fo:inline keep-with-next.within-line="always">
          <fo:basic-link internal-destination="{$id}">
		    <xsl:if test="$label != ''">
              <xsl:copy-of select="$label"/>
              <xsl:value-of select="$autotoc.label.separator"/>
            </xsl:if>
            <xsl:apply-templates select="." mode="titleabbrev.markup"/>
          </fo:basic-link>
        </fo:inline>
        <fo:inline keep-together.within-line="always">
          <xsl:text> </xsl:text>
          <fo:leader leader-pattern="dots"
                     leader-pattern-width="3pt"
                     leader-alignment="reference-area"
                     keep-with-next.within-line="always"/>
          <xsl:text> </xsl:text> 
          <fo:basic-link internal-destination="{$id}">
            <fo:page-number-citation ref-id="{$id}"/>
          </fo:basic-link>
        </fo:inline>
      </fo:block>
    </xsl:template>
	
	<!-- Hyphenation within Table Cells -->
	<!-- <xsl:param name="hyphenate">true</xsl:param> -->
	<xsl:param name="ulink.hyphenate.chars">.@:</xsl:param>
	<!-- zero-width space -->
	<xsl:param name="ulink.hyphenate">&#x200B;</xsl:param>
	<xsl:template match="d:entry//text()">
		<xsl:call-template name="hyphenate-url">
			<xsl:with-param name="url" select="."/>
		</xsl:call-template>
	</xsl:template>
	
	<!-- Split too long lines of program listings -->
	<xsl:attribute-set name="monospace.verbatim.properties" use-attribute-sets="verbatim.properties monospace.properties">
		<xsl:attribute name="wrap-option">wrap</xsl:attribute>
	</xsl:attribute-set>
	
	<!-- Labels for chapter and appendix are prefixed with the label of the part element that contains them -->
	<xsl:param name="component.label.includes.part.label" select="1"/>
	
	<!-- Numbering of components is re-started within each part -->
	<xsl:param name="label.from.part" select="1"/>
	
	<!-- No extra page between cover and chapter -->
	<xsl:template name="book.titlepage.separator"/>
	
	<!-- Width of the label (number) in an ordered list (default value: 1.0em) -->
	<!-- needed for double-digit spacing -->
	<xsl:param name="orderedlist.label.width">1.5em</xsl:param>
	
	<!-- Reduce space between list items -->
	<xsl:attribute-set name="list.item.spacing">
		<xsl:attribute name="space-before.optimum">0.2em</xsl:attribute>
		<xsl:attribute name="space-before.minimum">0.2em</xsl:attribute>
		<xsl:attribute name="space-before.maximum">0.2em</xsl:attribute>
	</xsl:attribute-set>
	
	<!-- emphasis roles 'codebf', 'rot', 'gruen' added -->
	<xsl:template match="d:emphasis">
		<xsl:variable name="depth">
			<xsl:call-template name="dot.count">
				<xsl:with-param name="string">
					<xsl:number level="multiple"/>
				</xsl:with-param>
			</xsl:call-template>
		</xsl:variable>
		
		<xsl:choose>
			<xsl:when test="@role='bold' or @role='strong'">
				<xsl:call-template name="inline.boldseq"/>
			</xsl:when>
			<xsl:when test="@role='underline'">
				<fo:inline text-decoration="underline">
					<xsl:call-template name="inline.charseq"/>
				</fo:inline>
			</xsl:when>
			<xsl:when test="@role='strikethrough'">
				<fo:inline text-decoration="line-through">
					<xsl:call-template name="inline.charseq"/>
				</fo:inline>
			</xsl:when>
			<xsl:when test="@role='codebf'">
				<xsl:call-template name="inline.boldmonoseq"/>
			</xsl:when>
			<xsl:when test="@role='rot'">
				<fo:inline color="red">
					<xsl:call-template name="inline.charseq"/>
				</fo:inline>
			</xsl:when>
			<xsl:when test="@role='gruen'">
				<fo:inline color="green">
					<xsl:call-template name="inline.charseq"/>
				</fo:inline>
			</xsl:when>
		    <xsl:when test="@role='normal'">
		        <fo:inline font-style="normal">
		            <xsl:apply-templates/>
		        </fo:inline>
		    </xsl:when>
			<xsl:otherwise>
				<xsl:choose>
					<xsl:when test="$depth mod 2 = 1">
						<fo:inline font-style="normal">
							<xsl:apply-templates/>
						</fo:inline>
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="inline.italicseq"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<!-- toc: punctuation after last digit removed -->
	<xsl:param name="autotoc.label.separator" select="' '"></xsl:param>
	
	<!-- Schriftgroesse Tabellentext gemaess Styleguide auf 9,0 pt gesetzt -->
	<xsl:template name="table.cell.block.properties">
		<!-- highlight this entry? -->
		<xsl:attribute name="font-size">9pt</xsl:attribute>
		<xsl:choose>
			<xsl:when test="ancestor::d:thead or ancestor::d:tfoot">
				<xsl:attribute name="font-weight">bold</xsl:attribute>
			</xsl:when>
			<!-- Make row headers bold too -->
			<xsl:when test="ancestor::d:tbody and 
                    (ancestor::d:table[@rowheader = 'firstcol'] or
                    ancestor::d:informaltable[@rowheader = 'firstcol']) and
                    ancestor-or-self::d:entry[1][count(preceding-sibling::d:entry) = 0]">
				<xsl:attribute name="font-weight">bold</xsl:attribute>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	
	<!-- Folgende Anpassung wird fuer den Umbruch von Kapitelreferenzen in generierten Tabellen benoetigt -->
	<xsl:template match="*" mode="intralabel.punctuation">
		<xsl:text>.&#x200B;</xsl:text>
	</xsl:template>
	
	<!-- force new chapters to start on an odd page -->
	<xsl:param name="double.sided">1</xsl:param>
	
	<!-- no headers and footers on blank pages -->
	<xsl:param name="headers.on.blank.pages" select="0"></xsl:param>
	<xsl:param name="footers.on.blank.pages" select="0"></xsl:param>
	
	<xsl:template name="fop1-document-information">
		<xsl:variable name="authors" select="(//d:author | //d:editor | //d:corpauthor | //d:authorgroup)[1]"/>
		
		<xsl:variable name="title">
			<xsl:apply-templates select="/*[1]" mode="label.markup"/>
			<xsl:apply-templates select="/*[1]" mode="title.markup"/>
			<xsl:variable name="subtitle">
				<xsl:apply-templates select="/*[1]" mode="subtitle.markup"/>
			</xsl:variable>
			<xsl:if test="$subtitle != ''">
				<xsl:text> - </xsl:text>
				<xsl:value-of select="$subtitle"/>
			</xsl:if>
		</xsl:variable>
		
		<fo:declarations>
			<x:xmpmeta xmlns:x="adobe:ns:meta/">
				<rdf:RDF xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#">
					<rdf:Description rdf:about="" xmlns:dc="http://purl.org/dc/elements/1.1/">
						<!-- Dublin Core properties go here -->
						
						<!-- Title -->
						<dc:title>
							<xsl:value-of select="normalize-space($title)"/>
						</dc:title>
						
						<!-- Author -->
						<dc:creator>
							<xsl:text>Koordinierungsstelle für IT-Standards (KoSIT)</xsl:text>
						</dc:creator>
						
						<!-- Subject -->
						<xsl:if test="//d:subjectterm">
							<dc:description>
								<xsl:for-each select="//d:subjectterm">
									<xsl:value-of select="normalize-space(.)"/>
									<xsl:if test="position() != last()">
										<xsl:text>, </xsl:text>
									</xsl:if>
								</xsl:for-each>
							</dc:description>
						</xsl:if>
					</rdf:Description>
					
					<rdf:Description rdf:about="" xmlns:xmp="http://ns.adobe.com/xap/1.0/">
						<xmp:CreatorTool></xmp:CreatorTool>
					</rdf:Description>
				</rdf:RDF>
			</x:xmpmeta>
		</fo:declarations>
	</xsl:template>
	
</xsl:stylesheet>
