<?xml version='1.0'?>
<xsl:stylesheet  
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:d="http://docbook.org/ns/docbook"	
	xmlns:fo="http://www.w3.org/1999/XSL/Format" version="1.0">
	
	<!-- Footer -->
	<xsl:template name="footer.content">
		<xsl:param name="pageclass" select="''"/>
		<xsl:param name="sequence" select="''"/>
		<xsl:param name="position" select="''"/>
		<xsl:param name="gentext-key" select="''"/>
		
		<fo:block>
			<xsl:choose>
				<!-- no footer on title pages -->
				
				<!-- Page with a list of titles, including book table of contents -->
				<!-- Index -->
				<!-- left:empty; center:"© Koordinierungsstelle für IT-Standards, Bremen"; right:empty -->
				<xsl:when test="($pageclass = 'lot' or $pageclass = 'index') and $position='right'">
					Koordinierungsstelle für IT-Standards
				</xsl:when>
				
				<!-- Front matter pages, main content pages, back matter pages -->
				<!-- TODO: display book revision -->
				<!-- left:title of the current chapter; center:"© Koordinierungsstelle für IT-Standards, Bremen"; right:book revision -->
				<xsl:when test="($pageclass = 'front' or $pageclass = 'body' or $pageclass = 'back') and $position='center'">

					<fo:block><xsl:apply-templates select="." mode="title.markup"/></fo:block>
				</xsl:when>
				<xsl:when test="($pageclass = 'front' or $pageclass = 'body' or $pageclass = 'back') and $position='right'">
					Koordinierungsstelle für IT-Standards
				</xsl:when>
			</xsl:choose>
		</fo:block>
	</xsl:template>
	
	<xsl:param name="toc.section.depth">1</xsl:param>
    
</xsl:stylesheet>