/*
 * Decompiled with CFR 0.152.
 */
package de.xoev.xgenerator.xpathfunctions;

import com.thaiopensource.relaxng.jaxp.XMLSyntaxSchemaFactory;
import com.thaiopensource.validation.Schema2;
import com.thaiopensource.validation.ValidatorHandler2;
import java.io.IOException;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.xml.parsers.SAXParserFactory;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.ExtensionFunctionCall;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.AnyURIValue;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class RelaxNGIsValid
extends ExtensionFunctionDefinition {
    private SAXParserFactory parserFactory;
    private Pattern entityReplacement = Pattern.compile("&(.*?);");
    private static XMLSyntaxSchemaFactory xmlSyntaxSchemaFactory = new XMLSyntaxSchemaFactory();
    ThreadLocal<XMLReader> xmlReader = new ThreadLocal();
    private Map<String, Schema2> schemas = new HashMap<String, Schema2>();

    public RelaxNGIsValid() {
        this.parserFactory = SAXParserFactory.newInstance();
        this.parserFactory.setValidating(false);
        this.parserFactory.setNamespaceAware(true);
    }

    public StructuredQName getFunctionQName() {
        return new StructuredQName("xgen", "http://www.xoev.de/de/xgenerator/framework/1/library", "relaxng-instance-errors");
    }

    public SequenceType getResultType(SequenceType[] suppliedArgumentTypes) {
        return SequenceType.STRING_SEQUENCE;
    }

    public SequenceType[] getArgumentTypes() {
        return new SequenceType[]{SequenceType.makeSequenceType((ItemType)BuiltInAtomicType.ANY_URI, (int)16384), SequenceType.SINGLE_STRING};
    }

    public boolean hasSideEffects() {
        return false;
    }

    private synchronized XMLReader getReaderFor(String uri) throws MalformedURLException, SAXException {
        Schema2 schema = this.schemas.get(uri);
        if (schema == null) {
            schema = xmlSyntaxSchemaFactory.newSchema(new URL(uri));
            this.schemas.put(uri, schema);
        }
        if (this.xmlReader.get() == null) {
            XMLReader r = XMLReaderFactory.createXMLReader();
            this.xmlReader.set(r);
        }
        ValidatorHandler2 handler = schema.newValidatorHandler();
        this.xmlReader.get().setContentHandler(handler);
        return this.xmlReader.get();
    }

    public ExtensionFunctionCall makeCallExpression() {
        return new ExtensionFunctionCall(){

            public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
                try {
                    AnyURIValue rngUri = (AnyURIValue)arguments[0].head();
                    StringValue text = (StringValue)arguments[1].head();
                    XMLReader r = RelaxNGIsValid.this.getReaderFor(rngUri.getStringValue());
                    r.parse(new InputSource(new StringReader(RelaxNGIsValid.this.entityReplacement.matcher(text.getStringValue()).replaceAll("$1"))));
                    return new SequenceExtent((Item[])new StringValue[0]);
                }
                catch (SAXParseException e) {
                    return new StringValue((CharSequence)e.getLocalizedMessage());
                }
                catch (SAXException e) {
                    return new StringValue((CharSequence)e.getLocalizedMessage());
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
                catch (IOException e) {
                    return new StringValue((CharSequence)e.getLocalizedMessage());
                }
            }
        };
    }
}

