/*
 * Decompiled with CFR 0.152.
 */
package socket;

import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Random;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.ParserAdapter;
import org.xml.sax.helpers.ParserFactory;
import org.xml.sax.helpers.XMLReaderFactory;

public class DelayedInput
extends DefaultHandler {
    protected static final String NAMESPACES_FEATURE_ID = "http://xml.org/sax/features/namespaces";
    protected static final String VALIDATION_FEATURE_ID = "http://xml.org/sax/features/validation";
    protected static final String SCHEMA_VALIDATION_FEATURE_ID = "http://apache.org/xml/features/validation/schema";
    protected static final String SCHEMA_FULL_CHECKING_FEATURE_ID = "http://apache.org/xml/features/validation/schema-full-checking";
    protected static final String DEFAULT_PARSER_NAME = "org.apache.xerces.parsers.SAXParser";
    protected static final boolean DEFAULT_NAMESPACES = true;
    protected static final boolean DEFAULT_VALIDATION = false;
    protected static final boolean DEFAULT_SCHEMA_VALIDATION = false;
    protected static final boolean DEFAULT_SCHEMA_FULL_CHECKING = false;
    protected PrintWriter fOut;

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        System.out.println("(" + string3);
        int n = attributes != null ? attributes.getLength() : 0;
        int n2 = 0;
        while (n2 < n) {
            System.out.println("A" + attributes.getQName(n2) + ' ' + attributes.getValue(n2));
            ++n2;
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        System.out.println(")" + string3);
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        this.printError("Warning", sAXParseException);
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        this.printError("Error", sAXParseException);
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        this.printError("Fatal Error", sAXParseException);
        throw sAXParseException;
    }

    protected void printError(String string, SAXParseException sAXParseException) {
        System.err.print("[");
        System.err.print(string);
        System.err.print("] ");
        String string2 = sAXParseException.getSystemId();
        if (string2 != null) {
            int n = string2.lastIndexOf(47);
            if (n != -1) {
                string2 = string2.substring(n + 1);
            }
            System.err.print(string2);
        }
        System.err.print(':');
        System.err.print(sAXParseException.getLineNumber());
        System.err.print(':');
        System.err.print(sAXParseException.getColumnNumber());
        System.err.print(": ");
        System.err.print(sAXParseException.getMessage());
        System.err.println();
        System.err.flush();
    }

    /*
     * Unable to fully structure code
     */
    public static void main(String[] var0) {
        if (var0.length == 0) {
            DelayedInput.printUsage();
            System.exit(1);
        }
        var1_1 = new DelayedInput();
        var2_2 = null;
        var3_3 = true;
        var4_4 = false;
        var5_5 = false;
        var6_6 = false;
        var7_7 = 0;
        while (var7_7 < var0.length) {
            block34: {
                var8_8 = var0[var7_7];
                if (!var8_8.startsWith("-")) ** GOTO lbl-1000
                var9_9 = var8_8.substring(1);
                if (var9_9.equals("p")) {
                    if (++var7_7 == var0.length) {
                        System.err.println("error: Missing argument to -p option.");
                    }
                    var10_16 = var0[var7_7];
                    try {
                        var2_2 = XMLReaderFactory.createXMLReader((String)var10_16);
                    }
                    catch (Exception var11_18) {
                        try {
                            var12_19 = ParserFactory.makeParser((String)var10_16);
                            var2_2 = new ParserAdapter(var12_19);
                            System.err.println("warning: Features and properties not supported on SAX1 parsers.");
                        }
                        catch (Exception var12_20) {
                            var2_2 = null;
                            System.err.println("error: Unable to instantiate parser (org.apache.xerces.parsers.SAXParser)");
                        }
                    }
                } else if (var9_9.equalsIgnoreCase("n")) {
                    var3_3 = var9_9.equals("n");
                } else if (var9_9.equalsIgnoreCase("v")) {
                    var4_4 = var9_9.equals("v");
                } else if (var9_9.equalsIgnoreCase("s")) {
                    var5_5 = var9_9.equals("s");
                } else if (var9_9.equalsIgnoreCase("f")) {
                    var6_6 = var9_9.equals("f");
                } else if (var9_9.equals("h")) {
                    DelayedInput.printUsage();
                } else lbl-1000:
                // 2 sources

                {
                    if (var2_2 == null) {
                        try {
                            var2_2 = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
                        }
                        catch (Exception var9_10) {
                            System.err.println("error: Unable to instantiate parser (org.apache.xerces.parsers.SAXParser)");
                            break block34;
                        }
                    }
                    try {
                        var2_2.setFeature("http://xml.org/sax/features/namespaces", var3_3);
                    }
                    catch (SAXException var9_11) {
                        System.err.println("warning: Parser does not support feature (http://xml.org/sax/features/namespaces)");
                    }
                    try {
                        var2_2.setFeature("http://xml.org/sax/features/validation", var4_4);
                    }
                    catch (SAXException var9_12) {
                        System.err.println("warning: Parser does not support feature (http://xml.org/sax/features/validation)");
                    }
                    try {
                        var2_2.setFeature("http://apache.org/xml/features/validation/schema", var5_5);
                    }
                    catch (SAXException var9_13) {
                        System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/validation/schema)");
                    }
                    try {
                        var2_2.setFeature("http://apache.org/xml/features/validation/schema-full-checking", var6_6);
                    }
                    catch (SAXException var9_14) {
                        System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/validation/schema-full-checking)");
                    }
                    var2_2.setContentHandler(var1_1);
                    var2_2.setErrorHandler(var1_1);
                    try {
                        System.out.println("# filename: " + var8_8);
                        var9_9 = new DelayedInputStream(new FileInputStream(var8_8));
                        var10_16 = new InputSource((InputStream)var9_9);
                        var10_16.setSystemId(var8_8);
                        var2_2.parse((InputSource)var10_16);
                    }
                    catch (SAXParseException var9_15) {
                    }
                    catch (Exception var10_17) {
                        System.err.println("error: Parse error occurred - " + var10_17.getMessage());
                        if (var10_17 instanceof SAXException) {
                            var10_16 = ((SAXException)var10_17).getException();
                        }
                        var10_16.printStackTrace(System.err);
                    }
                }
            }
            ++var7_7;
        }
    }

    private static void printUsage() {
        System.err.println("usage: java socket.DelayedInput (options) filename ...");
        System.err.println();
        System.err.println("options:");
        System.err.println("  -p name  Select parser by name.");
        System.err.println("  -n | -N  Turn on/off namespace processing.");
        System.err.println("  -v | -V  Turn on/off validation.");
        System.err.println("  -s | -S  Turn on/off Schema validation support.");
        System.err.println("           NOTE: Not supported by all parsers.");
        System.err.println("  -f  | -F Turn on/off Schema full checking.");
        System.err.println("           NOTE: Requires use of -s and not supported by all parsers.");
        System.err.println("  -h       This help screen.");
        System.err.println();
        System.err.println("defaults:");
        System.err.println("  Parser:     org.apache.xerces.parsers.SAXParser");
        System.err.print("  Namespaces: ");
        System.err.println("on");
        System.err.print("  Validation: ");
        System.err.println("off");
        System.err.print("  Schema:     ");
        System.err.println("off");
        System.err.print("  Schema full checking:     ");
        System.err.println("off");
    }

    static class DelayedInputStream
    extends FilterInputStream {
        private Random fRandom = new Random(System.currentTimeMillis());

        public DelayedInputStream(InputStream inputStream) {
            super(inputStream);
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (n2 > 48) {
                n2 = 48;
            }
            int n3 = 0;
            long l = System.currentTimeMillis();
            n3 = this.in.read(byArray, n, n2);
            try {
                Thread.sleep(Math.abs(this.fRandom.nextInt()) % 2000);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace(System.err);
            }
            long l2 = System.currentTimeMillis();
            System.out.print("read " + n3 + " bytes in " + (l2 - l) + " ms: ");
            this.printBuffer(byArray, n, n3);
            System.out.println();
            return n3;
        }

        private void printBuffer(byte[] byArray, int n, int n2) {
            if (n2 <= 0) {
                System.out.print("no data read");
                return;
            }
            System.out.print('[');
            int n3 = 0;
            while (n3 < n2) {
                switch ((char)byArray[n + n3]) {
                    case '\r': {
                        System.out.print("\\r");
                        break;
                    }
                    case '\n': {
                        System.out.print("\\n");
                        break;
                    }
                    default: {
                        System.out.print((char)byArray[n + n3]);
                    }
                }
                ++n3;
            }
            System.out.print(']');
        }
    }
}

