/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.script;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.apache.batik.script.Interpreter;
import org.apache.batik.script.InterpreterFactory;
import org.apache.batik.util.Service;
import org.w3c.dom.Document;

public class InterpreterPool {
    public static final String BIND_NAME_DOCUMENT = "document";
    protected static Map defaultFactories = new HashMap(7);
    protected Map factories = new HashMap(7);
    static /* synthetic */ Class class$org$apache$batik$script$InterpreterFactory;

    public InterpreterPool() {
        this.factories.putAll(defaultFactories);
    }

    public Interpreter createInterpreter(Document document, String string) {
        InterpreterFactory interpreterFactory = (InterpreterFactory)this.factories.get(string);
        if (interpreterFactory == null) {
            return null;
        }
        Interpreter interpreter = null;
        SVGOMDocument sVGOMDocument = (SVGOMDocument)document;
        try {
            URL uRL = new URL(sVGOMDocument.getDocumentURI());
            interpreter = interpreterFactory.createInterpreter(uRL, sVGOMDocument.isSVG12());
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (interpreter == null) {
            return null;
        }
        if (document != null) {
            interpreter.bindObject(BIND_NAME_DOCUMENT, document);
        }
        return interpreter;
    }

    public void putInterpreterFactory(String string, InterpreterFactory interpreterFactory) {
        this.factories.put(string, interpreterFactory);
    }

    public void removeInterpreterFactory(String string) {
        this.factories.remove(string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Iterator iterator = Service.providers(class$org$apache$batik$script$InterpreterFactory == null ? (class$org$apache$batik$script$InterpreterFactory = InterpreterPool.class$("org.apache.batik.script.InterpreterFactory")) : class$org$apache$batik$script$InterpreterFactory);
        while (iterator.hasNext()) {
            InterpreterFactory interpreterFactory = null;
            interpreterFactory = (InterpreterFactory)iterator.next();
            String[] stringArray = interpreterFactory.getMimeTypes();
            for (int i = 0; i < stringArray.length; ++i) {
                defaultFactories.put(stringArray[i], interpreterFactory);
            }
        }
    }
}

