<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xmi="http://www.omg.org/spec/XMI/20131001" xmlns:xgen="http://www.xoev.de/de/xgenerator/framework/1/library" xmlns:xoev="urn:xoev-de:kosit:xoev:classic:transformation_4.2.0" xmlns:uml="http://www.eclipse.org/uml2/5.0.0/UML" xmlns:xd="http://www.oxygenxml.com/ns/doc/xsl" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns="urn:xoev-de:kosit:xoev:lite:schema:fachmodell_1.2.0" xmlns:lite-bib="urn:xoev-de:kosit:xoev:lite:schema:bibliothek_1.2.0" xmlns:db="http://docbook.org/ns/docbook" xmlns:html="http://www.w3.org/1999/xhtml" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:xoev-profil="urn:xoev-de:kosit:xoev:classic:access-layer:xoev-profil_4.2.0" xmlns:xoev-wsdl="urn:xoev-de:kosit:xoev:classic:access-layer:osci-transport-profil_4.2.0" version="3.0" exclude-result-prefixes="xsl xmi xgen xoev xoev-profil uml xd xs xoev-wsdl">

  <xsl:variable name="prefix" select="
      if ($xoev:my-xmodel[xoev-profil:xoevBibliothek(.)]) then
        'lite-bib:'
      else
        ''"/>

  <xsl:template match="/" mode="xoev:default">
    <xsl:call-template name="xgen:result-document">
      <xsl:with-param name="local-path" select="xs:anyURI(concat($xoev:my-xmodel/(xoev-profil:xoevStandard(.), xoev-profil:xoevBibliothek(.))/@nameTechnisch, '.xml'))"/>
      <xsl:with-param name="content">
        <xsl:apply-templates select="$xoev:my-xmodel[xoev-profil:xoevBibliothek(.)]" mode="xoev:xoev-bibliothek"/>
        <xsl:apply-templates select="$xoev:my-xmodel[xoev-profil:xoevStandard(.)]" mode="xoev:xoev-fachmodell"/>
      </xsl:with-param>
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="element()" mode="xoev:xoev-bibliothek">
    <lite-bib:xoev-bibliothek xsi:schemaLocation="urn:xoev-de:kosit:xoev:lite:schema:bibliothek_1.2.0 http://xoev.de/schemata/lite/1.2.0/xoev-lite.bibliothek.xsd http://docbook.org/ns/docbook https://docbook.org/xml/5.0/xsd/docbook.xsd">
      <xsl:apply-templates select="." mode="xoev:xoev-BibliothekType"/>
    </lite-bib:xoev-bibliothek>
  </xsl:template>

  <xsl:template match="element()" mode="xoev:xoev-fachmodell">
    <xoev-fachmodell xsi:schemaLocation="urn:xoev-de:kosit:xoev:lite:schema:fachmodell_1.2.0 http://xoev.de/schemata/lite/1.2.0/xoev-lite.fachmodell.xsd http://docbook.org/ns/docbook https://docbook.org/xml/5.0/xsd/docbook.xsd">
      <xsl:apply-templates select="." mode="xoev:xoev-FachmodellType"/>
    </xoev-fachmodell>
  </xsl:template>

  <xsl:template match="element()" mode="xoev:xoev-BibliothekType">
    <xsl:apply-templates select="." mode="xoev:konfiguration.xoev-fachmodell"/>
    <xsl:apply-templates select="." mode="xoev:metadaten.bibliothek"/>
    <xsl:apply-templates select="." mode="xoev:metadaten.versionBibliothek"/>
    <xsl:apply-templates select="
        $uml:root-model/packagedElement[@name = 'Codelisten']/descendant::packagedElement[
        xoev-profil:xoevSonderfallGenutzteCodeliste(.) or xoev-profil:xoevSonderfallGenutzteVersionCodeliste(.)]" mode="xoev:nutztCodeliste">
      <xsl:sort select="(., xoev:dependencies-by-client(.)/uml:resolve-supplier(.))/@kennung"/>
    </xsl:apply-templates>
    <xsl:apply-templates select="child::packagedElement[uml:is-Package(.)]" mode="xoev:paketstruktur">
      <xsl:sort select="@name"/>
    </xsl:apply-templates>
  </xsl:template>

  <xsl:template match="element()" mode="xoev:xoev-FachmodellType">
    <xsl:apply-templates select="." mode="xoev:konfiguration.xoev-fachmodell"/>
    <xsl:apply-templates select="." mode="xoev:metadaten.standard"/>
    <xsl:apply-templates select="." mode="xoev:metadaten.versionStandard"/>
    <xsl:apply-templates select="$uml:root-model/descendant::packagedElement[(xoev-profil:xoevStandard(.) or xoev-profil:xoevBibliothek(.)) and @xmi:id != $xoev:my-xmodel/@xmi:id]" mode="xoev:externesModell">
      <xsl:sort select="xoev-profil:xoevStandard(.)/@kennung"/>
    </xsl:apply-templates>
    <xsl:apply-templates select="
        $uml:root-model/packagedElement[@name = 'Codelisten']/descendant::packagedElement[
        xoev-profil:xoevSonderfallGenutzteCodeliste(.) or xoev-profil:xoevSonderfallGenutzteVersionCodeliste(.)]" mode="xoev:nutztCodeliste">
      <xsl:sort select="(., xoev:dependencies-by-client(.)/uml:resolve-supplier(.))/@kennung"/>
    </xsl:apply-templates>
    <xsl:apply-templates select="child::packagedElement[uml:is-Package(.)]" mode="xoev:paketstruktur">
      <xsl:sort select="@name"/>
    </xsl:apply-templates>
  </xsl:template>

  <xsl:template match="element()" mode="xoev:konfiguration.xoev-fachmodell">
    <konfiguration.xoev-fachmodell>
      <xsl:apply-templates select="xoev-profil:xsdXModel(.)" mode="xoev:Konfiguration.XOEV-FachmodellType.xsdXModel"/>
      <xsl:apply-templates select="xoev-wsdl:wsdlKonfiguration(.)" mode="xoev:Konfiguration.XOEV-FachmodellType.wsdlKonfiguration"/>
    </konfiguration.xoev-fachmodell>
  </xsl:template>

  <xsl:template match="element()" mode="xoev:Konfiguration.XOEV-FachmodellType.xsdXModel">
    <xsl:apply-templates select="@fassungVom" mode="xoev:attribute-to-element"/>
    <xsl:apply-templates select="@namespace" mode="xoev:attribute-to-element"/>
    <xsl:apply-templates select="@prefix" mode="xoev:attribute-to-element"/>
    <xsl:apply-templates select="@schemaLocationBase" mode="xoev:attribute-to-element"/>
    <xsl:apply-templates select="@elementFormDefault" mode="xoev:attribute-to-element"/>
    <xsl:apply-templates select="@standardeinstellungEigenschaften" mode="xoev:attribute-to-element"/>
    <xsl:apply-templates select="@xsdGlobalElementNamePrefix" mode="xoev:attribute-to-element"/>
    <xsl:apply-templates select="@xsdGlobalElementNameSuffix" mode="xoev:attribute-to-element"/>
    <xsl:apply-templates select="@xsdNamedTypeNamePrefix" mode="xoev:attribute-to-element"/>
    <xsl:apply-templates select="@xsdNamedTypeNameSuffix" mode="xoev:attribute-to-element"/>
    <!-- Sobald die Grundkonfiguration für Code-Datentypen ebenfalls in Classic umgesetzt, die vier Attribute hier aufnehmen. -->
  </xsl:template>

  <xsl:template match="element()" mode="xoev:Konfiguration.XOEV-FachmodellType.wsdlKonfiguration">
    <xsl:for-each select="@StandardaufbauNamensraum">
      <wsdlStandardaufbauNamensraum>
        <xsl:value-of select="."/>
      </wsdlStandardaufbauNamensraum>
    </xsl:for-each>
    <xsl:for-each select="@StandardaufbauSubjectOperation">
      <wsdlStandardaufbauSubjectOperation>
        <xsl:value-of select="."/>
      </wsdlStandardaufbauSubjectOperation>
    </xsl:for-each>
    <xsl:for-each select="@Dateipraefix">
      <wsdlDateipraefix>
        <xsl:value-of select="."/>
      </wsdlDateipraefix>
    </xsl:for-each>
  </xsl:template>

  <xsl:template match="element()" mode="xoev:metadaten.bibliothek">
    <lite-bib:metadaten.bibliothek>
      <xsl:apply-templates select="xoev-profil:xoevBibliothek(.)" mode="xoev:Metadaten.BibliothekType"/>
    </lite-bib:metadaten.bibliothek>
  </xsl:template>

  <xsl:template match="element()" mode="xoev:Metadaten.BibliothekType">
    <xsl:apply-templates select="@nameLang" mode="xoev:attribute-to-element">
      <xsl:with-param name="prefix">lite-bib</xsl:with-param>
    </xsl:apply-templates>
    <xsl:apply-templates select="@nameKurz" mode="xoev:attribute-to-element">
      <xsl:with-param name="prefix">lite-bib</xsl:with-param>
    </xsl:apply-templates>
    <xsl:apply-templates select="@nameTechnisch" mode="xoev:attribute-to-element">
      <xsl:with-param name="prefix">lite-bib</xsl:with-param>
    </xsl:apply-templates>
    <xsl:apply-templates select="@kennung" mode="xoev:attribute-to-element">
      <xsl:with-param name="prefix">lite-bib</xsl:with-param>
    </xsl:apply-templates>
    <xsl:apply-templates select="@beschreibung" mode="xoev:attribute-to-element">
      <xsl:with-param name="prefix">lite-bib</xsl:with-param>
    </xsl:apply-templates>
    <xsl:apply-templates select="@herausgebernameLang" mode="xoev:attribute-to-element">
      <xsl:with-param name="prefix">lite-bib</xsl:with-param>
    </xsl:apply-templates>
    <xsl:apply-templates select="@herausgebernameKurz" mode="xoev:attribute-to-element">
      <xsl:with-param name="prefix">lite-bib</xsl:with-param>
    </xsl:apply-templates>
    <xsl:apply-templates select="@externeWebsite" mode="xoev:attribute-to-element">
      <xsl:with-param name="prefix">lite-bib</xsl:with-param>
    </xsl:apply-templates>
  </xsl:template>

  <xsl:template match="element()" mode="xoev:metadaten.versionBibliothek">
    <lite-bib:metadaten.versionBibliothek>
      <xsl:apply-templates select="xoev-profil:xoevVersionBibliothek(.)" mode="xoev:Metadaten.VersionBibliothekType"/>
    </lite-bib:metadaten.versionBibliothek>
  </xsl:template>

  <xsl:template match="element()" mode="xoev:Metadaten.VersionBibliothekType">
    <xsl:apply-templates select="@version" mode="xoev:attribute-to-element">
      <xsl:with-param name="prefix">lite-bib</xsl:with-param>
    </xsl:apply-templates>
    <xsl:apply-templates select="@beschreibung" mode="xoev:attribute-to-element">
      <xsl:with-param name="prefix">lite-bib</xsl:with-param>
    </xsl:apply-templates>
    <xsl:apply-templates select="@versionXOEVProduktionsumgebung" mode="xoev:attribute-to-element">
      <xsl:with-param name="prefix">lite-bib</xsl:with-param>
    </xsl:apply-templates>
    <xsl:apply-templates select="@lizenz" mode="xoev:attribute-to-element">
      <xsl:with-param name="prefix">lite-bib</xsl:with-param>
    </xsl:apply-templates>
    <xsl:apply-templates select="@bezugsort" mode="xoev:attribute-to-element">
      <xsl:with-param name="prefix">lite-bib</xsl:with-param>
    </xsl:apply-templates>
    <xsl:apply-templates select="@aenderungZurVorversion" mode="xoev:attribute-to-element">
      <xsl:with-param name="prefix">lite-bib</xsl:with-param>
    </xsl:apply-templates>
  </xsl:template>

  <xsl:template match="element()" mode="xoev:metadaten.standard">
    <metadaten.standard>
      <xsl:apply-templates select="xoev-profil:xoevStandard(.)" mode="xoev:Metadaten.StandardType"/>
    </metadaten.standard>
  </xsl:template>

  <xsl:template match="element()" mode="xoev:Metadaten.StandardType">
    <xsl:apply-templates select="@nameLang" mode="xoev:attribute-to-element"/>
    <xsl:apply-templates select="@nameKurz" mode="xoev:attribute-to-element"/>
    <xsl:apply-templates select="@nameTechnisch" mode="xoev:attribute-to-element"/>
    <xsl:apply-templates select="@kennung" mode="xoev:attribute-to-element"/>
    <xsl:apply-templates select="@beschreibung" mode="xoev:attribute-to-element"/>
  </xsl:template>

  <xsl:template match="element()" mode="xoev:metadaten.versionStandard">
    <metadaten.versionStandard>
      <xsl:apply-templates select="xoev-profil:xoevVersionStandard(.)" mode="xoev:Metadaten.VersionStandardType"/>
    </metadaten.versionStandard>
  </xsl:template>

  <xsl:template match="element()" mode="xoev:Metadaten.VersionStandardType">
    <xsl:apply-templates select="@version" mode="xoev:attribute-to-element"/>
    <xsl:apply-templates select="@beschreibung" mode="xoev:attribute-to-element"/>
    <xsl:apply-templates select="@versionXOEVHandbuch" mode="xoev:attribute-to-element"/>
    <xsl:apply-templates select="@versionXOEVProduktionsumgebung" mode="xoev:attribute-to-element"/>
    <xsl:apply-templates select="@nameModellierungswerkzeug" mode="xoev:attribute-to-element"/>
    <xsl:apply-templates select="@versionModellierungswerkzeug" mode="xoev:attribute-to-element"/>
  </xsl:template>

  <xsl:template match="element()" mode="xoev:externesModell">
    <externesModell>
      <xsl:apply-templates select="." mode="xoev:ExternesModellType"/>
    </externesModell>
  </xsl:template>

  <xsl:template match="element()" mode="xoev:ExternesModellType">
    <xsl:apply-templates select="(xoev-profil:xoevBibliothek(.), xoev-profil:xoevStandard(.))/@kennung" mode="xoev:attribute-to-attribute"/>
    <xsl:apply-templates select="(xoev-profil:xoevVersionBibliothek(.), xoev-profil:xoevVersionStandard(.))/@version" mode="xoev:attribute-to-attribute"/>
  </xsl:template>

  <xsl:template match="element()" mode="xoev:nutztCodeliste">
    <nutztCodeliste>
      <xsl:apply-templates select="." mode="xoev:NutztCodelisteType"/>
    </nutztCodeliste>
  </xsl:template>

  <xsl:template match="element()" mode="xoev:NutztCodelisteType">
    <xsl:attribute name="kennung">
      <xsl:value-of select="(., xoev:dependencies-by-client(.)/uml:resolve-supplier(.))/xoev-profil:xoevCodeliste(.)/@kennung"/>
    </xsl:attribute>
    <xsl:for-each select="xoev-profil:xoevVersionCodeliste(.)/@version">
      <xsl:attribute name="version">
        <xsl:value-of select="."/>
      </xsl:attribute>
    </xsl:for-each>
  </xsl:template>

  <xsl:template match="element()" mode="xoev:paketstruktur">
    <xsl:apply-templates select=".[xoev-profil:xsdSchema(.)]" mode="xoev:xsdSchema"/>
    <xsl:apply-templates select=".[not(xoev-profil:xsdSchema(.))]" mode="xoev:paket"/>
  </xsl:template>

  <xsl:template match="element()" mode="xoev:xsdSchema">
    <xsl:element name="xsdSchema">
      <xsl:apply-templates select="." mode="xoev:xsdSchemaType"/>
    </xsl:element>
  </xsl:template>

  <xsl:template match="element()" mode="xoev:xsdSchemaType">
    <xsl:apply-templates select="." mode="xoev:bezeichnungUndStatus"/>
    <xsl:apply-templates select="xoev-profil:xsdSchema(.)" mode="xoev:konfiguration.xsdSchema"/>
    <xsl:apply-templates select="." mode="xoev:dokumentation"/>
    <xsl:apply-templates select="." mode="xoev:nutztSchema"/>
    <xsl:apply-templates select="." mode="xoev:baustein"/>
    <xsl:for-each select="child::packagedElement[uml:is-Package(.)]">
      <xsl:sort select="@name"/>
      <xsl:element name="paket">
        <xsl:apply-templates select="." mode="xoev:PaketInSchemaType"/>
      </xsl:element>
    </xsl:for-each>
    <xsl:apply-templates select="ownedRule, packagedElement[xoev-profil:schRuleSet(.)]/ownedRule" mode="xoev:geschaeftsregel">
      <xsl:sort select="@name"/>
    </xsl:apply-templates>
  </xsl:template>

  <xsl:template match="element()" mode="xoev:bezeichnungUndStatus">
    <xsl:apply-templates select="@name" mode="xoev:attribute-to-attribute"/>
    <xsl:for-each select="xoev-profil:xsdTitled(.)/@title[not(. = '')]">
      <xsl:attribute name="titel">
        <xsl:value-of select="."/>
      </xsl:attribute>
    </xsl:for-each>
    <xsl:for-each select="xoev-profil:xsdDraft(.)">
      <xsl:attribute name="draft">true</xsl:attribute>
    </xsl:for-each>
  </xsl:template>

  <xsl:template match="element()" mode="xoev:konfiguration.xsdSchema">
    <xsl:apply-templates select="@namespace" mode="xoev:attribute-to-attribute"/>
    <xsl:apply-templates select="@prefix" mode="xoev:attribute-to-attribute"/>
    <xsl:apply-templates select="@schemaFile" mode="xoev:attribute-to-attribute"/>
    <xsl:apply-templates select="@schemaLocation" mode="xoev:attribute-to-attribute"/>
    <xsl:apply-templates select="@version" mode="xoev:attribute-to-attribute"/>
    <xsl:apply-templates select="@elementFormDefault[. != 'default']" mode="xoev:attribute-to-attribute"/>
  </xsl:template>

  <xsl:function name="xoev:unescaped-xml-without-entities" as="xs:string">
    <xsl:param name="string" as="xs:string"/>
    <xsl:value-of select="translate($string, '&lt;&gt;', '&#xE801;&#xE802;')"/>
  </xsl:function>

  <xsl:template match="element()" mode="xoev:dokumentation">
    <xsl:apply-templates select="." mode="xoev:beschreibung"/>
    <xsl:for-each select="xoev-profil:xsdWithImplementationHint(.)/@implementationHint[not(. = '')]">
      <umsetzungshinweis>
        <xsl:value-of select="xoev:unescaped-xml-without-entities(replace(replace(., '&lt;([^/!]{1})', '&lt;db:$1'), '&lt;/', '&lt;/db:'))"/>
      </umsetzungshinweis>
    </xsl:for-each>
  </xsl:template>

  <xsl:template match="element()" mode="xoev:beschreibung">
    <xsl:variable name="inhalte" as="element()*">
      <xsl:variable name="dokumentiert" as="xs:boolean" select="empty(ownedComment/body[xoev:clean-text(.) = '[nd]'])"/>
      <xsl:variable name="eigene-beschreibung" as="element()*" select="ownedComment/body[xoev:clean-text(.) != '']"/>
      <xsl:if test="$dokumentiert">
        <xsl:choose>
          <xsl:when test="not(empty($eigene-beschreibung))">
            <xsl:sequence select="$eigene-beschreibung"/>
          </xsl:when>
          <xsl:when test="uml:is-Property(.) and not(uml:resolve-type(.)[xoev:isReferenceableByName(.) or xoev-profil:xsdGlobalElement(.) or xoev-profil:xsdGlobalAttribute(.)])">
            <xsl:variable name="typ" select="uml:resolve-type(.)"/>
            <xsl:variable name="typ-dokumentiert" as="xs:boolean" select="empty($typ/ownedComment/body[xoev:clean-text(.) = '[nd]'])"/>
            <xsl:sequence select="$typ/ownedComment/body[xoev:clean-text(.) != '']"/>
          </xsl:when>
        </xsl:choose>
      </xsl:if>
    </xsl:variable>
    <xsl:for-each select="$inhalte">
      <beschreibung>
        <xsl:apply-templates select="." mode="xoev:BeschreibungType"/>
      </beschreibung>
    </xsl:for-each>
  </xsl:template>

  <xsl:template match="element()" mode="xoev:beschreibung.html">
    <xsl:for-each select="ownedComment/body[xoev:clean-text(.) != '']">
      <beschreibung>
        <xsl:apply-templates select="." mode="xoev:Beschreibung.HTMLType"/>
      </beschreibung>
    </xsl:for-each>
  </xsl:template>

  <xsl:template match="element()" mode="xoev:BeschreibungType">
    <xsl:value-of select="xoev:unescaped-xml-without-entities(replace(replace(., '&lt;([^/!:\s]+?([\s\r\n/]+?[.\s\S]*?)?>)', '&lt;db:$1'), '&lt;/([^:]*?>)', '&lt;/db:$1'))"/>
  </xsl:template>

  <xsl:template match="element()" mode="xoev:Beschreibung.HTMLType">
    <xsl:value-of select="xoev:unescaped-xml-without-entities(replace(replace(., '&lt;([^/!:\s]+?([\s\r\n/]+?[.\s\S]*?)?>)', '&lt;html:$1'), '&lt;/([^:]*?>)', '&lt;/html:$1'))"/>
  </xsl:template>

  <xsl:template match="element()" mode="xoev:nutztSchema">
    <xsl:variable name="schema" select="."/>
    <!-- Für den Fall, dass das Präfix des betrachteten Schemas selbst nicht eindeutig ist: -->
    <xsl:variable name="nutztSchema-self">
      <xsl:if test="
          $schema/root(.)//packagedElement[
          xoev-profil:xsdSchema(.) and
          xoev:getPrefix(.) = $schema/xoev:getPrefix(.) and
          (xoev:getNamespace(.) != $schema/xoev:getNamespace(.) or xoev:getSchemaVersion(.) != $schema/xoev:getSchemaVersion(.))]">
        <nutztSchema>
          <xsl:apply-templates select="." mode="xoev:NutztSchemaType">
            <xsl:with-param name="schema" select="$schema"/>
            <xsl:with-param name="used-prefix" select="$schema/xoev:getPrefix(.)"/>
            <xsl:with-param name="used-namespace" select="$schema/xoev:getNamespace(.)"/>
            <xsl:with-param name="used-schema" select="$schema"/>
            <xsl:with-param name="used-version" select="$schema/xoev:getSchemaVersion(.)"/>
          </xsl:apply-templates>
        </nutztSchema>
      </xsl:if>
    </xsl:variable>
    <xsl:variable name="nutztSchema-import">
      <xsl:for-each select="xoev:package-with-imports-and-includes($schema)/import[@kind = 'direct']">
        <xsl:sort select="@namespace"/>
        <xsl:variable name="used-prefix" select="@prefix"/>
        <xsl:variable name="used-namespace" select="@namespace"/>
        <xsl:variable name="used-schema" select="xoev:ids-to-elements(@id, $schema/root(.))"/>
        <xsl:variable name="used-version" select="$used-schema/xoev:getSchemaVersion(.)"/>
        <!-- Wenn das Präfix über xsdImport/@prefix geändert wurde oder das Präfix nicht eindeutig ist, wird das genutzte Präfix an das jeweilige Schema (Namensraum + Version) gebunden. -->
        <xsl:if test="
            not($used-schema/xoev:getPrefix(.) = $used-prefix) or
            count($schema/root(.)//packagedElement[xoev-profil:xsdSchema(.) and xoev:getPrefix(.) = $used-prefix]) gt 1">
          <nutztSchema>
            <xsl:apply-templates select="." mode="xoev:NutztSchemaType">
              <xsl:with-param name="schema" select="$schema"/>
              <xsl:with-param name="used-prefix" select="$used-prefix"/>
              <xsl:with-param name="used-namespace" select="$used-namespace"/>
              <xsl:with-param name="used-version" select="$used-version"/>
            </xsl:apply-templates>
          </nutztSchema>
        </xsl:if>
      </xsl:for-each>
    </xsl:variable>
    <xsl:for-each-group select="$nutztSchema-self, $nutztSchema-import/*:nutztSchema" group-by="concat(@prefix, @namespace, @version)">
      <xsl:sequence select="."/>
    </xsl:for-each-group>
  </xsl:template>

  <xsl:template match="element()" mode="xoev:NutztSchemaType">
    <xsl:param name="schema" as="element()"/>
    <xsl:param name="used-prefix" as="xs:string"/>
    <xsl:param name="used-namespace" as="xs:string"/>
    <xsl:param name="used-version" as="xs:string"/>
    <xsl:attribute name="prefix">
      <xsl:value-of select="$used-prefix"/>
    </xsl:attribute>
    <xsl:attribute name="namespace">
      <xsl:value-of select="$used-namespace"/>
    </xsl:attribute>
    <xsl:if test="count($schema/root(.)//packagedElement[xoev-profil:xsdSchema(.) and xoev:getNamespace(.) = $used-namespace]) gt 1">
      <xsl:attribute name="version">
        <xsl:value-of select="$used-version"/>
      </xsl:attribute>
    </xsl:if>
  </xsl:template>

  <xsl:template match="element()" mode="xoev:geschaeftsregel">
    <geschaeftsregel>
      <xsl:apply-templates select="." mode="xoev:GeschaeftsregelType"/>
    </geschaeftsregel>
  </xsl:template>

  <xsl:template match="element()" mode="xoev:GeschaeftsregelType">
    <xsl:variable name="owner" select="parent::*"/>
    <xsl:attribute name="kennung">
      <xsl:value-of select="@name"/>
    </xsl:attribute>
    <xsl:for-each select="xoev-profil:schVerbindlichkeit(.)/@verbindlichkeit[. != '']">
      <xsl:attribute name="verbindlichkeit">
        <xsl:value-of select="."/>
      </xsl:attribute>
    </xsl:for-each>
    <xsl:for-each select="ownedComment/body/xoev:clean-text(.)[. != '']">
      <beschreibung>
        <xsl:value-of select="."/>
      </beschreibung>
    </xsl:for-each>
    <xsl:for-each select="(specification/body, specification/@value)[1]">
      <spezifikation>
        <xsl:value-of select="."/>
      </spezifikation>
    </xsl:for-each>
    <xsl:for-each select="uml:resolve-constrainedElement(.)">
      <auswertungskontext>
        <xsl:value-of select="xoev:rueckpfad-zum-naechsten-benannten-baustein(@xmi:id, $owner)"/>
      </auswertungskontext>
    </xsl:for-each>
    <xsl:for-each select="$owner[xoev-profil:schRuleSet(.)]/xoev:dependencies-by-client(.)[xoev-profil:schContext(.)]/uml:resolve-supplier(.)">
      <fachkontext>
        <xsl:value-of select="xoev:rueckpfad-zum-naechsten-benannten-baustein(@xmi:id, $owner)"/>
      </fachkontext>
    </xsl:for-each>
  </xsl:template>

  <xsl:function name="xoev:rueckpfad-zum-naechsten-benannten-baustein" as="xs:string?">
    <xsl:param name="id" as="xs:string"/>
    <xsl:param name="rule-owner" as="element()"/>

    <xsl:variable name="model-element" select="xoev:ids-to-elements($id, $rule-owner/root(.))"/>
    <xsl:variable name="model-element-qualified-name" select="xoev:name-with-prefix($rule-owner, $model-element)"/>
    <xsl:variable name="model-element-named-owner" select="$model-element/self::ownedAttribute/parent::packagedElement[xoev-profil:xsdNamedType(.) or xoev-profil:xsdMessage(.) or xoev-profil:xsdGlobalElement(.)]"/>
    <xsl:variable name="model-element-named-owner-name" select="xoev:name-with-prefix($rule-owner, $model-element-named-owner)"/>

    <xsl:choose>
      <xsl:when test="$model-element[xoev-profil:xsdNamedType(.) or xoev-profil:xsdMessage(.) or xoev-profil:xsdGlobalElement(.) or xoev-profil:xsdGlobalAttribute(.)]">
        <xsl:value-of select="$model-element-qualified-name"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:variable name="message-tree-node" select="(xoev:message-nodes-by-id($id), xoev:message-nodes-by-type-id($id))[1]"/>
        <xsl:choose>
          <xsl:when test="$model-element-named-owner">
            <xsl:value-of select="concat($model-element-named-owner-name, '/', $message-tree-node/@name)"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="concat(xoev:rueckpfad-zum-naechsten-benannten-baustein($message-tree-node/parent::*/@id, $rule-owner), '/', $message-tree-node/@name)"/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:function>

  <xsl:template match="element()" mode="xoev:baustein">
    <xsl:apply-templates select="child::packagedElement[xoev-profil:xsdMessage(.)]" mode="xoev:nachricht">
      <xsl:sort select="tokenize(@name, '\.')[last()]"/>
    </xsl:apply-templates>
    <xsl:apply-templates select="child::packagedElement[xoev-profil:xsdNamedType(.) and xoev:is-code-type(.)]" mode="xoev:codeDatentyp">
      <xsl:sort select="@name"/>
    </xsl:apply-templates>
    <xsl:apply-templates select="child::packagedElement[xoev-profil:xsdNamedType(.) and not(xoev:is-code-type(.))]" mode="xoev:datentyp">
      <xsl:sort select="@name"/>
    </xsl:apply-templates>
    <xsl:apply-templates select="child::packagedElement[xoev-profil:xsdGroup(.)]" mode="xoev:globaleEigenschaftengruppe">
      <xsl:sort select="@name"/>
    </xsl:apply-templates>
    <xsl:apply-templates select="
        child::packagedElement[
        not(xoev-profil:xsdMessage(.)) and (xoev-profil:xsdGlobalElement(.) or xoev-profil:xsdGlobalAttribute(.))]" mode="xoev:globaleEigenschaft">
      <xsl:sort select="@name"/>
    </xsl:apply-templates>
    <xsl:apply-templates select="child::packagedElement[xoev-wsdl:osciTransportScenario(.)]" mode="xoev:osciTransportScenario">
      <xsl:sort select="@name"/>
    </xsl:apply-templates>
    <xsl:apply-templates select="child::packagedElement[xoev-wsdl:wsdlService(.)]" mode="xoev:wsdlService">
      <xsl:sort select="@name"/>
    </xsl:apply-templates>
  </xsl:template>

  <xsl:function name="xoev:is-code-type" as="xs:boolean">
    <xsl:param name="type" as="element()"/>
    <xsl:sequence select="
        $type/(xoev-profil:xoevCodeTyp4(.) or
        xoev:usages-by-client(.)/uml:resolve-supplier(.)[xoev-profil:xoevCodeliste(.) or xoev-profil:xoevVersionCodeliste(.)])"/>
  </xsl:function>

  <xsl:template match="element()" mode="xoev:nachricht">
    <xsl:element name="nachricht">
      <xsl:apply-templates select="." mode="xoev:NachrichtType"/>
    </xsl:element>
  </xsl:template>

  <xsl:template match="element()" mode="xoev:NachrichtType">
    <xsl:variable name="nachricht" select="."/>
    <xsl:variable name="typ" select="xoev:global-element-or-attribute-type(.)"/>
    <xsl:apply-templates select="." mode="xoev:bezeichnungUndStatus"/>
    <xsl:for-each select="xoev-profil:xsdMessage(.)/@autor">
      <xsl:attribute name="autor">
        <xsl:value-of select="."/>
      </xsl:attribute>
    </xsl:for-each>
    <xsl:for-each select="xoev-profil:xsdMessage(.)/@leser">
      <xsl:attribute name="leser">
        <xsl:value-of select="."/>
      </xsl:attribute>
    </xsl:for-each>
    <xsl:apply-templates select="." mode="xoev:ableitung"/>
    <xsl:for-each select="$typ">
      <xsl:attribute name="typ" select="xoev:name-with-prefix($nachricht, .)"/>
    </xsl:for-each>
    <xsl:apply-templates select=".[not($typ)]" mode="xoev:konfiguration.untergruppe"/>
    <xsl:apply-templates select="." mode="xoev:dokumentation"/>
    <xsl:for-each select="xoev-profil:xsdMessage(.)/rechtsgrundlagen">
      <rechtsgrundlage>
        <xsl:value-of select="xoev:unescaped-xml-without-entities(replace(replace(., '&lt;([^/!]{1})', '&lt;db:$1'), '&lt;/', '&lt;/db:'))"/>
      </rechtsgrundlage>
    </xsl:for-each>
    <xsl:apply-templates select=".[not($typ)]" mode="xoev:eigenschaften"/>
    <xsl:apply-templates select="ownedRule" mode="xoev:geschaeftsregel">
      <xsl:sort select="@name"/>
    </xsl:apply-templates>
  </xsl:template>

  <xsl:template match="element()" mode="xoev:ableitung">
    <xsl:variable name="context" select="."/>
    <xsl:for-each select="$context/generalization">
      <xsl:attribute name="basistyp">
        <xsl:value-of select="xoev:name-with-prefix($context, uml:resolve-general(.))"/>
      </xsl:attribute>
      <xsl:for-each select="xoev-profil:xsdRestriction(.)">
        <xsl:attribute name="restriction">
          <xsl:value-of select="true()"/>
        </xsl:attribute>
        <xsl:apply-templates select="@version" mode="xoev:attribute-to-attribute"/>
        <xsl:apply-templates select="@fractionDigits" mode="xoev:attribute-to-attribute"/>
        <xsl:apply-templates select="@length" mode="xoev:attribute-to-attribute"/>
        <xsl:apply-templates select="@maxExclusive" mode="xoev:attribute-to-attribute"/>
        <xsl:apply-templates select="@maxInclusive" mode="xoev:attribute-to-attribute"/>
        <xsl:apply-templates select="@maxLength" mode="xoev:attribute-to-attribute"/>
        <xsl:apply-templates select="@minExclusive" mode="xoev:attribute-to-attribute"/>
        <xsl:apply-templates select="@minInclusive" mode="xoev:attribute-to-attribute"/>
        <xsl:apply-templates select="@minLength" mode="xoev:attribute-to-attribute"/>
        <xsl:apply-templates select="@pattern" mode="xoev:attribute-to-attribute"/>
        <xsl:apply-templates select="@totalDigits" mode="xoev:attribute-to-attribute"/>
        <xsl:apply-templates select="@whitespace" mode="xoev:attribute-to-attribute"/>
      </xsl:for-each>
    </xsl:for-each>
  </xsl:template>

  <xsl:function name="xoev:global-element-or-attribute-type" as="element()*">
    <xsl:param name="element-or-attribute" as="element()"/>
    <xsl:sequence select="
        xoev:dependencies-by-client($element-or-attribute)[
        xoev-profil:xsdGlobalAttributeType(.) or xoev-profil:xsdGlobalElementType(.)]/uml:resolve-supplier(.)"/>
  </xsl:function>

  <xsl:template match="element()" mode="xoev:konfiguration.untergruppe">
    <xsl:if test="xoev-profil:xsdChoice(.)">
      <xsl:attribute name="gruppe.art">choice</xsl:attribute>
    </xsl:if>
    <xsl:if test="xoev-profil:xsdAll(.)">
      <xsl:attribute name="gruppe.art">all</xsl:attribute>
    </xsl:if>
    <xsl:if test="xoev:group-multiplizitaet(.) != '1'">
      <xsl:attribute name="gruppe.multiplizitaet">
        <xsl:value-of select="xoev:group-multiplizitaet(.)"/>
      </xsl:attribute>
    </xsl:if>
  </xsl:template>

  <xsl:template match="element()" mode="xoev:eigenschaften">
    <xsl:for-each select="ownedAttribute[xoev-profil:xsdAttribute(.)]">
      <xsl:sort select="@name"/>
      <xsl:variable name="typ-group" select="uml:resolve-type(.)[xoev-profil:xsdGroup(.)]"/>
      <xsl:apply-templates select=".[not($typ-group)]" mode="xoev:eigenschaft"/>
      <xsl:apply-templates select=".[$typ-group]" mode="xoev:eigenschaftengruppe"/>
    </xsl:for-each>
    <xsl:for-each select="ownedAttribute[not(xoev-profil:xsdAttribute(.))]">
      <xsl:sort select="xoev:position(.)"/>
      <xsl:variable name="typ" select="uml:resolve-type(.)"/>
      <xsl:variable name="typ-group" select="$typ[xoev-profil:xsdGroup(.)]"/>
      <xsl:choose>
        <xsl:when test="not(xoev-profil:xsdLocalStructure(.) or $typ-group)">
          <xsl:apply-templates select="." mode="xoev:eigenschaft"/>
        </xsl:when>
        <xsl:when test="xoev-profil:xsdLocalStructure(.) and $typ/xoev-profil:xsdAnyContents(.)">
          <xsl:apply-templates select="$typ/xoev-profil:xsdAnyContents(.)" mode="xoev:anyStruktur"/>
        </xsl:when>
        <xsl:when test="xoev-profil:xsdLocalStructure(.) or $typ-group">
          <xsl:apply-templates select="." mode="xoev:eigenschaftengruppe"/>
        </xsl:when>
      </xsl:choose>
    </xsl:for-each>
    <xsl:apply-templates select="xoev-profil:xsdAnyContents(.)" mode="xoev:anyStruktur"/>
  </xsl:template>

  <xsl:template match="element()" mode="xoev:eigenschaft">
    <xsl:element name="eigenschaft">
      <xsl:apply-templates select="." mode="xoev:EigenschaftType"/>
    </xsl:element>
  </xsl:template>

  <xsl:template match="element()" mode="xoev:EigenschaftType">
    <xsl:variable name="eigenschaft" select="."/>
    <xsl:variable name="typ" select="uml:resolve-type(.)"/>
    <xsl:variable name="typ-named" select="$typ[xoev:is-named-type(.)]"/>
    <xsl:variable name="typ-ref" select="$typ[xoev:is-global-property(.)]"/>
    <xsl:apply-templates select="." mode="xoev:optionaleBezeichnungUndStatus">
      <xsl:with-param name="named" select="not($typ-ref)"/>
    </xsl:apply-templates>
    <xsl:apply-templates select="." mode="xoev:multiplizitaet"/>
    <xsl:for-each select="$typ-ref">
      <xsl:attribute name="referenz" select="xoev:name-with-prefix($eigenschaft, .)"/>
    </xsl:for-each>
    <xsl:for-each select="xoev-profil:xsdElement(.)/@form[. != 'default']">
      <xsl:attribute name="form" select="."/>
    </xsl:for-each>
    <xsl:apply-templates select="xoev-profil:xsdElement(.)/@nillable" mode="xoev:attribute-to-attribute"/>
    <xsl:apply-templates select="$typ[not($typ-named or $typ-ref)]" mode="xoev:ableitung"/>
    <xsl:apply-templates select="." mode="xoev:konfiguration.eigenschaft">
      <xsl:with-param name="typ-named" select="$typ-named"/>
    </xsl:apply-templates>
    <xsl:apply-templates select="$typ[not($typ-named or $typ-ref)]" mode="xoev:konfiguration.untergruppe"/>
    <xsl:apply-templates select="." mode="xoev:dokumentation"/>
    <xsl:apply-templates select="xoev-profil:xoevBeispielwerte(.)/wert" mode="xoev:beispielwert"/>
    <xsl:apply-templates select="$typ[not($typ-named or $typ-ref or xoev-profil:xsdUnion(.))]" mode="xoev:eigenschaften"/>
    <xsl:apply-templates select="$typ[not($typ-named or $typ-ref) and xoev-profil:xsdUnion(.)]" mode="xoev:union"/>
    <xsl:apply-templates select="(ownedRule, $typ[not($typ-named or $typ-ref)]/ownedRule)" mode="xoev:geschaeftsregel">
      <xsl:sort select="@name"/>
    </xsl:apply-templates>
  </xsl:template>

  <xsl:template match="element()" mode="xoev:optionaleBezeichnungUndStatus">
    <xsl:param name="named" required="yes" as="xs:boolean"/>
    <xsl:apply-templates select="@name[$named]" mode="xoev:attribute-to-attribute"/>
    <xsl:for-each select="xoev-profil:xsdTitled(.)/@title[not(. = '')]">
      <xsl:attribute name="titel">
        <xsl:value-of select="."/>
      </xsl:attribute>
    </xsl:for-each>
    <xsl:for-each select="xoev-profil:xsdDraft(.)">
      <xsl:attribute name="draft">true</xsl:attribute>
    </xsl:for-each>
  </xsl:template>

  <xsl:template match="element()" mode="xoev:konfiguration.eigenschaft">
    <xsl:param name="typ-named" as="element()?"/>
    <xsl:variable name="eigenschaft" select="."/>
    <xsl:for-each select="$typ-named">
      <xsl:attribute name="typ" select="xoev:name-with-prefix($eigenschaft, .)"/>
    </xsl:for-each>
    <xsl:for-each select="xoev-profil:xsdAttribute(.)">
      <xsl:attribute name="xsdAttribute">
        <xsl:value-of select="true()"/>
      </xsl:attribute>
    </xsl:for-each>
    <xsl:variable name="default" select="defaultValue/(@value, body, uml:resolve-instance(.)/@name)[1][. != '']"/>
    <xsl:choose>
      <xsl:when test="$default and @isReadOnly = 'true'">
        <xsl:attribute name="fixedWert" select="$default"/>
      </xsl:when>
      <xsl:when test="$default">
        <xsl:attribute name="defaultWert" select="$default"/>
      </xsl:when>
    </xsl:choose>
  </xsl:template>

  <xsl:template match="element()" mode="xoev:multiplizitaet">
    <xsl:variable name="upperBound" select="
        if (upperValue/@value = '*') then
          '*'
        else
          if (upperValue/@value = '1' or not(upperValue)) then
            '1'
          else
            if (upperValue and not(upperValue/@value)) then
              '0'
            else
              upperValue/@value"/>

    <xsl:if test="'1' != (xs:string(xoev:lowerBound(.)), $upperBound)">
      <xsl:attribute name="multiplizitaet">
        <xsl:value-of select="xoev:lowerBound(.)"/>
        <xsl:if test="xs:string(xoev:lowerBound(.)) != $upperBound">
          <xsl:text>..</xsl:text>
          <xsl:value-of select="$upperBound"/>
        </xsl:if>
      </xsl:attribute>
    </xsl:if>
  </xsl:template>

  <xsl:template match="element()" mode="xoev:eigenschaftengruppe">
    <xsl:element name="eigenschaftengruppe">
      <xsl:apply-templates select="." mode="xoev:EigenschaftengruppeType"/>
    </xsl:element>
  </xsl:template>

  <xsl:template match="element()" mode="xoev:EigenschaftengruppeType">
    <xsl:variable name="gruppe" select="."/>
    <xsl:variable name="local" select="xoev-profil:xsdLocalStructure(.)"/>
    <xsl:variable name="typ" select="uml:resolve-type(.)"/>
    <xsl:variable name="typ-ref" select="$typ[xoev-profil:xsdGroup(.)]"/>
    <xsl:apply-templates select="." mode="xoev:optionaleBezeichnungUndStatus">
      <xsl:with-param name="named" select="not($typ-ref or $local)"/>
    </xsl:apply-templates>
    <xsl:for-each select="$typ-ref[not($local)]">
      <xsl:attribute name="referenz" select="xoev:name-with-prefix($gruppe, .)"/>
    </xsl:for-each>
    <xsl:for-each select="$typ[$local]">
      <xsl:if test="xoev-profil:xsdChoice(.)">
        <xsl:attribute name="art">choice</xsl:attribute>
      </xsl:if>
      <xsl:if test="xoev-profil:xsdAll(.)">
        <xsl:attribute name="art">all</xsl:attribute>
      </xsl:if>
    </xsl:for-each>
    <xsl:apply-templates select="." mode="xoev:multiplizitaet"/>
    <xsl:apply-templates select="." mode="xoev:dokumentation"/>
    <xsl:apply-templates select="$typ[$local]" mode="xoev:eigenschaften"/>
    <xsl:apply-templates select="ownedRule" mode="xoev:geschaeftsregel">
      <xsl:sort select="@name"/>
    </xsl:apply-templates>
  </xsl:template>

  <xsl:function name="xoev:group-multiplizitaet" as="xs:string">
    <xsl:param name="gruppe" as="element()"/>
    <xsl:variable name="konfig" select="xoev-profil:xsdModelGroup($gruppe)"/>
    <xsl:choose>
      <xsl:when test="$konfig">
        <xsl:variable name="upperBound" select="
            if ($konfig/@maxOccurs = 'unbounded') then
              '*'
            else
              $konfig/@maxOccurs"/>
        <xsl:value-of select="$konfig/@minOccurs"/>
        <xsl:if test="$konfig/@minOccurs != $upperBound">
          <xsl:text>..</xsl:text>
          <xsl:value-of select="$upperBound"/>
        </xsl:if>
      </xsl:when>
      <xsl:otherwise>
        <xsl:text>1</xsl:text>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:function>

  <xsl:template match="element()" mode="xoev:anyStruktur">
    <xsl:element name="anyStruktur">
      <xsl:apply-templates select="." mode="xoev:AnyStrukturType"/>
    </xsl:element>
  </xsl:template>

  <xsl:template match="element()" mode="xoev:AnyStrukturType">
    <xsl:apply-templates select="." mode="xoev:konfiguration.anyStruktur"/>
  </xsl:template>

  <xsl:template match="element()" mode="xoev:konfiguration.anyStruktur">
    <xsl:apply-templates select="@namespace" mode="xoev:attribute-to-attribute"/>
    <xsl:apply-templates select="@processContents" mode="xoev:attribute-to-attribute"/>
    <xsl:variable name="upperBound" select="
        if (@maxOccurs = 'unbounded') then
          '*'
        else
          @maxOccurs"/>
    <xsl:if test="'1' != (@minOccurs, $upperBound)">
      <xsl:attribute name="multiplizitaet">
        <xsl:value-of select="@minOccurs"/>
        <xsl:if test="@minOccurs != $upperBound">
          <xsl:text>..</xsl:text>
          <xsl:value-of select="$upperBound"/>
        </xsl:if>
      </xsl:attribute>
    </xsl:if>
  </xsl:template>

  <xsl:template match="element()" mode="xoev:union">
    <union>
      <xsl:apply-templates select="." mode="xoev:UnionType"/>
    </union>
  </xsl:template>

  <xsl:template match="element()" mode="xoev:UnionType">
    <xsl:variable name="union" select="."/>
    <xsl:for-each select="xoev:dependencies-by-client($union)[xoev-profil:xsdUnionMember(.)]/uml:resolve-supplier(.)">
      <xsl:sort select="xoev:name-with-prefix($union, .)"/>
      <memberType>
        <xsl:sequence select="xoev:name-with-prefix($union, .)"/>
      </memberType>
    </xsl:for-each>
  </xsl:template>

  <xsl:template match="element()" mode="xoev:codeDatentyp">
    <xsl:element name="codeDatentyp">
      <xsl:apply-templates select="." mode="xoev:CodeDatentypType"/>
    </xsl:element>
  </xsl:template>

  <xsl:template match="element()" mode="xoev:osciTransportScenario">
    <xsl:element name="osciTransportScenario">
      <xsl:apply-templates select="." mode="xoev:OSCITransportScenario"/>
    </xsl:element>
  </xsl:template>

  <xsl:template match="element()" mode="xoev:wsdlService">
    <xsl:element name="wsdlService">
      <xsl:apply-templates select="." mode="xoev:WSDLService"/>
    </xsl:element>
  </xsl:template>

  <xsl:template match="element()" mode="xoev:CodeDatentypType">
    <xsl:variable name="cd" select="."/>
    <xsl:variable name="usage" select="xoev:usages-by-client(.)"/>
    <xsl:variable name="supplier" select="$usage/uml:resolve-supplier(.)"/>
    <xsl:variable name="vcl" select="$supplier[xoev-profil:xoevVersionCodeliste(.)]"/>
    <xsl:variable name="cl" select="
        if ($vcl) then
          $vcl/xoev:dependencies-by-client(.)/uml:resolve-supplier(.)
        else
          $supplier"/>
    <xsl:apply-templates select="." mode="xoev:bezeichnungUndStatus"/>
    <xsl:for-each select="$cl[not($cd/xoev-profil:xoevCodeTyp4(.))]">
      <xsl:apply-templates select="xoev-profil:xoevCodeliste(.)/@kennung" mode="xoev:attribute-to-attribute"/>
    </xsl:for-each>
    <xsl:for-each select="$vcl[not($cd/xoev-profil:xoevCodeTyp4(.))]">
      <xsl:apply-templates select="xoev-profil:xoevVersionCodeliste(.)/@version" mode="xoev:attribute-to-attribute"/>
    </xsl:for-each>
    <xsl:apply-templates select="." mode="xoev:dokumentation"/>
    <xsl:apply-templates select="." mode="xoev:konfiguration.codeDatentyp">
      <xsl:with-param name="cd" select="$cd"/>
      <xsl:with-param name="usage" select="$usage"/>
    </xsl:apply-templates>
    <xsl:if test="$cd/xoev-profil:xoevCodeTyp4(.)">
      <xsl:apply-templates select="$cl, $vcl" mode="xoev:nutztCodeliste">
        <xsl:sort select="(., xoev:dependencies-by-client(.)/uml:resolve-supplier(.))/@kennung"/>
      </xsl:apply-templates>
    </xsl:if>
    <xsl:apply-templates select="ownedRule" mode="xoev:geschaeftsregel">
      <xsl:sort select="@name"/>
    </xsl:apply-templates>
  </xsl:template>

  <xsl:template match="element()" mode="xoev:OSCITransportScenario">
    <xsl:apply-templates select="." mode="xoev:bezeichnungUndStatus"/>
    <xsl:apply-templates select="." mode="xoev:beschreibung.html"/>
    <xsl:for-each select="xoev-wsdl:osciTransportScenario(.)">
      <xsl:apply-templates select="@SignaturNutzdaten" mode="xoev:attribute-to-element"/>
      <xsl:apply-templates select="@VerschluesselungNutzdaten" mode="xoev:attribute-to-element"/>
      <xsl:apply-templates select="@SignaturInhaltsdaten" mode="xoev:attribute-to-element"/>
      <xsl:apply-templates select="@VerschluesselungInhaltsdaten" mode="xoev:attribute-to-element"/>
      <xsl:apply-templates select="@Kommunikationsszenario" mode="xoev:attribute-to-element"/>
      <xsl:apply-templates select="@OptionalerContainer" mode="xoev:attribute-to-element"/>
      <xsl:apply-templates select="@NameMandatorischerContainer" mode="xoev:attribute-to-element"/>
    </xsl:for-each>
  </xsl:template>

  <xsl:template match="element()" mode="xoev:WSDLService">
    <xsl:apply-templates select="." mode="xoev:bezeichnungUndStatus"/>
    <xsl:for-each select="generalization/uml:resolve-general(.)">
      <osciTransportScenario>
        <xsl:value-of select="@name"/>
      </osciTransportScenario>
    </xsl:for-each>
    <xsl:apply-templates select="." mode="xoev:beschreibung.html"/>
    <xsl:variable name="service" select="."/>
    <xsl:for-each select="xoev-wsdl:wsdlService(.)">
      <xsl:apply-templates select="@SignaturNutzdaten" mode="xoev:attribute-to-element"/>
      <xsl:apply-templates select="@VerschluesselungNutzdaten" mode="xoev:attribute-to-element"/>
      <xsl:apply-templates select="@SignaturInhaltsdaten" mode="xoev:attribute-to-element"/>
      <xsl:apply-templates select="@VerschluesselungInhaltsdaten" mode="xoev:attribute-to-element"/>
      <xsl:apply-templates select="@Kommunikationsszenario" mode="xoev:attribute-to-element"/>
      <xsl:apply-templates select="@OptionalerContainer" mode="xoev:attribute-to-element"/>
      <xsl:apply-templates select="@NameMandatorischerContainer" mode="xoev:attribute-to-element"/>
      <xsl:apply-templates select="@Leistungserbringer" mode="xoev:attribute-to-element"/>
      <xsl:apply-templates select="@Hinweis" mode="xoev:attribute-to-element"/>
      <xsl:apply-templates select="@Nachrichtenbeschreibung" mode="xoev:attribute-to-element"/>
      <xsl:apply-templates select="@NamensraumOhneDateiname" mode="xoev:attribute-to-element"/>
      <xsl:apply-templates select="@Dateiname" mode="xoev:attribute-to-element"/>
      <xsl:apply-templates select="@SubjectOperation" mode="xoev:attribute-to-element"/>
      <xsl:apply-templates select="@TestaPort" mode="xoev:attribute-to-element"/>
      <xsl:apply-templates select="@InternetPort" mode="xoev:attribute-to-element"/>
      <xsl:for-each select="KategorieDesDienstanbieters">
        <KategorieDesDienstanbieters>
          <xsl:value-of select="."/>
        </KategorieDesDienstanbieters>
      </xsl:for-each>
    </xsl:for-each>
    <xsl:for-each select="xoev:dependencies-by-client(.)[xoev-wsdl:wsdlServiceMessage(.)]">
      <wsdlServiceMessage>
        <xsl:sequence select="uml:resolve-supplier(.)/concat(xoev:getPrefix(.), ':', @name)"/>
      </wsdlServiceMessage>
    </xsl:for-each>
    <xsl:for-each select="xoev:dependencies-by-client(.)[xoev-wsdl:wsdlServiceInputMessage(.)]">
      <wsdlServiceInputMessage>
        <xsl:sequence select="uml:resolve-supplier(.)/concat(xoev:getPrefix(.), ':', @name)"/>
      </wsdlServiceInputMessage>
    </xsl:for-each>
    <xsl:for-each select="xoev:dependencies-by-client(.)[xoev-wsdl:wsdlServiceOutputMessage(.)]">
      <wsdlServiceOutputMessage>
        <xsl:sequence select="uml:resolve-supplier(.)/concat(xoev:getPrefix(.), ':', @name)"/>
      </wsdlServiceOutputMessage>
    </xsl:for-each>
    <xsl:for-each select="xoev:dependencies-by-client(.)[xoev-wsdl:wsdlServiceFaultMessage(.)]">
      <wsdlServiceFaultMessage>
        <xsl:sequence select="uml:resolve-supplier(.)/concat(xoev:getPrefix(.), ':', @name)"/>
      </wsdlServiceFaultMessage>
    </xsl:for-each>
  </xsl:template>

  <xsl:template match="element()" mode="xoev:konfiguration.codeDatentyp">
    <xsl:param name="cd" as="element()"/>
    <xsl:param name="usage" as="element()?"/>
    <xsl:apply-templates select="." mode="xoev:grundkonfiguration.codeDatentyp">
      <xsl:with-param name="stereotyp" select="$usage/xoev-profil:xoevCodeTyp1(.), $usage/xoev-profil:xoevCodeTyp2(.), $usage/xoev-profil:xoevCodeTyp3(.), xoev-profil:xoevCodeTyp4(.)"/>
      <xsl:with-param name="ref-context" select="."/>
    </xsl:apply-templates>
    <xsl:for-each select="$usage/xoev-profil:xoevCodeTyp3(.)">
      <xsl:apply-templates select="@genutzteCodeSpalte" mode="xoev:attribute-to-element"/>
      <xsl:apply-templates select="@genutzteBeschreibungsspalte" mode="xoev:attribute-to-element"/>
    </xsl:for-each>
    <xsl:for-each select="$usage/xoev-profil:xoevCodeTyp1(.), $usage/xoev-profil:xoevCodeTyp2(.)">
      <xsl:for-each select="@genutzteCodeSpalte">
        <xsl:element name="{name()}">
          <xsl:value-of select="xoev:ids-to-elements(., $cd/root(.))/@name"/>
        </xsl:element>
      </xsl:for-each>
      <xsl:for-each select="@genutzteBeschreibungsspalte">
        <xsl:element name="{name()}">
          <xsl:value-of select="xoev:ids-to-elements(., $cd/root(.))/@name"/>
        </xsl:element>
      </xsl:for-each>
    </xsl:for-each>
    <xsl:for-each select="$usage/xoev-profil:xoevCodeTyp1(.)">
      <xsl:for-each select="@benannterCodelistenDatentypXSD">
        <xsl:element name="{name()}">
          <xsl:value-of select="xoev:name-with-prefix($cd, xoev:ids-to-elements(., $cd/root(.)))"/>
        </xsl:element>
      </xsl:for-each>
      <xsl:apply-templates select="@benannterCodelistenDatentypName" mode="xoev:attribute-to-element"/>
    </xsl:for-each>
  </xsl:template>

  <xsl:template match="element()" mode="xoev:grundkonfiguration.codeDatentyp">
    <xsl:param name="stereotyp" as="element()?"/>
    <xsl:param name="ref-context" as="element()"/>
    <xsl:for-each select="$stereotyp/@typDesCodeElements">
      <xsl:element name="{name()}">
        <xsl:value-of select="xoev:name-with-prefix($ref-context, xoev:ids-to-elements(., $ref-context/root(.)))"/>
      </xsl:element>
    </xsl:for-each>
    <xsl:for-each select="$stereotyp/@nameElement">
      <xsl:element name="nutzungNameElement">
        <xsl:value-of select="."/>
      </xsl:element>
    </xsl:for-each>
    <xsl:apply-templates select="$stereotyp/@benannterCodelistenDatentyp" mode="xoev:attribute-to-element"/>
    <xsl:if test="ends-with($stereotyp/name(), 'xoevCodeTyp1')">
      <xsl:element name="codesSchemavalidiert">
        <xsl:value-of select="true()"/>
      </xsl:element>
    </xsl:if>
    <xsl:if test="ends-with($stereotyp/name(), 'xoevCodeTyp2')">
      <xsl:element name="codesSchemavalidiert">
        <xsl:value-of select="false()"/>
      </xsl:element>
    </xsl:if>
  </xsl:template>

  <xsl:template match="element()" mode="xoev:datentyp">
    <xsl:element name="datentyp">
      <xsl:apply-templates select="." mode="xoev:DatentypType"/>
    </xsl:element>
  </xsl:template>

  <xsl:template match="element()" mode="xoev:DatentypType">
    <xsl:apply-templates select="." mode="xoev:bezeichnungUndStatus"/>
    <xsl:if test="@isAbstract = 'true'">
      <xsl:attribute name="abstrakt">true</xsl:attribute>
    </xsl:if>
    <xsl:apply-templates select="." mode="xoev:ableitung"/>
    <xsl:apply-templates select="." mode="xoev:konfiguration.untergruppe"/>
    <xsl:apply-templates select=".[xoev-profil:xoevDatentyp(.)]" mode="xoev:metadaten.xoevDatentyp"/>
    <xsl:apply-templates select="xoev-profil:xoevVersionDatentyp(.)" mode="xoev:metadaten.versionXOEVDatentyp"/>
    <xsl:apply-templates select="." mode="xoev:dokumentation"/>
    <xsl:apply-templates select="xoev-profil:xoevBeispielwerte(.)/wert" mode="xoev:beispielwert"/>
    <xsl:apply-templates select="." mode="xoev:eigenschaften"/>
    <xsl:apply-templates select=".[xoev-profil:xsdUnion(.)]" mode="xoev:union"/>
    <xsl:apply-templates select="ownedRule" mode="xoev:geschaeftsregel">
      <xsl:sort select="@name"/>
    </xsl:apply-templates>
  </xsl:template>

  <xsl:template match="element()" mode="xoev:beispielwert">
    <beispielwert>
      <xsl:value-of select="."/>
    </beispielwert>
  </xsl:template>

  <xsl:template match="element()" mode="xoev:metadaten.xoevDatentyp">
    <lite-bib:metadaten.xoevDatentyp>
      <xsl:apply-templates select="." mode="xoev:Metadaten.XOEVDatentypType"/>
    </lite-bib:metadaten.xoevDatentyp>
  </xsl:template>

  <xsl:template match="element()" mode="xoev:Metadaten.XOEVDatentypType">
    <xsl:variable name="datentyp" select="."/>
    <xsl:for-each select="xoev-profil:xoevDatentyp(.)">
      <xsl:apply-templates select="@nameLang" mode="xoev:attribute-to-element">
        <xsl:with-param name="prefix">lite-bib</xsl:with-param>
      </xsl:apply-templates>
      <xsl:apply-templates select="@nameKurz" mode="xoev:attribute-to-element">
        <xsl:with-param name="prefix">lite-bib</xsl:with-param>
      </xsl:apply-templates>
      <xsl:apply-templates select="@nameTechnisch" mode="xoev:attribute-to-element">
        <xsl:with-param name="prefix">lite-bib</xsl:with-param>
      </xsl:apply-templates>
      <xsl:apply-templates select="@kennung" mode="xoev:attribute-to-element">
        <xsl:with-param name="prefix">lite-bib</xsl:with-param>
      </xsl:apply-templates>
      <xsl:apply-templates select="$datentyp/ancestor::packagedElement/xoev-profil:xoevBibliothek(.)/@herausgebernameLang" mode="xoev:attribute-to-element">
        <xsl:with-param name="prefix">lite-bib</xsl:with-param>
      </xsl:apply-templates>
      <xsl:apply-templates select="$datentyp/ancestor::packagedElement/xoev-profil:xoevBibliothek(.)/@herausgebernameKurz" mode="xoev:attribute-to-element">
        <xsl:with-param name="prefix">lite-bib</xsl:with-param>
      </xsl:apply-templates>
      <xsl:apply-templates select="@externeWebsite" mode="xoev:attribute-to-element">
        <xsl:with-param name="prefix">lite-bib</xsl:with-param>
      </xsl:apply-templates>
    </xsl:for-each>
  </xsl:template>

  <xsl:template match="element()" mode="xoev:metadaten.versionXOEVDatentyp">
    <lite-bib:metadaten.versionXOEVDatentyp>
      <xsl:apply-templates select="." mode="xoev:Metadaten.VersionXOEVDatentypType"/>
    </lite-bib:metadaten.versionXOEVDatentyp>
  </xsl:template>

  <xsl:template match="element()" mode="xoev:Metadaten.VersionXOEVDatentypType">
    <xsl:apply-templates select="@version" mode="xoev:attribute-to-element">
      <xsl:with-param name="prefix">lite-bib</xsl:with-param>
    </xsl:apply-templates>
    <xsl:apply-templates select="@beschreibung" mode="xoev:attribute-to-element">
      <xsl:with-param name="prefix">lite-bib</xsl:with-param>
    </xsl:apply-templates>
    <xsl:apply-templates select="@lizenz" mode="xoev:attribute-to-element">
      <xsl:with-param name="prefix">lite-bib</xsl:with-param>
    </xsl:apply-templates>
    <xsl:apply-templates select="@bezugsort" mode="xoev:attribute-to-element">
      <xsl:with-param name="prefix">lite-bib</xsl:with-param>
    </xsl:apply-templates>
    <xsl:apply-templates select="@aenderungZurVorversion" mode="xoev:attribute-to-element">
      <xsl:with-param name="prefix">lite-bib</xsl:with-param>
    </xsl:apply-templates>
  </xsl:template>

  <xsl:template match="element()" mode="xoev:globaleEigenschaftengruppe">
    <xsl:element name="globaleEigenschaftengruppe">
      <xsl:apply-templates select="." mode="xoev:GlobaleEigenschaftengruppeType"/>
    </xsl:element>
  </xsl:template>

  <xsl:template match="element()" mode="xoev:GlobaleEigenschaftengruppeType">
    <xsl:variable name="datentyp" select="."/>
    <xsl:apply-templates select="." mode="xoev:bezeichnungUndStatus"/>
    <xsl:if test="xoev-profil:xsdChoice(.)">
      <xsl:attribute name="art">choice</xsl:attribute>
    </xsl:if>
    <xsl:if test="xoev-profil:xsdAll(.)">
      <xsl:attribute name="art">all</xsl:attribute>
    </xsl:if>
    <xsl:if test="xoev:group-multiplizitaet(.) != '1'">
      <xsl:attribute name="multiplizitaet">
        <xsl:value-of select="xoev:group-multiplizitaet(.)"/>
      </xsl:attribute>
    </xsl:if>
    <xsl:apply-templates select="." mode="xoev:dokumentation"/>
    <xsl:apply-templates select="." mode="xoev:eigenschaften"/>
    <xsl:apply-templates select="ownedRule" mode="xoev:geschaeftsregel">
      <xsl:sort select="@name"/>
    </xsl:apply-templates>
  </xsl:template>

  <xsl:template match="element()" mode="xoev:globaleEigenschaft">
    <xsl:element name="globaleEigenschaft">
      <xsl:apply-templates select="." mode="xoev:GlobaleEigenschaftType"/>
    </xsl:element>
  </xsl:template>

  <xsl:template match="element()" mode="xoev:GlobaleEigenschaftType">
    <xsl:variable name="ge" select="."/>
    <xsl:variable name="typ" select="xoev:global-element-or-attribute-type(.)"/>
    <xsl:apply-templates select="." mode="xoev:bezeichnungUndStatus"/>
    <xsl:apply-templates select="." mode="xoev:ableitung"/>
    <xsl:for-each select="$typ">
      <xsl:attribute name="typ" select="xoev:name-with-prefix($ge, .)"/>
    </xsl:for-each>
    <xsl:if test="xoev-profil:xsdGlobalAttribute(.)">
      <xsl:attribute name="xsdAttribute">true</xsl:attribute>
    </xsl:if>
    <xsl:for-each select="(xoev-profil:xsdGlobalAttribute(.), xoev-profil:xsdGlobalElement(.))/@defaultwert">
      <xsl:attribute name="defaultWert" select="."/>
    </xsl:for-each>
    <xsl:for-each select="(xoev-profil:xsdGlobalAttribute(.), xoev-profil:xsdGlobalElement(.))/@fixedwert">
      <xsl:attribute name="fixedWert" select="."/>
    </xsl:for-each>
    <xsl:apply-templates select=".[not($typ)]" mode="xoev:konfiguration.untergruppe"/>
    <xsl:apply-templates select="." mode="xoev:dokumentation"/>
    <xsl:apply-templates select="xoev-profil:xoevBeispielwerte(.)/wert" mode="xoev:beispielwert"/>
    <xsl:apply-templates select=".[not($typ)]" mode="xoev:eigenschaften"/>
    <xsl:apply-templates select=".[xoev-profil:xsdUnion(.)]" mode="xoev:union"/>
    <xsl:apply-templates select="ownedRule" mode="xoev:geschaeftsregel">
      <xsl:sort select="@name"/>
    </xsl:apply-templates>
  </xsl:template>

  <xsl:template match="element()" mode="xoev:paket">
    <xsl:element name="paket">
      <xsl:apply-templates select="." mode="xoev:PaketType"/>
    </xsl:element>
  </xsl:template>

  <xsl:template match="element()" mode="xoev:PaketType">
    <xsl:apply-templates select="." mode="xoev:bezeichnungUndStatus"/>
    <xsl:apply-templates select="." mode="xoev:dokumentation"/>
    <xsl:apply-templates select="." mode="xoev:baustein"/>
    <xsl:apply-templates select="child::packagedElement[uml:is-Package(.)]" mode="xoev:paketstruktur">
      <xsl:sort select="@name"/>
    </xsl:apply-templates>
    <xsl:apply-templates select="ownedRule, packagedElement[xoev-profil:schRuleSet(.)]/ownedRule" mode="xoev:geschaeftsregel">
      <xsl:sort select="@name"/>
    </xsl:apply-templates>
  </xsl:template>

  <xsl:template match="element()" mode="xoev:PaketInSchemaType">
    <xsl:apply-templates select="." mode="xoev:bezeichnungUndStatus"/>
    <xsl:apply-templates select="." mode="xoev:dokumentation"/>
    <xsl:apply-templates select="." mode="xoev:baustein"/>
    <xsl:for-each select="child::packagedElement[uml:is-Package(.)]">
      <xsl:sort select="@name"/>
      <xsl:element name="paket">
        <xsl:apply-templates select="." mode="xoev:PaketInSchemaType"/>
      </xsl:element>
    </xsl:for-each>
    <xsl:apply-templates select="ownedRule, packagedElement[xoev-profil:schRuleSet(.)]/ownedRule" mode="xoev:geschaeftsregel">
      <xsl:sort select="@name"/>
    </xsl:apply-templates>
  </xsl:template>

  <xsl:template match="attribute()" mode="xoev:attribute-to-element">
    <xsl:param name="prefix" as="xs:string" select="''" required="no"/>
    <xsl:element name="{concat($prefix, if($prefix != '') then ':' else '', name())}">
      <xsl:value-of select="."/>
    </xsl:element>
  </xsl:template>

  <xsl:template match="attribute()" mode="xoev:attribute-to-attribute">
    <xsl:param name="prefix" as="xs:string" select="''" required="no"/>
    <xsl:attribute name="{concat($prefix, if($prefix != '') then ':' else '', name())}">
      <xsl:value-of select="."/>
    </xsl:attribute>
  </xsl:template>

  <xsl:function name="xoev:name-with-prefix" as="xs:string">
    <xsl:param name="referring-context" as="element()" required="yes"/>
    <xsl:param name="used-object" as="element()" required="yes"/>
    <xsl:value-of select="
        concat(
        if ($used-object[parent::packagedElement/@name = 'W3C Data Types']) then
          'xs'
        else
          xoev:qualified-prefix($used-object/ancestor-or-self::packagedElement[xoev-profil:xsdSchema(.)], $referring-context), ':', $used-object/@name)"/>
  </xsl:function>

  <xsl:function name="xoev:is-named-type" as="xs:boolean">
    <xsl:param name="object" as="element()" required="yes"/>
    <xsl:sequence select="$object/parent::packagedElement/@name = 'W3C Data Types' or $object/xoev-profil:xsdNamedType(.)"/>
  </xsl:function>

  <xsl:function name="xoev:is-global-property" as="xs:boolean">
    <xsl:param name="object" as="element()" required="yes"/>
    <xsl:sequence select="$object/xoev-profil:xsdGlobalElement(.) or $object/xoev-profil:xsdGlobalAttribute(.)"/>
  </xsl:function>

  <xsl:function name="xoev:getSchemaVersion" as="xs:string?">
    <xsl:param name="element" as="element()"/>
    <xsl:sequence select="($element/ancestor-or-self::packagedElement/xoev-profil:xsdSchema(.)/@version, $element/ancestor-or-self::packagedElement/xoev-profil:xoevVersionStandard(.)/@version)[1]"/>
  </xsl:function>

</xsl:stylesheet>
