<?xml version="1.0" encoding="UTF-8"?>
<sch:schema xmlns:sch="http://purl.oclc.org/dsdl/schematron" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xmi="http://www.omg.org/spec/XMI/20131001" queryBinding="xslt2">

   <sch:title>XÖV-Prüfanweisungen: Namens- und Entwurfsregeln</sch:title>
   <xsl:include href="xgenerator-library.xgen-core.xsl"/>
   <xsl:include href="xgenerator-library.uml-access-layer.xsl"/>
   <xsl:include href="xoev-profil.profile-access-layer.xsl"/>
   <xsl:include href="xoev-profil.helpers.xsl"/>

   <sch:ns uri="http://www.xoev.de/de/xgenerator/framework/1/library" prefix="xgen"/>
   <sch:ns uri="http://www.omg.org/spec/XMI/20131001" prefix="xmi"/>
   <sch:ns uri="http://www.eclipse.org/uml2/5.0.0/UML" prefix="uml"/>
   <sch:ns uri="urn:xoev-de:kosit:xoev:classic:transformation_4.2.0" prefix="xoev"/>
   <sch:ns uri="urn:xoev-de:kosit:xoev:classic:access-layer:xoev-profil_4.2.0" prefix="xoev-profil"/>
   
   <sch:pattern id="pattern.classic.001">
      <sch:title>Verarbeitbares XÖV-Fachmodell</sch:title>
      <sch:rule context="/">
         <sch:assert id="classic.001" role="error" test=".//@xmi:id">classic.001: Das Dokument entspricht keiner vom XGenerator verarbeitbaren XMI-Version.</sch:assert>
      </sch:rule>
   </sch:pattern>

   <sch:pattern id="pattern.classic.002">
      <sch:title>Verarbeitbares XÖV-Fachmodell</sch:title>
      <sch:rule context="/">
          <sch:assert id="classic.002" role="error" test=".//uml:Model">classic.002: Das Dokument enthält kein Modell in einer vom XGenerator verarbeitbaren UML-Version.</sch:assert>
      </sch:rule>
   </sch:pattern>

   <sch:pattern id="pattern.NDR-2.001.classic">
      <sch:title>Genau ein XÖV-Fachmodell auf oberster Modellebene</sch:title>      
      <sch:rule context="/xmi:XMI/uml:Model[count(packagedElement[xoev-profil:xsdXModel(.)]) != 1]">
        <sch:assert role="error" id="NDR-2.001.classic" test="false()">NDR-2.001.classic: Auf der obersten Modellebene darf nur das Modell des eigenen Standards (UML-Modell mit dem Stereotyp xsdXModel) vorliegen. Alle weiteren XÖV-Fachmodelle müssen als externe Modelle im Paket "Externe Modelle" vorliegen. Aktuell existieren <sch:value-of select="count(packagedElement[xoev-profil:xsdXModel(.)])"/> Modelle auf der obersten Modellebene: <sch:value-of select="packagedElement[xoev-profil:xsdXModel(.)]/@name"/></sch:assert>
      </sch:rule>
   </sch:pattern>

    <sch:pattern id="pattern.NDR-2.002.classic">
      <sch:title>Externe Modelle ausschließlich im Paket Externe Modelle</sch:title>      
      <sch:rule context="/xmi:XMI/uml:Model">
         <sch:let name="models" value="//packagedElement[xoev-profil:xsdXModel(.)]"/>
         <sch:assert role="error" id="NDR-2.002.classic" test="
           count($models) - count($models[ancestor::packagedElement/@name = 'Externe Modelle']) = 1">NDR-2.002.classic: Externe Modelle (UML-Modelle mit dem Stereotyp xsdXModel, deren Inhalte nicht zum eigenen Standard gehören) müssen im Paket "Externe Modelle" abgelegt werden. Folgende Modelle liegen derzeit außerhalb des Pakets "Externe Modelle" vor: <sch:value-of select="//packagedElement[xoev-profil:xsdXModel(.) and not(parent::packagedElement/@name = 'Externe Modelle')]/@name"/></sch:assert>
      </sch:rule>
   </sch:pattern>
  
  <sch:pattern id="pattern.NDR-4.001.classic">
    <sch:title>Code-Datentypen sind stets benannte Datentypen.</sch:title>      
    <sch:rule context="uml:Model/packagedElement[xoev-profil:xsdXModel(.)]//packagedElement[uml:is-Class(.) and (xoev-profil:xoevCodeTyp4(.) or xoev:usages-by-client(.)/uml:resolve-supplier(.)[xoev-profil:xoevVersionCodeliste(.) or xoev-profil:xoevCodeliste(.)]) and not(xoev-profil:xsdDraft(.))] | uml:Model/packagedElement[xoev-profil:xsdXModel(.)]//nestedClassifier[uml:is-Class(.) and (xoev-profil:xoevCodeTyp4(.) or xoev:usages-by-client(.)/uml:resolve-supplier(.)[xoev-profil:xoevVersionCodeliste(.) or xoev-profil:xoevCodeliste(.)]) and not(xoev-profil:xsdDraft(.))]">
      <sch:assert role="error" id="NDR-4.001.classic" test="not(empty(xoev-profil:xsdNamedType(.)))">NDR-4.001.classic: Code-Datentypen sind stets benannte Datentypen. Folgender Code-Datentyp verletzt die Regel: <sch:value-of select="@name"/></sch:assert>
    </sch:rule>
  </sch:pattern>

   <sch:pattern id="pattern.NDR-28.001.classic">
      <sch:title>xsdNamedType, xsdGlobalElement und xsdGlobalElementAndNamedType schließen sich gegenseitig aus</sch:title>      
      <sch:rule context="
            /xmi:XMI/uml:Model/packagedElement[xoev-profil:xsdXModel(.)]//packagedElement[
            xoev-profil:xsdNamedType(.) and xoev-profil:xsdGlobalElement(.) or xoev-profil:xsdNamedType(.) and xoev-profil:xsdGlobalElementAndNamedType(.) or xoev-profil:xsdGlobalElement(.) and xoev-profil:xsdGlobalElementAndNamedType(.)] |
            /xmi:XMI/uml:Model/packagedElement[xoev-profil:xsdXModel(.)]//nestedClassifier[
            xoev-profil:xsdNamedType(.) and xoev-profil:xsdGlobalElement(.) or xoev-profil:xsdNamedType(.) and xoev-profil:xsdGlobalElementAndNamedType(.) or xoev-profil:xsdGlobalElement(.) and xoev-profil:xsdGlobalElementAndNamedType(.)]">
        <sch:assert role="error" id="NDR-28.001.classic" test="false()">NDR-28.001.classic: Die Stereotypen xsdNamedType, xsdGlobalElement und xsdGlobalElementAndNamedType schließen sich gegenseitig aus. Der Baustein <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
      </sch:rule>
   </sch:pattern>

    <sch:pattern id="pattern.NDR-28.002.classic">
      <sch:title>xsdNamedType und xsdMessage schließen sich gegenseitig aus</sch:title>      
      <sch:rule context="
            /xmi:XMI/uml:Model/packagedElement[xoev-profil:xsdXModel(.)]//packagedElement[xoev-profil:xsdNamedType(.) and xoev-profil:xsdMessage(.)] |
            /xmi:XMI/uml:Model/packagedElement[xoev-profil:xsdXModel(.)]//nestedClassifier[xoev-profil:xsdNamedType(.) and xoev-profil:xsdMessage(.)]">
          <sch:assert role="error" id="NDR-28.002.classic" test="false()">NDR-28.002.classic: Die Stereotypen xsdNamedType und xsdMessage schließen sich gegenseitig aus. Der Baustein <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
      </sch:rule>
   </sch:pattern>

    <sch:pattern id="pattern.NDR-28.003.classic">
      <sch:title>xsdAttribute, xsdElement und xsdLocalStructure schließen sich gegenseitig aus</sch:title>      
      <sch:rule context="
            /xmi:XMI/uml:Model/packagedElement[xoev-profil:xsdXModel(.)]//ownedAttribute[count((xoev-profil:xsdLocalStructure(.), xoev-profil:xsdElement(.), xoev-profil:xsdAttribute(.))) ge 2]">
          <sch:assert role="error" id="NDR-28.003.classic" test="false()">NDR-28.003.classic: Die Stereotypen xsdLocalStructure, xsdAttribute und xsdElement schließen sich gegenseitig aus. Die UML-Eigenschaft <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
      </sch:rule>
   </sch:pattern>

    <sch:pattern id="pattern.NDR-28.004.classic">
      <sch:title>Position eines Elements größer null</sch:title>      
      <sch:rule context="
            /xmi:XMI/uml:Model/packagedElement[xoev-profil:xsdXModel(.)]//ownedAttribute[(xoev-profil:xsdLocalStructure(.) or xoev:is-element(.)) and
            (ancestor::packagedElement/xoev-profil:xsdXModel(.)/@ermittlungElementreihenfolge = 'Stereotyp' or ../ownedAttribute/(xoev-profil:xsdLocalStructure(.), xoev-profil:xsdElement(.))/@position) and
            not(xs:integer((xoev-profil:xsdLocalStructure(.), xoev-profil:xsdElement(.))/@position) ge 1)]">
          <sch:assert role="error" id="NDR-28.004.classic" test="false()">NDR-28.004.classic: Die Position eines Elements (Eigenschaft position des Stereotyps xsdElement) muss eine Zahl größer null sein. Die UML-Eigenschaft <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
      </sch:rule>
   </sch:pattern>

    <sch:pattern id="pattern.NDR-28.005.classic">
      <sch:title>Eindeutige Position eines Elements in einem Baustein</sch:title>      
      <sch:rule context="
            /xmi:XMI/uml:Model/packagedElement[xoev-profil:xsdXModel(.)]//ownedAttribute[(xoev-profil:xsdElement(.) or xoev-profil:xsdLocalStructure(.)) and
            ../(xoev:elements(.), xoev-profil:xsdLocalStructure(.))[@xmi:id != current()/@xmi:id and (xoev-profil:xsdElement(.), xoev-profil:xsdLocalStructure(.))/@position = current()/(xoev-profil:xsdElement(.), xoev-profil:xsdLocalStructure(.))/@position]]">
          <sch:assert role="error" id="NDR-28.005.classic" test="false()">NDR-28.005.classic: Die Position eines Elements (Eigenschaft position des Stereotyps xsdElement) muss innerhalb eines Bausteins (UML-Klasse) eindeutig sein. Die UML-Eigenschaft <sch:value-of select="xgen:model-path(.)"/> besitzt jedoch dieselbe Position wie die folgenden Eigenschaften: <sch:value-of select="../(xoev:elements(.), xoev-profil:xsdLocalStructure(.))[@xmi:id != current()/@xmi:id and (xoev-profil:xsdElement(.), xoev-profil:xsdLocalStructure(.))/@position = current()/(xoev-profil:xsdElement(.), xoev-profil:xsdLocalStructure(.))/@position]/@name"/></sch:assert>
      </sch:rule>
   </sch:pattern>

    <sch:pattern id="pattern.NDR-28.006.classic">
      <sch:title>Keine verschachtelten Definitionen von XML Schema-Definitionen</sch:title>     
      <sch:rule context="
            /xmi:XMI/uml:Model/packagedElement[xoev-profil:xsdXModel(.)]//packagedElement[xoev-profil:xsdSchema(.) and ancestor::packagedElement[xoev-profil:xsdSchema(.)]]">
          <sch:assert role="error" id="NDR-28.006.classic" test="false()">NDR-28.006.classic: XML Schema-Definitionen (UML-Pakete mit dem Stereotyp xsdSchema) dürfen nicht verschachtelt sein. Das XML Schema-Paket <sch:value-of select="xgen:model-path(.)"/> befindet sich jedoch im XML Schema-Paket <sch:value-of select="xgen:model-path(ancestor::packagedElement[xoev-profil:xsdSchema(.)])"/>.</sch:assert>
      </sch:rule>
   </sch:pattern>

    <sch:pattern id="pattern.NDR-28.007.classic">
      <sch:title>Maximal ein Verweis auf einen Typ bei einem globalen Element</sch:title>      
      <sch:rule context="
            /xmi:XMI/uml:Model/packagedElement[xoev-profil:xsdXModel(.)]//packagedElement[(xoev-profil:xsdGlobalElement(.) or xoev-profil:xsdMessage(.)) and count(xoev:dependencies-by-client(.)[xoev-profil:xsdGlobalElementType(.)]) ge 2] |
            /xmi:XMI/uml:Model/packagedElement[xoev-profil:xsdXModel(.)]//nestedClassifer[(xoev-profil:xsdGlobalElement(.) or xoev-profil:xsdMessage(.)) and count(xoev:dependencies-by-client(.)[xoev-profil:xsdGlobalElementType(.)]) ge 2]">
          <sch:assert role="error" id="NDR-28.007.classic" test="false()">NDR-28.007.classic: Globale Elemente (UML-Klassen mit dem Stereotyp xsdGlobalElement) dürfen nicht mehr als einen Typen zugewiesen bekommen (UML-Abhängigkeitsbeziehung mit dem Stereotyp xsdGlobalElementType). Das globale Element <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe. Ihm sind die folgenden Typen zugewiesen: <sch:value-of select="xoev:dependencies-by-client(.)[xoev-profil:xsdGlobalElementType(.)]/uml:resolve-supplier(.)/@name"/></sch:assert>
      </sch:rule>
   </sch:pattern>

    <sch:pattern id="pattern.NDR-28.008.classic">
      <sch:title>Zyklenfreie XML Schema-Definitionen</sch:title>      
      <sch:rule context="
            /xmi:XMI/uml:Model/packagedElement[xoev-profil:xsdXModel(.)]//packagedElement[xoev-profil:xsdSchema(.)] |
            /xmi:XMI/uml:Model/packagedElement[xoev-profil:xsdXModel(.)]//nestedClassifier[xoev-profil:xsdSchema(.)]">
         <sch:let name="schema" value="."/>
         <sch:assert role="error" id="NDR-28.008.classic" test="
          empty($xoev:implicit-and-explicit-package-include-closure//xoev:include[xoev:including/@id = $schema/@xmi:id and $schema/@xmi:id = xoev:included/@id])">NDR-28.008.classic: Eine XML Schema-Definition darf sich nicht direkt oder indirekt selbst inkludieren oder importieren. Das Schema-Paket <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
      </sch:rule>
   </sch:pattern>
   
    <sch:pattern id="pattern.NDR-28.009.classic">
      <sch:title>Nur zwischen xsdSchema-Paketen Abhängigkeiten mit xsdImport oder xsdInclude</sch:title>      
      <sch:rule context="/xmi:XMI/uml:Model/packagedElement[xoev-profil:xsdXModel(.)]//packagedElement[xoev-profil:xsdInclude(.) or xoev-profil:xsdImport(.)]">
          <sch:assert role="error" id="NDR-28.009.classic" test="uml:resolve-supplier(.)[xoev-profil:xsdSchema(.)] and uml:resolve-client(.)[xoev-profil:xsdSchema(.)]">NDR-28.009.classic: XML-Imports (UML-Abhängigkeitsbeziehung mit dem Stereotyp xsdImport) und XML-Includes (UML-Abhängigkeitsbeziehung mit dem Stereotyp xsdInclude) müssen zwei XML Schema-Definitionen (UML-Pakete mit dem Stereotyp xsdSchema) verbinden. <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
      </sch:rule>
   </sch:pattern>

    <sch:pattern id="pattern.NDR-28.010.classic">
      <sch:title>Mit Stereotypen annotierte Klassen in xsdSchema-Paketen</sch:title>      
      <sch:rule context="
            /xmi:XMI/uml:Model/packagedElement[xoev-profil:xsdXModel(.)]//packagedElement[
            xoev-profil:xsdNamedType(.) or xoev-profil:xsdGlobalElementAndNamedType(.) or xoev-profil:xsdChoice(.) or xoev-profil:xsdCode(.) or xoev-profil:xsdGlobalElement(.) or xoev-profil:xsdMessage(.) or xoev-profil:xsdAnyContents(.)]">
          <sch:assert role="error" id="NDR-28.010.classic" test="ancestor::packagedElement[xoev-profil:xsdSchema(.)]">NDR-28.010.classic: UML-Klassen, die mit Stereotypen annotiert sind, müssen sich direkt oder indirekt in einem Schema-Paket (UML-Paket mit dem Stereotyp xsdSchema) befinden. Die Klasse <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
      </sch:rule>
   </sch:pattern>

    <sch:pattern id="pattern.NDR-28.011.classic">
      <sch:title>Mit Stereotypen annotierte Abhängigkeiten in xsdSchema-Paketen</sch:title>      
      <sch:rule context="
            /xmi:XMI/uml:Model/packagedElement[xoev-profil:xsdXModel(.)]//packagedElement[
            xoev-profil:xsdInclude(.) or xoev-profil:xsdImport(.) or xoev-profil:xsdKey(.) or xoev-profil:xsdKeyref(.) or xoev-profil:xsdUnique(.)]">
          <sch:assert role="error" id="NDR-28.011.classic" test="ancestor::packagedElement[xoev-profil:xsdSchema(.)]">NDR-28.011.classic: UML-Abhängigkeitsbeziehungen (Dependencies), die mit Stereotypen annotiert sind, müssen sich direkt oder indirekt in einem Schema-Paket (UML-Paket mit dem Stereotyp xsdSchema) befinden. <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
      </sch:rule>
   </sch:pattern>

    <sch:pattern id="pattern.NDR-28.012.classic">
      <sch:title>Mit Stereotypen annotierte Generalisierungen in xsdSchema-Paketen</sch:title>      
      <sch:rule context="/xmi:XMI/uml:Model/packagedElement[xoev-profil:xsdXModel(.)]//generalization[xoev-profil:xsdRestriction(.)]">
        <sch:assert role="error" id="NDR-28.012.classic" test="ancestor::packagedElement[xoev-profil:xsdSchema(.)]">NDR-28.012.classic: UML-Generalisierungsbeziehungen, die mit Stereotypen annotiert sind, müssen sich direkt oder indirekt in einem Schema-Paket (UML-Paket mit dem Stereotyp xsdSchema) befinden. <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
      </sch:rule>
   </sch:pattern>

    <sch:pattern id="pattern.NDR-28.013.classic">
      <sch:title>Eigenschaften mit xsdAttribute und xsdElement in xsdSchema-Paketen</sch:title>      
      <sch:rule context="/xmi:XMI/uml:Model/packagedElement[xoev-profil:xsdXModel(.)]//ownedAttribute[xoev-profil:xsdElement(.) or xoev-profil:xsdAttribute(.) or xoev-profil:xsdLocalStructure(.)]">
        <sch:assert role="error" id="NDR-28.013.classic" test="ancestor::packagedElement[xoev-profil:xsdSchema(.)]">NDR-28.013.classic: XML-Elemente und -Attribute (UML-Eigenschaften mit dem Stereotyp xsdElement oder xsdAttribute) müssen sich direkt oder indirekt in einem Schema-Paket (UML-Paket mit dem Stereotyp xsdSchema) befinden. Das <sch:value-of select="
                  if (xoev-profil:xsdElement(.)) then
                     'Element '
                  else
                     'Attribut '"/>
            <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
      </sch:rule>
   </sch:pattern>

    <sch:pattern id="pattern.NDR-28.014.classic">
      <sch:title>Klassen mit xsdNamedType oder xsdGlobalElement enthalten nur Eigenschaften mit xsdElement, xsdAttribute oder xsdLocalStructure</sch:title>  
      <sch:rule context="
            /xmi:XMI/uml:Model/packagedElement[xoev-profil:xsdXModel(.)/@standardeinstellungEigenschaften = 'keine']//packagedElement[(xoev-profil:xsdNamedType(.) or xoev-profil:xsdGlobalElementAndNamedType(.) or xoev-profil:xsdGlobalElement(.) or xoev-profil:xsdMessage(.)) and ownedAttribute and not(xoev-profil:xoevVersionCodeliste(.))] |
            /xmi:XMI/uml:Model/packagedElement[xoev-profil:xsdXModel(.)/@standardeinstellungEigenschaften = 'keine']//nestedClassifier[(xoev-profil:xsdNamedType(.) or xoev-profil:xsdGlobalElementAndNamedType(.) or xoev-profil:xsdGlobalElement(.) or xoev-profil:xsdMessage(.)) and ownedAttribute and not(xoev-profil:xoevVersionCodeliste(.))]">
          <sch:assert role="error" id="NDR-28.014.classic" test="count(ownedAttribute[xoev-profil:xsdElement(.) or xoev-profil:xsdAttribute(.) or xoev-profil:xsdLocalStructure(.)]) = count(ownedAttribute)">NDR-28.014.classic: UML-Klassen, die Typen (Stereotyp xsdNamedType) oder globale Elemente (Stereotyp xsdGlobalElement) bzw. beides (Stereotyp xsdGlobalElementAndNamedType) repräsentieren, besitzen ausschließlich Eigenschaften, die XML-Elemente (Stereotyp xsdElement), XML-Attribute (Stereotyp xsdAttribute) oder lokale XML-Strukturen (Stereotyp xsdLocalStructure) repräsentieren. Die Klasse <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
      </sch:rule>
   </sch:pattern>

    <sch:pattern id="pattern.NDR-28.015.classic">
      <sch:title>Nur maximal ein Basistyp bei abgeleiteten Typen und globalen Elementen</sch:title>     
      <sch:rule context="
            /xmi:XMI/uml:Model/packagedElement[xoev-profil:xsdXModel(.)]//packagedElement[uml:is-Class(.) and count(generalization) gt 1] |
            /xmi:XMI/uml:Model/packagedElement[xoev-profil:xsdXModel(.)]//nestedClassifier[uml:is-Class(.) and count(generalization) gt 1]">
        <sch:assert role="error" id="NDR-28.015.classic" test="false()">NDR-28.015.classic: Typen und globale Elemente dürfen von maximal einem Basistypen ableiten. Die Klasse <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
      </sch:rule>
   </sch:pattern>

    <sch:pattern id="pattern.NDR-28.016.classic">
      <sch:title>xsdGlobalElement und xsdAnyContents schließen sich gegenseitig aus</sch:title>      
      <sch:rule context="
            /xmi:XMI/uml:Model/packagedElement[xoev-profil:xsdXModel(.)]//packagedElement[(xoev-profil:xsdGlobalElement(.) or xoev-profil:xsdMessage(.) or xoev-profil:xsdGlobalElementAndNamedType(.)) and xoev-profil:xsdAnyContents(.)] |
            /xmi:XMI/uml:Model/packagedElement[xoev-profil:xsdXModel(.)]//nestedClassifier[(xoev-profil:xsdGlobalElement(.) or xoev-profil:xsdMessage(.) or xoev-profil:xsdGlobalElementAndNamedType(.)) and xoev-profil:xsdAnyContents(.)]">
          <sch:assert role="error" id="NDR-28.016.classic" test="false()">NDR-28.016.classic: Globale Elemente (UML-Klassen mit dem Stereotyp xsdGlobalElement) dürfen nicht gleichzeitig mit dem Stereotypen xsdAnyContents annotiert sein. Die Klasse <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
      </sch:rule>
   </sch:pattern>

    <sch:pattern id="pattern.NDR-28.017.classic">
      <sch:title>xsdAnyContents schließt xsdGlobalElement, xsdCode oder xsdChoice aus</sch:title>      
      <sch:rule context="
            /xmi:XMI/uml:Model/packagedElement[xoev-profil:xsdXModel(.)]//packagedElement[xoev-profil:xsdAnyContents(.) and
            (xoev-profil:xsdGlobalElement(.), xoev-profil:xsdMessage(.), xoev-profil:xsdCode(.), xoev-profil:xsdChoice(.))] |
            /xmi:XMI/uml:Model/packagedElement[xoev-profil:xsdXModel(.)]//nestedClassifier[xoev-profil:xsdAnyContents(.) and
            (xoev-profil:xsdGlobalElement(.), xoev-profil:xsdMessage(.), xoev-profil:xsdCode(.), xoev-profil:xsdChoice(.))]">
          <sch:assert role="error" id="NDR-28.017.classic" test="false()">NDR-28.017.classic: Any-Elemente (UML-Klassen mit dem Stereotyp xsdAnyContents) dürfen nicht gleichzeitig mit den Stereotypen xsdGlobalElement, xsdCode oder xsdChoice annotiert sein. Die Klasse <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
      </sch:rule>
   </sch:pattern>

    <sch:pattern id="pattern.NDR-28.018.classic">
      <sch:title>xsdChoice schließt xsdAnyContents und xsdCode aus</sch:title>     
      <sch:rule context="
            /xmi:XMI/uml:Model/packagedElement[xoev-profil:xsdXModel(.)]//packagedElement[xoev-profil:xsdChoice(.) and
            (xoev-profil:xsdAnyContents(.), xoev-profil:xsdCode(.))] |
            /xmi:XMI/uml:Model/packagedElement[xoev-profil:xsdXModel(.)]//nestedClassifier[xoev-profil:xsdChoice(.) and
            (xoev-profil:xsdAnyContents(.), xoev-profil:xsdCode(.))]">
          <sch:assert role="error" id="NDR-28.018.classic" test="false()">NDR-28.018.classic: XML-Choices (UML-Klassen mit dem Stereotyp xsdChoice) dürfen nicht gleichzeitig mit den Stereotypen xsdAnyContents oder xsdCode annotiert sein. Die Klasse <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
      </sch:rule>
   </sch:pattern>

    <sch:pattern id="pattern.NDR-28.019.classic">
      <sch:title>xsdCode schließt xsdGlobalElement, xsdAnyContents und xsdChoice aus</sch:title>      
      <sch:rule context="
            /xmi:XMI/uml:Model/packagedElement[xoev-profil:xsdXModel(.)]//packagedElement[xoev-profil:xsdCode(.) and
            (xoev-profil:xsdGlobalElement(.), xoev-profil:xsdMessage(.), xoev-profil:xsdAnyContents(.), xoev-profil:xsdChoice(.))] |
            /xmi:XMI/uml:Model/packagedElement[xoev-profil:xsdXModel(.)]//nestedClassifier[xoev-profil:xsdCode(.) and
            (xoev-profil:xsdGlobalElement(.), xoev-profil:xsdMessage(.), xoev-profil:xsdAnyContents(.), xoev-profil:xsdChoice(.))]">
          <sch:assert role="error" id="NDR-28.019.classic" test="false()">NDR-28.019.classic: Code-Datentypen (UML-Klassen mit dem Stereotyp xsdCode) dürfen nicht gleichzeitig mit den Stereotypen xsdGlobalElement, xsdAnyContents oder xsdChoice annotiert sein. Die Klasse <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
      </sch:rule>
   </sch:pattern>

    <sch:pattern id="pattern.NDR-28.020.classic">
      <sch:title>xsdGlobalElement oder xsdMessage nur an Klassen oder Enumerationen</sch:title>      
      <sch:rule context="
            /xmi:XMI/uml:Model/packagedElement[xoev-profil:xsdXModel(.)]//packagedElement[(xoev-profil:xsdGlobalElement(.) or xoev-profil:xsdMessage(.)) and not(uml:is-Class(.) or uml:is-Enumeration(.))] |
            /xmi:XMI/uml:Model/packagedElement[xoev-profil:xsdXModel(.)]//nestedClassifier[(xoev-profil:xsdGlobalElement(.) or xoev-profil:xsdMessage(.)) and not(uml:is-Class(.) or uml:is-Enumeration(.))]">
          <sch:assert role="error" id="NDR-28.020.classic" test="false()">NDR-28.020.classic: Globale Elemente müssen UML-Klassen oder UML-Enumerationen sein. Das UML-Element <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
      </sch:rule>
   </sch:pattern>

    <sch:pattern id="pattern.NDR-28.021.classic">
      <sch:title>Assoziation spezifiziert Eigenschaft in demselben Paket</sch:title>      
      <sch:rule context="
            /xmi:XMI/uml:Model/packagedElement[xoev-profil:xsdXModel(.)]//ownedAttribute[uml:resolve-association(.)]">
        <sch:assert role="information" id="NDR-28.021.classic" test="
          ancestor::packagedElement[uml:is-Package(.)][1] = uml:resolve-association(.)/ancestor::packagedElement[uml:is-Package(.)][1]">NDR-28.021.classic: Es wird empfohlen, dass eine UML-Assoziation (i. d. R. eine Komposition) im selben Paket wie die über die Assoziation spezifizierte Eigenschaft vorliegt. Die Eigenschaft (Assoziationsende) <sch:value-of select="xgen:model-path(.)"/> hält diese Empfehlung nicht ein.</sch:assert>
      </sch:rule>
   </sch:pattern>

  <sch:pattern id="pattern.classic.003">
      <sch:title>Keine Wiederverwendung von xoevCodelisteneintragDeprecated-Codelisteneinträgen</sch:title>
      <sch:rule context="uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//packagedElement[uml:is-InstanceSpecification(.) and xoev-profil:xoevCodelisteneintragDeprecated(.)] | uml:Model/packagedElement[uml:is-InstanceSpecification(.) and xoev-profil:xoevCodelisteneintragDeprecated(.)]">
         <sch:let name="eintrag" value="."/>
         <sch:let name="eintraege" value="ancestor::packagedElement[xoev-profil:xsdXModel(.)]//packagedElement[@xmi:id != $eintrag/@xmi:id and uml:is-InstanceSpecification(.) and @classifier = $eintrag/@classifier and not(xoev-profil:xoevCodelisteneintragDeprecated(.))]"/>
          <sch:assert role="error" id="classic.003" test="
               every $own-slot in $eintrag/slot[uml:resolve-definingFeature(.)/xoev-profil:xoevCodelistenspalte(.)/@codeSpalte = 'true']
                  satisfies (
                  every $other-slot in $eintraege/slot[uml:resolve-definingFeature(.)/@xmi:id = $own-slot/uml:resolve-definingFeature(.)/@xmi:id]
                     satisfies
                     not($own-slot/value/@value/normalize-space(.) = $other-slot/value/@value/normalize-space(.)))">classic.003: Codes in Codelisteneinträgen, die als veraltet gekennzeichnet sind (UML-Objekte mit dem Stereotyp xoevCodelisteneintragDeprecated), dürfen nicht in anderen Codelisteneinträgen derselben Codelistenversion wiederverwendet werden. Der Codelisteneintrag mit den Codes <sch:value-of select="$eintrag/slot[uml:resolve-definingFeature(.)/xoev-profil:xoevCodelistenspalte(.)/@codeSpalte = 'true']/value/@value/normalize-space(.)"/> verletzt diese Vorgabe.</sch:assert>
      </sch:rule>
   </sch:pattern>
   
   <sch:pattern id="pattern.schematron.classic.001">
      <sch:title>schRuleSet-Klasse hat mindestens eine schContext-Abhängigkeit</sch:title>
      <sch:rule context="
         uml:Model/packagedElement[xoev-profil:xsdXModel(.)]//packagedElement[xoev-profil:schRuleSet(.) and not(xoev:dependencies-by-client(.)[xoev-profil:schContext(.)])] |
         uml:Model/packagedElement[xoev-profil:xsdXModel(.)]//nestedClassifier[xoev-profil:schRuleSet(.) and not(xoev:dependencies-by-client(.)[xoev-profil:schContext(.)])]">
          <sch:assert role="error" id="schematron.classic.001" test="false()">schematron.classic.001: Ein Schematron Rule Set (UML-Klasse mit dem Stereotyp schRuleSet) muss mindestens einen Fachkontext haben (von der UML-Klasse ausgehende UML-Abhängigkeitsbeziehung mit dem Stereotyp schContext). Die Klasse <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
      </sch:rule>
   </sch:pattern>
   
    <sch:pattern id="pattern.schematron.classic.002">
      <sch:title>schContext-Abhängigkeitsbeziehung beginnt bei schRuleSet-Klasse</sch:title>
      <sch:rule context="uml:Model/packagedElement[xoev-profil:xsdXModel(.)]//packagedElement[xoev-profil:schContext(.) and uml:resolve-client(.)[not(xoev-profil:schRuleSet(.))]]">
          <sch:assert role="error" id="schematron.classic.002" test="false()">schematron.classic.002: Eine Schematron Fachkontext-Beziehung (UML-Abhängigkeitsbeziehung mit dem Stereotyp schContext) muss bei einem Rule Set (UML-Klasse mit dem Stereotyp schRuleSet) beginnen. <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
      </sch:rule>
   </sch:pattern>
   
  <sch:pattern id="pattern.schematron.classic.003">
      <sch:title>schContext-Abhängigkeitsbeziehung endet bei Klasse oder Eigenschaft</sch:title>
      <sch:rule context="
         uml:Model/packagedElement[xoev-profil:xsdXModel(.)]//packagedElement[
         xoev-profil:schContext(.) and uml:resolve-supplier(.)[not(uml:is-Class(.) or uml:is-Property(.))]]">
          <sch:assert role="error" id="schematron.classic.003" test="false()">schematron.classic.003: Eine Schematron Fachkontext-Beziehung (UML-Abhängigkeitsbeziehung mit dem Stereotyp schContext) muss bei einer UML-Klasse oder -Eigenschaft enden. <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
      </sch:rule>
   </sch:pattern>
   
   
   
   


  <sch:pattern id="pattern.NDR-28.022.classic">
      <sch:title>Codelisten haben einen Namen</sch:title>      
      <sch:rule context="
            /xmi:XMI/uml:Model/packagedElement[xoev-profil:xsdXModel(.)]//packagedElement[xoev-profil:xoevCodeliste(.) and xoev-profil:xsdNamedType(.) and @name = ''] |
            /xmi:XMI/uml:Model/packagedElement[xoev-profil:xsdXModel(.)]//nestedClassifier[xoev-profil:xoevCodeliste(.) and xoev-profil:xsdNamedType(.) and @name = '']">
          <sch:assert role="error" id="NDR-28.022.classic" test="false()">NDR-28.022.classic: Benannte Codelisten (UML-Enumerationen mit den Stereotypen xoevCodeliste und xsdNamedType) müssen einen Namen (Name der UML-Enumeration) besitzen. Im Paket <sch:value-of select="xgen:model-path(parent::packagedElement)"/> befindet sich jedoch eine Codeliste ohne einen solchen Namen.</sch:assert>
      </sch:rule>
   </sch:pattern>

    <sch:pattern id="pattern.NDR-28.023.classic">
      <sch:title>Basistyp einer Codeliste ist ein einfacher Datentyp</sch:title>      
      <sch:rule context="
            /xmi:XMI/uml:Model/packagedElement[xoev-profil:xsdXModel(.)]//packagedElement[
            xoev-profil:xsdCodeList(.)/xoev:resolve-base(.)[not(xoev:topmost-parent(.)/parent::packagedElement/@name = 'W3C Data Types') or xoev:allElements(.) or xoev:allAttributes(.)]] |
            /xmi:XMI/uml:Model/packagedElement[xoev-profil:xsdXModel(.)]//nestedClassifier[
            xoev-profil:xsdCodeList(.)/xoev:resolve-base(.)[not(xoev:topmost-parent(.)/parent::packagedElement/@name = 'W3C Data Types') or xoev:allElements(.) or xoev:allAttributes(.)]]">
          <sch:assert role="error" id="NDR-28.023.classic" test="false()">NDR-28.023.classic: Der Basistyp einer Codeliste (Eigenschaft base des Stereotyps xsdCodeList) muss ein einfacher Datentyp sein. Die Codeliste <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe. Der Basistyp der Codeliste ist <sch:value-of select="xoev-profil:xsdCodeList(.)/xoev:resolve-base(.)/xgen:model-path(.)"/>.</sch:assert>
      </sch:rule>
   </sch:pattern>

    <sch:pattern id="pattern.NDR-28.024.classic">
      <sch:title>Basistyp einer Codeliste ist token oder ein von token abgeleiteter Datentyp</sch:title>      
      <sch:rule context="
            /xmi:XMI/uml:Model/packagedElement[xoev-profil:xsdXModel(.)]//packagedElement[xoev-profil:xsdCodeList(.)/xoev:resolve-base(.)[empty((., xoev:allParents(.))[@name = 'token'])]] |
            /xmi:XMI/uml:Model/packagedElement[xoev-profil:xsdXModel(.)]//nestedClassifier[xoev-profil:xsdCodeList(.)/xoev:resolve-base(.)[empty((., xoev:allParents(.))[@name = 'token'])]]">
          <sch:assert role="error" id="NDR-28.024.classic" test="false()">NDR-28.024.classic: Der Basistyp einer Codeliste (Eigenschaft des Stereotyps xsdCodeList) muss xs:token oder einem davon abgeleiteten Datentypen entsprechen. Die Codeliste <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe. Der Basistyp der Codeliste ist <sch:value-of select="xoev-profil:xsdCodeList(.)/xoev:resolve-base(.)/xgen:model-path(.)"/>.</sch:assert>
      </sch:rule>
   </sch:pattern>

    <sch:pattern id="pattern.classic.004">
      <sch:title>xeovVersionCodeliste-Klasse hat Abhängigkeit zu xoevCodeliste-Klasse</sch:title>
      <sch:rule context="uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//packagedElement[uml:is-Class(.) and xoev-profil:xoevVersionCodeliste(.) and not(xoev-profil:xsdDraft(.))]">
        <sch:assert role="error" id="classic.004" test="xoev:dependencies-by-client(.)/uml:resolve-supplier(.)/xoev-profil:xoevCodeliste(.)">classic.004: Eine Codelistenversion (UML-Klasse mit dem Stereotyp xoevVersionCodeliste) muss mittels einer UML-Abhängigkeitsbeziehung mit einer Codeliste (UML-Klasse mit dem Stereotyp xoevCodeliste) verbunden sein. Die Codelistenversion <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
      </sch:rule>
   </sch:pattern>

    <sch:pattern id="pattern.classic.005">
      <sch:title>xoevCodelistenspalte-Eigenschaft gehört zu xoevVersionCodeliste-Klasse</sch:title>
      <sch:rule context="uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//ownedAttribute[xoev-profil:xoevCodelistenspalte(.) and not(xoev-profil:xsdDraft(parent::*))]">
          <sch:assert role="error" id="classic.005" test="parent::*/xoev-profil:xoevVersionCodeliste(.)">classic.005: Eine UML-Eigenschaft mit dem Stereotyp xoevCodelistenspalte gehört zu einer Codelistenversion (UML-Klasse mit dem Stereotyp xoevVersionCodeliste). Die Codelistenspalte <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
      </sch:rule>
   </sch:pattern>

    <sch:pattern id="pattern.classic.006">
      <sch:title>xoevVersionCodeliste-Klasse hat xoevCodelistenspalte-Eigenschaften</sch:title>
      <sch:rule context="uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//packagedElement[uml:is-Class(.) and xoev-profil:xoevVersionCodeliste(.) and not(xoev-profil:xsdDraft(.))]">
          <sch:assert role="error" id="classic.006" test="
               every $p in ownedAttribute
                satisfies $p/xoev-profil:xoevCodelistenspalte(.)">classic.006: Die UML-Eigenschaften einer Codelistenversion (UML-Klasse mit dem Stereotyp xoevVersionCodeliste) sind mit dem Stereotyp xoevCodelistenspalte versehen. Die Codelistenversion <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
      </sch:rule>
   </sch:pattern>

    <sch:pattern id="pattern.classic.007">
      <sch:title>Empfohlene Codespalte ist allgemeine Codespalte</sch:title>
      <sch:rule context="uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//ownedAttribute[xoev-profil:xoevCodelistenspalte(.) and not(xoev-profil:xsdDraft(parent::*))]">
          <sch:assert role="error" id="classic.007" test="not(xoev-profil:xoevCodelistenspalte(.)/@empfohleneCodeSpalte = 'true') or xoev-profil:xoevCodelistenspalte(.)/@codeSpalte = 'true'">classic.007: Eine empfohlene Code-Spalte (UML-Eigenschaft mit dem Stereotyp xoevCodelistenspalte und der Stereotypeigenschaft empfohleneCodeSpalte = 'true') ist immer auch eine allgemeine Code-Spalte (Stereotypeigenschaft codeSpalte = 'true'). Die Codelistenspalte <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
      </sch:rule>
   </sch:pattern>

    <sch:pattern id="pattern.classic.008">
      <sch:title>Code-Datentyp nutzt keine Codeliste oder Codelisten-Version im Entwurf</sch:title>
      <sch:rule context="uml:Model/packagedElement[xoev-profil:xsdXModel(.)]//packagedElement[uml:is-Class(.) and xoev:usages-by-client(.)/uml:resolve-supplier(.)/xoev-profil:xoevVersionCodeliste(.) and not(xoev-profil:xsdDraft(.))] | uml:Model/packagedElement[xoev-profil:xsdXModel(.)]//nestedClassifier[uml:is-Class(.) and xoev:usages-by-client(.)/uml:resolve-supplier(.)/xoev-profil:xoevVersionCodeliste(.) and not(xoev-profil:xsdDraft(.))]">
          <sch:assert role="error" id="classic.008" test="
               not(xoev:usages-by-client(.)/uml:resolve-supplier(.)/xoev-profil:xsdDraft(.)) and
                not(xoev:usages-by-client(.)/uml:resolve-supplier(.)/xoev:dependencies-by-client(.)/uml:resolve-supplier(.)/xoev-profil:xsdDraft(.))">classic.008: Ein produktiv eingesetzter Code-Datentyp darf keine durch den Stereotyp xsdDraft als Entwurf gekennzeichnete Codeliste oder Codelistenversion nutzen (Code-Typ 1 und 2). Der Code-Datentyp <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
      </sch:rule>
   </sch:pattern>

    <sch:pattern id="pattern.classic.009">
      <sch:title>Code-Datentyp nutzt keine Codeliste im Entwurf</sch:title>
      <sch:rule context="uml:Model/packagedElement[xoev-profil:xsdXModel(.)]//packagedElement[uml:is-Class(.) and xoev:usages-by-client(.)/uml:resolve-supplier(.)/xoev-profil:xoevCodeliste(.) and not(xoev-profil:xsdDraft(.))] | uml:Model/packagedElement[xoev-profil:xsdXModel(.)]//nestedClassifier[uml:is-Class(.) and xoev:usages-by-client(.)/uml:resolve-supplier(.)/xoev-profil:xoevCodeliste(.) and not(xoev-profil:xsdDraft(.))]">
          <sch:assert role="error" id="classic.009" test="not(xoev:usages-by-client(.)/uml:resolve-supplier(.)/xoev-profil:xsdDraft(.))">classic.009: Ein produktiv eingesetzter Code-Datentyp darf keine durch den Stereotyp xsdDraft als Entwurf gekennzeichnete Codeliste nutzen (Code-Typ 3). Der Code-Datentyp <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
      </sch:rule>
   </sch:pattern>

  <sch:pattern id="pattern.classic.010">
      <sch:title>xoevCodeTyp1- und xoevCodeTyp2-Usage-Beziehungen enden bei xoevVersionCodeliste-Klasse</sch:title>
      <sch:rule context="uml:Model/packagedElement[xoev-profil:xsdXModel(.)]//packagedElement[uml:is-Usage(.) and (xoev-profil:xoevCodeTyp1(.) or xoev-profil:xoevCodeTyp2(.))] | uml:Model/packagedElement[xoev-profil:xsdXModel(.)]//nestedClassifier[uml:is-Usage(.) and (xoev-profil:xoevCodeTyp1(.) or xoev-profil:xoevCodeTyp2(.))]">
          <sch:assert role="error" id="classic.010" test="uml:resolve-supplier(.)/xoev-profil:xoevVersionCodeliste(.)">classic.010: Usage-Beziehungen mit dem Stereotyp xoevCodeTyp1 oder xoevCodeTyp2 müssen bei einer Codelistenversion (UML-Klasse mit dem Stereotyp xoevVersionCodeliste) enden. <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
      </sch:rule>
   </sch:pattern>

    <sch:pattern id="pattern.classic.011">
      <sch:title>Usage-Beziehungen ohne xoevCodeTyp1 und xoevCodeTyp2 enden bei xoevCodeliste-Klasse</sch:title>
      <sch:rule context="uml:Model/packagedElement[xoev-profil:xsdXModel(.)]//packagedElement[uml:is-Usage(.) and (not(xoev-profil:xoevCodeTyp1(.) or xoev-profil:xoevCodeTyp2(.))) and uml:resolve-client(.)[not(xoev-profil:xoevCodeTyp4(.))]] | uml:Model/packagedElement[xoev-profil:xsdXModel(.)]//nestedClassifier[uml:is-Usage(.) and (not(xoev-profil:xoevCodeTyp1(.) or xoev-profil:xoevCodeTyp2(.))) and uml:resolve-client(.)[not(xoev-profil:xoevCodeTyp4(.))]]">
          <sch:assert role="error" id="classic.011" test="uml:resolve-supplier(.)/xoev-profil:xoevCodeliste(.)">classic.011: Usage-Beziehungen ohne Stereotyp bzw. mit dem Stereotyp xoevCodeTyp3 müssen bei einer Codeliste (UML-Klasse mit dem Stereotyp xoevCodeliste) enden. Hinweis: Usage-Beziehungen ohne Stereotyp sind ebenfalls im Kontext der Nutzungsart 4 erlaubt. <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
      </sch:rule>
   </sch:pattern>

    <sch:pattern id="pattern.classic.012">
      <sch:title>Klassen für Code-Datentypen ohne Eigenschaften</sch:title>
      <sch:rule context="uml:Model/packagedElement[xoev-profil:xsdXModel(.)]//packagedElement[uml:is-Class(.) and (xoev-profil:xoevCodeTyp4(.) or xoev:usages-by-client(.))] | uml:Model/packagedElement[xoev-profil:xsdXModel(.)]//nestedClassifier[uml:is-Class(.) and (xoev-profil:xoevCodeTyp4(.) or xoev:usages-by-client(.))]">
          <sch:assert role="error" id="classic.012" test="empty(xoev:allElements(.)) and empty(xoev:allAttributes(.))">classic.012: Im XÖV-Fachmodell modellierte Code-Datentypen (UML-Klassen mit dem Stereotyp xoevCodeTyp4 oder einer ausgehenden Usage-Beziehung) haben keine Eigenschaften (XML-Attribute oder -Elemente). Die UML-Klasse <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
      </sch:rule>
   </sch:pattern>

  <sch:pattern id="pattern.classic.013">
      <sch:title>xoevCodeTyp1 und xoevCodeTyp2 schließen sich gegenseitig aus</sch:title>
      <sch:rule context="uml:Model/packagedElement[xoev-profil:xsdXModel(.)]//packagedElement[uml:is-Usage(.) and xoev-profil:xoevCodeTyp1(.) and xoev-profil:xoevCodeTyp2(.)] | uml:Model/packagedElement[xoev-profil:xsdXModel(.)]//nestedClassifier[uml:is-Usage(.) and xoev-profil:xoevCodeTyp1(.) and xoev-profil:xoevCodeTyp2(.)]">
          <sch:assert role="error" id="classic.013" test="false()">classic.013: Die Stereotypen xoevCodeTyp1 und xoevCodeTyp2 schließen sich gegenseitig aus. <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
      </sch:rule>
   </sch:pattern>

    <sch:pattern id="pattern.classic.014">
      <sch:title>Usage-Beziehungen zu xoevVersionCodeliste-Klassen mit xoevCodeTyp1 oder xoevCodeTyp2</sch:title>
      <sch:rule context="uml:Model/packagedElement[xoev-profil:xsdXModel(.)]//packagedElement[uml:is-Usage(.) and uml:resolve-supplier(.)/xoev-profil:xoevVersionCodeliste(.) and uml:resolve-client(.)[not(xoev-profil:xoevCodeTyp4(.))]] | uml:Model/packagedElement[xoev-profil:xsdXModel(.)]//nestedClassifier[uml:is-Usage(.) and uml:resolve-supplier(.)/xoev-profil:xoevVersionCodeliste(.) and uml:resolve-client(.)[not(xoev-profil:xoevCodeTyp4(.))]]">
          <sch:assert role="error" id="classic.014" test="xoev-profil:xoevCodeTyp1(.) or xoev-profil:xoevCodeTyp2(.)">classic.014: Usage-Beziehungen zu Codelistenversionen (UML-Klassen mit dem Stereotyp xoevVersionCodeliste) müssen den Stereotyp xoevCodeTyp1 oder xoevCodeTyp2 haben, sofern es sich nicht um die Nutzungsart 4 handelt. <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
      </sch:rule>
   </sch:pattern>

    <sch:pattern id="pattern.classic.015">
      <sch:title>Keine Mehrfachbeziehungen zwischen Code-Datentypen und Codelisten bzw. Codelistenversionen</sch:title>
      <sch:rule context="
            uml:Model/packagedElement[xoev-profil:xsdXModel(.)]//packagedElement[uml:is-Class(.) and not(xoev-profil:xoevCodeTyp4(.)) and count(xoev:usages-by-client(.)/uml:resolve-supplier(.)[xoev-profil:xoevCodeliste(.) or xoev-profil:xoevVersionCodeliste(.)]) gt 1] |
            uml:Model/packagedElement[xoev-profil:xsdXModel(.)]//nestedClassifier[uml:is-Class(.) and not(xoev-profil:xoevCodeTyp4(.)) and count(xoev:usages-by-client(.)/uml:resolve-supplier(.)[xoev-profil:xoevCodeliste(.) or xoev-profil:xoevVersionCodeliste(.)]) gt 1]">
          <sch:assert role="error" id="classic.015" test="false()">classic.015: Von einem Code-Datentyp darf maximal eine Usage-Beziehung zur selben oder zu unterschiedlichen Codelisten bzw. Codelistenversionen ausgehen. <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
      </sch:rule>
   </sch:pattern>

    <sch:pattern id="pattern.classic.016">
      <sch:title>genutzteCodeSpalte ist Code-Spalte der genutzten xoevVersionCodeliste-Klasse</sch:title>
      <sch:rule context="uml:Model/packagedElement[xoev-profil:xsdXModel(.)]//packagedElement[uml:is-Usage(.) and (xoev-profil:xoevCodeTyp1(.)/@genutzteCodeSpalte or xoev-profil:xoevCodeTyp2(.)/@genutzteCodeSpalte) and uml:resolve-supplier(.)/xoev-profil:xoevVersionCodeliste(.)] | uml:Model/packagedElement[xoev-profil:xsdXModel(.)]//nestedClassifier[uml:is-Usage(.) and (xoev-profil:xoevCodeTyp1(.)/@genutzteCodeSpalte or xoev-profil:xoevCodeTyp2(.)/@genutzteCodeSpalte) and uml:resolve-supplier(.)/xoev-profil:xoevVersionCodeliste(.)]">
          <sch:assert role="error" id="classic.016" test="
           (xoev-profil:xoevCodeTyp1(.), xoev-profil:xoevCodeTyp2(.))/@genutzteCodeSpalte = uml:resolve-supplier(.)/ownedAttribute[xoev-profil:xoevCodelistenspalte(.)/@codeSpalte = 'true']/@xmi:id">classic.016: Die über die Eigenschaft genutzteCodeSpalte der Stereotypen xoevCodeTyp1 oder xoevCodeTyp2 bestimmte Spalte muss eine Code-Spalte (UML-Eigenschaft mit Eigenschaft xoevCodelistenspalte/codeSpalte = true) der genutzten Codelistenversion (UML-Klasse mit dem Stereotyp xoevVersionCodeliste) sein. <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
      </sch:rule>
   </sch:pattern>

    <sch:pattern id="pattern.classic.017">
      <sch:title>genutzteBeschreibungspalte ist Spalte der genutzten xoevVersionCodeliste-Klasse</sch:title>
      <sch:rule context="uml:Model/packagedElement[xoev-profil:xsdXModel(.)]//packagedElement[uml:is-Usage(.) and (xoev-profil:xoevCodeTyp1(.)/@genutzteBeschreibungsspalte or xoev-profil:xoevCodeTyp2(.)/@genutzteBeschreibungsspalte) and uml:resolve-supplier(.)/xoev-profil:xoevVersionCodeliste(.)] | uml:Model/packagedElement[xoev-profil:xsdXModel(.)]//nestedClassifier[uml:is-Usage(.) and (xoev-profil:xoevCodeTyp1(.)/@genutzteBeschreibungsspalte or xoev-profil:xoevCodeTyp2(.)/@genutzteBeschreibungsspalte) and uml:resolve-supplier(.)/xoev-profil:xoevVersionCodeliste(.)]">
          <sch:assert role="error" id="classic.017" test="
          (xoev-profil:xoevCodeTyp1(.), xoev-profil:xoevCodeTyp2(.))/@genutzteBeschreibungsspalte = uml:resolve-supplier(.)/ownedAttribute/@xmi:id">classic.017: Die über die Eigenschaft genutzteBeschreibungsspalte der Stereotypen xoevCodeTyp1 oder xoevCodeTyp2 bestimmte Spalte muss eine Spalte (UML-Eigenschaft mit Eigenschaft xoevCodelistenspalte/codeSpalte = true) der genutzten Codelistenversion (UML-Klasse mit dem Stereotyp xoevVersionCodeliste) sein. <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
      </sch:rule>
   </sch:pattern>

    <sch:pattern id="pattern.classic.018">
      <sch:title>typDesCodeElements ist token oder ein von token abgeleiteter Datentyp</sch:title>
      <sch:rule context="uml:Model/packagedElement[xoev-profil:xsdXModel(.)]//packagedElement[(xoev-profil:xoevCodeTyp1(.), xoev-profil:xoevCodeTyp2(.), xoev-profil:xoevCodeTyp3(.), xoev-profil:xoevCodeTyp4(.))/xoev:resolve-typDesCodeElements(.)] | uml:Model/packagedElement[xoev-profil:xsdXModel(.)]//nestedClassifier[(xoev-profil:xoevCodeTyp1(.), xoev-profil:xoevCodeTyp2(.), xoev-profil:xoevCodeTyp3(.), xoev-profil:xoevCodeTyp4(.))/xoev:resolve-typDesCodeElements(.)]">
         <sch:let name="typ" value="xoev:resolve-typDesCodeElements((xoev-profil:xoevCodeTyp1(.), xoev-profil:xoevCodeTyp2(.), xoev-profil:xoevCodeTyp3(.), xoev-profil:xoevCodeTyp4(.)))"/>
          <sch:assert role="error" id="classic.018" test="
           root()/descendant::packagedElement[xoev-profil:xoevDatentyp(.)/@kennung = 'urn:xoev-de:kosit:xoev:datentyp:code']/ownedAttribute[@name = 'code']/uml:resolve-type(.)/@xmi:id = ($typ, xoev:allParents($typ))/@xmi:id">classic.018: Der über die Eigenschaft typDesCodeElements der Stereotypen xoevCodeTyp1 bis xoevCodeTyp4 bestimmte Datentyp muss xs:token oder ein davon abgeleiteter Datentyp sein. <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
      </sch:rule>
   </sch:pattern>

   <sch:pattern id="pattern.C-CLH-1.0-R1">
      <sch:title>xoevVersionCodeliste-Klasse hat mindestens eine xoevCodelistenspalte-Eigenschaft mit codeSpalte = true</sch:title>
      <sch:rule context="uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//packagedElement[uml:is-Class(.) and xoev-profil:xoevVersionCodeliste(.) and not(xoev-profil:xsdDraft(.))]">
        <sch:assert role="error" id="C-CLH-1.0-R1" test="ownedAttribute[xoev-profil:xoevCodelistenspalte(.)/@codeSpalte = 'true']">C-CLH-1.0-R1: Eine Codelistenversion (UML-Klasse mit dem Stereotyp xoevVersionCodeliste) muss mindestens eine Code-Spalte (UML-Eigenschaft mit dem Stereotyp xoevCodelistenspalte und der Stereotypeigenschaft codeSpalte = 'true') besitzen. Die Codelistenversion <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
      </sch:rule>
   </sch:pattern>

   <sch:pattern id="pattern.C-CLH-1.0-R3">
      <sch:title>verwendung ist bei Code-Spalten required</sch:title>
      <sch:rule context="uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//ownedAttribute[xoev-profil:xoevCodelistenspalte(.)/@codeSpalte = 'true']">
        <sch:assert role="error" id="C-CLH-1.0-R3" test="xoev-profil:xoevCodelistenspalte(.)/@verwendung = 'required'">C-CLH-1.0-R3: Das Metadatenelement Verwendung (Eigenschaft verwendung des Stereotyps xoevCodelistenspalte) muss bei Code-Spalten (UML-Eigenschaft mit dem Stereotyp xoevVersionCodeliste und der Stereotypeigenschaft codeSpalte = true) auf "required" gesetzt werden. Die Codelistenspalte <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
      </sch:rule>
   </sch:pattern>

   <sch:pattern id="pattern.C-CLH-1.0-R4">
      <sch:title>Code-Spalte hat in jedem Codelisteneintrag einen Wert</sch:title>
      <sch:rule context="uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//ownedAttribute[xoev-profil:xoevCodelistenspalte(.)/@verwendung = 'required']">
         <sch:let name="spalte" value="."/>
         <sch:let name="instanzen" value="ancestor::packagedElement[xoev-profil:xsdXModel(.)]//packagedElement[uml:is-InstanceSpecification(.) and @classifier = $spalte/parent::*/@xmi:id and not(xoev-profil:xoevCodelisteneintragDeprecated(.))]"/>
         <sch:assert role="error" id="C-CLH-1.0-R4" test="
               every $instanz in $instanzen
               satisfies $instanz/slot[uml:resolve-definingFeature(.)/@xmi:id = $spalte/@xmi:id]/value/@value">C-CLH-1.0-R4: Eine Spalte mit der Verwendung "required" (UML-Eigenschaft mit dem Stereotyp xoevVersionCodeliste und der Stereotypeigenschaft verwendung = 'required') muss in jedem Codelisteneintrag (UML-Objekt der UML-Klasse der Codelistenversion) mit einem Wert belegt sein. Die Codelistenspalte <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
      </sch:rule>
   </sch:pattern>

   <sch:pattern id="pattern.C-CLH-1.0-R5">
      <sch:title>Nur erlaubte Zeichen im technischen Namen von Codelisten</sch:title>
      <sch:rule context="uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//packagedElement[xoev-profil:xoevCodeliste(.) and not(xoev-profil:xsdDraft(.))] | uml:Model/packagedElement[xoev-profil:xsdXModel(.)]//nestedClassifier[xoev-profil:xoevCodeliste(.) and not(xoev-profil:xsdDraft(.))]">
        <sch:assert role="error" id="C-CLH-1.0-R5" test="replace(xoev-profil:xoevCodeliste(.)/@nameTechnisch, '[a-zA-Z0-9\.\-]', '') = ''">C-CLH-1.0-R5: Der Name (technisch) einer Codeliste (UML-Klasse mit dem Stereotyp xoevCodeliste und der Stereotypeigenschaft nameTechnisch) darf nur die Zeichen "A-Z", "a-z", "0-9", "-" und "." enthalten. Die Codeliste <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
      </sch:rule>
   </sch:pattern>

   <sch:pattern id="pattern.C-XOEV-R6">
      <sch:title>Nur erlaubte Version von XÖV-Handbuch oder Codelisten-Handbuch zu einer Codeliste</sch:title>
      <sch:rule context="uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//packagedElement[xoev-profil:xoevVersionCodeliste(.) and not(xoev-profil:xsdDraft(.))] | uml:Model/packagedElement[xoev-profil:xsdXModel(.)]//nestedClassifier[xoev-profil:xoevVersionCodeliste(.) and not(xoev-profil:xsdDraft(.))]">
         <sch:assert role="error" id="C-XOEV-R6" test="
               if (uml:is-Class(.)) then
                  xoev-profil:xoevVersionCodeliste(.)/@versionCodelistenHandbuch = ('1.0', '1.1', '1.2')
               else
               xoev-profil:xoevVersionCodeliste(.)/@versionXOEVHandbuch = '2.1'">C-XOEV-R6: Die Version des Handbuchs, zu dessen Regelungen die technische Umsetzung der Version einer Codeliste konform ist, muss angegeben sein (Eigenschaft versionXOEVHandbuch bzw. versionCodelistenHandbuch des Stereotyps xoevVersionCodeliste) und einer existierenden Version entsprechen (XÖV-Handbuch 2.1 oder Codelisten-Handbuch 1.0, 1.1 bzw. 1.2). Die Codelistenversion <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
      </sch:rule>
   </sch:pattern>

   <sch:pattern id="pattern.C-XOEV-R8">
      <sch:title>Code-Spalte zu jedem Codelisteneintrag mit eindeutigem Wert</sch:title>
      <sch:rule context="uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//ownedAttribute[xoev-profil:xoevCodelistenspalte(.)/@codeSpalte = 'true']">
         <sch:let name="spalte" value="."/>
         <sch:let name="instanzen" value="ancestor::packagedElement[xoev-profil:xsdXModel(.)]//packagedElement[uml:is-InstanceSpecification(.) and @classifier = $spalte/parent::*/@xmi:id and not(xoev-profil:xoevCodelisteneintragDeprecated(.))]"/>
         <sch:assert role="error" id="C-XOEV-R8" test="
           count($instanzen/slot[uml:resolve-definingFeature(.)/@xmi:id = $spalte/@xmi:id]/value/@value) = count(distinct-values($instanzen/slot[uml:resolve-definingFeature(.)/@xmi:id = $spalte/@xmi:id]/value/@value))">C-XOEV-R8: Über die Werte in einer Code-Spalte (UML-Eigenschaft mit dem Stereotyp xoevCodelistenspalte und der Stereotypeigenschaft codeSpalte = true) müssen die einzelnen Einträge der Codeliste (UML-Objekte der UML-Klasse der Codelistenversion) eindeutig identifiziert werden können. Somit muss in einer Code-Spalte zu jedem Codelisteneintrag ein eindeutiger Wert vorliegen. Die Codelistenspalte <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
      </sch:rule>
   </sch:pattern>

   <sch:pattern id="pattern.C-CLH-1.0-R9">
      <sch:title>Pro Sprache ein Name (lang) für Codelisten</sch:title>
      <sch:rule context="uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//packagedElement[xoev-profil:xoevCodeliste(.) and not(xoev-profil:xsdDraft(.))] | uml:Model/packagedElement[xoev-profil:xsdXModel(.)]//nestedClassifier[xoev-profil:xoevCodeliste(.) and not(xoev-profil:xsdDraft(.))]">
        <sch:assert role="error" id="C-CLH-1.0-R9" test="count(xoev-profil:xoevCodeliste(.)/nameLang[. != '']) = (1, count(distinct-values(xoev-profil:xoevCodeliste(.)/nameLang/xoev:get-language(.))))">C-CLH-1.0-R9: Eine Codeliste muss genau einen Namen (lang) pro Sprache besitzen (Eigenschaft nameLang des Stereotyps xoevCodeliste). Die Codeliste <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
      </sch:rule>
   </sch:pattern>

   <sch:pattern id="pattern.C-CLH-1.0-R11">
      <sch:title>Pro Sprache ein Name (kurz) für Codelisten</sch:title>
      <sch:rule context="uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//packagedElement[xoev-profil:xoevCodeliste(.) and not(xoev-profil:xsdDraft(.))] | uml:Model/packagedElement[xoev-profil:xsdXModel(.)]//nestedClassifier[xoev-profil:xoevCodeliste(.) and not(xoev-profil:xsdDraft(.))]">
        <sch:assert role="error" id="C-CLH-1.0-R11" test="count(xoev-profil:xoevCodeliste(.)/nameKurz[. != '']) = (1, count(distinct-values(xoev-profil:xoevCodeliste(.)/nameKurz/xoev:get-language(.))))">C-CLH-1.0-R11: Eine Codeliste muss genau einen Namen (kurz) pro Sprache besitzen (Eigenschaft nameKurz des Stereotyps xoevCodeliste). Die Codeliste <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
      </sch:rule>
   </sch:pattern>

   <sch:pattern id="pattern.C-CLH-1.0-R12">
      <sch:title>Codeliste hat Name (technisch)</sch:title>
      <sch:rule context="uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//packagedElement[xoev-profil:xoevCodeliste(.) and not(xoev-profil:xsdDraft(.))] | uml:Model/packagedElement[xoev-profil:xsdXModel(.)]//nestedClassifier[xoev-profil:xoevCodeliste(.) and not(xoev-profil:xsdDraft(.))]">
          <sch:assert role="error" id="C-CLH-1.0-R12" test="xoev-profil:xoevCodeliste(.)/@nameTechnisch[. != '']">C-CLH-1.0-R12: Eine Codeliste muss einen Namen (technisch) besitzen (Eigenschaft nameTechnisch des Stereotyps xoevCodeliste). Die Codeliste <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
      </sch:rule>
   </sch:pattern>

   <sch:pattern id="pattern.C-CLH-1.0-R13">
      <sch:title>Codeliste hat Kennung</sch:title>
      <sch:rule context="uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//packagedElement[xoev-profil:xoevCodeliste(.) and not(xoev-profil:xsdDraft(.))] | uml:Model/packagedElement[xoev-profil:xsdXModel(.)]//nestedClassifier[xoev-profil:xoevCodeliste(.) and not(xoev-profil:xsdDraft(.))]">
          <sch:assert role="error" id="C-CLH-1.0-R13" test="xoev-profil:xoevCodeliste(.)/@kennung[. != '']">C-CLH-1.0-R13: Eine Codeliste muss eine Kennung besitzen (Eigenschaft kennung des Stereotyps xoevCodeliste). Die Codeliste <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
      </sch:rule>
   </sch:pattern>

   <sch:pattern id="pattern.C-CLH-1.0-R14">
      <sch:title>Nur erlaubte Zeichen in Kennung einer Codeliste</sch:title>
      <sch:rule context="
            uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//packagedElement[xoev-profil:xoevCodeliste(.) and not(xoev-profil:xsdDraft(.)) and not(xoev-profil:xoevCodeliste(.)/@kennung = $bestandskennungen)]">
          <sch:assert role="error" id="C-CLH-1.0-R14" test="replace(xoev-profil:xoevCodeliste(.)/@kennung, '[a-z0-9\.\-:]', '') = ''">C-CLH-1.0-R14: Die Kennung einer Codeliste darf ausschließlich die Zeichen "a-z", "0-9", ":", "-" und "." enthalten (Eigenschaft kennung des Stereotyps xoevCodeliste). Die Codeliste <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
      </sch:rule>
   </sch:pattern>

   <!-- Deaktiviert, da zunächst ausführlich zu prüfen. Sie schlägt bei vielen Standards an. -->
   <!--<sch:pattern id="pattern.C-CLH-1.0-R15">
      <sch:title>Korrekte Codelistenmodellierung</sch:title>
      <sch:rule context="uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//packagedElement[xoev-profil:xoevCodeliste(.) and not(xoev-profil:xsdDraft(.)) and not(xoev-profil:xoevCodeliste(.)/@kennung = $bestandskennungen)]">
         <sch:assert id="rule.C-CLH-1.0-R15" role="error" test='
                matches(., "^urn:(urn-[1-9][0-9]*|[a-zA-z0-9][a-zA-Z0-9-]{1,30}[a-z0-9]):[a-zA-Z0-9:&amp;@\-\._~!\$&apos;\(\)\*\+,;=][a-zA-Z0-9:&amp;@%\-\._~!\$&apos;\(\)\*\+,;=/]*$")'>Die Kennung einer Codeliste (/CodeList/Identification/CanonicalUri) muss in der Form eines URN notiert werden. [siehe Codelistenhandbuch 1.0, Abschnitt 1.3 "Identifikation von Codelisten"]</sch:assert>
         <sch:assert id="rule.C-CLH-1.0-R15-1" role="error" test="not(matches(., '^urn:urn-.*$')) or matches(., '^urn:urn-[1-9][0-9]*:.*$')">Die Kennung einer Codeliste (/CodeList/Identification/CanonicalUri) muss in der Form eines URN notiert werden: Ein informaler URN-Namespace darf nach "urn-" nur Zahlen enthalten.</sch:assert>
         <sch:assert id="rule.C-CLH-1.0-R15-2" role="error" test="not(matches(., '^urn:x-.*$'))">Die Kennung einer Codeliste (/CodeList/Identification/CanonicalUri) muss in der Form eines URN notiert werden: Der URN-Namespace darf nicht mit der Zeichenkette "X-" beginnen. </sch:assert>
         <sch:assert id="rule.C-CLH-1.0-R15-3" role="error" test="not(matches(., '^urn:..-.*$'))">Die Kennung einer Codeliste (/CodeList/Identification/CanonicalUri) muss in der Form eines URN notiert werden: Der URN-Namespace darf nicht mit zwei Zeichen, gefolgt von einem Bindestrich beginnen.</sch:assert>
         <sch:assert id="rule.C-CLH-1.0-R15-4" role="error" test="not(matches(., '^.*%.*$')) or matches(., '^urn:.*:.*%[0-9ABCDEF][0-9ABCDEF].*$')">Die Kennung einer Codeliste (/CodeList/Identification/CanonicalUri) muss in der Form eines URN notiert werden: Das Zeichen "%" darf nur zur Angabe von Hexadezimalzahlen verwendet werden.</sch:assert>
      </sch:rule>
   </sch:pattern>-->

   <sch:pattern id="pattern.C-CLH-1.0-R16">
      <sch:title>Nur erlaubte Syntax für Kennung einer Codeliste</sch:title>
      <sch:rule context="uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//packagedElement[xoev-profil:xoevCodeliste(.) and not(xoev-profil:xsdDraft(.)) and not(xoev-profil:xoevCodeliste(.)/@kennung = $bestandskennungen)]">
        <sch:assert role="warning" id="C-CLH-1.0-R16" test="starts-with(xoev-profil:xoevCodeliste(.)/@kennung, 'urn:xoev-de:')">C-CLH-1.0-R16: Es wird empfohlen, als globalen Teil der Kennung einer Codeliste (Eigenschaft kennung des Stereotyps xoevCodeliste) die Zeichenfolge "urn:xoev-de:" und die zugehörige Syntax zu verwenden. Die Codeliste <sch:value-of select="xgen:model-path(.)"/> entspricht dieser Empfehlung nicht. Hinweis: Diese Meldung erscheint ausschließlich bei Codelisten, die noch nicht im XRepository vorliegen.</sch:assert>
      </sch:rule>
   </sch:pattern>

   <sch:pattern id="pattern.C-CLH-1.0-R17">
      <sch:title>Kennung einer Codeliste enthält :codeliste:</sch:title>
      <sch:rule context="uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//packagedElement[xoev-profil:xoevCodeliste(.) and not(xoev-profil:xsdDraft(.)) and starts-with(xoev-profil:xoevCodeliste(.)/@kennung, 'urn:xoev-de:') and not(xoev-profil:xoevCodeliste(.)/@kennung = $bestandskennungen)]">
          <sch:assert role="error" id="C-CLH-1.0-R17" test="contains(xoev-profil:xoevCodeliste(.)/@kennung, ':codeliste:')">C-CLH-1.0-R17: Die Kennung einer Codeliste (Eigenschaft kennung des Stereotyps xoevCodeliste) mit dem globalen Teil "urn:xoev-de:" muss die Art des Inhalts mittels der Zeichenfolge ":codeliste:" beschreiben. Die Codeliste <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
      </sch:rule>
   </sch:pattern>

   <sch:pattern id="pattern.C-CLH-1.0-R18">
      <sch:title>Kennung einer Codeliste endet mit Name (technisch) der Codeliste in Kleinschreibung</sch:title>
      <sch:rule context="uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//packagedElement[xoev-profil:xoevCodeliste(.) and not(xoev-profil:xsdDraft(.)) and starts-with(xoev-profil:xoevCodeliste(.)/@kennung, 'urn:xoev-de:') and not(xoev-profil:xoevCodeliste(.)/@kennung = $bestandskennungen)]">
          <sch:assert role="error" id="C-CLH-1.0-R18" test="ends-with(xoev-profil:xoevCodeliste(.)/@kennung, lower-case(xoev-profil:xoevCodeliste(.)/@nameTechnisch))">C-CLH-1.0-R18: Die Kennung einer Codeliste (Eigenschaft kennung des Stereotyps xoevCodeliste) mit dem globalen Teil "urn:xoev-de:" muss mit dem Namen (technisch) der Codeliste in Kleinschreibung enden. Die Codeliste <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
      </sch:rule>
   </sch:pattern>

   <sch:pattern id="pattern.C-CLH-1.0-R19">
      <sch:title>Genau eine Beschreibung pro Sprache für eine Codeliste</sch:title>
      <sch:rule context="uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//packagedElement[xoev-profil:xoevCodeliste(.) and not(xoev-profil:xsdDraft(.))]">
          <sch:assert role="error" id="C-CLH-1.0-R19" test="count(xoev-profil:xoevCodeliste(.)/beschreibung[. != '']) = (1, count(distinct-values(xoev-profil:xoevCodeliste(.)/beschreibung/xoev:get-language(.))))">C-CLH-1.0-R19: Eine Codeliste muss genau eine Beschreibung pro Sprache besitzen (Eigenschaft beschreibung des Stereotyps xoevCodeliste). Die Codeliste <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
      </sch:rule>
   </sch:pattern>

   <sch:pattern id="pattern.C-CLH-1.0-R20">
      <sch:title>Genau ein Herausgebername (lang) pro Sprache für eine Codeliste</sch:title>
      <sch:rule context="uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//packagedElement[xoev-profil:xoevCodeliste(.) and not(xoev-profil:xsdDraft(.))]">
        <sch:assert role="error" id="C-CLH-1.0-R20" test="count(xoev-profil:xoevCodeliste(.)/herausgebernameLang[. != '']) = (1, count(distinct-values(xoev-profil:xoevCodeliste(.)/herausgebernameLang/xoev:get-language(.))))">C-CLH-1.0-R20: Eine Codeliste muss genau einen Namen (lang) ihres Herausgebers pro Sprache enthalten (Eigenschaft herausgebernameLang des Stereotyps xoevCodeliste). Die Codeliste <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
      </sch:rule>
   </sch:pattern>

   <sch:pattern id="pattern.C-CLH-1.0-R21">
     <sch:title>Genau ein Herausgebername (kurz) pro Sprache für eine Codeliste</sch:title>
      <sch:rule context="uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//packagedElement[xoev-profil:xoevCodeliste(.) and not(xoev-profil:xsdDraft(.))]">
          <sch:assert role="error" id="C-CLH-1.0-R21" test="count(xoev-profil:xoevCodeliste(.)/herausgebernameKurz[. != '']) = (1, count(distinct-values(xoev-profil:xoevCodeliste(.)/herausgebernameKurz/xoev:get-language(.))))">C-CLH-1.0-R21: Eine Codeliste muss genau einen Namen (kurz) ihres Herausgebers pro Sprache enthalten (Eigenschaft herausgebernameKurz des Stereotyps xoevCodeliste). Die Codeliste <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
      </sch:rule>
   </sch:pattern>

   <sch:pattern id="pattern.C-CLH-1.0-R23">
      <sch:title>Nur erlaubte Zeichen in Version zu einer Codelistenversion</sch:title>
      <sch:rule context="uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//packagedElement[xoev-profil:xoevVersionCodeliste(.) and not(xoev-profil:xsdDraft(.))]">
        <sch:assert role="error" id="C-CLH-1.0-R23" test="replace(xoev-profil:xoevVersionCodeliste(.)/@version, '[a-zA-Z0-9\.\-]', '') = ''">C-CLH-1.0-R23: Die Versionsangabe in einer Codelistenversion darf ausschließlich die Zeichen 'a-z', 'A-Z', '0-9', '-' und '.' enthalten (Eigenschaft version des Stereotyps xoevVersionCodeliste). Die Codelistenversion <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
      </sch:rule>
   </sch:pattern>

   <sch:pattern id="pattern.C-CLH-1.0-R24">
      <sch:title>Codelistenversion mit mindestens zwei Spalten</sch:title>
      <sch:rule context="uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//packagedElement[xoev-profil:xoevVersionCodeliste(.) and uml:is-Class(.) and not(xoev-profil:xsdDraft(.))]">
        <sch:assert role="error" id="C-CLH-1.0-R24" test="count(ownedAttribute[xoev-profil:xoevCodelistenspalte(.)]) &gt;= 2">C-CLH-1.0-R24: Eine Codelistenversion (UML-Klasse mit dem Stereotyp xoevVersionCodeliste) muss mindestens zwei Spalten enthalten (UML-Eigenschaften mit dem Stereotyp xoevCodelistenspalte). Die Codelistenversion <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
      </sch:rule>
   </sch:pattern>

   <sch:pattern id="pattern.C-CLH-1.0-R25">
      <sch:title>Nur erlaubte Zeichen in Name (technisch) einer Codelistenspalte</sch:title>
      <sch:rule context="uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//ownedAttribute[xoev-profil:xoevCodelistenspalte(.) and not(xoev-profil:xsdDraft(.))]">
        <sch:assert role="error" id="C-CLH-1.0-R25" test="replace(@name, '[a-zA-Z0-9\.\-]', '') = ''">C-CLH-1.0-R25: Der Name (technisch) einer Codelistenspalte (UML-Eigenschaft mit dem Stereotyp xoevCodelistenspalte und der Stereotypeigenschaft nameTechnisch) darf nur die Zeichen "a-z", "A-Z", "0-9", "-" und "." enthalten. Die Codelistenspalte <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
      </sch:rule>
   </sch:pattern>

   <sch:pattern id="pattern.C-CLH-1.0-R26">
      <sch:title>Codelistenversion mit mindestens einem Eintrag</sch:title>
      <sch:rule context="uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//packagedElement[xoev-profil:xoevVersionCodeliste(.) and not(xoev-profil:xsdDraft(.)) and uml:is-Class(.)]">
         <sch:let name="codelistenversion" value="."/>
          <sch:assert role="warning" id="C-CLH-1.0-R26" test="count(ancestor::packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//packagedElement[uml:is-InstanceSpecification(.) and @classifier = $codelistenversion/@xmi:id]) &gt;= 1">C-CLH-1.0-R26: Eine Codelistenversion (UML-Klasse mit dem Stereotyp xoevVersionCodeliste) sollte mindestens einen Eintrag (UML-Objekt der UML-Klasse der Codelistenversion) besitzen. Die Codelistenversion <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
      </sch:rule>
   </sch:pattern>

   <sch:pattern id="pattern.C-CLH-1.0-R28">
      <sch:title>Codelistenversion mit maximal einer empfohlenen Code-Spalte</sch:title>
      <sch:rule context="uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//packagedElement[xoev-profil:xoevVersionCodeliste(.) and uml:is-Class(.) and not(xoev-profil:xsdDraft(.))]">
          <sch:assert role="error" id="C-CLH-1.0-R28" test="count(ownedAttribute[xoev-profil:xoevCodelistenspalte(.)/@empfohleneCodeSpalte = 'true']) &lt;= 1">C-CLH-1.0-R28: Eine Codelistenversion (UML-Klasse mit dem Stereotyp xoevVersionCodeliste) darf höchstens eine empfohlene Code-Spalte (UML-Eigenschaft mit dem Stereotyp xoevCodelistenspalte und der Eigenschaft empfohleneCodeSpalte = true) besitzen. Die Codelistenversion <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
      </sch:rule>
   </sch:pattern>

   <sch:pattern id="pattern.C-CLH-1.0-R29">
      <sch:title>Gültigkeit einer Codeliste im Format JJJJ-MM-TT</sch:title>
      <sch:rule context="uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//packagedElement[xoev-profil:xoevVersionCodeliste(.) and not(xoev-profil:xsdDraft(.)) and xoev-profil:xoevVersionCodeliste(.)/@datumGueltigkeitAb]">
        <sch:assert role="error" id="C-CLH-1.0-R29" test="matches(xoev-profil:xoevVersionCodeliste(.)/@datumGueltigkeitAb, '\d\d\d\d\-\d\d\-\d\d')">C-CLH-1.0-R29: Das Datum "Gültigkeit ab" einer Codelistenversion (UML-Klasse mit dem Stereotyp xoevVersionCodeliste und der Eigenschaft datumGueltigkeitAb) darf nur Datumsangaben im Format JJJJ-MM-TT enthalten. Die Codelistenversion <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
      </sch:rule>
   </sch:pattern>

   <sch:pattern id="pattern.C-CLH-1.0-R30">
      <sch:title>Codelistenversion mit Versionsangabe</sch:title>
      <sch:rule context="uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//packagedElement[xoev-profil:xoevVersionCodeliste(.) and not(xoev-profil:xsdDraft(.))]">
        <sch:assert role="error" id="C-CLH-1.0-R30" test="xoev-profil:xoevVersionCodeliste(.)/@version[. != '']">C-CLH-1.0-R30: Die Versionangabe einer Codelistenversion muss spezifiziert sein (UML-Klasse mit dem Stereotyp xoevVersionCodeliste und der Eigenschaft version). Die Codelistenversion <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
      </sch:rule>
   </sch:pattern>

   <sch:pattern id="pattern.C-CLH-1.2-R31-A">
      <sch:title>Maximal eine Beschreibung pro Sprache zu einer Codelistenversion</sch:title>
      <sch:rule context="uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//packagedElement[xoev-profil:xoevVersionCodeliste(.) and not(xoev-profil:xsdDraft(.))] | uml:Model/packagedElement[xoev-profil:xsdXModel(.)]//nestedClassifier[xoev-profil:xoevVersionCodeliste(.) and not(xoev-profil:xsdDraft(.))]">
          <sch:assert role="error" id="C-CLH-1.2-R31-A" test="count(xoev-profil:xoevVersionCodeliste(.)/beschreibung[. != '']) = (0, 1, count(distinct-values(xoev-profil:xoevVersionCodeliste(.)/beschreibung/xoev:get-language(.))))">C-CLH-1.2-R31-A: Eine Codelistenversion darf höchstens eine Beschreibung pro Sprache besitzen (Eigenschaft beschreibung des Stereotyps xoevVersionCodeliste). Die Codelistenversion <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
      </sch:rule>
   </sch:pattern>

   <sch:pattern id="pattern.C-CLH-1.2-R32-A">
      <sch:title>Maximal eine Beschreibung der Änderungen zur Vorversion pro Sprache zu einer Codeliste</sch:title>
      <sch:rule context="uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//packagedElement[xoev-profil:xoevVersionCodeliste(.) and not(xoev-profil:xsdDraft(.))] | uml:Model/packagedElement[xoev-profil:xsdXModel(.)]//nestedClassifier[xoev-profil:xoevVersionCodeliste(.) and not(xoev-profil:xsdDraft(.))]">
          <sch:assert role="error" id="C-CLH-1.2-R32-A" test="count(xoev-profil:xoevVersionCodeliste(.)/aenderungZurVorversion[. != '']) = (0, 1, count(distinct-values(xoev-profil:xoevVersionCodeliste(.)/aenderungZurVorversion/xoev:get-language(.))))">C-CLH-1.2-R32-A: Eine Codelistenversion darf höchstens eine Beschreibung der Änderungen zur Vorversion pro Sprache besitzen (Eigenschaft aenderungZurVorversion des Stereotyps xoevVersionCodeliste). Die Codelistenversion <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
      </sch:rule>
   </sch:pattern>

   <sch:pattern id="pattern.C-XOEV-R33">
      <sch:title>Keine Eigenschaft versionXOEVHandbuch für Codelisten gemäß Codelisten-Handbuch</sch:title>
      <sch:rule context="uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//packagedElement[uml:is-Class(.) and xoev-profil:xoevVersionCodeliste(.) and not(xoev-profil:xsdDraft(.))]">
         <sch:assert role="error" id="C-XOEV-R33" test="
               xoev-profil:xoevVersionCodeliste(.)/@versionCodelistenHandbuch and
               empty(xoev-profil:xoevVersionCodeliste(.)/@versionXOEVHandbuch)">C-XOEV-R33: Im Kontext einer Codelistenversion, die der im Codelisten-Handbuch 1.0 dokumentierten Methodik entsprechend modelliert ist (UML-Klasse mit dem Stereotyp xoevVersionCodeliste) muss die Version des Codelisten-Handbuchs angeben sein (Eigenschaft versionCodelistenHandbuch des Stereotyps xoevVersionCodeliste). Die Eigenschaft versionXOEVHandbuch des Stereotyps xoevVersionCodeliste darf nicht befüllt sein. Die Codelistenversion <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
      </sch:rule>
   </sch:pattern>

   <sch:pattern id="pattern.C-XOEV-2.2-R34">
     <sch:title>Keine Eigenschaft versionCodelistenHandbuch für Codelisten gemäß XÖV-Handbuch</sch:title>
      <sch:rule context="uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//packagedElement[uml:is-Enumeration(.) and xoev-profil:xoevVersionCodeliste(.) and not(xoev-profil:xsdDraft(.))]">
         <sch:assert role="error" id="C-XOEV-2.2-R34" test="
               xoev-profil:xoevVersionCodeliste(.)/@versionXOEVHandbuch and
               empty(xoev-profil:xoevVersionCodeliste(.)/@versionCodelistenHandbuch)">C-XOEV-2.2-R34: Im Kontext einer Codelistenversion, die der im XÖV-Handbuch 2.1 dokumentierten Methodik entsprechend modelliert ist (UML-Enumeration mit dem Stereotyp xoevVersionCodeliste) muss die Version des XÖV-Handbuchs angeben sein (Eigenschaft versionXOEVHandbuch des Stereotyps xoevVersionCodeliste). Die Eigenschaft versionCodelistenHandbuch des Stereotyps xoevVersionCodeliste darf nicht befüllt sein. Die Codelistenversion <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
      </sch:rule>
   </sch:pattern>

    <sch:pattern id="pattern.classic.019">
      <sch:title>Eigenes Paket für jede xoevCodeliste-Klasse mit Codelisten-Kennung als Name</sch:title>
      <sch:rule context="uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//packagedElement[xoev-profil:xoevCodeliste(.) and uml:is-Class(.) and not(xoev-profil:xsdDraft(.))]">
          <sch:assert role="information" id="classic.019" test="parent::packagedElement/@name = xoev-profil:xoevCodeliste(.)/@kennung">classic.019: Es wird empfohlen, für jede Codeliste (UML-Klasse mit dem Stereotyp xoevCodeliste) ein eigenes UML-Paket zu erstellen, dessen Name der Kennung der Codeliste entspricht. Die Codeliste <sch:value-of select="xgen:model-path(.)"/> entspricht dieser Empfehlung nicht.</sch:assert>
      </sch:rule>
   </sch:pattern>

    <sch:pattern id="pattern.classic.020">
      <sch:title>Unterhalb von Codelisten-Paket ein Paket für xoevVersionCodeliste-Klasse</sch:title>
      <sch:rule context="uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//packagedElement[xoev-profil:xoevVersionCodeliste(.) and uml:is-Class(.) and not(xoev-profil:xsdDraft(.))]">
         <sch:let name="codelistenversion" value="."/>
         <sch:assert role="information" id="classic.020" test="parent::packagedElement[@name = $codelistenversion/xoev-profil:xoevVersionCodeliste(.)/@version and parent::packagedElement/packagedElement/@xmi:id = $codelistenversion/xoev:dependencies-by-client(.)/uml:resolve-supplier(.)/@xmi:id]">classic.020: Es wird empfohlen, für jede Codelistenversion (UML-Klasse mit dem Stereotyp xoevVersionCodeliste) ein eigenes UML-Paket unterhalb des Pakets der Codeliste zu erstellen und dem Paket die Versionsangabe als Namen zu geben. Die Codelistenversion <sch:value-of select="xgen:model-path(.)"/> entspricht dieser Empfehlung nicht.</sch:assert>
      </sch:rule>
   </sch:pattern>

    <sch:pattern id="pattern.classic.021">
      <sch:title>Instanzspezifikationen zur xoevVersionCodeliste-Klasse im Paket der Klasse</sch:title>
      <sch:rule context="uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//packagedElement[uml:is-InstanceSpecification(.) and not(xoev-profil:xoevCodelisteneintragDeprecated(.)) and uml:resolve-classifier(.)/xoev-profil:xoevVersionCodeliste(.)]">
         <sch:let name="codelistenversion" value="uml:resolve-classifier(.)"/>
         <sch:assert role="information" id="classic.021" test="parent::packagedElement/packagedElement/@xmi:id = $codelistenversion/@xmi:id">classic.021: Es wird empfohlen, die Codelisteneinträge (UML-Objekte der UML-Klasse der Codelistenversion) im UML-Paket der Codelistenversion abzulegen. Der Codelisteneintrag mit den Werten <sch:value-of select="slot/value/@value"/> der Codelistenversion <sch:value-of select="xgen:model-path($codelistenversion)"/> entspricht dieser Empfehlung nicht.</sch:assert>
      </sch:rule>
   </sch:pattern>

    <sch:pattern id="pattern.classic.022">
      <sch:title>Codelisten nach Codelisten-Handbuch modelliert</sch:title>
      <sch:rule context="uml:Model/packagedElement[xoev-profil:xsdXModel(.)]">
          <sch:assert role="warning" id="classic.022" test="empty((descendant::packagedElement, descendant::nestedClassifier)[uml:is-Enumeration(.) and xoev-profil:xoevCodeliste(.)])">classic.022: Codelisten sollen der im Codelisten-Handbuch (Version 1.0) dokumentierten Methodik entsprechend modelliert werden. Im XÖV-Fachmodell des Standards liegt mindestens eine Codeliste vor, die einer älteren Methodik entspricht.</sch:assert>
      </sch:rule>
   </sch:pattern>

   <sch:pattern id="pattern.C-CLH-1.0-R35">
      <sch:title>Nur erlaubte Zeichen für Codelisten-Werte</sch:title>
      <sch:rule context="
            uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//packagedElement[uml:is-InstanceSpecification(.) and not(xoev-profil:xoevCodelisteneintragDeprecated(.)) and uml:resolve-classifier(.)/xoev-profil:xoevVersionCodeliste(.) and
            not(uml:resolve-classifier(.)/xoev:dependencies-by-client(.)/uml:resolve-supplier(.)/xoev-profil:xoevCodeliste(.)/@kennung = $bestandskennungen)]">
          <sch:assert id="C-CLH-1.0-R35" role="warning" test="
               every $value in slot[uml:resolve-definingFeature(.)/xoev-profil:xoevCodelistenspalte(.)/@codeSpalte = 'true']/value/@value
               satisfies string-length($value) > 0 and not(matches($value, '^\p{Z}*$'))">C-CLH-1.0-R35: Codes sollen nicht leer sein oder ausschließlich aus Unicode-Seperatoren (z. B. Leerzeichen oder Zeilenumbrüchen) bestehen, da dies Probleme bzgl. Lesbarkeit und automatischer Weiterverarbeitung verursachen kann. Ein Code im Codelisteneintrag <sch:value-of select="xgen:model-path(.)"/> verletzt diese Regel.</sch:assert>
      </sch:rule>
   </sch:pattern>

    <sch:pattern id="pattern.NDR-34.001.classic">
      <sch:title>Modellierung von Codelisten-Version mit benanntem Typ</sch:title>
      <sch:rule context="
            uml:Model/packagedElement[xoev-profil:xsdXModel(.)]//packagedElement[uml:is-Class(.) and xoev:usages-by-client(.)[xoev-profil:xoevCodeTyp1(.)/@benannterCodelistenDatentyp = 'false'] and not(xoev-profil:xsdDraft(.))] |
            uml:Model/packagedElement[xoev-profil:xsdXModel(.)]//nestedClassifier[uml:is-Class(.) and xoev:usages-by-client(.)[xoev-profil:xoevCodeTyp1(.)/@benannterCodelistenDatentyp = 'false'] and not(xoev-profil:xsdDraft(.))]">
          <sch:assert role="information" id="NDR-34.001.classic" test="false()">Es wird empfohlen, Codelistenversionen als benannte Typen zu modellieren. Im Kontext des Code-Datentyps <sch:value-of select="xgen:model-path(.)"/> wird diese Empfehlung nicht eingehalten.</sch:assert>
      </sch:rule>
   </sch:pattern>

    <sch:pattern id="pattern.classic.023">
      <sch:title>Korrekte Codelisten-Ablage</sch:title>
      <sch:rule context="/xmi:XMI/uml:Model//packagedElement[(xoev-profil:xoevCodeliste(.) or xoev-profil:xoevVersionCodeliste(.)) and uml:is-Class(.) and not(xoev-profil:xsdDraft(.))]">
          <sch:assert role="error" id="classic.023" test="ancestor::packagedElement[@name = ('eigene Codelisten', 'externe Codelisten')]/parent::packagedElement[@name = 'Codelisten']/parent::uml:Model/@xmi:id = $uml:root-model/@xmi:id or ancestor::packagedElement[@name = 'Externe Modelle']/parent::uml:Model/@xmi:id = $uml:root-model/@xmi:id">classic.023: Alle eigenen und externen Codelisten (gemäß Abschnitt 8.1 "Codelisten im XÖV-Fachmodell" des XÖV-Handbuchs) müssen, im XÖV-Fachmodell auf oberster Ebene unterhalb eines UML-Pakets "Codelisten" (konkret "Codelisten/eigene Codelisten" oder "Codelisten/externe Codelisten") abgelegt werden. Die Codeliste <sch:value-of select="xgen:model-path(.)"/> entspricht dieser Vorgabe nicht.</sch:assert>
      </sch:rule>
   </sch:pattern>

    <sch:pattern id="pattern.classic.024">
      <sch:title>Keine Namenskollisionen bei benannten Typen zu Codelisten</sch:title>
      <sch:rule context="
            /xmi:XMI/uml:Model//packagedElement[
            xoev-profil:xoevVersionCodeliste(.) and uml:is-Class(.) and not(xoev-profil:xsdDraft(.)) and
            count(
            xoev:usages-by-supplier(.)[xoev-profil:xoevCodeTyp1(.)[not(@benannterCodelistenDatentyp = 'false')]]/
            uml:resolve-client(.)[ancestor::packagedElement/@xmi:id = $xoev:my-xmodel/@xmi:id])
            gt 1]">
         <sch:let name="usages" value="
               xoev:usages-by-supplier(.)[xoev-profil:xoevCodeTyp1(.)[not(@benannterCodelistenDatentyp = 'false')] and
               uml:resolve-client(.)[ancestor::packagedElement/@xmi:id = $xoev:my-xmodel/@xmi:id]]"/>
          <sch:assert role="error" id="classic.024" test="
               every $usage1 in $usages
                  satisfies (every $usage2 in $usages[@xmi:id != $usage1/@xmi:id]
                     satisfies
                     not($usage1/(xoev-profil:xoevCodeTyp1(.)/@benannterCodelistenDatentypXSD, uml:resolve-client(.)/ancestor::packagedElement[xoev-profil:xsdSchema(.)]/@xmi:id)[1] =
                     $usage2/(xoev-profil:xoevCodeTyp1(.)/@benannterCodelistenDatentypXSD, uml:resolve-client(.)/ancestor::packagedElement[xoev-profil:xsdSchema(.)]/@xmi:id)[1])
                     or
                     not($usage1/(xoev-profil:xoevCodeTyp1(.)/@benannterCodelistenDatentypName,
                     uml:resolve-supplier(.)/xoev:dependencies-by-client(.)/uml:resolve-supplier(.)/xoev-profil:xoevCodeliste(.)/@nameTechnisch)[1] =
                     $usage2/(xoev-profil:xoevCodeTyp1(.)/@benannterCodelistenDatentypName,
                     uml:resolve-supplier(.)/xoev:dependencies-by-client(.)/uml:resolve-supplier(.)/xoev-profil:xoevCodeliste(.)/@nameTechnisch)[1])
                     or (
                     $usage1/(xoev-profil:xoevCodeTyp1(.)/@genutzteCodeSpalte/xoev:ids-to-elements(., root()),
                     uml:resolve-supplier(.)/ownedAttribute[xoev-profil:xoevCodelistenspalte(.)/@empfohleneCodeSpalte = 'true'],
                     uml:resolve-supplier(.)/ownedAttribute[xoev-profil:xoevCodelistenspalte(.)/@codeSpalte = 'true'])[1]/@xmi:id =
                     $usage2/(xoev-profil:xoevCodeTyp1(.)/@genutzteCodeSpalte/xoev:ids-to-elements(., root()),
                     uml:resolve-supplier(.)/ownedAttribute[xoev-profil:xoevCodelistenspalte(.)/@empfohleneCodeSpalte = 'true'],
                     uml:resolve-supplier(.)/ownedAttribute[xoev-profil:xoevCodelistenspalte(.)/@codeSpalte = 'true'])[1]/@xmi:id
                     and
                     ($usage1/xoev-profil:xoevCodeTyp1(.)/xoev:resolve-typDesCodeElements(.)[@name != 'token']/@xmi:id, 'xs:token')[1] =
                     ($usage2/xoev-profil:xoevCodeTyp1(.)/xoev:resolve-typDesCodeElements(.)[@name != 'token']/@xmi:id, 'xs:token')[1]
                     )
                     )">classic.024: Wenn für eine Codelistenversion aufgrund der Nutzung in verschiedenen Code-Datentypen mit unterschiedlichen Nutzungseinstellungen mehrere benannte Datentypen in derselben XML Schema-Definition angelegt werden, muss sich der Name dieser Codelisten-Datentypen unterscheiden. Die Code-Datentypen <sch:value-of select="$usages/uml:resolve-client(.)/@name"/> nutzen die Codelistenversion <sch:value-of select="xgen:model-path(.)"/> als benannter Datentyp mit demselben Namen, nutzen jedoch verschiedene Code-Spalten oder legen verschiedene Typen des Code-Elements fest.</sch:assert>
      </sch:rule>
   </sch:pattern>

    <sch:pattern id="pattern.classic.025">
      <sch:title>xoevVersionCodeliste schließt xsdNamedType und xsdGlobalElementAndNamedType aus</sch:title>
      <sch:rule context="uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//packagedElement[xoev-profil:xoevVersionCodeliste(.) and uml:is-Class(.) and not(xoev-profil:xsdDraft(.))]">
          <sch:assert role="error" id="classic.025" test="not(xoev-profil:xsdNamedType(.) or xoev-profil:xsdGlobalElementAndNamedType(.))">classic.025: Eine Codelistenversion darf nicht mit dem Stereotypen xsdNamedType oder xsdGlobalElementAndNamedType annotiert sein. <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe. Hinweis: Ob für eine Codelistenversion ein benannter Datentyp erstellt wird, wird an der Nutzungsbeziehung konfiguriert (Stereotyp xoevCodeTyp1).</sch:assert>
      </sch:rule>
   </sch:pattern>

    <sch:pattern id="pattern.classic.026">
      <sch:title>benannterCodelistenDatentypXSD verweist auf internes xsdSchema-Paket</sch:title>
      <sch:rule context="
            uml:Model/packagedElement[xoev-profil:xsdXModel(.)]//packagedElement[uml:is-Class(.) and xoev:usages-by-client(.)[xoev-profil:xoevCodeTyp1(.)/@benannterCodelistenDatentypXSD] and not(xoev-profil:xsdDraft(.))] |
            uml:Model/packagedElement[xoev-profil:xsdXModel(.)]//nestedClassifier[uml:is-Class(.) and xoev:usages-by-client(.)[xoev-profil:xoevCodeTyp1(.)/@benannterCodelistenDatentypXSD] and not(xoev-profil:xsdDraft(.))]">
        <sch:assert role="error" id="classic.026" test="xoev:ids-to-elements(xoev:usages-by-client(.)/xoev-profil:xoevCodeTyp1(.)/@benannterCodelistenDatentypXSD, root())[xoev-profil:xsdSchema(.)]/ancestor::packagedElement[xoev-profil:xoevStandard(.)]/@xmi:id = $xoev:my-xmodel/@xmi:id">classic.026: Das in der Eigenschaft benannterCodelistenDatentypXSD des Stereotyps xoevCodeTyp1 angegebene Paket muss ein zum Standard gehörendes Schema-Paket (xsdSchema) sein. Im Kontext des Code-Datentyps <sch:value-of select="xgen:model-path(.)"/> wird diese Vorgabe nicht eingehalten.</sch:assert>
      </sch:rule>
   </sch:pattern> 

   <sch:pattern id="pattern.C-CLH-1.2-R42-1">
      <sch:title>Korrekte Angaben zur Mehrsprachigkeit</sch:title>
      <sch:rule context="uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//packagedElement[uml:is-Class(.) and (xoev-profil:xoevCodeliste(.) or xoev-profil:xoevVersionCodeliste(.)) and not(xoev-profil:xsdDraft(.))]">
         <sch:let name="cl-vcl" value="."/>
         <sch:assert role="error" id="C-CLH-1.2-R42-1" test="
               every $m in (xoev-profil:xoevCodeliste(.)/nameLang[count($cl-vcl/xoev-profil:xoevCodeliste(.)/nameLang) gt 1],
               xoev-profil:xoevCodeliste(.)/nameKurz[count($cl-vcl/xoev-profil:xoevCodeliste(.)/nameKurz) gt 1],
               xoev-profil:xoevCodeliste(.)/beschreibung[count($cl-vcl/xoev-profil:xoevCodeliste(.)/beschreibung) gt 1],
               xoev-profil:xoevCodeliste(.)/herausgebernameLang[count($cl-vcl/xoev-profil:xoevCodeliste(.)/herausgebernameLang) gt 1],
               xoev-profil:xoevCodeliste(.)/herausgebernameKurz[count($cl-vcl/xoev-profil:xoevCodeliste(.)/herausgebernameKurz) gt 1],
               xoev-profil:xoevVersionCodeliste(.)/beschreibung[count($cl-vcl/xoev-profil:xoevVersionCodeliste(.)/beschreibung) gt 1],
               xoev-profil:xoevVersionCodeliste(.)/aenderungZurVorversion[count($cl-vcl/xoev-profil:xoevVersionCodeliste(.)/aenderungZurVorversion) gt 1])
               satisfies xoev:get-language($m)">C-CLH-1.2-R42-1: Wenn ein mehrsprachiges Metadatenelement mehr als einen Wert besitzt, muss jeder Wert mit einer Sprachangabe in der Form "[xx-XX]" beginnen, wobei "xx-XX" eine Codierung auf der Basis von RFC-5646 darstellen muss, siehe Konformitätskriterien K-11 und K-13 im Codelistenhandbuch. Die Codeliste(nversion) <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
      </sch:rule>
   </sch:pattern>

   <sch:pattern id="pattern.C-CLH-1.2-R40-1">
      <sch:title>Vollständige Sprachauszeichnung für Codeliste</sch:title>
      <sch:rule context="uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//packagedElement[uml:is-Class(.) and xoev-profil:xoevCodeliste(.) and not(xoev-profil:xsdDraft(.))]">
         <sch:let name="cl" value="."/>
         <sch:assert role="error" id="C-CLH-1.2-R40-1" test="
               every $l in xoev-profil:xoevCodeliste(.)/(nameLang, nameKurz, beschreibung, herausgebernameLang, herausgebernameKurz)/xoev:get-language(.)
                  satisfies
                  (xoev-profil:xoevCodeliste(.)/nameLang[starts-with(., concat('[', $l, ']'))] and
                  xoev-profil:xoevCodeliste(.)/nameKurz[starts-with(., concat('[', $l, ']'))] and
                  xoev-profil:xoevCodeliste(.)/beschreibung[starts-with(., concat('[', $l, ']'))] and
                  xoev-profil:xoevCodeliste(.)/herausgebernameLang[starts-with(., concat('[', $l, ']'))] and
                  xoev-profil:xoevCodeliste(.)/herausgebernameKurz[starts-with(., concat('[', $l, ']'))])">C-CLH-1.2-R40-1: Jede für ein Metadatenelement genutzte Sprache muss ebenso als Sprache für die weiteren mehrsprachigen Metadatenelemente genutzt werden, außer für ein optionales Metadatenelement ist kein Wert angegeben, siehe Konformitätskriterium K-12 im Codelistenhandbuch. Die Codeliste <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
      </sch:rule>
   </sch:pattern>

   <sch:pattern id="pattern.C-CLH-1.2-R40-2">
      <sch:title>Vollständige Sprachauszeichnung für Codelistenversion</sch:title>
      <sch:rule context="uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//packagedElement[uml:is-Class(.) and xoev-profil:xoevVersionCodeliste(.) and not(xoev-profil:xsdDraft(.))]">
         <sch:let name="vcl" value="."/>
         <sch:assert role="error" id="C-CLH-1.2-R40-2" test="
               every $l in xoev-profil:xoevVersionCodeliste(.)/(beschreibung, aenderungZurVorversion)/xoev:get-language(.)
                  satisfies
                  ((empty(xoev-profil:xoevVersionCodeliste(.)/beschreibung) or xoev-profil:xoevVersionCodeliste(.)/beschreibung[starts-with(., concat('[', $l, ']'))]) and
                  (empty(xoev-profil:xoevVersionCodeliste(.)/aenderungZurVorversion) or xoev-profil:xoevVersionCodeliste(.)/aenderungZurVorversion[starts-with(., concat('[', $l, ']'))]))">C-CLH-1.2-R40-2: Jede für ein Metadatenelement genutzte Sprache muss ebenso als Sprache für die weiteren mehrsprachigen Metadatenelemente genutzt werden, außer für ein optionales Metadatenelement ist kein Wert angegeben, siehe Konformitätskriterium K-12 im Codelistenhandbuch. Die Codelistenversion <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
      </sch:rule>
   </sch:pattern>

   <sch:pattern id="pattern.C-CLH-1.2-R39">
      <sch:title>Korrekte Angabe in deutscher Sprache</sch:title>
      <sch:rule context="uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//packagedElement[uml:is-Class(.) and (xoev-profil:xoevCodeliste(.) or xoev-profil:xoevVersionCodeliste(.)) and not(xoev-profil:xsdDraft(.))]">
         <sch:assert role="error" id="C-CLH-1.2-R39" test="
               (empty(xoev-profil:xoevCodeliste(.)/nameLang[xoev:get-language(.) != 'de-DE']) or
               xoev-profil:xoevCodeliste(.)/nameLang[xoev:get-language(.) = 'de-DE']) and
               (empty(xoev-profil:xoevCodeliste(.)/nameKurz[xoev:get-language(.) != 'de-DE']) or
               xoev-profil:xoevCodeliste(.)/nameKurz[xoev:get-language(.) = 'de-DE']) and
               (empty(xoev-profil:xoevCodeliste(.)/beschreibung[xoev:get-language(.) != 'de-DE']) or
               xoev-profil:xoevCodeliste(.)/beschreibung[xoev:get-language(.) = 'de-DE']) and
               (empty(xoev-profil:xoevCodeliste(.)/herausgebernameLang[xoev:get-language(.) != 'de-DE']) or
               xoev-profil:xoevCodeliste(.)/herausgebernameLang[xoev:get-language(.) = 'de-DE']) and
               (empty(xoev-profil:xoevCodeliste(.)/herausgebernameKurz[xoev:get-language(.) != 'de-DE']) or
               xoev-profil:xoevCodeliste(.)/herausgebernameKurz[xoev:get-language(.) = 'de-DE']) and
               (empty(xoev-profil:xoevVersionCodeliste(.)/beschreibung[xoev:get-language(.) != 'de-DE']) or
               xoev-profil:xoevVersionCodeliste(.)/beschreibung[xoev:get-language(.) = 'de-DE']) and
               (empty(xoev-profil:xoevVersionCodeliste(.)/aenderungZurVorversion[xoev:get-language(.) != 'de-DE']) or
               xoev-profil:xoevVersionCodeliste(.)/aenderungZurVorversion[xoev:get-language(.) = 'de-DE'])">C-CLH-1.2-R39: Wenn für ein mehrsprachiges Metadatenelement eine Sprache ungleich "de-DE" angegeben ist, muss immer auch ein Wert für die Sprache de-DE mit expliziter Kennzeichnung ("[de-DE]") vorliegen, siehe Konformitätskriterien K-10 und K-11 im Codelistenhandbuch. Die Codeliste(nversion) <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
      </sch:rule>
   </sch:pattern>

   <sch:pattern id="pattern.C-CLH-1.2-R42-2">
      <sch:title>Korrekte Sprachangabe in Codelistenspalte</sch:title>
      <sch:rule context="
            uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//ownedAttribute[
            xoev-profil:xoevCodelistenspalte(.)/@sprache[. != ''] and not(xoev-profil:xsdDraft(.))]">
          <sch:assert role="error" id="C-CLH-1.2-R42-2" test="
            xoev-profil:xoevCodelistenspalte(.)/@sprache/matches(., '^[a-z]{2}-[A-Z]{2}.*$')">C-CLH-1.2-R42-2: Die Sprachangabe für eine Spalte muss auf der Basis von RFC-5646 kodiert sein (Muster: "xx-XX"), siehe Konformitätskriterium K-13 im Codelistenhandbuch. Die Codelistenspalte <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
      </sch:rule>
   </sch:pattern>

   <sch:let name="bestandskennungen" value="('urn:xoev-de:xdomea:codeliste:anschriftstyp', 'urn:de:dsmeld:schluesseltabelle:religion.nicht.steuererhebend', 'urn:xoev-de:xbau:codeliste:benachrichtigunganlass', 'urn:xoev-de:xbau:codeliste:formellebefundeart', 'urn:de:bund:kba:xkfz:codeliste:quittungsebene', 'urn:xoev-de:xdomea:codeliste:beteiligungsstatus', 'urn:xoev-de:xdomea:codeliste:bewertungsvorschlag', 'urn:xoev-de:xdomea:codeliste:dateiformat', 'urn:de:bund:kba:xkfz:codeliste:rolle', 'urn:xoev-de:xdomea:codeliste:datenaustauschart', 'urn:xoev-de:xdomea:codeliste:kommunikationsart', 'urn:de:bund:kba:xkfz:codeliste:schluesselnummerderueberwachungsinstitutionoderzdk', 'urn:xoev-de:xbau:nw:codeliste:technischeanlage', 'urn:de:bund:kba:xkfz:codeliste:statuselektronischerantrag', 'urn:de:bund:kba:xkfz:codeliste:statuselektronischerantragauskunft', 'urn:xoev-de:xdomea:codeliste:kompressionsverfahren', 'urn:xoev-de:xdomea:codeliste:konfigurationsparameter', 'urn:xoev-de:xdomea:codeliste:medium', 'urn:xoev-de:xdomea:codeliste:nachrichtentyp', 'urn:xoev-de:xdomea:codeliste:spezifischefehlermeldung0602', 'urn:de:gkleika:leika:modul', 'urn:xoev-de:xdomea:codeliste:spezifischefehlermeldung0604', 'urn:de:xinneres:codeliste:dvdvpraefix', 'urn:de:xinneres:codeliste:nachrichtentyp', 'urn:de:xmeld:schluesseltabelle:behoerdenauskunft.anforderungselement', 'urn:de:xwaffe:codelisten:munitionsbezeichnungkalibersynonym', 'urn:de:xauslaender:codelist:azr:abrufzweck', 'urn:xoev-de:xbau:codeliste:mppvotechnischeanlage', 'urn:de:xauslaender:codelist:azr:artablehnungfeststellungdtstaatsangehoerigkeit', 'urn:de:xauslaender:codelist:azr:artderanerkennung', 'urn:de:xauslaender:codelist:azr:artderaugenfarbe', 'urn:de:xauslaender:codelist:azr:artderauslieferungdurchlieferung', 'urn:de:xauslaender:codelist:azr:artderaussiedlereigenschaft', 'urn:de:xauslaender:codelist:azr:artderintegrationsundarbeitsvermittlungsdaten', 'urn:xoev-de:xdomea:codeliste:spezifischefehlermeldung0606', 'urn:de:xmeld:schluesseltabelle:xmeldit.aenderungsart', 'urn:de:xauslaender:codelist:aenderungsart', 'urn:dsmeld:schluesseltabelle:religion.nicht.steuererhebend', 'urn:xoev-de:xdomea:codeliste:spezifischefehlermeldung0607', 'urn:xoev-de:xdomea:codeliste:spezifischefehlermeldung0609', 'urn:de:xauslaender:codelist:azr:artderschule', 'urn:de:xauslaender:codelist:abhabh:aktenanforderung:antwort', 'urn:de:xauslaender:codelist:abhabh:aktenanforderung:grund', 'urn:xoev-de:xdomea:codeliste:spezifischefehlermeldung0612', 'urn:de:xauslaender:codelist:abhbamf:integration:kurseigenschaften', 'urn:xoev-de:bund:kba:codeliste:artderbremse', 'urn:xoev-de:xdomea:codeliste:spezifischefehlermeldung0615', 'urn:de:xauslaender:codelist:abhmb:grundderablehnung', 'urn:xoev-de:xdomea:codeliste:spezifischefehlermeldung0616', 'urn:de:xauslaender:codelist:aufenthaltsantrag:entscheidung', 'urn:xoev-de:xdomea:codeliste:spezifischefehlermeldung0617', 'urn:de:xauslaender:codelist:aufenthaltsantrag:gegenstand', 'urn:de:xauslaender:codelist:aufenthaltsantrag:ohneentscheidung', 'urn:de:xauslaender:codelist:aufenthaltsbeginart', 'urn:de:xauslaender:codelist:aufenthaltsendesart', 'urn:de:xauslaender:codelist:azr:artderverurteilung', 'urn:de:xauslaender:codelist:aufenthaltszweckart', 'urn:de:xauslaender:codelist:ausweisart', 'urn:de:xauslaender:codelist:azr:aenderungsart', 'urn:de:xauslaender:codelist:azr:anderername', 'urn:de:xwaffe:codelisten:munitionsbezeichnungkaliber', 'urn:xoev-de:xdomea:codeliste:spezifischefehlermeldung0620', 'urn:xoev-de:xdomea:codeliste:spezifischefehlermeldung0621', 'urn:xoev-de:xdomea:codeliste:spezifischefehlermeldung0623', 'urn:de:xauslaender:codelist:azr:artdesausreiseverbots', 'urn:xoev-de:bund:kba:codeliste:artderuntersuchungsstelle', 'urn:xoev-de:xdomea:codeliste:spezifischefehlermeldung0624', 'urn:xoev-de:xdomea:codeliste:spezifischefehlermeldung0625', 'urn:xoev-de:xdomea:codeliste:spezifischefehlermeldung0626', 'urn:xoev-de:bund:kba:codeliste:artdesdokuments', 'urn:xoev-de:bund:kba:codeliste:artdesgeschaeftsvorfalls', 'urn:xoev-de:xdomea:codeliste:spezifischefehlermeldung0631', 'urn:xoev-de:bund:kba:codeliste:artdesgutachtens', 'urn:xoev-de:xdomea:codeliste:transportweg', 'urn:xoev-de:bund:kba:codeliste:artdesmandats', 'urn:xoev-de:bund:kba:codeliste:artdessiegels', 'urn:xoev-de:xdomea:codeliste:vertraulichkeitsstufe', 'urn:xoev-de:xgewerbeanzeige:codeliste:artdereintragung', 'urn:de:xauslaender:codelist:azr:artdesberufs', 'urn:de:xauslaender:codelist:azr:artdeskursabschlusses', 'urn:xoev-de:xgewerbeanzeige:codeliste:empfaengerklassen', 'urn:xoev-de:bund:kba:codeliste:bearbeitungsart', 'urn:xoev-de:bund:kba:codeliste:datengruppenregistersatz', 'urn:xoev-de:xgewerbeanzeige:codeliste:grundfueranmeldung', 'urn:xoev-de:xgewerbeanzeige:codeliste:geschlecht', 'urn:xoev-de:xgewerbeanzeige:codeliste:janein', 'urn:xoev-de:xgewerbeanzeige:codeliste:korrekturgrund', 'urn:xoev-de:bund:kba:codeliste:ergebnisderuntersuchung', 'urn:xoev-de:xgewerbeanzeige:codeliste:nachrichtentypen', 'urn:de:xauslaender:codelist:azr:artdeskurses', 'urn:xoev-de:bund:kba:codeliste:kennzeichenformat', 'urn:xoev-de:xgewerbeanzeige:codeliste:rechtsformen', 'urn:de:xauslaender:codelist:azr:artdesschulabschlusses', 'urn:xoev-de:bund:kba:codeliste:nachrichtentyp', 'urn:de:xauslaender:codelist:azr:artdesstraftatverdachts', 'urn:xoev-de:bund:kba:codeliste:nummerderfeinstaubplakette', 'urn:xoev-de:xjustiz:codeliste:bnotk.empfangstyp.ztr', 'urn:de:xauslaender:codelist:bamfabh:asyl:abschlussinformationen', 'urn:de:xauslaender:codelist:bamfabh:asyl:antragsniederschrift', 'urn:xoev-de:bund:kba:codeliste:positionderbremse', 'urn:de:xauslaender:codelist:abhmb:grundderabmeldung', 'urn:de:xauslaender:codelist:bamfabh:asyl:asylantrag', 'urn:de:xauslaender:codelist:bamfabh:asyl:feststellungsinformationen', 'urn:de:xauslaender:codelist:bamfabh:asyl:gerichtsinstanz', 'urn:xoev-de:xjustiz:codeliste:bnotk.empfangstyp.ztr.bw', 'urn:de:xauslaender:codelist:bamfabh:asyl:personendaten:aenderungsgrund', 'urn:de:xauslaender:codelist:bamfabh:int:auskunftnichtmoeglich', 'urn:xoev-de:xjustiz:codeliste:bnotk.mitteilungstyp.ztr.bw', 'urn:de:xauslaender:codelist:azr:arteinschraenkungpolitischebetaetigung', 'urn:de:xauslaender:codelist:azr:artpassrechtlichemassnahmen', 'urn:de:xauslaender:codelist:azr:artpersonalie', 'urn:de:xauslaender:codelist:dokumentformat', 'urn:de:xauslaender:codelist:familienstand', 'urn:de:xauslaender:codelist:fehlercodes:synchron', 'urn:de:xauslaender:codelist:gericht', 'urn:de:xauslaender:codelist:int:behoerdentyp', 'urn:de:xauslaender:codelist:azr:artueberwachungsmassnahme', 'urn:de:xauslaender:codelist:mbabh:abmeldung', 'urn:de:xauslaender:codelist:mbauskunftssperre', 'urn:de:xauslaender:codelist:nebenbestimmungen:beschaeftigung', 'urn:xoev-de:xjustiz:codeliste:bnotk.urkunde.status.ztr', 'urn:de:xauslaender:codelist:nebenbestimmungen:bildungsweg', 'urn:xoev-de:xjustiz:codeliste:grbu.belastungsart.abtiii', 'urn:de:xauslaender:codelist:nebenbestimmungen:erloeschen', 'urn:de:xauslaender:codelist:nebenbestimmungen:oertlichebeschraenkung', 'urn:xoev-de:bund:kba:codeliste:quittungsebene', 'urn:de:xauslaender:codelist:nebenbestimmungen:selbstaendig', 'urn:de:xauslaender:codelist:religion', 'urn:xoev-de:xjustiz:codeliste:grbu.dokumentart', 'urn:de:xauslaender:codelist:vertretungsart', 'urn:xoev-de:xjustiz:codeliste:grbu.rang', 'urn:de:xauslaender:codelist:vonamtswegen', 'urn:de:xauslaender:codelist:wohnungsstatus', 'urn:de:xauslaender:codelist:azr:artzurueckweisungzurueckschiebung', 'urn:xoev-de:xjustiz:codeliste:grbu.rollenbezeichnung', 'urn:xoev-de:bund:kba:codeliste:statuselektronischerantrag', 'urn:de:xwaffe:codelisten:herstellerbezeichnungsammlung', 'urn:xoev-de:xauslaender:codeliste:asyl:datenberichtigungsanlass', 'urn:xoev-de:xjustiz:codeliste:reg.besondere-befreiung', 'urn:xoev-de:xauslaender:codeliste:asyl:einstellungsgrund', 'urn:xoev-de:xjustiz:codeliste:reg.dokumentart', 'urn:xoev-de:xauslaender:codeliste:asyl:fortfuehrungsantragart', 'urn:xoev-de:xauslaender:codeliste:asyl:prognosefolgeantrag', 'urn:de:xauslaender:codelist:azr:asylstatus', 'urn:xoev-de:xauslaender:codeliste:asyl:ruecknahmegrund', 'urn:de:bund:bzst:schluessel:rts.fehlercodes', 'urn:de:xauslaender:codelist:azr:aufenthaltserlaubnis', 'urn:de:xauslaender:codelist:azr:aufenthaltsgestattung', 'urn:xoev-de:xjustiz:codeliste:reg.dokumentstatus', 'urn:de:xauslaender:codelist:azr:dokumentenformat', 'urn:de:xauslaender:codelist:azr:dokumenttyp', 'urn:de:xauslaender:codelist:azr:entscheidungba', 'urn:de:xauslaender:codelist:azr:euaufenthaltsrecht', 'urn:de:xauslaender:codelist:azr:familienbeziehung', 'urn:de:xauslaender:codelist:azr:gesundheitsdatenart', 'urn:de:xauslaender:codelist:azr:graddersprachkenntnis', 'urn:de:xauslaender:codelist:azr:trefferkategorie', 'urn:de:xauslaender:codelist:azr:lichtbildgroesse', 'urn:de:dsmeld:schluesseltabelle:auskunftssperre', 'urn:de:xauslaender:codelist:azr:meldestatusart', 'urn:de:xauslaender:codelist:azr:artderfestnahmeaufenthaltsermittlung', 'urn:de:xauslaender:codelist:azr:nebenbestimmungerwerbstaetigkeit', 'urn:de:xauslaender:codelist:azr:rechtsstellung', 'urn:xoev-de:xjustiz:codeliste:reg.rollenbezeichnung', 'urn:xoev-de:xjustiz:codeliste:reg.status-rechtstraeger', 'urn:de:xauslaender:codelist:azr:sicherheitsleistung', 'urn:de:dsmeld:schluesseltabelle:staatsangehoerigkeit.glaubhaftmachung', 'urn:de:xauslaender:codelist:azr:sicherheitsrechtlichebefragung', 'urn:de:xauslaender:codelist:azr:sichtbarkeitdessuchvermerks', 'urn:de:xauslaender:codelist:azr:suchprofil', 'urn:xoev-de:bund:kba:codeliste:typdergebuehrenaufstellung', 'urn:de:xauslaender:codelist:azr:suchvermerk', 'urn:xoev-de:bund:kba:codeliste:typdesidentifikationsdokuments', 'urn:de:xauslaender:codelist:azr:uebermittlungssperre', 'urn:de:xauslaender:codelist:azr:unerlaubteeinreiseundaufenthaltart', 'urn:de:xauslaender:codelist:azr:verfuegungstextstatus', 'urn:xoev-de:bund:kba:codeliste:versandart', 'urn:de:xauslaender:codelist:azr:zustimmungsfreiebeschaeftigung', 'urn:xoev-de:bund:kba:xkfz:codeliste:statusprozessschritt', 'urn:de:bund:bfj:schluesseltabelle:anerkennungsform.sonstige', 'urn:de:bund:bfj:schluesseltabelle:anerkennungsform.ueberbeglaubigung', 'urn:de:bund:bfj:schluesseltabelle:fuehrungszeugnis.anfrageart', 'urn:de:bund:bfj:schluesseltabelle:fuehrungszeugnis.gebuehr', 'urn:de:xmeld:schluesseltabelle:antwortstatus', 'urn:de:xmeld:schluesseltabelle:azr.anlass', 'urn:de:xmeld:schluesseltabelle:behoerdenauskunft.aktualitaet.suche.status', 'urn:de:xmeld:schluesseltabelle:behoerdenauskunft.ergebnisstatus', 'urn:de:xmeld:schluesseltabelle:lra.aenderung.anlass', 'urn:de:xmeld:schluesseltabelle:behoerdenauskunft.nichterstellung.grund', 'urn:de:xmeld:schluesseltabelle:bzst.anforderung.idnr', 'urn:xoev-de:xdomea:codeliste:aussonderungsart', 'urn:de:xmeld:schluesseltabelle:bzst.antwort.idnr-ehegatte-lebenspartner', 'urn:de:xmeld:schluesseltabelle:bzst.beendigung.der.zustaendigkeit', 'urn:de:xmeld:schluesseltabelle:bzst.hinweis.auf.inkonsistenz', 'urn:de:xmeld:schluesseltabelle:bzst.hinweis.auf.inkonsistenz.rolle.beteiligte.person', 'urn:de:xmeld:schluesseltabelle:dsrv.anlass.bruttolieferung', 'urn:de:xmeld:schluesseltabelle:ehegatte.oder.lebenspartner', 'urn:de:xmeld:schluesseltabelle:fortschreibung.datenuebermittlungsanlaesse.fachspezifisch', 'urn:de:xmeld:schluesseltabelle:melderegister.abweichung', 'urn:de:xmeld:schluesseltabelle:melderegisterauskunft.ergebnisstatus', 'urn:de:xmeld:schluesseltabelle:melderegisterauskunft.nichterstellung.grund', 'urn:de:xmeld:schluesseltabelle:melderegisterauskunft.optionen', 'urn:de:xmeld:schluesseltabelle:melderegisterauskunft.zusatzinformation', 'urn:de:xmeld:schluesseltabelle:mime-type', 'urn:de:xmeld:schluesseltabelle:partnerdaten.anlass.der.fortschreibung', 'urn:de:xmeld:schluesseltabelle:partnerschaftsinformation', 'urn:de:xmeld:schluesseltabelle:quittung.ebene', 'urn:de:xmeld:schluesseltabelle:ruecksendung.einer.nachricht', 'urn:de:xmeld:schluesseltabelle:stornierung', 'urn:de:xmeld:schluesseltabelle:vorausgefuellter.meldeschein.antwortstatus', 'urn:de:xmeld:schluesseltabelle:xmeld.datenuebermittlungsanlaesse', 'urn:de:xmeld:schluesseltabelle:xmeldit.art.der.untersuchung', 'urn:de:xmeld:schluesseltabelle:xmeldit.konsequenz.fehler', 'urn:xoev-de:xdomea:codeliste:datentyp', 'urn:xoev-de:xmeld:codeliste:xmeld.fortschreibung.aenderungsart', 'urn:xoev-de:xmeld:codeliste:xmeld.kirche.hintergrundinformation', 'urn:de:xauslaender:codelist:azr:artdesanlassesderausschreibung', 'urn:xoev-de:bund:kba:codeliste:artdergebuehr', 'urn:xoev-de:xdomea:codeliste:konfigurationsparametergruppe', 'urn:de:xauslaender:codelist:azr:artderausschreibung', 'urn:xoev-de:xdomea:codeliste:schriftgutobjekttyp', 'urn:xoev-de:xdomea:codeliste:spezifischefehlermeldung0601', 'urn:xoev-de:xdomea:codeliste:spezifischefehlermeldung0603', 'urn:xoev-de:xdomea:codeliste:spezifischefehlermeldung0605', 'urn:xoev-de:xdomea:codeliste:spezifischefehlermeldung0608', 'urn:xoev-de:xdomea:codeliste:spezifischefehlermeldung0610', 'urn:xoev-de:xdomea:codeliste:spezifischefehlermeldung0611', 'urn:xoev-de:xjustiz:codeliste:reg.mitteilungsart', 'urn:xoev-de:xdomea:codeliste:spezifischefehlermeldung0613', 'urn:xoev-de:xdomea:codeliste:spezifischefehlermeldung0614', 'urn:xoev-de:xbau:codeliste:xbau-fehlerkennzahlen', 'urn:de:bund:kba:xkfz:codeliste:typderreferenz', 'urn:de:bund:kba:xkfz:codeliste:typderreferenzdatei', 'urn:de:bund:kba:xkfz:codeliste:typderuntersuchung', 'urn:de:bund:kba:xkfz:codeliste:typdeskontakts', 'urn:de:bund:kba:xkfz:codeliste:versandart', 'urn:de:bund:kba:xkfz:codeliste:xkfzkommunikationspartner', 'urn:de:bund:kba:xkfz:codeliste:waehrung', 'urn:de:dsmeld:schluesseltabelle:anschrift.unbekannt', 'urn:de:dsmeld:schluesseltabelle:familienstand', 'urn:de:dsmeld:schluesseltabelle:familienstand.beendigungsgrund', 'urn:de:dsmeld:schluesseltabelle:gesetzlicher.vertreter', 'urn:de:dsmeld:schluesseltabelle:geschlecht', 'urn:de:dsmeld:schluesseltabelle:passversagung.status', 'urn:de:dsmeld:schluesseltabelle:religion.steuererhebend', 'urn:de:dsmeld:schluesseltabelle:wahlausschluss', 'urn:de:dsmeld:schluesseltabelle:wohnungsart', 'urn:de:dsmeld:schluesseltabelle:wohnungsstatus', 'urn:de:fim:leika:modul', 'urn:de:fim:leika:verrichtung', 'urn:de:gkleika:leika:leistungsgruppierung', 'urn:de:gkleika:leika:typisierung', 'urn:de:xauslaender:codelist:aufenthaltsstatusart', 'urn:xoev-de:xdomea:codeliste:spezifischefehlermeldung0618', 'urn:xoev-de:xdomea:codeliste:spezifischefehlermeldung0619', 'urn:xoev-de:xauslaender:codeliste:sprachenkatalog', 'urn:xoev-de:xdomea:codeliste:spezifischefehlermeldung0622', 'urn:de:bund:destatis:bevoelkerungsstatistik:schluessel:bundesland', 'urn:de:xauslaender:codelist:azr:verpflichtungserklaerung', 'urn:xoev-de:xdomea:codeliste:spezifischefehlermeldung0627', 'urn:xoev-de:xdomea:codeliste:spezifischefehlermeldung0628', 'urn:xoev-de:xdomea:codeliste:spezifischefehlermeldung0632', 'urn:xoev-de:fim:codeliste:ozg-themenfeld', 'urn:xoev-de:xgewerbeanzeige:codeliste:artdermeldung', 'urn:xoev-de:xgewerbeanzeige:codeliste:artderniederlassung', 'urn:xoev-de:xgewerbeanzeige:codeliste:funktioneinerperson', 'urn:xoev-de:xgewerbeanzeige:codeliste:grundfuerabmeldung', 'urn:de:xauslaender:codelist:nachrichtentyp', 'urn:de:xauslaender:codelist:bamftgs:int:verkuerzennichtmoeglich', 'urn:de:xfalldaten:kommunikationskanal', 'urn:de:xmeld:schluesseltabelle:melderegisterauskunft.gewerblicher.zweck', 'urn:de:xmeld:schluesseltabelle:rueckweisungsgrund', 'urn:de:xoev:codeliste:erreichbarkeit', 'urn:de:xoev:codeliste:koordinatensystemtyp', 'urn:de:xprozess:codeliste:modellierungsmethode', 'urn:de:bund:kba:xkfz:codeliste:sucheinschraenkungkennzeichen', 'urn:de:bund:kba:xkfz:codeliste:rechtsgrundlagehalterauskunft', 'urn:de:xprozess:codeliste:zwecksetzung', 'urn:de:xta:codeliste:business.scenario', 'urn:de:xta:codeliste:report.type', 'urn:de:xta:codeliste:type.of.party.identifier', 'urn:de:bund:kba:xkfz:codeliste:nutzungbankverbindung', 'urn:de:bund:kba:xkfz:codeliste:statusgutachten', 'urn:de:bund:kba:xkfz:codeliste:typdesidentifikationsdokuments', 'urn:de:xzufi:codeliste:zustaendigkeitsrolle', 'urn:eu:commission:regulation:105:2007:nuts:nuts-1', 'urn:xoev-de:bund:bamf:codeliste:integration:fehlercodes:synchron.spezifisch', 'urn:xoev-de:xbau:codeliste:baulicheanlagen.sonstige', 'urn:de:xauslaender:codelist:bamfabh:int:kursart', 'urn:xoev-de:bund:bamf:codeliste:asyl:bamfaussenstellen', 'urn:de:xauslaender:codelist:azr:artdergrenzfahndung', 'urn:de:bund:bamf:codelist:integration:ablehnungsgrund', 'urn:de:xauslaender:codelist:bamfabh:integration:artberechtigung', 'urn:de:xauslaender:codelist:azr:artdesanlassesdergrenzfahndung', 'urn:xoev-de:kosit:codeliste:icd', 'urn:de:xauslaender:codelist:bamfabh:int:verpflichtungnichtmoeglich', 'urn:de:xauslaender:codelist:integration:ba.dienststellen', 'urn:de:bund:bamf:codelist:berd:fehlercode', 'urn:de:bund:bamf:codelist:berd:dublettenverdacht', 'urn:de:bund:bamf:codelist:berd:ablehnungsgrund', 'urn:de:bund:bamf:codelist:berd:aufenthaltsstatus', 'urn:xoev-de:bund:bmj:codeliste:fundstellennachweis.bund.a', 'urn:de:bund:bamf:codelist:berd:modulart', 'urn:xoev-de:bund:destatis:codeliste:xmeld.zensus.rueckweisung-fehlercodes', 'urn:xoev-de:bund:destatis:codeliste:xmeld.zenus.rueckweisung-fehlercodes', 'urn:xoev-de:bund:kba:codeliste:artdermonetaereneinnahme', 'urn:xoev-de:bund:kba:codeliste:artderumruestung', 'urn:xoev-de:bund:kba:codeliste:artderunterlage', 'urn:xoev-de:bund:kba:codeliste:artderuntersuchung', 'urn:xoev-de:bund:kba:codeliste:artderzahlung', 'urn:xoev-de:bund:kba:codeliste:auskunftsmedium', 'urn:xoev-de:bund:kba:codeliste:kbaarbeitsgang', 'urn:xoev-de:bund:kba:codeliste:kurzzeichenherstellerdruckstuecke', 'urn:xoev-de:bund:kba:codeliste:lieferdienst', 'urn:xoev-de:bund:kba:codeliste:nutzungbankverbindung', 'urn:xoev-de:bund:kba:codeliste:prozessschrittname', 'urn:xoev-de:bund:kba:codeliste:prueforganisation', 'urn:xoev-de:bund:kba:codeliste:quittungsart', 'urn:de:bund:bamf:codelist:berd:artbeschaeftigung', 'urn:xoev-de:bund:kba:codeliste:rechtsgrundlagehalterauskunft', 'urn:xoev-de:bund:kba:codeliste:rolle', 'urn:de:xpersonenstand:codeliste:staat', 'urn:de:xpersonenstand:codeliste:staatsangehoerigkeit', 'urn:xoev-de:bund:kba:codeliste:statuselektronischerantragauskunft', 'urn:xpersonenstand:schluesseltabelle:aufenthaltsstatus', 'urn:xpersonenstand:schluesseltabelle:beendigungsgrundfamilienstand', 'urn:xpersonenstand:schluesseltabelle:beschlussart', 'urn:xpersonenstand:schluesseltabelle:bestattungsart', 'urn:xpersonenstand:schluesseltabelle:familienstand', 'urn:xpersonenstand:schluesseltabelle:familienstandpersonenstandswesen', 'urn:xpersonenstand:schluesseltabelle:geschlecht', 'urn:xpersonenstand:schluesseltabelle:namensart', 'urn:xpersonenstand:schluesseltabelle:registerart', 'urn:xpersonenstand:schluesseltabelle:wahlehename', 'urn:xpersonenstand:schluesseltabelle:wahllpname', 'urn:xoev-de:bund:kba:codeliste:statusgutachten', 'urn:xoev-de:bund:kba:codeliste:sucheinschraenkungkennzeichen', 'urn:xoev-de:bund:kba:codeliste:systemcode', 'urn:xoev-de:bund:kba:codeliste:typderreferenzdatei', 'urn:xoev-de:bund:kba:codeliste:typderuntersuchung', 'urn:xoev-de:bund:kba:codeliste:typdesdokuments', 'urn:xoev-de:bund:kba:codeliste:typdeskennzeichens', 'urn:xoev-de:bund:kba:codeliste:typdeskontakts', 'urn:xoev-de:bund:kba:codeliste:waehrung', 'urn:de:bund:bamf:codelist:berd:artberechtigungverpflichtung', 'urn:xoev-de:bund:kba:xkfz:codeliste:herstellerdruckstuecke', 'urn:xoev-de:bund:kba:xkfz:codeliste:steuerzahlweise', 'urn:xoev-de:kirche:codeliste:xmeld.kirchen.rts-fehlercodes', 'urn:xoev-de:kosit:codeliste:handwerkskammern', 'urn:xoev-de:stala:codeliste:xmeld.statistik.bevstatg.rueckweisung-fehlercodes', 'urn:xoev-de:xbau:codeliste:erleichterung.gegenstand', 'urn:xoev-de:xdomea:codeliste:allgemeinerueckmeldung', 'urn:xoev-de:xbau:codeliste:xbau-mimetypes', 'urn:de:bund:destatis:bevoelkerungsstatistik:schluessel:synopse-gebiete', 'urn:xoev-de:bund:kba:codeliste:kba-arbeitsgang', 'urn:xoev-de:kosit:codeliste:eas', 'urn:xoev-de:bund:kba:codeliste:typderreferenz', 'urn:xoev-de:bund:kba:codeliste:quittungscode', 'urn:xoev-de:fim:codeliste:sdginformationsbereich', 'urn:xoev-de:fim:codeliste:ozg-lage', 'urn:xoev-de:fim:codeliste:ozg-leistung', 'urn:xoev-de:xgewerbeanzeige:codeliste:grundfuerummeldung', 'urn:de:dvzmv:codelisten:verarbeitung', 'urn:xoev-de:xgewerbeanzeige:codeliste:handwerkskammern', 'urn:xoev-de:fim:codeliste:onlinedienstlinktyp', 'urn:de:dvzmv:nwr:codelisten:verarbeitung', 'urn:xoev-de:fim:codeliste:identifizierungsmittel', 'urn:xoev-de:bund:kba:codeliste:nachrichtentypen', 'urn:de:xauslaender:codelist:azr:artdesausweispruefungsergebnis', 'urn:de:xauslaender:codelist:azr:wohnsitzauflage', 'urn:de:xauslaender:codelist:azr:artdeseinreiseaufenthaltsverbots', 'urn:de:xauslaender:codelist:azr:artderabschiebung', 'urn:de:xauslaender:codelist:azr:artdesausreisenachweis', 'urn:de:xauslaender:codelist:azr:artderausweisung', 'urn:de:xauslaender:codelist:azr:artderausreisefoerderung', 'urn:de:xauslaender:codelist:azr:artdesabschiebungsverbots', 'urn:xoev-de:xjustiz:codeliste:bnotk.dokumententyp.ztr.bw', 'urn:xoev-de:xjustiz:codeliste:bnotk.registrierung.status.ztr.bw', 'urn:xoev-de:xauslaender:codeliste:asyl:abschlusssachverhalt', 'urn:de:xauslaender:codelist:volkszugehoerigkeit', 'urn:de:xauslaender:codelist:azr:niederlassungserlaubnis', 'urn:xoev-de:xjustiz:codeliste:grbu.berechtigungsveraeltnis', 'urn:de:xauslaender:codelist:azr:aufenthaltsstatus', 'urn:xoev-de:xjustiz:codeliste:grbu.berechtigungsverhaeltnis', 'urn:xoev-de:bund:kba:codeliste:stba', 'urn:de:fim:leika:leistungsgruppierung', 'urn:xoev-de:xauslaender:codeliste:asyl:teilabschlusssachverhalt', 'urn:xoev-de:bund:bmi:bit:codeliste:dvdv.praefix', 'urn:xoev-de:bund:bva:azr:codeliste:xmeld.fachliche-fehlercodes', 'urn:xoev-de:fim:codeliste:xzufi.anschrifttyp', 'urn:xoev-de:fim:codeliste:xzufi.begriffimkontexttyp', 'urn:xoev-de:xbau:codeliste:abweichungart', 'urn:xoev-de:fim:codeliste:xzufi.fristtyp', 'urn:xoev-de:xbau:codeliste:baumassnahme', 'urn:xoev-de:xbau:codeliste:bautechnischernachweisart', 'urn:xoev-de:xbau:codeliste:bauvorlageberechtigungsachverhalt', 'urn:xoev-de:fim:codeliste:xzufi.hierarchietyp', 'urn:xoev-de:xbau:codeliste:bauweise', 'urn:xoev-de:xbau:codeliste:beteiligungrolle', 'urn:xoev-de:fim:codeliste:xzufi.kostentyp', 'urn:xoev-de:xbau:codeliste:formellebefundeantragart', 'urn:xoev-de:fim:codeliste:xzufi.leistungsadressat', 'urn:xoev-de:xbau:codeliste:genehmigungsfreistellung', 'urn:xoev-de:fim:codeliste:xzufi.nachrichtantwortcode', 'urn:xoev-de:xbau:codeliste:mbogaragentyp', 'urn:xoev-de:xbau:codeliste:mbogebaeudeklasse', 'urn:xoev-de:fim:codeliste:xzufi.onlinedienstdynamischerparametertyp', 'urn:xoev-de:fim:codeliste:xzufi.signatur', 'urn:xoev-de:xbau:codeliste:mbosonderbauten', 'urn:xoev-de:xbau:codeliste:mppvobauwerksklasse', 'urn:xoev-de:fim:codeliste:xzufi.tagesposition', 'urn:xoev-de:fim:codeliste:xzufi.tagestyp', 'urn:xoev-de:xbau:codeliste:mppvonachpruefunggrund', 'urn:xoev-de:fim:codeliste:xzufi.zeiteinheit', 'urn:xoev-de:xbau:codeliste:mppvopruefungtechnischeanlageanlass', 'urn:xoev-de:xbau:codeliste:mppvotechnischeanlageweiterbetrieb', 'urn:xoev-de:fim:codeliste:xzufi.zeitserientyp', 'urn:xoev-de:xbau:codeliste:nebenbestimmungart', 'urn:xoev-de:fim:codeliste:xzufi.zustaendigkeitskriterium', 'urn:xoev-de:xbau:codeliste:statistikmeldunganlass', 'urn:xoev-de:xbau:codeliste:vorbescheidbetreff', 'urn:xoev-de:xbau:codeliste:vorlagenbauantragbauvorhaben', 'urn:xoev-de:xbau:codeliste:vorlagenbauantragbearbeitung', 'urn:xoev-de:xbau:codeliste:vorlagenbauzustand', 'urn:xoev-de:xbau:codeliste:xbau-nachrichten', 'urn:xoev-de:xfim:codeliste:xzufi.leistungsklasse', 'urn:xoev-de:kosit:codeliste:rec21', 'urn:de:xauslaender:codelist:int:abschlusstestartsprache', 'urn:xoev-de:kosit:codeliste:currency-codes', 'urn:de:xauslaender:codelist:int:abschlusstestdatensprache', 'urn:xoev-de:kosit:codeliste:vatex', 'urn:xoev-de:kosit:codeliste:untdid.1001', 'urn:de:xauslaender:codelist:int:abschlusstestergebnisinterpretation', 'urn:xoev-de:kosit:codeliste:untdid.1153', 'urn:xoev-de:kosit:codeliste:untdid.2005', 'urn:xoev-de:kosit:codeliste:untdid.4451', 'urn:xoev-de:kosit:codeliste:untdid.5189', 'urn:xoev-de:kosit:codeliste:untdid.5305', 'urn:xoev-de:kosit:codeliste:untdid.7143', 'urn:xoev-de:kosit:codeliste:mime-type-xrechnung', 'urn:xoev-de:kosit:codeliste:rec20', 'urn:xoev-de:kosit:codeliste:untdid.7161', 'urn:xoev-de:bund:bfj:codeliste:bfjstaat', 'urn:xoev-de:kosit:codeliste:country-codes', 'urn:xoev-de:bund:bfj:codeliste:bfj.berichtigungart', 'urn:xoev-de:bund:bfj:codeliste:bfj.staat', 'urn:xoev-de:bund:bfj:codeliste:bfj.fehlerkennzahl', 'urn:de:xauslaender:codelist:azr:artderduldung', 'urn:xoev-de:bund:bfj:codeliste:bfj.geschlecht', 'urn:xoev-de:xgewerbeanzeige:codeliste:schematron-fehlercodes', 'urn:xoev-de:bund:bfj:codeliste:bfj.uebermittelndestelle', 'urn:xoev-de:bund:bfj:codeliste:bfj.waehrung', 'urn:xoev-de:xgewerbeanzeige:codeliste:beteiligungoeffentlichehand', 'urn:xoev-de:bund:bfj:codeliste:bzr.behoerdenfuehrungszeugnisgrund', 'urn:de:xauslaender:codelist:azr:sachverhaltsgruppe', 'urn:xoev-de:bund:bfj:codeliste:bzr.benachrichtigunggrund', 'urn:xoev-de:bund:bfj:codeliste:bzr.freiheitsentziehungart', 'urn:de:bund:ba:codelist:integration:ba.dienststellen', 'urn:xoev-de:bund:bfj:codeliste:bfj.gebuehrenbefreiunggrund', 'urn:xoev-de:bund:bfj:codeliste:bzr.hinweisanlass', 'urn:xoev-de:bund:bfj:codeliste:bzr.hinweisart', 'urn:xoev-de:xgewerbeanzeige:codeliste:laenderkennziffern', 'urn:xoev-de:xgewerbeanzeige:codeliste:status', 'urn:xoev-de:xgewerbeanzeige:codeliste:unfallversicherungstraeger', 'urn:xoev-de:xgewerbeanzeige:codeliste:verdachtsmomente', 'urn:xoev-de:xgewerbeanzeige:codeliste:ursachefuerabmeldung', 'urn:xoev-de:xgewerbeanzeige:codeliste:weiterekommunikationspartner', 'urn:xoev-de:xjustiz:codeliste:bnotk.dokumententyp.ztr', 'urn:xoev-de:bund:bfj:codeliste:bzr.identitaetsdokumentart', 'urn:xoev-de:xjustiz:codeliste:bnotk.mitteilungstyp.ztr', 'urn:xoev-de:xjustiz:codeliste:bnotk.registrierung.status.ztr', 'urn:xoev-de:bund:bfj:codeliste:bzr.textkennzahl', 'urn:de:xauslaender:codelist:azr:artdereinreisebedenken', 'urn:xoev-de:xjustiz:codeliste:bnotk.vorgangsart.ztr', 'urn:xoev-de:xjustiz:codeliste:bnotk.urkunde.status.ztr.bw', 'urn:xoev-de:xjustiz:codeliste:grbu.auszugsart', 'urn:xoev-de:xjustiz:codeliste:bnotk.vorgangsart.ztr.bw', 'urn:xoev-de:xjustiz:codeliste:grbu.belastungsart.abtii', 'urn:de:xauslaender:codelist:azr:deutschestaatsangehoerigkeitart', 'urn:xoev-de:xjustiz:codeliste:grbu.ereignis', 'urn:xoev-de:mv:em:codeliste:xprozess:handlungsgrundlagenart', 'urn:xoev-de:bund:bfj:codeliste:gzr.verwendungszweckbehoerdenvorlage', 'urn:xoev-de:xjustiz:codeliste:grbu.veraenderungen.abtii', 'urn:xoev-de:xjustiz:codeliste:grbu.veraenderungen.abtiii', 'urn:xoev-de:bund:bfj:codeliste:gzr.gewerbeart', 'urn:xoev-de:xjustiz:codeliste:reg.allgemeine-befreiung', 'urn:xoev-de:xjustiz:codeliste:reg.allgemeine-vertretungsregelung', 'urn:xoev-de:xjustiz:codeliste:reg.besondere-vertretungsregelung', 'urn:xoev-de:xjustiz:codeliste:reg.eintragungsart', 'urn:xoev-de:xjustiz:codeliste:reg.rechtsform', 'urn:xoev-de:xjustiz:codeliste:reg.mitteilungsgsart', 'urn:xoev-de:bund:bfj:codeliste:gzr.gewerbeschluessel', 'urn:xoev-de:xjustiz:codeliste:reg.sachliche-erweiterung-prokura', 'urn:xoev-de:xpersonenstandsregister:codeliste:geschlecht', 'urn:xoev-de:xpersonenstand:codelist:nachrichtentyp', 'urn:xoev-de:xrechnung:codeliste:untdid.4461', 'urn:xoev-de:bund:bfj:codeliste:gzr.rechtsform', 'urn:xoev-de:bund:bfj:codeliste:gzr.oeffentlichesregister', 'urn:xoev-de:bund:bfj:codeliste:gzr.rechtsvorschriften', 'urn:de:bund:bamf:codelist:integration:nachfragegrund', 'urn:de:bund:bfj:schluesseltabelle:behoerdenkennzeichen', 'urn:de:bund:bfj:schluesseltabelle:fuehrungszeugnis.verwendungszweck', 'urn:de:bund:bfj:schluesseltabelle:justizbehoerdenkennzeichen', 'urn:xoev-de:bund:bfj:codeliste:nachrichtencode.bzr.anfrageaehnlichenservice', 'urn:de:bund:bmi:meldewesen:schluessel:religion_nicht_steuererhebend', 'urn:de:bund:bmi:meldewesen:schluessel:religion_steuererhebend', 'urn:de:bund:bzst:schluessel:fachliche.fehlercodes', 'urn:xoev-de:xgewerbeanzeige:codeliste:rueckweisungsgruende', 'urn:xoev-de:bund:bfj:codeliste:gzr.textkennzahl', 'urn:xoev-de:bund:bfj:codeliste:nachrichtencode.bzr.anfrageunbeschraenkteauskunft', 'urn:xoev-de:bund:bfj:codeliste:nachrichtencode.bzr.antragbehoerdenfuehrungszeugnis', 'urn:de:bund:kba:xkfz:codeliste:artderbremse', 'urn:xoev-de:bund:bfj:codeliste:nachrichtencode.bzr.antragprivatfuehrungszeugnis', 'urn:xoev-de:bund:bfj:codeliste:nachrichtencode.gzr.anfragebetroffeneperson', 'urn:xoev-de:bund:bfj:codeliste:nachrichtencode.bzr.auskunft', 'urn:xoev-de:bund:bfj:codeliste:nachrichtencode.bzr.mitteilung', 'urn:xoev-de:bund:bfj:codeliste:nachrichtencode.gzr.anfrageoeffentlichestelle', 'urn:xoev-de:bund:bfj:codeliste:nachrichtencode.gzr.auskunft', 'urn:xoev-de:bund:bfj:codeliste:nachrichtencode.gzr.mitteilung', 'urn:xoev-de:bund:bfj:codeliste:xbfj-nachrichten', 'urn:de:bund:destatis:bevoelkerungsstatistik:schluessel:kreis', 'urn:xoev-de:bund:bfj:codeliste:bfj.verwendungszweckauskunft', 'urn:xoev-de:bund:bfj:codeliste:bfj.behoerde', 'urn:xoev-de:bund:kba:codeliste:xkfzkommunikationspartner', 'urn:de:bund:destatis:bevoelkerungsstatistik:schluessel:staatsangehoerigkeit', 'urn:de:bund:kba:xkfz:codeliste:artderumruestung', 'urn:de:bund:kba:xkfz:codeliste:artderunterlage', 'urn:de:bund:kba:xkfz:codeliste:artderuntersuchung', 'urn:de:bund:kba:xkfz:codeliste:artderzahlung', 'urn:de:bund:kba:xkfz:codeliste:artdesgeschaeftsvorfalls', 'urn:de:bund:kba:xkfz:codeliste:artdesgutachtens', 'urn:de:bund:kba:xkfz:codeliste:auskunftsmedium', 'urn:de:bund:kba:xkfz:codeliste:datengruppenregistersatz', 'urn:de:bund:kba:xkfz:codeliste:ergebnisderuntersuchung', 'urn:de:bund:kba:xkfz:codeliste:kba-arbeitsgang', 'urn:de:bund:kba:xkfz:codeliste:kennzeichenformat', 'urn:de:bund:kba:xkfz:codeliste:lieferdienst', 'urn:de:bund:kba:xkfz:codeliste:nachrichtentyp', 'urn:de:bund:kba:xkfz:codeliste:positionderbremse', 'urn:de:bund:kba:xkfz:codeliste:prueforganisation', 'urn:de:bund:kba:xkfz:codeliste:artdergebuehr', 'urn:de:bund:kba:xkfz:codeliste:artdermonetaereneinnahme', 'urn:de:bund:kba:xkfz:codeliste:artderuntersuchungsstelle', 'urn:de:xwaffe:codelisten:abfragegrund', 'urn:de:xwaffe:codelisten:aktivitaet', 'urn:de:xwaffe:codelisten:anschrifttyp', 'urn:de:xwaffe:codelisten:artabhandenkommen', 'urn:de:xwaffe:codelisten:artaustausch', 'urn:de:xwaffe:codelisten:bearbeitungunbrauchbarmachung', 'urn:de:xwaffe:codelisten:bedeutung', 'urn:de:xwaffe:codelisten:beduerfnisgrund', 'urn:de:xwaffe:codelisten:behoerdenstatus', 'urn:de:xwaffe:codelisten:dokumentstatus', 'urn:de:xwaffe:codelisten:erlaubnisstatus', 'urn:de:xwaffe:codelisten:erlaubnistyp', 'urn:de:xwaffe:codelisten:erstregistrierungsart', 'urn:de:xwaffe:codelisten:erwerbsart', 'urn:de:xwaffe:codelisten:fehlerartregister', 'urn:de:bund:kba:xkfz:codeliste:artdesdokuments', 'urn:de:xwaffe:codelisten:fehlerklassekopfstelle', 'urn:de:xwaffe:codelisten:fehlernummerkopfstelle', 'urn:de:xwaffe:codelisten:geschlecht', 'urn:de:xwaffe:codelisten:hinweisart', 'urn:de:xwaffe:codelisten:kommunikationskanal', 'urn:de:xwaffe:codelisten:meldungsart', 'urn:de:xwaffe:codelisten:munitionsarten', 'urn:de:xwaffe:codelisten:objekttyp', 'urn:de:xwaffe:codelisten:personenrolle', 'urn:de:bund:kba:xkfz:codeliste:artdesmandats', 'urn:de:xwaffe:codelisten:personobjektstatus', 'urn:de:xwaffe:codelisten:suchebestand', 'urn:de:xwaffe:codelisten:suchprofil', 'urn:de:bund:kba:xkfz:codeliste:artdessiegels', 'urn:de:xwaffe:codelisten:transaktionsstatus', 'urn:de:xwaffe:codelisten:ueberlassungsabsicht', 'urn:de:xwaffe:codelisten:ueberlassungsart', 'urn:de:xwaffe:codelisten:ueberlassungsstatus', 'urn:de:xwaffe:codelisten:voreintragstatus', 'urn:de:xwaffe:codelisten:waffenkategorie', 'urn:de:bund:kba:xkfz:codeliste:codedessystems', 'urn:de:xwaffe:codelisten:waffenstatus', 'urn:de:xwaffe:codelisten:waffentechnischeausfuehrung', 'urn:de:xwaffe:codelisten:waffentrageberechtigungsart', 'urn:de:xwaffe:codelisten:waffentypanlage1', 'urn:de:xwaffe:codelisten:waffentypfeingliederung', 'urn:de:xwaffe:codelisten:waffenverbotsart', 'urn:de:xwaffe:codelisten:waffenverweisstatus', 'urn:de:xwaffe:codelisten:waffewaffenteil', 'urn:de:xwaffe:codelisten:wesentlicheswaffenteil', 'urn:de:xwaffe:codelisten:zuordnungsart', 'urn:de:xwaffe:codelisten:zustaendigebehoerdestatus', 'urn:de:bund:kba:xkfz:codeliste:herstellerdruckstuecke', 'urn:de:xauslaender:codelist:abhkennung', 'urn:de:bund:kba:xkfz:codeliste:kurzzeichenherstellerdruckstuecke', 'urn:de:bund:destatis:bevoelkerungsstatistik:schluessel:bezirk', 'urn:xoev-de:bund:bmi:bit:codeliste:dvdv.behoerdenschluessel', 'urn:de:bund:kba:xkfz:codeliste:nummerderfeinstaubplakette', 'urn:de:bund:kba:xkfz:codeliste:prozessschrittname', 'urn:de:bund:kba:xkfz:codeliste:quittungsart', 'urn:xoev-de:mv:em:xprozess:codeliste:handlungsgrundlagenart', 'urn:de:bund:kba:xkfz:codeliste:quittungscode', 'urn:xoev-de:xprozess:codeliste:entscheidungsart', 'urn:xoev-de:xprozess:codeliste:verfahrensart', 'urn:de:xprozess:codeliste:uebermittlungsart', 'urn:xoev-de:xprozess:codeliste:uebermittlungsart', 'urn:xoev-de:xprozess:codeliste:beteiligungsform', 'urn:de:xprozess:codeliste:detaillierungsstufe', 'urn:xoev-de:xprozess:codeliste:detaillierungsstufe', 'urn:de:xprozess:codeliste:handlungsform', 'urn:xoev-de:xprozess:codeliste:handlungsform', 'urn:de:xprozess:codeliste:operativesziel', 'urn:xoev-de:xprozess:codeliste:operativesziel', 'urn:xoev-de:xprozess:codeliste:zwecksetzung', 'urn:xoev-de:xprozess:codeliste:bearbeitungsart', 'urn:xoev-de:xprozess:codeliste:formellepruefung', 'urn:xoev-de:xprozess:codeliste:prozessrolle', 'urn:de:bund:kba:xkfz:codeliste:statusprozessschritt', 'urn:xoev-de:xprozess:codeliste:status', 'urn:xoev-de:xprozess:codeliste:modellierungsmethode', 'urn:xoev-de:xprozess:codeliste:ausfertigungsform', 'urn:xoev-de:xprozess:codeliste:schriftformfunktion', 'urn:xoev-de:xprozess:codeliste:referenzaktivitaetengruppe', 'urn:xoev-de:xprozess:codeliste:referenzaufgabe', 'urn:xoev-de:fim:codeliste:vertrauensniveau', 'urn:xoev-de:xbau:codeliste:bauwerte.gebaeudearten', 'urn:xoev-de:xbau-nw:codeliste:technischeanlage', 'urn:de:bund:destatis:bevoelkerungsstatistik:schluessel:ags', 'urn:de:bund:kba:xkfz:codeliste:stba', 'urn:de:bund:destatis:bevoelkerungsstatistik:schluessel:gemeindeverband', 'urn:xoev-de:bund:destatis:bevoelkerungsstatistik:codeliste:ags.historie', 'urn:de:bund:kba:xkfz:codeliste:steuerzahlweise', 'urn:de:bund:kba:xkfz:codeliste:typdergebuehrenaufstellung', 'urn:de:bund:kba:xkfz:codeliste:typdesdokuments', 'urn:de:bund:kba:xkfz:codeliste:typdeskennzeichens', 'urn:xoev-de:xinneres:codeliste:quittungsrelevanter-sachverhalt', 'urn:de:dsmeld:schluesseltabelle:einwilligung.datenuebermittlung', 'urn:xoev-de:xgewerbeanzeige:codeliste:registergerichte', 'urn:de:bund:destatis:bevoelkerungsstatistik:schluessel:rs', 'urn:de:dsmeld:schluesseltabelle:pass.und.ausweisdokumente', 'urn:de:xauslaender:codelist:azr:artdersprache', 'urn:xoev-de:bund:kba:codeliste:schluesselnummerderueberwachungsinstitutionoderzdk', 'urn:de:xauslaender:codelist:azr:ausweisart', 'urn:de:fim:codeliste:dokumenttyp', 'urn:de:fim:leika:leistung', 'urn:de:fim:leika:typisierung', 'urn:de:kirche:agszuordnung', 'urn:de:xauslaender:codelist:bamfabh:int:anmeldestatus', 'urn:de:xauslaender:codelist:bamfabh:int:informationberechtigungsschein', 'urn:de:xauslaender:codelist:bamfabh:int:kursabschnitt', 'urn:de:xauslaender:codelist:geschlecht', 'urn:de:xauslaender:codelist:integration:aufenthaltstitel', 'urn:de:xinneres:codeliste:fehlercodes', 'urn:de:xmeld:lra:schluessel:rts.fehlercodes', 'urn:de:xmeld:schluesseltabelle:xmeld.nachrichten', 'urn:de:xprozess:codeliste:beteiligungsform', 'urn:de:xprozess:codeliste:handlungsgrundlagenart', 'urn:de:xprozess:codeliste:verfahrensart', 'urn:de:xta:codeliste:category.of.party', 'urn:de:xta:codeliste:service.parameter.type', 'urn:de:xta:codeliste:xhd-nachrichten', 'urn:de:xwaffe:codelisten:munitionsbezeichnungkalibersammlung', 'urn:de:xzufi:codeliste:leistungstextmodulleika', 'urn:de:xzufi:codeliste:zahlungsweise', 'urn:de:xwaffe:codelisten:herstellersammlung', 'urn:de:xwaffe:codelisten:kalibersammlung', 'urn:de:xauslaender:codelist:bamfabh:int:dublettenmeldung', 'urn:de:gkleika:leika:leistung', 'urn:de:bund:destatis:bevoelkerungsstatistik:schluessel:staat', 'urn:de:bund:dsrv:schluessel:fehlerkatalog', 'urn:de:xwaffe:codelisten:herstellerbezeichnungsynonym', 'urn:de:bund:bzst:schluessel:fehlerkatalog', 'urn:de:gkleika:leika:verrichtung', 'urn:de:xwaffe:codelisten:herstellerbezeichnung', 'urn:de:bund:destatis:bevoelkerungsstatistik:schluessel:staatsgebiete', 'urn:dsmeld:schluesseltabelle:religion.steuererhebend', 'urn:de:bund:destatis:bevoelkerungsstatistik:schluessel:standesamtsnummern', 'urn:xoev-de:bmk:codeliste:bauwerkszuordnungskatalog', 'urn:xoev-de:bund:bfj:codeliste:bfjbehoerde', 'urn:xoev-de:bund:bfj:codeliste:fehlerkennzahl', 'urn:xoev-de:bund:bfj:codeliste:uebermittelndestelle', 'urn:xoev-de:bund:bfj:codeliste:verwendungszweck', 'urn:de:xauslaender:codelist:int:informationberechtigungverpflichtung', 'urn:de:xauslaender:codelist:abhmb:anlassmitteilungazrnummer')"/>

</sch:schema>
