<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xgen="http://www.xoev.de/de/xgenerator/framework/1/library" xmlns:xd="http://www.oxygenxml.com/ns/doc/xsl" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:svg="http://www.w3.org/2000/svg" xmlns:lite="urn:xoev-de:kosit:xoev:lite:transformation_1.2.0" exclude-result-prefixes="#all" version="2.0">
   <xsl:output method="xml" indent="yes"/>
   <xd:doc>
        <xd:desc>Die Schriftgröße für die Namen von Elementen und Typen für Kindelemente</xd:desc>
    </xd:doc>
    <xsl:variable name="lite:svg.font-size-elem-attr-and-type" as="xs:integer">12</xsl:variable>
    <xd:doc>
        <xd:desc>Die Schriftgröße für die Angabe von Multiplizitäten</xd:desc>
    </xd:doc>
    <xsl:variable name="lite:svg.font-size-multiplicities" as="xs:integer">11</xsl:variable>
    <xd:doc>
        <xd:desc>Die Schriftgröße für die Angabe des Titels der Grafik</xd:desc>
    </xd:doc>
    <xsl:variable name="lite:svg.font-size-title" as="xs:integer">14</xsl:variable>
    <xd:doc>
        <xd:desc>Die Höhe der Box, in der Elemente und ihre Typen dargestellt werden.</xd:desc>
    </xd:doc>
    <xsl:variable name="lite:svg.rect-height-element-box" as="xs:double" select="3 * $lite:svg.font-size-elem-attr-and-type"/>
    <xd:doc>
        <xd:desc>Der Abstand zwischen Text und linken Rahmen der Element-Box.</xd:desc>
    </xd:doc>
    <xsl:variable name="lite:svg.rect-horizontal-inset" as="xs:double" select="0.3 * $lite:svg.font-size-elem-attr-and-type"/>
    <xd:doc>
        <xd:desc>Der Mindestabstand zwischen zwei vertikal aufeinander gestapelten Element-Boxen.</xd:desc>
    </xd:doc>
    <xsl:variable name="lite:svg.inter-node-vskip" as="xs:double" select="$lite:svg.font-size-elem-attr-and-type"/>

   <xsl:template match="xs:element | xs:complexType | xs:simpleType | xs:group" mode="lite:svg">
      <!--<svg xmlns="http://www.w3.org/2000/svg" width="187.86875" height="94">
         <defs>
            <style type="text/css">
               text {
                  font-family: 'Arial';
                  fill: black;
               }
               text.at {
                  font-family: 'Arial';
                  fill: rgb(242, 152, 0);
               }
               line {
                  stroke: black;
               }
               line.type-structure {
                  stroke: black;
               }
               line.type-structure-optional {
                  stroke: black;
                  stroke-dasharray: 4, 4;
               }
               rect.attribute-upper {
                  stroke: black;
                  fill: rgb(255, 239, 211);
               }
               rect.element-upper {
                  stroke: black;
                  fill: rgb(215, 227, 249);
               }
               rect.element-lower {
                  stroke: black;
                  fill: rgb(236, 242, 252);
               }
               a text {
                  fill: black;
               }</style>
         </defs>
         <rect width="177.86875" height="84" stroke-dasharray="3,3" rx="1" ry="1" style="stroke: grey;fill: white;"/>
         <text font-size="14" x="3.6" y="18" font-weight="bold">complexType DummySVG</text>
         <g transform="translate(10,34)">
            <g transform="translate(55,0)">
               <rect width="83.734375" height="18" class="element-upper"/>
               <rect width="83.734375" height="18" y="18" class="element-lower"/>
               <text font-size="12" x="3.6" y="12" font-weight="bold">dummySVG</text>
               <line x1="0" y1="18" x2="83.734375" y2="18"/>
               <text font-size="12" fill="grey" x="3.6" y="30">type</text>
               <line x1="31.753125" y1="18" x2="31.753125" y2="36"/>
               <text font-size="12" x="35.353125" y="30">xs:string</text>
               <g transform="translate(83.734375,0)"/>
            </g>
            <line x1="33" y1="18" x2="55" y2="18" class="type-structure-required"/>
            <text font-size="11" fill="black" x="53" y="16" text-anchor="end"/>
            <line x1="33" y1="18" x2="33" y2="18" class="type-structure-required"/>
            <circle cx="15" cy="18" r="10" stroke="black" fill="rgb(251, 251, 251)"/>
            <line x1="0" y1="18" x2="5" y2="18" class="type-structure-required"/>
            <line x1="25" y1="18" x2="33" y2="18" class="type-structure-required"/>
            <circle cx="10" cy="18" r="1.2" stroke="black" fill="black"/>
            <circle cx="15" cy="18" r="1.2" stroke="black" fill="black"/>
            <circle cx="20" cy="18" r="1.2" stroke="black" fill="black"/>
            <line x1="7" y1="18" x2="23" y2="18"/>
         </g>
      </svg>-->
      <xsl:variable name="intermediate-result" as="element(lite:intermediate-result)">
            <xsl:apply-templates select="." mode="lite:svg.intermediate-result">
                <xsl:with-param name="is-root">true</xsl:with-param>
            </xsl:apply-templates>
        </xsl:variable>
        <xsl:variable name="result-no-ns">
            <svg width="{$intermediate-result/lite:metadata/lite:width}" height="{$intermediate-result/lite:metadata/lite:height}">
                <defs>
                    <style type="text/css"><![CDATA[
                        text {
                            font-family: 'Arial';
                            fill: black;
                        }
                        text.at {
                            font-family: 'Arial';
                            fill: rgb(242, 152, 0);
                        }
                        line {
                            stroke: black;
                        }
                        line.type-structure {
                            stroke: black;
                        }
                        line.type-structure-optional {
                            stroke: black;
                            stroke-dasharray: 4, 4;
                        }
                        rect.attribute-upper {
                            stroke: black;
                            fill: rgb(255, 239, 211);
                        }
                        rect.element-upper {
                            stroke: black;
                            fill: rgb(215, 227, 249);
                        }
                        rect.element-lower {
                            stroke: black;
                            fill: rgb(236, 242, 252);
                        }
                        a text {
                            fill: black;
                        }]]> 
                    </style>
                </defs>
                <xsl:sequence select="$intermediate-result/lite:svg/*"/>
            </svg>
        </xsl:variable>
        <xsl:apply-templates select="$result-no-ns" mode="lite:svg.inter-node-vskip"/>
   </xsl:template>
   <xsl:template match="xs:attribute | xs:element | xs:complexType | xs:simpleType | xs:group | xs:any | xs:choice | xs:sequence" mode="lite:svg.intermediate-result">
        <xsl:param name="is-root" as="xs:boolean" required="yes"/>
        <xsl:variable name="structure" select="."/>
        <lite:intermediate-result>
            <xsl:variable name="complexStructure" as="element()?">
                <xsl:choose>
                    <xsl:when test="self::xs:element and xs:complexType">
                        <xsl:sequence select="xs:complexType"/>
                    </xsl:when>
                    <xsl:when test="self::xs:complexType | self::xs:group">
                        <xsl:sequence select="."/>
                    </xsl:when>
                </xsl:choose>
            </xsl:variable>
            <xsl:variable name="child-structures-container" as="element()?">
                <xsl:choose>
                    <xsl:when test="$complexStructure">
                        <xsl:sequence select="lite:svg.child-structures-container($complexStructure)"/>
                    </xsl:when>
                    <xsl:when test="self::xs:any or self::xs:choice or self::xs:sequence">
                        <xsl:sequence select="."/>
                    </xsl:when>
                </xsl:choose>
            </xsl:variable>
            <xsl:variable name="intermediate-results-for-child-structures" as="element(lite:intermediate-result)*">
                <xsl:for-each select="$complexStructure/lite:svg.attributes-in-complexType(.)">
                    <xsl:apply-templates select="." mode="#current">
                        <xsl:with-param name="is-root">false</xsl:with-param>
                    </xsl:apply-templates>
                </xsl:for-each>
                <xsl:for-each select="$child-structures-container/(xs:element | xs:any | xs:choice | xs:sequence)">
                    <xsl:apply-templates select="." mode="#current">
                        <xsl:with-param name="is-root">false</xsl:with-param>
                    </xsl:apply-templates>
                </xsl:for-each>
            </xsl:variable>
            <xsl:variable name="root-base-title" as="xs:string?">
                <xsl:choose>
                    <xsl:when test="self::xs:element and @type">
                        <xsl:value-of select="concat('element ', @name, ' (type ', @type, ')')"/>
                    </xsl:when>
                    <xsl:when test="self::xs:element and @ref">
                        <xsl:value-of select="concat('element ', @ref, ' (ref)')"/>
                    </xsl:when>
                    <xsl:when test="self::xs:element and xs:complexType">
                        <xsl:value-of select="concat('element ', @name, ' (anonymous type)')"/>
                    </xsl:when>
                    <xsl:when test="self::xs:element and xs:simpleType">
                        <xsl:value-of select="concat('element ', @name, ' (anonymous type)')"/>
                    </xsl:when>
                    <xsl:when test="self::xs:complexType">
                        <xsl:value-of select="concat('complexType ', @name)"/>
                    </xsl:when>
                    <xsl:when test="self::xs:simpleType">
                        <xsl:value-of select="concat('simpleType ', @name)"/>
                    </xsl:when>
                    <xsl:when test="self::xs:group">
                      <xsl:value-of select="concat('group ', @name)"/>
                    </xsl:when>
                </xsl:choose>
            </xsl:variable>
            <xsl:variable name="root-subtitle" as="xs:string?">
                <xsl:choose>
                    <xsl:when test="$complexStructure/xs:complexContent/xs:extension">
                        <xsl:value-of select="concat(' (extension of ', $complexStructure/xs:complexContent/xs:extension/@base, ')')"/>
                    </xsl:when>
                    <xsl:when test="$complexStructure/xs:complexContent/xs:restriction">
                        <xsl:value-of select="concat(' (restriction of ', $complexStructure/xs:complexContent/xs:restriction/@base, ')')"/>
                    </xsl:when>
                    <xsl:when test="$complexStructure/xs:simpleContent/xs:extension">
                        <xsl:value-of select="concat(' (restriction of ', $complexStructure/xs:simpleContent/xs:extension/@base, ')')"/>
                    </xsl:when>
                </xsl:choose>
            </xsl:variable>
            <xsl:variable name="root-base-title-width" select="xgen:svg.text-width($root-base-title, 1, $lite:svg.font-size-title)"/>
            <xsl:variable name="root-base-title-width-with-inset" select="
                    $root-base-title-width + (if ($root-base-title-width gt 450) then
                        2.0
                    else
                        (if ($root-base-title-width gt 300) then
                            3.0
                        else
                            4.0)) * $lite:svg.rect-horizontal-inset"/>
            <xsl:variable name="root-subtitle-width" select="xgen:svg.text-width($root-subtitle, 0, $lite:svg.font-size-elem-attr-and-type)"/>
            <xsl:variable name="root-subtitle-width-with-inset" select="
                    xgen:svg.text-width($root-subtitle, 0, $lite:svg.font-size-elem-attr-and-type) + (if ($root-subtitle-width gt 450) then
                        2
                    else
                        (if ($root-subtitle-width gt 300) then
                            3.5
                        else
                            4)) * $lite:svg.rect-horizontal-inset"/>
            <xsl:variable name="title-width" as="xs:double" select="
                    if ($root-subtitle) then
                        max(($root-base-title-width-with-inset, $root-subtitle-width-with-inset))
                    else
                        $root-base-title-width-with-inset"/>
            <!-- Vertikaler Platz, der für den Titel benötigt wird. -->
            <xsl:variable name="title-skip" as="xs:double" select="
                    20 + (if ($root-subtitle) then
                        $lite:svg.font-size-title + $lite:svg.font-size-elem-attr-and-type
                    else
                        $lite:svg.font-size-title)"/>
            <!-- Die Höhe, die insgesamt für die Darstellung dieses Objekts in SVG benötigt wird. -->
            <xsl:variable name="height" as="xs:double">
                <xsl:variable name="height-without-title" select="
                        max(($lite:svg.rect-height-element-box + $lite:svg.inter-node-vskip, sum($intermediate-results-for-child-structures/lite:metadata/lite:height)))"/>
                <xsl:choose>
                    <xsl:when test="$is-root">
                        <!-- Falls dies der Einstieg in die Rekursion ist, wird Platz für die Überschrift (den Namen des Typs bzw. Elements) benötigt .-->
                        <xsl:value-of select="$title-skip + $lite:svg.inter-node-vskip + $height-without-title"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:value-of select="$height-without-title"/>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:variable>
            <!-- Die Breite des "type"-Labels -->
            <xsl:variable name="text-width-type-label" select="xgen:svg.text-width('type', 0, $lite:svg.font-size-elem-attr-and-type) + 3.0 * $lite:svg.rect-horizontal-inset"/>
            <!-- Die Breite der Typ-Bezeichnung des Elements -->
            <xsl:variable name="text-width-elem-attr-type">
                <xsl:choose>
                    <xsl:when test="@type">
                        <xsl:value-of select="xgen:svg.text-width(@type, 0, $lite:svg.font-size-elem-attr-and-type)"/>
                    </xsl:when>
                    <xsl:when test="xs:simpleType">
                        <xsl:value-of select="xgen:svg.text-width('(anonymous simple type)', 0, $lite:svg.font-size-elem-attr-and-type)"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:value-of select="xgen:svg.text-width('xxx', 0, $lite:svg.font-size-elem-attr-and-type)"/>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:variable>
            <xsl:variable name="element-name" as="xs:string">
                <xsl:choose>
                    <xsl:when test="@name">
                        <xsl:value-of select="@name"/>
                    </xsl:when>
                    <xsl:when test="@ref">
                        <xsl:value-of select="concat(@ref, ' (ref)')"/>
                    </xsl:when>
                    <xsl:otherwise>(anonymous)</xsl:otherwise>
                </xsl:choose>
            </xsl:variable>
            <xsl:variable name="text-width-element-name" as="xs:double+" select="
                    (if (self::xs:attribute) then
                        xgen:svg.text-width('@ ', 1, $lite:svg.font-size-elem-attr-and-type) + xgen:svg.text-width($element-name, 1, $lite:svg.font-size-elem-attr-and-type)
                    else
                        xgen:svg.text-width($element-name, 1, $lite:svg.font-size-elem-attr-and-type)) + $lite:svg.rect-horizontal-inset"/>
            <!-- Die Breite, die für den Kasten des Elements selbst (ohne Kindelemente) benötigt wird. -->
            <xsl:variable name="rect-width-element" select="
                    if (self::xs:any or self::xs:choice or self::xs:sequence) then
                        0
                    else
                        max(($text-width-element-name, $text-width-type-label + $text-width-elem-attr-type)) + 2.0 * $lite:svg.rect-horizontal-inset"/>
            <!-- Die Breite, die insgesamt für die Darstellung dieses Objekts in SVG benötigt wird. -->
            <xsl:variable name="width" as="xs:double">
                <xsl:variable name="w1" select="max(($intermediate-results-for-child-structures/lite:metadata/lite:width, 1.0))"/>
                <xsl:variable name="w2" select="
                        if ($child-structures-container/xs:element) then
                            60
                        else
                            0"/>
                <xsl:choose>
                    <xsl:when test="$is-root">
                        <xsl:value-of select="max(($title-width, 20 + $w1 + $w2))"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:value-of select="$rect-width-element + $w1 + $w2"/>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:variable>
            <lite:svg>
                <xsl:choose>
                    <xsl:when test="$is-root">
                        <!-- gestrichelter Rahmen -->
                        <rect width="{$width - 10}" height="{$height - 10}" stroke-dasharray="3,3" rx="1" ry="1" style="stroke: grey;fill: white;"/>
                        <!-- Title Text -->
                        <text font-size="{$lite:svg.font-size-title}" x="{$lite:svg.rect-horizontal-inset}" y="{1.5 * $lite:svg.font-size-elem-attr-and-type}" font-weight="bold">
                            <xsl:value-of select="$root-base-title"/>
                        </text>
                        <!-- Subtitle Text -->
                        <xsl:if test="$root-subtitle">
                            <text font-size="{$lite:svg.font-size-elem-attr-and-type}" x="{$lite:svg.rect-horizontal-inset}" y="{1.5 * $lite:svg.font-size-elem-attr-and-type + 1.2 * $lite:svg.font-size-title}">
                                <xsl:value-of select="$root-subtitle"/>
                            </text>
                        </xsl:if>
                    </xsl:when>
                    <xsl:when test="self::xs:element">
                        <xsl:variable name="vertical-offset" select="
                                count(xs:complexType/lite:svg.attributes-in-complexType(.)) * ($lite:svg.rect-height-element-box + $lite:svg.inter-node-vskip)"/>
                        <rect width="{$rect-width-element}" height="{$lite:svg.rect-height-element-box div 2}" class="element-upper">
                            <xsl:if test="not($vertical-offset = 0)">
                                <xsl:attribute name="y" select="$vertical-offset"/>
                            </xsl:if>
                        </rect>
                        <rect width="{$rect-width-element}" height="{$lite:svg.rect-height-element-box div 2}" y="{($lite:svg.rect-height-element-box div 2) + $vertical-offset}" class="element-lower"/>
                        <text font-size="{$lite:svg.font-size-elem-attr-and-type}" x="{$lite:svg.rect-horizontal-inset}" y="{$lite:svg.font-size-elem-attr-and-type + $vertical-offset}" font-weight="bold">
                            <xsl:value-of select="$element-name"/>
                        </text>
                        <line x1="0" y1="{1.5 * $lite:svg.font-size-elem-attr-and-type + $vertical-offset}" x2="{$rect-width-element}" y2="{1.5 * $lite:svg.font-size-elem-attr-and-type + $vertical-offset}"/>
                        <text font-size="{$lite:svg.font-size-elem-attr-and-type}" fill="grey" x="{$lite:svg.rect-horizontal-inset}" y="{1.5 * $lite:svg.font-size-elem-attr-and-type + $lite:svg.font-size-elem-attr-and-type + $vertical-offset}">
                            <xsl:text>type</xsl:text>
                        </text>
                        <line x1="{$text-width-type-label}" y1="{1.5 * $lite:svg.font-size-elem-attr-and-type + $vertical-offset}" x2="{$text-width-type-label}" y2="{1.5 * ($lite:svg.font-size-elem-attr-and-type + $lite:svg.font-size-elem-attr-and-type) + $vertical-offset}"/>
                        <xsl:if test="@type | xs:simpleType | @ref">
                            <text font-size="{$lite:svg.font-size-elem-attr-and-type}" x="{$lite:svg.rect-horizontal-inset + $text-width-type-label}" y="{1.5 * $lite:svg.font-size-elem-attr-and-type + $lite:svg.font-size-elem-attr-and-type + $vertical-offset}">
                                <xsl:value-of select="
                                        (@type,
                                        if (@ref) then
                                            '(see element def.)'
                                        else
                                            '(anonymous simple type)')[1]"/>
                            </text>
                        </xsl:if>
                    </xsl:when>
                    <xsl:when test="self::xs:attribute">
                        <rect width="{$rect-width-element}" height="{$lite:svg.rect-height-element-box div 2}" class="attribute-upper"/>
                        <rect width="{$rect-width-element}" height="{$lite:svg.rect-height-element-box div 2}" y="{$lite:svg.rect-height-element-box div 2}" class="element-lower"/>
                        <text font-size="{$lite:svg.font-size-elem-attr-and-type}" x="{$lite:svg.rect-horizontal-inset}" y="{$lite:svg.font-size-elem-attr-and-type}" font-weight="bold" class="at">
                            <xsl:text>@ </xsl:text>
                        </text>
                        <text font-size="{$lite:svg.font-size-elem-attr-and-type}" x="{$lite:svg.rect-horizontal-inset + xgen:svg.text-width('@x', 0, $lite:svg.font-size-elem-attr-and-type)}" y="{$lite:svg.font-size-elem-attr-and-type}" font-weight="bold">
                            <xsl:value-of select="$element-name"/>
                        </text>
                        <line x1="0" y1="{1.5 * $lite:svg.font-size-elem-attr-and-type}" x2="{$rect-width-element}" y2="{1.5 * $lite:svg.font-size-elem-attr-and-type}"/>
                        <text font-size="{$lite:svg.font-size-elem-attr-and-type}" fill="grey" x="{$lite:svg.rect-horizontal-inset}" y="{1.5 * $lite:svg.font-size-elem-attr-and-type + $lite:svg.font-size-elem-attr-and-type}">
                            <xsl:text>type</xsl:text>
                        </text>
                        <line x1="{$text-width-type-label}" y1="{1.5 * $lite:svg.font-size-elem-attr-and-type}" x2="{$text-width-type-label}" y2="{1.5 * ($lite:svg.font-size-elem-attr-and-type + $lite:svg.font-size-elem-attr-and-type)}"/>
                        <xsl:if test="@type | xs:simpleType | @ref">
                            <text font-size="{$lite:svg.font-size-elem-attr-and-type}" x="{$lite:svg.rect-horizontal-inset + $text-width-type-label}" y="{1.5 * $lite:svg.font-size-elem-attr-and-type + $lite:svg.font-size-elem-attr-and-type}">
                                <xsl:value-of select="
                                        (@type,
                                        if (@ref) then
                                            '(see attribute def.)'
                                        else
                                            '(anonymous simple type)')[1]"/>
                            </text>
                        </xsl:if>
                        <text font-size="{$lite:svg.font-size-multiplicities}" fill="black" x="-2" y="{0.5 * $lite:svg.rect-height-element-box - 2}" text-anchor="end">
                            <xsl:value-of select="
                                    if (@use = 'required') then
                                        '1..1'
                                    else
                                        '0..1'"/>
                        </text>
                    </xsl:when>
                </xsl:choose>
                <g transform="translate({if ($is-root) then 10 else $rect-width-element},{if ($is-root) then $title-skip else 0})">
                    <xsl:for-each select="$intermediate-results-for-child-structures">
                        <xsl:variable name="position" select="position()"/>
                        <xsl:variable name="vskip-upto-current-minus-1" select="sum($intermediate-results-for-child-structures[position() lt $position]/lite:metadata/lite:height)"/>
                        <xsl:variable name="vskip-upto-current-minus-2" select="sum($intermediate-results-for-child-structures[position() lt ($position - 1)]/lite:metadata/lite:height)"/>
                        <xsl:variable name="previous-structure" as="element()?" select="
                                ($complexStructure/lite:svg.attributes-in-complexType(.), $child-structures-container/(xs:element | xs:any | xs:choice | xs:sequence))[$position - 1]"/>
                        <xsl:variable name="current-structure" as="element()" select="
                                ($complexStructure/lite:svg.attributes-in-complexType(.), $child-structures-container/(xs:element | xs:any | xs:choice | xs:sequence))[$position]"/>
                        <xsl:variable name="vertical-offset" select="
                                count($current-structure/xs:complexType/lite:svg.attributes-in-complexType(.)) * ($lite:svg.rect-height-element-box + $lite:svg.inter-node-vskip)" as="xs:double"/>
                        <xsl:if test="not(empty(lite:svg/*))">
                            <g transform="translate(55,{$vskip-upto-current-minus-1})">
                                <xsl:sequence select="lite:svg/*"/>
                            </g>
                        </xsl:if>
                        <xsl:variable name="class-current">
                            <xsl:choose>
                                <xsl:when test="$current-structure/@minOccurs = '0'">type-structure-optional</xsl:when>
                                <xsl:otherwise>type-structure-required</xsl:otherwise>
                            </xsl:choose>
                        </xsl:variable>
                        <xsl:variable name="class-up-to-current">
                            <xsl:choose>
                                <xsl:when test="
                                        every $e in ($complexStructure/lite:svg.attributes-in-complexType(.), $child-structures-container/(xs:element | xs:any | xs:choice | xs:sequence))[position() ge $position]
                                            satisfies $e/@minOccurs = '0'">type-structure-optional</xsl:when>
                                <xsl:otherwise>type-structure-required</xsl:otherwise>
                            </xsl:choose>
                        </xsl:variable>
                        <xsl:if test="not($current-structure/name() = 'xs:attribute')">
                            <line x1="33" y1="{$vskip-upto-current-minus-1 + 0.5 * $lite:svg.rect-height-element-box + $vertical-offset}" x2="55" y2="{$vskip-upto-current-minus-1 + 0.5 * $lite:svg.rect-height-element-box + $vertical-offset}" class="{$class-current}"/>
                        </xsl:if>
                        <text font-size="{$lite:svg.font-size-multiplicities}" fill="black" x="53" y="{$vskip-upto-current-minus-1 + 0.5 * $lite:svg.rect-height-element-box - 2 + $vertical-offset}" text-anchor="end">
                            <xsl:value-of select="lite:svg.multiplicity-string($current-structure)"/>
                        </text>
                        <xsl:if test="not($current-structure/name() = 'xs:attribute') and not($previous-structure/name() = 'xs:attribute')">
                            <line x1="33" y1="{$vskip-upto-current-minus-2 + 0.5 * $lite:svg.rect-height-element-box}" x2="33" y2="{$vskip-upto-current-minus-1 + 0.5 * $lite:svg.rect-height-element-box + $vertical-offset}" class="{$class-up-to-current}"/>
                        </xsl:if>
                    </xsl:for-each>
                    <xsl:if test="$child-structures-container/(xs:element | xs:any | xs:choice | xs:sequence)">
                        <xsl:variable name="vertical-offset" select="
                                count($complexStructure/lite:svg.attributes-in-complexType(.)) * ($lite:svg.rect-height-element-box + $lite:svg.inter-node-vskip)" as="xs:double"/>
                        <circle cx="15" cy="{0.5 * $lite:svg.rect-height-element-box + $vertical-offset}" r="10" stroke="black" fill="rgb(251, 251, 251)"/>
                        <xsl:variable name="class">
                            <xsl:choose>
                                <xsl:when test="
                                        every $e in $child-structures-container/(xs:element | xs:any | xs:choice | xs:sequence)
                                            satisfies $e/@minOccurs = '0'">type-structure-optional</xsl:when>
                                <xsl:otherwise>type-structure-required</xsl:otherwise>
                            </xsl:choose>
                        </xsl:variable>
                        <line x1="0" y1="{0.5 * $lite:svg.rect-height-element-box + $vertical-offset}" x2="5" y2="{0.5 * $lite:svg.rect-height-element-box + $vertical-offset}" class="{$class}"/>
                        <line x1="25" y1="{0.5 * $lite:svg.rect-height-element-box + $vertical-offset}" x2="33" y2="{0.5 * $lite:svg.rect-height-element-box + $vertical-offset}" class="{$class}"/>
                        <xsl:variable name="vcenter" select="0.5 * $lite:svg.rect-height-element-box + $vertical-offset" as="xs:double"/>
                      <xsl:choose>
                        <xsl:when test="local-name($child-structures-container) = 'sequence'">
                          <circle cx="10" cy="{$vcenter}" r="1.2" stroke="black" fill="black"/>
                          <circle cx="15" cy="{$vcenter}" r="1.2" stroke="black" fill="black"/>
                          <circle cx="20" cy="{$vcenter}" r="1.2" stroke="black" fill="black"/>
                        </xsl:when>
                        <xsl:when test="local-name($child-structures-container) = 'choice'">
                          <circle cx="15" cy="{$vcenter - 4}" r="1.2" stroke="black" fill="black"/>
                          <circle cx="15" cy="{$vcenter}" r="1.2" stroke="black" fill="black"/>
                          <circle cx="15" cy="{$vcenter + 4}" r="1.2" stroke="black" fill="black"/>                           
                          <line x1="10" y1="{$vcenter - 4}" x2="20" y2="{$vcenter -4}"/>
                        </xsl:when>
                        <xsl:when test="local-name($child-structures-container) = 'all'">
                          <circle cx="15" cy="{$vcenter - 4}" r="1.2" stroke="black" fill="black"/>
                          <circle cx="15" cy="{$vcenter}" r="1.2" stroke="black" fill="black"/>
                          <circle cx="15" cy="{$vcenter + 4}" r="1.2" stroke="black" fill="black"/>
                        </xsl:when>
                        <xsl:otherwise>
                          <xsl:call-template name="xgen:report-error">
                            <xsl:with-param name="message">SVG for XML Schema: Cannot handle element model <xsl:value-of select="string-join(ancestor-or-self::*/(concat(local-name(),'[',@name,']')),'/')"/> yet.</xsl:with-param>
                          </xsl:call-template>
                        </xsl:otherwise>
                      </xsl:choose>
                    </xsl:if>
                </g>
            </lite:svg>
            <lite:metadata>
                <lite:height>
                    <xsl:value-of select="$height"/>
                </lite:height>
                <lite:width>
                    <xsl:value-of select="$width"/>
                </lite:width>
            </lite:metadata>
        </lite:intermediate-result>
    </xsl:template>
    <!-- Nötig, da SVG gegen eine DTD validieren muss, die keine Namensraumpräfixe zulässt.
         Siehe http://stackoverflow.com/questions/2432818/how-can-i-dynamically-set-the-default-namespace-declaration-of-an-xslt-transform.-->
    <xsl:template match="node() | @*" mode="lite:svg.inter-node-vskip">
        <xsl:copy>
            <xsl:apply-templates select="node() | @*" mode="lite:svg.inter-node-vskip"/>
        </xsl:copy>
    </xsl:template>
    <xsl:template match="*[namespace-uri() = '']" mode="lite:svg.inter-node-vskip">
        <xsl:element name="{name()}" namespace="http://www.w3.org/2000/svg">
            <xsl:copy-of select="@*"/>
            <xsl:apply-templates mode="lite:svg.inter-node-vskip"/>
        </xsl:element>
    </xsl:template>
    <xsl:function name="lite:svg.child-structures-container" as="element()?">
        <xsl:param name="owner" as="element()?"/>
        <xsl:sequence select="
                ($owner/(xs:sequence, xs:choice, xs:all),
                $owner/xs:complexContent/xs:extension/(xs:sequence, xs:choice, xs:all),
                $owner/xs:complexContent/xs:restriction/(xs:sequence, xs:choice, xs:all))[1]"/>
    </xsl:function>
    <xsl:function name="lite:svg.attributes-in-complexType" as="element()*">
        <xsl:param name="type" as="element()"/>
        <xsl:sequence select="
                $type/(xs:attribute,
                xs:complexContent/xs:extension/xs:attribute,
                xs:complexContent/xs:restriction/xs:attribute)"/>
    </xsl:function>
    <xsl:function name="lite:svg.multiplicity-string" as="xs:string?">
        <xsl:param name="e" as="element()"/>
        <xsl:variable name="min" select="($e/@minOccurs, '1')[1]"/>
        <xsl:variable name="max-1" select="($e/@maxOccurs, '1')[1]"/>
        <xsl:variable name="max" select="
                if ($max-1 = 'unbounded') then
                    '*'
                else
                    $max-1"/>
        <xsl:choose>
            <xsl:when test="$min = $max">
                <xsl:choose>
                    <xsl:when test="$min = '1'"/>
                    <xsl:otherwise>
                        <xsl:value-of select="$min"/>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="concat($min, '..', $max)"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:function>

</xsl:stylesheet>
