<xsl:stylesheet 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:xs="http://www.w3.org/2001/XMLSchema" 
	xmlns:db="http://docbook.org/ns/docbook" 
	xmlns:gc="http://docs.oasis-open.org/codelist/ns/genericode/1.0/" 
	xmlns:log="http://www.xoev.de/de/xgenerator/framework/1/log" 
	xmlns:xoev-cl-2="http://xoev.de/schemata/genericode/2" 
	xmlns:xoev-cl-4="http://xoev.de/schemata/genericode/4" 
	xmlns:lite="urn:xoev-de:kosit:xoev:lite:transformation_1.2.0" 
	xmlns:lite-bib="urn:xoev-de:kosit:xoev:lite:schema:bibliothek_1.2.0" 
	xmlns:lite-fm="urn:xoev-de:kosit:xoev:lite:schema:fachmodell_1.2.0" 
	xmlns:xgen="http://www.xoev.de/de/xgenerator/framework/1/library" 
	xmlns="http://docbook.org/ns/docbook" 
	xpath-default-namespace="urn:xoev-de:kosit:xoev:lite:schema:fachmodell_1.2.0" 
	version="2.0" 
	exclude-result-prefixes="xgen xsl xs db gc log xoev-cl-2 xoev-cl-4 lite lite-fm lite-bib">
   <!-- *************************************************************************************
        ** 
        **  Verwendung der Templatevorlage:
        **  
        **  Diese Datei kann als Vorlage für Templates verwendet werden,
        **  die Dateien in einen strukturiertes Verzeichnis schreiben sollen.
        **
        **  Vorbereitung:
        **  
        **  1. Es muss ein Dateiname und ein Modename passend zum Verwendungszweck bestimmt werden.
        **     Der eigene 'Mode-Einstieg soll verhindern dass das Einstiegstemplate im Zuge der
        **     Templateverarbeitung noch einmal verarbeitet wird.
        **
        **     Dateiname:          'lite2dbxx.verwendungszweck.xsl'
        **     Mode-Einstieg:      'lite:verwendungszweck-entry'
        **     Mode:               'lite:verwendungszweck'
        **
        **  2. Diese Datei wird unter dem bestmmten Dateinamen  'lite2dbxx.verwendungszweck.xsl'
        **     im xsl Ordner gespeichert.
        **  3. Die Datei wird in uebersetzungsanweisungen.lite2db.xsl inkludiert.
        **     (<xsl:include href="lite2dbxx.verwendungszweck.xsl"/>)
        **  4. Ebenfalls in uebersetzungsanweisungen.lite2db.xsl wird ein
        **     (<xsl:apply-templates select="." mode="lite:verwendungszweck-entry"/>)
        **     Eingesetzt.
        **
        **  Umsetztung:
        **  
        **  1. Der relative Pfad zum Speicherort einer zu erzeugenden Datei wird bestimmt.
        **     Dabei wird in der Variable 'target-document-directory' auf den Ordner verwiesen
        **     in dem die Datei gespeichert werden soll. Im Parameter 'local-path' wird noch
        **     der gewünschte Dateiname angehängt.
        **     Es ist zu beachten dass der relative Pfad an einen vorgegebenen Pfad in
        **     xgen:result-document angehängt wird. Derzeit Ordner 'docbooc'.
        **  2. Grundsätzlich werden alle templates und apply-templates mit dem aktuellen mode
        **     versehen (mode="lite:verwendungszweck")
        **  3. Im Template unter 'Einstiegspunkt für die Generierung'
        **     soll das 'apply-templates' einen Pfad zu einem
	     **     für die Content Generierung geeigneten Kontext enthalten.
	     **  4. Das Template unter 'Erzeuge Datei' soll ein 
	     **     Element matchen, das dem Einstiegspunkt (siehe 3.) entspricht.
	     **  5. Unter 'Erzeuge den gewünschten Content' können weitere Templates angehängt 
	     **     werden die den gewünschten Content erzeugen.
	     **
	     ***********************************************************************************
        -->
      
  
   
	
	<!-- Einstiegspunkt für die Generierung -->
   <xsl:template match="/" mode="lite:verwendungszweck-entry">
      <xsl:apply-templates select="*" mode="lite:verwendungszweck"/>
	</xsl:template>
	
	
   <!-- Erzeuge Datei-->
   <xsl:template match="" mode="lite:verwendungszweck">
      <!-- Diese Variable verweisen auf den Ordner in dem ein Datei gespeichert werden soll -->
      <xsl:variable name="document-directory" select="'dokumente'" as="xs:string"/>
      <xsl:variable name="target-document-directory" select="(string-join(($document-directory, string-join(ancestor::*/@name, '/')), '/'))" as="xs:string"/>
      
      <!-- Diese Variable enthält den Content einer zu erzeugenden Datei. -->
      
      
      <xsl:variable name="content">
         <xsl:apply-templates select="." mode="lite:verwendungszweck"/>
      </xsl:variable>
      
      <!-- Hier wird das Template zur Dateierzeugung aufgerufen -->
      <xsl:call-template name="lite:write-file-return-log">
         <xsl:with-param name="content" select="$content"/>
         <xsl:with-param name="local-path" select="xs:anyURI(concat($target-document-directory, @name , '.xml'))"/>
      </xsl:call-template>
      <!-- Um die Erzeugung leerer Dateien zu vermeiden kann
      Variante 1: Bei Fehlendem Inhalt die Dateierzeugung ganz vermieden werden.
      
      <xsl:if test="not(empty($content))">
         <xsl:call-template name="lite:write-file-return-log">
            <xsl:with-param name="content" select="$content"/>
            <xsl:with-param name="local-path" select="xs:anyURI(concat($target-document-directory, @name , '.xml'))"/>
         </xsl:call-template>
      </xsl:if>
      
      Variante 2: Der Content kann mit der Helperfunktion lite:validateContent(content,nocontent) inhaltlich 
      überprüft werden.
      
      Ist der Content Inhaltlich falsch wird der Inhalt von noContent in die Datei geschrieben
      Ist für den Content noch keine Prüfung Implementiert wird eine section mit dem Titel
      "Prüfung fehlgeschlagen" zurückgegeben. In diesem Fall muss die Prüfungsfunktion erweitert werden.
      siehe "lite:validateContent" in "helpers.stage.lite-dokumentation.xsl"
      
         
      <xsl:variable name="noContent">
         <section version="5">
            <title>Fehlermeldung</title>
            <para>Es sind keine Code-Datentypen auffindbar.</para>
         </section>
      </xsl:variable>
      
      <xsl:call-template name="lite:write-file-return-log">
         <xsl:with-param name="content" select="lite:validateContent($content,$noContent)"/>
         <xsl:with-param name="local-path" select="xs:anyURI(concat($target-document-directory, @name , '.xml'))"/>
      </xsl:call-template>
      -->
   </xsl:template>

   
   
   
	<!-- Erzeuge den gewünschten Content -->
   <xsl:template match=" " mode="lite:verwendungszweck">
     
   </xsl:template>
	
</xsl:stylesheet>
