<?xml-stylesheet type="text/css" href="../css/style.css" title="style für sch" alternate="no"?>
<sch:schema xmlns:sch="http://purl.oclc.org/dsdl/schematron" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:bp="urn:xoev-de:kosit:xoev:lite:schema:betrieb.pruefanweisungen" queryBinding="xslt2">

   <sch:title>Prüfanweisungen: XÖV lite</sch:title>
   <xsl:include href="helpers.lite.xsl"/>
   <xsl:include href="../xsl/helpers.lite.schematron.xsl"/>

  <sch:ns uri="urn:xoev-de:kosit:xoev:lite:schema:fachmodell_1.2.0" prefix="fm"/>
  <sch:ns uri="urn:xoev-de:kosit:xoev:lite:schema:bibliothek_1.2.0" prefix="bib"/>
  <sch:ns uri="urn:xoev-de:kosit:xoev:lite:transformation_1.2.0" prefix="lite"/>
    
    <sch:pattern id="pattern.NDR-11.001">
      <sch:title>Namen von benannten Typen und globalen Elementen ohne Whitespaces</sch:title>      
      <sch:rule context="fm:globaleEigenschaft[@xsdAttribute = false() and @name] | fm:nachricht[@name] | fm:datentyp[@name] | fm:codeDatentyp[@name]">
        <sch:assert role="error" id="NDR-11.001" test="not(matches(@name, '\s'))">NDR-11.001: Benannte Typen und globale Elemente dürfen keine Whitespaces enthalten. <sch:value-of select="@name"/> verletzt diese Regel.</sch:assert>
      </sch:rule>
    </sch:pattern>
    
    <sch:pattern id="pattern.NDR-11.002">
      <sch:title>Nur erlaubte Zeichen in Namen von Präfixen und Suffixen</sch:title>      
      <sch:rule context="fm:xsdGlobalElementNamePrefix | fm:xsdGlobalElementNameSuffix | fm:xsdNamedTypeNamePrefix | fm:xsdNamedTypeNameSuffix">
        <sch:assert role="warning" id="NDR-11.002" test="
          replace(., '[a-zA-Z0-9\.\-_]', '') = ''">NDR-11.002: Namenspräfixe und -suffixe von benannten Typen und globalen Elementen (xsdGlobalElementNamePrefix, xsdGlobalElementNameSuffix, xsdNamedTypeNamePrefix, xsdNamedTypeNameSuffix) sollen nur die Zeichen "a-z", "A-Z", "0-9", ".", "_" und "-" enthalten. Folgende Eigenschaft verletzt diese Regel: <sch:value-of select="name()"/></sch:assert>
      </sch:rule>
    </sch:pattern>
    
    <sch:pattern id="pattern.NDR-11.003">
      <sch:title>Keine Whitespaces in Namen von Präfixen und Suffixen</sch:title>      
      <sch:rule context="fm:xsdGlobalElementNamePrefix | fm:xsdGlobalElementNameSuffix | fm:xsdNamedTypeNamePrefix | fm:xsdNamedTypeNameSuffix">
        <sch:assert role="error" id="NDR-11.003" test="
          not(matches(., '\s'))">NDR-11.003: Namenspräfixe und -suffixe von benannten Typen und globalen Elementen (xsdGlobalElementNamePrefix, xsdGlobalElementNameSuffix, xsdNamedTypeNamePrefix, xsdNamedTypeNameSuffix) dürfen keine Whitespaces enthalten. Folgende Eigenschaft verletzt diese Regel: <sch:value-of select="name()"/></sch:assert>
      </sch:rule>
    </sch:pattern>
    
    <sch:pattern id="pattern.NDR-11.004">
      <sch:title>Nur erlaubte Zeichen in Namen von Elementen, Attributen, Gruppen, Datentypen und Nachrichten</sch:title>      
      <sch:rule context="fm:eigenschaft[@name]|fm:globaleEigenschaft[@name]|fm:eigenschaftenGruppe[@name]|fm:globaleEigenschaftenGruppe[@name]|fm:nachricht[@name]|fm:datentyp[@name]|fm:codeDatentyp[@name]">
        <sch:assert role="warning" id="NDR-11.004" test="not(replace(@name, '[a-zA-Z0-9\.\-_]', '') != '')">NDR-11.004: Namen von Elementen, Elementgruppen, Attributen, Attributgruppen, Datentypen und Nachrichten sollen nur die Zeichen "a-z", "A-Z", "0-9", ".", "_" und "-" enthalten. <sch:value-of select="@name"/> verletzt diese Regel.</sch:assert>
      </sch:rule>
    </sch:pattern>
    
    <sch:pattern id="pattern.NDR-11.005">
      <sch:title>Keine Whitespaces in Namen von Elementen und Attributen</sch:title>      
      <sch:rule context="fm:eigenschaft[@name] | fm:globaleEigenschaft[@name]">
        <sch:assert role="error" id="NDR-11.005" test="not(matches(@name, '\s'))">NDR-11.005:  Namen von Elementen und Attributen dürfen keine Whitespaces enthalten. <sch:value-of select="@name"/> verletzt diese Regel.</sch:assert>
      </sch:rule>
    </sch:pattern>
  
  <sch:pattern id="pattern.NDR-11.006">
    <sch:title>Erlaubte Zeichen in Namen benannter Datentypen zur Nutzung von Schema-validierenden Codelisten-Versionen</sch:title>    
    <sch:rule context="fm:codeDatentyp[fm:benannterCodelistenDatentypName][not(matches(fm:benannterCodelistenDatentypName, '^[a-zA-Z0-9\.\-_]*$'))]">
      <sch:assert role="warning" id="NDR-11.006" test="false()">NDR-11.006: Datentypen, die Schema-validierende Codelisten einbinden und über einen Code-Datentyp referenziert werden, sollen nur die Zeichen "a-z", "A-Z", "0-9", ".", "_" und "-" enthalten. Im Kontext der Verwendungsbeziehung in dem Code-Datentyp <sch:value-of select="@name"/> wird der Datentypname "<sch:value-of select="fm:benannterCodelistenDatentypName"/>" mit ungültigen Zeichen spezifiziert.</sch:assert>
    </sch:rule>
  </sch:pattern>
  
  <sch:pattern id="pattern.NDR-11.007">
    <sch:title>Keine Whitespaces in Namen benannter Datentypen zur Nutzung von Schema-validierenden Codelisten-Versionen</sch:title>    
    <sch:rule context="fm:codeDatentyp[fm:benannterCodelistenDatentypName][matches(fm:benannterCodelistenDatentypName, '\s')]">
      <sch:assert role="error" id="NDR-11.007" test="false()">NDR-11.007: Datentypen, die Schema-validierende Codelisten einbinden und über einen Code-Datentyp referenziert werden, dürfen keine Whitespaces enthalten. Im Kontext der Verwendungsbeziehung in dem Code-Datentyp <sch:value-of select="@name"/> wird der Datentypname "<sch:value-of select="fm:benannterCodelistenDatentypName"/>" mit Whitespaces spezifiziert.</sch:assert>
    </sch:rule>
  </sch:pattern>

   <sch:pattern id="pattern.NDR-28.001">
     <sch:title>Sich ausschließende Default- und Fixed-Werte</sch:title>
     <sch:rule context="fm:globaleEigenschaft[@defaultWert and @fixedWert] | fm:eigenschaft[@defaultWert and @fixedWert]">
       <sch:assert role="error" id="NDR-28.001" test="false()">NDR-28.001: Ein Attribut oder Element darf nicht gleichzeitig einen Default-Wert und einen Fixed-Wert haben. <sch:value-of select="@name"/> verletzt diese Vorgabe.</sch:assert>
      </sch:rule>
   </sch:pattern>
   
   <sch:pattern id="pattern.NDR-28.002">
      <sch:title>Eindeutige Namen von Datentypen in einem Namensraum</sch:title>      
      <sch:rule context="fm:datentyp[@name] | fm:codeDatentyp[@name]">
        <sch:assert role="error" id="NDR-28.002" test="
               not(count(
               ancestor::fm:xoev-fachmodell//(fm:datentyp | fm:codeDatentyp)[@name and
               lite:namespace(.) = lite:namespace(current()) and @name = current()/@name]) > 1)">NDR-28.002: Im gleichen Namensraum dürfen keine benannten Datentypen mit dem gleichen Namen existieren. Der Name des Datentyps <sch:value-of select="@name"/> ist im Namensraum "<sch:value-of select="lite:namespace(.)"/>" nicht eindeutig.</sch:assert>
      </sch:rule>
    </sch:pattern>
   
    <sch:pattern id="pattern.NDR-28.003">
      <sch:title>Eindeutige Namen von Nachrichten, globalen Elemente, globalen Elementgruppen, globalen Attribute und globalen Attributgruppen in einem Namensraum</sch:title>      
      <sch:rule context="fm:globaleEigenschaft[@name] | fm:nachricht[@name] | fm:globaleEigenschaftengruppe[@name]">
        <sch:assert role="error" id="NDR-28.003" test="
               not(count(
               ancestor::fm:xoev-fachmodell//(fm:globaleEigenschaft | fm:nachricht | fm:globaleEigenschaftengruppe)[@name and
               lite:namespace(.) = lite:namespace(current()) and @name = current()/@name]) > 1)">NDR-28.003: Im gleichen Namensraum dürfen keine Nachrichten, globalen Elemente, globalen Elementgruppen, globalen Attribute und globalen Attributgruppen mit dem gleichen Namen existieren. Der Name <sch:value-of select="@name"/> ist im Namensraum "<sch:value-of select="lite:namespace(.)"/>" nicht eindeutig.</sch:assert>
      </sch:rule>
   </sch:pattern>
   
   <sch:pattern id="pattern.NDR-28.004">
      <sch:title>Benannte oder referenzierende Elemente, Elementgruppen, Attribute und Attributgruppen</sch:title>      
      <sch:rule context="
        fm:eigenschaft|fm:eigenschaftengruppe">
        <sch:assert role="error" id="NDR-28.004" test="(not(@referenz) and not(@name) and not(fm:eigenschaft|fm:eigenschaftengruppe)) = false()">NDR-28.004: Elemente, Elementgruppen, Attribute und Attributgruppen von Elementen, Elementgruppen, Attributgruppen und Datentypen müssen benannt sein oder auf ein globales Element, ein globales Attribut, eine globale Elementgruppe bzw. eine globale Attributgruppe referenzieren. <sch:value-of select="../@name"/> verletzt diese Vorgabe.</sch:assert>
      </sch:rule>
   </sch:pattern>

   <sch:pattern id="pattern.NDR-28.005">
      <sch:title>Eindeutig benannte und referenzierte Elemente in Nachrichten, Datentypen und globalen Elementgruppen</sch:title>      
      <sch:rule context="fm:nachricht | fm:datentyp | fm:globaleEigenschaftengruppe">
        <sch:assert role="error" id="NDR-28.005" test="count(lite:all-element-names(.)) = count(distinct-values(lite:all-element-names(.)))">NDR-28.005: Die Elemente einer Nachricht, eines Datentyps oder einer globalen Elementgruppe müssen eindeutig benannt sein. Hierbei sind auch die Namen referenzierter globaler Elemente und die Namen der Elemente in referenzierten Gruppen zu berücksichtigen. Im Kontext von <sch:value-of select="@name"/> sind die folgenden Namen nicht eindeutig: <sch:value-of select="
                  if (lite:get-duplicate-strings(lite:all-element-names(.)) = '') then
                     'Elemente ohne Namen'
                  else
                     lite:get-duplicate-strings(lite:all-element-names(.))"/></sch:assert>
      </sch:rule>
   </sch:pattern>

   <sch:pattern id="pattern.NDR-28.006">
      <sch:title>Typisierte globale Elemente und Nachrichten ohne eigene weitere Elemente und Attribute</sch:title>      
      <sch:rule context="fm:globaleEigenschaft[@xsdAttribute = false() and @typ] | fm:nachricht[@typ]">
        <sch:assert role="error" id="NDR-28.006" test="count(fm:eigenschaft | fm:eigenschaftengruppe | fm:anyStruktur) = 0">NDR-28.006: Typisierte globale Elemente und Nachrichten dürfen keine weiteren eigenen Elemente oder Attribute besitzen. <sch:value-of select="@name"/> verletzt diese Vorgabe.</sch:assert>
      </sch:rule>
   </sch:pattern>
  
   <sch:pattern id="pattern.NDR-28.007">
     <sch:title>Verwendung existierender globaler Typen, Elemente, Elementgruppen, Attribute und Attributgruppen</sch:title>      
     <sch:rule context="fm:eigenschaft[@typ or @basistyp or @referenz]|
       fm:globaleEigenschaft[@typ or @basistyp]|
       fm:nachricht[@typ or @basistyp] |
       fm:codeDatentyp[fm:typDesCodeElements] |
       fm:datentyp[@basistyp] |
       fm:eigenschaftengruppe[@referenz] |
       fm:union[fm:memberType]">
       <sch:assert role="error" id="NDR-28.007" test="
         if (fm:memberType) then 
         ((every $m in fm:memberType
         satisfies
         (lite:resolve($m, ., false())))) else 
            if(fm:typDesCodeElements) then lite:resolve(fm:typDesCodeElements, ., false()) else 
                if (@typ) then lite:resolve(@typ, ., false()) else 
                    if (@basistyp) then lite:resolve(@basistyp, ., false()) else lite:resolve(@referenz, ., true())">NDR-28.007: Elemente, Elementgruppen, Attribute, Attributgruppen, Nachrichten und Datentypen verwenden bzw. referenzieren existierende globale Typen, Elemente, Elementgruppen, Attribute und Attributgruppen. <sch:value-of select="if (@name) then @name else parent::*/@name"/> verletzt diese Vorgabe: <sch:value-of select="@typ|@basistyp|@referenz"/> ist nicht erreichbar.</sch:assert>
      </sch:rule>
   </sch:pattern> 
   
    <sch:pattern id="pattern.NDR-28.008">
      <sch:title>Referenzierung von Elementreferenzen auf globale Elemente und Elementgruppen</sch:title>      
      <sch:rule context="fm:eigenschaft[(not(@xsdAttribute) or @xsdAttribute = false()) and @referenz]">
        <sch:assert role="error" id="NDR-28.008" test="not(empty((lite:resolve(@referenz, ., true()))))">NDR-28.008: Elementreferenzen müssen auf globale Elemente oder Elementgruppen referenzieren. Das Element <sch:value-of select="@name | @referenz"/> in <sch:value-of select="ancestor::fm:datentyp/@name | ancestor::fm:eigenschaft/@name | ancestor::fm:globaleEigenschaft/@name"/> verletzt diese Vorgabe.</sch:assert>
      </sch:rule>
   </sch:pattern>

    <sch:pattern id="pattern.NDR-28.009">
      <sch:title>Schema Location für Schema</sch:title>      
      <sch:rule context="fm:xsdSchema[not(lite:schema-location(.))]">
        <sch:assert role="error" id="NDR-28.009" test="false()">NDR-28.009: XML Schema-Definitionen müssen eine Schema Location besitzen, entweder über schemaLocation am Schema oder über schemaLocationBase am XÖV-Fachmodell. Das Schema <sch:value-of select="@name"/> besitzt keine Schema Location. Gleichzeitig ist auch keine Schema Location Base für das XÖV-Fachmodell spezifiziert.</sch:assert>
      </sch:rule>
   </sch:pattern>
  
   <sch:pattern id="pattern.NDR-28.010">
      <sch:title>Eindeutiger Dateinamen für Schema</sch:title>      
      <sch:rule context="fm:xsdSchema">
         <sch:assert role="error" id="NDR-28.010" test="
               not(count(
               ancestor::fm:xoev-fachmodell//fm:xsdSchema[@schemaFile = current()/@schemaFile]) > 1)">NDR-28.010: XML Schema-Definitionen müssen im XÖV-Fachmodell eindeutige Dateinamen (schemaFile) aufweisen. Der Dateiname <sch:value-of select="@schemaFile"/> im Schema <sch:value-of select="@name"/> ist nicht eindeutig.</sch:assert>
      </sch:rule>
   </sch:pattern>

   <sch:pattern id="pattern.NDR-28.011">
      <sch:title>Eindeutige Schema Location für Schema</sch:title>      
      <sch:rule context="fm:xsdSchema">
         <sch:assert role="error" id="NDR-28.011" test="
               not(count(
               ancestor::fm:xoev-fachmodell//fm:xsdSchema[
               lite:schema-location(.) = lite:schema-location(current())]) > 1)">NDR-28.011: XML Schema-Definitionen müssen im XÖV-Fachmodell eindeutige Schema Locations aufweisen, entweder über schemaLocation am Schema oder über eine Kombination aus schemaLocationBase am XÖV-Fachmodell und schemaFile des Schema. Die folgende Schema Location wird mehrfach verwendet: <sch:value-of select="lite:schema-location(.)"/></sch:assert>
      </sch:rule>
   </sch:pattern>

   <sch:pattern id="pattern.NDR-28.012">
      <sch:title>Ausschließlich Elemente in Elementgruppen und Attribute in Attributgruppen</sch:title>      
      <sch:rule context="fm:globaleEigenschaftengruppe[descendant::fm:eigenschaft][not((count(descendant::fm:eigenschaft) = count(descendant::fm:eigenschaft[@xsdAttribute = 'true'])) or (count(descendant::fm:eigenschaft) = count(descendant::fm:eigenschaft[not(@xsdAttribute) or @xsdAttribute = 'false'])))]">
         <sch:assert role="error" id="NDR-18-012" test="false()">NDR-28.012: Globale Elementgruppen besitzen ausschließlich nur Elemente, globale Attributgruppen besitzen ausschließlich Attribute. Die Gruppe <sch:value-of select="@name"/> verletzt diese Vorgabe.</sch:assert>
      </sch:rule>
   </sch:pattern>

   <sch:pattern id="pattern.NDR-28.013">
      <sch:title>Keine erweiternden Elemente oder Attribute für per Restriktion definierte Typen, Nachrichten und globale Elemente</sch:title>      
      <sch:rule context="fm:datentyp[@basistyp and @restriction = 'true'] | fm:nachricht[@basistyp and @restriction = 'true'] | fm:globaleEigenschaft[@basistyp and @restriction = 'true']">
         <sch:let name="baustein" value="."/>
         <sch:let name="basistyp" value="lite:resolve(@basistyp, ., false())"/>
         <sch:assert role="error" id="NDR-28.013" test="
               (every $p in $baustein/(lite:attributes(.), lite:elements(.))
                  satisfies
                  $basistyp/(lite:all-attributes(.), lite:all-elements(.))[@name = $p/@name and @typ]/lite:resolve(@typ, $basistyp, false())[
                  
                  (if ($p[@typ]/lite:resolve(@typ, $p, false())[name() = 'codeDatentyp']) then
                     *:metadaten.xoevDatentyp/*:kennung = 'urn:xoev-de:kosit:xoev:datentyp:code' or name() = 'codeDatentyp'
                  else
                     lite:equal-object(., $p[@typ]/lite:resolve(@typ, $p, false())/(., lite:all-restriction-parents(.))))]
                  
                  and
                  
                  $basistyp/(lite:all-attributes(.), lite:all-elements(.))[@name = $p/@name and
                  lite:eigenschaft-lower-bound($p) ge lite:eigenschaft-lower-bound(.) and
                  (lite:eigenschaft-upper-bound(.) = '*' or
                  lite:eigenschaft-upper-bound($p) != '*' and xs:integer(lite:eigenschaft-upper-bound($p)) le xs:integer(lite:eigenschaft-upper-bound(.)))]) and
               ($baustein/@gruppe.art = 'choice' or (every $p in $basistyp/(lite:all-attributes(.), lite:all-elements(.))
                  satisfies
                  tokenize($p/@multiplizitaet, '\.\.')[1] = '0' or $baustein/(lite:attributes(.), lite:elements(.))[@name = $p/@name]))">NDR-28.013: Per XML-Restriktion (restriction) abgeleitete Typen, Nachricht oder globale Elemente dürfen keine zusätzlichen Elemente oder Attribute mehr hinzufügen. Die Typen der enthalten Elemente und Attribute müssen gleich den Typen der entpsrechenden Elemente und Attribute im Basistyp sein bzw. diese einschränken. Ebenso müssen die Multiplizitäten der Elementen und Attribute gleich bzw. eingeschränkt gegenüber den Multiplizitäten im Basistyp sein. <sch:value-of select="@name"/> verletzt diese Vorgabe.</sch:assert>
      </sch:rule>
   </sch:pattern>

   <sch:pattern id="pattern.NDR-28.014">
      <sch:title>Keine Verwendung von im Entwurf befindlichen Typen</sch:title>      
      <sch:rule context="fm:eigenschaft[@typ]|fm:globaleEigenschaft[@typ]|fm:nachricht[@typ]">
        <sch:assert role="error" id="NDR-28.014" test="not(@draft = 'true' or ((lite:resolve(@typ, ., false())/@draft = 'true')
          and parent::*/@draft = 'false'))">NDR-28.014: Elemente und Attribute dürfen keine sich im Entwurf befindenden benannten Typen (draft) nutzen, sofern sie nicht selbst Teil eines Entwurfs sind. <sch:value-of select="./@name"/> in <sch:value-of select="parent::*/@name"/> verletzt diese Vorgabe.</sch:assert>
      </sch:rule>
   </sch:pattern>
   
   <sch:pattern id="pattern.NDR-28.015">
      <sch:title>Keine Verwendung von im Entwurf befindlichen globalen Elementen, Elementgruppen, Attributen und Attributgruppen</sch:title>      
      <sch:rule context="fm:eigenschaft[@referenz]|fm:globaleEigenschaft[@referenz]|fm:nachricht[@referenz]">
        <sch:assert role="error" id="NDR-28.015" test="not(@draft = 'true' or (lite:resolve(@referenz, ., true())/@draft = 'true'))">NDR-28.015: Elemente und Attribute dürfen keine sich im Entwurf befindenden globalen Elemente, Elementgruppen, Attribute und Attributgruppen nutzen, sofern sie nicht selbst Teil eines Entwurfs sind. <sch:value-of select="./@name"/> verletzt diese Vorgabe.</sch:assert>
      </sch:rule>
   </sch:pattern>

   <sch:pattern id="pattern.NDR-28.016">
      <sch:title>Korrekte Elementreihenfolge bei einschränkenden Datentypen, Nachrichten und globalen Elementen</sch:title>      
      <sch:rule context="
            fm:datentyp[@basistyp and @restriction = 'true' and @gruppe.art != 'all'] | fm:nachricht[@basistyp and @restriction = 'true' and @gruppe.art != 'all'] |
            fm:globaleEigenschaft[@basistyp and @restriction = 'true' and @gruppe.art != 'all']">
         <sch:let name="baustein" value="."/>
         <sch:let name="basistyp" value="lite:resolve(@basistyp, ., false())"/>
         <sch:let name="elemente-basistyp" value="
               $basistyp/lite:all-elements(.)[(if (@referenz) then
                  lite:resolve(@referenz, ., true())/@name
               else
                  @name) = $baustein/lite:elements(.)/(if (@referenz) then
                  lite:resolve(@referenz, ., true())/@name
               else
                  @name)]"/>
         <sch:let name="elemente-baustein" value="$baustein/lite:elements(.)"/>
         <sch:assert role="error" id="NDR-28.016" test="
               every $eb in $elemente-baustein
                  satisfies count($elemente-baustein[lite:position($baustein, .) le lite:position($baustein, $eb)]) =
                  count($elemente-basistyp[lite:get-global-position($basistyp, .) le lite:get-global-position($basistyp, $eb)])">NDR-28.016: Elemente in einem per Restriktion eingeschränkenden Datentyp, Nachricht oder globalen Element müssen die gleiche Reihenfolge wie die Elemente des Basistyps aufweisen. <sch:value-of select="@name"/> verletzt diese Vorgabe. Elementreihenfolge des Basistyps: <sch:value-of select="lite:element-sequence($basistyp)"/> Elementreihenfolge des eingeschränkten Typs, Nachricht oder globalen Elements: <sch:value-of select="lite:element-sequence($baustein)"/>
         </sch:assert>
      </sch:rule>
   </sch:pattern>
   
   <sch:pattern id="pattern.NDR-28.017">
      <sch:title>Facetten zur Restriktion nur bei einfachen Datentypen</sch:title>      
      <sch:rule context="fm:datentyp[not(empty(@basistyp)) and @restriction = 'true'][@fractionDigits or @length or @totalDigits or @maxExclusive or
         @maxInclusive or @maxLength or @minInclusive or @minInclusive or @minLength or @pattern or
         @whitespace]">
         <sch:assert role="error" id="NDR-28.017" test="
            lite:is-simple-type(.) = true()">NDR-28.017: Restriction-Facetten dürfen ausschließich im Kontext von Datentypen mit einfachem Inhalt genutzt werden. Der Datentyp <sch:value-of select="@name"/> verletzt diese Vorgabe.</sch:assert>
      </sch:rule>
   </sch:pattern>
  
   <sch:pattern id="pattern.NDR-28.018">
      <sch:title>Facette fractionsDigits nur zur Einschränkung von bestimmten einfachen Datentypen</sch:title>      
      <sch:rule context="fm:datentyp[@restriction = 'true'][@fractionDigits]">
         <sch:assert role="error" id="NDR-28.018" test="
           lite:topmost-parent(.)[empty(ancestor::xsdSchema) and @name = 'decimal']">NDR-28.018: Datentypen, die per Restriktion mit der Facette fractionDigits ableiten, müssen den W3C-Datentyp xs:decimal als Basistyp haben. Der Datentyp <sch:value-of select="@name"/> verletzt diese Vorgabe.</sch:assert>
      </sch:rule>
   </sch:pattern>

   <sch:pattern id="pattern.NDR-28.019">
      <sch:title>Facette length nur zur Einschränkung von bestimmten einfachen Datentypen</sch:title>      
      <sch:rule context="fm:datentyp[@restriction = 'true'][@length]">
         <sch:assert role="error" id="NDR-28.019" test="
           lite:topmost-parent(.)[empty(ancestor::xsdSchema) and @name = ('anyURI', 'base64Binary', 'ENTITIES', 'ENTITY', 'hexBinary', 'ID', 'IDREF', 'IDREFS', 'language', 'Name', 'NCName', 'NMTOKEN', 'NMTOKENS', 'normalizedString', 'NOTATION', 'QName', 'string', 'token')]">NDR-28.019: Datentypen, die per Restriktion mit der Facette length ableiten, müssen den W3C-Datentyp xs:anyURI, base64Binary, xs:ENTITIES, xs:ENTITY, xs:hexBinary, xs:ID, xs:IDREF, xs:IDREFS, xs:language, xs:Name, xs:NCName, xs:NMTOKEN, xs:NMTOKENS, xs:normalizedString, xs:NOTATION, xs:QName, xs:string oder xs:token als Basistyp haben. Der Datentyp <sch:value-of select="@name"/> verletzt diese Vorgabe.</sch:assert>
      </sch:rule>
   </sch:pattern>
   
   <sch:pattern id="pattern.NDR-28.020">
      <sch:title>Ausschluss der Facette length bei Nutzung der Facetten maxLength oder minLength</sch:title>      
      <sch:rule context="fm:datentyp[@restriction = 'true'][@length]">
         <sch:assert role="error" id="NDR-28.020" test="
            empty(@maxLength) and empty(@minLength)">NDR-28.020: Die Facette length darf nicht zusammen mit den Facetten maxLength oder minLength angegeben sein. Der Datentyp <sch:value-of select="@name"/> verletzt diese Vorgabe.</sch:assert>
      </sch:rule>
   </sch:pattern>
   
   <sch:pattern id="pattern.NDR-28.021">
      <sch:title>Gegenseitiger Ausschluss der Facetten maxExclusive und maxInclusive</sch:title>      
      <sch:rule context="fm:datentyp[@restriction = 'true'][@maxExclusive and @maxInclusive]">
         <sch:assert role="error" id="NDR-28.021" test="false()">NDR-28.021: Die Facetten maxExclusive und maxInclusive schließen sich gegenseitig aus. Der Datentyp <sch:value-of select="@name"/> verletzt diese Vorgabe.</sch:assert>
      </sch:rule>
   </sch:pattern>
      
   <sch:pattern id="pattern.NDR-28.022">
      <sch:title>Gegenseitiger Ausschluss der Facetten minExlusive und minInclusive</sch:title>      
      <sch:rule context="fm:datentyp[@restriction = 'true'][@minExclusive and @minInclusive]">
        <sch:assert role="error" id="NDR-28.022" test="false()">NDR-28.022: Die Facetten minExclusive und minInclusive schließen sich gegenseitig aus. Der Datentyp <sch:value-of select="@name"/> verletzt diese Vorgabe.</sch:assert>
      </sch:rule>
   </sch:pattern>

   <sch:pattern id="pattern.NDR-28.023">
      <sch:title>Facette maxExclusive nur zur Einschränkung von bestimmten einfachen Datentypen</sch:title>      
      <sch:rule context="fm:datentyp[@restriction = 'true'][@maxExclusive]">
         <sch:assert role="error" id="NDR-28.023" test="
           lite:topmost-parent(.)[empty(ancestor::xsdSchema) and @name = ('byte', 'date', 'dateTime', 'decimal', 'double', 'duration', 'float', 'gDay', 'gMonth', 'gYear', 'gYearMonth', 'int', 'integer', 'long', 'negativeInteger', 'nonNegativeInteger', 'nonPositiveInteger', 'positiveInteger', 'short', 'time', 'unsignedByte', 'unsignedInt', 'unsignedLong', 'unsignedShort')]">NDR-28.023: Datentypen, die per Restriktion mit der Facette maxExclusive ableiten, müssen den W3C-Datentyp xs:byte, xs:date, xs:dateTime, xs:decimal, xs:double, xs:duration, xs:float, xs:gDay, xs:gMonth, xs:gYear, xs:gYearMonth, xs:int, xs:integer, xs:long, xs:negativeInteger, xs:nonNegativeInteger, xs:nonPositiveInteger, xs:positiveInteger, xs:short, xs:time, xs:unsignedByte, xs:unsignedInt, xs:unsignedLong oder xs:unsignedShort als Basistyp haben. Der Datentyp <sch:value-of select="@name"/> verletzt diese Vorgabe.</sch:assert>
      </sch:rule>
   </sch:pattern>

   <sch:pattern id="pattern.NDR-28.024">
      <sch:title>Facette maxInclusive nur zur Einschränkung von bestimmten einfachen Datentypen</sch:title>      
      <sch:rule context="fm:datentyp[@restriction = 'true'][@maxInclusive]">
         <sch:assert role="error" id="NDR-28.024" test="
           lite:topmost-parent(.)[empty(ancestor::xsdSchema) and @name = ('byte', 'date', 'dateTime', 'decimal', 'double', 'duration', 'float', 'gDay', 'gMonth', 'gYear', 'gYearMonth', 'int', 'integer', 'long', 'negativeInteger', 'nonNegativeInteger', 'nonPositiveInteger', 'positiveInteger', 'short', 'time', 'unsignedByte', 'unsignedInt', 'unsignedLong', 'unsignedShort')]">NDR-28.024: Datentypen, die per Restriktion mit der Facette maxInclusive ableiten, müssen den W3C-Datentyp xs:byte, xs:date, xs:dateTime, xs:decimal, xs:double, xs:duration, xs:float, xs:gDay, xs:gMonth, xs:gYear, xs:gYearMonth, xs:int, xs:integer, xs:long, xs:negativeInteger, xs:nonNegativeInteger, xs:nonPositiveInteger, xs:positiveInteger, xs:short, xs:time, xs:unsignedByte, xs:unsignedInt, xs:unsignedLong oder xs:unsignedShort als Basistyp haben. Der Datentyp <sch:value-of select="@name"/> verletzt diese Vorgabe.</sch:assert>
      </sch:rule>
   </sch:pattern>

   <sch:pattern id="pattern.NDR-28.025">
      <sch:title>Facette maxLength nur zur Einschränkung von bestimmten einfachen Datentypen</sch:title>      
      <sch:rule context="fm:datentyp[@restriction = 'true'][@maxLength]">
         <sch:assert role="error" id="NDR-28.025" test="
           lite:topmost-parent(.)[empty(ancestor::xsdSchema) and @name = ('anyURI', 'base64Binary', 'ENTITIES', 'ENTITY', 'hexBinary', 'ID', 'IDREF', 'IDREFS', 'language', 'Name', 'NCName', 'NMTOKEN', 'NMTOKENS', 'normalizedString', 'NOTATION', 'QName', 'string', 'token')]">NDR-28.025: Datentypen, die per Restriktion mit der Facette maxLength ableiten, müssen den W3C-Datentyp xs:anyURI, base64Binary, xs:ENTITIES, xs:ENTITY, xs:hexBinary, xs:ID, xs:IDREF, xs:IDREFS, xs:language, xs:Name, xs:NCName, xs:NMTOKEN, xs:NMTOKENS, xs:normalizedString, xs:NOTATION, xs:QName, xs:string oder xs:token als Basistyp haben. Der Datentyp <sch:value-of select="@name"/> verletzt diese Vorgabe.</sch:assert>
      </sch:rule>
   </sch:pattern>

   <sch:pattern id="pattern.NDR-28.026">
      <sch:title>Facette minExclusive nur zur Einschränkung von bestimmten einfachen Datentypen</sch:title>      
      <sch:rule context="fm:datentyp[@restriction = 'true'][@minExclusive]">
         <sch:assert role="error" id="NDR-28.026" test="
           lite:topmost-parent(.)[empty(ancestor::xsdSchema) and @name = ('byte', 'date', 'dateTime', 'decimal', 'double', 'duration', 'float', 'gDay', 'gMonth', 'gYear', 'gYearMonth', 'int', 'integer', 'long', 'negativeInteger', 'nonNegativeInteger', 'nonPositiveInteger', 'positiveInteger', 'short', 'time', 'unsignedByte', 'unsignedInt', 'unsignedLong', 'unsignedShort')]">NDR-28.026: Datentypen, die per Restriktion mit der Facette minExclusive ableiten, müssen den W3C-Datentyp xs:byte, xs:date, xs:dateTime, xs:decimal, xs:double, xs:duration, xs:float, xs:gDay, xs:gMonth, xs:gYear, xs:gYearMonth, xs:int, xs:integer, xs:long, xs:negativeInteger, xs:nonNegativeInteger, xs:nonPositiveInteger, xs:positiveInteger, xs:short, xs:time, xs:unsignedByte, xs:unsignedInt, xs:unsignedLong oder xs:unsignedShort als Basistyp haben. Der Datentyp <sch:value-of select="@name"/> verletzt diese Vorgabe.</sch:assert>
      </sch:rule>
   </sch:pattern>

   <sch:pattern id="pattern.NDR-28.027">
     <sch:title>Facette minInclusive nur zur Einschränkung von bestimmten einfachen Datentypen</sch:title>      
      <sch:rule context="fm:datentyp[@restriction = 'true'][@minInclusive]">
         <sch:assert role="error" id="NDR-28.027" test="
           lite:topmost-parent(.)[empty(ancestor::xsdSchema) and @name = ('byte', 'date', 'dateTime', 'decimal', 'double', 'duration', 'float', 'gDay', 'gMonth', 'gYear', 'gYearMonth', 'int', 'integer', 'long', 'negativeInteger', 'nonNegativeInteger', 'nonPositiveInteger', 'positiveInteger', 'short', 'time', 'unsignedByte', 'unsignedInt', 'unsignedLong', 'unsignedShort')]">NDR-28.027: Datentypen, die per Restriktion mit der Facette minInclusive ableiten, müssen den W3C-Datentyp xs:byte, xs:date, xs:dateTime, xs:decimal, xs:double, xs:duration, xs:float, xs:gDay, xs:gMonth, xs:gYear, xs:gYearMonth, xs:int, xs:integer, xs:long, xs:negativeInteger, xs:nonNegativeInteger, xs:nonPositiveInteger, xs:positiveInteger, xs:short, xs:time, xs:unsignedByte, xs:unsignedInt, xs:unsignedLong oder xs:unsignedShort als Basistyp haben. Der Datentyp <sch:value-of select="@name"/> verletzt diese Vorgabe.</sch:assert>
      </sch:rule>
   </sch:pattern>

   <sch:pattern id="pattern.NDR-28.028">
      <sch:title>Facette minLength nur zur Einschränkung von bestimmten einfachen Datentypen</sch:title>      
      <sch:rule context="fm:datentyp[@restriction = 'true'][@minLength]">
         <sch:assert role="error" id="NDR-28.028" test="
           lite:topmost-parent(.)[empty(ancestor::xsdSchema) and @name = ('anyURI', 'base64Binary', 'ENTITIES', 'ENTITY', 'hexBinary', 'ID', 'IDREF', 'IDREFS', 'language', 'Name', 'NCName', 'NMTOKEN', 'NMTOKENS', 'normalizedString', 'NOTATION', 'QName', 'string', 'token')]">NDR-28.028: Datentypen, die per Restriktion mit der Facette minLength ableiten, müssen den W3C-Datentyp xs:anyURI, base64Binary, xs:ENTITIES, xs:ENTITY, xs:hexBinary, xs:ID, xs:IDREF, xs:IDREFS, xs:language, xs:Name, xs:NCName, xs:NMTOKEN, xs:NMTOKENS, xs:normalizedString, xs:NOTATION, xs:QName, xs:string oder xs:token als Basistyp haben. Der Datentyp <sch:value-of select="@name"/> verletzt diese Vorgabe.</sch:assert>
      </sch:rule>
   </sch:pattern>

   <sch:pattern id="pattern.NDR-28.029">
      <sch:title>Facette pattern nur zur Einschränkung von bestimmten einfachen Datentypen</sch:title>      
      <sch:rule context="fm:datentyp[@restriction = 'true'][@pattern]">
         <sch:assert role="error" id="NDR-28.029" test="
               lite:topmost-parent(.)[empty(ancestor::xsdSchema) and @name = ('anyURI', 'base64Binary', 'boolean', 'byte', 'date', 'dateTime', 'decimal', 'double', 'duration', 'ENTITY', 'float', 'gDay', 'gMonth', 'gYear', 'gYearMonth', 'hexBinary', 'ID', 'IDREF', 'int', 'integer', 'language', 'long', 'Name', 'NCName', 'negativeInteger', 'NMTOKEN', 'nonNegativeInteger', 'nonPositiveInteger', 'normalizedString', 'NOTATION', 'positiveInteger', 'QName', 'short', 'string', 'time', 'token', 'unsignedByte', 'unsignedInt', 'unsignedLong', 'unsignedShort')]">NDR-28.029: Datentypen, die per Restriktion mit der Facette pattern ableiten, müssen den W3C-Datentyp xs:anyURI, xs:base64Binary, xs:boolean, xs:byte, xs:date, xs:dateTime, xs:decimal, xs:double, xs:duration, xs:ENTITY, xs:float, xs:gDay, xs:gMonth, xs:gYear, xs:gYearMonth, xs:hexBinary, xs:ID, xs:IDREF, xs:int, xs:integer, xs:language, xs:long, xs:Name, xs:NCName, xs:negativeInteger, xs:NMTOKEN, xs:nonNegativeInteger, xs:nonPositiveInteger, xs:normalizedString, xs:NOTATION, xs:positiveInteger, xs:QName, xs:short, xs:string, xs:time, xs:token, xs:unsignedByte, xs:unsignedInt, xs:unsignedLong oder xs:unsignedShort als Basistyp haben. Der Datentyp <sch:value-of select="@name"/> verletzt diese Vorgabe.</sch:assert>
      </sch:rule>
   </sch:pattern>

   <sch:pattern id="pattern.NDR-28.030">
      <sch:title>Facette totalDigits nur zur Einschränkung von bestimmten einfachen Datentypen</sch:title>      
      <sch:rule context="fm:datentyp[@restriction = 'true'][@totalDigits]">
         <sch:assert role="error" id="NDR-28.030" test="
           lite:topmost-parent(.)[empty(ancestor::xsdSchema) and @name = ('byte', 'decimal', 'int', 'integer', 'long', 'negativeInteger', 'nonNegativeInteger', 'nonPositiveInteger', 'positiveInteger', 'short', 'unsignedByte', 'unsignedInt', 'unsignedLong', 'unsignedShort')]">NDR-28.030: Datentypen, die per Restriktion mit der Facette totalDigits ableiten, müssen den W3C-Datentyp xs:byte, xs:decimal, xs:int, xs:integer, xs:long, xs:negativeInteger, xs:nonNegativeInteger, xs:nonPositiveInteger, xs:positiveInteger, xs:short, xs:unsignedByte, xs:unsignedInt, xs:unsignedLong oder xs:unsignedShort als Basistyp haben. Der Datentyp <sch:value-of select="@name"/> verletzt diese Vorgabe.</sch:assert>
      </sch:rule>
   </sch:pattern>

   <sch:pattern id="pattern.NDR-28.031">
      <sch:title>Facette whitespace nur zur Einschränkung von bestimmten einfachen Datentypen</sch:title>      
      <sch:rule context="fm:datentyp[@restriction = 'true'][@whitespace]">
         <sch:assert role="error" id="NDR-28.031" test="
           lite:topmost-parent(.)[empty(ancestor::xsdSchema) and @name = ('ENTITIES', 'ENTITY', 'ID', 'IDREF', 'IDREFS', 'Name', 'NCName', 'NMTOKEN', 'NMTOKENS', 'normalizedString', 'string', 'token')]">NDR-28.031: Datentypen, die per Restriktion mit der Facette whitespace ableiten, müssen den W3C-Datentyp xs:ENTITIES, xs:ENTITY, xs:ID, xs:IDREF, xs:IDREFS, xs:language, xs:Name, xs:NCName, xs:NMTOKEN, xs:NMTOKENS, xs:normalizedString, xs:string oder xs:token als Basistyp haben. Der Datentyp <sch:value-of select="@name"/> verletzt diese Vorgabe.</sch:assert>
      </sch:rule>
   </sch:pattern>

   <sch:pattern id="pattern.NDR-28.032">
      <sch:title>Eingeschränkte Multiplizität bei Attributen</sch:title>      
      <sch:rule context="fm:eigenschaft[@xsdAttribute = true() and not((compare(@multiplizitaet, '0..1') = 0 or compare(@multiplizitaet, '1') = 0 or compare(@multiplizitaet, '0') = 0 or not(@multiplizitaet)))]">
         <sch:assert role="error" id="NDR-28.032" test="false()">NDR-28.032: Attribute müssen die Multiplizität 0..1, 1 oder 0 besitzen. Das Attribut <sch:value-of select="@name"/> verletzt diese Vorgabe.</sch:assert>
      </sch:rule>
   </sch:pattern>

   <sch:pattern id="pattern.NDR-28.033">
      <sch:title>xsd als Dateiendung von Schema</sch:title>      
      <sch:rule context="
            fm:xsdSchema[
            not(ends-with(@schemaFile, lower-case('.xsd')))]">
         <sch:assert role="error" id="NDR-28.033" test="false()">NDR-28.033: Dateinamen von XML Schema-Definitionen (schemaFile) müssen "xsd" als Dateiendung beinhalten. Das Schema <sch:value-of select="@name"/> verletzt diese Vorgabe.</sch:assert>
      </sch:rule>
   </sch:pattern>

   <sch:pattern id="pattern.NDR-28.034">
      <sch:title>xsd als Dateiendung von Schema Location</sch:title>      
      <sch:rule context="
            fm:xsdSchema[
            not(ends-with(lite:schema-location(.), lower-case('.xsd')))]">
         <sch:assert role="error" id="NDR-28.034" test="false()">NDR-28.034: Schema Locations von XML Schema-Definitionen (schemaLocation) müssen "xsd" als Dateiendung beinhalten. Das Schema <sch:value-of select="@name"/> verletzt diese Vorgabe.</sch:assert>
      </sch:rule>
   </sch:pattern>

    <sch:pattern id="pattern.NDR-28.035">   
      <sch:title>Elemente, Elementgruppen, Attribute und Attributgruppen mit Typ, Referenz oder lokaler Struktur</sch:title>    
      <sch:rule context="fm:eigenschaft|fm:eigenschaftengruppe">
        <sch:assert role="error" id="NDR-28.035" test="
          ((@typ and @name and not(@referenz) and not(@basistyp) and not(fm:eigenschaft) and not(fm:eigenschaftengruppe)) or 
          (@referenz and not(@name) and not(fm:eigenschaft) and not(fm:eigenschaftengruppe)) or 
          (@name and not(@referenz) and not(fm:eigenschaft) and not(fm:eigenschaftengruppe) and fm:anyStruktur) or 
          (@name and fm:union and not(fm:eigenschaft) and not(fm:eigenschaftengruppe) and not(@referenz)) or
          (@name and @basistyp and not(@typ) and not(@referenz)) or 
          (@name and (fm:eigenschaft or fm:eigenschaftengruppe) and not(@typ) and not(@referenz)) or
          (not(@name) and (fm:eigenschaft or fm:eigenschaftengruppe) and not(@typ) and not(@referenz))) and
          (not(@name and @referenz))">NDR-28.035: Elemente, Elementgruppen, Attribute und Attributgruppen müssen entweder einen Typ, eine Referenz oder eine lokale Struktur besitzen. Wenn eine Referenz vorhanden ist, darf kein Name vorhanden sein - in allen anderen Fällen muss ein Name vorhanden sein. Element / Elementgruppe / Attribut / Attributgruppe mit Namen (<sch:value-of select="@name"/>) und/oder Referenz (<sch:value-of select="@referenz"/>) in <sch:value-of select="ancestor::fm:datentyp/@name | ancestor::fm:eigenschaft/@name | ancestor::fm:globaleEigenschaft/@name"/> verletzt diese Vorgabe.</sch:assert>
      </sch:rule>
    </sch:pattern>
    
    <sch:pattern id="pattern.NDR-28.036">
      <sch:title>Zyklenfreie Importe und Inkludierungen von Schema</sch:title>    
      <sch:rule context="fm:xsdSchema">
        <sch:let name="schema" value="."/>
        <sch:assert role="error" id="NDR-28.036" 
          test="empty($lite:implicit-and-explicit-schema-include-closure//lite:include[lite:including/@id = $schema/lite:schema-id(.) and $schema/lite:schema-id(.) = lite:included/@id])">NDR-28.036: Eine XML Schema-Definition darf sich nicht direkt oder indirekt selbst inkludieren oder importieren. Das Schema <sch:value-of select="$schema/@name"/> verletzt diese Vorgabe.</sch:assert>
      </sch:rule>
    </sch:pattern>
    
    <sch:pattern id="pattern.NDR-28.037">
      <sch:title>Unqualifizierte Elemente bei namensraumübergreifenden Restriktionen</sch:title>    
      <sch:rule context="fm:eigenschaft[parent::fm:datentyp[@basistyp and @restriction = 'true'] and @xsdAttribute = false()]
        [not(lite:namespace(parent::fm:datentyp) = lite:namespace(lite:resolve(parent::fm:datentyp/@basistyp, parent::fm:datentyp, false())))]">      
        <sch:let name="basistyp" value="parent::fm:datentyp/@basistyp"/>
        <sch:let name="parent" value="parent::fm:datentyp"/>
        <sch:assert role="error" id="NDR-28.037" test="
          (ancestor::fm:xsdSchema/@elementFormDefault = 'unqualified' or
          ancestor::fm:xoev-fachmodell/@elementFormDefault = 'unqualified' or
          ./@form = 'unqualified')
          and
          (every $e in lite:resolve(parent::fm:datentyp/@basistyp, parent::fm:datentyp, false())/lite:elements(.)
          satisfies
          (($e/@form = 'unqualified' or
          (lite:resolve($basistyp, $parent, false())/ancestor::fm:xsdSchema/@elementFormDefault = 'unqualified' or
          (lite:resolve($basistyp, $parent, false())/ancestor::fm:xsdXModel/@elementFormDefault = 'unqualified')))))">NDR-28.037: Eine namensraumübergreifende XML-Restriktion zweier Datentypen erfordert, dass alle Elemente der beiden Datentypen unqualifiziert sind (form = "unqualified"). Im Falle der Restriktion zwischen den beiden Datentypen <sch:value-of select="$parent/@name"/> (einschränkender Datentyp) und <sch:value-of select="$parent/@basistyp"/> (eingeschränkter Datentyp) wird diese Vorgabe nicht eingehalten.</sch:assert>
      </sch:rule>
    </sch:pattern>
    
    <sch:pattern id="pattern.NDR-28.038">
      <sch:title>Ausschließlich einfache Datentypen als Member eines Unions</sch:title>    
      <sch:rule context="fm:memberType">
        <sch:assert role="error" id="NDR-28.038" test="not (. = '') and lite:resolve(., ., false()) and lite:is-simple-type(lite:resolve(., ., false())) = true()">NDR-28.038: Ein Datentyp, der als Member einer XML-Union genutzt wird, muss ein einfacher Datentyp sein. Der Typ <sch:value-of select="."/> verletzt diese Vorgabe. Er wird als Member der Union <sch:value-of select="ancestor::fm:datentyp/@name | ancestor::fm:eigenschaft/@name | ancestor::fm:globaleEigenschaft/@name"/> genutzt.</sch:assert>
      </sch:rule>
    </sch:pattern>
    
    <sch:pattern id="pattern.NDR-28.039">
      <sch:title>Nur benannte Datentypen als Member eines Unions</sch:title>    
      <sch:rule context="fm:memberType">
        <sch:assert role="error" id="NDR-28.039" test="not (. = '')">NDR-28.039: Ein Datentyp, der als Member einer XML-Union genutzt wird, muss ein benannter Datentyp sein. Union <sch:value-of select="ancestor::fm:datentyp/@name | ancestor::fm:eigenschaft/@name | ancestor::fm:globaleEigenschaft/@name"/> verletzt diese Vorgabe.</sch:assert>
      </sch:rule>
    </sch:pattern>
  
    <sch:pattern id="pattern.NDR-28.040">
      <sch:title>Verweise auf globale Datentypen, globale Attribute, globale Elemente oder globale Gruppen mit Präfix</sch:title>      
      <sch:rule context="fm:datentyp[@basistyp]|
        fm:eigenschaft[@typ or @basistyp or @referenz]|
        fm:eigenschaftengruppe[@referenz]|        
        fm:codeDatentyp[fm:typDesCodeElements]|
        fm:nachricht[@typ or @basistyp]|        
        fm:globaleEigenschaft[@typ or @basistyp or @referenz]|
        fm:union[fm:memberType]">
        <sch:assert role="error" id="NDR-28.040" test="
          if (fm:memberType) then 
            ((every $m in fm:memberType
              satisfies
            (contains($m, ':')))) else if(fm:typDesCodeElements) then contains(fm:typDesCodeElements, ':') else if (@typ) then contains(@typ, ':') else if (@basistyp) then contains(@basistyp, ':') else contains(@referenz, ':')">NDR-28.040: Alle Verweise auf globale Datentypen, globale Attribute, globale Elemente oder globale Gruppen müssen mit einem über einen Doppelpunkt abgetrennten Präfix referenziert werden. Im Kontext von <sch:value-of  select="@name"/> wird diese Vorgabe nicht eingehalten.</sch:assert>
      </sch:rule>
    </sch:pattern>
  
    <sch:pattern id="pattern.NDR-28.041">
      <sch:title>Attribute mit einfachem Typ</sch:title>
      <sch:rule context="fm:eigenschaft[@xsdAttribute = 'true' and (@basistyp or @typ)]">
        <sch:assert role="error" id="NDR-28.041" test="((lite:resolve(@typ, ., false()) and lite:is-simple-type(lite:resolve(@typ, ., false())) = true()) and 
          (lite:resolve(@basistyp, ., false()) and lite:is-simple-type(lite:resolve(@basistyp, ., false())) = true()) = false())">NDR-28.041: Ein Attribut darf sich nur auf einen einfachen Datentyp beziehen. Im Kontext von <sch:value-of select="@name"/> wird diese Vorgabe nicht eingehalten.</sch:assert>
      </sch:rule>
    </sch:pattern>
  
    <sch:pattern id="pattern.NDR-28.042">
      <sch:title>Nur Attribute zur Erweiterung einfacher Datentypen</sch:title>      
      <sch:rule context="fm:datentyp[@basistyp and @restriction = 'false' and lite:is-simple-type(lite:resolve(@basistyp, ., false())) = true()]/fm:eigenschaft">
        <sch:let name="baustein" value="parent::fm:datentyp"/>
        <sch:let name="basistyp" value="lite:resolve(@basistyp, ., false())"/>
        <sch:assert role="error" id="NDR-28.042" test="@xsdAttribute = 'true'">NDR-28.042: Per XML-Erweiterung (extension) abgeleitete einfache Typen dürfen keine zusätzlichen Elemente mehr hinzufügen. <sch:value-of select="@name"/> im Datentyp <sch:value-of select="$baustein/@name"/> verletzt diese Vorgabe.</sch:assert>
      </sch:rule>
    </sch:pattern>
  
   <sch:pattern id="pattern.NDR-29.001">
      <sch:title>Namensraum für Schema</sch:title>      
      <sch:rule context="fm:xsdSchema[empty((@namespace, ancestor::fm:xoev-fachmodell/fm:konfiguration.xoev-fachmodell/fm:namespace)[. != ''])]">
        <sch:assert role="error" id="NDR-29.001" test="false()">NDR-29.001: XML Schema-Definitionen müssen einen Namensraum besitzen, entweder über namespace am XML-Schema oder über namespace am XÖV-Fachmodell. Das XML-Schema <sch:value-of select="@name"/> verletzt diese Vorgabe.</sch:assert>
      </sch:rule>
   </sch:pattern>

   <sch:pattern id="pattern.NDR-29.002">
      <sch:title>Namensraumpräfix für Schema</sch:title>
      <sch:rule context="fm:xsdSchema[empty((@prefix, ancestor::fm:xoev-fachmodell/fm:konfiguration.xoev-fachmodell/fm:prefix)[. != ''])]">
        <sch:assert role="error" id="NDR-29.002" test="false()">NDR-29.002: XML Schema-Definitionen müssen ein Namensraumpräfix besitzen, entweder über prefix am XML-Schema oder über prefix am XÖV-Fachmodell. Das XML-Schema <sch:value-of select="@name"/> verletzt diese Vorgabe.</sch:assert>
      </sch:rule>
   </sch:pattern>

   <sch:pattern id="pattern.NDR-30.001">
      <sch:title>Version für Schema</sch:title>      
      <sch:rule context="fm:xsdSchema[empty((@version, ancestor::fm:xoev-fachmodell/fm:metadaten.versionStandard/fm:version)[. != ''])]">
        <sch:assert role="error" id="NDR-30.001" test="false()">NDR-30.001: XML Schema-Definitionen müssen eine Version besitzen, entweder über version am XML-Schema oder über version am XÖV-Fachmodell. Das XML-Schema <sch:value-of select="@name"/> verletzt diese Vorgabe.</sch:assert>
      </sch:rule>
   </sch:pattern>

   <sch:pattern id="pattern.NDR-32.001">
      <sch:title>Kennung des Standards beginnt mit urn:xoev-de:</sch:title>      
      <sch:rule context="fm:xoev-fachmodell[not(starts-with(fm:metadaten.standard/fm:kennung, 'urn:xoev-de:'))]">
        <sch:assert role="error" id="NDR-32.001" test="false()">NDR-32.001: Die Kennung des Standards (kennung) muss mit der Zeichenfolge "urn:xoev-de:" beginnen. Die angegebene Kennung <sch:value-of select="fm:xoev-fachmodell/fm:metadaten.standard/fm:kennung"/> verletzt diese Vorgabe.</sch:assert>
      </sch:rule>
   </sch:pattern>

   <sch:pattern id="pattern.NDR-32.002">
      <sch:title>Kennung des Standards mit :standard:</sch:title>      
      <sch:rule context="fm:xoev-fachmodell[not(contains(fm:metadaten.standard/fm:kennung, ':standard:'))]">
        <sch:assert role="error" id="NDR-32.002" test="false()">NDR-32.002: Die Kennung des Standards (kennung) muss die Zeichenfolge ":standard:" enthalten. Die angegebene Kennung <sch:value-of select="fm:xoev-fachmodell/fm:metadaten.standard/fm:kennung"/> verletzt diese Vorgabe.</sch:assert>
      </sch:rule>
   </sch:pattern>

   <sch:pattern id="pattern.NDR-32.003">
      <sch:title>Kennung des Standards mit kleingeschriebenem technischen Namen des Standards</sch:title>      
      <sch:rule context="fm:xoev-fachmodell[not(contains(fm:metadaten.standard/fm:kennung, lower-case(fm:metadaten.standard/fm:nameTechnisch)))]">
        <sch:assert role="error" id="NDR-32.003" test="false()">NDR-32.003: Die Kennung des Standards (kennung) muss den technischen Namen des Standards (nameTechnisch) in Kleinschreibung enthalten. Die angegebene Kennung <sch:value-of select="fm:xoev-fachmodell/fm:metadaten.standard/fm:kennung"/> verletzt diese Vorgabe und enthält nicht den technischen Namen <sch:value-of select="fm:xoev-fachmodell/fm:metadaten.standard/fm:nameTechnisch"/> in Kleinschreibung.</sch:assert>
      </sch:rule>
   </sch:pattern>

   <sch:pattern id="pattern.NDR-32.004">
      <sch:title>Kennung des Standards mit xoev nur zu Beginn in urn:xoev-de</sch:title>      
      <sch:rule context="fm:xoev-fachmodell[contains(replace(fm:metadaten.standard/fm:kennung, 'urn:xoev-de', ''), 'xoev')]">
        <sch:assert role="error" id="NDR-32.004" test="false()">NDR-32.004: Die Kennung des Standards (kennung) muss mit der Zeichenfolge "urn:xoev-de:" beginnen, darf die Zeichenfolge "xoev" jedoch an keiner weiteren Stelle enthalten. Die angegebene Kennung <sch:value-of select="fm:xoev-fachmodell/fm:metadaten.standard/fm:kennung"/> verletzt diese Vorgabe.</sch:assert>
      </sch:rule>
   </sch:pattern>

   <sch:pattern id="pattern.NDR-32.005">
      <sch:title>Nur erlaubte Zeichen in der Kennung eines Standards</sch:title>      
      <sch:rule context="fm:xoev-fachmodell[replace(fm:metadaten.standard/fm:kennung, '[a-z0-9\.\-,:]', '') != '']">
        <sch:assert role="error" id="NDR-32.005" test="false()">NDR-32.005: Die Kennung des Standards (kennung) darf nur die Zeichen "a-z", "0-9", "-", ":" und "." enthalten. Die angegebene Kennung <sch:value-of select="fm:xoev-fachmodell/fm:metadaten.standard/fm:kennung"/> verletzt diese Vorgabe.</sch:assert>
      </sch:rule>
   </sch:pattern>

   <sch:pattern id="pattern.NDR-32.006">
      <sch:title>Nur erlaubte Zeichen im technischen Namen eines Standards</sch:title>      
      <sch:rule context="fm:xoev-fachmodell[replace(fm:metadaten.standard/fm:nameTechnisch, '[a-zA-Z0-9\.\-,]', '') != '']">
        <sch:assert role="error" id="NDR-32.006" test="false()">NDR-32.006: Der technische Name des Standards (nameTechnisch) darf nur die Zeichen "a-z", "A-Z", "0-9", "-" und "." enthalten. Der angegebene technische Name <sch:value-of select="fm:xoev-fachmodell/fm:metadaten.standard/fm:nameTechnisch"/> verletzt diese Vorgabe.</sch:assert>
      </sch:rule>
   </sch:pattern>

  <sch:pattern id="pattern.NDR-32.007">
      <sch:title>Nur erlaubte Zeichen in der Version eines Standards</sch:title>      
      <sch:rule context="fm:xoev-fachmodell[replace(fm:metadaten.versionStandard/fm:version, '[a-zA-Z0-9\.\-,]', '') != '']">
        <sch:assert role="error" id="NDR-32.007" test="false()">NDR-32.007: Die Version des Standards (version) darf nur die Zeichen "a-z", "A-Z", "0-9", "-", ":" und "." enthalten. Die angegebene Version <sch:value-of select="fm:xoev-fachmodell/fm:metadaten.versionStandard/fm:version"/> verletzt diese Vorgabe.</sch:assert>
      </sch:rule>
   </sch:pattern>
  
    <sch:pattern id="pattern.NDR-33.001">
      <sch:title>token als Basis des Elements code in Code-Datentypen</sch:title>
      <sch:rule context="fm:codeDatentyp[fm:typDesCodeElements][not(lite:topmost-parent(fm:typDesCodeElements)[empty(ancestor::xsdSchema) and @name = 'token'] or fm:typDesCodeElements = 'xs:token')]">
        <sch:assert role="error" id="NDR-33.001" test="false()">NDR-33.001: Der über typDesCodeElements (am XÖV-Fachmodell oder Code-Datentyp) bestimmte Datentyp muss xs:token oder ein davon abgeleiteter Datentyp sein. <sch:value-of select="@name"/> verletzt diese Vorgabe.</sch:assert>
      </sch:rule>
    </sch:pattern>

    <sch:pattern id="pattern.NDR-33.002">
      <sch:title>Angabe von Kennung und Version für Schema-validierende Codes in Code-Datentypen</sch:title>
      <sch:rule context="fm:xoev-fachmodell//fm:codeDatentyp[fm:codesSchemavalidiert = 'true']">
        <sch:assert role="error" id="NDR-33.002" test="@kennung and @version">NDR-33.002: Code-Datentypen, deren Codes schema-validierend integriert werden sollen, müssen eine Kennung und eine Version für die Codeliste besitzen. <sch:value-of select="@name"/> verletzt diese Vorgabe.</sch:assert>
      </sch:rule>
    </sch:pattern>  
    
    <sch:pattern id="pattern.NDR-33.003">
      <sch:title>Definition genutzter Code-Spalte als Code-Spalte der Codelisten-Version</sch:title>
      <sch:rule context="fm:xoev-fachmodell//fm:codeDatentyp[fm:genutzteCodeSpalte]">
        <sch:let name="genutzteCodeSpalte" value="fm:genutzteCodeSpalte"/>
        <sch:assert role="error" id="NDR-33.003" 
          test="some $sp in lite:genutzte-cl-oder-vcl(.)/lite:versioncodeliste-spalten(.)
          satisfies
          ($sp/@Id = $genutzteCodeSpalte and lite:versioncodeliste-spalte-codeSpalte($sp))
          ">NDR-33.003: Die über genutzteCodeSpalte am Code-Datentyp bestimmte Spalte muss eine Code-Spalte der genutzten Codelisten-Version sein. GenutzteCodeSpalte <sch:value-of select="lite:genutzte-code-spalte(., lite:genutzte-cl-oder-vcl(.))"/> in Code-Datentyp <sch:value-of select="@name"/> verletzt diese Vorgabe.</sch:assert>
      </sch:rule>
    </sch:pattern>
    
    <sch:pattern id="pattern.NDR-33.004">
      <sch:title>Korrekte Codelistenmodellierung</sch:title>
      <sch:rule context="fm:xoev-fachmodell//fm:codeDatentyp[fm:genutzteBeschreibungsspalte]">
        <sch:let name="genutzteBeschreibungsspalte" value="fm:genutzteBeschreibungsspalte"/>
        <sch:assert role="error" id="NDR-33.004" 
          test="some $sp in lite:genutzte-cl-oder-vcl(.)/lite:versioncodeliste-spalten(.)
          satisfies
          ($sp/@Id = $genutzteBeschreibungsspalte)
          ">NDR-33.004: Die über genutzteBeschreibungsspalte am Code-Datentyp bestimmte Spalte muss eine Spalte der genutzten Codelisten-Version sein. GenutzteBeschreibungsspalte <sch:value-of select="$genutzteBeschreibungsspalte"/> in Code-Datentyp <sch:value-of select="@name"/> verletzt diese Vorgabe.</sch:assert>
      </sch:rule>
    </sch:pattern>

    <sch:pattern id="pattern.lite.001">
      <sch:title>Beispielwerte nur im erlaubten Kontext</sch:title>
      <sch:rule context="fm:beispielwert[parent::fm:datentyp]">      
        <sch:assert role="error" id="lite.001" test="lite:is-simple-type(./parent::fm:datentyp) = true()">lite.001: Ein Beispielwert darf nur zu einem einfachen Datentyp angegeben werden. Im Kontext des Datentyps <sch:value-of select="parent::fm:datentyp/@name"/> wird diese Vorgabe für Beispielwert <sch:value-of select="."/> verletzt.</sch:assert>
      </sch:rule>
    </sch:pattern>
    
    <sch:pattern id="pattern.lite.002">
      <sch:title>Beispielewerte nur für lokale Elemente und Attribute mit einfachem Typ</sch:title>
      <sch:rule context="fm:beispielwert[parent::fm:eigenschaft/@typ]">
        <sch:assert role="error" id="lite.002" test="lite:is-simple-type(lite:resolve(parent::fm:eigenschaft/@typ, ., false()))">lite.002: Ein Beispielwert darf nur zu einem lokalen Element oder Attribut mit einfachem Datentyp angegeben werden. Im Kontext von <sch:value-of select="parent::fm:eigenschaft/@name"/> in <sch:value-of select="ancestor::fm:datentyp/@name | ancestor::fm:nachricht/@name"/> wird diese Vorgabe verletzt.</sch:assert>
      </sch:rule>
    </sch:pattern>
    
    <sch:pattern id="pattern.lite.003">
      <sch:title>Beispielewerte nur für globale Elemente und Attribute mit einfachem Typ</sch:title>
      <sch:rule context="fm:beispielwert[parent::fm:globaleEigenschaft/@typ]">
        <sch:assert role="error" id="lite.003" test="lite:is-simple-type(lite:resolve(parent::fm:globaleEigenschaft/@typ, ., false()))">lite.003: Ein Beispielwert darf nur zu einem globalen Element oder Attribut mit einfachen Datentyp angegeben werden. Im Kontext von <sch:value-of select="parent::fm:globaleEigenschaft/@name"/> wird diese Vorgabe verletzt.</sch:assert>
      </sch:rule>
    </sch:pattern>
    
    <sch:pattern id="pattern.lite.004">
      <sch:title>Beispielwerte nur für Elemente und Attribute mit Referenz auf Element oder Attribut mit einfachem Typ</sch:title>
      <sch:rule context="fm:beispielwert[parent::fm:eigenschaft/@referenz]">
        <sch:assert role="error" id="lite.004" test="lite:is-simple-type(lite:resolve(lite:resolve(parent::fm:eigenschaft/@referenz, ., true())/@typ, ., false()))">lite.004: Ein Beispielwert darf nur zu einem Element oder Attribut angegeben werden, das auf ein globales Element oder Attribut mit einfachem Datentyp referenziert. Im Kontext von <sch:value-of select="parent::fm:eigenschaft/@referenz"/> des Datentyps / der Nachricht <sch:value-of select="ancestor::fm:datentyp/@name | ancestor::fm:nachricht/@name"/> wird diese Vorgabe nicht eingehalten.</sch:assert>
      </sch:rule>
    </sch:pattern>
    
    <sch:pattern id="pattern.lite.005">
      <sch:title>Beispielwerte nur für Elemente und Attribute mit Einschränkung auf einfachen Typ</sch:title>
      <sch:rule context="fm:beispielwert[parent::fm:eigenschaft][not(parent::fm:eigenschaft/@referenz) and not(parent::fm:eigenschaft/@typ)]">
        <sch:assert role="error" id="lite.005" test="parent::fm:eigenschaft/@restriction = true() and 
          lite:is-simple-type(lite:resolve(parent::fm:eigenschaft/@basistyp, ., false()))">lite.005: Ein Beispielwert darf nur zu einem Element oder Attribut angegeben werden, das einen einfachen Datentyp einschränkt. Im Kontext von <sch:value-of select="parent::fm:eigenschaft/@name"/> des Datentyps / der Nachricht <sch:value-of select="ancestor::fm:datentyp/@name | ancestor::fm:nachricht/@name"/> wird diese Vorgabe nicht eingehalten.</sch:assert>
      </sch:rule>
    </sch:pattern>
    
    <sch:pattern id="pattern.lite.006">
      <sch:title>Verarbeitbares XÖV-Fachmodell</sch:title>
      <sch:rule context="/" >      
        <sch:assert id="lite.006" role="error" test="/child::*[
          self::*:xoev-fachmodell and 
          starts-with(namespace-uri(), 'urn:xoev-de:kosit:xoev:lite:schema:fachmodell_')
          ]
          ">lite.006: Das Dokument enthält kein verarbeitbares XÖV-Fachmodell.</sch:assert>
      </sch:rule>
    </sch:pattern>
    
    <sch:pattern id="pattern.lite.007">
      <sch:title>Keine leeren Deklarationen</sch:title>
      <sch:rule context="fm:xoev-fachmodell[attribute::*]|fm:konfiguration.xoev-fachmodell[attribute::*]|fm:metadaten.standard[attribute::*]|
        fm:metadaten.versionStandard[attribute::*]|fm:externesModell[attribute::*]|
        fm:nutztSchema[attribute::*]|fm:nutztCodeliste[attribute::*]|fm:xsdSchema[attribute::*]|fm:osciTransportScenario[attribute::*]|
        fm:wsdlService[attribute::*]|fm:umsetzungshinweis[attribute::*]|fm:beschreibung[attribute::*]|
        fm:geschaeftsregel[attribute::*]|fm:union[attribute::*]|fm:datentyp[attribute::*]|fm:eigenschaft[attribute::*]|fm:eigenschaftengruppe[attribute::*]|
        fm:anyStruktur[attribute::*]|fm:codeDatentyp[attribute::*]|fm:nachricht[attribute::*]|fm:globaleEigenschaftengruppe[attribute::*]|
        fm:globaleEigenschaft[attribute::*]|fm:paket[attribute::*]|fm:elementFormDefault[attribute::*]|fm:standardeinstellungEigenschaften[attribute::*]|
        fm:nutzungNameElement[attribute::*]|fm:wsdlStandardaufbauNamensraum[attribute::*]|fm:wsdlStandardaufbauSubjectOperation[attribute::*]|
        fm:wsdlDateipraefix[attribute::*]|fm:rechtsgrundlage[attribute::*]|fm:TestaPort[attribute::*]|fm:InternetPort[attribute::*]">
        <sch:assert role="warning" id="lite.007" test="not(./attribute::*[. = ''])">lite.007: Alle Deklarationen im XÖV-Fachmodell müssen einen Inhalt haben. Im Kontext der Deklaration <sch:value-of  select="attribute::*[. = '']/name()"/> unter <sch:value-of select="string-join(concat(name(), '(', @name, ')'), '/')"/> wird diese Vorgabe nicht eingehalten.</sch:assert>
      </sch:rule>
    </sch:pattern>

	<sch:pattern id="pattern.lite.008">
		<sch:title>Codelisten mit Kennung liegen im codelists-Verzeichnis vollständig vor</sch:title>
		<sch:rule context="fm:xoev-fachmodell//fm:codeDatentyp[@kennung and not(@version)]">
		  <sch:assert role="error" id="lite.008" test="not(empty(lite:genutzte-cl-oder-vcl(.)))">lite.008: Alle genutzten Codelisten liegen vollständig im codelists-Verzeichnis vor. Im Kontext der genutzten Codeliste <sch:value-of  select="@kennung"/> unter <sch:value-of select="@name"/> wird diese Vorgabe nicht eingehalten.</sch:assert>
		</sch:rule>
	</sch:pattern>
  
	<sch:pattern id="pattern.lite.009">
		<sch:title>Codelisten mit Kennung und Version liegen im codelists-Verzeichnis vollständig vor</sch:title>
		<sch:rule context="fm:xoev-fachmodell//fm:codeDatentyp[@kennung and @version]">
		  <sch:assert role="error" id="lite.009" test="not(empty(lite:genutzte-cl-oder-vcl(.))) and @version = lite:versioncodeliste-version(lite:genutzte-cl-oder-vcl(.))">lite.009: Alle genutzten Codelisten liegen vollständig im codelists-Verzeichnis vor. Im Kontext der genutzten Codeliste <sch:value-of  select="@kennung"/> (Version: <sch:value-of  select="@version"/>) unter <sch:value-of select="@name"/> wird diese Vorgabe nicht eingehalten.</sch:assert>
		</sch:rule>
	</sch:pattern>
  
  <sch:pattern id="pattern.lite.010">
    <sch:title>Externe Modelle liegen im Modell-Verzeichnis vollständig vor</sch:title>
    <sch:rule context="fm:xoev-fachmodell/fm:externesModell[@kennung and @version]">      
      <sch:let name="externesModell" value="."/>
      <sch:let name="anzahlGleichesVorherigesExternesModell" value="count(preceding-sibling::fm:externesModell[@kennung = $externesModell/@kennung and @version = $externesModell/@version])"/>     
      <sch:assert role="error" id="lite.010" test="$anzahlGleichesVorherigesExternesModell != 0 or not(empty($modelle/*:xoev-fachmodell
        [*:metadaten.standard/*:kennung = $externesModell/@kennung and *:metadaten.versionStandard/*:version = $externesModell/@version]) and 
        empty($modelle/*:xoev-bibliothek
        [*:metadaten.bibliothek/*:kennung = $externesModell/@kennung and *:metadaten.versionBibliothek/*:version = $externesModell/@version]))">lite.010: Alle genutzten externen Modelle liegen vollständig im Modell-Verzeichnis vor. Im Kontext des genutzten externen Modells <sch:value-of  select="@kennung"/> (Version: <sch:value-of  select="@version"/>) wird diese Vorgabe nicht eingehalten.</sch:assert>                
    </sch:rule>
  </sch:pattern>
  
  <sch:pattern id="pattern.lite.011">
    <sch:title>Externe Modelle im XÖV-Fachmodell bestimmt</sch:title>
    <sch:rule context="fm:xoev-fachmodell">     
      <sch:let name="fachmodell" value="."/>      
      <sch:assert role="error" id="lite.011" test="every $externesModell in $modelle
        satisfies
        (($fachmodell/fm:externesModell[
        (($externesModell/*:xoev-fachmodell/*:metadaten.standard/*:kennung = @kennung and $externesModell/*:xoev-fachmodell/*:metadaten.versionStandard/*:version = @version) or 
        ($externesModell/*:xoev-bibliothek/*:metadaten.bibliothek/*:kennung = @kennung and $externesModell/*:xoev-bibliothek/*:metadaten.versionBibliothek/*:version = @version))]) or 
        ($externesModell/*:xoev-fachmodell/*:metadaten.standard/*:kennung = $fachmodell/fm:metadaten.standard/fm:kennung and $externesModell/*:xoev-fachmodell/*:metadaten.versionStandard/*:version = $fachmodell/fm:metadaten.versionStandard/fm:version))">lite.011: Alle genutzten externen Modelle sollen im XÖV-Fachmodell bestimmt sein. Im Kontext der genutzten externen Modelle 
        <sch:value-of select="
          for $externesModell in $modelle
          return if 
          (($fachmodell/fm:externesModell[
          (($externesModell/*:xoev-fachmodell/*:metadaten.standard/*:kennung = @kennung and $externesModell/*:xoev-fachmodell/*:metadaten.versionStandard/*:version = @version) or 
          ($externesModell/*:xoev-bibliothek/*:metadaten.bibliothek/*:kennung = @kennung and $externesModell/*:xoev-bibliothek/*:metadaten.versionBibliothek/*:version = @version))]) or 
          ($externesModell/*:xoev-fachmodell/*:metadaten.standard/*:kennung = $fachmodell/fm:metadaten.standard/fm:kennung and $externesModell/*:xoev-fachmodell/*:metadaten.versionStandard/*:version = $fachmodell/fm:metadaten.versionStandard/fm:version))
          then ''
          else if ($externesModell/*:xoev-fachmodell) 
            then concat($externesModell/*:xoev-fachmodell/*:metadaten.standard/*:kennung, ' (', $externesModell/*:xoev-fachmodell/*:metadaten.versionStandard/*:version, ') - ')
            else concat($externesModell/*:xoev-bibliothek/*:metadaten.bibliothek/*:kennung, ' (', $externesModell/*:xoev-bibliothek/*:metadaten.versionBibliothek/*:version, ') - ')
          "/> wird diese Vorgabe nicht eingehalten.</sch:assert>                        
    </sch:rule>
  </sch:pattern>

    <sch:pattern id="pattern.GP-1.001">
      <sch:title>Paket für Basisdatentypen</sch:title>      
      <sch:rule context="fm:xoev-fachmodell[count(fm:paket[@name = 'Basisdatentypen'] | fm:xsdSchema[@name = 'Basisdatentypen']) = 0]">
        <sch:assert role="information" id="GP-1.001" test="false()">GP-1.001: Es wird empfohlen, im XÖV-Fachmodell ein Paket mit Namen "Basisdatentypen" vorzusehen. Das XÖV-Fachmodell enthält kein Paket mit dem Namen "Basisdatentypen".</sch:assert>
      </sch:rule>
    </sch:pattern>
    
    <sch:pattern id="pattern.GP-1.002">
      <sch:title>Paket für Baukasten</sch:title>      
      <sch:rule context="fm:xoev-fachmodell[count(fm:paket[@name = 'Baukasten'] | fm:xsdSchema[@name = 'Baukasten']) = 0]">
        <sch:assert role="information" id="GP-1.002" test="false()">GP-1.002: Es wird empfohlen, im XÖV-Fachmodell ein Paket mit Namen "Baukasten" vorzusehen. Das XÖV-Fachmodell enthält kein Paket mit dem Namen "Baukasten".</sch:assert>
      </sch:rule>
    </sch:pattern>
    
    <sch:pattern id="pattern.GP-1.003">
      <sch:title>Paket für Nachrichten oder Fachmodule</sch:title>      
      <sch:rule context="fm:xoev-fachmodell[count(fm:paket[@name = 'Nachrichten' or @name = 'Fachmodule'] | fm:xsdSchema[@name = 'Nachrichten' or @name = 'Fachmodule']) = 0]">
        <sch:assert role="information" id="GP-1.003" test="false()">GP-1.003: Es wird empfohlen, im XÖV-Fachmodell ein Paket mit Namen "Nachrichten" bzw. "Fachmodule" vorzusehen. Das XÖV-Fachmodell enthält kein Paket mit dem Namen "Nachrichten" oder "Fachmodule".</sch:assert>
      </sch:rule>
    </sch:pattern>
    
    <sch:pattern id="pattern.GP-1.004">
      <sch:title>Mindestens ein Schema für Nachrichten oder Fachmodule</sch:title>      
      <sch:rule context="
        fm:xoev-fachmodell[fm:paket[@name = 'Nachrichten' or @name = 'Fachmodule']
        [empty(fm:xsdSchema[not(@name = 'Nachrichtentypen')])]]">
        <sch:assert role="information" id="GP-1.004" test="false()">GP-1.004: Es wird empfohlen, im Paket "Nachrichten" bzw. "Fachmodule" mindestens ein Nachrichtenhauptgruppen-Schema vorzusehen. Das XÖV-Fachmodell enthält nicht mindestens ein Schema im Paket mit dem Namen "Nachrichten" oder "Fachmodule".</sch:assert>
      </sch:rule>
    </sch:pattern>
    
    <sch:pattern id="pattern.GP-1.005">
      <sch:title>Nachrichten nur in einem Schema für Nachrichten oder Fachmodule</sch:title>      
      <sch:rule context="fm:nachricht[not(ancestor-or-self::fm:paket[@name = 'Nachrichten' or @name = 'Fachmodule'] | ancestor-or-self::fm:xsdSchema[@name = 'Nachrichten' or @name = 'Fachmodule'])]">
        <sch:assert role="information" id="GP-1.005" test="false()">GP-1.005: Es wird empfohlen, Nachrichten nur in einem Schema unterhalb des Pakets "Nachrichten" bzw. "Fachmodule" zu spezifizieren. Die Nachricht <sch:value-of select="@name"/> entspricht der Empfehlung nicht.</sch:assert>
      </sch:rule>
    </sch:pattern>
    
    <sch:pattern id="pattern.GP-1.006">
      <sch:title>Schema im Paket Nachrichten oder Fachmodule mit mindestens einer Nachricht</sch:title>      
      <sch:rule context="
        fm:xsdSchema[ancestor::fm:paket[@name = 'Nachrichten' or @name = 'Fachmodule']
        [not(@name = 'Nachrichtentypen')]]
        [count(descendant::fm:nachricht) = 0]">
        <sch:assert role="information" id="GP-1.006" test="false()">GP-1.006: Es wird empfohlen, in einem Schema unterhalb des Paketes "Nachrichten" bzw. "Fachmodule" mindestens eine Nachricht zu spezifieren. Das Schema <sch:value-of select="@name"/> entspricht der Empfehlung nicht.</sch:assert>
      </sch:rule>
    </sch:pattern>
  
    <sch:pattern id="pattern.GP-5.001">
      <sch:title>Nutzung von Schema-validierenden Codelistenversionen über benannte Datentypen</sch:title>
      <sch:rule context="fm:codeDatentyp[fm:benannterCodelistenDatentyp = 'false'][fm:codesSchemavalidiert = 'true'][not(@draft = 'true')]">
        <sch:assert role="information" id="GP-5.001" test="false()">GP-5.001: Es wird empfohlen, Schema-validierende Codelistenversionen über benannte Datentypen einzubinden und diese dann in dem eigentlichen Code-Datentyp zu referenzieren. Im Kontext des Code-Datentyps <sch:value-of select="@name"/> wird diese Empfehlung nicht eingehalten.</sch:assert>
      </sch:rule>
    </sch:pattern>
    
    <sch:pattern id="pattern.GP-5.002">
      <sch:title>Namen benannter Datentypen zur Nutzung von Schema-validierenden Codelisten-Versionen eindeutig</sch:title>
      <sch:rule context="fm:codeDatentyp[fm:benannterCodelistenDatentyp = 'true'][fm:codesSchemavalidiert = 'true'][not(@draft = 'true')][fm:benannterCodelistenDatentypXSD]">
        <sch:assert role="error" id="GP-5.002" test="
          not(count(
          ancestor::fm:xoev-fachmodell//fm:codeDatentyp[
          ./fm:benannterCodelistenDatentypXSD = current()/fm:benannterCodelistenDatentypXSD and ./fm:benannterCodelistenDatentypName = current()/fm:benannterCodelistenDatentypName]) > 1)">GP-5.002: Datentypen, die Schema-validierende Codelisten einbinden und über einen Code-Datentyp referenziert werden, müssen bzgl. ihres Namens eindeutig sein. Der Datentyp <sch:value-of select="fm:benannterCodelistenDatentypXSD"/>, der über den Code-Datentyp <sch:value-of select="@name"/> benannt wird, hat denselben Namen wie ein anderer Datentyp in dem Schema <sch:value-of select="fm:benannterCodelistenDatentypXSD"/>.</sch:assert>
      </sch:rule>
    </sch:pattern>
    
    <sch:pattern id="pattern.GP-5.003">
      <sch:title>Benannte Datentypen zur Nutzung von Schema-validierenden Codelisten-Versionen in einem Schema des XÖV-Standards</sch:title>
      <sch:rule context="fm:codeDatentyp[fm:benannterCodelistenDatentyp = 'true'][fm:codesSchemavalidiert = 'true'][not(@draft = 'true')][fm:benannterCodelistenDatentypXSD]">
        <sch:let name="schema" value="fm:benannterCodelistenDatentypXSD"/>
        <sch:assert role="error" id="GP-5.003" test="count(ancestor::fm:xoev-fachmodell//fm:xsdSchema[@schemaFile = $schema]) = 1">GP-5.003: Datentypen, die Schema-validierende Codelisten einbinden und über einen Code-Datentyp referenziert werden, müssen zu einem Schema des XÖV-Standards gehören. Der Datentyp <sch:value-of select="fm:benannterCodelistenDatentypXSD"/>, der über den Code-Datentyp <sch:value-of select="@name"/> referenziert wird, gehört zum Schema <sch:value-of select="fm:benannterCodelistenDatentypXSD"/>, das kein Bestandteil des XÖV-Standards ist.</sch:assert>
      </sch:rule>
    </sch:pattern>
  
   <sch:pattern id="pattern.GP-6.001">
      <sch:title>Keine aufeinanderfolgenden Punkte in Namen von Typen, globalen Elementen, Nachrichten und Datentypen</sch:title>      
      <sch:rule context="fm:globaleEigenschaft[@xsdAttribute = false()] | fm:nachricht | fm:datentyp[@name] | fm:codeDatentyp[@name]">
        <sch:assert role="warning" id="GP-6.001" test="not(contains(@name, '..'))">GP-6.001: Es wird empfohlen, dass die Namen von Typen, globalen Elementen, Nachrichten und Datentypen keine aufeinanderfolgenden Punkte enthalten. <sch:value-of select="@name"/> verletzt diese Vorgabe.</sch:assert>
      </sch:rule>
   </sch:pattern>

  <sch:pattern id="pattern.GP-6.002">
      <sch:title>Keine aufeinanderfolgenden Punkte in Namen von Elementen und Attributen</sch:title>      
      <sch:rule context="fm:eigenschaft[@name]">
        <sch:assert role="warning" id="GP-6.002" test="not(contains(@name, '..'))">GP-6.002: Es wird empfohlen, dass die Namen von Elementen und Attributen keine aufeinanderfolgenden Punkte enthalten. <sch:value-of select="@name"/> verletzt diese Vorgabe.</sch:assert>
      </sch:rule>
   </sch:pattern>      

   <sch:pattern id="pattern.GP-8.001">
      <sch:title>Großer Buchstabe am Beginn des Namens von Datentypen</sch:title>
      <sch:rule context="fm:datentyp[@name] | fm:codeDatentyp[@name]">
         <sch:assert role="information" id="GP-8.001" test="not(substring(@name, 1, 1) != upper-case(substring(@name, 1, 1)))">GP-8.001: Es wird empfohlen, Namen benannter Typen mit einem Großbuchstaben zu beginnen. <sch:value-of select="@name"/> entspricht der Empfehlung nicht.</sch:assert>
      </sch:rule>
   </sch:pattern>

   <sch:pattern id="pattern.GP-8.002">
      <sch:title>Kleiner Buchstabe am Beginn des Namens von Elementen und Attributen</sch:title>      
      <sch:rule context="fm:eigenschaft[substring(@name, 1, 1) != lower-case(substring(@name, 1, 1))]">
         <sch:assert role="information" id="GP-8.002" test="false()">GP-8.002: Es wird empfohlen, Namen von Elementen und Attributen mit einem Kleinbuchstaben zu beginnen. <sch:value-of select="@name"/> entspricht der Empfehlung nicht.</sch:assert>
      </sch:rule>
   </sch:pattern>

  <sch:pattern id="pattern.GP-8.003">
      <sch:title>Kleiner Buchstabe am Beginn des Namens von globalen Elementen und Nachrichten</sch:title>      
      <sch:rule context="
            fm:globaleEigenschaft[@xsdAttribute != true()][substring(@name, 1, 1) != lower-case(substring(@name, 1, 1))] |
            fm:nachricht[substring(@name, 1, 1) != lower-case(substring(@name, 1, 1))]">
          <sch:assert role="information" id="GP-8.003" test="false()">GP-8.003: Es wird empfohlen, Namen globaler Elemente und Nachrichten mit einem Kleinbuchstaben zu beginnen. <sch:value-of select="@name"/> entspricht der Empfehlung nicht.</sch:assert>
      </sch:rule>
   </sch:pattern>

  <sch:pattern id="pattern.GP-9.001">
      <sch:title>Vorangestellter Präfix in Namen von Nachrichten</sch:title>      
      <sch:rule context="fm:nachricht[count(tokenize(@name, '\.')) lt 2]">
          <sch:assert role="information" id="GP-9.001" test="false()">GP-9.001: Es wird empfohlen, Namen von Nachrichten ein mit einem Punkt abgetrenntes Präfix voranzustellen. <sch:value-of select="@name"/> entspricht der Empfehlung nicht.</sch:assert>
      </sch:rule>
   </sch:pattern>

  <sch:pattern id="pattern.GP-9.002">
      <sch:title>Vorangestellter Präfix in Namen von Nachrichten entspricht Name des Schema-Pakets</sch:title>      
      <sch:rule context="fm:nachricht">
         <sch:let name="msg-prefix" value="tokenize(@name, '\.')[1]"/>
         <sch:let name="msg-prefix-norm" value="concat(lower-case(substring($msg-prefix, 1, 1)), substring($msg-prefix, 2, string-length($msg-prefix)))"/>
         <sch:let name="schema-name" value="ancestor::fm:xsdSchema/@name"/>
         <sch:let name="schema-name-norm" value="concat(lower-case(substring($schema-name, 1, 1)), substring($schema-name, 2, string-length($schema-name)))"/>
        <sch:assert role="information" id="GP-9.002" test="$msg-prefix-norm = $schema-name-norm">GP-9.002: Es wird empfohlen, Namen von Nachrichten mit einem Präfix zu versehen, das dem Namen des zugehörigen xsdSchema-Hauptgruppenpakets entspricht (Hinweis: Die Anfangsbuchstaben dürfen sich in ihrer Groß- und Kleinschreibung unterscheiden). <sch:value-of select="@name"/> entspricht der Empfehlung nicht.</sch:assert>
      </sch:rule>
   </sch:pattern>

   <sch:pattern id="pattern.GP-10.001">
      <sch:title>Nachgestellter numerischer Suffix in Namen von Nachrichten</sch:title>      
      <sch:rule context="fm:nachricht[replace(tokenize(@name, '\.')[last()], '[0-9]', '') != '']">
        <sch:assert role="information" id="GP-10.001" test="false()">GP-10.001: Es wird empfohlen, Namen von Nachrichten mit einem Suffix zu versehen, das die Nachrichtennummer repräsentiert, also ausschließlich aus Ziffern besteht. <sch:value-of select="@name"/> entspricht der Empfehlung nicht.</sch:assert>
      </sch:rule>
   </sch:pattern>

   <sch:pattern id="pattern.GP-10.002">
      <sch:title>Eindeutiger nachgestellter numerischer Suffix in Namen von Nachrichten</sch:title>      
      <sch:rule context="fm:nachricht[count(ancestor::fm:xoev-fachmodell//fm:nachricht[tokenize(current()/@name, '\.')[last()] = tokenize(@name, '\.')[last()] and lite:namespace(.) = current()/lite:namespace(.)]) > 1]">
          <sch:assert role="information" id="GP-10.002" test="false()">GP-10.002: Es wird empfohlen, eindeutige Nachrichtennummern zu vergeben. <sch:value-of select="@name"/> entspricht der Empfehlung nicht.</sch:assert>
      </sch:rule>
   </sch:pattern>

   <sch:pattern id="pattern.GP-11.001">
      <sch:title>Technischer Name des Standards am Beginn des Dateinamens einer Schema-Datei</sch:title>      
      <sch:rule context="fm:xsdSchema[not(starts-with(lower-case(@schemaFile), lower-case(ancestor::fm:xoev-fachmodell/fm:metadaten.standard/fm:nameTechnisch)))]">
          <sch:assert role="information" id="GP-11.001" test="false()">GP-11.001: Es wird empfohlen, den Namen der XML Schema-Dateien eines Standards (schemaFile) den technischen Namen des Standards (nameTechnisch) voranzustellen. <sch:value-of select="@name"/> entspricht der Empfehlung nicht.</sch:assert>
      </sch:rule>
   </sch:pattern>

    <sch:pattern id="pattern.GP-11.002">
      <sch:title>Technischer Name des Standards am Beginn der Schema-Location einer Schema-Datei</sch:title>      
      <sch:rule context="
            fm:xsdSchema[not(contains(lower-case(lite:schema-location(.)),
            lower-case(ancestor::fm:xoev-fachmodell/fm:metadaten.standard/fm:nameTechnisch)))]">
        <sch:assert role="information" id="GP-11.002" test="false()">GP-11.002: Es wird empfohlen, in der Schema Location eines XML-Schemas (schemaLocation des XML-Schemas bzw. schemaLocationBase des XÖV-Fachmodells in Verbindung mit schemaFile des XML-Schemas) den technischen Namen des Standards (nameTechnisch) aufzuführen. <sch:value-of select="@name"/> entspricht der Empfehlung nicht.</sch:assert>
      </sch:rule>
   </sch:pattern>

    <sch:pattern id="pattern.GP-12.001">
      <sch:title>Rechtsgrundlage für Nachrichten</sch:title>      
      <sch:rule context="fm:nachricht[empty(fm:rechtsgrundlage)]">
        <sch:assert role="information" id="GP-12.001" test="false()">GP-12.001: Es wird empfohlen, für Nachrichten die jeweiligen Rechtsgrundlagen zu dokumentieren. Die Nachricht <sch:value-of select="@name"/> entspricht der Empfehlung nicht.</sch:assert>
      </sch:rule>
   </sch:pattern>    
  
  <!-- WSDL - Beginn --> 
  
  <!-- Quelle XGen2: wsdlVorlagedateiZugeordnet -->
  
  <!--<sch:pattern id="pattern-WSDLVorlagedateiDerNachrichtZugeordnet">
    <sch:title>WSDL-Vorlagedatei der Nachricht zugeordnet</sch:title>
    <sch:rule context="uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[xoev:xsdMessage(.)[@wsdlVorlagedatei = 'zugeordnet' or empty(@wsdlVorlagedatei)]]">
      <sch:assert role="error" id="rule-WSDLVorlagedateiDerNachrichtZugeordnet" test="kosit:dependencies-by-supplier(.)/uml:resolve-client(.)[kosit-wsdl:wsdlService(.)]">Falls nicht explizit gekennzeichnet, müssen alle Nachrichten mindestens einem Dienst zugeordnet sein. Die Nachricht <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
    </sch:rule>
  </sch:pattern>-->
  
  <!--<sch:pattern id="pattern-WSDLVorlagedateiDerNachrichtTemporaerNichtZugeordnet">
    <sch:title>WSDL-Vorlagedatei der Nachricht zugeordnet</sch:title>
    <sch:rule context="uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[xoev:xsdMessage(.)/@wsdlVorlagedatei = 'temporaerNichtZugeordnet']">
      <sch:assert role="warning" id="rule-WSDLVorlagedateiDerNachrichtTemporaerNichtZugeordnet" test="false()">Der Nachricht <sch:value-of select="xgen:model-path(.)"/> ist eine WSDL-Vorlagedatei temporär nicht zugeordnet.</sch:assert>
    </sch:rule>
  </sch:pattern>-->
  
  <!--<sch:pattern id="pattern-WSDLVorlagedateiFalschZugeordnet">
    <sch:title>WSDL-Vorlagedatei der Nachricht zugeordnet</sch:title>
    <sch:rule context="uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[xoev:xsdMessage(.)/@wsdlVorlagedatei = ('dauerhaftNichtZugeordnet','temporaerNichtZugeordnet')]">
      <sch:assert role="error" id="rule-WSDLVorlagedateiFalschZugeordnet" test="empty(kosit:dependencies-by-supplier(.)/uml:resolve-client(.)[kosit-wsdl:wsdlService(.)])">Wenn für eine Nachricht bestimmt wurde, dass eine WSDL-Vorlage-Datei temporär oder dauerhaft nicht zuzuordnen ist, darf die Nachricht dementsprechend keinem Dienst zugeordnet sein. Die Nachricht <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
    </sch:rule>
  </sch:pattern> -->    
  
  <sch:pattern id="pattern.WSDL-2.001">
    <sch:title>Dienst mit gültigem Kommunikationsszenario</sch:title>
    <sch:rule context="fm:wsdlService[fm:Kommunikationsszenario]">
      <sch:assert role="error" id="WSDL-2.001" test="fm:Kommunikationsszenario = 'one-way-active' or fm:Kommunikationsszenario = 'one-way-passive' or fm:Kommunikationsszenario = 'request-response' or fm:Kommunikationsszenario = 'request-response-noprotocol'">WSDL-2.001: Erlaubte Kommunikationsszenarien für Dienste sind one-way-active, one-way-passive, request-response und request-response-noprotocol. Der Dienst <sch:value-of select="@name"/> verletzt diese Vorgabe.</sch:assert>
    </sch:rule>
  </sch:pattern>
  
  <!-- Quelle XGen2: passendesKommunikationsszenario -->
  <sch:pattern id="pattern.WSDL-3.001">
    <sch:title>Transportszenario mit gültigem Kommunikationsszenario</sch:title>
    <sch:rule context="fm:osciTransportScenario[fm:Kommunikationsszenario]">
      <sch:assert role="error" id="WSDL-3.001" test="fm:Kommunikationsszenario = 'one-way-active' or fm:Kommunikationsszenario = 'one-way-passive' or fm:Kommunikationsszenario = 'request-response' or fm:Kommunikationsszenario = 'request-response-noprotocol'">WSDL-3.001: Erlaubte Kommunikationsszenarien für Transportszenarien sind one-way-active, one-way-passive, request-response und request-response-noprotocol. Das OSCI-Transportszenario <sch:value-of select="@name"/> verletzt diese Vorgabe.</sch:assert>
    </sch:rule>
  </sch:pattern>
  
  <!-- Quelle XGen2: passendeSignaturInhaltsdaten -->
  <sch:pattern id="pattern.WSDL-4.001">
    <sch:title>Dienst mit gültigem Signaturlevel für Inhaltsdaten</sch:title>
    <sch:rule context="fm:wsdlService[fm:SignaturInhaltsdaten]">
      <sch:assert role="error" id="WSDL-4.001" test="fm:SignaturInhaltsdaten = 'none' or fm:SignaturInhaltsdaten = 'advanced' or fm:SignaturInhaltsdaten = 'qualified'">WSDL-4.001: Erlaubtes Signaturlevel für Inhaltsdaten ist none, advanced oder qualified. Der Dienst <sch:value-of select="@name"/> verletzt diese Vorgabe.</sch:assert>
    </sch:rule>
  </sch:pattern>
  
  <!-- Quelle XGen2: passendeSignaturInhaltsdaten -->
  <sch:pattern id="pattern.WSDL-5.001">
    <sch:title>Transportszenario mit gültigem Signaturlevel für Inhaltsdaten</sch:title>
    <sch:rule context="fm:osciTransportScenario[fm:SignaturInhaltsdaten]">
      <sch:assert role="error" id="WSDL-5.001" test="fm:SignaturInhaltsdaten = 'none' or fm:SignaturInhaltsdaten = 'advanced' or fm:SignaturInhaltsdaten = 'qualified'">WSDL-5.001: Erlaubtes Signaturlevel für Inhaltsdaten ist none, advanced oder qualified. Das OSCI-Transportszenario <sch:value-of select="@name"/> verletzt diese Vorgabe.</sch:assert>
    </sch:rule>
  </sch:pattern>
  
  <!-- Quelle XGen2: passendeSignaturNutzdaten -->
  <sch:pattern id="pattern.WSDL-6.001">
    <sch:title>Dienst mit gültigem Signaturlevel für Nutzdaten</sch:title>
    <sch:rule context="fm:wsdlService[fm:SignaturNutzdaten]">
      <sch:assert role="error" id="WSDL-6.001" test="fm:SignaturNutzdaten = 'none' or fm:SignaturNutzdaten = 'advanced' or fm:SignaturNutzdaten = 'qualified'">WSDL-6.001: Erlaubtes Signaturlevel für Nutzdaten ist none, advanced oder qualified. Der Dienst <sch:value-of select="@name"/> verletzt diese Vorgabe.</sch:assert>
    </sch:rule>
  </sch:pattern>
  
  <!-- Quelle XGen2: passendeSignaturNutzdaten -->
  <sch:pattern id="pattern.WSDL-7.001">
    <sch:title>Transportszenario mit gültigem Signaturlevel für Nutzdaten</sch:title>
    <sch:rule context="fm:osciTransportScenario[fm:SignaturNutzdaten]">
      <sch:assert role="error" id="WSDL-7.001" test="fm:SignaturNutzdaten = 'none' or fm:SignaturNutzdaten = 'advanced' or fm:SignaturNutzdaten = 'qualified'">WSDL-7.001: Erlaubtes Signaturlevel für Nutzdaten ist none, advanced oder qualified. Das OSCI-Transportszenario <sch:value-of select="@name"/> verletzt diese Vorgabe.</sch:assert>
    </sch:rule>
  </sch:pattern>
  
  <!-- Quelle XGen2: optionalerContainerBestimmt -->
  <sch:pattern id="pattern.WSDL-8.001">
    <sch:title>Nutzung optionaler Container korrekt geregelt in Dienst</sch:title>
    <sch:rule context="fm:wsdlService[fm:OptionalerContainer]">
      <sch:assert role="error" id="WSDL-8.001" test="fm:OptionalerContainer = 'true' or fm:OptionalerContainer = 'false'">WSDL-8.001: Nutzung des optionalen Containers muss geregelt sein ('true' oder 'false'). Der Dienst <sch:value-of select="@name"/> verletzt diese Vorgabe.</sch:assert>
    </sch:rule>
  </sch:pattern>
  
  <!-- Quelle XGen2: optionalerContainerBestimmt -->
  <sch:pattern id="pattern.WSDL-9.001">
    <sch:title>Nutzung optionaler Container korrekt geregelt in Transportszenario</sch:title>
    <sch:rule context="fm:osciTransportScenario[fm:OptionalerContainer]">
      <sch:assert role="error" id="WSDL-9.001" test="fm:OptionalerContainer = 'true' or fm:OptionalerContainer = 'false'">WSDL-9.001: Nutzung des optionalen Containers muss geregelt sein ('true' oder 'false'). Das OSCI-Transportszenario <sch:value-of select="@name"/> verletzt diese Vorgabe.</sch:assert>
    </sch:rule>
  </sch:pattern>
  
  <!-- Quelle XGen2: oneWayActiveMessages -->
  <sch:pattern id="pattern.WSDL-10.001">
    <sch:title>Korrekte Service Messages in one-way-active</sch:title>
    <sch:rule context="fm:wsdlService[fm:Kommunikationsszenario = 'one-way-active' or lite:all-parents(.)[fm:osciTransportScenario/fm:Kommunikationsszenario = 'one-way-active']]">
      <sch:assert role="error" id="WSDL-10.001" test="
       count(fm:wsdlServiceMessage) > 0 and not(fm:wsdlServiceInputMessage) and not(fm:wsdlServiceOutputMessage) and not(fm:wsdlServiceFaultMessage)">WSDL-10.001: One-way-active-Szenarios beziehen ausschließlich allgemeine Service-Messages ein. Der Dienst <sch:value-of select="@name"/> verletzt diese Vorgabe.</sch:assert>
    </sch:rule>
  </sch:pattern>
  
  <!-- Quelle XGen2: requestResponseMessages -->
  <sch:pattern id="pattern.WSDL-11.001">
    <sch:title>Korrekte Service Messages in request-response</sch:title>
    <sch:rule context="fm:wsdlService[fm:Kommunikationsszenario = 'request-response' or lite:all-parents(.)[fm:osciTransportScenario/fm:Kommunikationsszenario = 'request-response']]">
      <sch:assert role="error" id="WSDL-11.001" test="
        not(fm:wsdlServiceMessage) and
        count((fm:wsdlServiceInputMessage, fm:wsdlServiceOutputMessage, fm:wsdlServiceFaultMessage)) > 0">WSDL-11.001: Request-response-Szenarios beziehen ausschließlich Input- , Output- und Fault-Messages ein. Der Dienst <sch:value-of select="@name"/> verletzt diese Vorgabe.</sch:assert>
    </sch:rule>
  </sch:pattern>
  
  <!-- Quelle XGen2: unterstützteSzenarien -->
  <sch:pattern id="pattern.WSDL-12.001">
    <sch:title>Nicht unterstützte Kommumikationszenarien in Diensten</sch:title>
    <sch:rule context="fm:wsdlService[fm:Kommunikationsszenario = 'one-way-passive' or fm:wsdlService/fm:Kommunikationsszenario = 'request-response-noprotocol']">
      <sch:assert role="error" id="WSDL-12.001" test="false()">WSDL-12.001: One-way-passive und request-response-noprotocol werden noch nicht unterstützt. Der Dienst <sch:value-of select="@name"/> verletzt diese Vorgabe.</sch:assert>
    </sch:rule>
  </sch:pattern>
  
  <!-- Quelle XGen2: unterstützteSzenarien -->
  <sch:pattern id="pattern.WSDL-12.002">
    <sch:title>Nicht unterstützte Kommunikationsszenarien in Transportszenarien</sch:title>
    <sch:rule context="fm:osciTransportScenario[fm:Kommunikationsszenario = 'one-way-passive' or fm:osciTransportScenario/fm:Kommunikationsszenario = 'request-response-noprotocol']">
      <sch:assert role="error" id="WSDL-12.002" test="false()">WSDL-12.002: One-way-passive und request-response-noprotocol werden noch nicht unterstützt. Der Dienst <sch:value-of select="@name"/> verletzt diese Vorgabe.</sch:assert>
    </sch:rule>
  </sch:pattern>
  
  <!-- WSDL - Ende -->
  
</sch:schema>
