<?xml version='1.0'?>
<xsl:stylesheet  
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:d="http://docbook.org/ns/docbook"	
	xmlns:fo="http://www.w3.org/1999/XSL/Format" version="1.0">
	
	
	
	<!-- Seitenformatierung -->
	<xsl:param name="paper.type">A4</xsl:param>
	<xsl:param name="page.margin.bottom">22.0mm</xsl:param>
	<xsl:param name="page.margin.inner">25.0mm</xsl:param>
	<xsl:param name="page.margin.outer">25.0mm</xsl:param>
	<xsl:param name="page.margin.top">27.5mm</xsl:param>
	
	
	
	<!-- Listengenerierung -->
	<!-- Änderung: Keine Tabellen-, Example-, Figure- und Formelverzechnisse -->
	<xsl:param name="generate.toc">
		/appendix toc,title
		article/appendix  nop
		/article  nop
		book      toc,title
		/chapter  toc,title
		/part      toc,title
		/preface  toc,title
		reference toc,title
		/sect1    toc
		/sect2    toc
		/sect3    toc
		/sect4    toc
		/sect5    toc
		/section  toc
		set       toc,title
	</xsl:param>
	
	
	
	<!-- Formate der verschiedenen Überschriften und Abschnitte -->
	
	<!-- Schrift für normale Absätze -->
	<xsl:param name="body.font.family">Arial</xsl:param>
	<xsl:param name="body.font.master">10</xsl:param>
	
	<!-- Schriften für Überschriften -->
	<xsl:attribute-set name="chapter.titlepage.recto.style">
		<xsl:attribute name="font-size">24pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
	</xsl:attribute-set>
	
	<xsl:attribute-set name="part.titlepage.recto.style">
		<xsl:attribute name="font-size">36pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
	</xsl:attribute-set>
		
	<xsl:attribute-set name="section.title.level1.properties">
		<xsl:attribute name="font-size">14pt</xsl:attribute>
		<xsl:attribute name="font-weight">normal</xsl:attribute>
		
		<xsl:attribute name="space-before.minimum">12pt</xsl:attribute>
		<xsl:attribute name="space-before.optimum">17pt</xsl:attribute>
		<xsl:attribute name="space-before.maximum">19pt</xsl:attribute>
		
		<xsl:attribute name="space-after.minimum">4pt</xsl:attribute>
		<xsl:attribute name="space-after.optimum">6pt</xsl:attribute>
		<xsl:attribute name="space-after.maximum">10pt</xsl:attribute>
	</xsl:attribute-set>
	
	<xsl:attribute-set name="section.title.level2.properties">
		<xsl:attribute name="font-size">12pt</xsl:attribute>
		<xsl:attribute name="font-weight">normal</xsl:attribute>
		
		<xsl:attribute name="space-before.minimum">10pt</xsl:attribute>
		<xsl:attribute name="space-before.optimum">14pt</xsl:attribute>
		<xsl:attribute name="space-before.maximum">16pt</xsl:attribute>
		
		<xsl:attribute name="space-after.minimum">5pt</xsl:attribute>
		<xsl:attribute name="space-after.optimum">6pt</xsl:attribute>
		<xsl:attribute name="space-after.maximum">9pt</xsl:attribute>
	</xsl:attribute-set>
	
	<xsl:attribute-set name="section.title.level3.properties">
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="font-weight">normal</xsl:attribute>
		
		<xsl:attribute name="space-before.minimum">8pt</xsl:attribute>
		<xsl:attribute name="space-before.optimum">12pt</xsl:attribute>
		<xsl:attribute name="space-before.maximum">15pt</xsl:attribute>
		
		<xsl:attribute name="space-after.minimum">5pt</xsl:attribute>
		<xsl:attribute name="space-after.optimum">6pt</xsl:attribute>
		<xsl:attribute name="space-after.maximum">9pt</xsl:attribute>
	</xsl:attribute-set>
	
	<xsl:attribute-set name="section.title.level4.properties">
		<xsl:attribute name="font-size">9pt</xsl:attribute>
		<xsl:attribute name="font-weight">normal</xsl:attribute>
		
		<xsl:attribute name="space-before.minimum">8pt</xsl:attribute>
		<xsl:attribute name="space-before.optimum">11pt</xsl:attribute>
		<xsl:attribute name="space-before.maximum">14pt</xsl:attribute>
		
		<xsl:attribute name="space-after.minimum">5pt</xsl:attribute>
		<xsl:attribute name="space-after.optimum">6pt</xsl:attribute>
		<xsl:attribute name="space-after.maximum">9pt</xsl:attribute>
	</xsl:attribute-set>
	
	<!-- Abstand zwischen Absätzen -->
	<xsl:attribute-set name="normal.para.spacing">
		<xsl:attribute name="space-before.optimum">5pt</xsl:attribute>
		<xsl:attribute name="space-before.minimum">3pt</xsl:attribute>
		<xsl:attribute name="space-before.maximum">6pt</xsl:attribute>
	</xsl:attribute-set>
	
	<!-- Bild und Tabellentitel -->
	<xsl:attribute-set name="formal.title.properties">
		<xsl:attribute name="font-size">
			<xsl:text>10pt</xsl:text>
		</xsl:attribute>
		<xsl:attribute name="space-before.minimum">8pt</xsl:attribute>
		<xsl:attribute name="space-before.optimum">12pt</xsl:attribute>
		<xsl:attribute name="space-before.maximum">16pt</xsl:attribute>
		
		<xsl:attribute name="space-after.minimum">8pt</xsl:attribute>
		<xsl:attribute name="space-after.optimum">12pt</xsl:attribute>
		<xsl:attribute name="space-after.maximum">16pt</xsl:attribute>
	</xsl:attribute-set>
	
	<!-- Blockquote kursiv und eingerückt -->
	<xsl:attribute-set name="blockquote.properties">
		<xsl:attribute name="font-style">italic</xsl:attribute>
		<xsl:attribute name="margin-{$direction.align.start}">5mm</xsl:attribute>
		<xsl:attribute name="margin-{$direction.align.end}">5mm</xsl:attribute>
	</xsl:attribute-set>
	
	<!-- Listen -->
	<xsl:attribute-set name="list.block.properties">
		<xsl:attribute name="provisional-label-separation">0.2em</xsl:attribute>
		<xsl:attribute name="provisional-distance-between-starts">0.5em</xsl:attribute>
	</xsl:attribute-set>
	
	
	
	<!-- Header und Footer -->
	
	<!-- Header -->
	<xsl:param name="marker.section.level">1</xsl:param>
	<xsl:template name="header.content">
		<xsl:param name="pageclass" select="''"/>
		<xsl:param name="sequence" select="''"/>
		<xsl:param name="position" select="''"/>
		<xsl:param name="gentext-key" select="''"/>
		
		<fo:block>
			<xsl:choose>
				<xsl:when test="self::d:part">
				</xsl:when>
				<xsl:when test="self::d:article and $sequence = 'first'">
				</xsl:when>
				
				<xsl:when test="($double.sided = 0 or $sequence = 'odd') and $position = 'right'">
					Seite <fo:page-number/>
				</xsl:when>
				<xsl:when test="$double.sided != 0 and $sequence = 'even' and $position = 'left'">
					Seite <fo:page-number/>
				</xsl:when>
				
				<xsl:when test="$sequence = 'first' and $position = 'right'">  
					Seite <fo:page-number/>
				</xsl:when>
			</xsl:choose>
		</fo:block>
	</xsl:template>
	
	<!-- header: head.sep.rule on part and article titlepage removed -->
	<xsl:template name="head.sep.rule">
		<xsl:param name="pageclass"/>
		<xsl:param name="sequence"/>
		<xsl:param name="gentext-key"/>
	
		<xsl:if test="$header.rule != 0">
			<xsl:choose>
				<xsl:when test="self::d:part or (self::d:article and $sequence='first')">
					<!-- off -->
				</xsl:when>
				<xsl:otherwise>
					<xsl:attribute name="border-bottom-width">0.5pt</xsl:attribute>
					<xsl:attribute name="border-bottom-style">solid</xsl:attribute>
					<xsl:attribute name="border-bottom-color">black</xsl:attribute>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
	</xsl:template>
	
	<!-- Footer -->
	<xsl:template name="footer.content">
		<xsl:param name="pageclass" select="''"/>
		<xsl:param name="sequence" select="''"/>
		<xsl:param name="position" select="''"/>
		<xsl:param name="gentext-key" select="''"/>
		
		<fo:block>
			<xsl:choose>
				<!-- no footer on title pages -->
				<xsl:when test="self::d:part">
				</xsl:when>
				
				<!-- definition by cases -->
				<xsl:when test="$double.sided = 0 and $position='left'">
					<xsl:call-template name="footer.singlesided.left">
						<xsl:with-param name="pageclass" select="$pageclass"/>
					</xsl:call-template>
				</xsl:when>
				<xsl:when test="$double.sided = 0 and $position='right'">
					<xsl:call-template name="footer.singlesided.right">
						<xsl:with-param name="pageclass" select="$pageclass"/>
					</xsl:call-template>					
				</xsl:when>
				<xsl:when test="$double.sided = 0 and $position='center'">
					<xsl:call-template name="footer.singlesided.center">
						<xsl:with-param name="pageclass" select="$pageclass"/>
					</xsl:call-template>					
				</xsl:when>
				<xsl:when test="$double.sided != 0 and $sequence = 'first' and $position='left'">
					<xsl:call-template name="footer.doublesided.first.left">
						<xsl:with-param name="pageclass" select="$pageclass"/>
					</xsl:call-template>					
				</xsl:when>
				<xsl:when test="$double.sided != 0 and $sequence = 'first' and $position='right'">
					<xsl:call-template name="footer.doublesided.first.right">
						<xsl:with-param name="pageclass" select="$pageclass"/>
					</xsl:call-template>					
				</xsl:when>
				<xsl:when test="$double.sided != 0 and $sequence = 'first' and $position='center'">
					<xsl:call-template name="footer.doublesided.first.center">
						<xsl:with-param name="pageclass" select="$pageclass"/>
					</xsl:call-template>
				</xsl:when>
				<xsl:when test="$double.sided != 0 and $sequence = 'odd' and $position='left'">
					<xsl:call-template name="footer.doublesided.odd.left">
						<xsl:with-param name="pageclass" select="$pageclass"/>
					</xsl:call-template>		
				</xsl:when>
				<xsl:when test="$double.sided != 0 and $sequence = 'odd' and $position='right'">
					<xsl:call-template name="footer.doublesided.odd.right">
						<xsl:with-param name="pageclass" select="$pageclass"/>
					</xsl:call-template>					
				</xsl:when>
				<xsl:when test="$double.sided != 0 and $sequence = 'odd' and $position='center'">
					<xsl:call-template name="footer.doublesided.odd.center">
						<xsl:with-param name="pageclass" select="$pageclass"/>
					</xsl:call-template>					
				</xsl:when>
				<xsl:when test="$double.sided != 0 and $sequence = 'even' and $position='left'">
					<xsl:call-template name="footer.doublesided.even.left">
						<xsl:with-param name="pageclass" select="$pageclass"/>
					</xsl:call-template>					
				</xsl:when>
				<xsl:when test="$double.sided != 0 and $sequence = 'even' and $position='right'">
					<xsl:call-template name="footer.doublesided.even.right">
						<xsl:with-param name="pageclass" select="$pageclass"/>
					</xsl:call-template>					
				</xsl:when>
				<xsl:when test="$double.sided != 0 and $sequence = 'even' and $position='center'">
					<xsl:call-template name="footer.doublesided.even.center">
						<xsl:with-param name="pageclass" select="$pageclass"/>
					</xsl:call-template>					
				</xsl:when>
			</xsl:choose>
		</fo:block>
	</xsl:template>
	
	<xsl:template name="footer.singlesided.left">
		<xsl:param name="pageclass" select="''"/>
		<xsl:apply-templates select="." mode="title.markup"/>
	</xsl:template>
	
	<xsl:template name="footer.singlesided.right">
		<xsl:param name="pageclass" select="''"/>
		<xsl:value-of select="ancestor-or-self::*[@revision][1]/@revision"/> / <xsl:value-of select="ancestor-or-self::*[@status][1]/@status"/>
	</xsl:template>
	
	<xsl:template name="footer.singlesided.center">
		<xsl:param name="pageclass" select="''"/>
		<xsl:text>© Koordinierungsstelle für IT-Standards, Bremen</xsl:text>		
	</xsl:template>
	
	<xsl:template name="footer.doublesided.first.left">
		<xsl:param name="pageclass" select="''"/>
		<!-- No title on title page -->
	</xsl:template>
	
	<xsl:template name="footer.doublesided.first.right">
		<xsl:param name="pageclass" select="''"/>
		<xsl:call-template name="footer.singlesided.right">
			<xsl:with-param name="pageclass" select="$pageclass"/>
		</xsl:call-template>
	</xsl:template>
	
	<xsl:template name="footer.doublesided.first.center">
		<xsl:param name="pageclass" select="''"/>
		<xsl:call-template name="footer.singlesided.center">
			<xsl:with-param name="pageclass" select="$pageclass"/>
		</xsl:call-template>
	</xsl:template>
	
	<xsl:template name="footer.doublesided.odd.left">
		<xsl:param name="pageclass" select="''"/>
		<xsl:apply-templates select="." mode="title.markup"/>
	</xsl:template>
	
	<xsl:template name="footer.doublesided.odd.right">
		<xsl:param name="pageclass" select="''"/>
		<xsl:call-template name="footer.singlesided.right">
			<xsl:with-param name="pageclass" select="$pageclass"/>
		</xsl:call-template>
	</xsl:template>
	
	<xsl:template name="footer.doublesided.odd.center">
		<xsl:param name="pageclass" select="''"/>
		<xsl:call-template name="footer.singlesided.center">
			<xsl:with-param name="pageclass" select="$pageclass"/>
		</xsl:call-template>
	</xsl:template>
	
	<xsl:template name="footer.doublesided.even.left">
		<xsl:param name="pageclass" select="''"/>
		<xsl:call-template name="footer.singlesided.right">
			<xsl:with-param name="pageclass" select="$pageclass"/>
		</xsl:call-template>
	</xsl:template>
	
	<xsl:template name="footer.doublesided.even.right">
		<xsl:param name="pageclass" select="''"/>
		<xsl:call-template name="footer.singlesided.left">
			<xsl:with-param name="pageclass" select="$pageclass"/>
		</xsl:call-template>
	</xsl:template>
	
	<xsl:template name="footer.doublesided.even.center">
		<xsl:param name="pageclass" select="''"/>
		<xsl:call-template name="footer.singlesided.center">
			<xsl:with-param name="pageclass" select="$pageclass"/>
		</xsl:call-template>
	</xsl:template>
	
	<!-- footer: foot.sep.rule on part titlepage removed -->
	<xsl:template name="foot.sep.rule">
		<xsl:param name="pageclass"/>
		<xsl:param name="sequence"/>
		<xsl:param name="gentext-key"/>
	
		<xsl:if test="$footer.rule != 0">
			<xsl:choose>
				<xsl:when test="self::d:part">
					<!-- off -->
				</xsl:when>
				<xsl:otherwise>
					<xsl:attribute name="border-top-width">0.5pt</xsl:attribute>
					<xsl:attribute name="border-top-style">solid</xsl:attribute>
					<xsl:attribute name="border-top-color">black</xsl:attribute>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
	</xsl:template>
	
	<!-- Breite der einzelnen Regionen im Footer anpassen -->
	<xsl:param name="footer.column.widths">2 3 2</xsl:param>
	
	<!-- Style des Footers anpassen -->
	<xsl:attribute-set name="footer.content.properties">
		<xsl:attribute name="font-size">6pt</xsl:attribute>
	</xsl:attribute-set>
    
    <!-- Allow for specific alignment of a paragraph. --> 
    <xsl:template match="d:para[@role='left-aligned']">
        <fo:block text-align="left">
            <xsl:apply-templates/>
        </fo:block>
    </xsl:template>
	
</xsl:stylesheet>