<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xmi="http://www.omg.org/spec/XMI/20131001" xmlns:xgen="http://www.xoev.de/de/xgenerator/framework/1/library" xmlns:xoev="urn:xoev-de:kosit:xoev:classic:transformation_4.2.0" xmlns:xoev-profil="urn:xoev-de:kosit:xoev:classic:access-layer:xoev-profil_4.2.0" xmlns:uml="http://www.eclipse.org/uml2/5.0.0/UML" xmlns:xd="http://www.oxygenxml.com/ns/doc/xsl" version="3.0" exclude-result-prefixes="xsl xmi xgen xoev uml xd">

    <xsl:function name="xoev:is-ref" as="xs:boolean">
        <xsl:param name="property" as="element()"/>
        <xsl:sequence select="
                if ($xoev:my-xmodel/xoev-profil:xsdXModel(.)[@standardreferenzstil = 'Stereotyp']) then
                    $property/(xoev-profil:xsdElement(.), xoev-profil:xsdAttribute(.))/@isRef = 'true'
                else
                    not(empty($property/uml:resolve-type(.)[
                    xoev-profil:xsdGlobalElement(.) or xoev-profil:xsdGlobalAttribute(.) or xoev-profil:xsdMessage(.) or xoev-profil:xsdGroup(.) or
                    xoev-profil:xsdGlobalElementAndNamedType(.) and ($xoev:my-xmodel/xoev-profil:xsdXModel(.)[@standardreferenzstil = 'Element' or empty(@standardreferenzstil)])]))"/>
    </xsl:function>

    <xsl:function name="xoev:get-language" as="xs:string?">
        <xsl:param name="value" as="xs:string"/>
        <xsl:if test="matches($value, '^\[[a-z]{2}-[A-Z]{2}\].*$')">
            <xsl:value-of select="substring-before(substring-after($value, '['), ']')"/>
        </xsl:if>
    </xsl:function>

    <xsl:function name="xoev:metadatenwert" as="xs:string?">
        <xsl:param name="elem" as="element()?"/>
        <xsl:choose>
            <xsl:when test="$elem/xoev:get-language(.) != ''">
                <xsl:value-of select="substring-after($elem, ']')"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="$elem"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:function>

    <xsl:template match="element()" mode="xoev:metadatenwert">
        <xsl:param name="clean" as="xs:boolean" required="no">false</xsl:param>
        <xsl:variable name="text" select="
                if ($clean) then
                    xoev:clean-text(.)
                else
                    ."/>
        <xsl:choose>
            <xsl:when test="xoev:get-language(.) != ''">
                <xsl:value-of select="substring-after($text, ']')"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="$text"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:function name="xoev:genutzte-sprache" as="xs:string">
        <xsl:param name="element" as="element()"/>
        <xsl:value-of select="($element/ancestor::packagedElement/xoev-profil:xoevGenutzteSprache(.)/@sprache, 'de-DE')[1]"/>
    </xsl:function>

    <xsl:function name="xoev:metadatenelement-in-genutzter-sprache" as="element()?">
        <xsl:param name="elemente" as="element()*"/>
        <xsl:param name="kontext" as="element()"/>
        <xsl:sequence select="
                ($elemente[empty(xoev:get-language(.))],
                $elemente[xoev:get-language(.) = xoev:genutzte-sprache($kontext)],
                $elemente[xoev:get-language(.) = 'de-DE'])[1]"/>
    </xsl:function>

    <xsl:function name="xoev:global-element-name" as="xs:string">
        <xsl:param name="element" as="element()"/>
        <xsl:choose>
            <xsl:when test="$element[xoev-profil:xsdGlobalElement(.) or xoev-profil:xsdGlobalElementAndNamedType(.)]">
                <xsl:sequence select="concat(($element/ancestor::packagedElement/xoev-profil:xsdXModel(.)/@xsdGlobalElementNamePrefix, '')[1], $element/@name, ($element/ancestor::packagedElement/xoev-profil:xsdXModel(.)/@xsdGlobalElementNameSuffix, '')[1])"/>
            </xsl:when>
            <xsl:otherwise>
                <!-- xsdMessage, xsdGlobalAttribute -->
                <xsl:sequence select="$element/@name"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:function>

    <xsl:function name="xoev:type-name" as="xs:string">
        <xsl:param name="type" as="element()"/>
        <xsl:choose>
            <xsl:when test="$type[xoev-profil:xsdNamedType(.) or xoev-profil:xsdGlobalElementAndNamedType(.)]">
                <xsl:sequence select="concat(($type/ancestor::packagedElement/xoev-profil:xsdXModel(.)/@xsdNamedTypeNamePrefix, '')[1], $type/@name, ($type/ancestor::packagedElement/xoev-profil:xsdXModel(.)/@xsdNamedTypeNameSuffix, '')[1])"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:sequence select="$type/@name"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:function>

    <xd:doc>
        <xd:desc>Key zur Ermittlung der Menge von Dependencies, in denen die angegebene ID als client fungiert, es sich also um ein abhängiges Element handelt.</xd:desc>
    </xd:doc>
    <!-- Implementierungshinweis: Anstelle von uml:is-Dependeny wird hier bewusst die Definition direkt eingefügt, da Saxon-HE 
         dies im Rahmen der Optimierung nicht tut und der Profiler gezeigt hat, dass dies hier ein Performance-Hotspot ist. -->
    <xsl:key name="xoev:dependency-by-client" match="packagedElement[@xmi:type = 'uml:Dependency']" use="@client"/>
    <xsl:function name="xoev:dependencies-by-client" as="element()*">
        <xsl:param name="element" as="element()"/>
        <xsl:sequence select="key('xoev:dependency-by-client', $element/@xmi:id, root($element))"/>
    </xsl:function>

    <xsl:key name="xoev:dependency-by-supplier" match="packagedElement[@xmi:type = 'uml:Dependency']" use="@supplier"/>
    <xsl:function name="xoev:dependencies-by-supplier" as="element()*">
        <xsl:param name="element" as="element()"/>
        <xsl:sequence select="key('xoev:dependency-by-supplier', $element/@xmi:id, root($element))"/>
    </xsl:function>

    <xsl:key name="xoev:usage-by-client" match="packagedElement[@xmi:type = 'uml:Usage']" use="@client"/>
    <xsl:function name="xoev:usages-by-client" as="element()*">
        <xsl:param name="element" as="element()"/>
        <xsl:sequence select="key('xoev:usage-by-client', $element/@xmi:id, root($element))"/>
    </xsl:function>

    <xsl:key name="xoev:usage-by-supplier" match="packagedElement[@xmi:type = 'uml:Usage']" use="@supplier"/>
    <xsl:function name="xoev:usages-by-supplier" as="element()*">
        <xsl:param name="element" as="element()"/>
        <xsl:sequence select="key('xoev:usage-by-supplier', $element/@xmi:id, root($element))"/>
    </xsl:function>

    <xsl:function name="xoev:resolve-base" as="element()*">
        <xsl:param name="element-with-base" as="element()?"/>
        <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-base/@base, $element-with-base/base)"/>
    </xsl:function>

    <xsl:function name="xoev:resolve-typDesCodeElements" as="element()*">
        <xsl:param name="element-with-typDesCodeElements" as="element()?"/>
        <xsl:sequence select="xgen:resolve-ids-or-hrefs($element-with-typDesCodeElements/@typDesCodeElements, $element-with-typDesCodeElements/typDesCodeElements)"/>
    </xsl:function>

    <xsl:function name="xoev:position" as="xs:integer">
        <xsl:param name="property" as="element()"/>
        <xsl:sequence select="(xs:integer($property/(xoev-profil:xsdElement(.), xoev-profil:xsdLocalStructure(.))/@position), count($property/preceding-sibling::ownedAttribute[xoev:is-element(.) or xoev-profil:xsdLocalStructure(.)]) + 1)[1]"/>
    </xsl:function>

    <xsl:function name="xoev:is-element" as="xs:boolean">
        <xsl:param name="property" as="element()"/>
        <xsl:sequence select="
                if ($xoev:my-xmodel/xoev-profil:xsdXModel(.)/@standardeinstellungEigenschaften = 'keine') then
                    not(empty($property[xoev-profil:xsdElement(.)]))
                else
                    empty($property[xoev-profil:xsdAttribute(.) or xoev-profil:xsdLocalStructure(.) or ../xoev-profil:xoevVersionCodeliste(.) or ancestor::packagedElement/xoev-profil:xoevAdapter(.) or not(../uml:is-Class(.))])"/>
    </xsl:function>

    <xsl:function name="xoev:ids-to-elements" as="element()*">
        <xsl:param name="ids" as="xs:string*"/>
        <xsl:param name="root"/>
        <xsl:for-each select="$ids">
            <xsl:sequence select="xgen:safe-key('uml:_element-by-id', ., $root)"/>
        </xsl:for-each>
    </xsl:function>

    <xsl:key name="xoev:enumeration-by-name" match="packagedElement | nestedClassifier" use="@name"/>
    <xsl:function name="xoev:enumeration-by-name" as="element()*">
        <xsl:param name="name"/>
        <xsl:param name="context" as="node()"/>
        <xsl:sequence select="key('xoev:enumeration-by-name', $name, $context)"/>
    </xsl:function>

    <xsl:key name="xoev:code-by-uri" match="packagedElement | nestedClassifier" use="ownedAttribute[@name = 'listURI']/(defaultValue/@value, defaultValue/body)[1]"/>
    <xsl:function name="xoev:code-by-uri" as="element()*">
        <xsl:param name="uri"/>
        <xsl:param name="context" as="node()"/>
        <xsl:sequence select="key('xoev:code-by-uri', $uri, root($context))"/>
    </xsl:function>

    <xsl:key name="xoev:codelist-by-uri" match="packagedElement | nestedClassifier" use="xoev-profil:xoevCodeliste(.)/@kennung"/>
    <xsl:function name="xoev:codelist-by-uri" as="element()*">
        <xsl:param name="uri"/>
        <xsl:param name="context" as="node()"/>
        <xsl:sequence select="key('xoev:codelist-by-uri', $uri, root($context))"/>
    </xsl:function>

    <xsl:function name="xoev:getNamespace" as="xs:string?">
        <xsl:param name="element" as="element()"/>
        <xsl:sequence select="($element/ancestor-or-self::packagedElement/xoev-profil:xsdSchema(.)/@namespace, $element/ancestor-or-self::packagedElement/xoev-profil:xsdXModel(.)/@namespace)[1]"/>
    </xsl:function>

    <xsl:function name="xoev:getPrefix" as="xs:string?">
        <xsl:param name="element" as="element()"/>
        <xsl:sequence select="($element/ancestor-or-self::packagedElement/xoev-profil:xsdSchema(.)/@prefix, $element/ancestor-or-self::packagedElement/xoev-profil:xsdXModel(.)/@prefix)[1]"/>
    </xsl:function>

    <xd:doc>
        <xd:desc>Das eigene xsdXModel-Modell. Dieses entspricht dem (einzigen) xsdXModel-Modell, das außerhalb des Pakets 'Externe Modelle' vorliegt. Prüfanweisungen stellen sicher, dass genau ein xsdXModel-Modell auf dieser Ebene vorliegt.</xd:desc>
    </xd:doc>
    <xsl:variable name="xoev:my-xmodel" as="element(packagedElement)">
        <!-- [1] für den Fall, dass mehr als ein xsdXModel auf oberster Ebene existiert. Es soll kein XSLT-Fehler auftreten. Prüfanweisung fängt diesen Fall ab. -->
        <xsl:sequence select="$uml:root-model/packagedElement[xoev-profil:xsdXModel(.)][1]"/>
    </xsl:variable>

    <xsl:function name="xoev:isReferenceableByName" as="xs:boolean">
        <xsl:param name="type" as="element()"/>
        <xsl:sequence select="$type/parent::packagedElement/@name = 'W3C Data Types' or xoev-profil:xsdNamedType($type) or xoev-profil:xsdGlobalElementAndNamedType($type)"/>
    </xsl:function>

    <xsl:function name="xoev:lowerBound" as="xs:integer">
        <xsl:param name="property" as="element()"/>
        <xsl:choose>
            <xsl:when test="$property/lowerValue/@value = 1 or not($property/lowerValue)">1</xsl:when>
            <xsl:when test="$property/lowerValue and not($property/lowerValue/@value)">0</xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="$property/lowerValue/@value"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:function>

    <xsl:function name="xoev:upperBound" as="xs:integer">
        <xsl:param name="property" as="element()"/>
        <xsl:choose>
            <xsl:when test="$property/upperValue/@value = '*'">-1</xsl:when>
            <xsl:when test="$property/upperValue/@value = '1' or not($property/upperValue)">1</xsl:when>
            <xsl:when test="$property/upperValue and not($property/upperValue/@value)">0</xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="$property/upperValue/@value"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:function>

    <xsl:function name="xoev:allParents" as="element()*">
        <xsl:param name="class" as="element()"/>
        <xsl:for-each select="$class/generalization/uml:resolve-general(.)">
            <xsl:sequence select="."/>
            <xsl:sequence select="xoev:allParents(.)"/>
        </xsl:for-each>
    </xsl:function>

    <xsl:function name="xoev:allExtendedParents" as="element()*">
        <xsl:param name="class" as="element()"/>
        <xsl:for-each select="$class/generalization[not(xoev-profil:xsdRestriction(.))]/uml:resolve-general(.)">
            <xsl:sequence select="."/>
            <xsl:sequence select="xoev:allExtendedParents(.)"/>
        </xsl:for-each>
    </xsl:function>

    <xsl:function name="xoev:allRestrictionParents" as="element()*">
        <xsl:param name="class" as="element()"/>
        <xsl:for-each select="$class/generalization[xoev-profil:xsdRestriction(.)]/uml:resolve-general(.)">
            <xsl:sequence select="."/>
            <xsl:sequence select="xoev:allRestrictionParents(.)"/>
        </xsl:for-each>
    </xsl:function>

    <xsl:function name="xoev:getDuplicateStrings" as="xs:string*">
        <xsl:param name="seq" as="xs:string*"/>
        <xsl:for-each select="$seq[index-of($seq, .)[2]]">
            <xsl:sequence select="."/>
        </xsl:for-each>
    </xsl:function>

    <xsl:function name="xoev:allElementNamesIncludingRefsAndGroups" as="xs:string*">
        <xsl:param name="class" as="element()"/>
        <xsl:for-each select="xoev:allElements($class)">
            <xsl:choose>
                <xsl:when test="xoev:is-ref(.) and uml:resolve-type(.)[xoev-profil:xsdGroup(.)]">
                    <xsl:sequence select="xoev:allElementNamesIncludingRefsAndGroups(uml:resolve-type(.))"/>
                </xsl:when>
                <xsl:when test="xoev:is-ref(.) and uml:resolve-type(.)[xoev-profil:xsdMessage(.) or xoev-profil:xsdGlobalElement(.) or xoev-profil:xsdGlobalElementAndNamedType(.)]">
                    <xsl:sequence select="uml:resolve-type(.)/xoev:global-element-name(.)"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:sequence select="@name"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:for-each>
    </xsl:function>

    <xsl:function name="xoev:allElements" as="element()*">
        <xsl:param name="class" as="element()"/>
        <xsl:for-each select="$class/generalization[not(xoev-profil:xsdRestriction(.))]/uml:resolve-general(.)">
            <xsl:sequence select="xoev:allElements(.)"/>
        </xsl:for-each>
        <xsl:sequence select="xoev:elements($class)"/>
    </xsl:function>

    <xsl:function name="xoev:allAttributes" as="element()*">
        <xsl:param name="class" as="element()"/>
        <xsl:sequence select="xoev:attributes($class)"/>
        <xsl:for-each select="$class/generalization[not(xoev-profil:xsdRestriction(.))]/uml:resolve-general(.)">
            <xsl:sequence select="xoev:allAttributes(.)"/>
        </xsl:for-each>
    </xsl:function>

    <xsl:function name="xoev:attributes" as="element()*">
        <xsl:param name="class" as="element()"/>
        <xsl:for-each select="$class/ownedAttribute[xoev-profil:xsdAttribute(.)]">
            <xsl:sort select="@name"/>
            <xsl:sequence select="."/>
        </xsl:for-each>
    </xsl:function>

    <xsl:function name="xoev:elements" as="element()*">
        <xsl:param name="class" as="element()"/>
        <xsl:for-each select="$class/ownedAttribute[xoev:is-element(.) or xoev-profil:xsdLocalStructure(.)]">
            <xsl:sort select="xoev:position(.)"/>
            <xsl:sequence select="."/>
        </xsl:for-each>
    </xsl:function>

    <xsl:function name="xoev:getRealPosition" as="xs:integer">
        <xsl:param name="name" as="xs:string" required="yes"/>
        <xsl:param name="class" as="element()" required="yes"/>
        <xsl:choose>
            <xsl:when test="$name = $class/xoev:elements(.)/@name">
                <xsl:value-of select="
                        count(
                        $class/xoev:elements(.)[
                        xoev:position(.) le number($class/xoev:elements(.)[@name = $name]/xoev:position(.))]) +
                        count($class/generalization[not(xoev-profil:xsdRestriction(.))]/uml:resolve-general(.)/xoev:allElements(.))"/>
            </xsl:when>
            <xsl:when test="$class/generalization[not(xoev-profil:xsdRestriction(.))]">
                <xsl:value-of select="xoev:getRealPosition($name, $class/generalization/uml:resolve-general(.))"/>
            </xsl:when>
            <xsl:otherwise>0</xsl:otherwise>
        </xsl:choose>
    </xsl:function>

    <xsl:function name="xoev:sortAndConcatForXMLRestriktionMitKorrekterElementenreihenfolge" as="xs:string*">
        <xsl:param name="class" as="element()" required="yes"/>
        <xsl:for-each select="$class/xoev:allElements(.)">
            <xsl:value-of select="
                    concat(codepoints-to-string(10), 'Position ', position(), ' in Elementsequenz: ', (if (xoev:is-ref(.)) then
                        uml:resolve-type(.)/xoev:global-element-name(.)
                    else
                        @name), if (position() = last()) then
                        codepoints-to-string(10)
                    else
                        '')"/>
        </xsl:for-each>
    </xsl:function>

    <xsl:function name="xoev:qualified-type-name" as="xs:string">
        <!-- Typ, für den der qualifizierte Name ermittelt werden soll. -->
        <xsl:param name="type"/>
        <!-- Kontext (z. B. Element oder Typ), in dem der Typ (type) genutzt werden soll. -->
        <xsl:param name="referringContext" as="element()"/>
        <xsl:param name="is-ref" as="xs:boolean"/>
        <xsl:variable name="prefix">
            <xsl:choose>
                <xsl:when test="$type/parent::packagedElement/@name = 'W3C Data Types'">xs</xsl:when>
                <xsl:otherwise>
                    <xsl:variable name="referringSchema" as="element()" select="$referringContext/ancestor::packagedElement[xoev-profil:xsdSchema(.)][1]"/>
                    <xsl:variable name="typeSchema" as="element()?" select="$type/ancestor::packagedElement[xoev-profil:xsdSchema(.)]"/>
                    <xsl:choose>
                        <xsl:when test="$typeSchema">
                            <xsl:variable name="include" select="xoev:package-with-imports-and-includes($referringSchema)/include[@id = $typeSchema/@xmi:id]" as="element(include)+"/>
                            <!-- Im Falle eines Mehrfach-Imports wird das erste import-Element genutzt. -->
                            <xsl:variable name="import" select="xoev:package-with-imports-and-includes($referringSchema)/import[@id = $typeSchema/@xmi:id][1]" as="element(import)?"/>
                            <xsl:choose>
                                <xsl:when test="$typeSchema/@xmi:id = $referringSchema/@xmi:id or $include">
                                    <xsl:value-of select="xoev:getPrefix($typeSchema)"/>
                                </xsl:when>
                                <xsl:when test="$import">
                                    <xsl:value-of select="$import/@prefix"/>
                                </xsl:when>
                                <xsl:otherwise>
                                    <xsl:message terminate="yes">Assertion failed: Could not determine namespace prefix for type <xsl:value-of select="
                                                $type/(if ($is-ref) then
                                                    xoev:global-element-name(.)
                                                else
                                                    xoev:type-name(.))"/> in context of referring Schema <xsl:value-of select="$referringSchema/@name"/>.</xsl:message>
                                </xsl:otherwise>
                            </xsl:choose>
                        </xsl:when>
                        <xsl:otherwise/>
                    </xsl:choose>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <xsl:value-of select="
                concat($prefix, ':', $type/(if ($is-ref) then
                    xoev:global-element-name(.)
                else
                    xoev:type-name(.)))"/>
    </xsl:function>

    <xsl:function name="xoev:qualified-prefix" as="xs:string">
        <xsl:param name="schema"/>
        <xsl:param name="referringContext" as="element()"/>
        <xsl:variable name="referringSchema" as="element()" select="$referringContext/ancestor::packagedElement[xoev-profil:xsdSchema(.)][1]"/>
        <xsl:variable name="include" select="xoev:package-with-imports-and-includes($referringSchema)/include[@id = $schema/@xmi:id]" as="element(include)+"/>
        <!-- Im Falle eines Mehrfach-Imports wird das erste import-Element genutzt. -->
        <xsl:variable name="import" select="xoev:package-with-imports-and-includes($referringSchema)/import[@id = $schema/@xmi:id][1]" as="element(import)?"/>
        <xsl:choose>
            <xsl:when test="$schema/@xmi:id = $referringSchema/@xmi:id or $include">
                <xsl:value-of select="xoev:getPrefix($schema)"/>
            </xsl:when>
            <xsl:when test="$import">
                <xsl:value-of select="$import/@prefix"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:message terminate="yes">Assertion failed: Could not determine namespace prefix for schema <xsl:value-of select="$schema/@name"/> in context of referring Schema <xsl:value-of select="$referringSchema/@name"/>.</xsl:message>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:function>


    <xsl:function name="xoev:topmost-parent" as="element()">
        <xsl:param name="class" as="element()"/>
        <xsl:choose>
            <!-- $class/generalization[1] anstelle von $class/generalization, damit kein Fehler bei Klassen mit mehr als einer ausgehenden Generalisierung
                 auftritt. Prüfanweisung NDR-28-ValideW3CXMLSchemaDefinitionen-EinfacheVererbung stellt sicher, dass Validierung zum error führt. -->
            <xsl:when test="$class/generalization">
                <xsl:sequence select="xoev:topmost-parent($class/generalization[1]/uml:resolve-general(.))"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:sequence select="$class"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:function>

    <xsl:function name="xoev:clean-text" as="xs:string">
        <xsl:param name="string"/>
        <xsl:value-of select="normalize-space(replace(replace(replace(replace($string, 
            '&lt;[^&lt;!][^&lt;]+[^-]&gt;', ''),
            '&amp;ndash;','-'),
            '&amp;([^;]+);', '$1'),
            '&lt;!--[^&gt;]*--&gt;',''))"/>
    </xsl:function>

    <xsl:function name="xoev:used-schema-packages" as="element(packagedElement)*">
        <xsl:param name="package" as="element(packagedElement)"/>
        <xsl:for-each select="
                $uml:root-model//packagedElement[
                xoev-profil:xsdSchema(.) and @xmi:id != $package/@xmi:id and
                ($package//(ownedAttribute[xoev:is-element(.) or xoev-profil:xsdAttribute(.)]/uml:resolve-type(.), (packagedElement, nestedClassifier)[uml:is-Class(.)]/generalization/uml:resolve-general(.),
                (packagedElement, nestedClassifier)[xoev-profil:xsdGlobalElement(.) or xoev-profil:xsdGlobalAttribute(.)]/xoev:dependencies-by-client(.)[
                xoev-profil:xsdGlobalElementType(.) or xoev-profil:xsdGlobalAttributeType(.)]/uml:resolve-supplier(.))
                [xoev-profil:xsdNamedType(.) or xoev-profil:xsdGlobalElementAndNamedType(.) or xoev-profil:xsdGlobalElement(.) or xoev-profil:xsdMessage(.)])/ancestor::packagedElement/@xmi:id = @xmi:id],
                $uml:root-model/descendant::packagedElement[
                xoev-profil:xsdSchema(.) and descendant::packagedElement/xoev-profil:xoevDatentyp(.)/@kennung = 'urn:xoev-de:kosit:xoev:datentyp:code'
                and $package//packagedElement[uml:is-Class(.) and xoev-profil:xoevCodeTyp4(.) or xoev:usages-by-client(.)/uml:resolve-supplier(.)[xoev-profil:xoevCodeliste(.) or xoev-profil:xoevVersionCodeliste(.)]]]">
            <xsl:sequence select="."/>
        </xsl:for-each>
    </xsl:function>

    <xsl:variable name="xoev:implicit-and-explicit-package-include" as="element(xoev:package-include)">
        <xoev:package-include>
            <xsl:for-each select="$uml:root-model//packagedElement[xoev-profil:xsdSchema(.)]">
                <xsl:sort select="@name"/>
                <xsl:variable name="package" select="."/>
                <xsl:variable name="explicitly-included-packages" select="xoev:dependencies-by-client($package)[xoev-profil:xsdInclude(.)]/uml:resolve-supplier(.)"/>
                <xsl:for-each select="
                        xoev:used-schema-packages(.)[xoev:getNamespace(.) = xoev:getNamespace($package) and not(@xmi:id = $explicitly-included-packages/@xmi:id)],
                        $explicitly-included-packages">
                    <xsl:sort select="xoev-profil:xsdSchema(.)/@schemaFile"/>
                    <xoev:include>
                        <xoev:including schemaFile="{$package/xoev-profil:xsdSchema(.)/@schemaFile}" id="{$package/@xmi:id}"/>
                        <xoev:included schemaFile="{xoev-profil:xsdSchema(.)/@schemaFile}" id="{@xmi:id}"/>
                    </xoev:include>
                </xsl:for-each>
            </xsl:for-each>
        </xoev:package-include>
    </xsl:variable>

    <xsl:variable name="xoev:implicit-and-explicit-package-import" as="element(xoev:package-import)">
        <xoev:package-import>
            <xsl:for-each select="$uml:root-model//packagedElement[xoev-profil:xsdSchema(.)]">
                <xsl:sort select="@name"/>
                <xsl:variable name="package" select="."/>
                <xsl:variable name="explicitly-imported-packages" select="xoev:dependencies-by-client($package)[xoev-profil:xsdImport(.)]/uml:resolve-supplier(.)"/>
                <xsl:for-each select="
                        xoev:used-schema-packages(.)[xoev:getNamespace(.) != xoev:getNamespace($package) and not(@xmi:id = $explicitly-imported-packages/@xmi:id)],
                        $explicitly-imported-packages">
                    <xsl:sort select="xoev-profil:xsdSchema(.)/@schemaFile"/>
                    <xoev:import>
                        <xoev:importing schemaFile="{$package/xoev-profil:xsdSchema(.)/@schemaFile}" id="{$package/@xmi:id}"/>
                        <xoev:imported schemaFile="{xoev-profil:xsdSchema(.)/@schemaFile}" id="{@xmi:id}"/>
                    </xoev:import>
                </xsl:for-each>
            </xsl:for-each>
        </xoev:package-import>
    </xsl:variable>

    <xsl:function name="xoev:implicit-and-explicit-package-include-closure" as="element(xoev:package-include)">
        <xsl:param name="package-include" as="element(xoev:package-include)"/>
        <xsl:variable name="new">
            <xsl:for-each select="$package-include//*:including">
                <xsl:variable name="A" select="."/>
                <xsl:for-each select="$package-include//*:include[*:including/@id = $A/@id]/*:included">
                    <xsl:variable name="B" select="."/>
                    <xsl:for-each select="$package-include//*:include[*:including/@id = $B/@id]/*:included">
                        <xsl:variable name="C" select="."/>
                        <xsl:if test="empty($package-include//*:include[*:including/@id = $A/@id and *:included/@id = $C/@id])">
                            <xoev:include>
                                <xoev:including schemaFile="{$A/@schemaFile}" id="{$A/@id}"/>
                                <xoev:included schemaFile="{$C/@schemaFile}" id="{$C/@id}"/>
                            </xoev:include>
                        </xsl:if>
                    </xsl:for-each>
                </xsl:for-each>
            </xsl:for-each>
        </xsl:variable>
        <xsl:choose>
            <xsl:when test="empty($new//xoev:include)">
                <xsl:sequence select="$package-include"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:variable name="next">
                    <xoev:package-include>
                        <xsl:copy-of select="$package-include//*:include"/>
                        <xsl:sequence select="$new"/>
                    </xoev:package-include>
                </xsl:variable>
                <xsl:sequence select="xoev:implicit-and-explicit-package-include-closure($next/xoev:package-include)"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:function>
    <xsl:variable name="xoev:implicit-and-explicit-package-include-closure" select="xoev:implicit-and-explicit-package-include-closure($xoev:implicit-and-explicit-package-include)"/>

    <xsl:variable name="xoev:direct-implicit-and-explicit-package-include" as="element(xoev:direct-package-include)">
        <xoev:direct-package-include>
            <xsl:variable name="includes" select="$xoev:implicit-and-explicit-package-include-closure"/>
            <xsl:for-each select="$includes//xoev:include">
                <xsl:variable name="A" select="xoev:including"/>
                <xsl:variable name="C" select="xoev:included"/>
                <xsl:if test="
                        not(
                        some $i in $includes//@id
                            satisfies (
                            $includes//xoev:include[xoev:including/@id = $A/@id and xoev:included/@id = $i] and
                            $includes//xoev:include[xoev:including/@id = $i and xoev:included/@id = $C/@id]))">
                    <xsl:copy-of select="."/>
                </xsl:if>
            </xsl:for-each>
        </xoev:direct-package-include>
    </xsl:variable>

    <xsl:variable name="xoev:direct-implicit-and-explicit-package-import" as="element(xoev:direct-package-import)">
        <xoev:direct-package-import>
            <xsl:for-each select="$xoev:implicit-and-explicit-package-import//xoev:import">
                <xsl:variable name="A" select="xoev:importing"/>
                <xsl:variable name="C" select="xoev:imported"/>
                <xsl:if test="
                        not(
                        some $i in $xoev:implicit-and-explicit-package-import//@id
                            satisfies (
                            $xoev:implicit-and-explicit-package-import//xoev:import[xoev:importing/@id = $A/@id and xoev:imported/@id = $i] and
                            $xoev:implicit-and-explicit-package-include-closure//xoev:include[xoev:including/@id = $i and xoev:included/@id = $C/@id]))">
                    <xsl:copy-of select="."/>
                </xsl:if>
            </xsl:for-each>
        </xoev:direct-package-import>
    </xsl:variable>

    <xsl:function name="xoev:directly-included-packages" as="element(packagedElement)*">
        <xsl:param name="package" as="element(packagedElement)"/>
        <xsl:choose>
            <xsl:when test="$xoev:my-xmodel/xoev-profil:xsdXModel(.)/@automatischeIncludeErmittlung != 'true'">
                <xsl:sequence select="xoev:dependencies-by-client($package)[xoev-profil:xsdInclude(.)]/uml:resolve-supplier(.)"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:sequence select="
                        $xoev:direct-implicit-and-explicit-package-include//
                        xoev:include[xoev:including/@id = $package/@xmi:id]/xoev:included/@id/xoev:ids-to-elements(., root($package))"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:function>

    <xsl:function name="xoev:directly-imported-packages" as="element(packagedElement)*">
        <xsl:param name="package" as="element(packagedElement)"/>
        <xsl:choose>
            <xsl:when test="$xoev:my-xmodel/xoev-profil:xsdXModel(.)/@automatischeImportErmittlung != 'true'">
                <xsl:sequence select="xoev:dependencies-by-client($package)[xoev-profil:xsdImport(.)]/uml:resolve-supplier(.)"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:sequence select="
                        $xoev:direct-implicit-and-explicit-package-import//
                        xoev:import[xoev:importing/@id = $package/@xmi:id]/xoev:imported/@id/xoev:ids-to-elements(., root($package))"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:function>

    <xsl:function name="xoev:all-included-packages" as="element(packagedElement)*">
        <xsl:param name="package" as="element(packagedElement)"/>
        <xsl:for-each select="xoev:directly-included-packages($package)">
            <xsl:sequence select="."/>
            <xsl:sequence select="xoev:all-included-packages(.)"/>
        </xsl:for-each>
    </xsl:function>

    <xd:doc>
        <xd:desc>Die direkten xsdImports und xsdIncludes eines jeden xsdSchema-Pakets. Zum Zugriff wird die Funktion <xd:ref name="xoev:package-with-imports-and-includes" type="function"/> verwendet.</xd:desc>
    </xd:doc>
    <xsl:variable name="xoev:packages-with-imports-and-includes" as="document-node(element(packages-with-imports-and-includes))">
        <xsl:document>
            <packages-with-imports-and-includes>
                <xsl:for-each select="$uml:root-model//packagedElement[xoev-profil:xsdSchema(.)]">
                    <xsl:variable name="package" select="."/>
                    <package-with-imports-and-includes id="{@xmi:id}">
                        <xsl:for-each select="xoev:directly-imported-packages(.)">
                            <xsl:variable name="imported-package" select="." as="element()"/>
                            <xsl:variable name="import-dependency" select="$imported-package/xoev:dependencies-by-supplier(.)[uml:resolve-client(.)/@xmi:id = $package/@xmi:id]"/>
                            <xsl:variable name="xmodel-of-imported-package" as="element()" select="$imported-package/ancestor::packagedElement/xoev-profil:xsdXModel(.)"/>
                            <xsl:variable name="import-prefix" select="
                                    ($import-dependency/xoev-profil:xsdImport(.)/@prefix,
                                    xoev:getPrefix($imported-package))[1]"/>
                            <xsl:variable name="imported-namespace" select="xoev:getNamespace($imported-package)"/>
                            <import id="{$imported-package/@xmi:id}" prefix="{$import-prefix}" namespace="{$imported-namespace}" schemaFile="{xoev-profil:xsdSchema($imported-package)/@schemaFile}" kind="direct">
                               <xsl:attribute name="schemaLocation" select="
                                  ($import-dependency/xoev-profil:xsdImport(.)/@schemaLocationDeployment,
                                  xoev-profil:xsdSchema($imported-package)/@schemaLocation,
                                  concat($xmodel-of-imported-package/@schemaLocationBase, xoev-profil:xsdSchema($imported-package)/@schemaFile))[1]"/>
                            </import>
                            <xsl:for-each select="xoev:all-included-packages($imported-package)">
                                <import id="{@xmi:id}" prefix="{$import-prefix}" namespace="{$imported-namespace}" schemaFile="{xoev-profil:xsdSchema(.)/@schemaFile}" kind="indirect"/>
                            </xsl:for-each>
                        </xsl:for-each>
                        <xsl:for-each select="xoev:directly-included-packages(.)">
                            <include id="{@xmi:id}" schemaFile="{xoev-profil:xsdSchema(.)/@schemaFile}" kind="direct"/>
                            <xsl:for-each select="xoev:all-included-packages(.)">
                                <include id="{@xmi:id}" schemaFile="{xoev-profil:xsdSchema(.)/@schemaFile}" kind="indirect"/>
                            </xsl:for-each>
                        </xsl:for-each>
                    </package-with-imports-and-includes>
                </xsl:for-each>
            </packages-with-imports-and-includes>
        </xsl:document>
    </xsl:variable>
    <xd:doc>
        <xd:desc>Key zur Ermittlung eines Elements aus <xd:ref name="xoev:packages-with-imports-and-includes" type="variable"/> anhand der ID des betrachteten Pakets.</xd:desc>
    </xd:doc>
    <xsl:key name="xoev:packages-with-imports-and-includes" match="package-with-imports-and-includes" use="@id"/>
    <xsl:function name="xoev:package-with-imports-and-includes" as="element(package-with-imports-and-includes)">
        <xsl:param name="package" as="element()"/>
        <xsl:sequence select="key('xoev:packages-with-imports-and-includes', $package/@xmi:id, $xoev:packages-with-imports-and-includes)"/>
    </xsl:function>

    <xsl:variable name="xoev:ist-zyklenfrei" as="xs:boolean">
        <xsl:value-of select="empty($xoev:implicit-and-explicit-package-include-closure//xoev:include[xoev:including/@id = xoev:included/@id])"/>
    </xsl:variable>

    <xsl:function name="xoev:paketpfad-clean" as="xs:string">
        <xsl:param name="element" as="node()"/>
        <xsl:param name="oberstes-paket" as="node()"/>
        <xsl:value-of select="replace(replace(replace(xoev:paketpfad($element, $oberstes-paket), '&amp;' , '_') , '-' , '_'), ' ', '_')"/>
    </xsl:function>

    <xsl:function name="xoev:paketpfad" as="xs:string">
        <xsl:param name="element" as="node()"/>
        <xsl:param name="oberstes-paket" as="node()"/>
        <xsl:choose>
            <xsl:when test="not($element/@xmi:id = $oberstes-paket/@xmi:id) and $element/parent::packagedElement">
                <xsl:value-of select="concat(xoev:paketpfad-clean($element/parent::packagedElement, $oberstes-paket), '/', replace($element/@name, '[\s\-]+', '_'))"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="$element/@name"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:function>

    <xsl:function name="xoev:qualifizierter-name" as="xs:string">
        <xsl:param name="element" as="node()"/>
        <xsl:choose>
            <xsl:when test="$element/parent::packagedElement">
                <xsl:value-of select="concat(xoev:qualifizierter-name($element/parent::packagedElement), '.', $element/@name)"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="$element/@name"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:function>

    <xsl:function name="xoev:docbook-id" as="xs:string">
        <xsl:param name="element" as="node()"/>
        <xsl:value-of select="replace(xoev:qualifizierter-name($element), '[\s&lt;&gt;#%?&amp;{}\-\\()]+', '_')"/>
    </xsl:function>

    <xsl:function name="xoev:clean-name" as="xs:string">
        <xsl:param name="string"/>
        <xsl:value-of select="normalize-space(replace(replace(replace(replace($string, 
            '&lt;[^&lt;!][^&lt;]+[^-]&gt;', ''),
            '&amp;ndash;','-'),
            '&amp;([^;]+);', '$1'),
            '&lt;!--[^&gt;]*--&gt;',''))"/>
    </xsl:function>

</xsl:stylesheet>
