<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:app="http://www.xoev.de/de/xgenerator/framework/1/application"
                xmlns:uml="http://www.eclipse.org/uml2/5.0.0/UML"
                xmlns:xd="http://www.oxygenxml.com/ns/doc/xsl"
                xmlns:xgen="http://www.xoev.de/de/xgenerator/framework/1/library"
                xmlns:xmi="http://www.omg.org/spec/XMI/20131001"
                xmlns:xoev="urn:xoev-de:kosit:xoev:classic:access-layer:osci-transport-profil_4.2.0"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                version="2.0">
   <xsl:variable name="xoev:profile-application"
                 select="$xgen:profile-applications/xgen:profile-application[@name = 'OSCI-Transport-Profil']"
                 as="element(xgen:profile-application)?"/>
   <xsl:variable name="xoev:version">4.2.0</xsl:variable>
   <xd:doc>
      <xd:desc>Internal access key. Do not use directly.</xd:desc>
   </xd:doc>
   <xsl:key name="xoev:wsdlService"
            match="/xmi:XMI/*[namespace-uri() = $xoev:profile-application/@nsURI and local-name()='wsdlService']"
            use="(@base_Class)[1]"/>
   <xd:doc>
      <xd:desc>Access function for applications of stereotyp wsdlService.</xd:desc>
      <xd:param name="model-element">Model element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>Stereotype application (e. g. xsdSchema) or empty sequence.</xd:return>
   </xd:doc>
   <xsl:function name="xoev:wsdlService" as="element()?">
      <xsl:param name="model-element" as="element()"/>
      <xsl:sequence select="key('xoev:wsdlService', $model-element/@xmi:id, root($model-element))"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Internal access key. Do not use directly.</xd:desc>
   </xd:doc>
   <xsl:key name="xoev:wsdlServiceMessage"
            match="/xmi:XMI/*[namespace-uri() = $xoev:profile-application/@nsURI and local-name()='wsdlServiceMessage']"
            use="(@base_Dependency)[1]"/>
   <xd:doc>
      <xd:desc>Access function for applications of stereotyp wsdlServiceMessage.</xd:desc>
      <xd:param name="model-element">Model element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>Stereotype application (e. g. xsdSchema) or empty sequence.</xd:return>
   </xd:doc>
   <xsl:function name="xoev:wsdlServiceMessage" as="element()?">
      <xsl:param name="model-element" as="element()"/>
      <xsl:sequence select="key('xoev:wsdlServiceMessage', $model-element/@xmi:id, root($model-element))"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Internal access key. Do not use directly.</xd:desc>
   </xd:doc>
   <xsl:key name="xoev:osciTransportScenario"
            match="/xmi:XMI/*[namespace-uri() = $xoev:profile-application/@nsURI and local-name()='osciTransportScenario']"
            use="(@base_Class)[1]"/>
   <xd:doc>
      <xd:desc>Access function for applications of stereotyp osciTransportScenario.</xd:desc>
      <xd:param name="model-element">Model element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>Stereotype application (e. g. xsdSchema) or empty sequence.</xd:return>
   </xd:doc>
   <xsl:function name="xoev:osciTransportScenario" as="element()?">
      <xsl:param name="model-element" as="element()"/>
      <xsl:sequence select="key('xoev:osciTransportScenario', $model-element/@xmi:id, root($model-element))"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Internal access key. Do not use directly.</xd:desc>
   </xd:doc>
   <xsl:key name="xoev:wsdlServiceInputMessage"
            match="/xmi:XMI/*[namespace-uri() = $xoev:profile-application/@nsURI and local-name()='wsdlServiceInputMessage']"
            use="(@base_Dependency)[1]"/>
   <xd:doc>
      <xd:desc>Access function for applications of stereotyp wsdlServiceInputMessage.</xd:desc>
      <xd:param name="model-element">Model element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>Stereotype application (e. g. xsdSchema) or empty sequence.</xd:return>
   </xd:doc>
   <xsl:function name="xoev:wsdlServiceInputMessage" as="element()?">
      <xsl:param name="model-element" as="element()"/>
      <xsl:sequence select="key('xoev:wsdlServiceInputMessage', $model-element/@xmi:id, root($model-element))"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Internal access key. Do not use directly.</xd:desc>
   </xd:doc>
   <xsl:key name="xoev:wsdlServiceOutputMessage"
            match="/xmi:XMI/*[namespace-uri() = $xoev:profile-application/@nsURI and local-name()='wsdlServiceOutputMessage']"
            use="(@base_Dependency)[1]"/>
   <xd:doc>
      <xd:desc>Access function for applications of stereotyp wsdlServiceOutputMessage.</xd:desc>
      <xd:param name="model-element">Model element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>Stereotype application (e. g. xsdSchema) or empty sequence.</xd:return>
   </xd:doc>
   <xsl:function name="xoev:wsdlServiceOutputMessage" as="element()?">
      <xsl:param name="model-element" as="element()"/>
      <xsl:sequence select="key('xoev:wsdlServiceOutputMessage', $model-element/@xmi:id, root($model-element))"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Internal access key. Do not use directly.</xd:desc>
   </xd:doc>
   <xsl:key name="xoev:wsdlServiceFaultMessage"
            match="/xmi:XMI/*[namespace-uri() = $xoev:profile-application/@nsURI and local-name()='wsdlServiceFaultMessage']"
            use="(@base_Dependency)[1]"/>
   <xd:doc>
      <xd:desc>Access function for applications of stereotyp wsdlServiceFaultMessage.</xd:desc>
      <xd:param name="model-element">Model element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>Stereotype application (e. g. xsdSchema) or empty sequence.</xd:return>
   </xd:doc>
   <xsl:function name="xoev:wsdlServiceFaultMessage" as="element()?">
      <xsl:param name="model-element" as="element()"/>
      <xsl:sequence select="key('xoev:wsdlServiceFaultMessage', $model-element/@xmi:id, root($model-element))"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Internal access key. Do not use directly.</xd:desc>
   </xd:doc>
   <xsl:key name="xoev:wsdlServiceAndOperations"
            match="/xmi:XMI/*[namespace-uri() = $xoev:profile-application/@nsURI and local-name()='wsdlServiceAndOperations']"
            use="(@base_Class)[1]"/>
   <xd:doc>
      <xd:desc>Access function for applications of stereotyp wsdlServiceAndOperations.</xd:desc>
      <xd:param name="model-element">Model element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>Stereotype application (e. g. xsdSchema) or empty sequence.</xd:return>
   </xd:doc>
   <xsl:function name="xoev:wsdlServiceAndOperations" as="element()?">
      <xsl:param name="model-element" as="element()"/>
      <xsl:sequence select="key('xoev:wsdlServiceAndOperations', $model-element/@xmi:id, root($model-element))"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Internal access key. Do not use directly.</xd:desc>
   </xd:doc>
   <xsl:key name="xoev:wsdlBinding"
            match="/xmi:XMI/*[namespace-uri() = $xoev:profile-application/@nsURI and local-name()='wsdlBinding']"
            use="(@base_Element)[1]"/>
   <xd:doc>
      <xd:desc>Access function for applications of stereotyp wsdlBinding.</xd:desc>
      <xd:param name="model-element">Model element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>Stereotype application (e. g. xsdSchema) or empty sequence.</xd:return>
   </xd:doc>
   <xsl:function name="xoev:wsdlBinding" as="element()?">
      <xsl:param name="model-element" as="element()"/>
      <xsl:sequence select="key('xoev:wsdlBinding', $model-element/@xmi:id, root($model-element))"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Internal access key. Do not use directly.</xd:desc>
   </xd:doc>
   <xsl:key name="xoev:wsdlBindingType"
            match="/xmi:XMI/*[namespace-uri() = $xoev:profile-application/@nsURI and local-name()='wsdlBindingType']"
            use="(@base_Dependency)[1]"/>
   <xd:doc>
      <xd:desc>Access function for applications of stereotyp wsdlBindingType.</xd:desc>
      <xd:param name="model-element">Model element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>Stereotype application (e. g. xsdSchema) or empty sequence.</xd:return>
   </xd:doc>
   <xsl:function name="xoev:wsdlBindingType" as="element()?">
      <xsl:param name="model-element" as="element()"/>
      <xsl:sequence select="key('xoev:wsdlBindingType', $model-element/@xmi:id, root($model-element))"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Internal access key. Do not use directly.</xd:desc>
   </xd:doc>
   <xsl:key name="xoev:wsdlMessage"
            match="/xmi:XMI/*[namespace-uri() = $xoev:profile-application/@nsURI and local-name()='wsdlMessage']"
            use="(@base_Element)[1]"/>
   <xd:doc>
      <xd:desc>Access function for applications of stereotyp wsdlMessage.</xd:desc>
      <xd:param name="model-element">Model element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>Stereotype application (e. g. xsdSchema) or empty sequence.</xd:return>
   </xd:doc>
   <xsl:function name="xoev:wsdlMessage" as="element()?">
      <xsl:param name="model-element" as="element()"/>
      <xsl:sequence select="key('xoev:wsdlMessage', $model-element/@xmi:id, root($model-element))"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Internal access key. Do not use directly.</xd:desc>
   </xd:doc>
   <xsl:key name="xoev:wsdlOperation"
            match="/xmi:XMI/*[namespace-uri() = $xoev:profile-application/@nsURI and local-name()='wsdlOperation']"
            use="(@base_Feature)[1]"/>
   <xd:doc>
      <xd:desc>Access function for applications of stereotyp wsdlOperation.</xd:desc>
      <xd:param name="model-element">Model element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>Stereotype application (e. g. xsdSchema) or empty sequence.</xd:return>
   </xd:doc>
   <xsl:function name="xoev:wsdlOperation" as="element()?">
      <xsl:param name="model-element" as="element()"/>
      <xsl:sequence select="key('xoev:wsdlOperation', $model-element/@xmi:id, root($model-element))"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Internal access key. Do not use directly.</xd:desc>
   </xd:doc>
   <xsl:key name="xoev:wsdlOperationInputHeaderPart"
            match="/xmi:XMI/*[namespace-uri() = $xoev:profile-application/@nsURI and local-name()='wsdlOperationInputHeaderPart']"
            use="(@base_Dependency)[1]"/>
   <xd:doc>
      <xd:desc>Access function for applications of stereotyp wsdlOperationInputHeaderPart.</xd:desc>
      <xd:param name="model-element">Model element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>Stereotype application (e. g. xsdSchema) or empty sequence.</xd:return>
   </xd:doc>
   <xsl:function name="xoev:wsdlOperationInputHeaderPart" as="element()?">
      <xsl:param name="model-element" as="element()"/>
      <xsl:sequence select="key('xoev:wsdlOperationInputHeaderPart', $model-element/@xmi:id, root($model-element))"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Internal access key. Do not use directly.</xd:desc>
   </xd:doc>
   <xsl:key name="xoev:wsdlOperationOutputHeaderPart"
            match="/xmi:XMI/*[namespace-uri() = $xoev:profile-application/@nsURI and local-name()='wsdlOperationOutputHeaderPart']"
            use="(@base_Dependency)[1]"/>
   <xd:doc>
      <xd:desc>Access function for applications of stereotyp wsdlOperationOutputHeaderPart.</xd:desc>
      <xd:param name="model-element">Model element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>Stereotype application (e. g. xsdSchema) or empty sequence.</xd:return>
   </xd:doc>
   <xsl:function name="xoev:wsdlOperationOutputHeaderPart" as="element()?">
      <xsl:param name="model-element" as="element()"/>
      <xsl:sequence select="key('xoev:wsdlOperationOutputHeaderPart', $model-element/@xmi:id, root($model-element))"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Internal access key. Do not use directly.</xd:desc>
   </xd:doc>
   <xsl:key name="xoev:wsdlPortType"
            match="/xmi:XMI/*[namespace-uri() = $xoev:profile-application/@nsURI and local-name()='wsdlPortType']"
            use="(@base_Class)[1]"/>
   <xd:doc>
      <xd:desc>Access function for applications of stereotyp wsdlPortType.</xd:desc>
      <xd:param name="model-element">Model element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>Stereotype application (e. g. xsdSchema) or empty sequence.</xd:return>
   </xd:doc>
   <xsl:function name="xoev:wsdlPortType" as="element()?">
      <xsl:param name="model-element" as="element()"/>
      <xsl:sequence select="key('xoev:wsdlPortType', $model-element/@xmi:id, root($model-element))"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Internal access key. Do not use directly.</xd:desc>
   </xd:doc>
   <xsl:key name="xoev:wsdlSchemaTarget"
            match="/xmi:XMI/*[namespace-uri() = $xoev:profile-application/@nsURI and local-name()='wsdlSchemaTarget']"
            use="(@base_Dependency)[1]"/>
   <xd:doc>
      <xd:desc>Access function for applications of stereotyp wsdlSchemaTarget.</xd:desc>
      <xd:param name="model-element">Model element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>Stereotype application (e. g. xsdSchema) or empty sequence.</xd:return>
   </xd:doc>
   <xsl:function name="xoev:wsdlSchemaTarget" as="element()?">
      <xsl:param name="model-element" as="element()"/>
      <xsl:sequence select="key('xoev:wsdlSchemaTarget', $model-element/@xmi:id, root($model-element))"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Internal access key. Do not use directly.</xd:desc>
   </xd:doc>
   <xsl:key name="xoev:wsdlSchemaImport"
            match="/xmi:XMI/*[namespace-uri() = $xoev:profile-application/@nsURI and local-name()='wsdlSchemaImport']"
            use="(@base_Dependency)[1]"/>
   <xd:doc>
      <xd:desc>Access function for applications of stereotyp wsdlSchemaImport.</xd:desc>
      <xd:param name="model-element">Model element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>Stereotype application (e. g. xsdSchema) or empty sequence.</xd:return>
   </xd:doc>
   <xsl:function name="xoev:wsdlSchemaImport" as="element()?">
      <xsl:param name="model-element" as="element()"/>
      <xsl:sequence select="key('xoev:wsdlSchemaImport', $model-element/@xmi:id, root($model-element))"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Internal access key. Do not use directly.</xd:desc>
   </xd:doc>
   <xsl:key name="xoev:wsdlKonfiguration"
            match="/xmi:XMI/*[namespace-uri() = $xoev:profile-application/@nsURI and local-name()='wsdlKonfiguration']"
            use="(@base_Model)[1]"/>
   <xd:doc>
      <xd:desc>Access function for applications of stereotyp wsdlKonfiguration.</xd:desc>
      <xd:param name="model-element">Model element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>Stereotype application (e. g. xsdSchema) or empty sequence.</xd:return>
   </xd:doc>
   <xsl:function name="xoev:wsdlKonfiguration" as="element()?">
      <xsl:param name="model-element" as="element()"/>
      <xsl:sequence select="key('xoev:wsdlKonfiguration', $model-element/@xmi:id, root($model-element))"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>Internal access key. Do not use directly.</xd:desc>
   </xd:doc>
   <xsl:key name="xoev:Info"
            match="/xmi:XMI/*[namespace-uri() = $xoev:profile-application/@nsURI and local-name()='Info']"
            use="(@base_Package)[1]"/>
   <xd:doc>
      <xd:desc>Access function for applications of stereotyp Info.</xd:desc>
      <xd:param name="model-element">Model element, e. g., packagedElement, ownedAttribut, uml:Model</xd:param>
      <xd:return>Stereotype application (e. g. xsdSchema) or empty sequence.</xd:return>
   </xd:doc>
   <xsl:function name="xoev:Info" as="element()?">
      <xsl:param name="model-element" as="element()"/>
      <xsl:sequence select="key('xoev:Info', $model-element/@xmi:id, root($model-element))"/>
   </xsl:function>
</xsl:stylesheet>
