<?xml version="1.0" encoding="UTF-8"?>

<!-- Version 1.2.0 -->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:gc="http://docs.oasis-open.org/codelist/ns/genericode/1.0/" xmlns:xoev-cl-2="http://xoev.de/schemata/genericode/2" xmlns:xoev-cl-4="http://xoev.de/schemata/genericode/4" xmlns:lite="urn:xoev-de:kosit:xoev:lite:transformation_1.2.0" xmlns:lite-bib="urn:xoev-de:kosit:xoev:lite:schema:bibliothek_1.2.0" xmlns:db="http://docbook.org/ns/docbook" xmlns:html="http://www.w3.org/1999/xhtml" xmlns:lite-fm="urn:xoev-de:kosit:xoev:lite:schema:fachmodell_1.2.0" xmlns:xgen="http://www.xoev.de/de/xgenerator/framework/1/library" xmlns:ns="http://schemas.xmlsoap.org/soap/encoding/" xmlns:soap="http://schemas.xmlsoap.org/wsdl/soap/" xmlns="http://schemas.xmlsoap.org/wsdl/" xmlns:ds="http://www.w3.org/2000/09/xmldsig#" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:wsdl="http://schemas.xmlsoap.org/wsdl/" xmlns:tpl="http://www.dvdv.de/dvdv/template/" xmlns:osci="http://www.osci.de/2006/07/wsdl/" xpath-default-namespace="urn:xoev-de:kosit:xoev:lite:schema:fachmodell_1.2.0" version="2.0" exclude-result-prefixes="xsl lite gc html xoev-cl-2 xoev-cl-4 lite-bib lite-fm xgen xsi db">

  <xsl:template match="/" mode="lite:default-lite2wsdl">
    <xsl:apply-templates select="$xoev-modell/descendant::wsdlService[wsdlServiceMessage]" mode="lite:wsdl-document-one-way-active"/>
    <xsl:apply-templates select="$xoev-modell/descendant::wsdlService[wsdlServiceInputMessage]" mode="lite:wsdl-document-request-response"/>

  </xsl:template>
  <xsl:function name="lite:service-name" as="xs:string">
    <xsl:param name="wsdlService" as="element()"/>
    <xsl:value-of select="
        ($wsdlService/Dateiname,
        concat($wsdlService/ancestor::xoev-fachmodell/konfiguration.xoev-fachmodell/prefix,
        replace($wsdlService/ancestor::xoev-fachmodell/metadaten.versionStandard/version, '\.', ''),
        $wsdlService/@name))[1]"/>
  </xsl:function>
  <xsl:function name="lite:namensraum-basis" as="xs:string">
    <xsl:param name="wsdlService" as="element()"/>
    <xsl:value-of select="($wsdlService/NamensraumOhneDateiname, $wsdlService/ancestor::xoev-fachmodell/konfiguration.xoev-fachmodell/namespace)[1]"/>
  </xsl:function>
  <xsl:function name="lite:namensraum-basis-mit-slash" as="xs:string">
    <xsl:param name="wsdlService" as="element()"/>
    <xsl:value-of select="
        concat(lite:namensraum-basis($wsdlService),
        if (ends-with(lite:namensraum-basis($wsdlService), '/')) then
          ''
        else
          '/')"/>
  </xsl:function>
  <xsl:function name="lite:namensraum" as="xs:string">
    <xsl:param name="wsdlService" as="element()"/>
    <xsl:choose>
      <xsl:when test="$wsdlService/ancestor::xoev-fachmodell/konfiguration.xoev-fachmodell/StandardaufbauNamensraum = 'URN'">
        <xsl:value-of select="concat($wsdlService/ancestor-or-self::xoev-fachmodell/metadaten.standard/kennung, ':service:wsdl:', lite:service-name($wsdlService))"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="concat(lite:namensraum-basis-mit-slash($wsdlService), lite:service-name($wsdlService), '.wsdl')"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:function>
  <xsl:function name="lite:optionaler-container" as="xs:string">
    <xsl:param name="wsdlService" as="element()"/>
    <xsl:value-of select="
        ($wsdlService/OptionalerContainer[. != ''],
        $xoev-modell/descendant::osciTransportScenario[@name = $wsdlService/osciTransportScenario]/OptionalerContainer)[1]"/>
  </xsl:function>
  <xsl:template match="wsdlService" mode="lite:schema-fuer-nachrichtenmenge">
    <xsl:param name="messages" as="element()*"/>
    <xsl:param name="art" as="xs:string"/>
    <xsl:variable name="wsdlService" select="."/>
    <xsl:choose>
      <xsl:when test="count(distinct-values($messages/lite:namespace(.))) gt 1">
        <xsl:element name="xs:schema">
          <xsl:for-each-group select="$messages/ancestor-or-self::xsdSchema" group-by="@name">
            <xsl:sort select="
                (@schemaLocation,
                concat(ancestor::xoev-fachmodell/konfiguration.xoev-fachmodell/schemaLocationBase,
                @schemaFile))[1]"/>
            <xsl:variable name="schema" select="."/>
            <xsl:namespace name="{$schema/@prefix}" select="$schema/lite:namespace(.)"/>
          </xsl:for-each-group>
          <xsl:attribute name="targetNamespace" select="lite:namensraum($wsdlService)"/>
          <xsl:for-each-group select="$messages/ancestor-or-self::xsdSchema" group-by="@name">
            <xsl:sort select="
                (@schemaLocation,
                concat(ancestor::xoev-fachmodell/konfiguration.xoev-fachmodell/schemaLocationBase,
                @schemaFile))[1]"/>
            <xsl:variable name="schema-paket" select="."/>
            <xsl:element name="xs:import">
              <xsl:attribute name="namespace" select="$schema-paket/lite:namespace(.)"/>
              <xsl:attribute name="schemaLocation" select="
                  ($schema-paket/@schemaLocation,
                  concat($schema-paket/ancestor::xoev-fachmodell/konfiguration.xoev-fachmodell/schemaLocationBase, $schema-paket/@schemaFile))[1]"/>
            </xsl:element>
          </xsl:for-each-group>
          <xsl:element name="xs:complexType">
            <xsl:attribute name="name" select="
                concat(lower-case($wsdlService/@name), $art, 'Schemata')"/>
            <xsl:element name="xs:choice">
              <xsl:for-each-group select="$messages" group-by="@name">
                <xsl:sort select="@name"/>
                <xsl:element name="xs:element">
                  <xsl:attribute name="name" select="@name"/>
                </xsl:element>
              </xsl:for-each-group>
            </xsl:element>
          </xsl:element>
        </xsl:element>
      </xsl:when>
      <xsl:otherwise>
        <xsl:element name="xs:schema">
          <xsl:namespace name="" select="lite:namensraum-basis($wsdlService)"/>
          <xsl:attribute name="targetNamespace" select="lite:namensraum($wsdlService)"/>
          <xsl:for-each-group select="$messages/ancestor-or-self::xsdSchema" group-by="@name">
            <xsl:sort select="
                (@schemaLocation,
                concat(ancestor::xoev-fachmodell/konfiguration.xoev-fachmodell/schemaLocationBase,
                @schemaFile))[1]"/>
            <xsl:variable name="schema-paket" select="."/>
            <xsl:element name="xs:import">
              <xsl:attribute name="namespace" select="$schema-paket/lite:namespace(.)"/>
              <xsl:attribute name="schemaLocation" select="
                  ($schema-paket/@schemaLocation,
                  concat($schema-paket/ancestor::xoev-fachmodell/konfiguration.xoev-fachmodell/schemaLocationBase, $schema-paket/@schemaFile))[1]"/>
            </xsl:element>
          </xsl:for-each-group>
          <xsl:element name="xs:complexType">
            <xsl:attribute name="name" select="
                concat(lower-case($wsdlService/@name), $art, 'Schemata')"/>
            <xsl:element name="xs:choice">
              <xsl:for-each-group select="$messages" group-by="@name">
                <xsl:sort select="@name"/>
                <xsl:element name="xs:element">
                  <xsl:attribute name="name" select="@name"/>
                </xsl:element>
              </xsl:for-each-group>
            </xsl:element>
          </xsl:element>
        </xsl:element>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  <xsl:template match="wsdlService" mode="lite:message">
    <xsl:param name="messages" as="element()*"/>
    <xsl:param name="art" as="xs:string"/>
    <xsl:variable name="wsdlService" select="."/>
    <xsl:variable name="request-response-fault" select="
        if ($art = 'Input') then
          'Request'
        else
          if ($art = 'Output') then
            'Response'
          else
            if ($art = 'Fault') then
              'Fault'
            else
              ''"/>
    <message name="{concat(lower-case($wsdlService/@name),
            $request-response-fault,'Nachricht')}">
      <xsl:if test="$messages">
        <xsl:element name="part">
          <xsl:attribute name="name" select="
              if ($request-response-fault) then
                lower-case($request-response-fault)
              else
                concat(lower-case($wsdlService/@name), 'Nachricht')"/>
          <xsl:choose>
            <xsl:when test="count($messages) = 1">
              <xsl:attribute name="element" select="$messages"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:attribute name="type" select="concat('tns:', lower-case($wsdlService/@name), $art, 'Schemata')"/>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:element>
      </xsl:if>
      <xsl:if test="lite:optionaler-container($wsdlService) = 'true'">
        <part name="optionaleNachricht" type="xs:anyType"/>
      </xsl:if>
    </message>
  </xsl:template>
  <xsl:function name="lite:wsdlService-upper-camel-case" as="xs:string">
    <xsl:param name="wsdlService" as="element()"/>
    <xsl:value-of select="concat(upper-case(substring($wsdlService/@name, 1, 1)), substring($wsdlService/@name, 2, string-length($wsdlService/@name) - 1))"/>
  </xsl:function>
  <xsl:template match="wsdlService" mode="lite:port">
    <xsl:param name="ist-one-way-active" as="xs:boolean" required="no" select="false()"/>
    <xsl:param name="hat-fault-nachrichten" as="xs:boolean" required="no" select="false()"/>
    <xsl:variable name="wsdlService" select="."/>
    <portType name="{concat('osci',lite:wsdlService-upper-camel-case($wsdlService),'Interface')}">
      <xsl:choose>
        <xsl:when test="$ist-one-way-active">
          <operation name="{concat('sende',lite:wsdlService-upper-camel-case($wsdlService))}">
            <input message="{concat('tns:',lower-case($wsdlService/@name),'Nachricht')}"/>
          </operation>
        </xsl:when>
        <xsl:otherwise>
          <operation name="{concat('sende',lite:wsdlService-upper-camel-case($wsdlService))}">
            <input message="{concat('tns:',lower-case($wsdlService/@name),'RequestNachricht')}"/>
            <output message="{concat('tns:',lower-case($wsdlService/@name),'ResponseNachricht')}"/>
            <xsl:if test="$hat-fault-nachrichten">
              <fault name="faultMessage" message="{concat('tns:',lower-case($wsdlService/@name),'FaultNachricht')}"/>
            </xsl:if>
          </operation>
        </xsl:otherwise>
      </xsl:choose>
    </portType>
  </xsl:template>
  <xsl:template match="wsdlService" mode="lite:binding">
    <xsl:param name="ist-request-response" as="xs:boolean" select="false()" required="no"/>
    <xsl:param name="hat-fault-nachrichten" as="xs:boolean" select="false()" required="no"/>
    <xsl:variable name="wsdlService" select="."/>
    <xsl:variable name="signatur-nutzdaten" select="
        ($wsdlService/SignaturNutzdaten[. != ''],
        $xoev-modell/descendant::osciTransportScenario[@name = $wsdlService/osciTransportScenario]/SignaturNutzdaten)[1]"/>
    <xsl:variable name="signatur-inhaltsdaten" select="
        ($wsdlService/@SignaturInhaltsdaten[. != ''],
        $xoev-modell/descendant::osciTransportScenario[@name = $wsdlService/osciTransportScenario]/SignaturInhaltsdaten)[1]"/>
    <xsl:variable name="verschluesselung-nutzdaten" select="
        ($wsdlService/VerschluesselungNutzdaten[. != ''],
        $xoev-modell/descendant::osciTransportScenario[@name = $wsdlService/osciTransportScenario]/VerschluesselungNutzdaten)[1]"/>
    <xsl:variable name="verschluesselung-inhaltsdaten" select="
        ($wsdlService/VerschluesselungInhaltsdaten[. != ''],
        $xoev-modell/descendant::osciTransportScenario[@name = $wsdlService/osciTransportScenario]/VerschluesselungInhaltsdaten)[1]"/>
    <xsl:variable name="kommunikationsszenario" select="
        ($wsdlService/Kommunikationsszenario[. != ''],
        $xoev-modell/descendant::osciTransportScenario[@name = $wsdlService/osciTransportScenario]/Kommunikationsszenario)[1]"/>
    <binding name="osciBinding" type="{concat('tns:','osci',lite:wsdlService-upper-camel-case($wsdlService),'Interface')}">
      <osci:binding signatureLevel="{$signatur-nutzdaten}" encrypted="{$verschluesselung-nutzdaten}">
        <osci:reader name="Inhaltsdaten-Verschlüsselungszertifikat">
          <tpl:certificate/>
        </osci:reader>
        <xsl:if test="$ist-request-response">
          <osci:author name="Inhaltsdaten-Signaturzertifikat">
            <tpl:certificate/>
          </osci:author>
        </xsl:if>
      </osci:binding>
      <xsl:comment> Vorbelegung der Richtlinien zur Signatur und Verschlüsselung der Nutzdaten für alle Operationen </xsl:comment>
      <operation name="{concat('sende',lite:wsdlService-upper-camel-case($wsdlService))}">
        <xsl:variable name="subject-name" select="
            if (starts-with(ancestor::xoev-fachmodell/konfiguration.xoev-fachmodell/StandardaufbauSubjectOperation, 'ModelName')) then
              concat(upper-case(substring(ancestor::xoev-fachmodell/metadaten.standard/nameTechnisch, 1, 2)),
              substring(ancestor::xoev-fachmodell/metadaten.standard/nameTechnisch, 3, string-length(ancestor::xoev-fachmodell/metadaten.standard/nameTechnisch)))
            else
              concat(upper-case(substring(ancestor::xoev-fachmodell/konfiguration.xoev-fachmodell/prefix, 1, 2)),
              substring(ancestor::xoev-fachmodell/konfiguration.xoev-fachmodell/prefix, 3, string-length(ancestor::xoev-fachmodell/konfiguration.xoev-fachmodell/prefix)))"/>
        <xsl:variable name="module-version" select="
            ($xoev-modell/descendant::nachricht[concat(lite:prefix(.), ':', @name) = (wsdlServiceMessage, wsdlServiceInputMessage)]/ancestor::xsdSchema/@version,
            ancestor::xoev-fachmodell/metadaten.versionStandard/version)[1]"/>
        <osci:operation communicationType="{$kommunikationsszenario}" subject="{
                    ($wsdlService/SubjectOperation,
                    concat($subject-name, 
                    ' ',
                    if(ends-with(ancestor::xoev-fachmodell/konfiguration.xoev-fachmodell/StandardaufbauSubjectOperation, 'ModulVersion')) then
                    concat($wsdlService/@name, ' ', $module-version) else
                    concat(ancestor::xoev-fachmodell/metadaten.versionStandard/version, ' ', $wsdlService/@name)))[1]}"/>
        <input>
          <osci:container signatureLevel="{$signatur-inhaltsdaten}" encrypted="{$verschluesselung-inhaltsdaten}" name="{
                        ($wsdlService/NameMandatorischerContainer[. != ''],
                        $xoev-modell/descendant::osciTransportScenario[@name = $wsdlService/osciTransportScenario]/NameMandatorischerContainer,
                        concat(upper-case($wsdlService/ancestor::xoev-fachmodell/metadaten.standard/nameTechnisch),'_DATA'))[1]}" required="true">
            <osci:readerRef ref="Inhaltsdaten-Verschlüsselungszertifikat"/>
            <osci:part>
              <osci:content part="{if($ist-request-response) then 'tns:request' else concat('tns:',lower-case($wsdlService/@name),'Nachricht')}"/>
            </osci:part>
          </osci:container>
          <xsl:if test="lite:optionaler-container($wsdlService) = 'true'">
            <osci:container signatureLevel="none" encrypted="false" required="false">
              <osci:part>
                <osci:content part="tns:optionaleNachricht"/>
              </osci:part>
            </osci:container>
          </xsl:if>
        </input>
        <xsl:if test="$ist-request-response">
          <output>
            <osci:container signatureLevel="{$signatur-inhaltsdaten}" encrypted="{$verschluesselung-inhaltsdaten}" name="{concat(upper-case(ancestor::xoev-fachmodell/metadaten.standard/nameTechnisch),'_DATA')}" required="true">
              <osci:readerRef ref="Inhaltsdaten-Verschlüsselungszertifikat"/>
              <osci:part>
                <osci:content part="tns:response"/>
              </osci:part>
            </osci:container>
            <xsl:if test="lite:optionaler-container($wsdlService) = 'true'">
              <osci:container signatureLevel="none" encrypted="false" required="false">
                <osci:part>
                  <osci:content part="tns:optionaleNachricht"/>
                </osci:part>
              </osci:container>
            </xsl:if>
          </output>
          <xsl:if test="$hat-fault-nachrichten">
            <fault name="faultMessage">
              <osci:container signatureLevel="{$signatur-inhaltsdaten}" encrypted="{$verschluesselung-inhaltsdaten}" name="{concat(upper-case(ancestor::xoev-fachmodell/metadaten.standard/nameTechnisch),'_DATA')}" required="true">
                <osci:readerRef ref="Inhaltsdaten-Verschlüsselungszertifikat"/>
                <osci:part>
                  <osci:content part="tns:fault"/>
                </osci:part>
              </osci:container>
              <xsl:if test="lite:optionaler-container($wsdlService) = 'true'">
                <osci:container signatureLevel="none" encrypted="false" required="false">
                  <osci:part>
                    <osci:content part="tns:optionaleNachricht"/>
                  </osci:part>
                </osci:container>
              </xsl:if>
            </fault>
          </xsl:if>
        </xsl:if>
      </operation>
    </binding>
  </xsl:template>
  <xsl:template match="wsdlService" mode="lite:service">
    <xsl:variable name="wsdlService" select="."/>
    <service name="{concat('osci',$wsdlService/@name,'Service')}">
      <xsl:comment> OSCI Infrastrukturserver </xsl:comment>
      <osci:devices>
        <osci:intermediary uri="" name="InternetIntermediär">
          <osci:signatureCertificate>
            <tpl:certificate/>
          </osci:signatureCertificate>
          <osci:cipherCertificate>
            <tpl:certificate/>
          </osci:cipherCertificate>
        </osci:intermediary>
        <osci:intermediary uri="" name="TESTAIntermediär">
          <osci:signatureCertificate>
            <tpl:certificate/>
          </osci:signatureCertificate>
          <osci:cipherCertificate>
            <tpl:certificate/>
          </osci:cipherCertificate>
        </osci:intermediary>
        <osci:addressee name="InternetEmpfänger">
          <osci:cipherCertificate>
            <tpl:certificate/>
          </osci:cipherCertificate>
        </osci:addressee>
        <osci:addressee name="TESTAEmpfänger">
          <osci:cipherCertificate>
            <tpl:certificate/>
          </osci:cipherCertificate>
        </osci:addressee>
      </osci:devices>
      <xsl:comment> Endpunkt im Internet </xsl:comment>
      <port name="{concat('osci',$wsdlService/@name,'InternetPort')}" binding="tns:osciBinding">
        <documentation>
          <xsl:choose>
            <xsl:when test="$wsdlService/InternetPort = 'required'">
              <tpl:use>required</tpl:use>
              <xsl:text> Dieser Port ist nicht optional </xsl:text>
            </xsl:when>
            <xsl:otherwise>
              <tpl:use>optional</tpl:use>
              <xsl:text> Dieser Port ist optional </xsl:text>
            </xsl:otherwise>
          </xsl:choose>
        </documentation>
        <osci:address>
          <osci:intermediaryRef ref="InternetIntermediär"/>
          <osci:addresseeRef ref="InternetEmpfänger"/>
        </osci:address>
      </port>
      <xsl:comment> Endpunkt im TESTA </xsl:comment>
      <port name="{concat('osci',$wsdlService/@name,'TestaPort')}" binding="tns:osciBinding">
        <documentation>
          <xsl:choose>
            <xsl:when test="$wsdlService/TestaPort = 'required'">
              <tpl:use>required</tpl:use>
              <xsl:text> Dieser Port ist nicht optional </xsl:text>
            </xsl:when>
            <xsl:otherwise>
              <tpl:use>optional</tpl:use>
              <xsl:text> Dieser Port ist optional </xsl:text>
            </xsl:otherwise>
          </xsl:choose>
        </documentation>
        <osci:address>
          <osci:intermediaryRef ref="TESTAIntermediär"/>
          <osci:addresseeRef ref="TESTAEmpfänger"/>
        </osci:address>
      </port>
    </service>
  </xsl:template>
  <xsl:template match="wsdlService" mode="lite:wsdl-document-request-response">
    <xsl:variable name="wsdlService" select="."/>
    <xsl:variable name="service-input-messages" select="wsdlServiceInputMessage"/>
    <xsl:variable name="service-output-messages" select="wsdlServiceOutputMessage"/>
    <xsl:variable name="service-fault-messages" select="wsdlServiceFaultMessage"/>
    <xsl:call-template name="xgen:result-document">
      <xsl:with-param name="local-path" select="
          if (ancestor::xoev-fachmodell/konfiguration.xoev-fachmodell/Dateipraefix = 'ModelName') then
            xs:anyURI(concat(ancestor::xoev-fachmodell/metadaten.standard/nameTechnisch, '.', lite:service-name($wsdlService), '.wsdl'))
          else
            xs:anyURI(concat(lite:service-name($wsdlService), '.wsdl'))"/>
      <xsl:with-param name="content">
        <xsl:comment> Service </xsl:comment>
        <definitions name="{lite:service-name($wsdlService)}" targetNamespace="{lite:namensraum($wsdlService)}" xsi:schemaLocation="http://schemas.xmlsoap.org/wsdl/ http://schemas.xmlsoap.org/wsdl/">
          <xsl:namespace name="tns" select="lite:namensraum($wsdlService)"/>
          <xsl:apply-templates select="$wsdlService" mode="lite:standard-namespace"/>
          <xsl:variable name="begin-cdata"><![CDATA[<![CDATA[]]></xsl:variable>
          <xsl:variable name="end-cdata"><![CDATA[]]]]><![CDATA[>]]></xsl:variable>
          <documentation>
            <xsl:apply-templates select="$wsdlService" mode="lite:categories"/>
            <xsl:value-of select="xgen:unescaped-xml($begin-cdata)"/>
            <html>
              <xsl:apply-templates select="beschreibung" mode="lite:beschreibung">
                <xsl:with-param name="service-input-messages" select="$service-input-messages"/>
                <xsl:with-param name="service-output-messages" select="$service-output-messages"/>
                <xsl:with-param name="service-fault-messages" select="$service-fault-messages"/>
              </xsl:apply-templates>
            </html>
            <xsl:value-of select="xgen:unescaped-xml($end-cdata)"/>
          </documentation>
          <import namespace="http://www.osci.de/2006/07/wsdl/" location="http://www.osci.de/wsdl-osci-binding/WSDL-OSCI-Binding_1.2.xsd"/>
          <xsl:if test="count($service-input-messages) gt 1 or count($service-output-messages) gt 1 or count($service-fault-messages) gt 1">
            <wsdl:types>
              <xsl:apply-templates select="$wsdlService[count($service-input-messages) gt 1]" mode="lite:schema-fuer-nachrichtenmenge">
                <xsl:with-param name="messages" select="$xoev-modell/descendant::nachricht[concat(lite:prefix(.), ':', @name) = $service-input-messages]"/>
                <xsl:with-param name="art">Input</xsl:with-param>
              </xsl:apply-templates>
              <xsl:apply-templates select="$wsdlService[count($service-output-messages) gt 1]" mode="lite:schema-fuer-nachrichtenmenge">
                <xsl:with-param name="messages" select="$xoev-modell/descendant::nachricht[concat(lite:prefix(.), ':', @name) = $service-output-messages]"/>
                <xsl:with-param name="art">Output</xsl:with-param>
              </xsl:apply-templates>
              <xsl:apply-templates select="$wsdlService[count($service-fault-messages) gt 1]" mode="lite:schema-fuer-nachrichtenmenge">
                <xsl:with-param name="messages" select="$xoev-modell/descendant::nachricht[concat(lite:prefix(.), ':', @name) = $service-fault-messages]"/>
                <xsl:with-param name="art">Fault</xsl:with-param>
              </xsl:apply-templates>
            </wsdl:types>
          </xsl:if>
          <xsl:variable name="input-schema" select="$xoev-modell/descendant::nachricht[concat(lite:prefix(.), ':', @name) = $wsdlService/wsdlServiceInputMessage]/ancestor::xsdSchema"/>
          <xsl:variable name="output-schema" select="$xoev-modell/descendant::nachricht[concat(lite:prefix(.), ':', @name) = $wsdlService/wsdlServiceOutputMessage]/ancestor::xsdSchema"/>
          <xsl:variable name="fault-schema" select="$xoev-modell/descendant::nachricht[concat(lite:prefix(.), ':', @name) = $wsdlService/wsdlServiceFaultMessage]/ancestor::xsdSchema"/>
          <xsl:for-each-group select="
              $input-schema[count($service-input-messages) = 1],
              $output-schema[count($service-output-messages) = 1],
              $fault-schema[count($service-fault-messages) = 1]" group-by="@name">
            <xsl:sort select="
                (@schemaLocation,
                concat(ancestor::xoev-fachmodell/konfiguration.xoev-fachmodell/schemaLocationBase,
                @schemaFile))[1]"/>
            <xsl:variable name="schema" select="."/>
            <import namespace="{($schema/@namespace, $schema/ancestor::xoev-fachmodell/konfiguration.xoev-fachmodell/namespace)[1]}" location="{($schema/@schemaLocation, 
              concat($schema/ancestor::xoev-fachmodell/konfiguration.xoev-fachmodell/schemaLocationBase, $schema/@schemaFile))[1]}"/>
          </xsl:for-each-group>
          <xsl:apply-templates select="$wsdlService" mode="lite:message">
            <xsl:with-param name="messages" select="$service-input-messages"/>
            <xsl:with-param name="art">Input</xsl:with-param>
          </xsl:apply-templates>
          <xsl:apply-templates select="$wsdlService" mode="lite:message">
            <xsl:with-param name="messages" select="$service-output-messages"/>
            <xsl:with-param name="art">Output</xsl:with-param>
          </xsl:apply-templates>
          <xsl:apply-templates select="$wsdlService" mode="lite:message">
            <xsl:with-param name="messages" select="$service-fault-messages"/>
            <xsl:with-param name="art">Fault</xsl:with-param>
          </xsl:apply-templates>
          <xsl:apply-templates select="$wsdlService" mode="lite:port">
                        <xsl:with-param name="hat-fault-nachrichten" select="not(empty($service-fault-messages))"/>
                    </xsl:apply-templates>
          <xsl:apply-templates select="$wsdlService" mode="lite:binding">
                        <xsl:with-param name="ist-request-response" select="true()"/>
                        <xsl:with-param name="hat-fault-nachrichten" select="not(empty($service-fault-messages))"/>
                    </xsl:apply-templates>
          <xsl:apply-templates select="$wsdlService" mode="lite:service"/>
        </definitions>
      </xsl:with-param>
    </xsl:call-template>
  </xsl:template>
  <xsl:template match="wsdlService" mode="lite:standard-namespace">
    <xsl:variable name="wsdlService" select="."/>
    <xsl:choose>
      <xsl:when test="
          ancestor::xoev-fachmodell/metadaten.standard/kennung = ('urn:xoev-de:kosit:standard:xinneres.basismodul', 'urn:xoev-de:kosit:standard:xfamilie', 'urn:xoev-de:bva:standard:xbasisdaten') and
          count(wsdlServiceMessage = 1)">
        <xsl:variable name="schema" select="$xoev-modell/descendant::nachricht[concat(lite:prefix(.), ':', @name) = $wsdlService/wsdlServiceMessage]/ancestor::xsdSchema"/>
        <xsl:namespace name="{$schema/@prefix}" select="$schema/lite:namespace(.)"/>
      </xsl:when>
      <xsl:when test="
          ancestor::xoev-fachmodell/metadaten.standard/kennung = 'urn:xoev-de:bva:standard:xbasisdaten'">
        <xsl:variable name="input-schema" select="$xoev-modell/descendant::nachricht[concat(lite:prefix(.), ':', @name) = $wsdlService/wsdlServiceInputMessage]/ancestor::xsdSchema"/>
        <xsl:variable name="output-schema" select="$xoev-modell/descendant::nachricht[concat(lite:prefix(.), ':', @name) = $wsdlService/wsdlServiceOutputMessage]/ancestor::xsdSchema"/>
        <xsl:variable name="fault-schema" select="$xoev-modell/descendant::nachricht[concat(lite:prefix(.), ':', @name) = $wsdlService/wsdlServiceFaultMessage]/ancestor::xsdSchema"/>
        <xsl:for-each-group select="($input-schema, $output-schema, $fault-schema)" group-by="@name">
          <xsl:sort select="
              (@schemaLocation,
              concat(ancestor::xoev-fachmodell/konfiguration.xoev-fachmodell/schemaLocationBase,
              @schemaFile))[1]"/>
          <xsl:variable name="schema" select="."/>
          <xsl:namespace name="{$schema/@prefix}" select="$schema/lite:namespace(.)"/>
        </xsl:for-each-group>
      </xsl:when>
      <xsl:otherwise>
        <xsl:namespace name="{ancestor::xoev-fachmodell/konfiguration.xoev-fachmodell/prefix}" select="ancestor::xoev-fachmodell/konfiguration.xoev-fachmodell/namespace"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  <xsl:template match="wsdlService" mode="lite:wsdl-document-one-way-active">
    <xsl:variable name="wsdlService" select="."/>
    <xsl:variable name="service-messages" select="wsdlServiceMessage"/>
    <xsl:call-template name="xgen:result-document">
      <xsl:with-param name="local-path" select="
          if (ancestor::xoev-fachmodell/konfiguration.xoev-fachmodell/Dateipraefix = 'ModelName') then
            xs:anyURI(concat(ancestor::xoev-fachmodell/metadaten.standard/nameTechnisch, '.', lite:service-name($wsdlService), '.wsdl'))
          else
            xs:anyURI(concat(lite:service-name($wsdlService), '.wsdl'))"/>
      <xsl:with-param name="content">
        <xsl:comment> Service </xsl:comment>
        <definitions name="{lite:service-name($wsdlService)}" targetNamespace="{$wsdlService/lite:namensraum(.)}" xsi:schemaLocation="http://schemas.xmlsoap.org/wsdl/ http://schemas.xmlsoap.org/wsdl/">
          <xsl:namespace name="tns" select="lite:namensraum($wsdlService)"/>
          <xsl:apply-templates select="$wsdlService" mode="lite:standard-namespace"/>
          <xsl:variable name="begin-cdata"><![CDATA[<![CDATA[]]></xsl:variable>
          <xsl:variable name="end-cdata"><![CDATA[]]]]><![CDATA[>]]></xsl:variable>
          <documentation>
            <xsl:apply-templates select="$wsdlService" mode="lite:categories"/>
            <xsl:value-of select="xgen:unescaped-xml($begin-cdata)"/>
            <html>
              <xsl:apply-templates select="beschreibung" mode="lite:beschreibung">
                <xsl:with-param name="nachrichtenmenge" select="$service-messages"/>
              </xsl:apply-templates>
            </html>
            <xsl:value-of select="xgen:unescaped-xml($end-cdata)"/>
          </documentation>
          <import namespace="http://www.osci.de/2006/07/wsdl/" location="http://www.osci.de/wsdl-osci-binding/WSDL-OSCI-Binding_1.2.xsd"/>
          <xsl:choose>
            <xsl:when test="count(wsdlServiceMessage) = 1">
              <xsl:variable name="schema" select="$xoev-modell/descendant::nachricht[concat(lite:prefix(.), ':', @name) = $wsdlService/wsdlServiceMessage]/ancestor::xsdSchema"/>
              <import namespace="{lite:namespace($schema)}" location="{($schema/@schemaLocation, 
                              concat($schema/ancestor::xoev-fachmodell/konfiguration.xoev-fachmodell/schemaLocationBase, $schema/@schemaFile))[1]}"/>
            </xsl:when>
            <xsl:otherwise>
              <wsdl:types>
                <xsl:apply-templates select="$wsdlService[count(wsdlServiceMessage) gt 1]" mode="lite:schema-fuer-nachrichtenmenge">
                  <xsl:with-param name="messages" select="$xoev-modell/descendant::nachricht[concat(lite:prefix(.), ':', @name) = $wsdlService/wsdlServiceMessage]"/>
                  <xsl:with-param name="art"/>
                </xsl:apply-templates>
              </wsdl:types>
            </xsl:otherwise>
          </xsl:choose>
          <xsl:apply-templates select="$wsdlService" mode="lite:message">
            <xsl:with-param name="messages" select="$service-messages"/>
            <xsl:with-param name="art"/>
          </xsl:apply-templates>
          <xsl:variable name="wsdlService-upper-camel-case" select="
              concat(upper-case(substring($wsdlService/@name, 1, 1)), substring($wsdlService/@name, 2, string-length($wsdlService/@name)))"/>
          <xsl:apply-templates select="$wsdlService" mode="lite:port">
            <xsl:with-param name="ist-one-way-active" select="true()"/>
          </xsl:apply-templates>
          <xsl:apply-templates select="$wsdlService" mode="lite:binding"/>
          <xsl:apply-templates select="$wsdlService" mode="lite:service"/>
        </definitions>
      </xsl:with-param>
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="wsdlService" mode="lite:categories">
    <xsl:variable name="kategorien" select="KategorieDesDienstanbieters"/>
    <xsl:if test="not(empty($kategorien))">
      <tpl:categories>
        <xsl:for-each select="$kategorien">
          <xsl:sort select="."/>
          <tpl:category>
            <xsl:value-of select="."/>
          </tpl:category>
        </xsl:for-each>
      </tpl:categories>
    </xsl:if>
  </xsl:template>

  <xsl:template match="beschreibung" mode="lite:beschreibung">
    <xsl:param name="nachrichtenmenge" as="element()*"/>
    <xsl:param name="service-input-messages" as="element()*"/>
    <xsl:param name="service-output-messages" as="element()*"/>
    <xsl:param name="service-fault-messages" as="element()*"/>
    <xsl:apply-templates select="@* | node()">
      <xsl:with-param name="nachrichtenmenge" select="$nachrichtenmenge"/>
      <xsl:with-param name="service-input-messages" select="$service-input-messages"/>
      <xsl:with-param name="service-output-messages" select="$service-output-messages"/>
      <xsl:with-param name="service-fault-messages" select="$service-fault-messages"/>
    </xsl:apply-templates>
  </xsl:template>

  <xsl:template match="html:servicelist">
    <xsl:param name="nachrichtenmenge" as="element()*"/>
    <ul>
      <xsl:for-each select="$nachrichtenmenge">
        <xsl:sort select="tokenize(., '\.')[last()]"/>
        <li>
          <xsl:value-of select="substring-after(., ':')"/>
        </li>
      </xsl:for-each>
    </ul>
  </xsl:template>

  <xsl:template match="html:serviceInputList">
    <xsl:param name="service-input-messages" as="element()*"/>
    <ul>
      <xsl:for-each select="$service-input-messages">
        <xsl:sort select="tokenize(., '\.')[last()]"/>
        <li>
          <xsl:value-of select="substring-after(., ':')"/>
        </li>
      </xsl:for-each>
    </ul>
  </xsl:template>

  <xsl:template match="html:serviceOutputList">
    <xsl:param name="service-output-messages" as="element()*"/>
    <ul>
      <xsl:for-each select="$service-output-messages">
        <xsl:sort select="tokenize(., '\.')[last()]"/>
        <li>
          <xsl:value-of select="substring-after(., ':')"/>
        </li>
      </xsl:for-each>
    </ul>
  </xsl:template>

  <xsl:template match="html:serviceFaultList">
    <xsl:param name="service-fault-messages" as="element()*"/>
    <ul>
      <xsl:for-each select="$service-fault-messages">
        <xsl:sort select="tokenize(., '\.')[last()]"/>
        <li>
          <xsl:value-of select="substring-after(., ':')"/>
        </li>
      </xsl:for-each>
    </ul>
  </xsl:template>

  <xsl:template match="html:*">
    <xsl:param name="nachrichtenmenge" as="element()*"/>
    <xsl:param name="service-input-messages" as="element()*"/>
    <xsl:param name="service-output-messages" as="element()*"/>
    <xsl:param name="service-fault-messages" as="element()*"/>
    <xsl:element name="{local-name()}">
      <xsl:apply-templates select="@* | node()">
        <xsl:with-param name="nachrichtenmenge" select="$nachrichtenmenge"/>
        <xsl:with-param name="service-input-messages" select="$service-input-messages"/>
        <xsl:with-param name="service-output-messages" select="$service-output-messages"/>
        <xsl:with-param name="service-fault-messages" select="$service-fault-messages"/>
      </xsl:apply-templates>
    </xsl:element>
  </xsl:template>

  <xsl:template match="@* | node()">
    <xsl:param name="nachrichtenmenge" as="element()*"/>
    <xsl:param name="service-input-messages" as="element()*"/>
    <xsl:param name="service-output-messages" as="element()*"/>
    <xsl:param name="service-fault-messages" as="element()*"/>
    <xsl:copy>
      <xsl:apply-templates select="@* | node()">
        <xsl:with-param name="nachrichtenmenge" select="$nachrichtenmenge"/>
        <xsl:with-param name="service-input-messages" select="$service-input-messages"/>
        <xsl:with-param name="service-output-messages" select="$service-output-messages"/>
        <xsl:with-param name="service-fault-messages" select="$service-fault-messages"/>
      </xsl:apply-templates>
    </xsl:copy>
  </xsl:template>
</xsl:stylesheet>
