<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
   xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xd="http://www.oxygenxml.com/ns/doc/xsl"
   xmlns:db="http://docbook.org/ns/docbook"
   xmlns:gc="http://docs.oasis-open.org/codelist/ns/genericode/1.0/"
   xmlns:log="http://www.xoev.de/de/xgenerator/framework/1/log"
   xmlns:xoev-cl-2="http://xoev.de/schemata/genericode/2"
   xmlns:xoev-cl-4="http://xoev.de/schemata/genericode/4"
   xmlns:lite="urn:xoev-de:kosit:xoev:lite:transformation_1.2.0"
   xmlns:lite-bib="urn:xoev-de:kosit:xoev:lite:schema:bibliothek_1.2.0"
   xmlns:lite-fm="urn:xoev-de:kosit:xoev:lite:schema:fachmodell_1.2.0"
   xmlns:xgen="http://www.xoev.de/de/xgenerator/framework/1/library"
   xmlns="http://docbook.org/ns/docbook"
   xpath-default-namespace="urn:xoev-de:kosit:xoev:lite:schema:fachmodell_1.2.0" version="2.0"
   exclude-result-prefixes="xgen xsl xs db gc log xoev-cl-2 xoev-cl-4 lite lite-fm lite-bib">

   <xd:doc scope="stylesheet">
      <xd:desc>
         <xd:p>Dieses Stylesheet generiert einen vollständigen Abschnitt zu Codelisten mit
            Übersichtstabellen.</xd:p>
      </xd:desc>
   </xd:doc>


   <xd:doc>
      <xd:desc>
         <xd:p>Einstiegspunkt für die Generierung</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="/" mode="lite:codelistenuebersicht-entry">
      <xsl:apply-templates select="/" mode="lite:codelistenuebersicht"/>
   </xsl:template>

   <xd:doc>
      <xd:desc>
         <xd:p>Erzeuge Datei codelistenGesamt.xml in
            dokumente/anhang/codelisten</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="/" mode="lite:codelistenuebersicht">
      <!-- Diese Variablen verweisen auf den Ordner in dem ein Datei gespeichert werden soll -->
      <xsl:variable name="document-directory" select="'dokumente/anhang/codelisten'"
         as="xs:string"/>
     
      <!-- Diese Variable enthält den Content einer zu erzeugenden Datei. -->
      <xsl:variable name="content">
         <xsl:apply-templates select="." mode="lite:codelistenuebersicht-content"/>
      </xsl:variable>

      <!-- Hier wird das Template zur Dateierzeugung aufgerufen -->
      <xsl:call-template name="lite:write-file-return-log">
         <xsl:with-param name="content" select="$content"/>
         <xsl:with-param name="local-path"
            select="xs:anyURI(concat($document-directory, '/codelistenGesamt.xml'))"/>
      </xsl:call-template>

   </xsl:template>

   <xd:doc>
      <xd:desc>
         <xd:p>Erzeuge den Content für einen vollständigen Abschnitt zu Codelisten mit
            Übersichtstabellen.</xd:p>
         <xd:p> Der Abschnitt besteht aus folgenden Unterabschnitten: <xd:ul>
               <xd:li>Übersichtstabelle mit Codelisten vom Einbindungstyp 3</xd:li>
               <xd:li>Übersichtstabelle mit Codelistenversionen vom Einbindungstyp 1 und 2</xd:li>
               <xd:li>Detailabschnitte mit den Inhalten der Codelistenversionen vom Einbindungstyp 1
                  und 2</xd:li>
            </xd:ul>
         </xd:p>
         <xd:p>Wenn der Standard eine der Codelistenkategorien nicht enthält wird der entsprechende
            Unterabschnitt nicht erzeugt.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="." mode="lite:codelistenuebersicht-content">

      <!-- TODOs / zu klären
         - Spalten in Inhaltstabelle sortieren (erst Codes, dann Beschreibungen)?
         - Spaltenbreite klären (Problem u.a. Spalte Version in XBildung)
         -->

      <xsl:variable name="nameStandard" select="$xoev-modell/metadaten.standard/nameKurz"/>

      <!-- Sammeln der Codedatentypen für die beiden Übersichtslisten -->

      <xsl:variable name="codeDatentypen_3" select="//codeDatentyp[@kennung][not(@version)][not(@draft = 'true')]"/>
      <xsl:variable name="codeDatentypen_1_2" select="//codeDatentyp[@kennung][@version][not(@draft = 'true')]"/>
      
      <!-- Sammeln der Codelisten, die von CodeDatentypen eines externen Modells genutzt werden -->
      
      <xsl:variable name="nutztCodeliste_3" select="//nutztCodeliste[@kennung][not(@version)][not(@draft = 'true')]"/>
      <xsl:variable name="nutztCodeliste_1_2" select="//nutztCodeliste[@kennung][@version][not(@draft = 'true')]"/>
      

      <!-- [Gesamter Abschnitt] -->
      
         
         <appendix xmlns="http://docbook.org/ns/docbook" version="5" xml:lang="de" xml:id="schluesseltabellen">
            <title xmlns:xlink="http://www.w3.org/1999/xlink">Codelisten</title>
            
            <xsl:choose>
               <xsl:when test="empty($codeDatentypen_1_2) and empty($codeDatentypen_3)"> 
                  <para>Hinweis: In diesem Standard werden keine Codelisten verwendet.</para> 
                  <!-- Datei wird erzeugt, aber Einbindung bleibt dem Standard überlassen. -->
               </xsl:when>
               <xsl:otherwise>
              
            
            <para xmlns:xlink="http://www.w3.org/1999/xlink"> In diesem Abschnitt sind die in
               <xsl:value-of select="$nameStandard"/> verwendeten Codelisten und ihre Inhalte
               aufgeführt. </para>
            
            <!-- [Übersicht Codelisten (Typ 3)] -->
            
            <xsl:if test="not(empty($codeDatentypen_3 | $nutztCodeliste_3))">
               <section xmlns:xlink="http://www.w3.org/1999/xlink"
                  xml:id="schluesseltabellen.uebersicht.codelisten">
                  <title>Übersicht Codelisten (Typ 3)</title>
                  
                  <para>In der nachstehenden Tabelle werden die folgenden Informationen
                     dargestellt:</para>
                  <variablelist>
                     <varlistentry>
                        <term>Kennung</term>
                        <listitem>
                           <para>Die Kennungen aller in <xsl:value-of select="$nameStandard"/> über
                              einen Code-Typ 3 genutzten Codelisten in alphabetischer
                              Reihenfolge.<footnote xml:id="no-entry-3">
                                 <para>Sofern in der Spalte „Code-Datentyp(en)“ kein Eintrag
                                    vorhanden ist, bedeutet dies, dass der Standard die jeweilige
                                    Codeliste verwendet und dokumentieren möchte. Der die Codeliste
                                    nutzende Code-Datentyp ist jedoch nicht im Standard selbst
                                    spezifiziert, sondern in einem externen Modell.</para>
                              </footnote>
                           </para>
                        </listitem>
                     </varlistentry>
                     <varlistentry>
                        <term>Code-Datentyp(en)</term>
                        <listitem>
                           <para>Die die jeweilige Codeliste nutzenden Code-Datentypen.<footnoteref
                              linkend="no-entry-3"/>
                           </para>
                        </listitem>
                     </varlistentry>
                  </variablelist>
                  
                  <para>Die Kennungen stellen Links zur jeweiligen Codeliste im XRepository dar. Die
                     Namen der Code-Datentypen stellen Links zu den jeweiligen Detail-Abschnitten
                     dar.</para>
                  <informaltable version="5" xml:lang="de"
                     xml:id="codelisten-typ3-uebersichtstabelle">
                     <tgroup cols="2">
                        <colspec colnum="1" colname="kennung" colwidth="90mm"/>
                        <colspec colnum="2" colname="code" colwidth="70mm"/>
                        <thead>
                           <row>
                              <entry>Kennung</entry>
                              <entry>Code-Datentyp(en)</entry>
                           </row>
                        </thead>
                        <tbody>
                           <!-- Eine Codeliste kann von mehreren Codedatentypen verwendet werden.
                              Die Codedatentypen werden daher nach Codelisten (identifiziert über die Kennung) gruppiert. -->
                           <xsl:for-each-group select="$codeDatentypen_3 | $nutztCodeliste_3" group-by="@kennung">
                              <xsl:sort select="@kennung"/>
                              <row>
                                 <entry align="left">
                                    <!-- Gruppierschlüssel ist die Codelistenkennung. -->
                                    <link role="schwarz"
                                       xlink:href="{concat('https://www.xrepository.de/details/', current-grouping-key())}">
                                       <xsl:value-of select="@kennung"/>
                                    </link>
                                 </entry>
                                 <entry align="left">
                                    <!-- Innerhalb der Tabellenzelle ein oder mehrere Codedatentypen zur Codeliste -->
                                    <xsl:for-each select="current-group()[self::codeDatentyp]">
                                       <para role="codeDatentyp">
                                          <link role="schwarz" linkend="{lite:docbook-id(.)}">
                                             <xsl:value-of select="@name"/>
                                          </link>
                                       </para>
                                    </xsl:for-each>
                                 </entry>
                              </row>
                           </xsl:for-each-group>
                        </tbody>
                     </tgroup>
                  </informaltable>
               </section>
            </xsl:if>
            
            
            <!-- [Übersicht Codelistenversionen (Typ 1 und 2)] -->
            
            
            <xsl:if test="not(empty($codeDatentypen_1_2 | $nutztCodeliste_1_2))">
               <section xmlns:xlink="http://www.w3.org/1999/xlink"
                  xml:id="schluesseltabellen.uebersicht.codelistenversionen">
                  <title>Übersicht Codelistenversionen (Typ 1 und 2)</title>
                  
                  <para>In der nachstehenden Tabelle werden die folgenden Informationen
                     dargestellt:</para>
                  <variablelist>
                     <varlistentry>
                        <term>Codeliste</term>
                        <listitem>
                           <para>Alle in <xsl:value-of select="$nameStandard"/> genutzten
                              Codelistenversionen in alphabetischer Reihenfolge, die in mindestens
                              einem Code-Datentyp genutzt werden (Typ der Codelistennutzung 1 bis
                              2).<footnote xml:id="no-entry-12">
                                 <para>Sofern in der Spalte „Code-Datentyp(en)“ kein Eintrag
                                    vorhanden ist, bedeutet dies, dass der Standard die jeweilige
                                    Codeliste verwendet und dokumentieren möchte. Der die Codeliste
                                    nutzende Code-Datentyp ist jedoch nicht im Standard selbst
                                    spezifiziert, sondern in einem externen Modell.</para>
                              </footnote>
                           </para>
                        </listitem>
                     </varlistentry>
                     <varlistentry>
                        <term>Version</term>
                        <listitem>
                           <para>Die Version der Codeliste.</para>
                        </listitem>
                     </varlistentry>
                     <varlistentry>
                        <term>Code-Datentyp(en)</term>
                        <listitem>
                           <para>Die die jeweilige Codeliste nutzenden Code-Datentypen.<footnoteref
                              linkend="no-entry-12"/>
                           </para>
                        </listitem>
                     </varlistentry>
                  </variablelist>
                  <para>Die Namen der Code-Datentypen und der Codelisten stellen Links zu den
                     jeweiligen Detail-Abschnitten dar.</para>
                  <informaltable version="5" xml:lang="de" xml:id="codelisten-uebersichtstabelle">
                     <tgroup cols="3">
                        <colspec colnum="1" colname="codeliste" colwidth="73mm"/>
                        <colspec colnum="2" colname="version" colwidth="14mm"/>
                        <colspec colnum="3" colname="code" colwidth="73mm"/>
                        <thead>
                           <row>
                              <entry>Codeliste</entry>
                              <entry>Version</entry>
                              <entry>Code-Datentyp(en)</entry>
                           </row>
                        </thead>
                        <tbody>
                           <xsl:for-each-group select="$codeDatentypen_1_2 | $nutztCodeliste_1_2" group-by="@kennung">
                              <xsl:sort select="lite:codeliste-nameKurz(lite:genutzte-cl-oder-vcl(.))"/>
                              <row>
                                 <entry align="left">
                                    <link role="schwarz"
                                       linkend="{replace(concat('tabelle.', @kennung), ':', '.')}">
                                       <xsl:choose>
                                          <xsl:when test="empty(lite:codeliste-nameKurz(lite:genutzte-cl-oder-vcl(.)))">
                                             <emphasis role="rot">Codeliste besitzt keinen Namen (kurz)</emphasis>
                                          </xsl:when>
                                          <xsl:otherwise>
                                             <xsl:value-of select="lite:codeliste-nameKurz(lite:genutzte-cl-oder-vcl(.))"/>
                                          </xsl:otherwise>
                                       </xsl:choose>
                                    </link>
                                 </entry>
                                 <entry align="left">
                                    <!-- zwecks Trennbarkeit breitenlose Leerzeichen eingefügt -->
                                    <xsl:value-of select="replace(@version,'(.)',concat('$1',xgen:unescaped-xml('&amp;'), '#x200B;'))"/>
                                 </entry>
                                 <entry align="left">
                                    <xsl:for-each select="current-group()[self::codeDatentyp]">
                                       <para role="codeDatentyp">
                                          <link role="schwarz" linkend="{lite:docbook-id(.)}">
                                             <xsl:value-of select="@name"/>
                                          </link>
                                       </para>
                                    </xsl:for-each>
                                 </entry>
                              </row>
                           </xsl:for-each-group>
                        </tbody>
                     </tgroup>
                  </informaltable>
               </section>
               
               <!-- [Details zu den Codelisten]-->
               
               <xsl:if test="not(empty($gc-codelisten))">
                  <section xmlns:xlink="http://www.w3.org/1999/xlink" xml:id="schluesseltabellen.details">
                     
                     <title>Details</title>
                     
                     <xsl:apply-templates select="$codeDatentypen_1_2 | $nutztCodeliste_1_2" mode="lite:codelistenuebersicht-detail">
                        <xsl:sort select="lite:codeliste-nameKurz(lite:genutzte-cl-oder-vcl(.))"/>
                     </xsl:apply-templates>
                     
                  </section>
               </xsl:if>
            </xsl:if>

            
            <!-- Alternative mit Hinweis auf nicht vorhandene Codelisten:
               <xsl:choose>
               <xsl:when test="empty($codeDatentypen_1_2)"> 
               <para>Dieser Standard enthält keine Codelisten
               vom Typ 1 oder 2.</para> 
               </xsl:when>
               <xsl:otherwise>
               </xsl:otherwise>
               </xsl:choose>
            -->
               </xsl:otherwise>
            </xsl:choose>

         </appendix>
      
   </xsl:template>
   
   
   <xd:doc>
      <xd:desc><xd:p>Prüft, ob alle übergebenen Strings Zahlen darstellen. Dient hier zur Entscheidung, ob die Code-Spalte numerisch sortiert werden kann.</xd:p></xd:desc>
      <xd:param name="strings"><xd:p>String-Sequenz, hier Inhalte der Code-Spalte</xd:p></xd:param>
   </xd:doc>
   <xsl:function name="lite:is-integer-sequence" as="xs:boolean">
      <xsl:param name="strings" as="xs:string*" />
      <xsl:sequence select="every $str in $strings satisfies number($str) = number($str) and not(contains($str, 'NaN'))" />
   </xsl:function>

   <xd:doc>
      <xd:desc>
         <xd:p>Dieses Template erzeugt für jede Codeliste Typ 1 oder 2 einen Detail-Abschnitt mit Metadaten und Inhalten.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="codeDatentyp | nutztCodeliste" mode="lite:codelistenuebersicht-detail">
   <!-- Jeder Detail-Abschnitt zu einer Codeliste soll auf einer neuen Seite beginnen. -->
   <xsl:if test="position() &gt; 1">
      <xsl:processing-instruction name="KoSIT-FO">hard-pagebreak</xsl:processing-instruction>
   </xsl:if>
   
   <xsl:variable name="codeliste" select="lite:genutzte-cl-oder-vcl(.)"/>
   
   <!-- Section-Id in der Form: tabelle.urn.xoev-de.xdomea.codeliste.datenaustauschart.datenaustauschart
               Doppelpunkte werden durch Punkte ersetzt. -->
   <section xml:id="{replace(concat('tabelle.', @kennung), ':', '.')}">
      
      <title>
         <xsl:choose>
            <xsl:when test="empty(lite:codeliste-nameKurz($codeliste))">
               <emphasis role="rot">Codeliste besitzt keinen Namen (kurz)</emphasis>
            </xsl:when>
            <xsl:otherwise>
               <xsl:value-of select="lite:codeliste-nameKurz($codeliste)"/>
            </xsl:otherwise>
         </xsl:choose>
      </title>
      
      <!-- alternativ: Beschreibung(en) in der Metadatentabelle -->
      <!--<para>
         <xsl:value-of select="lite:codeliste-beschreibung($codeliste)"/>
      </para>
      <para>
         <xsl:value-of select="lite:versioncodeliste-beschreibung($codeliste)"/>
      </para>-->
      
      <xsl:variable name="codespalte" select="lite:genutzte-code-spalte(., $codeliste)"/>
      <xsl:variable name="codewerte" select="for $zeile in lite:versioncodeliste-zeilen($codeliste) return (lite:versioncodeliste-zeile-spaltenwert($zeile, $codespalte))"/>
      <xsl:variable name="ist-numerisch" select="lite:is-integer-sequence($codewerte)"/>
      
      
      <xsl:apply-templates select="$codeliste" mode="lite:codelistenuebersicht-detail-metadaten"/>
       
      <xsl:apply-templates select="$codeliste" mode="lite:codelistenuebersicht-detail-inhalt">
         <xsl:with-param name="codespalte" select="$codespalte"/>
         <xsl:with-param name="numerische-codes" select="$ist-numerisch"/>
      </xsl:apply-templates>
      
   </section>
</xsl:template>

   <xd:doc>
      <xd:desc>
         <xd:p>Dieses Template erzeugt für jede Codeliste Typ 1 oder 2 einen Abschnitt mit Metadaten.</xd:p>
      </xd:desc>
   </xd:doc>
<xsl:template match="element()" mode="lite:codelistenuebersicht-detail-metadaten">
   <section>
      <title>Metadaten</title>
      <informaltable>
         <tgroup cols="2">
            <colspec colnum="1" colname="meta" colwidth="30mm" align="left"/>
            <colspec colnum="2" colname="wert" colwidth="130mm"/>
            <thead>
               <row>
                  <entry>Metadatenelement</entry>
                  <entry>Wert</entry>
               </row>
            </thead>
            <tbody>
               <row>
                  <entry>Name (lang)</entry>
                  <entry>
                     <xsl:value-of select="lite:codeliste-nameLang(.)"/>
                  </entry>
               </row>
               <row>
                  <entry>Name (kurz)</entry>
                  <entry>
                     <xsl:value-of select="lite:codeliste-nameKurz(.)"/>
                  </entry>
               </row>
               <row>
                  <entry>Kennung</entry>
                  <entry>
                     <xsl:value-of select="lite:codeliste-kennung(.)"/>
                  </entry>
               </row>
               <xsl:if test="not(empty(lite:codeliste-beschreibung(.)))">
                  <row>
                     <entry>Beschreibung der Codeliste</entry>
                     <entry>
                        <xsl:value-of select="lite:codeliste-beschreibung(.)"/>
                     </entry>
                  </row>
               </xsl:if>
               <xsl:if test="not(empty(lite:versioncodeliste-beschreibung(.)))">
                  <row>
                     <entry>Beschreibung der Codelistenversion</entry>
                     <entry>
                        <xsl:value-of select="lite:versioncodeliste-beschreibung(.)"/>
                     </entry>
                  </row>
               </xsl:if>
               <row>
                  <entry>Herausgeber</entry>
                  <entry>
                     <xsl:value-of
                        select="lite:codeliste-herausgebernameLang(.)"/>
                     <xsl:if test="not(empty(lite:codeliste-herausgebernameKurz(.)))">
                        <xsl:value-of
                           select="concat(' (', lite:codeliste-herausgebernameKurz(.),')')"/>
                     </xsl:if>
                  </entry>
               </row>
               <row>
                  <entry>Version</entry>
                  <entry>
                     <xsl:value-of
                        select="lite:versioncodeliste-version(.)"/>
                  </entry>
               </row>
               <xsl:variable name="gueltigAb"
                  select="lite:versioncodeliste-datumGueltigkeitAb(.)"/>
               <xsl:if test="not(empty($gueltigAb))">
                  <row>
                     <entry>Gültigkeit ab</entry>
                     <entry>
                        <xsl:value-of select="$gueltigAb"/>
                     </entry>
                  </row>
               </xsl:if>
            </tbody>
         </tgroup>
      </informaltable>
   </section>
</xsl:template>

   <xd:doc>
      <xd:desc>
         <xd:p>Dieses Template erzeugt für jede Codeliste Typ 1 oder 2 eine Tabelle der Codelisteneinträge.</xd:p>
      </xd:desc>
      <xd:param name="codespalte"><xd:p>Verwendete Codespalte, nach dieser soll sortiert werden.</xd:p></xd:param>
      <xd:param name="numerische-codes"><xd:p>true, wenn alle Codes Zahlen darstellen, so dass numerisch sortiert werden kann.</xd:p></xd:param>
   </xd:doc>
<xsl:template match="element()" mode="lite:codelistenuebersicht-detail-inhalt">
   <xsl:param name="codespalte"/>
   <xsl:param name="numerische-codes"/>
   <section>
      <title>Daten</title>
      
      <informaltable>
         <xsl:variable name="spalten"
            select="lite:versioncodeliste-spalten(.)"/>
         <xsl:variable name="spaltenzahl" select="count($spalten)" as="xs:integer"/>
         <tgroup cols="{count($spalten)}">
            
          
            <!-- Für mehrspaltige Codelisten, es wird ein choice mit colspecs für 2-7 Spalten verwendet -->
            <!-- Eine Variante zur Einbindung über ein Template, eine als Funktion -->
            <!-- <xsl:copy-of select="lite:codelist-colspecs($spaltenzahl)"/> -->
            <xsl:apply-templates select="."
               mode="codelistenuebersicht-colspec"/>
            
            <thead>
               <row>
                  <xsl:for-each select="$spalten">
                     <entry align="left">
                        <xsl:value-of
                           select="lite:versioncodeliste-spalte-spaltennameTechnisch(.)"
                        />
                        <xsl:variable name="nameLang" select="lite:versioncodeliste-spalte-spaltennameLang(.)"/>
                        <xsl:if test="exists($nameLang) and not(normalize-space($nameLang)='')">
                           <xsl:value-of
                              select="concat(' (',$nameLang,')')"
                           />
                        </xsl:if>
                     </entry>
                  </xsl:for-each>
               </row>
            </thead>
            <tbody>
               <xsl:for-each select="lite:versioncodeliste-zeilen(.)">
                  <xsl:sort select="lite:versioncodeliste-zeile-spaltenwert(., $codespalte)" data-type="{if ($numerische-codes) then 'number' else 'text'}"/>
                  <xsl:variable name="zeile" select="."/>
                  <row>
                     <xsl:for-each select="$spalten">
                        <entry align="left">
                           <xsl:value-of
                              select="lite:versioncodeliste-zeile-spaltenwert($zeile, lite:versioncodeliste-spalte-spaltennameTechnisch(.))"
                           />
                        </entry>
                     </xsl:for-each>
                  </row>
               </xsl:for-each>
            </tbody>
         </tgroup>
      </informaltable>
   </section>
</xsl:template>

   <xd:doc>
      <xd:desc>
         <xd:p>Gib die colspec-Elemente für die Tabellen der Codelisten-Inhalte zurück.</xd:p>
         <xd:p>Es werden zwei bis sieben Spalten unterstützt, mehr sind bisher nicht
            vorgekommen.</xd:p>
         <xd:p>Die Spaltenbreiten werden fest vorgegeben in Millimetern.</xd:p>
         <xd:p>Diese Funktion ist eine Alternative zum Template mit
            mode="codelistenuebersicht-colspec"</xd:p>
      </xd:desc>
      <xd:param name="spaltenanzahl"/>
   </xd:doc>
   <xsl:function name="lite:codelist-colspecs" as="element()*">
      <xsl:param name="spaltenanzahl" as="xs:integer*"/>
      <xsl:sequence>
         <xsl:choose>
            <xsl:when test="$spaltenanzahl = 7">
               <colspec colnum="1" colname="col1" colwidth="22mm"/>
               <colspec colnum="2" colname="col2" colwidth="23mm"/>
               <colspec colnum="3" colname="col3" colwidth="23mm"/>
               <colspec colnum="4" colname="col4" colwidth="23mm"/>
               <colspec colnum="5" colname="col5" colwidth="23mm"/>
               <colspec colnum="6" colname="col6" colwidth="23mm"/>
               <colspec colnum="7" colname="lastcol" colwidth="23mm"/>
            </xsl:when>
            <xsl:when test="$spaltenanzahl = 6">
               <colspec colnum="1" colname="col1" colwidth="25mm"/>
               <colspec colnum="2" colname="col2" colwidth="27mm"/>
               <colspec colnum="3" colname="col3" colwidth="27mm"/>
               <colspec colnum="4" colname="col4" colwidth="27mm"/>
               <colspec colnum="5" colname="col5" colwidth="27mm"/>
               <colspec colnum="6" colname="lastcol" colwidth="27mm"/>
            </xsl:when>
            <xsl:when test="$spaltenanzahl = 5">
               <colspec colnum="1" colname="col1" colwidth="24mm"/>
               <colspec colnum="2" colname="col2" colwidth="34mm"/>
               <colspec colnum="3" colname="col3" colwidth="34mm"/>
               <colspec colnum="4" colname="col4" colwidth="34mm"/>
               <colspec colnum="5" colname="lastcol" colwidth="34mm"/>
            </xsl:when>
            <xsl:when test="$spaltenanzahl = 4">
               <colspec colnum="1" colname="col1" colwidth="25mm"/>
               <colspec colnum="2" colname="col2" colwidth="45mm"/>
               <colspec colnum="3" colname="col3" colwidth="45mm"/>
               <colspec colnum="4" colname="lastcol" colwidth="45mm"/>
            </xsl:when>
            <xsl:when test="$spaltenanzahl = 3">
               <colspec colnum="1" colname="key" colwidth="25mm"/>
               <colspec colnum="2" colname="val" colwidth="65mm"/>
               <colspec colnum="3" colname="desc" colwidth="70mm"/>
            </xsl:when>
            <xsl:otherwise>
               <colspec colnum="1" colname="key" colwidth="25mm"/>
               <colspec colnum="2" colname="val" colwidth="135mm"/>
            </xsl:otherwise>
         </xsl:choose>
      </xsl:sequence>
   </xsl:function>


   <xd:doc>
      <xd:desc>
         <xd:p>Erzeuge die colspec-Elemente für die Tabellen der Codelisten-Inhalte</xd:p>
         <xd:p>Es werden zwei bis sieben Spalten unterstützt, mehr sind bisher nicht
            vorgekommen.</xd:p>
         <xd:p>Die Spaltenbreiten werden fest vorgegeben in Millimetern.</xd:p>
         <xd:p>Dieses Template ist eine Alternative zur Funktion lite:codelist-colspecs</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="element()" mode="codelistenuebersicht-colspec">
      <xsl:variable name="spaltenanzahl" select="count(lite:versioncodeliste-spalten(.))"
         as="xs:integer"/>
      <xsl:choose>
         <xsl:when test="$spaltenanzahl = 7">
            <colspec colnum="1" colname="col1" colwidth="22mm"/>
            <colspec colnum="2" colname="col2" colwidth="23mm"/>
            <colspec colnum="3" colname="col3" colwidth="23mm"/>
            <colspec colnum="4" colname="col4" colwidth="23mm"/>
            <colspec colnum="5" colname="col5" colwidth="23mm"/>
            <colspec colnum="6" colname="col6" colwidth="23mm"/>
            <colspec colnum="7" colname="lastcol" colwidth="23mm"/>
         </xsl:when>
         <xsl:when test="$spaltenanzahl = 6">
            <colspec colnum="1" colname="col1" colwidth="25mm"/>
            <colspec colnum="2" colname="col2" colwidth="27mm"/>
            <colspec colnum="3" colname="col3" colwidth="27mm"/>
            <colspec colnum="4" colname="col4" colwidth="27mm"/>
            <colspec colnum="5" colname="col5" colwidth="27mm"/>
            <colspec colnum="6" colname="lastcol" colwidth="27mm"/>
         </xsl:when>
         <xsl:when test="$spaltenanzahl = 5">
            <colspec colnum="1" colname="col1" colwidth="24mm"/>
            <colspec colnum="2" colname="col2" colwidth="34mm"/>
            <colspec colnum="3" colname="col3" colwidth="34mm"/>
            <colspec colnum="4" colname="col4" colwidth="34mm"/>
            <colspec colnum="5" colname="lastcol" colwidth="34mm"/>
         </xsl:when>
         <xsl:when test="$spaltenanzahl = 4">
            <colspec colnum="1" colname="col1" colwidth="25mm"/>
            <colspec colnum="2" colname="col2" colwidth="45mm"/>
            <colspec colnum="3" colname="col3" colwidth="45mm"/>
            <colspec colnum="4" colname="lastcol" colwidth="45mm"/>
         </xsl:when>
         <xsl:when test="$spaltenanzahl = 3">
            <colspec colnum="1" colname="key" colwidth="25mm"/>
            <colspec colnum="2" colname="val" colwidth="65mm"/>
            <colspec colnum="3" colname="desc" colwidth="70mm"/>
         </xsl:when>
         <xsl:otherwise>
            <colspec colnum="1" colname="key" colwidth="25mm"/>
            <colspec colnum="2" colname="val" colwidth="135mm"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

</xsl:stylesheet>
