<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
   xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:db="http://docbook.org/ns/docbook"
   xmlns:gc="http://docs.oasis-open.org/codelist/ns/genericode/1.0/"
   xmlns:log="http://www.xoev.de/de/xgenerator/framework/1/log"
   xmlns:xoev-cl-2="http://xoev.de/schemata/genericode/2"
   xmlns:xoev-cl-4="http://xoev.de/schemata/genericode/4"
   xmlns:lite="urn:xoev-de:kosit:xoev:lite:transformation_1.2.0"
   xmlns:lite-bib="urn:xoev-de:kosit:xoev:lite:schema:bibliothek_1.2.0"
   xmlns:lite-fm="urn:xoev-de:kosit:xoev:lite:schema:fachmodell_1.2.0"
   xmlns:xgen="http://www.xoev.de/de/xgenerator/framework/1/library"
   xmlns="http://docbook.org/ns/docbook"
   xpath-default-namespace="urn:xoev-de:kosit:xoev:lite:schema:fachmodell_1.2.0"
   version="2.0"
   exclude-result-prefixes="xgen xsl xs db gc log xoev-cl-2 xoev-cl-4 lite lite-fm lite-bib">


   <!-- Einstiegspunkt für die Generierung -->
   <xsl:template match="/" mode="lite:code-datentyp-codelisten">
      <xsl:apply-templates select="xoev-fachmodell" mode="lite:code-datentyp-codelisten-uebersicht"
      />
   </xsl:template>

   <!-- Erzeuge Übersicht Codelisten -->
   <xsl:template match="xoev-fachmodell" mode="lite:code-datentyp-codelisten-uebersicht">

      <xsl:variable name="document-directory" select="'dokumente/anhang/codeDatentypen'"
         as="xs:string"/>
      <xsl:variable name="target-document-directory"
         select="(concat($document-directory, '/', 'codeDatentypenTabelleGesamt.xml'))"
         as="xs:string"/>
      <xsl:variable name="codeDatentypen_3"
         select="//codeDatentyp[@kennung][not(@version)][not(@draft = 'true')]"/>
      <xsl:variable name="codeDatentypen_1_2_4"
         select="//codeDatentyp[@kennung][@version][not(@draft = 'true')] | //codeDatentyp[not(@kennung)][not(@version)]"/>
      <xsl:variable name="fachmodell-kurz" select="//nameKurz" as="xs:string"/>
      <xsl:variable name="content">
         <appendix xmlns="http://docbook.org/ns/docbook" version="5">
            <title>Übersicht Code-Datentypen</title>

            <xsl:choose>
               <xsl:when test="empty($codeDatentypen_1_2_4) and empty($codeDatentypen_3)">
                  <para>Hinweis: Dieser Standard enthält keine Code-Datentypen.</para>
                  <!-- Datei wird erzeugt, aber Einbindung bleibt dem Standard überlassen. -->
               </xsl:when>
               <xsl:otherwise>
                  <para>In diesem Abschnitt sind die in <xsl:value-of select="$fachmodell-kurz"/>
                     verwendeten Code-Datentypen in der Übersicht dargestellt.</para>
                  <!-- Codelisten typ 3 -->
                  <xsl:if test="exists($codeDatentypen_3)">
                     <section>
                        <title>Code-Typ 3</title>
                        <para>In der nachstehenden Tabelle werden die folgenden Informationen
                           dargestellt:</para>
                        <variablelist>
                           <varlistentry>
                              <term>Code-Datentyp</term>
                              <listitem>
                                 <para>Alle in <xsl:value-of select="$fachmodell-kurz"/> definierten
                                    Code-Datentypen des Typ 3 in alphabetischer Reihenfolge.</para>
                              </listitem>
                           </varlistentry>
                           <varlistentry>
                              <term>Kennung</term>
                              <listitem>
                                 <para>Die Kennung<footnote><para>Weitere Informationen zu den
                                          Metadaten einer Codeliste sind im aktuellen
                                          Codelisten-Handbuch beschrieben.</para></footnote> der im
                                    jeweiligen Code-Datentyp genutzten Codeliste.</para>
                              </listitem>
                           </varlistentry>
                        </variablelist>
                        <para>Die Namen der Code-Datentypen stellen Links zu den jeweiligen
                           Detail-Abschnitten dar. Die Kennungen stellen Links zur jeweiligen
                           Codeliste im XRepository dar.</para>
                        <informaltable version="5" xmlns:xlink="http://www.w3.org/1999/xlink"
                           xml:lang="de" xml:id="code-uebersichtstabelle-typ3">
                           <tgroup cols="2">
                              <colspec colnum="1" colname="code" colwidth="64mm"/>
                              <colspec colnum="2" colname="codeliste" colwidth="96mm"/>

                              <thead>
                                 <row>
                                    <entry align="left">Code-Datentyp</entry>
                                    <entry align="left">Kennung</entry>

                                 </row>
                              </thead>
                              <tbody>
                                 <xsl:apply-templates select="$codeDatentypen_3"
                                    mode="lite:code-datentyp-3-codelisten">
                                    <xsl:sort select="@name"/>
                                 </xsl:apply-templates>
                              </tbody>
                           </tgroup>
                        </informaltable>
                        <!--<xsl:apply-templates select="//paket[@name='Codes']| //xsdSchema [@name='Codes']" mode="lite:code-datentyp-codelisten-typ3"/>-->
                     </section>
                  </xsl:if>
                  <!-- Codelisten typ 1,2 und 4 -->
                  <xsl:if test="$codeDatentypen_1_2_4">
                     <section>
                        <title>Code-Typ 1, 2 und 4</title>
                        <para>In der nachstehenden Tabelle werden die folgenden Informationen
                           dargestellt:</para>

                        <variablelist>
                           <varlistentry>
                              <term>Code-Datentyp</term>
                              <listitem>
                                 <para>Alle in <xsl:value-of select="$fachmodell-kurz"/> definierten
                                    Code-Datentypen des Typs 1, 2 und 4 in alphabetischer
                                    Reihenfolge.</para>
                              </listitem>
                           </varlistentry>
                           <varlistentry>
                              <term>Codeliste</term>
                              <listitem>
                                 <para>Der Name (kurz)<footnote><para>Weitere Informationen zu den
                                          Metadaten einer Codeliste sind im aktuellen
                                          Codelisten-Handbuch beschrieben.</para></footnote> der im
                                    jeweiligen Code-Datentyp genutzten Codeliste.</para>
                              </listitem>
                           </varlistentry>
                           <varlistentry>
                              <term>Version</term>
                              <listitem>
                                 <para>Die Version der im jeweiligen Code-Datentyp genutzten
                                    Codeliste (Attribut listVersionID).</para>
                              </listitem>
                           </varlistentry>
                           <varlistentry>
                              <term>Typ</term>
                              <listitem>
                                 <para>Art der Codelistennutzung, wie im Codelisten-Handbuch
                                    beschrieben.</para>
                              </listitem>
                           </varlistentry>
                        </variablelist>
                        <informaltable version="5" xml:lang="de"
                           xml:id="code-uebersichtstabelle-typ124">
                           <tgroup cols="4">
                              <colspec colnum="1" colname="code" colwidth="74mm"/>
                              <colspec colnum="2" colname="codeliste" colwidth="65mm"/>
                              <colspec colnum="3" colname="version" colwidth="14mm"/>
                              <colspec colnum="4" colname="nutzung" colwidth="7mm"/>
                              <thead>
                                 <row>
                                    <entry>Code-Datentyp</entry>
                                    <entry>Codeliste</entry>
                                    <entry>Version</entry>
                                    <entry>Typ</entry>
                                 </row>
                              </thead>
                              <tbody>
                                 <xsl:apply-templates select="$codeDatentypen_1_2_4"
                                    mode="lite:code-datentyp-124-codelisten">
                                    <xsl:sort select="@name"/>
                                 </xsl:apply-templates>
                              </tbody>
                           </tgroup>
                        </informaltable>
                        <!--<xsl:apply-templates select="//paket[@name='Codes']| //xsdSchema [@name='Codes']" mode="lite:code-datentyp-codelisten-typ124"/>-->
                     </section>
                  </xsl:if>
               </xsl:otherwise>
            </xsl:choose>
         </appendix>
      </xsl:variable>

      <xsl:call-template name="lite:write-file-return-log">
         <xsl:with-param name="content" select="$content"/>
         <xsl:with-param name="local-path" select="xs:anyURI($target-document-directory)"/>
      </xsl:call-template>

   </xsl:template>

   <!-- Erzeuge den gewünschten Content -->
   <xsl:template match="codeDatentyp" mode="lite:code-datentyp-124-codelisten">
      <xsl:variable name="codeliste" as="element()?">
         <xsl:sequence select="lite:genutzte-cl-oder-vcl(.)"/>
      </xsl:variable>
      <xsl:variable name="version" as="xs:string?" select="@version"/>
      <!-- select="lite:versioncodeliste-version($codeliste)"-->

      <xsl:choose>
         <xsl:when test="empty($codeliste)">
            <row role="codeDatentyp">
               <entry align="left">
                  <link role="schwarz" linkend="{lite:docbook-id(.)}">
                     <xsl:value-of select="lite:name-with-name-praefix-and-suffix(.)"/>
                  </link>
               </entry>

               <entry align="left">
                  <para>
                     <xsl:value-of select="'--'"/>
                  </para>
               </entry>
               <entry align="left">

                  <xsl:choose>
                     <xsl:when test="empty($version)">
                        <xsl:value-of select="'--'"/>
                     </xsl:when>
                     <xsl:otherwise>
                        <!-- Zeichen der Versionsangabe mit breitenlosen Leerzeichen trennen, 
                           um bei längeren Angaben Zeilenumbruch zu ermöglichen -->
                        <xsl:value-of
                           select="replace(@version,'(.)',concat('$1',xgen:unescaped-xml('&amp;'), '#x200B;'))"
                        />
                     </xsl:otherwise>
                  </xsl:choose>
               </entry>
               <entry align="left">
                  <para>
                     <xsl:sequence
                        select="lite:code-typ(., $codeliste, codesSchemavalidiert/text())"/>
                  </para>
               </entry>
            </row>
         </xsl:when>
         <xsl:otherwise>
            <row role="codeDatentyp">
               <entry align="left">
                  <link role="schwarz" linkend="{lite:docbook-id(.)}">
                     <xsl:value-of select="lite:name-with-name-praefix-and-suffix(.)"/>
                  </link>
               </entry>
               <entry align="left">
                  <link role="schwarz" linkend="{replace(concat('tabelle.', @kennung), ':', '.')}">
                     <xsl:value-of select="lite:codeliste-nameLang($codeliste)"/>
                  </link>
               </entry>
               <entry align="left">

                  <xsl:choose>
                     <xsl:when test="empty($version)">
                        <xsl:value-of select="'--'"/>
                     </xsl:when>
                     <xsl:otherwise>
                        <xsl:value-of
                           select="replace(@version,'(.)',concat('$1',xgen:unescaped-xml('&amp;'), '#x200B;'))"
                        />
                     </xsl:otherwise>
                  </xsl:choose>
               </entry>
               <entry align="left">

                  <para>
                     <xsl:sequence
                        select="lite:code-typ(., $codeliste, codesSchemavalidiert/text())"/>
                  </para>
               </entry>
            </row>
         </xsl:otherwise>
      </xsl:choose>

   </xsl:template>

   <xsl:template match="codeDatentyp" mode="lite:code-datentyp-3-codelisten">
      <row xmlns:xlink="http://www.w3.org/1999/xlink" role="codeDatentyp">
         <entry align="left">
            <link role="schwarz" linkend="{lite:docbook-id(.)}">
               <xsl:value-of select="lite:name-with-name-praefix-and-suffix(.)"/>
            </link>
         </entry>
         <entry align="left">
            <link role="schwarz"
               xlink:href="{concat('https://www.xrepository.de/details/',@kennung)}">
               <xsl:value-of select="@kennung"/>
            </link>
         </entry>
      </row>
   </xsl:template>

</xsl:stylesheet>
