<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:db="http://docbook.org/ns/docbook"
    xmlns:xd="http://www.oxygenxml.com/ns/doc/xsl"
    xmlns:gc="http://docs.oasis-open.org/codelist/ns/genericode/1.0/"
    xmlns:log="http://www.xoev.de/de/xgenerator/framework/1/log"
    xmlns:xoev-cl-2="http://xoev.de/schemata/genericode/2"
    xmlns:xoev-cl-4="http://xoev.de/schemata/genericode/4"
    xmlns:lite="urn:xoev-de:kosit:xoev:lite:transformation_1.2.0"
    xmlns:lite-bib="urn:xoev-de:kosit:xoev:lite:schema:bibliothek_1.2.0"
    xmlns:lite-fm="urn:xoev-de:kosit:xoev:lite:schema:fachmodell_1.2.0"
    xmlns:xgen="http://www.xoev.de/de/xgenerator/framework/1/library"
    xmlns="http://docbook.org/ns/docbook"
    xpath-default-namespace="urn:xoev-de:kosit:xoev:lite:schema:fachmodell_1.2.0" version="2.0"
    exclude-result-prefixes="xgen xsl xs db gc log xoev-cl-2 xoev-cl-4 lite lite-fm lite-bib">


    <xd:doc scope="stylesheet">
        <xd:desc>
            <xd:p>Dieses Stylesheet generiert für jeden Codedatentyp einen Abschnitt.</xd:p>
        </xd:desc>
    </xd:doc>


    <xd:doc>
        <xd:desc>
            <xd:p>Einstiegspunkt für die Generierung</xd:p>
        </xd:desc>
    </xd:doc>
    <xsl:template match="/" mode="lite:abschnitt-codedatentyp-entry">
        <xsl:apply-templates select="//codeDatentyp[not(@draft = 'true')]"
            mode="lite:abschnitt-codedatentyp"/>
    </xsl:template>

    <xd:doc>
        <xd:desc>
            <xd:p>Erzeuge für jeden Codedatentyp eine separate Datei. Diese Dateien werden in einem
                Ordner docbook/dokumente/anhang/codes unter dem Namen des Codedatentyps
                abgelegt.</xd:p>
        </xd:desc>
    </xd:doc>
    <xsl:template match="codeDatentyp" mode="lite:abschnitt-codedatentyp">
        <!-- Diese Variable verweisen auf den Ordner in dem ein Datei gespeichert werden soll -->
        <xsl:variable name="document-directory" select="'dokumente/codeDatentypen-einzeln-lite2db8/'" as="xs:string"/>
        <xsl:variable name="target-document-directory" select="$document-directory" as="xs:string"/>

        <!-- Diese Variable enthält den Content einer zu erzeugenden Datei. -->
        <xsl:variable name="content">
            <xsl:apply-templates select="." mode="lite:abschnitt-codedatentyp-content"/>
        </xsl:variable>

        <!-- Hier wird das Template zur Dateierzeugung aufgerufen -->
        <xsl:call-template name="lite:write-file-return-log">
            <xsl:with-param name="content" select="$content"/>
            <xsl:with-param name="local-path"
                select="xs:anyURI(concat($target-document-directory, @name, '.xml'))"/>
        </xsl:call-template>
    </xsl:template>

    <xd:doc>
        <xd:desc>
            <xd:p>Erzeuge den Content für einen Abschnitt zu einem Codedatentyp.</xd:p>
            <xd:p> Der Abschnitt besteht aus folgenden Bestandteilen: <xd:ul>
                    <xd:li>Eine Tabelle mit Informationen zur zugehörigen Codeliste inklusive des
                        Nutzungstyps</xd:li>
                    <xd:li>Eine Tabelle zur Konfiguration des Codedatentyps. Diese Tabelle wurde
                        bisher in der Spezifikation nicht abgebildet. Die Tabellenzeilen werden nur
                        abgebildet, falls der Wert angegeben ist und vom für den Standard
                        angegebenen Defaultwert abweicht.</xd:li>
                    <xd:li>Nutzungs des Datentyps (in separatem Issue noch zu
                        implementieren)</xd:li>
                    <xd:li>Geschäftsregel (in separatem Issue noch zu implementieren)</xd:li>
                </xd:ul>
            </xd:p>
        </xd:desc>
    </xd:doc>
    <xsl:template match="codeDatentyp" mode="lite:abschnitt-codedatentyp-content">
        <section xmlns="http://docbook.org/ns/docbook" xmlns:xlink="http://www.w3.org/1999/xlink"
            version="5" xml:lang="de" xml:id="{lite:docbook-id(.)}" role="codeDatentyp">

            <title>
                <xsl:value-of select="(@titel, @name)[1]"/>
            </title>
            <xsl:if test="@titel">
                <subtitle>Typ: <emphasis role="codebf"><xsl:value-of select="@name"
                    /></emphasis></subtitle>
            </xsl:if>

            <xsl:apply-templates select="beschreibung" mode="lite:dokumentation.beschreibung"/>

            <xsl:apply-templates select="umsetzungshinweis"
                mode="lite:dokumentation.umsetzungshinweis"/>

            <xsl:variable name="hatKennung" select="not(empty(@kennung))" as="xs:boolean"/>
            <xsl:variable name="hatVersion" select="not(empty(@version))" as="xs:boolean"/>
            <xsl:variable name="codeliste" select="lite:genutzte-cl-oder-vcl(.)" as="element()?"/>


            <informaltable>
                <tgroup cols="2">
                    <colspec colnum="1" colname="des" colwidth="22mm"/>
                    <colspec colnum="2" colname="val" colwidth="138mm"/>
                    <thead>
                        <row>
                            <entry>Codelisten</entry>
                            <entry/>
                        </row>
                    </thead>
                    <tbody>
                        <!-- Beschreibungszeile für Typ 3 unterdrücken -->
                        <xsl:if test="not($hatKennung and $hatVersion = false())">
                            <row>
                                <entry>-beschreibung</entry>
                                <entry>
                                    <xsl:choose>
                                        <xsl:when test="$hatKennung and empty($codeliste)">
                                            <xsl:call-template
                                                name="annotation.todo.xoevlite.developer">
                                                <xsl:with-param name="titel">Fehler: Codeliste nicht
                                                  gefunden.</xsl:with-param>
                                                <xsl:with-param name="beschreibung">Zum
                                                  Code-Datentyp <xsl:value-of select="./@name"/>
                                                  konnte im Verzeichnis <em>codelists</em> keine
                                                  Codeliste gefunden werden. Möglicherweise fehlt
                                                  die Codeliste im XRepository.</xsl:with-param>
                                                <xsl:with-param name="url"
                                                  >https://projekte.kosit.org/xoev/lite-projekte/lite-dokumentation/-/issues/36#note_215982</xsl:with-param>
                                            </xsl:call-template>
                                        </xsl:when>
                                        <xsl:when test="not(empty($codeliste))">
                                            <xsl:value-of
                                                select="(lite:codeliste-beschreibung($codeliste), 'unbestimmt')[1]"
                                            />
                                        </xsl:when>
                                        <xsl:otherwise>unbestimmt</xsl:otherwise>
                                    </xsl:choose>
                                </entry>
                            </row>
                        </xsl:if>

                        <row>
                            <entry>-nutzung</entry>
                            <entry>
                                <xsl:choose>
                                    <xsl:when
                                        test="$hatKennung and $hatVersion and codesSchemavalidiert = 'true'"
                                        > Typ: 1, Inhalte der Codeliste siehe <xref
                                            linkend="{replace(concat('tabelle.', @kennung), ':', '.')}"
                                            role="Seite"/>
                                        <!-- Hinweis: 
                                            Inhalt des linkend-Attributs kann nicht per Helperfunktion ermittelt werden, 
                                            da die Tabelle zu diesem Zeitpunkt noch nicht vorliegt. 
                                            Es muss eine selbstdefinierte ID für die Tabelle der Codelisteninhalte vereinbart werden, 
                                            die hier dann verwendet wird. 
                                            Verwendet wird eine Verkettung aus "tabelle." + Kennung der Codeliste (Doppelpunkt wird durch Punkt ersetzt, sonst kein valides linkend)
                                            
                                            Bsp.: <xref linkend="tabelle.urn.xoev-de.xdomea.codeliste.bewertungsvorschlag.bewertungsvorschlag" role="Seite"/>
                                        -->
                                    </xsl:when>
                                    <xsl:when
                                        test="$hatKennung and $hatVersion and codesSchemavalidiert = 'false'"
                                        >Typ: 2, siehe Beschreibung</xsl:when>
                                    <!-- Beschreibung soll bei bei Typ 3 nicht mehr angegeben werden, 
                                        daher nur noch Typ eingetragen. -->
                                    <xsl:when test="$hatKennung and not($hatVersion)">Typ:
                                        3</xsl:when>
                                    <xsl:when test="not($hatKennung) and not($hatVersion)">Typ: 4,
                                        siehe Beschreibung des Code-Datentyps</xsl:when>
                                    <xsl:otherwise>
                                        <xsl:call-template name="annotation.todo.xoevlite.developer">
                                            <xsl:with-param name="titel">Fehler bei Ermittlung der
                                                Codelistennutzung.</xsl:with-param>
                                            <xsl:with-param name="beschreibung">Die Auswertung der
                                                Merkmale des Codedatentyps zur Ermittlung des
                                                Nutzungstyps führt zu einer ungültigen
                                                Konstellation. Hat Kennung? <xsl:value-of
                                                  select="$hatKennung"/>, hat Version? <xsl:value-of
                                                  select="$hatVersion"/>, Codes schemavalidiert?
                                                  <xsl:value-of select="@codesSchemavalidiert"
                                                /></xsl:with-param>
                                            <xsl:with-param name="url" >https://projekte.kosit.org/xoev/lite-projekte/lite-dokumentation/-/issues/35</xsl:with-param>
                                        </xsl:call-template>
                                    </xsl:otherwise>
                                </xsl:choose>
                            </entry>
                        </row>
                        <row>
                            <entry>-kennung</entry>
                            <entry>
                                <!-- Bei Typ 3 ins XRepository verlinken -->
                                <xsl:choose>
                                    <xsl:when test="$hatKennung and not($hatVersion)">
                                        <link role="schwarz"
                                            xlink:href="{concat('https://www.xrepository.de/details/', @kennung)}">
                                            <xsl:value-of select="@kennung"/>
                                        </link>
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <xsl:value-of select="(@kennung, 'unbestimmt')[1]"/>
                                    </xsl:otherwise>
                                </xsl:choose>
                            </entry>
                        </row>
                        <row>
                            <entry>-version</entry>
                            <entry>
                                <xsl:value-of select="(@version, 'unbestimmt')[1]"/>
                            </entry>
                        </row>
                    </tbody>
                </tgroup>
            </informaltable>

            <xsl:variable name="konfigurationsinhalt">
                <xsl:if
                    test="typDesCodeElements and not(typDesCodeElements = /xoev-fachmodell/konfiguration.xoev-fachmodell/typDesCodeElements)">
                    <row>
                        <entry>Typ des <emphasis role="codebf">code</emphasis>-Elements</entry>
                        <entry>
                            <xsl:value-of select="typDesCodeElements"/>
                        </entry>
                    </row>
                </xsl:if>
                <xsl:if
                    test="nutzungNameElement and not(nutzungNameElement = /xoev-fachmodell/konfiguration.xoev-fachmodell/nutzungNameElement)">
                    <row>
                        <entry>Nutzung des <emphasis role="codebf">name</emphasis>-Elements</entry>
                        <entry>
                            <xsl:value-of select="nutzungNameElement"/>
                        </entry>
                    </row>
                </xsl:if>
                <xsl:if
                    test="benannterCodelistenDatentyp and not(benannterCodelistenDatentyp = /xoev-fachmodell/konfiguration.xoev-fachmodell/benannterCodelistenDatentyp)">
                    <row>
                        <entry>Umsetzung der Codelistenversion als benannter Datentyp</entry>
                        <entry>
                            <para>
                                <xsl:value-of select="benannterCodelistenDatentyp"/>
                            </para>
                            <xsl:if test="benannterCodelistenDatentypXSD">
                                <para>(Schema: <xsl:value-of select="benannterCodelistenDatentypXSD"
                                    />)</para>
                            </xsl:if>
                            <xsl:if test="benannterCodelistenDatentypName">
                                <para>(Name des Datentyps: <xsl:value-of
                                        select="benannterCodelistenDatentypName"/>)</para>
                            </xsl:if>
                        </entry>
                    </row>
                </xsl:if>
                <xsl:if test="genutzteCodeSpalte">
                    <row>
                        <entry>zu nutzende Code-Spalte</entry>
                        <entry>
                            <xsl:value-of select="genutzteCodeSpalte"/>
                        </entry>
                    </row>
                </xsl:if>
                <xsl:if test="genutzteBeschreibungsspalte">
                    <row>
                        <entry>zu nutzende Beschreibungsspalte</entry>
                        <entry>
                            <xsl:value-of select="genutzteBeschreibungsspalte"/>
                        </entry>
                    </row>
                </xsl:if>
            </xsl:variable>

            <xsl:if test="not(normalize-space($konfigurationsinhalt) = '')">
                <para>
                    Konfiguration des Codedatentyps (soweit angegeben und von XÖV-Default-Einstellung abweichend):
                </para>

                <informaltable>
                    <tgroup cols="2">
                        <colspec colnum="1" colname="des" colwidth="62mm"/>
                        <colspec colnum="2" colname="val" colwidth="98mm"/>
                        <thead>
                            <row>
                                <entry>Eigenschaft</entry>
                                <entry>Wert</entry>
                            </row>
                        </thead>
                        <tbody>
                            <xsl:copy-of select="$konfigurationsinhalt"/>
                        </tbody>
                    </tgroup>
                </informaltable>
            </xsl:if>

            <!-- TODO Ausstehend: Nutzung des Code-Datentyps, Geschäftsregeln -->
        </section>

    </xsl:template>



</xsl:stylesheet>
