<xsl:stylesheet 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:xs="http://www.w3.org/2001/XMLSchema" 
	xmlns:xd="http://www.oxygenxml.com/ns/doc/xsl" 
	xmlns:db="http://docbook.org/ns/docbook" 
	xmlns:gc="http://docs.oasis-open.org/codelist/ns/genericode/1.0/" 
	xmlns:xoev-cl-2="http://xoev.de/schemata/genericode/2" 
	xmlns:xoev-cl-4="http://xoev.de/schemata/genericode/4" 
	xmlns:lite="urn:xoev-de:kosit:xoev:lite:transformation_1.2.0" 
	xmlns:lite-bib="urn:xoev-de:kosit:xoev:lite:schema:bibliothek_1.2.0" 
	xmlns:lite-fm="urn:xoev-de:kosit:xoev:lite:schema:fachmodell_1.2.0" 
	xmlns:xgen="http://www.xoev.de/de/xgenerator/framework/1/library" 
	xmlns="http://docbook.org/ns/docbook" 
	xpath-default-namespace="urn:xoev-de:kosit:xoev:lite:schema:fachmodell_1.2.0" 
	version="2.0" 
	exclude-result-prefixes="xgen xsl xs db gc xoev-cl-2 xoev-cl-4 lite lite-fm lite-bib">


	<xd:doc scope="stylesheet">
		<xd:desc>
			<xd:p>Dieses Stylesheet dient der Abbildung einer Eigenschaftentabelle von
				Nachrichten, komplexen Datentypen, globalen Eigenschaften und globalen
				Eigenschaftengruppen.</xd:p>
		</xd:desc>
	</xd:doc>

	<!-- Abstandhalter zwischen Bezeichnung, Icon und Multiplizität, verschiedene Breiten: -->
	<!-- 1 em -->
	<!-- <xsl:variable name="gruppe-icon-separator" select="'&#x2003;'"/>--><!-- 1 em -->
	<!-- 0.75 em (1 en (= 1/2 em) + 1/4 em) -->
	<!-- <xsl:variable name="gruppe-icon-separator" select="'&#x2002;&#x2005;'"/> -->
	<!-- 1 en -->
	<xsl:variable name="gruppe-icon-separator" select="'&#x2002;'"/> 

	<xd:doc>
		<xd:desc>
			<xd:p>Erzeuge die Eigenschaft-Tabelle für einen Baustein (Nachricht, Datentyp, globale
				Eigenschaftengruppe oder globale Eigenschaft).</xd:p>
		</xd:desc>
	</xd:doc>
	<xsl:template match="nachricht | datentyp | globaleEigenschaftengruppe | globaleEigenschaft"
		mode="lite:dokumentation.eigenschaften">
		<!-- Die Tabelle wird nur dann erzeugt, wenn es mindestens eine "eigenschaft" oder "eigenschaftengruppe" gibt,
			die nicht den Status "draft" hat. -->
		<xsl:if test="eigenschaft[not(@draft = 'true')] | eigenschaftengruppe[not(@draft = 'true')] | anyStruktur[not(@draft = 'true')]">

			<table xml:id="table.{lite:docbook-id(.)}" role="{local-name(.)}">
				<title>Struktur von <xsl:value-of select="(@titel, @name)[1]"/></title>
				<tgroup cols="12">
					<colspec colname="indent0" colnum="1" colwidth="5mm"/>
					<colspec colname="indent1" colnum="2" colwidth="5mm"/>
					<colspec colname="indent2" colnum="3" colwidth="5mm"/>
					<colspec colname="indent3" colnum="4" colwidth="5mm"/>
					<colspec colname="indent4" colnum="5" colwidth="5mm"/>
					<colspec colname="indent5" colnum="6" colwidth="5mm"/>
					<colspec colname="child" colnum="7" colwidth="27mm"/>
					<colspec colname="type" colnum="8" colwidth="55mm"/>
					<colspec colname="type-icon" colnum="9" colwidth="10mm" align="right"/>
					<colspec colname="cardinality" colnum="10" colwidth="12mm" align="center"/>
					<colspec colname="reference" colnum="11" colwidth="14mm" align="center"/>
					<colspec colname="page" colnum="12" colwidth="12mm" align="right"/>
				
					<thead>
						<!-- Enthält Gruppenart, -multiplizität und Name für den ganzen Baustein -->
						<row>
							<entry namest="indent0" nameend="page" align="center">
								<para>
									<emphasis role="codebf">
									<xsl:value-of select="@name"/>
									<xsl:apply-templates select="." mode="lite:dokumentation.eigenschaften.tabelleneintrag.gruppenattribute">
										<xsl:with-param name="kinderlos" select="false()"/>
									</xsl:apply-templates>
								</emphasis>
								</para>
							</entry>
						</row>
						<row>
							<entry namest="indent0" nameend="child">Kindelement<xsl:if
									test="eigenschaft[not(@draft = 'true')][@xsdAttribute = 'true']"
									>/Attribut</xsl:if></entry>
							<entry namest="type" nameend="type-icon">Typ / Basistyp / Referenz</entry>
							<entry>Anz.</entry>
							<entry>Ref.</entry>
							<entry>Seite</entry>
						</row>
					</thead>
					<tbody>
						<xsl:for-each
							select="eigenschaft[not(@draft = 'true')] | eigenschaftengruppe[not(@draft = 'true')] | anyStruktur[not(@draft = 'true')]">
							<xsl:apply-templates select="."
								mode="lite:dokumentation.eigenschaften.tabelleneintrag">
								<xsl:with-param name="indent" select="0"/>
								<xsl:with-param name="lastElement" select="position() = last()"/>
							</xsl:apply-templates>
						</xsl:for-each>
					</tbody>
				</tgroup>
			</table>
		</xsl:if>
	</xsl:template>

	<xd:doc>
		<xd:desc>
			<xd:p>Erzeuge einen Eintrag der Eigenschaften-Tabelle (rekursiv)</xd:p>
		</xd:desc>
		<xd:param name="indent">Einrückungstiefe</xd:param>
		<xd:param name="lastElement">Wird für die Analyse benötigt um zu entscheiden, ob ein
			"rowsep" gesetzt werden muss</xd:param>
	</xd:doc>
	<xsl:template match="eigenschaft | eigenschaftengruppe | anyStruktur"
		mode="lite:dokumentation.eigenschaften.tabelleneintrag">
		<xsl:param name="indent" as="xs:integer" required="yes"/>
		<xsl:param name="lastElement" as="xs:boolean*" required="yes"/>
		
		<xsl:variable name="typ-oder-referenz-element" as="element()?">
			<xsl:choose>
				<xsl:when test="@typ">
					<xsl:sequence select="lite:resolve(@typ,.,false())"/>
				</xsl:when>
				<xsl:when test="@referenz">
					<xsl:sequence select="lite:resolve(@referenz,.,true())"/>
				</xsl:when>
				<xsl:when test="@basistyp">
					<xsl:sequence select="lite:resolve(@basistyp,.,false())"/>
				</xsl:when>
				<xsl:otherwise></xsl:otherwise>
			</xsl:choose>
		</xsl:variable>

		<!-- In dieser Variable werden potentielle Inhalte für das Dokumentationsfeld gesammelt.
		Anschließend kann geprüft werden, ob sich Inhalte in der Variablen befinden. 
		Wenn ja, wird der Inhalt in das Feld eingefügt. Wenn nein, entfällt die Dokumentationszeile. 
		Die Variable wird schon an dieser Stelle angelegt, damit geprüft werden kann, ob nach der letzten Eigenschaftszeile
		mit Bezeichnung, Typ, Anzahl, Referenz eine Zeilenbegrenzung eingezogen werden muss.
		-->
		<xsl:variable name="dokumentation">
			<xsl:apply-templates select="."
				mode="lite:dokumentation.eigenschaften.tabelleneintrag.dokumentation"/>
		</xsl:variable>

		<!-- Die beiden folgenden Variablen werden verwendet, um die Erzeugung des "rowsep"-Attributes für ein "entry"-Element zu steuern -->
		<xsl:variable name="eigenschaftIstKinderlos"
			select="empty(eigenschaft) and empty(eigenschaftengruppe)"/>

		<xsl:variable name="eigenschaftHatKeineAngabenFuerDasDokumentationsfeld"
			select="normalize-space($dokumentation) = ''"/>

		<!-- Erzeugt die Zeile mit den Kerninformationen des Kindelements (Bezeichnung, Typ, Anzahl, Referenz (Kapitel und Seite)) -->
		<row role="{local-name(.)}">
			<!-- Rücke ggf. ein und lege fest, wie die rowsep/colsep-Angaben sein müssen -->
			<xsl:for-each select="1 to $indent">
				<entry
					rowsep="{if (empty(index-of(subsequence($lastElement, position() + 1), false())) and 
         							  $eigenschaftIstKinderlos and $eigenschaftHatKeineAngabenFuerDasDokumentationsfeld)
         							  then '1' else '0'}"
					colsep="{if (position() = last()) then '1' else '0'}"/>
			</xsl:for-each>

			<!-- Feld für Bezeichnung und Gruppenart -->
			<entry namest="indent{$indent}" nameend="child">
								
				<!-- Bezeichnung -->
				<xsl:apply-templates select="."
					mode="lite:dokumentation.eigenschaften.tabelleneintrag.bezeichnung"/>
				
				<!-- Art und Multiplizität impliziter und expliziter Gruppe -->
				<xsl:apply-templates select="." mode="lite:dokumentation.eigenschaften.tabelleneintrag.gruppenattribute">
					<xsl:with-param name="kinderlos" select="$eigenschaftIstKinderlos"/>
				</xsl:apply-templates>
			</entry>

			<!-- Feld für Datentyp, referenzierte globale Eigenschaft/Eigenschaftengruppe oder Basistyp -->
				<xsl:choose>
					<xsl:when test="@typ">
						<entry colsep="0">
							<emphasis role="codebf">
								<xsl:value-of select="lite:kuerze-internen-typnamen(@typ, $typ-oder-referenz-element)"/>
						</emphasis>
						</entry>
						<entry>
							<xsl:copy-of select="lite:gibStrukturIcon(if (lite:is-simple-type($typ-oder-referenz-element)) then 'type_simple' else 'type_complex')"/>
						</entry>
					</xsl:when>
					<xsl:when test="@referenz">
						<entry colsep="0">
							<emphasis role="codebf">
								<xsl:value-of select="lite:kuerze-internen-typnamen(@referenz,$typ-oder-referenz-element)"/>
						</emphasis>
						</entry>
						<entry>
							<xsl:copy-of select="lite:gibStrukturIcon(
							if (lite:resolve(@referenz, ., true())/@xsdAttribute=true()) then 'ref_attribute' 
							else if (lite:is-element-group($typ-oder-referenz-element)) then 'ref_element_group' 
							else if (lite:is-attribute-group($typ-oder-referenz-element)) then 'ref_attribute_group' 
							else 'ref_element'
							)"/>
						</entry>
					</xsl:when>
					<xsl:when test="@basistyp">
						<entry colsep="0">
							<emphasis role="codebf">
								<xsl:value-of select="lite:kuerze-internen-typnamen(@basistyp,$typ-oder-referenz-element)"/>
						</emphasis>
						</entry>
						<entry>
							<xsl:copy-of select="lite:gibStrukturIcon('basistyp')"/>
						</entry>
					</xsl:when>
					<xsl:otherwise>
						<entry colsep="0"></entry>
						<entry></entry>
					</xsl:otherwise>
				</xsl:choose>

			<!-- Feld für Multiplizität (nur für Eigenschaften, keine impliziten oder expliziten Gruppen) -->
			<entry>
				<emphasis role="bold">
					<xsl:if test="self::eigenschaft">
						<xsl:value-of select="translate((@multiplizitaet,'1')[1], '*', 'n')"/>
					</xsl:if>
				</emphasis>
			</entry>

			<!-- Feld für Verlinkung (Abschnitt / Seitenzahl) -->
			<xsl:choose>

				<xsl:when test="@typ and not(starts-with(@typ, 'xs:'))">
					<!-- Verweis auf Datentyp, außer W3C-Datentyp -->
					<entry>
						<xref linkend="{lite:docbook-id($typ-oder-referenz-element)}"
							role="AbschnittNummer"/>
					</entry>
					<entry>
						<xref linkend="{lite:docbook-id($typ-oder-referenz-element)}"
							role="Seitenzahl"/>
					</entry>
				</xsl:when>
				<xsl:when test="@referenz">
					<!-- Verweis auf globale Eigenschaft -->
					<entry>
						<xref linkend="{lite:docbook-id($typ-oder-referenz-element)}"
							role="AbschnittNummer"/>
					</entry>
					<entry>
						<xref linkend="{lite:docbook-id($typ-oder-referenz-element)}"
							role="Seitenzahl"/>
					</entry>
				</xsl:when>
				<xsl:otherwise>
					<entry/>
					<entry/>
				</xsl:otherwise>
			</xsl:choose>
			
		</row>

		<!-- Dokumentationsfeld nur dann erzeugen, falls Inhalt vorhanden -->
		<xsl:if test="not(normalize-space($dokumentation) = '')">
			<!-- Dokufeld anlegen -->
			<row>
				<!-- Rücke ggf. ein und lege fest, wie die rowsep/colsep-Angaben sein müssen -->
				<xsl:for-each select="1 to $indent">
					<entry
						rowsep="{if (empty(index-of(subsequence($lastElement, position() + 1), false())) and $eigenschaftIstKinderlos) 
						then '1' else '0'}"
						colsep="{if (position() = last()) then '1' else '0'}"/>
				</xsl:for-each>
				<!-- Einfügen der gesammelten Dokumentation -->
				<entry namest="indent{$indent}" nameend="page">
					<xsl:copy-of select="$dokumentation"/>
				</entry>
			</row>
		</xsl:if>

		<!-- Rekursives Durchlaufen der Kindelemente -->
		<xsl:for-each select="(eigenschaft | eigenschaftengruppe)">
			<xsl:apply-templates select="."
				mode="lite:dokumentation.eigenschaften.tabelleneintrag">

				<xsl:with-param name="indent" select="$indent + 1"/>
				<xsl:with-param name="lastElement" select="$lastElement, (position() = last())"/>
			</xsl:apply-templates>
		</xsl:for-each>
	</xsl:template>

	<xd:doc>
		<xd:desc>
			<xd:p>Dieses Template stellt die Art und die Multiplizität für implizite und explizite Gruppen dar.</xd:p>
			<xd:p>implizit: eigenschaft/@gruppe.art und eigenschaft/@gruppe.multiplizitaet</xd:p>
			<xd:p>explizit: eigenschaftengruppe/@art und eigenschaftengruppe/@multiplizitaet</xd:p>
		</xd:desc>
		<xd:param name="kinderlos">true, wenn keine Unterelemente eigenschaft oder eigenschaftengruppe vorhanden sind</xd:param>
	</xd:doc>
	<xsl:template match="*"
		mode="lite:dokumentation.eigenschaften.tabelleneintrag.gruppenattribute">
		<xsl:param name="kinderlos" as="xs:boolean"/>
		
		
		<xsl:choose>
			<xsl:when test="self::eigenschaft and not($kinderlos)">
				<!-- Für Eigenschaften mit anonymen Typen: -->
				<xsl:value-of select="if (./@name) then $gruppe-icon-separator else ''"/>
				<xsl:copy-of select="lite:gibStrukturIcon((@gruppe.art,'sequence')[1])"/>
				<xsl:value-of select="concat($gruppe-icon-separator,translate((@gruppe.multiplizitaet,'1')[1], '*', 'n'))"/>
			</xsl:when>
				<!-- Für jedwede Eigenschaftengruppe: -->
			<!-- TODO: zu klären: bei eigenschaftengruppen, die auf globaleEigenschaftengruppe referenzieren, 
				Gruppeneigenschaften hier anzeigen? -->
			<xsl:when test="self::eigenschaftengruppe">
				<xsl:value-of select="if (./@name) then $gruppe-icon-separator else ''"/>
				<xsl:copy-of select="lite:gibStrukturIcon((@art,'sequence')[1])"/>
				<xsl:value-of select="concat($gruppe-icon-separator,translate((@multiplizitaet,'1')[1], '*', 'n'))"/>
			</xsl:when>
			<xsl:when test="self::nachricht or self::datentyp or self::globaleEigenschaft or self::globaleEigenschaftengruppe">
				<!-- Für den Tabellenkopf Gruppeneigenschaften des Bausteins: -->
				<xsl:value-of select="$gruppe-icon-separator"/>
				<xsl:copy-of select="lite:gibStrukturIcon((@gruppe.art,@art,'sequence')[1])"/>
				<xsl:value-of select="concat($gruppe-icon-separator,translate((@multiplizitaet,'1')[1], '*', 'n'))"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>


	<xd:doc>
		<xd:desc>
			<xd:p>Dieses Template gibt die Bezeichnung der Eigenschaft aus.</xd:p>
			<xd:p>Referenzierte globale Eigenschaften und Eigenschaftengruppen werden nicht als
				Bezeichnung, sondern als Typ eingetragen.</xd:p>
		</xd:desc>
	</xd:doc>
	<xsl:template match="eigenschaft | eigenschaftengruppe | anyStruktur"
		mode="lite:dokumentation.eigenschaften.tabelleneintrag.bezeichnung">
		<xsl:choose>
			<xsl:when test="@xsdAttribute = 'true'">
				<xsl:if test="not(@referenz)">
					<xsl:copy-of select="lite:gibStrukturIcon('attribute')"/>
				</xsl:if>
				<!-- emphasis in dieser Verschachtelungs-Reihenfolge, sonst funktioniert es nicht -->
				<emphasis role="italics">
					<emphasis role="bold">
						<xsl:value-of select="@name"/>
					</emphasis>
				</emphasis>
			</xsl:when>
			<xsl:when test="not(@name)">
				<emphasis role="italics">
					<emphasis role="bold">
						<!--unbenannt-->
					</emphasis>
				</emphasis>
			</xsl:when>
			<xsl:otherwise>
				<emphasis role="bold">
					<xsl:value-of select="@name"/>
				</emphasis>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xd:doc>
		<xd:desc>
			<xd:p>Dieses Template sammelt Informationen, die im Dokumentationsfeld ausgegeben werden
				können.</xd:p>
			<xd:p>TODO: Prüfen, welche Informationen aus der referenzierten globalen Eigenschaft(engruppe) übernommen werden sollen, falls hier in der Eigenschaft(engruppe) keine vorhanden sind.</xd:p>
		</xd:desc>
	</xd:doc>
	<xsl:template match="eigenschaft | eigenschaftengruppe | anyStruktur"
		mode="lite:dokumentation.eigenschaften.tabelleneintrag.dokumentation">
		
		<!-- 1. Titel -->
		<xsl:if test="@titel">
			<para role="titel"><emphasis role="strong">Titel: </emphasis><emphasis><xsl:value-of select="@titel"/></emphasis></para>
		</xsl:if>

		<!-- 2. Beschreibung (falls keine vorhanden, ggf. aus referenzierter globaler Eigenschaft(engruppe)) -->
		<xsl:apply-templates select="beschreibung" mode="lite:dokumentation.beschreibung"/>
		<xsl:if test="empty(beschreibung) and @referenz">
			<!-- Beschreibung aus referenzierter globaler Eigenschaft übernommen -->
			<xsl:apply-templates select="lite:resolve(@referenz, ., true())/beschreibung"
				mode="lite:dokumentation.beschreibung"/>
		</xsl:if>

		<!-- 3. Fixed- und Default-Wert -->
		<xsl:if test="@fixedWert">
			<para role="fixedWert">In diesem Element/Attribut ist nur der Wert "<xsl:value-of select="@fixedWert"/>"
				zulässig (fixed-Wert).</para>
		</xsl:if>
		<xsl:if test="@defaultWert">
			<para role="defaultWert">Dieses Element/Attribut hat den Wert "<xsl:value-of select="@defaultWert"/>",
				sofern kein anderer Wert übermittelt wird (default-Wert).</para>
		</xsl:if>
		
		<!-- 4. Umsetzungshinweis -->
		<xsl:apply-templates select="umsetzungshinweis" mode="lite:dokumentation.umsetzungshinweis"/>

		<!-- 5. Beispielwert -->
		<xsl:apply-templates select="." mode="lite:dokumentation.eigenschaften.beispielwert"/>

		<!-- 6. Form (falls angegeben und vom Defaultwert abweichend) -->
		<xsl:if test="@form and not(@form = /xoev-fachmodell/konfiguration.xoev-fachmodell/elementFormDefault)">
			<para role="form">Form (Qualifizierung): <xsl:value-of select="@form"/></para>
		</xsl:if>
		
		<!-- 7. Angaben zur Ableitung (pattern, maxLength etc.) -->
		<!-- Ableitungsattribute, die in der Eigenschaft selbst angegeben sind -->
		<xsl:apply-templates select="."
			mode="lite:dokumentation.eigenschaften.tabelleneintrag.ableitung"/>
		<!-- Ableitungsattribute, die in der referenzierten globalen Eigenschaft angegeben sind (noch zu klären, ob erwünscht) -->
		<xsl:apply-templates select="lite:resolve(@referenz, ., true())"
			mode="lite:dokumentation.eigenschaften.tabelleneintrag.ableitung"/>
		
		<!-- 8. Angaben für anyStruktur -->
		<xsl:if test="@namespace">
			<para role="namespace"><emphasis role="strong">Namensraum: </emphasis><xsl:value-of select="@namespace"/></para>
		</xsl:if>
		<xsl:if test="@processContents">
			<para role="processContents"><emphasis role="strong">Art der Validierung: </emphasis><xsl:value-of select="@processContents"/></para>
		</xsl:if>
		
		<!-- 9. Angaben für union -->
		<xsl:apply-templates select="union" mode="lite:dokumentation.eigenschaften.tabelleneintrag"/>
		
		<!-- 10. Angaben für Geschäftsregel -->
		<xsl:if test="geschaeftsregel">
			<xsl:apply-templates select="." mode="lite:dokumentation.eigenschaften.geschaeftsregeln"/>
		</xsl:if>
		
	</xsl:template>


	<xd:doc>
		<xd:desc>Dieses Template verarbeitet Angaben zur Ableitung eines Datentyps einer
			Eigenschaft.</xd:desc>
	</xd:doc>
	<xsl:template match="*" mode="lite:dokumentation.eigenschaften.tabelleneintrag.ableitung">
		<!-- Größtenteils übernommen von baustein_in_paketstruktur.xsl -->

		<xsl:if test="@basistyp">
			<xsl:variable name="basistyp" select="lite:resolve(@basistyp, ., false())"/>
			<xsl:variable name="isRestriction" select="
					if (@restriction[. = 'true']) then
						true()
					else
						false()"/>

			<!-- a) Vererbungsinfo generieren (Einschränkung oder Erweiterung; ggf. Querreferenz im Dokument) -->
			<para>
				<xsl:text>Der Typ dieses Elements ist eine </xsl:text>
				<xsl:choose>
					<xsl:when test="$isRestriction">
						<xsl:text>Einschränkung</xsl:text>
					</xsl:when>
					<xsl:otherwise>
						<xsl:text>Erweiterung</xsl:text>
					</xsl:otherwise>
				</xsl:choose>
				<xsl:text> des Basistyps </xsl:text>
				<emphasis role="codebf">
					<xsl:value-of select="$basistyp/@name"/>
				</emphasis>
				<xsl:if test="not(starts-with(@basistyp, 'xs:'))">
					<xsl:text> (siehe </xsl:text>
					<xref linkend="{lite:docbook-id(lite:resolve(@basistyp, ., false()))}" role="AS"/>
					<xsl:text>)</xsl:text>
				</xsl:if>
				<xsl:text>.</xsl:text>
			</para>

			<!-- b) Patterns, if any -->
			<xsl:variable name="pattern" as="xs:string*"><![CDATA[<![CDATA[]]><xsl:value-of
					select="@pattern"/>]]&gt;</xsl:variable>
			<xsl:if test="@pattern[. != '']">
				<para role="pattern">
					<xsl:text>Die Werte müssen dem Muster '</xsl:text>
					<xsl:value-of select="lite:unescaped-xml(string-join($pattern, ''))"/>
					<xsl:text>' entsprechen.</xsl:text>
				</para>
			</xsl:if>

			<!-- c) Facets, if any -->
			<xsl:variable name="facets" select="
					(@fractionDigits, @length, @maxExclusive, @maxInclusive, @maxLength,
					@minExclusive, @minInclusive, @minLength, @totalDigits, @whitespace)"/>
			<xsl:if test="$facets">
				<para>
					<xsl:text>Beschränkungen (XML-Schema-Facetten): </xsl:text>
					<xsl:for-each select="$facets">
						<xsl:value-of select="concat(name(), ':', .)"/>
						<xsl:if test="position() != last()">
							<xsl:text>, </xsl:text>
						</xsl:if>
					</xsl:for-each>
				</para>
			</xsl:if>
		</xsl:if>
	</xsl:template>

	
	
	
	<xd:doc>
		<xd:desc>Dieses Template verarbeitet das Element union innerhalb einer Eigenschaft.</xd:desc>
	</xd:doc>
	<xsl:template match="union" mode="lite:dokumentation.eigenschaften.tabelleneintrag">
		<para>Der Typ dieser Eigenschaft ist eine Vereinigung folgender Datentypen:</para>
		<itemizedlist role="union">
			<xsl:for-each select="memberType">
				<listitem role="memberType"><xsl:value-of select="."/></listitem>
			</xsl:for-each>
		</itemizedlist>
	</xsl:template>
	
	<xd:doc scope="component">
		<xd:desc>
			<xd:p>Dieses Template erzeugt einen Eintrag mit einem oder mehreren Beispielwerten, sofern vorhanden.</xd:p>
		</xd:desc>
	</xd:doc>
	<xsl:template match="*" mode="lite:dokumentation.eigenschaften.beispielwert">
		<!-- Aufbau des Templates aus baustein_in_paketstruktur.xsl übernommen, könnte in uebersetzungsanweisungen.common-templates.xsl zusammengefasst werden. -->
		<xsl:if test="beispielwert">
			<para role="beispielwert">
				<xsl:choose>
					<xsl:when test="count(beispielwert) = 1">
						<xsl:text>Beispielwert: </xsl:text>
					</xsl:when>
					<xsl:otherwise>
						<xsl:text>Beispielwerte: </xsl:text>
					</xsl:otherwise>
				</xsl:choose>					
				<xsl:for-each select="beispielwert">
					<xsl:value-of select="."/>
					<xsl:if test="position() != last()">
						<xsl:text>, </xsl:text>
					</xsl:if>
				</xsl:for-each>
			</para>
		</xsl:if>
	</xsl:template>	
	
	<xd:doc>
		<xd:desc>
			<xd:p>Erzeuge eine Tabelle mit Geschäftsregeln.</xd:p>
		</xd:desc>
	</xd:doc>
	<xsl:template match="eigenschaft" mode="lite:dokumentation.eigenschaften.geschaeftsregeln">
		<!-- Die Tabelle wird nur dann erzeugt, wenn es mindestens eine "geschaeftsregel" gibt. -->
		<xsl:if test="geschaeftsregel">
			
				<para><emphasis role="strong">Geschäftsregeln</emphasis></para>
				<informaltable xml:id="table.{lite:docbook-id(.)}.rules">
					<tgroup cols="2">
						<colspec colname="id" colnum="1" colwidth="20mm"/>
						<colspec colname="regel" colnum="2" colwidth="130mm"/>
						<thead>
							<row>
								<entry>ID</entry>
								<entry>Regel / XPath</entry>
							</row>
						</thead>
						<tbody>
							<xsl:for-each select="geschaeftsregel">
								<xsl:sort select="@kennung"/>
								<row role="geschaeftsregel">
									<entry morerows="1">
										<!-- Liefert die @kennung zurück, aber mit einem "zero width space (ZWSP)" zwischen den einzelnen Buchstaben.
											  Damit wird ein Trennalgorithmus beim Setzen des Dokuments gezielt ausgehebelt.-->
										<xsl:variable name="zwsp" select="'&#x200B;'"/>
										<xsl:value-of select="replace(@kennung, '(.)', concat('$1', $zwsp))"/>
									</entry>
									<entry role="beschreibung">
										<xsl:apply-templates select="beschreibung" mode="lite:dokumentation.beschreibung"/>
									</entry>
								</row>
								<row>
									<entry role="spezifikation">
										<para>
											<emphasis role="codebf"><xsl:value-of select="spezifikation"/></emphasis>
										</para>
									</entry>
								</row>
							</xsl:for-each>
						</tbody>
					</tgroup>
				</informaltable>
		</xsl:if>
		
		<!-- TODO Zu klären: Darstellung von  -->
		<!-- 
			<para>Verbindlichkeit: <xsl:value-of select="@verbindlichkeit"/></para>
			<para>Auswertungskontext: <xsl:value-of select="auswertungskontext"/></para>
			<para>Fachkontext: <xsl:value-of select="fachkontext"/></para>
		-->
	</xsl:template>

	

	<xd:doc>
		<xd:desc> Diese Funktion erzeugt Icons für bestimmte Strukturelemente.</xd:desc>
		<xd:param name="strukturtyp">
			<xd:p>String, der das Strukturelement bezeichnet. Momentan unterstützt:</xd:p>
			<xd:p>
				<xd:ul>
					<xd:li><xd:b>sequence</xd:b> Gruppenart sequence</xd:li>
					<xd:li><xd:b>choice</xd:b> Gruppenart choice</xd:li>
					<xd:li><xd:b>all</xd:b> Gruppenart all</xd:li>
					<xd:li><xd:b>attribute</xd:b> Attribut</xd:li>
					<xd:li><xd:b>typ</xd:b> Datentyp</xd:li>
					<xd:li><xd:b>basistyp</xd:b> Basistyp</xd:li>
					<xd:li><xd:b>type_simple</xd:b> nutztEinfachenDatentyp</xd:li>
					<xd:li><xd:b>type_complex</xd:b> nutztKomplexenDatentyp</xd:li>
					<xd:li><xd:b>ref_element</xd:b> nutztGlobalesElement</xd:li>
					<xd:li><xd:b>ref_attribute</xd:b> nutztGlobalesAttribut</xd:li>
					<xd:li><xd:b>ref_element_group</xd:b> nutztGlobaleElementgruppe</xd:li>
					<xd:li><xd:b>ref_attribute_group</xd:b> nutztGlobaleAttributgruppe</xd:li>
				</xd:ul>
			</xd:p>
		</xd:param>
	</xd:doc>
	<xsl:function name="lite:gibStrukturIcon">
		<xsl:param name="strukturtyp" as="xs:string"/>

		<xsl:variable name="Dateiname">
			<xsl:choose>
				<xsl:when test="$strukturtyp = 'sequence'">/gruppenart sequenz.svg</xsl:when>
				<xsl:when test="$strukturtyp = 'choice'">/gruppenart auswahl.svg</xsl:when>
				<xsl:when test="$strukturtyp = 'all'">/gruppenart alle.svg</xsl:when>
				<xsl:when test="$strukturtyp = 'attribute'">/attribut.svg</xsl:when>
				<xsl:when test="$strukturtyp = 'typ'">/einfacher datentyp.svg</xsl:when>
				<xsl:when test="$strukturtyp = 'basistyp'">/basistyp_GR.svg</xsl:when>
				<xsl:when test="$strukturtyp = 'type_simple'">/nutztEinfachenDatentyp.svg</xsl:when>
				<xsl:when test="$strukturtyp = 'type_complex'">/nutztKomplexenDatentyp.svg</xsl:when>
				<xsl:when test="$strukturtyp = 'ref_element'">/nutztGlobalesElement.svg</xsl:when>
				<xsl:when test="$strukturtyp = 'ref_attribute'">/nutztGlobalesAttribut.svg</xsl:when>
				<xsl:when test="$strukturtyp = 'ref_element_group'">/nutztGlobaleElementgruppe.svg</xsl:when>
				<xsl:when test="$strukturtyp = 'ref_attribute_group'">/nutztGlobaleAttributgruppe.svg</xsl:when>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="Alternativtext">
			<xsl:choose>
				<xsl:when test="$strukturtyp = 'sequence'">Sequence</xsl:when>
				<xsl:when test="$strukturtyp = 'choice'">Choice</xsl:when>
				<xsl:when test="$strukturtyp = 'all'">All</xsl:when>
				<xsl:when test="$strukturtyp = 'attribute'">@</xsl:when>
				<xsl:when test="$strukturtyp = 'typ'">Typ</xsl:when>
				<xsl:when test="$strukturtyp = 'basistyp'">Basistyp</xsl:when>
				<xsl:when test="$strukturtyp = 'type_simple'">einf. Datentyp</xsl:when>
				<xsl:when test="$strukturtyp = 'type_complex'">kplx. Datentyp</xsl:when>
				<xsl:when test="$strukturtyp = 'ref_element'">glob. Element</xsl:when>
				<xsl:when test="$strukturtyp = 'ref_attribute'">glob. Attribut</xsl:when>
				<xsl:when test="$strukturtyp = 'ref_element_group'">glob. Elementgruppe</xsl:when>
				<xsl:when test="$strukturtyp = 'ref_attribute_group'">glob. Attributgruppe</xsl:when>
			</xsl:choose>
		</xsl:variable>
		<xsl:sequence>
			<inlinemediaobject>
				<imageobject>
					<imagedata fileref="{concat($icon-directory, $Dateiname)}" width="0.8em"
						depth="0.8em" valign="middle"/>
				</imageobject>
				<textobject>
					<para>
						<xsl:value-of select="$Alternativtext"/>
					</para>
				</textobject>
			</inlinemediaobject>
		</xsl:sequence>
	</xsl:function>


</xsl:stylesheet>
