<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:db="http://docbook.org/ns/docbook" xmlns:gc="http://docs.oasis-open.org/codelist/ns/genericode/1.0/" xmlns:log="http://www.xoev.de/de/xgenerator/framework/1/log" xmlns:xoev-cl-2="http://xoev.de/schemata/genericode/2" xmlns:xoev-cl-4="http://xoev.de/schemata/genericode/4" xmlns:lite="urn:xoev-de:kosit:xoev:lite:transformation_1.2.0" xmlns:lite-bib="urn:xoev-de:kosit:xoev:lite:schema:bibliothek_1.2.0" xmlns:lite-fm="urn:xoev-de:kosit:xoev:lite:schema:fachmodell_1.2.0" xmlns:xgen="http://www.xoev.de/de/xgenerator/framework/1/library" xmlns:xi="http://www.w3.org/2001/XInclude" xmlns="http://docbook.org/ns/docbook" xpath-default-namespace="urn:xoev-de:kosit:xoev:lite:schema:fachmodell_1.2.0" version="2.0" exclude-result-prefixes="xgen xsl xs db gc log xoev-cl-2 xoev-cl-4 lite lite-fm lite-bib">


  <!-- Einstiegspunkt für die Generierung -->
  <xsl:template match="xoev-fachmodell" mode="lite:paket-abschnitt-paketstruktur">
    <xsl:apply-templates select="." mode="lite:paketstruktur">
      <xsl:with-param name="pfad" select="'dokumente'"/>
    </xsl:apply-templates>
  </xsl:template>

  <xsl:function name="lite:ist-baustein" as="xs:boolean">
    <xsl:param name="objekt" as="element()"/>
    <xsl:sequence select="not(empty($objekt[self::nachricht or self::codeDatentyp or self::datentyp or self::globaleEigenschaftengruppe or self::globaleEigenschaft]))"/>
  </xsl:function>


  <!-- Erzeuge Datei-->
  <xsl:template match="*" mode="lite:paketstruktur lite:contentfile">
    <xsl:param name="pfad"/>
    
    <xsl:variable name="dateipfad">
      <xsl:choose>
        <xsl:when test="self::xoev-fachmodell">
          <xsl:value-of select="concat($pfad, '/', 'Paket-', lite:set-path-or-filename(metadaten.standard/nameTechnisch))"/>
        </xsl:when>
        <xsl:when test="self::paket or self::xsdSchema">
          <xsl:value-of select="concat($pfad, '/', 'Paket-', lite:set-path-or-filename(@name))"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="concat($pfad, '/', lite:set-path-or-filename(@name))"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

    <xsl:variable name="ordnerpfad">
      <xsl:choose>
        <xsl:when test="self::xoev-fachmodell">
          <xsl:value-of select="concat($pfad, '/', lite:set-path-or-filename(metadaten.standard/nameTechnisch))"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="concat($pfad, '/', lite:set-path-or-filename(@name))"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>


  <!-- Erzeugung des Schemas als Vorbereitung der svg-Generierung -->
    <xsl:variable name="baustein.schema" as="element()?">
      <xsl:if test="$generiere-svg">
      <!-- Template ist enthalten in lite2xsd.uebersetzungsanweisungen.xsl -->
      <xsl:apply-templates select=".[not(self::paket or self::xsdSchema or self::xoev-fachmodell) and lite:baustein-has-svg-content(.)]" mode="lite:baustein"/>
        </xsl:if>
    </xsl:variable>

    <!-- Erzeugung der svg-Grafik aus einem Schema -->
    <xsl:variable name="svg-content" as="element()?">
      <xsl:if test="$generiere-svg">
      <!-- FIXME svg-Erzeugung für lokale Tests auskommentiert, führt zu Fehler -->
      <!-- Template enthalten in xsd2svg.uebersetzungsanweisungen.xsl -->
      <xsl:apply-templates select="$baustein.schema" mode="lite:svg"/>
      </xsl:if>
    </xsl:variable>

    
    
    <xsl:variable name="locpath" select="concat($dateipfad, '.adoc')"/>

    <!-- Diese Variable enthält den Content einer zu erzeugenden Datei. -->
    <xsl:variable name="content">
      <xsl:choose>

        <xsl:when test="self::paket or self::xsdSchema or self::xoev-fachmodell">
          <xsl:choose>
            <xsl:when test="*[@name and (not((self::paket or self::xsdSchema)) or descendant::*[lite:ist-baustein(.)])]">
              <xsl:apply-templates select=".[*[@name and (not((self::paket or self::xsdSchema)) or descendant::*[lite:ist-baustein(.)])]]" mode="lite:paketinclude"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:value-of select="concat('= ', lite:set-path-or-filename(@name), '&#x0A;')"/>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:when>
        <xsl:when test="$generiere-svg">
          <xsl:apply-templates select="." mode="lite:content">
            <!-- FIXME svg-Erzeugung führt bei lokalem Test zu Fehler,
                   daher werden die mit per ant-Skript erzeugten svgs verwendet 
                   und hier Dummy-svg-Maße angegeben -->
            <xsl:with-param name="svg-width" select="$svg-content/@width"/>
            <xsl:with-param name="svg-height" select="$svg-content/@height"/>
            <!--<xsl:with-param name="svg-width" select="'250'"/>
            <xsl:with-param name="svg-height" select="'250'"/>-->
            <xsl:with-param name="locpath" select="$locpath"/>
          </xsl:apply-templates>
        </xsl:when>
        <xsl:otherwise>
          <xsl:apply-templates select="." mode="lite:content">
            <xsl:with-param name="locpath" select="$locpath"/>
          </xsl:apply-templates>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

    <!-- Hier wird das Template zur Dateierzeugung aufgerufen -->
    <xsl:if test="not(empty($content))">
      <xsl:call-template name="xgen:result-document">
        <xsl:with-param name="local-path" select="xs:anyURI($locpath)"/>
        <xsl:with-param name="method">text</xsl:with-param>
        <xsl:with-param name="content" select="$content"/>
      </xsl:call-template>
    </xsl:if>

    <xsl:if test="$svg-content">
      <xsl:call-template name="lite:write-file-return-log">
        <xsl:with-param name="content" select="$svg-content"/>
        <xsl:with-param name="local-path" select="xs:anyURI(concat('zeichnungen', substring-after($dateipfad, 'dokumente'), '.svg'))"/>
      </xsl:call-template>
    </xsl:if>

    <xsl:choose>
      <xsl:when test="self::xoev-fachmodell">
        <xsl:apply-templates select="paket | xsdSchema" mode="lite:contentfile">
          <xsl:with-param name="pfad" select="$ordnerpfad"/>
        </xsl:apply-templates>
      </xsl:when>

      <xsl:when test="self::paket or self::xsdSchema">
        <xsl:apply-templates select="*[@name]" mode="lite:contentfile">
          <xsl:with-param name="pfad" select="$ordnerpfad"/>
        </xsl:apply-templates>
      </xsl:when>
    </xsl:choose>

  </xsl:template>

  <!-- Erzeuge den gewünschten Content 
	     für xoev-fachmodell paket und xsdschema Elemente
	     wird als content include Elemente zu anderen Dateien erzeugt
	     für jedes Kind-Paket und Content Element eins-->

  <xsl:template match="xoev-fachmodell" mode="lite:paketinclude">

    <xsl:value-of select="concat('= ', metadaten.standard/nameTechnisch, '&#x0A;&#x0A;')"/>

    <xsl:apply-templates select="." mode="lite:dokumentation.adoc-header"/>

    <xsl:text>:leveloffset: +1&#x0A;&#x0A;</xsl:text>
    <xsl:for-each select="(paket | xsdSchema)[descendant::*[lite:ist-baustein(.)]]">
      <xsl:variable name="Includepath" select="concat(lite:set-path-or-filename(parent::xoev-fachmodell/metadaten.standard/nameTechnisch), '/', 'Paket-', lite:set-path-or-filename(@name), '.adoc')"/>

      <xsl:value-of select="concat('include::', $Includepath, '[]&#x0A;&#x0A;')"/>
    </xsl:for-each>
    <xsl:text>:leveloffset: -1&#x0A;&#x0A;</xsl:text>
    
  </xsl:template>

  <xsl:template match="paket | xsdSchema" mode="lite:paketinclude">

    <xsl:value-of select="concat('= ', @name, '&#x0A;&#x0A;')"/>

    <xsl:apply-templates select="." mode="lite:dokumentation.adoc-header"/>

    <xsl:text>:leveloffset: +1&#x0A;&#x0A;</xsl:text>
    <xsl:if test="self::xsdSchema[.//nachricht]">
      <xsl:variable name="table-filename" select="
          concat('tabelle.nachrichten.', lite:set-path-or-filename(@name), '.adoc')"/>
      <xsl:value-of select="concat('include::', $table-filename, '[]&#x0A;&#x0A;')"/>
    </xsl:if>

    <xsl:for-each select="*[@name]">
      
      <xsl:variable name="Includepath">
        <xsl:choose>
          <xsl:when test="self::paket | self::xsdSchema">
            <xsl:value-of select="concat(lite:set-path-or-filename(parent::*/@name), '/', 'Paket-', lite:set-path-or-filename(@name), '.adoc')"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="concat(lite:set-path-or-filename(parent::*/@name), '/', lite:set-path-or-filename(@name), '.adoc')"/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>

      <!-- Wenn es sich nicht um ein leeres Paket handelt, ... -->
      <xsl:if test="not((self::paket | self::xsdSchema) and empty(descendant::*[lite:ist-baustein(.)]))">
        <xsl:value-of select="concat('include::', $Includepath, '[]&#x0A;&#x0A;')"/>
      </xsl:if>
      
    </xsl:for-each>
    
    <xsl:text>:leveloffset: -1&#x0A;&#x0A;</xsl:text>
    
  </xsl:template>

  <!-- Erzeuge den gewünschten Content 
	     für Content-Elemente mit name Attribut in paketen wird als content
	     docbook erzeugt das in eigenen Templates bestimmt wird
	     
	     dh. template match="element" mode="lite:content" ist einstiegspunkt
	     zur Erzeugung des Inhalts der content Elemente
   -->
  <xsl:template match="*" mode="lite:content">
    <xsl:param name="svg-width" as="xs:string?"/>
    <xsl:param name="svg-height" as="xs:string?"/>
    <xsl:param name="locpath" as="xs:string?"/>

    <xsl:apply-templates select="." mode="lite:content-paketstruktur">
      <xsl:with-param name="svg-width" select="$svg-width"/>
      <xsl:with-param name="svg-height" select="$svg-height"/>
    </xsl:apply-templates>
  </xsl:template>
</xsl:stylesheet>
