<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xd="http://www.oxygenxml.com/ns/doc/xsl"
	xmlns:db="http://docbook.org/ns/docbook"
	xmlns:gc="http://docs.oasis-open.org/codelist/ns/genericode/1.0/"
	xmlns:xoev-cl-2="http://xoev.de/schemata/genericode/2"
	xmlns:xoev-cl-4="http://xoev.de/schemata/genericode/4"
	xmlns:lite="urn:xoev-de:kosit:xoev:lite:transformation_1.2.0"
	xmlns:lite-bib="urn:xoev-de:kosit:xoev:lite:schema:bibliothek_1.2.0"
	xmlns:lite-fm="urn:xoev-de:kosit:xoev:lite:schema:fachmodell_1.2.0"
	xmlns:xgen="http://www.xoev.de/de/xgenerator/framework/1/library"
	xmlns="http://docbook.org/ns/docbook"
	xpath-default-namespace="urn:xoev-de:kosit:xoev:lite:schema:fachmodell_1.2.0"
	version="2.0"
	exclude-result-prefixes="xgen xsl xs db gc xoev-cl-2 xoev-cl-4 lite lite-fm lite-bib">


	<xd:doc scope="stylesheet">
		<xd:desc>
			<xd:p>Dieses Stylesheet stellt die Templates für die Erzeugung von vier XÖV lite
				Bausteinen <xd:i>(Nachrichten, Datentypen, globale Eigenschaften, globale
					Eigenschaftengruppen)</xd:i> bereit.</xd:p>
		</xd:desc>
	</xd:doc>


	<xd:doc scope="component">
		<xd:desc>
			<xd:p>Erzeuge den Content für einen Baustein. Dabei werden ausschließlich Bausteine
				berücksichtigt, die sich nicht im Entwurfsstand befinden.</xd:p>
			<xd:p>Aufgrund der strukturellen Ähnlichkeiten ist <xd:b>ein</xd:b> Einstiegstemplate
				für die Bausteinarten <xd:i>Nachricht</xd:i>, <xd:i>Datentyp</xd:i>, <xd:i>globale
					Eigenschaftengruppe</xd:i> und <xd:i>globale Eigenschaft</xd:i>
				ausreichend.</xd:p>
		</xd:desc>
		<xd:param name="svg-width">Breite der Grafik der Bausteinstruktur</xd:param>
		<xd:param name="svg-height">Höhe der Grafik der Bausteinstruktur</xd:param>
	</xd:doc>
	<xsl:template match="
			nachricht[not(@draft = 'true')]
			| datentyp[not(@draft = 'true')]
			| globaleEigenschaftengruppe[not(@draft = 'true')]
			| globaleEigenschaft[not(@draft = 'true')]" mode="lite:content-paketstruktur">
		<xsl:param name="svg-width" as="xs:string?"/>
		<xsl:param name="svg-height" as="xs:string?"/>

		<xsl:apply-templates select="." mode="lite:dokumentation.adoc-header"/>

		<!-- ID (als Sprungziel) für Abschnitt erzeugen: -->
		<xsl:value-of select="concat('[id=', lite:docbook-id(.), ']&#x0A;')"/>

		<!-- Titel erzeugen: -->

		<xsl:value-of select="concat('= ', (@titel, @name)[1], '&#x0A;&#x0A;')"/>

		<!-- Subtitel (= technischer Name) erzeugen -->
		<xsl:choose>
			<xsl:when test="self::nachricht">
				<xsl:text>Nachricht: </xsl:text>
			</xsl:when>
			<xsl:when test="self::datentyp">
				<xsl:text>Typ: </xsl:text>
			</xsl:when>
			<xsl:when test="self::globaleEigenschaftengruppe">
				<xsl:text>Globale Eigenschaftengruppe: </xsl:text>
			</xsl:when>
			<xsl:when test="self::globaleEigenschaft">
				<xsl:text>Globale Eigenschaft: </xsl:text>
			</xsl:when>
		</xsl:choose>
		<xsl:value-of select="
				concat('`*', @name, if (@abstrakt = 'true') then
					'*` (abstrakt)'
				else
					'*`', '&#x0A;&#x0A;')"/>

		<!-- Bei Nachrichten können Autor- und Leserangaben vorhanden sein. -->
		<xsl:if test="self::nachricht">
			<xsl:apply-templates select="@autor"
				mode="lite:dokumentation.nachricht.autor-oder-leser"/>
			<xsl:apply-templates select="@leser"
				mode="lite:dokumentation.nachricht.autor-oder-leser"/>
		</xsl:if>

		<!-- Weitere Angaben bei globalen Eigenschaften -->
		<xsl:if test="self::globaleEigenschaft[@typ]">
			<xsl:variable name="artDerEigenschaft" select="
					if (@xsdAttribute = true()) then
						'Attribut'
					else
						'Element'"/>

			<xsl:value-of select="concat('Typ des ', $artDerEigenschaft, 's: ', @typ)"/>

			<!-- Link nur erzeugen, wenn kein W3C Simple Type vorliegt -->
			<xsl:if test="not(starts-with(@typ, 'xs:'))">
				<xsl:variable name="zielbaustein" select="lite:resolve(@typ, ., false())"/>
				<xsl:variable name="bausteinpfad" select="lite:baustein-pfad($zielbaustein)"/>
				<xsl:variable name="bausteinid" select="lite:docbook-id($zielbaustein)"/>
				<!-- Bei Erzeugung des gesamten Dokuments wird ein interner Link erzeugt, 
					beim Einzeldokument ein externer Link -->
				<xsl:text>&#x0A;ifdef::volldokument[]&#x0A;</xsl:text>
				<xsl:value-of select="concat(' (siehe xref:#', $bausteinid, '[])&#x0A;')"/>
				<xsl:text>endif::[]&#x0A;</xsl:text>
				<xsl:text>ifndef::volldokument[]&#x0A;</xsl:text>
				<xsl:value-of select="concat(' (siehe xref:', $bausteinpfad, '.adoc[hier])&#x0A;')"/>
				<xsl:text>endif::[]&#x0A;</xsl:text>
			</xsl:if>

			<xsl:text>&#x0A;&#x0A;</xsl:text>

			<xsl:if test="@fixedWert">
				<xsl:value-of
					select="concat('In diesem ', $artDerEigenschaft, ' ist nur der Wert &quot;', @fixedWert, '&quot; zulässig (fixed-Wert).&#x0A;&#x0A;')"/>

			</xsl:if>
			<xsl:if test="@defaultWert">
				<xsl:value-of select="
						concat('Dieses ', $artDerEigenschaft, ' hat den Wert &quot;', @defaultWert, '&quot;,
					sofern kein anderer Wert übermittelt wird (default-Wert).&#x0A;&#x0A;')"/>

			</xsl:if>
		</xsl:if>

		<!-- Erzeuge die Kerndokumentation für einen Baustein. -->

		<xsl:apply-templates select="beschreibung"
			mode="lite:dokumentation.FliesstextUndDocBookType"/>

		<xsl:apply-templates select="umsetzungshinweis"
			mode="lite:dokumentation.FliesstextUndDocBookType"/>

		<!-- Bei Nachrichten können Rechtsgrundlagen vorhanden sein. -->
		<xsl:if test="self::nachricht">
			<xsl:apply-templates select="." mode="lite:dokumentation.nachricht.rechtsgrundlage"/>
		</xsl:if>

		<!-- Eine Einbindung (und auch Generierung) eines SVGs erfolgt nur dann, wenn der Baustein SVG-relevanten Content hat. -->

		<xsl:if test="$generiere-svg and lite:baustein-has-svg-content(.)">
			<!-- Pfad wie für lite2db relativ zur Datei des Bausteins -->
			<xsl:variable name="navigate-up" select="
					string-join(for $step in ancestor-or-self::*
					return
						'../')"/>
			<xsl:variable name="pfadRelativZuBaustein"
				select="lite:set-path-or-filename(concat($navigate-up, 'zeichnungen/', /xoev-fachmodell/metadaten.standard/nameTechnisch, '/', string-join(ancestor-or-self::*/@name, '/'), '.svg'))"/>

			<!-- Pfad relativ zum Stammverzeichnis für Bilder, das als Dokumentattribut angegeben ist -->
			<xsl:variable name="pfadRelativ"
				select="lite:set-path-or-filename(concat(/xoev-fachmodell/metadaten.standard/nameTechnisch, '/', string-join(ancestor-or-self::*/@name, '/'), '.svg'))"/>

			<xsl:variable name="scaleDecimal"
				select="floor(min((1.1, 750.0 div number($svg-width), 1000.0 div number($svg-height))))"/>

			<xsl:variable name="scaledWidth" select="round($scaleDecimal * number($svg-width))"/>
			<xsl:variable name="scaledHeight" select="round($scaleDecimal * number($svg-height))"/>

			<xsl:value-of select="concat('[id=figure.', lite:docbook-id(.), ']&#x0A;')"/>
			<xsl:value-of
				select="concat('image::', $pfadRelativ, '[', @name, ',', $scaledWidth, ', ', $scaledHeight, ', align=&quot;center&quot;]&#x0A;&#x0A;')"/>

		</xsl:if>

		<!-- Verarbeite Basistyp-Informationen, sofern vorhanden. -->
		<xsl:apply-templates select="." mode="lite:dokumentation.baustein.basistyp"/>

		<!-- Erzeuge Beispielwerte, sofern vorhanden. -->
		<xsl:apply-templates select="." mode="lite:dokumentation.baustein.beispielwert"/>

		<!-- Verarbeite Eigenschaften, sofern vorhanden. -->
		<xsl:apply-templates select="." mode="lite:dokumentation.eigenschaften"/>

		<!-- Verarbeite Geschäftsregeln, sofern vorhanden. -->
		<xsl:apply-templates select="." mode="lite:dokumentation.geschaeftsregeln"/>

		<!-- Bei Datentypen sind Nutzungs- und Ableitungsinformationen zu erzeugen. -->
		<!--<xsl:if test="self::datentyp">
				<xsl:comment>*** Nutzung des Datentyps: to be done ***</xsl:comment>
				<xsl:call-template name="annotation.todo.xoevlite.developer">
					<xsl:with-param name="titel">Nutzung des Datentyps: OFFEN</xsl:with-param>
					<xsl:with-param name="beschreibung">An dieser Stelle sind diejenigen Nachrichten (Liste der Nachrichtennummern) aufzuführen, die diesen Datentyp verwenden. Falls es Datentypen gibt, die von diesem Datentyp abgeleitet werden (als Einschränkung oder Erweiterung), sind diese ebenfalls aufzuführen (Liste der Datentypen). – Es ist noch zu klären, ob diese Listen auch für globale Eigenschaften und globale Gruppen sinnvoll sind. MK weist darauf hin, dass es auch für diese Bausteinarten hilfreich sein könnte ihren Einsatzort (Nachrichten) angezeigt zu bekommen. Dies ist derzeit noch nicht aktiviert / vorgesehen; das umfassende xsl:if müsste dann um die Bausteine 'globaleEigenschaftengruppe' und 'globaleEigenschaft' ergänzt werden.</xsl:with-param>
					<xsl:with-param name="url">https://projekte.kosit.org/xoev/lite-projekte/lite-dokumentation/-/issues/46</xsl:with-param>
				</xsl:call-template>
			</xsl:if>-->
	</xsl:template>


	<xd:doc scope="component">
		<xd:desc>
			<xd:p>Dieses Template erzeugt Angaben zum Autor bzw. Leser.</xd:p>
		</xd:desc>
	</xd:doc>
	<xsl:template match="@autor | @leser" mode="lite:dokumentation.nachricht.autor-oder-leser">

		<xsl:value-of select="
				concat(if (name() = 'autor') then
					'*Autor: '
				else
					'*Leser: ', ., '*&#x0A;&#x0A;')"/>

	</xsl:template>


	<xd:doc scope="component">
		<xd:desc>
			<xd:p>Dieses Template erzeugt einen Eintrag für Rechtsgrundlagen, sofern
				vorhanden.</xd:p>
		</xd:desc>
	</xd:doc>
	<xsl:template match="nachricht" mode="lite:dokumentation.nachricht.rechtsgrundlage">
		<xsl:if test="rechtsgrundlage">
			<xsl:text>*Rechtsgrundlagen:*&#x0A;&#x0A;</xsl:text>
			<xsl:for-each select="rechtsgrundlage">
				<!-- Achtung: Rechtsgrundlage einer Nachricht hat FliesstextUndDocBookType, nicht nur String! -->
				<xsl:text>* </xsl:text>
				<xsl:apply-templates select="." mode="lite:dokumentation.FliesstextUndDocBookType"/>
				<xsl:text>&#x0A;</xsl:text>
			</xsl:for-each>
			<xsl:text>&#x0A;</xsl:text>
		</xsl:if>
	</xsl:template>


	<xd:doc scope="component">
		<xd:desc>
			<xd:p>Dieses Template erzeugt ergänzende Dokumentation, falls Basistyp-Informationen
				vorliegen.</xd:p>
		</xd:desc>
	</xd:doc>
	<xsl:template match="nachricht | datentyp | globaleEigenschaftengruppe | globaleEigenschaft"
		mode="lite:dokumentation.baustein.basistyp">
		<xsl:if test="@basistyp">
			<xsl:variable name="isRestriction" select="
					if (@restriction[. = 'true']) then
						true()
					else
						false()"/>
			<xsl:variable name="basistyp" select="lite:resolve(@basistyp, ., false())"/>

			<!-- a) Vererbungsinfo generieren (Einschränkung oder Erweiterung; ggf. Querreferenz im Dokument) -->
			<xsl:variable name="baustein">
				<xsl:choose>
					<xsl:when test="self::nachricht">
						<xsl:text>Diese Nachricht</xsl:text>
					</xsl:when>
					<xsl:when test="self::datentyp">
						<xsl:text>Dieser Datentyp</xsl:text>
					</xsl:when>
					<xsl:when test="self::globaleEigenschaftengruppe">
						<xsl:text>Diese globale Eigenschaftengruppe</xsl:text>
					</xsl:when>
					<xsl:when test="self::globaleEigenschaft">
						<xsl:text>Diese globale Eigenschaft</xsl:text>
					</xsl:when>
					<xsl:otherwise>
						<!-- sollte derzeit kaum erreichbar sein ;-) -->
						<xsl:text>Dieses globale Element</xsl:text>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>

			<!-- Angaben zum Basistyp -->
			<xsl:value-of select="
					concat($baustein, ' ist eine ', if ($isRestriction) then
						'Einschränkung'
					else
						'Erweiterung',
					' des Basistyps ')"/>

			<xsl:value-of
				select="concat('`*', lite:kuerze-internen-typnamen(@basistyp, $basistyp), '*`')"/>

			<!-- Link nur erzeugen, wenn kein W3C Simple Type vorliegt -->
			<xsl:if test="not(lite:reference-is-w3c-simpletype(@basistyp))">

				<!-- Bei Erzeugung des gesamten Dokuments wird ein interner Link erzeugt, beim Einzeldokument ein externer Link -->
				<xsl:text>&#x0A;ifdef::volldokument[]&#x0A;</xsl:text>
				<xsl:value-of
					select="concat(' (siehe xref:#', lite:docbook-id($basistyp), '[])&#x0A;')"/>
				<xsl:text>endif::[]&#x0A;</xsl:text>
				<xsl:text>ifndef::volldokument[]&#x0A;</xsl:text>
				<xsl:value-of
					select="concat(' (siehe xref:', lite:baustein-pfad($basistyp), '.adoc[hier])&#x0A;')"/>
				<xsl:text>endif::[]&#x0A;</xsl:text>

			</xsl:if>
			<xsl:text>.&#x0A;&#x0A;</xsl:text>

			<!-- b) Pattern, falls vorhanden (andere Behandlung als die anderen W3C-Facetten!) -->
			<xsl:variable name="pattern" as="xs:string*">+++<xsl:value-of select="@pattern"
				/>+++</xsl:variable>
			<!--		  <xsl:variable name="pattern" as="xs:string*"><![CDATA[<![CDATA[]]><xsl:value-of select="@pattern"/>]]&gt;</xsl:variable>-->

			<!-- TODO: prüfen, ob das Escaping sowohl in HTML als auch in pdf korrekt funktioniert -->
			<xsl:if test="@pattern[. != '']">
				<xsl:text>Die Werte müssen dem Muster '</xsl:text>
				<xsl:value-of select="lite:unescaped-xml(string-join($pattern, ''))"/>
				<xsl:text>' entsprechen.&#x0A;&#x0A;</xsl:text>
			</xsl:if>

			<!-- c) Weitere W3C-Facetten, falls vorhanden -->
			<xsl:variable name="otherFacets" select="
					(@fractionDigits, @length, @maxExclusive, @maxInclusive,
					@maxLength, @minExclusive, @minInclusive, @minLength,
					@totalDigits, @whitespace)"/>
			<xsl:if test="$otherFacets">
				<xsl:text>Beschränkungen (XML-Schema-Facetten): </xsl:text>

				<xsl:for-each select="$otherFacets">
					<xsl:value-of select="concat(name(), ':', .)"/>
					<xsl:if test="position() != last()">
						<xsl:text>, </xsl:text>
					</xsl:if>
				</xsl:for-each>
				<xsl:text>&#x0A;&#x0A;</xsl:text>
			</xsl:if>
		</xsl:if>
	</xsl:template>


	<xd:doc>
		<xd:desc>
			<xd:p>Gibt den Pfad zur Datei des Bausteins aus, relativ zum dokumente-Verzeichnis, ohne
				Dateiendung</xd:p>
			<xd:p>Beruht auf Funktion lite:qualifizierter-name aus
				helpers.lite-dokumentation.xsl</xd:p>
		</xd:desc>
		<xd:param name="element">
			<xd:p>Element, dessen Pfad ausgegeben werden soll</xd:p>
		</xd:param>
	</xd:doc>
	<xsl:function name="lite:baustein-pfad" as="xs:string">
		<xsl:param name="element" as="node()"/>
		<xsl:choose>
			<xsl:when
				test="$element/parent::xoev-fachmodell or $element/parent::lite-bib:xoev-bibliothek">
				<xsl:sequence
					select="concat($element/parent::*/(metadaten.standard/nameTechnisch, lite-bib:metadaten.bibliothek/lite-bib:nameTechnisch), '/', $element/@name)"
				/>
			</xsl:when>
			<xsl:when
				test="not(lite:modell-kennung($element) = lite:modell-kennung($xoev-modell)) or not(lite:modell-version($element) = lite:modell-version($xoev-modell))">
				<xsl:sequence
					select="concat('anhang/externeModelle/externeModelle.adoc#', replace(concat('externes.modell.', lite:modell-kennung($element), '_', lite:modell-version($element)), '[:\-]+', '_'))"
				/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:sequence
					select="concat(lite:baustein-pfad($element/parent::*), '/', $element/@name)"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:function>


	<xd:doc scope="component">
		<xd:desc>
			<xd:p>Dieses Template erzeugt einen Eintrag mit einem oder mehreren Beispielwerten,
				sofern vorhanden.</xd:p>
		</xd:desc>
	</xd:doc>
	<xsl:template match="nachricht | datentyp | globaleEigenschaftengruppe | globaleEigenschaft"
		mode="lite:dokumentation.baustein.beispielwert">
		<xsl:if test="beispielwert">
			<xsl:value-of select="
					if (count(beispielwert) = 1) then
						'Beispielwert: '
					else
						'Beispielwerte: '"/>
			<xsl:for-each select="beispielwert">
				<xsl:value-of select="."/>
				<xsl:if test="position() != last()">
					<xsl:text>, </xsl:text>
				</xsl:if>
			</xsl:for-each>
			<xsl:text> &#x0A;&#x0A;</xsl:text>
		</xsl:if>
	</xsl:template>

</xsl:stylesheet>
