<xsl:stylesheet 
   xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
   xmlns:log="http://www.xoev.de/de/xgenerator/framework/1/log" 
   xmlns:xgen="http://www.xoev.de/de/xgenerator/framework/1/library" 
   xmlns:xs="http://www.w3.org/2001/XMLSchema" 
   xmlns:lite="urn:xoev-de:kosit:xoev:lite:transformation_1.2.0" 
   xmlns:lite-bib="urn:xoev-de:kosit:xoev:lite:schema:bibliothek_1.2.0" 
   xmlns:err="http://www.w3.org/2005/xqt-errors" 
   xmlns:xd="http://www.oxygenxml.com/ns/doc/xsl" 
   xmlns:db="http://docbook.org/ns/docbook"
   xmlns:xlink="http://www.w3.org/1999/xlink"
   xmlns="http://docbook.org/ns/docbook"
   xpath-default-namespace="urn:xoev-de:kosit:xoev:lite:schema:fachmodell_1.2.0" version="2.0"
   exclude-result-prefixes="err xsl lite log xgen xs lite-bib xd db">
   
   <xd:doc scope="component" id="lite:modell-kennung">
      <xd:desc>
         <xd:p>Ermittelt die Kennung des Standards, in dem sich der gegebene Inhalt befindet.</xd:p>
      </xd:desc>
      <xd:param name="element">Ein Bestandteil des XÖV-Fachmodells in der Form eines lite-Elements (z. B. <xd:i>nachricht</xd:i> oder <xd:i>xoev-fachmodell</xd:i>).</xd:param>
      <xd:return>Kennung des Standards als einfache Zeichenfolge.</xd:return>
   </xd:doc>
   <xsl:function name="lite:modell-kennung" as="xs:string">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="
         $element/(ancestor-or-self::xoev-fachmodell/metadaten.standard/kennung, ancestor-or-self::lite-bib:xoev-bibliothek/lite-bib:metadaten.bibliothek/lite-bib:kennung)"/>
   </xsl:function>

   <xd:doc scope="component" id="lite:modell-version">
      <xd:desc>
         <xd:p>Ermittelt die Version des Standards, in dem sich der gegebene Inhalt befindet.</xd:p>
      </xd:desc>
      <xd:param name="element">Ein Bestandteil des XÖV-Fachmodells in der Form eines lite-Elements (z. B. <xd:i>nachricht</xd:i> oder <xd:i>xoev-fachmodell</xd:i>).</xd:param>
      <xd:return>Version des Standards als einfache Zeichenfolge.</xd:return>
   </xd:doc>
   <xsl:function name="lite:modell-version" as="xs:string">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="
         $element/(ancestor-or-self::xoev-fachmodell/metadaten.versionStandard/version, ancestor-or-self::lite-bib:xoev-bibliothek/lite-bib:metadaten.versionBibliothek/lite-bib:version)"/>
   </xsl:function>

   
   <xd:doc scope="component" id="lite:modell-nameKurz">
      <xd:desc>
         <xd:p>Ermittelt den nameKurz des Standards, in dem sich der gegebene Inhalt befindet.</xd:p>
      </xd:desc>
      <xd:param name="element">Ein Bestandteil des XÖV-Fachmodells in der Form eines lite-Elements (z. B. <xd:i>nachricht</xd:i> oder <xd:i>xoev-fachmodell</xd:i>).</xd:param>
      <xd:return>nameKurz des Standards als einfache Zeichenfolge.</xd:return>
   </xd:doc>
   <xsl:function name="lite:modell-nameKurz" as="xs:string">
      <xsl:param name="element" as="element()"/>
      <xsl:sequence select="
         $element/(ancestor-or-self::xoev-fachmodell/metadaten.standard/nameKurz, ancestor-or-self::lite-bib:xoev-bibliothek/lite-bib:metadaten.bibliothek/lite-bib:nameKurz)"/>
   </xsl:function>
   <xd:doc>
      <xd:desc>intern</xd:desc>
      <xd:param name="element"/>
   </xd:doc>
   <xsl:function name="lite:qualifizierter-name" as="xs:string">
      <xsl:param name="element" as="node()"/>
      <xsl:choose>
         <xsl:when test="$element/parent::xoev-fachmodell or $element/parent::lite-bib:xoev-bibliothek">
            <xsl:sequence select="concat($element/parent::*/(metadaten.standard/nameTechnisch, lite-bib:metadaten.bibliothek/lite-bib:nameTechnisch), '.', $element/@name)"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:sequence select="concat(lite:qualifizierter-name($element/parent::*), '.', $element/@name)"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:function>
   
   <xd:doc scope="component" id="lite:docbook-id">
      <xd:desc>
         <xd:p>Ermittelt eine eindeutige DocBook-ID für den gegebenen Inhalt.</xd:p>
      </xd:desc>
      <xd:param name="element">Ein Bestandteil des XÖV-Fachmodells in der Form eines lite-Elements (z. B. <xd:i>nachricht</xd:i> oder <xd:i>datentyp</xd:i>).</xd:param>
      <xd:return>XML-ID mit ausschließlich gültigen Zeichen. Bei externen Inhalten wird die ID des externen Modells zurückgeliefert, insb. für xref-Verweise.</xd:return>
   </xd:doc>
   <xsl:function name="lite:docbook-id" as="xs:string?">
      <xsl:param name="element" as="node()?"/>
      <xsl:choose>
         <xsl:when test="empty($element)">
            <xsl:sequence select="()"/>
         </xsl:when>
         <xsl:when test="$element/self::datentyp and empty($element/ancestor::xsdSchema)">
            <xsl:sequence select="concat('xs_', $element/@name)"/>
         </xsl:when>
         <xsl:when test="not(lite:modell-kennung($element) = lite:modell-kennung($xoev-modell)) or not(lite:modell-version($element) = lite:modell-version($xoev-modell))">
            <xsl:sequence select="replace(concat('externes.modell.', lite:modell-kennung($element), '_', lite:modell-version($element)), '[:\-]+', '_')"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:sequence select="replace(lite:qualifizierter-name($element), '[:\s&lt;&gt;#%?&amp;{}\-\\()]+', '_')"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:function>


   <xd:doc>
      <xd:desc>intern</xd:desc>
   </xd:doc>
   <xsl:variable name="lite:genutzte-externe-inhalte" as="document-node(element(lite:genutzte-externe-inhalte))">
      <xsl:variable name="externe-inhalte">
         <xsl:for-each select="$xoev-modell//(@typ, @referenz, @basistyp)[not(starts-with(., 'xs:'))]">
            <xsl:variable name="resolved" select="lite:resolve(., .., name() = 'referenz')"/>
            <xsl:if test="not(lite:modell-kennung($xoev-modell) = lite:modell-kennung($resolved)) or not(lite:modell-version($xoev-modell) = lite:modell-version($resolved))">
               <lite:inhalt name="{.}" modell-kennung="{lite:modell-kennung($resolved)}" modell-version="{lite:modell-version($resolved)}" namespace="{lite:namespace($resolved)}" nameKurz="{lite:modell-nameKurz($resolved)}"/>
            </xsl:if>
         </xsl:for-each>
         <xsl:for-each select="$xoev-modell//codeDatentyp">
            <xsl:variable name="prefix" select="(ancestor::*/nutztSchema[@namespace = 'http://xoev.de/schemata/code/1_0'][1]/@prefix, 'xoev-code')[1]"/>
            <xsl:variable name="resolved" select="lite:resolve(concat($prefix, ':Code'), ., false())"/>
            <lite:inhalt name="{concat($prefix,':Code')}" modell-kennung="{lite:modell-kennung($resolved)}" modell-version="{lite:modell-version($resolved)}" namespace="{lite:namespace($resolved)}" nameKurz="{lite:modell-nameKurz($resolved)}"/>
         </xsl:for-each>
      </xsl:variable>
      <xsl:document>
         <lite:genutzte-externe-inhalte>
            <xsl:for-each-group select="$externe-inhalte//lite:inhalt" group-by="concat(@name, @modell-kennung, @modell-version)">
               <xsl:sort select="@name"/>
               <xsl:sequence select="."/>
            </xsl:for-each-group>
         </lite:genutzte-externe-inhalte>
      </xsl:document>
   </xsl:variable>
   
   <xd:doc scope="component" id="lite:genutzte-externe-inhalte-metadaten">
      <xd:desc>
         <xd:p>Ermittelt die genutzten externen Inhalte eines externen Modells und macht die erforderlichen Metadaten zugreifbar.</xd:p>
      </xd:desc>
      <xd:param name="externesModell">Die Referenz auf das externe Modell gegeben mit dem Element <xd:i>externesModell</xd:i>.</xd:param>
      <xd:return>Inhalt (Element <xd:i>lite:inhalt</xd:i>) mit den Attributen <xd:i>@name</xd:i>, <xd:i>@namespace</xd:i>, <xd:i>@modell-kennung</xd:i>, <xd:i>@modell-version</xd:i> zum Zugriff auf Name und Namensraum des Inhalts sowie Kennung und Version des zugrundeliegenden Modells.</xd:return>
   </xd:doc>
   <xsl:function name="lite:genutzte-externe-inhalte-metadaten" as="element(lite:inhalt)*">
      <xsl:param name="externesModell" as="element(externesModell)"/>
      <xsl:sequence select="$lite:genutzte-externe-inhalte//lite:inhalt[@modell-kennung = $externesModell/@kennung and @modell-version = $externesModell/@version]"/>
   </xsl:function>
   
   <xd:doc scope="component" id="lite:nachrichtennummer">
      <xd:desc>
         <xd:p>Ermittelt die Nummer einer Nachricht, wenn diese vorliegt.</xd:p>
         <xd:p>Häufige Nutzung in der Form "<xd:i>lite:nachrichtennummer(.)</xd:i>" um für die gerade behandelte Nachricht die Nummer zu erhalten.</xd:p>
      </xd:desc>
      <xd:param name="nachricht">Ein Bestandteil des XÖV-Fachmodells in der Form eines lite-Elements <xd:i>nachricht</xd:i>.</xd:param>
      <xd:return>Nummer der Nachricht als einfache Zeichenfolge.</xd:return>
   </xd:doc>
   <xsl:function name="lite:nachrichtennummer" as="xs:string?">
      <xsl:param name="nachricht" as="element()"/>
      <xsl:variable name="nummer" select="tokenize($nachricht/@name, '\.')[last()]"/>
      <xsl:if test="matches($nummer, '^\d*$')">
         <xsl:sequence select="$nummer"/>
      </xsl:if>
   </xsl:function>
   
   <!-- Rechtsgrundlage -->
   <xd:doc scope="component" id="lite:rechtsgrundlage-liste">
      <xd:desc>
         <xd:p>Erstellt eine Liste aus den Elementen Rechtsgrundlage einer Nachricht.</xd:p>
         <xd:p>Der Liste ist eine Überschrift "Rechtsgrundlagen" vorangestellt.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:function name="lite:rechtsgrundlage-liste" as="element(db:para)?">
      <xsl:param name="rg-elemente" as="element(rechtsgrundlage)*"></xsl:param>
      <xsl:if test="$rg-elemente">
         <para>
            <emphasis role="bold">Rechtsgrundlagen:</emphasis>
            <itemizedlist>
               <xsl:for-each select="$rg-elemente">
                  <listitem role="rechtsgrundlage">
                     <para><xsl:value-of select="."/></para>
                  </listitem>
               </xsl:for-each>
            </itemizedlist>
         </para>
      </xsl:if>
   </xsl:function> 

   <!-- "Beschreibung" einer Nachricht, Pfad: nachricht/beschreibung -->
   <xd:doc scope="component" id="lite:nachricht-beschreibung">
      <xd:desc>Kopiert Inhalte von Element beschreibung.</xd:desc>
   </xd:doc>
   <xsl:function name="lite:nachricht-beschreibung" as="element()*">
      <xsl:param name="beschreibung" as="element(beschreibung)"/>
      <xsl:copy-of select="$beschreibung/*" copy-namespaces="no"/>
   </xsl:function>


	<xd:doc scope="component">
		<xd:desc>
			<xd:p>Ermittelt, ob ein W3C Simple Type vorliegt.</xd:p>
			<xd:p>Beispielhafte Nutzung: <xd:i>lite:reference-is-w3c-simpletype('xs:integer')</xd:i> liefert "true", während <xd:i>lite:reference-is-w3c-simpletype('din91379:datatypeC')</xd:i> "false" liefert</xd:p>
		</xd:desc>
		<xd:param name="qualified-name">Der qualifizierte Name (z. B. "xdomea:KontaktType", "din91379:datatypeC" oder "xs:boolean") des zu prüfenden Typs.</xd:param>
		<xd:return>Liefert "true", falls es sich beim übergebenen Typ um einen W3C Simple Type handelt.</xd:return>
	</xd:doc>
	<xsl:function name="lite:reference-is-w3c-simpletype" as="xs:boolean">
		<xsl:param name="qualified-name" as="xs:string?"/>
		<xsl:choose>
			<xsl:when test="starts-with($qualified-name, 'xs:')">
				<xsl:value-of select="true()"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="false()"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:function>
	
	<xd:doc scope="component">
		<xd:desc>
			<xd:p>Stellt anhand seines qualifizierten Namens fest, ob das übergebene Element aus einem externen Modell stammt.</xd:p>
			<xd:p>Beispielhafte Nutzung: Im Kontext des Fachmodells XMeld (Präfix "<xd:i>xmeld</xd:i>") liefert <xd:i>lite:reference-is-from-external-model('din91379:datatypeC')</xd:i> "true" während <xd:i>lite:reference-is-from-external-model('xmeld:type.AnschriftMelderecht')</xd:i> "false" liefert.</xd:p>
		</xd:desc>
	   <xd:param name="element">Zu prüfendes Element</xd:param>
		<xd:return>Liefert "true", falls der übergebene Typ aus einem externen Modell stammt.</xd:return>
	</xd:doc>
   <xsl:function name="lite:reference-is-from-external-model" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:choose>
         <xsl:when test="not(lite:modell-kennung($xoev-modell) = lite:modell-kennung($element)) or not(lite:modell-version($xoev-modell) = lite:modell-version($element))">
            <xsl:value-of select="true()"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:value-of select="false()"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:function>
	
   <xd:doc scope="component">
      <xd:desc>
         <xd:p>Entfernt das Präfix bei internen Namen.</xd:p>
      </xd:desc>
      <xd:param name="qualified-name">Der qualifizierte Name (z. B. "xdomea:KontaktType", "din91379:datatypeC" oder "xs:boolean") des Typs.</xd:param>
      <xd:param name="element">Das Element des Typs bzw. der Referenz.</xd:param>
      <xd:return>Liefert den Namen ohne Namensraumpräfix, falls der Typ nicht aus einem externen Modell stammt oder ein W3C-Datentyp ist.</xd:return>
   </xd:doc>
   <xsl:function name="lite:kuerze-internen-typnamen" as="xs:string">
      <xsl:param name="qualified-name" as="xs:string?"/>
      <xsl:param name="element" as="element()"/>
      <xsl:choose>
         <xsl:when test="starts-with($qualified-name, 'xs:')">
            <!-- W3C-Datentyp behält das Präfix -->
            <!-- ggf. Test ergänzen/ersetzen mit: empty($element) or (normalize-space($element) = '')  -->
            <xsl:value-of select="$qualified-name"/>
         </xsl:when>
         <xsl:when test="not(lite:modell-kennung($xoev-modell) = lite:modell-kennung($element)) or not(lite:modell-version($xoev-modell) = lite:modell-version($element))">
            <!-- Datentyp aus externem Modell behält das Präfix -->
            <xsl:value-of select="$qualified-name"/>
         </xsl:when>
         <xsl:otherwise>
            <!-- Datentyp aus eigenem Modell wird ohne Präfix dargestellt -->
            <xsl:value-of select="substring-after($qualified-name, ':')"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:function>
   
      
   <xd:doc scope="component">
      <xd:desc>
         <xd:p>Entfernt das Präfix bei internen Namen.</xd:p>
      </xd:desc>
      <xd:param name="qualified-name">Der qualifizierte Name (z. B. "xdomea:KontaktType", "din91379:datatypeC" oder "xs:boolean") des Typs.</xd:param>
      <xd:param name="from">Kontext des angegebenen Typs bzw. der Referenz.</xd:param>
      <xd:param name="is-ref">"true", wenn es sich um ein referenziertes Element handelt.</xd:param>
      <xd:return>Liefert den Namen ohne Namensraumpräfix, falls der Typ nicht aus einem externen Modell stammt oder ein W3C-Datentyp ist.</xd:return>
   </xd:doc>
   <xsl:function name="lite:kuerze-internen-typnamen" as="xs:string">
      <xsl:param name="qualified-name" as="xs:string?"/>
      <!-- von wo schaue ich: -->
      <xsl:param name="from" as="element()"/>
      <!-- handelt es sich um eine Referenz (= true) oder einen Typ (= false): -->
      <xsl:param name="is-ref" as="xs:boolean"/>
      <xsl:variable name="element" select="lite:resolve($qualified-name,$from, $is-ref)"/>
      <xsl:choose>
         <xsl:when test="starts-with($qualified-name, 'xs:')">
            <!-- W3C-Datentyp behält das Präfix -->
            <xsl:value-of select="$qualified-name"/>
         </xsl:when>
         <xsl:when test="not(lite:modell-kennung($xoev-modell) = lite:modell-kennung($element)) or not(lite:modell-version($xoev-modell) = lite:modell-version($element))">
            <!-- Datentyp aus externem Modell behält das Präfix -->
            <xsl:value-of select="$qualified-name"/>
         </xsl:when>
         <xsl:otherwise>
            <!-- Datentyp aus eigenem Modell wird ohne Präfix dargestellt -->
            <xsl:value-of select="substring-after($qualified-name, ':')"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:function>
	
	<xd:doc scope="component">
		<xd:desc>
			<xd:p>Ermittelt, ob der übergebene Baustein Content besitzt, der in einer SVG-Grafik gezeigt werden muss.</xd:p>
			<xd:p>Beispielhafte Nutzung im XMeld-Kontext: <xd:i>lite:baustein-has-svg-content(type.AnschriftfeldNachDIN.ZusatzUndVermerkzone.Zeile.Position)</xd:i> liefert "false", während <xd:i>lite:baustein-has-svg-content(type.AnschriftMelderechtOhneAusland)</xd:i> "true" liefert.</xd:p>
		</xd:desc>
		<xd:param name="baustein">Ein Baustein des XÖV-Fachmodells in der Form eines lite-Elements, z. B. ein <xd:i>datentyp</xd:i>.</xd:param>
		<xd:return>Liefert "true", falls es der übergebene Baustein SVG-relevanten Content besitzt.</xd:return>
	</xd:doc>
	<xsl:function name="lite:baustein-has-svg-content" as="xs:boolean">
		<xsl:param name="baustein" as="element()"/>
		<xsl:choose>
			<xsl:when test="$baustein/eigenschaft">
				<xsl:value-of select="true()"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="false()"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:function>
   
   <!--Ab hier beginnt Integration der Funktionen die früher in der Datei helpers.stage.lite-dokumentation.xsl waren -->
	
   <xd:doc scope="component" id="lite:set-path-or-filename">
      <xd:desc>
         <xd:p>Esetzt in einem String die für Dateinamen und Pfade ungeeigneten Zeichen</xd:p>
      </xd:desc>
      <xd:param name="String">Enthält den zu bearbeitenden String</xd:param>
      <xd:return>Der im Parameter übergebene string wird mit ausgetauschten Zeichen zurückgegeben.</xd:return>
      
   </xd:doc>
   <xsl:function name="lite:set-path-or-filename" as="xs:string">
      <xsl:param name="String" as="xs:string"/>
      
      <xsl:value-of select="replace(replace(replace(replace(replace(replace(
         translate($String,' :*?&quot;&lt;&gt;','_------')
         ,'ä','ae')
         ,'ö','oe')
         ,'ü','ue')
         ,'Ä','Ae')
         ,'Ö','Oe')
         ,'Ü','Ue')
         "/>
   </xsl:function>
   
   <!-- Todo: Die drei Parameter der Funktion müssen noch kommentiert werden, 
        siehe auch https://projekte.kosit.org/xoev/lite-projekte/lite-dokumentation/-/issues/83 -->
   
   <xd:doc scope="component" id="lite:code-typ">
      <xd:desc>
         <xd:p>Aus den Attributen @kennung, @version und @codesSchemavalidiert
            wird der code-typ bestimmt:</xd:p>
         <xd:p>Wenn @kennung und @version existieren und @codesSchemavalidiert = true dann ist der code-typ 1</xd:p>
         <xd:p>Wenn @kennung und @version existieren und @codesSchemavalidiert = false dann ist der code-typ 2</xd:p>
         <xd:p>Wenn @kennung existiert @version aber nicht dann ist der code-typ 3</xd:p>
         <xd:p>Wenn weder @kennung noch @version existieren dann ist der code-typ 4</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:function name="lite:code-typ">
      <xsl:param name="codedatentyp" as="element(codeDatentyp)"></xsl:param>
      <xsl:param name="codeliste"/>
      <xsl:param name="fachmodellSchemavalidiert"/>
      
      <xsl:variable name="kennung" select="$codedatentyp/@kennung"/>
      <xsl:variable name="version" select="$codedatentyp/@version"/>
      <xsl:variable name="schemavalidiert" select="$codeliste/codesSchemavalidiert = 'true' or $fachmodellSchemavalidiert = 'true'" as="xs:boolean"/>
      <xsl:choose>
         <xsl:when test="empty($kennung) and empty($version)">
            <xsl:value-of select="'4'"/>
         </xsl:when>
         <xsl:when test="not(empty($kennung)) and empty($version)">
            <xsl:value-of select="'3'"/>
         </xsl:when>
         <xsl:when test="not(empty($kennung)) and not(empty($version))">
            
            <xsl:choose>
               <xsl:when test="$schemavalidiert">
                  <xsl:value-of select="'1'"/>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:value-of select="'2'"/>
               </xsl:otherwise>
            </xsl:choose>
            
         </xsl:when>
      </xsl:choose>
   </xsl:function>
   
   <xd:doc scope="component" id="lite:validateContent">
      <xd:desc>
         <xd:p>Diese Funktion prüft ein übergebenes Element (im Parameter content) auf korrekten Aufbau.</xd:p>
         <xd:p>Trifft dies zu wird der content zurückgegeben. Anderenfalls wird
            noContent zurückgegeben.</xd:p>
         <xd:p>Derzeit können folgende Elemente geprüft werden:</xd:p>
         <xd:ul>
            <xd:li>informaltable</xd:li>
            <xd:li>itemizedlist</xd:li>
            <xd:li>orderedlist</xd:li>
            <xd:li>variablelist</xd:li>
            <xd:li>glosslist</xd:li>
         </xd:ul>
         <xd:p>Diese Funktion kann bei bedarf für andere zu prüfende Elemente erweitert werden.</xd:p>
      </xd:desc>
      <xd:param name="content">Enthält ein Element dessen korrekter Aufbau geprüft werden soll.</xd:param>
      <xd:param name="noContent">Enthält ein Element das Alternativ zu content zurückgegeben werden kann.</xd:param>
   </xd:doc>
   <!--<xsl:function name="lite:validateContent">
      <xsl:param name="content" as="document-node()"/>
      <xsl:param name="noContent" as="document-node()"/>
      
      <xsl:choose>
         <xsl:when test="$content/db:appendix">
            <xsl:choose>
               <xsl:when test="$content/db:appendix[db:title/text()=('Eingebundene externe Modelle','Übersicht Code-Datentypen','Codelisten')]">
                  <xsl:sequence select="if ($content/db:appendix/db:section) then $content else $noContent"></xsl:sequence>
               </xsl:when>
               <xsl:when test="$content/db:appendix[db:title/text()='Nachrichtengesamtübersicht']">
                  <xsl:sequence select="if ($content/db:appendix/db:informaltable) then $content else $noContent"></xsl:sequence>
               </xsl:when>
               <xsl:when test="$content/db:appendix[db:title/text()=('Übersicht über die Code-Datentypen')]">
                  <xsl:sequence select="if ($content/db:appendix/*:include) then $content else $noContent"></xsl:sequence>
               </xsl:when>
               <xsl:otherwise>
                  <section version="5">
                     <title>Test fehlgeschlagen</title>
                     <xsl:call-template name="annotation.todo.xoevlite.developer">
                        <xsl:with-param name="titel">Prüfung lite:validateContent fehlgeschlagen.</xsl:with-param>
                        <xsl:with-param name="beschreibung">Das zu prüfende Element <xsl:value-of select="$content/*/name()"/> wird nicht unterstützt.</xsl:with-param>
                        
                     </xsl:call-template>
                  </section>
               </xsl:otherwise>
            </xsl:choose>
            
         </xsl:when>
         <xsl:when test="$content/db:informaltable">
            <xsl:sequence select="if ($content//db:tbody/db:row) then $content else $noContent"/>
         </xsl:when>
         <xsl:when test="$content/db:itemizedlist or $content/db:orderedlist or $content/db:variablelist">
            <xsl:sequence select="if ($content//db:listitem) then $content else $noContent"/>
         </xsl:when>
         <xsl:when test="$content/db:glosslist">
            <xsl:sequence select="if ($content//db:glossentry) then $content else $noContent"/>
         </xsl:when>
         <xsl:when test="$content/db:appendix[db:title/text()='Eingebundene externe Modelle']">
            <xsl:sequence select="if ($content/db:section) then $content else $noContent"></xsl:sequence>
         </xsl:when>
         
         <xsl:otherwise>
            <section version="5">
               <title>Prüfung fehlgeschlagen</title>
               <xsl:call-template name="annotation.todo.xoevlite.developer">
                  <xsl:with-param name="titel">Prüfung lite:validateContent fehlgeschlagen.</xsl:with-param>
                  <xsl:with-param name="beschreibung">Das zu prüfende Element <xsl:value-of select="$content/*/name()"/> wird nicht unterstützt.</xsl:with-param>
                  
               </xsl:call-template>
            </section>
         </xsl:otherwise>
      </xsl:choose>
      
   </xsl:function>-->
   
   <!-- Die nachfolgende Funktion ist noch nicht fertig. Sie dient (zukünftig) der Umsetzung von 
   https://projekte.kosit.org/xoev/lite-projekte/lite-dokumentation/-/issues/46 -->
   
   <xd:doc scope="component" id="lite:get-datatypes">
      <xd:desc>
         
      </xd:desc>
      <xd:param name="message">Übergeben wird ein Element Nachricht.</xd:param>
      <xd:return>Es werden typelemente zurückgegeben für jeden von der Nachricht genutzten Datentyp.</xd:return>
   </xd:doc>
   
   <xsl:function name="lite:get-datatypes">
      <xsl:param name="message" as="element()"/>
      <xsl:variable name="types" select="$message//*/@typ"/>
      <xsl:variable name="root" select="$message/ancestor::xoev-fachmodell"/>
      <xsl:for-each select="$root//datentyp[@name = $types or @basistyp = $types]">
         <type name="{@name}" id="{generate-id()}" typ="{name()}"/>
         <xsl:sequence select="lite:get-datatypes(.)"></xsl:sequence>
      </xsl:for-each>
   </xsl:function>
   
   <!-- Todo: Das nachfolgende Template soll in Zukunft integriert werden in die Datei uebersetzungsanweisungen.common-templates.xsl -->
   
   <xd:doc scope="component" id="lite:write-file-return-log">
      <xd:desc>
         <xd:p>Schreibt den Content in eine Datei.</xd:p>
         <xd:p>Die an der mit 'local-path' bestimmten Position erstellt wird.</xd:p>
         <xd:p>Es werden die in content-with-log enthaltenen liginformationen zurückgegeben.</xd:p>
         
      </xd:desc>
      <xd:param name="content">Inhalt der zu schreibenden Datei.</xd:param>
      <xd:param name="local-path">Der relative Pfad ausgehend vom in 'xgen:result-document'
         verwendeten Wurzelpfads.</xd:param>
      <xd:return>Enthaltene Loginformationen werden zurückgegeben.</xd:return>
   </xd:doc>
   <xsl:template name="lite:write-file-return-log">
      <xsl:param name="content" as="node()"/>
      <xsl:param name="local-path"/>
      
      <xsl:variable name="content" as="document-node()">
         <xsl:choose>
            <xsl:when test="$content/self::document-node()">
               <xsl:sequence select="$content"/>
            </xsl:when>
            <xsl:otherwise>
               <xsl:document>
                  <xsl:sequence select="$content"/>
               </xsl:document>
            </xsl:otherwise>
         </xsl:choose>
      </xsl:variable>
      
      <xsl:call-template name="xgen:result-document">
         <xsl:with-param name="content" select="$content"/>
         <xsl:with-param name="local-path" select="$local-path"/>
      </xsl:call-template>
      
   </xsl:template>
	
</xsl:stylesheet>
