@ECHO OFF
ECHO Validiere Spezifikation
java -Dorg.apache.xerces.xni.parser.XMLParserConfiguration=org.apache.xerces.parsers.XIncludeParserConfiguration -jar ./docbookzubehoer/jing-20091111/bin/jing.jar ./docbookzubehoer/docbook-5.0/rng/docbookxi.rng ./src/spezifikation.xml
IF ERRORLEVEL 1 GOTO validierungFehlgeschlagen

ECHO Vorbearbeitung der Spezifikation
java  -cp ./docbookzubehoer/saxon/saxon.jar;./docbookzubehoer/xerces/xercesImpl.jar ^
    -Djavax.xml.parsers.DocumentBuilderFactory=org.apache.xerces.jaxp.DocumentBuilderFactoryImpl ^
    -Djavax.xml.parsers.SAXParserFactory=org.apache.xerces.jaxp.SAXParserFactoryImpl ^
    -Dorg.apache.xerces.xni.parser.XMLParserConfiguration=org.apache.xerces.parsers.XIncludeParserConfiguration ^
     com.icl.saxon.StyleSheet ^
     -o ./src/spezifikation_pre.xml ^
		./src/spezifikation.xml ^
		./docbookzubehoer/docbook-xsl-ns/fo/kosit/kosit_preprocessor.xsl
	  
IF ERRORLEVEL 1 GOTO preprozessorFehlgeschlagen

ECHO Uebersetzte nach FO (DocBook-XSL)
java  -cp ./docbookzubehoer/saxon/saxon.jar;./docbookzubehoer/xerces/xercesImpl.jar ^
    -Djavax.xml.parsers.DocumentBuilderFactory=org.apache.xerces.jaxp.DocumentBuilderFactoryImpl ^
    -Djavax.xml.parsers.SAXParserFactory=org.apache.xerces.jaxp.SAXParserFactoryImpl ^
    -Dorg.apache.xerces.xni.parser.XMLParserConfiguration=org.apache.xerces.parsers.XIncludeParserConfiguration ^
     com.icl.saxon.StyleSheet ^
	 -o ./src/spezifikation.fo ^
	 ./src/spezifikation_pre.xml ^
	 ./docbookzubehoer/docbook-xsl-ns/fo/kosit/kosit_docbook.xsl
IF ERRORLEVEL 1 GOTO foerzeugungFehlgeschlagen

ECHO Erzeuge PDF (FOP)
call ./docbookzubehoer/fop-1.1/fop.bat -c "./docbookzubehoer/fop-1.1/conf/fop-config.xml" -fo ./src/spezifikation.fo -pdf ./pdf/spezifikation.pdf
del  .\src\spezifikation_pre.xml
del  .\src\spezifikation.fo
IF ERRORLEVEL 1 GOTO erzeugungFehlgeschlagen

ECHO Fertig!
goto exit

:validierungFehlgeschlagen
ECHO Validierung fehlgeschlagen!
goto exit

:preprozessorFehlgeschlagen
ECHO Vorbearbeitung fehlgeschlagen!
goto exit

:foerzeugungFehlgeschlagen
ECHO FO konnte nicht erzeugt werden!
goto exit

:erzeugungFehlgeschlagen
ECHO Fehler bei der PDF Generierung!
goto exit

:exit