<?xml version='1.0'?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:d="http://docbook.org/ns/docbook" xmlns:fo="http://www.w3.org/1999/XSL/Format" version="1.0" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:kosit="http://www.xoev.de/de/kosit-zubehoer/3_2_0" xmlns:ent="http://www.xoev.de/de/kosit-zubehoer/entity">

    <xsl:key name="id" match="*" use="@id | @xml:id"/>

    <!--<xsl:variable name="types" select="document('../../../build/docbook/dokumente/anhang/structures/types.xml')"/>
    <xsl:variable name="messages" select="document('../../../build/docbook/dokumente/anhang/structures/messages.xml')"/>
    <xsl:variable name="codes" select="document('../../../build/docbook/dokumente/anhang/structures/codes.xml')"/>-->
    <xsl:variable name="entities" select="document('../../../ent/entities.xml')"/>

    <xsl:template match="node() | @*">
        <xsl:copy>
            <xsl:apply-templates select="@* | node()"/>
        </xsl:copy>
    </xsl:template>

    <xsl:template match="ent:value">
        <xsl:apply-templates/>
    </xsl:template>

    <xsl:template match="d:entity">
        <xsl:variable name="entity" select="."/>
        <xsl:variable name="entity-source" select="$entities//ent:entity[ent:id = $entity]"/>
       <xsl:choose>
          <xsl:when test="$entity-source/ent:value/child::text()[normalize-space(.) != '']">
             <xsl:apply-templates select="$entity-source/ent:value"/>
          </xsl:when>
          <xsl:otherwise>
             <xsl:apply-templates select="$entity-source/ent:value/child::*"/>
          </xsl:otherwise>
       </xsl:choose>
    </xsl:template>

    <!--<xsl:template match="d:type-ref">
        <xsl:variable name="type" select="."/>
        <xsl:variable name="type-in-types" select="$types//kosit:type[@name = $type]"/>
        <d:emphasis role="codebf">
            <xsl:choose>
                <xsl:when test="$type-in-types[@id]">
                    <d:link role="schwarz" linkend="{$type-in-types/@id}">
                        <xsl:value-of select="$type"/>
                    </d:link>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="$type"/>
                </xsl:otherwise>
            </xsl:choose>
        </d:emphasis>
    </xsl:template>-->

    <!--<xsl:template match="d:type-ref-with-prefix">
        <xsl:variable name="type" select="substring-after(., ':')"/>
        <xsl:variable name="type-in-types" select="$types//kosit:type[@name = $type]"/>
        <d:emphasis role="codebf">
            <xsl:choose>
                <xsl:when test="$type-in-types[@id]">
                    <d:link role="schwarz" linkend="{$type-in-types/@id}">
                        <xsl:value-of select="."/>
                    </d:link>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="."/>
                </xsl:otherwise>
            </xsl:choose>
        </d:emphasis>
    </xsl:template>-->

    <!--<xsl:template match="d:message-ref">
        <xsl:variable name="message" select="."/>
        <xsl:variable name="message-in-types" select="$messages//kosit:message[@name = $message]"/>
        <d:emphasis role="codebf">
            <xsl:choose>
                <xsl:when test="$message-in-types[@id]">
                    <d:link role="schwarz" linkend="{$message-in-types/@id}">
                        <xsl:value-of select="$message"/>
                    </d:link>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="$message"/>
                </xsl:otherwise>
            </xsl:choose>
        </d:emphasis>
    </xsl:template>-->

    <!--<xsl:template match="d:message-ref-with-prefix">
        <xsl:variable name="message" select="substring-after(., ':')"/>
        <xsl:variable name="message-in-types" select="$messages//kosit:message[@name = $message]"/>
        <d:emphasis role="codebf">
            <xsl:choose>
                <xsl:when test="$message-in-types[@id]">
                    <d:link role="schwarz" linkend="{$message-in-types/@id}">
                        <xsl:value-of select="."/>
                    </d:link>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="."/>
                </xsl:otherwise>
            </xsl:choose>
        </d:emphasis>
    </xsl:template>-->

    <!--<xsl:template match="d:message-number">
        <xsl:variable name="number" select="substring-after(normalize-space(.), 'Nachricht ')"/>
        <xsl:variable name="message-in-types" select="$messages//kosit:message[@number = $number]"/>
        <xsl:choose>
            <xsl:when test="$message-in-types[@id]">
                <d:link linkend="{$message-in-types/@id}">
                    <xsl:value-of select="."/>
                </d:link>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="."/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>-->

    <!--<xsl:template match="d:message-title">
        <xsl:variable name="number" select="substring-after(normalize-space(.), 'Nachricht ')"/>
        <xsl:variable name="message-in-types" select="$messages//kosit:message[@number = $number]"/>
        <xsl:choose>
            <xsl:when test="$message-in-types[@id]">
                <d:link role="schwarz" linkend="{$message-in-types/@id}">
                    <xsl:apply-templates select="$message-in-types/kosit:title"/>
                </d:link>
            </xsl:when>
            <xsl:otherwise>
                <xsl:apply-templates select="$message-in-types/kosit:title"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>-->
    
    <xsl:template match="kosit:title">
        <xsl:apply-templates/>
    </xsl:template>

    <!--<xsl:template match="d:property-ref">
        <xsl:variable name="start" select="@start"/>
        <xsl:variable name="path" select="."/>
        <xsl:variable name="start-in-types" select="($types//kosit:type)[@name = $start]"/>
        <xsl:variable name="start-in-messages" select="($messages//kosit:message)[@name = $start]"/>
        <d:emphasis role="codebf">
            <xsl:choose>
                <xsl:when test="$start-in-types[@id]">
                    <d:link role="schwarz" linkend="{$start-in-types/@id}">
                        <xsl:value-of select="."/>
                    </d:link>
                </xsl:when>
                <xsl:when test="$start-in-messages[@id]">
                    <d:link role="schwarz" linkend="{$start-in-messages/@id}">
                        <xsl:value-of select="."/>
                    </d:link>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="."/>
                </xsl:otherwise>
            </xsl:choose>
        </d:emphasis>
    </xsl:template>-->
    
    <!--<xsl:template match="d:code-ref">
        <xsl:variable name="cl" select="@cl"/>
        <xsl:variable name="code" select="."/>
        <xsl:variable name="cl-in-codes" select="($codes//kosit:codelist)[@urn = $cl]"/>
        <d:emphasis role="codebf">
            <d:link role="schwarz" linkend="{$cl-in-codes/@id}">
                <xsl:value-of select="."/>
            </d:link>
        </d:emphasis>
    </xsl:template>-->

    <!-- Benanntes Template für den standard Hinweistext bei Deprecated-->
    <xsl:template name="deprecatedHinweis">
        <xsl:param name="aid"/>
        <xsl:element name="d:important">
            <d:para>
                <d:emphasis role="rot">Dieser Abschnitt entfällt!</d:emphasis>
            </d:para>
            <xsl:apply-templates select="key('id', $aid)/d:info/d:abstract/*"/>
            <d:para>Weitere Informationen finden sie in <d:xref linkend="{$aid}" role="AS"/>.</d:para>
        </xsl:element>
    </xsl:template>

    <!-- section Element mit Attribut deprecatedContext bekommt para nach dem Titel -->
    <xsl:template match="
            d:section[key('id', @annotations)[@role = 'deprecated']] |
            d:formalpara[key('id', @annotations)[@role = 'deprecated']]">
        <xsl:copy>
            <xsl:apply-templates select="@*"/>
            <xsl:apply-templates select="d:info"/>
            <xsl:apply-templates select="d:title"/>
            <xsl:apply-templates select="d:subtitle"/>

            <xsl:call-template name="deprecatedHinweis">
                <xsl:with-param name="aid" select="@annotations"/>
            </xsl:call-template>

            <xsl:apply-templates select="*[not(self::d:info or self::d:title or self::d:subtitle)]"/>
        </xsl:copy>
    </xsl:template>

    <!-- para -->
    <xsl:template match="d:para[key('id', @annotations)[@role = 'deprecated']]">
        <xsl:call-template name="deprecatedHinweis">
            <xsl:with-param name="aid" select="@annotations"/>
        </xsl:call-template>

        <xsl:copy>
            <!-- Den Rest kopieren -->
            <xsl:apply-templates select="@* | node()"/>
        </xsl:copy>
    </xsl:template>

    <!-- Tabellenzeile mit Attribut deprecatedContext bekommt eine Markierung -->
    <xsl:template match="d:row[key('id', @annotations)[@role = 'deprecated']]/d:entry[last()]">
        <d:entry>
            <xsl:apply-templates select="*"/>
            <d:emphasis role="rot">
                <d:footnote>
                    <d:para>
                        <d:emphasis role="rot">Diese Zeile entfällt! (Weitere Informationen finden sie in <xsl:element name="d:xref">
                                <xsl:attribute name="linkend">
                                    <xsl:value-of select="../@annotations"/>
                                </xsl:attribute>
                                <xsl:attribute name="role">AS</xsl:attribute>
                            </xsl:element>).</d:emphasis>
                    </d:para>
                </d:footnote>
            </d:emphasis>
        </d:entry>
    </xsl:template>

    <!-- Umschreiben der deprecatedContext Elemente zu DocBook -->
    <xsl:template match="d:annotation[@role = 'deprecated']">
        <xsl:variable name="dId" select="@xml:id"/>
        <d:section>
            <xsl:attribute name="xml:id">
                <xsl:value-of select="$dId"/>
            </xsl:attribute>
            <xsl:attribute name="annotations">deprecated</xsl:attribute>
            <d:info>
                <d:title>
                    <xsl:value-of select="d:info/d:title"/>
                </d:title>
            </d:info>
            <xsl:apply-templates select="*[not(self::d:info)]"/>
            <xsl:element name="d:section">
                <xsl:element name="d:title">Betroffene Elemente</xsl:element>
                <d:para>
                    <d:informaltable>
                        <d:tgroup cols="3">
                            <d:colspec colname="name" colnum="1" colwidth="90mm"/>
                            <d:colspec colname="typ" colnum="2" colwidth="40mm"/>
                            <d:colspec colname="seite" colnum="3" colwidth="20mm"/>
                            <d:spanspec spanname="all" namest="name" nameend="seite"/>
                            <d:thead>
                                <d:row>
                                    <d:entry>Titel</d:entry>
                                    <d:entry>Typ</d:entry>
                                    <d:entry>Seite</d:entry>
                                </d:row>
                            </d:thead>
                            <d:tbody>
                                <xsl:variable name="usages" select="//*[@annotations = $dId]"/>
                                <xsl:choose>
                                    <xsl:when test="count($usages) &gt; 0">
                                        <xsl:apply-templates select="$usages" mode="deprecatedReference"/>
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <d:row>
                                            <d:entry spanname="all" align="center">Es sind noch keine betroffenen Elemente markiert.</d:entry>
                                        </d:row>
                                    </xsl:otherwise>
                                </xsl:choose>
                            </d:tbody>
                        </d:tgroup>
                    </d:informaltable>
                </d:para>
            </xsl:element>
        </d:section>
    </xsl:template>

    <!-- Templates für die einzelnen Verweise auf deprecated Elemente -->
    <xsl:template name="title">
        <xsl:param name="node"/>
        <xsl:choose>
            <xsl:when test="d:info/d:title">
                <xsl:value-of select="d:info/d:title"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="d:title"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template match="d:section" mode="deprecatedReference">
        <d:row>
            <d:entry>
                <xsl:call-template name="title">
                    <xsl:with-param name="node" select="."/>
                </xsl:call-template>
            </d:entry>
            <d:entry>Abschnitt</d:entry>
            <d:entry>
                <xsl:element name="d:xref">
                    <xsl:attribute name="linkend">
                        <xsl:value-of select="@xml:id"/>
                    </xsl:attribute>
                    <xsl:attribute name="role">Seite</xsl:attribute>
                </xsl:element>
            </d:entry>
        </d:row>
    </xsl:template>

    <xsl:template match="d:para" mode="deprecatedReference">
        <d:row>
            <d:entry>n/a</d:entry>
            <d:entry>Absatz</d:entry>
            <d:entry>
                <xsl:element name="d:xref">
                    <xsl:attribute name="linkend">
                        <xsl:value-of select="@xml:id"/>
                    </xsl:attribute>
                    <xsl:attribute name="role">Seite</xsl:attribute>
                </xsl:element>
            </d:entry>
        </d:row>
    </xsl:template>

    <xsl:template match="d:formalpara" mode="deprecatedReference">
        <d:row>
            <d:entry>
                <xsl:call-template name="title">
                    <xsl:with-param name="node" select="."/>
                </xsl:call-template>
            </d:entry>
            <d:entry>Absatz</d:entry>
            <d:entry>
                <xsl:element name="d:xref">
                    <xsl:attribute name="linkend">
                        <xsl:value-of select="@xml:id"/>
                    </xsl:attribute>
                    <xsl:attribute name="role">Seite</xsl:attribute>
                </xsl:element>
            </d:entry>
        </d:row>
    </xsl:template>

    <xsl:template match="d:row" mode="deprecatedReference">
        <d:row>
            <d:entry>
                <xsl:value-of select="./d:entry[1]"/>
            </d:entry>
            <d:entry>Tabellenzeile</d:entry>
            <d:entry>
                <xsl:element name="d:xref">
                    <xsl:attribute name="linkend">
                        <xsl:value-of select="ancestor::*[@xml:id][1]/@xml:id"/>
                    </xsl:attribute>
                    <xsl:attribute name="role">Seite</xsl:attribute>
                </xsl:element>
            </d:entry>
        </d:row>
    </xsl:template>

    <!-- Umschreiben der todo-Elemente zu DocBook -->
    <xsl:template match="d:annotation[@role = 'todo']">
        <xsl:element name="d:important">
            <xsl:attribute name="xml:id">todo.<xsl:value-of select="generate-id()"/></xsl:attribute>
            <d:para>
                <d:emphasis role="rot">TODO<xsl:if test="d:info/d:title">: <xsl:value-of select="d:info/d:title"/></xsl:if></d:emphasis>
            </d:para>
            <xsl:apply-templates select="./*[not(d:info)]"/>
            <xsl:if test="d:info/d:author">
                <d:para>Verantwortlich: <xsl:value-of select="d:info/d:author"/></d:para>
            </xsl:if>
            <xsl:if test="d:info/d:date">
                <d:para>Fällig: <xsl:value-of select="d:info/d:date"/></d:para>
            </xsl:if>
        </xsl:element>
    </xsl:template>

    <xsl:template match="processing-instruction('KoSIT-FO')[normalize-space(.) = 'appendix_todo']">
        <xsl:if test="count(//d:annotation[@role = 'todo']) > 0">
            <xsl:element name="d:appendix">
                <xsl:element name="d:title">Übersicht über die ToDos</xsl:element>
                <d:para>
                    <d:informaltable>
                        <d:tgroup cols="6">
                            <d:colspec colname="nr" colnum="1" colwidth="10mm"/>
                            <d:colspec colname="seite" colnum="2" colwidth="12mm"/>
                            <d:colspec colname="titel" colnum="3" colwidth="35mm"/>
                            <d:colspec colname="beschreibung" colnum="4" colwidth="53mm"/>
                            <d:colspec colname="faellig" colnum="5" colwidth="25mm"/>
                            <d:colspec colname="verantwortlich" colnum="6" colwidth="25mm"/>
                            <d:thead>
                                <d:row>
                                    <d:entry>Nr</d:entry>
                                    <d:entry>Seite</d:entry>
                                    <d:entry>Todo-Titel</d:entry>
                                    <d:entry>Beschreibung</d:entry>
                                    <d:entry>Fällig</d:entry>
                                    <d:entry>Verantwortlich</d:entry>
                                </d:row>
                            </d:thead>
                            <d:tbody>
                                <xsl:for-each select="//d:annotation[@role = 'todo']">
                                    <d:row>
                                        <d:entry>
                                            <xsl:value-of select="position()"/>
                                        </d:entry>
                                        <d:entry>
                                            <xsl:element name="d:xref">
                                                <xsl:attribute name="linkend">
                                                    <xsl:value-of select="concat('todo.', generate-id())"/>
                                                </xsl:attribute>
                                                <xsl:attribute name="role">Seitenzahl</xsl:attribute>
                                            </xsl:element>
                                        </d:entry>
                                        <d:entry>
                                            <xsl:value-of select="d:info/d:title"/>
                                        </d:entry>
                                        <d:entry>
                                            <xsl:apply-templates select="*[not(self::d:info)]"/>
                                        </d:entry>
                                        <d:entry>
                                            <xsl:value-of select="d:info/d:date"/>
                                        </d:entry>
                                        <d:entry>
                                            <xsl:value-of select="d:info/d:author"/>
                                        </d:entry>
                                    </d:row>
                                </xsl:for-each>
                            </d:tbody>
                        </d:tgroup>
                    </d:informaltable>
                </d:para>
            </xsl:element>
        </xsl:if>
    </xsl:template>
</xsl:stylesheet>
