<?xml version='1.0'?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:d="http://docbook.org/ns/docbook" xmlns:fo="http://www.w3.org/1999/XSL/Format"
	version="1.0">

	<!-- Template fuer die KoSIT Titelseite
		
		 Folgende Inhalte werden angezeigt:
		 
		 1. Projektlogo oben
		 Muss als mediaobject in book/info eingebunden sein.
		 Die Gr��e kann dort festgelegt werden.
		 
		 2. book/title oder book/info/title im mittleren Bereich
		 
		 3. (Fassung vom /book/info/pubdate) unter dem Titel
		 
		 4. /book/info/abstract unterhalb des Titelbereichs.
	-->
	<xsl:template match="d:abstract" mode="book.titlepage.recto.mode">
		<fo:block xsl:use-attribute-sets="abstract.properties">
			<xsl:apply-templates select="*[not(self::d:title)]" mode="titlepage.mode"/>
		</fo:block>
	</xsl:template>

	<xsl:template name="book.titlepage.verso">
		<!-- R�ckseite der Titelseite ist leer -->
	</xsl:template>

	<xsl:template name="book.titlepage.recto">
		<fo:table>
			<fo:table-column column-width="8cm"/>
			<fo:table-column column-width="8cm"/>
			<fo:table-body>
				<fo:table-row height="2cm">
					<fo:table-cell text-align="left" display-align="after">
						<fo:block>
							<fo:external-graphic text-align="left"
								src="../docbookzubehoer/stylesheets/custom/Logo_IT-Planungsrat.png"
								width="7cm" content-width="scale-to-fit"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell text-align="right">
						<fo:block>
							<fo:external-graphic text-align="right"
								src="../docbookzubehoer/stylesheets/custom/Logo_XOEV.png"
								width="5cm" content-width="scale-to-fit"/>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>

		<fo:block-container top="60.5mm" left="0mm" width="160mm" height="5mm" position="absolute">
			<fo:block border-top-style="solid" border-top-width="1pt" border-top-color="#C0C0C0"/>
		</fo:block-container>

		<fo:block-container top="65.5mm" left="0mm" width="160mm" height="108mm" position="absolute"
			text-align="center" font-family="Times New Roman" font-size="12pt"
			background-color="#CCCCCC" display-align="center" text-indent="5mm">
			<fo:block>
				<xsl:choose>
					<xsl:when test="d:info/d:title">
						<xsl:apply-templates mode="book.titlepage.recto.auto.mode"
							select="d:info/d:title"/>
					</xsl:when>
					<xsl:when test="d:title">
						<xsl:apply-templates mode="book.titlepage.recto.auto.mode" select="d:title"
						/>
					</xsl:when>
				</xsl:choose>
			</fo:block>
			<fo:block font-family="Times New Roman" font-size="24pt" font-style="italic"
				hyphenate="false" space-before="1cm">
				<xsl:choose>
					<xsl:when test="d:info/d:subtitle">
						<!-- <xsl:apply-templates 
							mode="book.titlepage.recto.auto.mode" 
							select="d:info/d:subtitle"/>
							-->
						<xsl:value-of select="d:info/d:subtitle"/>
					</xsl:when>
					<xsl:when test="d:subtitle">
						<xsl:apply-templates mode="book.titlepage.recto.auto.mode"
							select="d:subtitle"/>
					</xsl:when>
				</xsl:choose>
			</fo:block>
			<fo:block font-family="Arial" font-size="10pt" text-align="left" space-before="2cm">
				<xsl:choose>
					<xsl:when test="d:info/d:pubdate"> Fassung vom <xsl:value-of select="d:info/d:pubdate"/></xsl:when>
				</xsl:choose>
			</fo:block>
			<fo:block  font-family="Arial" font-size="10pt" text-align="left">
				<xsl:choose>
					<xsl:when test="d:info/d:author"><xsl:value-of select="d:info/d:author"/>
					</xsl:when>
				</xsl:choose>
			</fo:block>
			<fo:block  font-family="Arial" font-size="10pt" text-align="left">
				<xsl:apply-templates mode="book.titlepage.recto.auto.mode" select="d:info/d:abstract"/>
			</fo:block>
		</fo:block-container>
		
		<fo:block-container top="178.0mm" left="0mm" width="160mm" height="5mm" position="absolute">
			<fo:block border-top-style="solid" border-top-width="1pt" border-top-color="#C0C0C0"/>
		</fo:block-container>


	</xsl:template>
</xsl:stylesheet>
